/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.dosgi.discovery.zookeeper;

import java.io.IOException;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.logging.Logger;
import org.apache.cxf.dosgi.discovery.zookeeper.ZooKeeperDiscovery;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;

public class Activator
implements BundleActivator,
ManagedService {
    private static final Logger LOG = Logger.getLogger(Activator.class.getName());
    private ZooKeeperDiscovery zkd;
    private Dictionary zkProperties;
    private BundleContext bctx;
    ServiceRegistration cmReg;

    public synchronized void start(BundleContext bc) throws Exception {
        this.bctx = bc;
        this.zkProperties = this.getCMDefaults();
        this.zkd = this.createZooKeeperDiscovery();
        this.cmReg = bc.registerService(ManagedService.class.getName(), (Object)this, this.zkProperties);
    }

    public synchronized void stop(BundleContext bc) throws Exception {
        this.cmReg.unregister();
        this.zkd.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void updated(Dictionary configuration) throws ConfigurationException {
        LOG.info("Received configuration update for Zookeeper Discovery: " + configuration);
        if (configuration == null) {
            return;
        }
        Dictionary effective = this.getCMDefaults();
        Object e = configuration.keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            if (key == null) continue;
            Object val = configuration.get(key);
            effective.put(key, val);
        }
        if (this.zkProperties.equals(effective)) {
            LOG.info("properties haven't changed ...");
            return;
        }
        this.zkProperties = effective;
        this.cmReg.setProperties(this.zkProperties);
        e = this;
        synchronized (e) {
            this.zkd.stop();
            this.zkd = this.createZooKeeperDiscovery();
        }
        try {
            this.zkd.start();
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }

    private Dictionary getCMDefaults() {
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("zookeeper.timeout", "3000");
        ((Dictionary)props).put("zookeeper.port", "2181");
        ((Dictionary)props).put("service.pid", "org.apache.cxf.dosgi.discovery.zookeeper");
        return props;
    }

    protected ZooKeeperDiscovery createZooKeeperDiscovery() {
        return new ZooKeeperDiscovery(this.bctx, this.zkProperties);
    }
}

