/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.dosgi.discovery.zookeeper.server;

import java.io.File;
import java.io.IOException;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.apache.zookeeper.server.ServerConfig;
import org.apache.zookeeper.server.ZooKeeperServerMain;
import org.apache.zookeeper.server.quorum.QuorumPeerConfig;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationException;

public class ManagedService
implements org.osgi.service.cm.ManagedService {
    private static final Logger LOG = Logger.getLogger(ManagedService.class);
    private final BundleContext bundleContext;
    ServiceRegistration serviceRegistration;
    MyZooKeeperServerMain main;
    Thread zkMainThread;

    public ManagedService(BundleContext ctx) {
        this.bundleContext = ctx;
    }

    public synchronized void shutdown() {
        if (this.main != null) {
            LOG.info((Object)"Shutting down ZooKeeper server");
            this.main.shutdown();
            try {
                this.zkMainThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.main = null;
            this.zkMainThread = null;
        }
    }

    public void setDefaults(Dictionary dict) throws IOException {
        this.setDefault(dict, "tickTime", "2000");
        this.setDefault(dict, "initLimit", "10");
        this.setDefault(dict, "syncLimit", "5");
        this.setDefault(dict, "dataDir", new File(this.bundleContext.getDataFile(""), "zkdata").getCanonicalPath());
        this.setDefault(dict, "service.pid", "org.apache.cxf.dosgi.discovery.zookeeper.server");
    }

    private void setDefault(Dictionary dict, String key, String value) {
        if (dict.get(key) == null) {
            dict.put(key, value);
        }
    }

    public synchronized void updated(Dictionary dict) throws ConfigurationException {
        if (dict == null) {
            this.shutdown();
            return;
        }
        if (this.main != null) {
            this.shutdown();
        }
        if (dict.get("clientPort") == null) {
            LOG.info((Object)"Ignoring configuration update because required property 'clientPort' isn't set.");
            return;
        }
        Properties props = new Properties();
        Enumeration e = dict.keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            props.put(key, dict.get(key));
        }
        try {
            this.setDefaults(props);
            if (this.serviceRegistration != null) {
                this.serviceRegistration.setProperties((Dictionary)props);
            }
            QuorumPeerConfig config = new QuorumPeerConfig();
            config.parseProperties(props);
            final ServerConfig serverConfig = new ServerConfig();
            serverConfig.readFrom(config);
            this.main = this.getZooKeeperMain();
            this.zkMainThread = new Thread(new Runnable(){

                public void run() {
                    try {
                        ManagedService.this.main.runFromConfig(serverConfig);
                    }
                    catch (IOException e) {
                        LOG.error((Object)"Problem running ZooKeeper server.", (Throwable)e);
                    }
                }
            });
            this.startThread();
            LOG.info((Object)("Applied configuration update :" + props));
        }
        catch (Exception th) {
            LOG.error((Object)("Problem applying configuration update: " + props), (Throwable)th);
        }
    }

    void startThread() {
        this.zkMainThread.start();
    }

    MyZooKeeperServerMain getZooKeeperMain() {
        return new MyZooKeeperServerMain();
    }

    public void setRegistration(ServiceRegistration reg) {
        this.serviceRegistration = reg;
    }

    static class MyZooKeeperServerMain
    extends ZooKeeperServerMain {
        MyZooKeeperServerMain() {
        }

        protected void shutdown() {
            super.shutdown();
        }
    }
}

