/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.wss4j.policyvalidators;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.cxf.message.Message;
import org.apache.cxf.ws.policy.AssertionInfo;
import org.apache.cxf.ws.policy.AssertionInfoMap;
import org.apache.cxf.ws.security.wss4j.policyvalidators.AbstractTokenPolicyValidator;
import org.apache.cxf.ws.security.wss4j.policyvalidators.TokenPolicyValidator;
import org.apache.wss4j.dom.WSSecurityEngineResult;
import org.apache.wss4j.dom.util.WSSecurityUtil;
import org.apache.wss4j.policy.SP13Constants;
import org.apache.wss4j.policy.model.AbstractSecurityAssertion;
import org.apache.wss4j.policy.model.AbstractToken;
import org.apache.wss4j.policy.model.SupportingTokens;
import org.apache.wss4j.policy.model.UsernameToken;
import org.w3c.dom.Element;

public class UsernameTokenPolicyValidator
extends AbstractTokenPolicyValidator
implements TokenPolicyValidator {
    @Override
    public boolean validatePolicy(AssertionInfoMap aim, Message message, Element soapBody, List<WSSecurityEngineResult> results, List<WSSecurityEngineResult> signedResults) {
        Collection<AssertionInfo> ais = this.getAllAssertionsByLocalname(aim, "UsernameToken");
        if (!ais.isEmpty()) {
            this.parsePolicies(ais, message, results);
            this.assertPolicy(aim, SP13Constants.CREATED);
            this.assertPolicy(aim, SP13Constants.NONCE);
            this.assertPolicy(aim, "NoPassword");
            this.assertPolicy(aim, "HashPassword");
            this.assertPolicy(aim, "WssUsernameToken10");
            this.assertPolicy(aim, "WssUsernameToken11");
        }
        return true;
    }

    private void parsePolicies(Collection<AssertionInfo> ais, Message message, List<WSSecurityEngineResult> results) {
        ArrayList<Integer> actions = new ArrayList<Integer>(2);
        actions.add(1);
        actions.add(8192);
        List utResults = WSSecurityUtil.fetchAllActionResults(results, actions);
        for (AssertionInfo ai : ais) {
            UsernameToken usernameTokenPolicy = (UsernameToken)ai.getAssertion();
            ai.setAsserted(true);
            if (!this.isTokenRequired((AbstractToken)usernameTokenPolicy, message)) continue;
            if (utResults.isEmpty()) {
                ai.setNotAsserted("The received token does not match the token inclusion requirement");
                continue;
            }
            if (this.checkTokens(usernameTokenPolicy, ai, utResults)) continue;
        }
    }

    public boolean checkTokens(UsernameToken usernameTokenPolicy, AssertionInfo ai, List<WSSecurityEngineResult> utResults) {
        for (WSSecurityEngineResult result : utResults) {
            boolean isNoPassword;
            org.apache.wss4j.dom.message.token.UsernameToken usernameToken = (org.apache.wss4j.dom.message.token.UsernameToken)result.get((Object)"username-token");
            UsernameToken.PasswordType passwordType = usernameTokenPolicy.getPasswordType();
            boolean isHashPassword = passwordType == UsernameToken.PasswordType.HashPassword;
            boolean bl = isNoPassword = passwordType == UsernameToken.PasswordType.NoPassword;
            if (isHashPassword != usernameToken.isHashed()) {
                ai.setNotAsserted("Password hashing policy not enforced");
                return false;
            }
            if (isNoPassword && usernameToken.getPassword() != null) {
                ai.setNotAsserted("Username Token NoPassword policy not enforced");
                return false;
            }
            if (!isNoPassword && usernameToken.getPassword() == null && this.isNonEndorsingSupportingToken(usernameTokenPolicy)) {
                ai.setNotAsserted("Username Token No Password supplied");
                return false;
            }
            if (usernameTokenPolicy.isCreated() && (usernameToken.getCreated() == null || usernameToken.isHashed())) {
                ai.setNotAsserted("Username Token Created policy not enforced");
                return false;
            }
            if (!usernameTokenPolicy.isNonce() || usernameToken.getNonce() != null && !usernameToken.isHashed()) continue;
            ai.setNotAsserted("Username Token Nonce policy not enforced");
            return false;
        }
        return true;
    }

    private boolean isNonEndorsingSupportingToken(UsernameToken usernameTokenPolicy) {
        SupportingTokens supportingToken;
        String localname;
        AbstractSecurityAssertion parentAssertion = usernameTokenPolicy.getParentAssertion();
        return parentAssertion instanceof SupportingTokens && ((localname = (supportingToken = (SupportingTokens)parentAssertion).getName().getLocalPart()).equals("SupportingTokens") || localname.equals("SignedSupportingTokens") || localname.equals("EncryptedSupportingTokens") || localname.equals("SignedEncryptedSupportingTokens"));
    }
}

