/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.tokenstore;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.ws.security.tokenstore.SecurityToken;
import org.apache.cxf.ws.security.tokenstore.TokenStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemoryTokenStore
implements TokenStore {
    public static final long DEFAULT_TTL = 300L;
    public static final long MAX_TTL = 3600L;
    private Map<String, CacheEntry> tokens = new ConcurrentHashMap<String, CacheEntry>();

    @Override
    public void add(SecurityToken token) {
        CacheEntry cacheEntry;
        if (token != null && !StringUtils.isEmpty((String)token.getId()) && (cacheEntry = this.createCacheEntry(token)) != null) {
            this.tokens.put(token.getId(), cacheEntry);
        }
    }

    @Override
    public void add(String identifier, SecurityToken token) {
        CacheEntry cacheEntry;
        if (token != null && !StringUtils.isEmpty((String)identifier) && (cacheEntry = this.createCacheEntry(token)) != null) {
            this.tokens.put(identifier, cacheEntry);
        }
    }

    @Override
    public void remove(String identifier) {
        if (!StringUtils.isEmpty((String)identifier) && this.tokens.containsKey(identifier)) {
            this.tokens.remove(identifier);
        }
    }

    @Override
    public Collection<String> getTokenIdentifiers() {
        this.processTokenExpiry();
        return this.tokens.keySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<SecurityToken> getExpiredTokens() {
        ArrayList<SecurityToken> expiredTokens = new ArrayList<SecurityToken>();
        Date current = new Date();
        Map<String, CacheEntry> map = this.tokens;
        synchronized (map) {
            for (String id : this.tokens.keySet()) {
                CacheEntry cacheEntry = this.tokens.get(id);
                if (!cacheEntry.getExpiry().before(current)) continue;
                expiredTokens.add(cacheEntry.getSecurityToken());
            }
        }
        return expiredTokens;
    }

    @Override
    public SecurityToken getToken(String id) {
        this.processTokenExpiry();
        CacheEntry cacheEntry = this.tokens.get(id);
        if (cacheEntry != null) {
            return cacheEntry.getSecurityToken();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processTokenExpiry() {
        Date current = new Date();
        Map<String, CacheEntry> map = this.tokens;
        synchronized (map) {
            for (String id : this.tokens.keySet()) {
                CacheEntry cacheEntry = this.tokens.get(id);
                if (!cacheEntry.getExpiry().before(current)) continue;
                this.tokens.remove(id);
            }
        }
    }

    private CacheEntry createCacheEntry(SecurityToken token) {
        CacheEntry cacheEntry = null;
        if (token.getExpires() == null) {
            Date expires = new Date();
            long currentTime = expires.getTime();
            expires.setTime(currentTime + 300000L);
            cacheEntry = new CacheEntry(token, expires);
        } else {
            Date expires = token.getExpires();
            Date current = new Date();
            long expiryTime = expires.getTime() - current.getTime();
            if (expiryTime < 0L) {
                return null;
            }
            if (expiryTime > 3600000L) {
                expires.setTime(current.getTime() + 300000L);
            }
            cacheEntry = new CacheEntry(token, expires);
        }
        return cacheEntry;
    }

    private static class CacheEntry {
        private final SecurityToken securityToken;
        private final Date expires;

        public CacheEntry(SecurityToken securityToken, Date expires) {
            this.securityToken = securityToken;
            this.expires = expires;
        }

        public SecurityToken getSecurityToken() {
            return this.securityToken;
        }

        public Date getExpiry() {
            return this.expires;
        }
    }
}

