/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.policy.builders;

import javax.xml.namespace.QName;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.ws.policy.PolicyBuilder;
import org.apache.cxf.ws.policy.PolicyConstants;
import org.apache.cxf.ws.security.policy.SP11Constants;
import org.apache.cxf.ws.security.policy.SP12Constants;
import org.apache.cxf.ws.security.policy.SPConstants;
import org.apache.cxf.ws.security.policy.model.KerberosToken;
import org.apache.neethi.Assertion;
import org.apache.neethi.AssertionBuilderFactory;
import org.apache.neethi.builders.AssertionBuilder;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KerberosTokenBuilder
implements AssertionBuilder<Element> {
    PolicyBuilder builder;

    public KerberosTokenBuilder(PolicyBuilder b) {
        this.builder = b;
    }

    public Assertion build(Element element, AssertionBuilderFactory factory) {
        SPConstants consts = "http://schemas.xmlsoap.org/ws/2005/07/securitypolicy".equals(element.getNamespaceURI()) ? SP11Constants.INSTANCE : SP12Constants.INSTANCE;
        KerberosToken kerberosToken = new KerberosToken(consts);
        kerberosToken.setOptional(PolicyConstants.isOptional((Element)element));
        kerberosToken.setIgnorable(PolicyConstants.isIgnorable((Element)element));
        String attribute = element.getAttributeNS(element.getNamespaceURI(), "IncludeToken");
        if (attribute != null) {
            kerberosToken.setInclusion(consts.getInclusionFromAttributeValue(attribute.trim()));
        }
        Element child = DOMUtils.getFirstElement((Node)element);
        boolean foundPolicy = false;
        while (child != null) {
            String ln = child.getLocalName();
            if ("Policy".equals(ln)) {
                foundPolicy = true;
                NodeList policyChildren = child.getChildNodes();
                if (policyChildren != null) {
                    for (int i = 0; i < policyChildren.getLength(); ++i) {
                        Node policyChild = policyChildren.item(i);
                        if (!(policyChild instanceof Element)) continue;
                        QName qname = new QName(policyChild.getNamespaceURI(), policyChild.getLocalName());
                        String localpart = qname.getLocalPart();
                        if ("WssKerberosV5ApReqToken11".equals(localpart)) {
                            kerberosToken.setV5ApReqToken11(true);
                            continue;
                        }
                        if ("WssGssKerberosV5ApReqToken11".equals(localpart)) {
                            kerberosToken.setGssV5ApReqToken11(true);
                            continue;
                        }
                        if (!"RequireDerivedKeys".equals(localpart)) continue;
                        kerberosToken.setDerivedKeys(true);
                    }
                }
            }
            child = DOMUtils.getNextElement((Element)child);
        }
        if (!foundPolicy && consts != SP11Constants.INSTANCE) {
            throw new IllegalArgumentException("sp:KerberosToken/wsp:Policy must have a value");
        }
        return kerberosToken;
    }

    public QName[] getKnownElements() {
        return new QName[]{SP11Constants.KERBEROS_TOKEN, SP12Constants.KERBEROS_TOKEN};
    }
}

