/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rt.security.saml.xacml;

import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.rt.security.saml.xacml.AbstractXACMLAuthorizingInterceptor;
import org.apache.cxf.rt.security.saml.xacml.pdp.api.PolicyDecisionPoint;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.saml.OpenSAMLUtil;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.xacml.ctx.RequestType;
import org.opensaml.xacml.ctx.ResponseType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XACMLAuthorizingInterceptor
extends AbstractXACMLAuthorizingInterceptor {
    private PolicyDecisionPoint pdp;

    public XACMLAuthorizingInterceptor(PolicyDecisionPoint pdp) {
        this.pdp = pdp;
    }

    @Override
    public ResponseType performRequest(RequestType request, Message message) throws Exception {
        Source requestSource = this.requestType2Source(request);
        Source responseSource = this.pdp.evaluate(requestSource);
        return this.responseSourceToResponseType(responseSource);
    }

    private Source requestType2Source(RequestType request) {
        Element requestElement;
        Document doc = DOMUtils.createDocument();
        try {
            requestElement = OpenSAMLUtil.toDom((XMLObject)request, (Document)doc);
        }
        catch (WSSecurityException e) {
            throw new RuntimeException("Error converting PDP RequestType to Dom", e);
        }
        return new DOMSource(requestElement);
    }

    private ResponseType responseSourceToResponseType(Source responseSource) {
        try {
            Transformer trans = TransformerFactory.newInstance().newTransformer();
            DOMResult res = new DOMResult();
            trans.transform(responseSource, res);
            Node nd = res.getNode();
            if (nd instanceof Document) {
                nd = ((Document)nd).getDocumentElement();
            }
            return (ResponseType)OpenSAMLUtil.fromDom((Element)((Element)nd));
        }
        catch (Exception e) {
            throw new RuntimeException("Error converting pdp response to ResponseType", e);
        }
    }
}

