/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.saml.sso;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.security.Key;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.security.auth.callback.CallbackHandler;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.Base64Exception;
import org.apache.cxf.common.util.Base64Utility;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.rs.security.common.SecurityUtils;
import org.apache.cxf.rs.security.xml.EncryptionUtils;
import org.apache.ws.security.WSDocInfo;
import org.apache.ws.security.WSSConfig;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.handler.RequestData;
import org.apache.ws.security.saml.SAMLKeyInfo;
import org.apache.ws.security.saml.SAMLUtil;
import org.apache.ws.security.saml.ext.AssertionWrapper;
import org.apache.ws.security.util.WSSecurityUtil;
import org.apache.ws.security.validate.Credential;
import org.apache.ws.security.validate.SamlAssertionValidator;
import org.apache.ws.security.validate.SignatureTrustValidator;
import org.apache.ws.security.validate.Validator;
import org.apache.xml.security.encryption.XMLCipher;
import org.apache.xml.security.encryption.XMLEncryptionException;
import org.opensaml.Configuration;
import org.opensaml.saml1.core.Response;
import org.opensaml.saml2.core.Assertion;
import org.opensaml.saml2.core.EncryptedAssertion;
import org.opensaml.security.SAMLSignatureProfileValidator;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.encryption.EncryptedData;
import org.opensaml.xml.security.x509.BasicX509Credential;
import org.opensaml.xml.signature.KeyInfo;
import org.opensaml.xml.signature.Signature;
import org.opensaml.xml.signature.SignatureValidator;
import org.opensaml.xml.validation.ValidationException;
import org.opensaml.xml.validation.ValidatorSuite;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class SAMLProtocolResponseValidator {
    public static final String SAML2_STATUSCODE_SUCCESS = "urn:oasis:names:tc:SAML:2.0:status:Success";
    public static final String SAML1_STATUSCODE_SUCCESS = "Success";
    private static final Logger LOG = LogUtils.getL7dLogger(SAMLProtocolResponseValidator.class);
    private Validator assertionValidator = new SamlAssertionValidator();
    private Validator signatureValidator = new SignatureTrustValidator();

    public void validateSamlResponse(org.opensaml.saml2.core.Response samlResponse, Crypto sigCrypto, CallbackHandler callbackHandler) throws WSSecurityException {
        if (samlResponse.getStatus() == null || samlResponse.getStatus().getStatusCode() == null) {
            LOG.fine("Either the SAML Response Status or StatusCode is null");
            throw new WSSecurityException(0, "invalidSAMLsecurity");
        }
        if (!SAML2_STATUSCODE_SUCCESS.equals(samlResponse.getStatus().getStatusCode().getValue())) {
            LOG.fine("SAML Status code of " + samlResponse.getStatus().getStatusCode().getValue() + "does not equal " + SAML2_STATUSCODE_SUCCESS);
            throw new WSSecurityException(0, "invalidSAMLsecurity");
        }
        this.validateResponseAgainstSchemas(samlResponse);
        this.validateResponseSignature(samlResponse, sigCrypto, callbackHandler);
        Document doc = samlResponse.getDOM().getOwnerDocument();
        for (EncryptedAssertion assertion : samlResponse.getEncryptedAssertions()) {
            EncryptedData encryptedData = assertion.getEncryptedData();
            Element encryptedDataDOM = encryptedData.getDOM();
            Element decAssertion = this.decryptAssertion(encryptedDataDOM, sigCrypto, callbackHandler);
            AssertionWrapper wrapper = new AssertionWrapper(decAssertion);
            samlResponse.getAssertions().add(wrapper.getSaml2());
        }
        for (EncryptedAssertion assertion : samlResponse.getAssertions()) {
            AssertionWrapper wrapper = new AssertionWrapper((Assertion)assertion);
            this.validateAssertion(wrapper, sigCrypto, callbackHandler, doc);
        }
    }

    public void validateSamlResponse(Response samlResponse, Crypto sigCrypto, CallbackHandler callbackHandler) throws WSSecurityException {
        if (samlResponse.getStatus() == null || samlResponse.getStatus().getStatusCode() == null || samlResponse.getStatus().getStatusCode().getValue() == null) {
            LOG.fine("Either the SAML Response Status or StatusCode is null");
            throw new WSSecurityException(0, "invalidSAMLsecurity");
        }
        String statusValue = samlResponse.getStatus().getStatusCode().getValue().getLocalPart();
        if (!SAML1_STATUSCODE_SUCCESS.equals(statusValue)) {
            LOG.fine("SAML Status code of " + samlResponse.getStatus().getStatusCode().getValue() + "does not equal " + SAML1_STATUSCODE_SUCCESS);
            throw new WSSecurityException(0, "invalidSAMLsecurity");
        }
        this.validateResponseAgainstSchemas(samlResponse);
        this.validateResponseSignature(samlResponse, sigCrypto, callbackHandler);
        for (org.opensaml.saml1.core.Assertion assertion : samlResponse.getAssertions()) {
            AssertionWrapper wrapper = new AssertionWrapper(assertion);
            this.validateAssertion(wrapper, sigCrypto, callbackHandler, samlResponse.getDOM().getOwnerDocument());
        }
    }

    private void validateResponseAgainstSchemas(org.opensaml.saml2.core.Response samlResponse) throws WSSecurityException {
        ValidatorSuite schemaValidators = Configuration.getValidatorSuite((String)"saml2-core-schema-validator");
        try {
            schemaValidators.validate((XMLObject)samlResponse);
        }
        catch (ValidationException e) {
            LOG.log(Level.FINE, "Saml Validation error: " + e.getMessage(), e);
            throw new WSSecurityException(0, "invalidSAMLsecurity");
        }
    }

    private void validateResponseAgainstSchemas(Response samlResponse) throws WSSecurityException {
        ValidatorSuite schemaValidators = Configuration.getValidatorSuite((String)"saml1-core-schema-validator");
        try {
            schemaValidators.validate((XMLObject)samlResponse);
        }
        catch (ValidationException e) {
            LOG.log(Level.FINE, "Saml Validation error: " + e.getMessage(), e);
            throw new WSSecurityException(0, "invalidSAMLsecurity");
        }
    }

    private void validateResponseSignature(org.opensaml.saml2.core.Response samlResponse, Crypto sigCrypto, CallbackHandler callbackHandler) throws WSSecurityException {
        if (!samlResponse.isSigned()) {
            return;
        }
        this.validateResponseSignature(samlResponse.getSignature(), samlResponse.getDOM().getOwnerDocument(), sigCrypto, callbackHandler);
    }

    private void validateResponseSignature(Response samlResponse, Crypto sigCrypto, CallbackHandler callbackHandler) throws WSSecurityException {
        if (!samlResponse.isSigned()) {
            return;
        }
        this.validateResponseSignature(samlResponse.getSignature(), samlResponse.getDOM().getOwnerDocument(), sigCrypto, callbackHandler);
    }

    private void validateResponseSignature(Signature signature, Document doc, Crypto sigCrypto, CallbackHandler callbackHandler) throws WSSecurityException {
        RequestData requestData = new RequestData();
        requestData.setSigCrypto(sigCrypto);
        WSSConfig wssConfig = WSSConfig.getNewInstance();
        requestData.setWssConfig(wssConfig);
        requestData.setCallbackHandler(callbackHandler);
        WSDocInfo docInfo = new WSDocInfo(doc);
        KeyInfo keyInfo = signature.getKeyInfo();
        SAMLKeyInfo samlKeyInfo = null;
        try {
            samlKeyInfo = SAMLUtil.getCredentialFromKeyInfo((Element)keyInfo.getDOM(), (RequestData)requestData, (WSDocInfo)docInfo, (boolean)requestData.getWssConfig().isWsiBSPCompliant());
        }
        catch (WSSecurityException ex) {
            LOG.log(Level.FINE, "Error in getting KeyInfo from SAML Response: " + ex.getMessage(), ex);
            throw ex;
        }
        if (samlKeyInfo == null) {
            LOG.fine("No KeyInfo supplied in the SAMLResponse signature");
            throw new WSSecurityException(0, "invalidSAMLsecurity");
        }
        this.validateSignatureAgainstProfiles(signature, samlKeyInfo);
        Credential trustCredential = new Credential();
        trustCredential.setPublicKey(samlKeyInfo.getPublicKey());
        trustCredential.setCertificates(samlKeyInfo.getCerts());
        try {
            this.signatureValidator.validate(trustCredential, requestData);
        }
        catch (WSSecurityException e) {
            LOG.log(Level.FINE, "Error in validating signature on SAML Response: " + e.getMessage(), e);
            throw new WSSecurityException(0, "invalidSAMLsecurity");
        }
    }

    private void validateSignatureAgainstProfiles(Signature signature, SAMLKeyInfo samlKeyInfo) throws WSSecurityException {
        SAMLSignatureProfileValidator validator = new SAMLSignatureProfileValidator();
        try {
            validator.validate(signature);
        }
        catch (ValidationException ex) {
            LOG.log(Level.FINE, "Error in validating the SAML Signature: " + ex.getMessage(), ex);
            throw new WSSecurityException(0, "invalidSAMLsecurity");
        }
        BasicX509Credential credential = new BasicX509Credential();
        if (samlKeyInfo.getCerts() != null) {
            credential.setEntityCertificate(samlKeyInfo.getCerts()[0]);
        } else if (samlKeyInfo.getPublicKey() != null) {
            credential.setPublicKey(samlKeyInfo.getPublicKey());
        } else {
            LOG.fine("Can't get X509Certificate or PublicKey to verify signature");
            throw new WSSecurityException(0, "invalidSAMLsecurity");
        }
        SignatureValidator sigValidator = new SignatureValidator((org.opensaml.xml.security.credential.Credential)credential);
        try {
            sigValidator.validate(signature);
        }
        catch (ValidationException ex) {
            LOG.log(Level.FINE, "Error in validating the SAML Signature: " + ex.getMessage(), ex);
            throw new WSSecurityException(0, "invalidSAMLsecurity");
        }
    }

    private void validateAssertion(AssertionWrapper assertion, Crypto sigCrypto, CallbackHandler callbackHandler, Document doc) throws WSSecurityException {
        Credential credential = new Credential();
        credential.setAssertion(assertion);
        RequestData requestData = new RequestData();
        requestData.setSigCrypto(sigCrypto);
        WSSConfig wssConfig = WSSConfig.getNewInstance();
        requestData.setWssConfig(wssConfig);
        requestData.setCallbackHandler(callbackHandler);
        if (assertion.isSigned()) {
            if (assertion.getSaml1() != null) {
                assertion.getSaml1().getDOM().setIdAttributeNS(null, "AssertionID", true);
            } else {
                assertion.getSaml2().getDOM().setIdAttributeNS(null, "ID", true);
            }
            try {
                assertion.verifySignature(requestData, new WSDocInfo(doc));
            }
            catch (WSSecurityException e) {
                e.printStackTrace();
                LOG.log(Level.FINE, "Assertion failed signature validation", e);
                throw new WSSecurityException(0, "invalidSAMLsecurity");
            }
        }
        try {
            this.assertionValidator.validate(credential, requestData);
        }
        catch (WSSecurityException ex) {
            LOG.log(Level.FINE, "Assertion validation failed: " + ex.getMessage(), ex);
            throw new WSSecurityException(0, "invalidSAMLsecurity");
        }
    }

    private Element decryptAssertion(Element encryptedDataDOM, Crypto sigCrypto, CallbackHandler callbackHandler) throws WSSecurityException {
        Element encKeyElement = this.getNode(encryptedDataDOM, "http://www.w3.org/2001/04/xmlenc#", "EncryptedKey", 0);
        if (encKeyElement == null) {
            LOG.log(Level.FINE, "EncryptedKey element is not available");
            throw new WSSecurityException(0, "invalidSAMLsecurity");
        }
        X509Certificate cert = this.loadCertificate(sigCrypto, encKeyElement);
        if (cert == null) {
            LOG.fine("X509Certificate cannot be retrieved from EncryptedKey element");
            throw new WSSecurityException(0, "invalidSAMLsecurity");
        }
        String keyEncAlgo = this.getEncodingMethodAlgorithm(encKeyElement);
        String digestAlgo = this.getDigestMethodAlgorithm(encKeyElement);
        Element cipherValue = this.getNode(encKeyElement, "http://www.w3.org/2001/04/xmlenc#", "CipherValue", 0);
        if (cipherValue == null) {
            LOG.fine("CipherValue element is not available");
            throw new WSSecurityException(0, "invalidSAMLsecurity");
        }
        if (callbackHandler == null) {
            LOG.fine("A CallbackHandler must be configured to decrypt encrypted Assertions");
            throw new WSSecurityException(0, "invalidSAMLsecurity");
        }
        PrivateKey key = null;
        try {
            key = sigCrypto.getPrivateKey(cert, callbackHandler);
        }
        catch (Exception ex) {
            LOG.log(Level.FINE, "Encrypted key can not be decrypted", ex);
            throw new WSSecurityException(0, "invalidSAMLsecurity");
        }
        Cipher cipher = EncryptionUtils.initCipherWithKey((String)keyEncAlgo, (String)digestAlgo, (int)2, (Key)key);
        byte[] decryptedBytes = null;
        try {
            byte[] encryptedBytes = Base64Utility.decode((String)cipherValue.getTextContent().trim());
            decryptedBytes = cipher.doFinal(encryptedBytes);
        }
        catch (Base64Exception ex) {
            LOG.log(Level.FINE, "Base64 decoding has failed", ex);
            throw new WSSecurityException(0, "invalidSAMLsecurity");
        }
        catch (Exception ex) {
            LOG.log(Level.FINE, "Encrypted key can not be decrypted", ex);
            throw new WSSecurityException(0, "invalidSAMLsecurity");
        }
        String symKeyAlgo = this.getEncodingMethodAlgorithm(encryptedDataDOM);
        byte[] decryptedPayload = null;
        try {
            decryptedPayload = this.decryptPayload(encryptedDataDOM, decryptedBytes, symKeyAlgo);
        }
        catch (Exception ex) {
            LOG.log(Level.FINE, "Payload can not be decrypted", ex);
            throw new WSSecurityException(0, "invalidSAMLsecurity");
        }
        Document payloadDoc = null;
        try {
            payloadDoc = DOMUtils.readXml((Reader)new InputStreamReader((InputStream)new ByteArrayInputStream(decryptedPayload), "UTF-8"));
            return payloadDoc.getDocumentElement();
        }
        catch (Exception ex) {
            LOG.log(Level.FINE, "Payload document can not be created", ex);
            throw new WSSecurityException(0, "invalidSAMLsecurity");
        }
    }

    private Element getNode(Element parent, String ns, String name, int index) {
        NodeList list = parent.getElementsByTagNameNS(ns, name);
        if (list != null && list.getLength() >= index + 1) {
            return (Element)list.item(index);
        }
        return null;
    }

    private X509Certificate loadCertificate(Crypto crypto, Element encKeyElement) throws WSSecurityException {
        Element certNode = this.getNode(encKeyElement, "http://www.w3.org/2000/09/xmldsig#", "X509Certificate", 0);
        if (certNode != null) {
            try {
                return SecurityUtils.loadX509Certificate((Crypto)crypto, (Element)certNode);
            }
            catch (Exception ex) {
                LOG.log(Level.FINE, "X509Certificate can not be created", ex);
                throw new WSSecurityException(0, "invalidSAMLsecurity");
            }
        }
        certNode = this.getNode(encKeyElement, "http://www.w3.org/2000/09/xmldsig#", "X509IssuerSerial", 0);
        if (certNode != null) {
            try {
                return SecurityUtils.loadX509IssuerSerial((Crypto)crypto, (Element)certNode);
            }
            catch (Exception ex) {
                LOG.log(Level.FINE, "X509Certificate can not be created", ex);
                throw new WSSecurityException(0, "invalidSAMLsecurity");
            }
        }
        return null;
    }

    private String getEncodingMethodAlgorithm(Element parent) throws WSSecurityException {
        Element encMethod = this.getNode(parent, "http://www.w3.org/2001/04/xmlenc#", "EncryptionMethod", 0);
        if (encMethod == null) {
            LOG.fine("EncryptionMethod element is not available");
            throw new WSSecurityException(0, "invalidSAMLsecurity");
        }
        return encMethod.getAttribute("Algorithm");
    }

    private String getDigestMethodAlgorithm(Element parent) {
        Element digestMethod;
        Element encMethod = this.getNode(parent, "http://www.w3.org/2001/04/xmlenc#", "EncryptionMethod", 0);
        if (encMethod != null && (digestMethod = this.getNode(encMethod, "http://www.w3.org/2000/09/xmldsig#", "DigestMethod", 0)) != null) {
            return digestMethod.getAttributeNS(null, "Algorithm");
        }
        return null;
    }

    private byte[] decryptPayload(Element root, byte[] secretKeyBytes, String symEncAlgo) throws WSSecurityException {
        SecretKey key = WSSecurityUtil.prepareSecretKey((String)symEncAlgo, (byte[])secretKeyBytes);
        try {
            XMLCipher xmlCipher = EncryptionUtils.initXMLCipher((String)symEncAlgo, (int)2, (Key)key);
            return xmlCipher.decryptToByteArray(root);
        }
        catch (XMLEncryptionException ex) {
            throw new WSSecurityException(2, null, null, (Throwable)ex);
        }
    }
}

