/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.saml.sso;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.Date;
import java.util.ResourceBundle;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.DataFormatException;
import javax.annotation.PreDestroy;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.cxf.Bus;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.Base64Exception;
import org.apache.cxf.common.util.Base64Utility;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.jaxrs.ext.MessageContext;
import org.apache.cxf.rs.security.saml.DeflateEncoderDecoder;
import org.apache.cxf.rs.security.saml.sso.AbstractSSOSpHandler;
import org.apache.cxf.rs.security.saml.sso.EHCacheTokenReplayCache;
import org.apache.cxf.rs.security.saml.sso.SAMLProtocolResponseValidator;
import org.apache.cxf.rs.security.saml.sso.SAMLSSOResponseValidator;
import org.apache.cxf.rs.security.saml.sso.SSOValidatorResponse;
import org.apache.cxf.rs.security.saml.sso.TokenReplayCache;
import org.apache.cxf.rs.security.saml.sso.state.RequestState;
import org.apache.cxf.rs.security.saml.sso.state.ResponseState;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.saml.ext.OpenSAMLUtil;
import org.apache.ws.security.util.DOM2Writer;
import org.opensaml.xml.XMLObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Path(value="sso")
public class RequestAssertionConsumerService
extends AbstractSSOSpHandler {
    private static final Logger LOG = LogUtils.getL7dLogger(RequestAssertionConsumerService.class);
    private static final ResourceBundle BUNDLE = BundleUtils.getBundle(RequestAssertionConsumerService.class);
    private boolean supportDeflateEncoding = true;
    private boolean supportBase64Encoding = true;
    private boolean enforceAssertionsSigned = true;
    private boolean enforceKnownIssuer = true;
    private TokenReplayCache<String> replayCache;
    private MessageContext messageContext;

    @Context
    public void setMessageContext(MessageContext mc) {
        this.messageContext = mc;
    }

    public void setSupportDeflateEncoding(boolean deflate) {
        this.supportDeflateEncoding = deflate;
    }

    public boolean isSupportDeflateEncoding() {
        return this.supportDeflateEncoding;
    }

    public void setReplayCache(TokenReplayCache<String> replayCache) {
        this.replayCache = replayCache;
    }

    public TokenReplayCache<String> getReplayCache() {
        if (this.replayCache == null) {
            Bus bus = (Bus)this.messageContext.getContextualProperty((Object)Bus.class.getName());
            this.replayCache = new EHCacheTokenReplayCache(bus);
        }
        return this.replayCache;
    }

    public void setEnforceAssertionsSigned(boolean enforceAssertionsSigned) {
        this.enforceAssertionsSigned = enforceAssertionsSigned;
    }

    public void setEnforceKnownIssuer(boolean enforceKnownIssuer) {
        this.enforceKnownIssuer = enforceKnownIssuer;
    }

    public void setSupportBase64Encoding(boolean supportBase64Encoding) {
        this.supportBase64Encoding = supportBase64Encoding;
    }

    public boolean isSupportBase64Encoding() {
        return this.supportBase64Encoding;
    }

    @POST
    @Produces(value={"application/x-www-form-urlencoded"})
    public Response processSamlResponse(@FormParam(value="SAMLResponse") String encodedSamlResponse, @FormParam(value="RelayState") String relayState) {
        return this.doProcessSamlResponse(encodedSamlResponse, relayState, true);
    }

    @GET
    public Response getSamlResponse(@QueryParam(value="SAMLResponse") String encodedSamlResponse, @QueryParam(value="RelayState") String relayState) {
        return this.doProcessSamlResponse(encodedSamlResponse, relayState, false);
    }

    @Override
    @PreDestroy
    public void close() throws IOException {
        if (this.replayCache != null) {
            this.replayCache.close();
        }
        super.close();
    }

    protected Response doProcessSamlResponse(String encodedSamlResponse, String relayState, boolean postBinding) {
        RequestState requestState = this.processRelayState(relayState);
        URI targetURI = this.getTargetURI(requestState.getTargetAddress());
        org.opensaml.saml2.core.Response samlResponse = this.readSAMLResponse(postBinding, encodedSamlResponse);
        this.validateSamlResponseProtocol(samlResponse);
        SSOValidatorResponse validatorResponse = this.validateSamlSSOResponse(postBinding, samlResponse, requestState);
        String securityContextKey = UUID.randomUUID().toString();
        long currentTime = System.currentTimeMillis();
        Date notOnOrAfter = validatorResponse.getSessionNotOnOrAfter();
        long expiresAt = 0L;
        expiresAt = notOnOrAfter != null ? notOnOrAfter.getTime() : currentTime + this.getStateTimeToLive();
        ResponseState responseState = new ResponseState(validatorResponse.getAssertion(), relayState, requestState.getWebAppContext(), requestState.getWebAppDomain(), currentTime, expiresAt);
        this.getStateProvider().setResponseState(securityContextKey, responseState);
        String contextCookie = this.createCookie("org.apache.cxf.websso.context", securityContextKey, requestState.getWebAppContext(), requestState.getWebAppDomain());
        return Response.seeOther((URI)targetURI).header("Set-Cookie", (Object)contextCookie).build();
    }

    private RequestState processRelayState(String relayState) {
        if (relayState == null) {
            this.reportError("MISSING_RELAY_STATE");
            throw new BadRequestException();
        }
        if (relayState.getBytes().length < 0 || relayState.getBytes().length > 80) {
            this.reportError("INVALID_RELAY_STATE");
            throw new BadRequestException();
        }
        RequestState requestState = this.getStateProvider().removeRequestState(relayState);
        if (requestState == null) {
            this.reportError("MISSING_REQUEST_STATE");
            throw new WebApplicationException(400);
        }
        if (this.isStateExpired(requestState.getCreatedAt(), 0L)) {
            this.reportError("EXPIRED_REQUEST_STATE");
            throw new BadRequestException();
        }
        return requestState;
    }

    private org.opensaml.saml2.core.Response readSAMLResponse(boolean postBinding, String samlResponse) {
        if (StringUtils.isEmpty((String)samlResponse)) {
            this.reportError("MISSING_SAML_RESPONSE");
            throw new BadRequestException();
        }
        String samlResponseDecoded = samlResponse;
        ByteArrayInputStream tokenStream = null;
        if (this.isSupportBase64Encoding()) {
            try {
                byte[] deflatedToken = Base64Utility.decode((String)samlResponseDecoded);
                tokenStream = !postBinding && this.isSupportDeflateEncoding() ? new DeflateEncoderDecoder().inflateToken(deflatedToken) : new ByteArrayInputStream(deflatedToken);
            }
            catch (Base64Exception ex) {
                throw new BadRequestException((Throwable)ex);
            }
            catch (DataFormatException ex) {
                throw new BadRequestException((Throwable)ex);
            }
        }
        try {
            tokenStream = new ByteArrayInputStream(samlResponseDecoded.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException ex) {
            throw new BadRequestException((Throwable)ex);
        }
        Document responseDoc = null;
        try {
            responseDoc = DOMUtils.readXml((Reader)new InputStreamReader((InputStream)tokenStream, "UTF-8"));
        }
        catch (Exception ex) {
            throw new WebApplicationException(400);
        }
        LOG.fine("Received response: " + DOM2Writer.nodeToString((Node)responseDoc.getDocumentElement()));
        XMLObject responseObject = null;
        try {
            responseObject = OpenSAMLUtil.fromDom((Element)responseDoc.getDocumentElement());
        }
        catch (WSSecurityException ex) {
            throw new BadRequestException((Throwable)ex);
        }
        if (!(responseObject instanceof org.opensaml.saml2.core.Response)) {
            throw new BadRequestException();
        }
        return (org.opensaml.saml2.core.Response)responseObject;
    }

    protected void validateSamlResponseProtocol(org.opensaml.saml2.core.Response samlResponse) {
        try {
            SAMLProtocolResponseValidator protocolValidator = new SAMLProtocolResponseValidator();
            protocolValidator.validateSamlResponse(samlResponse, this.getSignatureCrypto(), this.getCallbackHandler());
        }
        catch (WSSecurityException ex) {
            LOG.log(Level.FINE, ex.getMessage(), ex);
            this.reportError("INVALID_SAML_RESPONSE");
            throw new BadRequestException();
        }
    }

    protected SSOValidatorResponse validateSamlSSOResponse(boolean postBinding, org.opensaml.saml2.core.Response samlResponse, RequestState requestState) {
        try {
            SAMLSSOResponseValidator ssoResponseValidator = new SAMLSSOResponseValidator();
            ssoResponseValidator.setAssertionConsumerURL(this.messageContext.getUriInfo().getAbsolutePath().toString());
            ssoResponseValidator.setClientAddress(this.messageContext.getHttpServletRequest().getRemoteAddr());
            ssoResponseValidator.setIssuerIDP(requestState.getIdpServiceAddress());
            ssoResponseValidator.setRequestId(requestState.getSamlRequestId());
            ssoResponseValidator.setSpIdentifier(requestState.getIssuerId());
            ssoResponseValidator.setEnforceAssertionsSigned(this.enforceAssertionsSigned);
            ssoResponseValidator.setEnforceKnownIssuer(this.enforceKnownIssuer);
            ssoResponseValidator.setReplayCache(this.getReplayCache());
            return ssoResponseValidator.validateSamlResponse(samlResponse, postBinding);
        }
        catch (WSSecurityException ex) {
            this.reportError("INVALID_SAML_RESPONSE");
            throw new BadRequestException((Throwable)ex);
        }
    }

    private URI getTargetURI(String targetAddress) {
        if (targetAddress != null) {
            try {
                return URI.create(targetAddress);
            }
            catch (IllegalArgumentException ex) {
                this.reportError("INVALID_TARGET_URI");
            }
        } else {
            this.reportError("MISSING_TARGET_URI");
        }
        throw new BadRequestException();
    }

    private void reportError(String code) {
        Message errorMsg = new Message(code, BUNDLE, new Object[0]);
        LOG.warning(errorMsg.toString());
    }
}

