/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.saml.sso;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Date;
import java.util.Properties;
import java.util.logging.Logger;
import javax.annotation.PreDestroy;
import javax.security.auth.callback.CallbackHandler;
import org.apache.cxf.Bus;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.jaxrs.utils.HttpUtils;
import org.apache.cxf.phase.PhaseInterceptorChain;
import org.apache.cxf.resource.ResourceManager;
import org.apache.cxf.rs.security.saml.sso.state.SPStateManager;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.components.crypto.CryptoFactory;
import org.apache.ws.security.saml.ext.OpenSAMLUtil;

public class AbstractSSOSpHandler {
    private static final Logger LOG = LogUtils.getL7dLogger(AbstractSSOSpHandler.class);
    private SPStateManager stateProvider;
    private long stateTimeToLive = 120000L;
    private Crypto signatureCrypto;
    private String signaturePropertiesFile;
    private CallbackHandler callbackHandler;
    private String callbackHandlerClass;

    @PreDestroy
    public void close() throws IOException {
        if (this.stateProvider != null) {
            this.stateProvider.close();
            this.stateProvider = null;
        }
    }

    public void setSignatureCrypto(Crypto crypto) {
        this.signatureCrypto = crypto;
    }

    public void setSignaturePropertiesFile(String signaturePropertiesFile) {
        this.signaturePropertiesFile = signaturePropertiesFile;
        LOG.fine("Setting signature properties: " + signaturePropertiesFile);
    }

    public void setCallbackHandler(CallbackHandler callbackHandler) {
        this.callbackHandler = callbackHandler;
        LOG.fine("Setting callbackHandler: " + callbackHandler);
    }

    public void setCallbackHandlerClass(String callbackHandlerClass) {
        this.callbackHandlerClass = callbackHandlerClass;
        LOG.fine("Setting callbackHandlerClass: " + callbackHandlerClass);
    }

    protected String createCookie(String name, String value, String path, String domain) {
        String contextCookie = name + "=" + value;
        if (path != null) {
            contextCookie = contextCookie + ";Path=" + path;
        }
        if (domain != null) {
            contextCookie = contextCookie + ";Domain=" + domain;
        }
        Date expiresDate = new Date(System.currentTimeMillis() + this.stateTimeToLive);
        String cookieExpires = HttpUtils.getHttpDateFormat().format(expiresDate);
        contextCookie = contextCookie + ";Expires=" + cookieExpires;
        return contextCookie;
    }

    protected boolean isStateExpired(long stateCreatedAt, long expiresAt) {
        Date currentTime = new Date();
        if (currentTime.after(new Date(stateCreatedAt + this.getStateTimeToLive()))) {
            return true;
        }
        return expiresAt > 0L && currentTime.after(new Date(expiresAt));
    }

    public void setStateProvider(SPStateManager stateProvider) {
        this.stateProvider = stateProvider;
    }

    public SPStateManager getStateProvider() {
        return this.stateProvider;
    }

    public void setStateTimeToLive(long stateTimeToLive) {
        this.stateTimeToLive = stateTimeToLive;
    }

    public long getStateTimeToLive() {
        return this.stateTimeToLive;
    }

    protected static Properties getProps(Object o) {
        Properties properties = null;
        if (o instanceof Properties) {
            properties = (Properties)o;
        } else if (o instanceof String) {
            URL url = null;
            Bus bus = PhaseInterceptorChain.getCurrentMessage().getExchange().getBus();
            ResourceManager rm = (ResourceManager)bus.getExtension(ResourceManager.class);
            url = (URL)rm.resolveResource((String)o, URL.class);
            try {
                if (url == null) {
                    url = ClassLoaderUtils.getResource((String)((String)o), AbstractSSOSpHandler.class);
                }
                if (url == null) {
                    url = new URL((String)o);
                }
                if (url != null) {
                    properties = new Properties();
                    InputStream ins = url.openStream();
                    properties.load(ins);
                    ins.close();
                }
            }
            catch (IOException e) {
                LOG.fine(e.getMessage());
                properties = null;
            }
        } else if (o instanceof URL) {
            properties = new Properties();
            try {
                InputStream ins = ((URL)o).openStream();
                properties.load(ins);
                ins.close();
            }
            catch (IOException e) {
                LOG.fine(e.getMessage());
                properties = null;
            }
        }
        return properties;
    }

    protected Crypto getSignatureCrypto() {
        if (this.signatureCrypto == null && this.signaturePropertiesFile != null) {
            Properties sigProperties = AbstractSSOSpHandler.getProps(this.signaturePropertiesFile);
            if (sigProperties == null) {
                LOG.fine("Cannot load signature properties using: " + this.signaturePropertiesFile);
                return null;
            }
            try {
                this.signatureCrypto = CryptoFactory.getInstance((Properties)sigProperties);
            }
            catch (WSSecurityException ex) {
                LOG.fine("Error in loading the signature Crypto object: " + ex.getMessage());
                return null;
            }
        }
        return this.signatureCrypto;
    }

    protected CallbackHandler getCallbackHandler() {
        if (this.callbackHandler == null && this.callbackHandlerClass != null) {
            this.callbackHandler = this.getCallbackHandler(this.callbackHandlerClass);
            if (this.callbackHandler == null) {
                LOG.fine("Cannot load CallbackHandler using: " + this.callbackHandlerClass);
                return null;
            }
        }
        return this.callbackHandler;
    }

    private CallbackHandler getCallbackHandler(Object o) {
        CallbackHandler handler = null;
        if (o instanceof CallbackHandler) {
            handler = (CallbackHandler)o;
        } else if (o instanceof String) {
            try {
                handler = (CallbackHandler)ClassLoaderUtils.loadClass((String)((String)o), this.getClass()).newInstance();
            }
            catch (Exception e) {
                LOG.fine(e.getMessage());
                handler = null;
            }
        }
        return handler;
    }

    static {
        OpenSAMLUtil.initSamlEngine();
    }
}

