/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth2.grants.code;

import java.util.List;
import org.apache.cxf.rs.security.oauth2.grants.code.AuthorizationCodeDataProvider;
import org.apache.cxf.rs.security.oauth2.grants.code.AuthorizationCodeRegistration;
import org.apache.cxf.rs.security.oauth2.grants.code.ServerAuthorizationCodeGrant;
import org.apache.cxf.rs.security.oauth2.provider.AbstractOAuthDataProvider;
import org.apache.cxf.rs.security.oauth2.provider.OAuthServiceException;
import org.apache.cxf.rs.security.oauth2.utils.OAuthUtils;

public abstract class AbstractAuthorizationCodeDataProvider
extends AbstractOAuthDataProvider
implements AuthorizationCodeDataProvider {
    private long grantLifetime = 3600L;

    @Override
    public ServerAuthorizationCodeGrant createCodeGrant(AuthorizationCodeRegistration reg) throws OAuthServiceException {
        ServerAuthorizationCodeGrant grant = new ServerAuthorizationCodeGrant(reg.getClient(), this.getCode(reg), this.getGrantLifetime(), this.getIssuedAt());
        grant.setApprovedScopes(this.getApprovedScopes(reg));
        grant.setAudience(reg.getAudience());
        grant.setClientCodeVerifier(reg.getClientCodeVerifier());
        grant.setSubject(reg.getSubject());
        grant.setRedirectUri(reg.getRedirectUri());
        return grant;
    }

    protected List<String> getApprovedScopes(AuthorizationCodeRegistration reg) {
        return reg.getApprovedScope();
    }

    protected String getCode(AuthorizationCodeRegistration reg) {
        return OAuthUtils.generateRandomTokenKey();
    }

    public long getGrantLifetime() {
        return this.grantLifetime;
    }

    public void setGrantLifetime(long lifetime) {
        this.grantLifetime = lifetime;
    }

    protected long getIssuedAt() {
        return OAuthUtils.getIssuedAt();
    }
}

