/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth.client;

import java.net.URI;
import java.security.PrivateKey;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.ClientException;
import javax.ws.rs.core.UriBuilder;
import net.oauth.OAuth;
import net.oauth.OAuthAccessor;
import net.oauth.OAuthConsumer;
import net.oauth.OAuthMessage;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.jaxrs.ext.form.Form;
import org.apache.cxf.rs.security.oauth.provider.OAuthServiceException;

public final class OAuthClientUtils {
    private OAuthClientUtils() {
    }

    public static URI getAuthorizationURI(String authorizationServiceURI, String requestToken) {
        return UriBuilder.fromUri((String)authorizationServiceURI).queryParam("oauth_token", new Object[]{requestToken}).build(new Object[0]);
    }

    public static Token getRequestToken(WebClient requestTokenService, Consumer consumer, URI callback, Map<String, String> extraParams) throws OAuthServiceException {
        return OAuthClientUtils.getRequestToken(requestTokenService, consumer, callback, extraParams, null);
    }

    public static Map<String, Object> prepareOAuthRsaProperties(PrivateKey pk) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("oauth_signature_method", "RSA-SHA1");
        props.put("RSA-SHA1.PrivateKey", pk);
        return props;
    }

    public static Token getRequestToken(WebClient requestTokenService, Consumer consumer, URI callback, Map<String, String> extraParams, Map<String, Object> oauthConsumerProps) throws OAuthServiceException {
        HashMap<String, String> parameters = new HashMap<String, String>();
        if (extraParams != null) {
            parameters.putAll(extraParams);
        }
        parameters.put("oauth_callback", callback.toString());
        if (oauthConsumerProps == null || !oauthConsumerProps.containsKey("oauth_signature_method")) {
            parameters.put("oauth_signature_method", "HMAC-SHA1");
        }
        parameters.put("oauth_nonce", UUID.randomUUID().toString());
        parameters.put("oauth_timestamp", String.valueOf(System.currentTimeMillis() / 1000L));
        parameters.put("oauth_consumer_key", consumer.getKey());
        OAuthAccessor accessor = OAuthClientUtils.createAccessor(consumer, oauthConsumerProps);
        return OAuthClientUtils.getToken(requestTokenService, accessor, parameters);
    }

    private static OAuthAccessor createAccessor(Consumer consumer, Map<String, Object> props) {
        OAuthConsumer oAuthConsumer = new OAuthConsumer(null, consumer.getKey(), consumer.getSecret(), null);
        if (props != null) {
            for (Map.Entry<String, Object> entry : props.entrySet()) {
                oAuthConsumer.setProperty(entry.getKey(), entry.getValue());
            }
        }
        return new OAuthAccessor(oAuthConsumer);
    }

    public static Token getAccessToken(WebClient accessTokenService, Consumer consumer, Token requestToken, String verifier) throws OAuthServiceException {
        return OAuthClientUtils.getAccessToken(accessTokenService, consumer, requestToken, verifier, null);
    }

    public static Token getAccessToken(WebClient accessTokenService, Consumer consumer, Token requestToken, String verifier, Map<String, Object> oauthConsumerProps) throws OAuthServiceException {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("oauth_consumer_key", consumer.getKey());
        parameters.put("oauth_token", requestToken.getToken());
        parameters.put("oauth_verifier", verifier);
        if (oauthConsumerProps == null || !oauthConsumerProps.containsKey("oauth_signature_method")) {
            parameters.put("oauth_signature_method", "HMAC-SHA1");
        }
        OAuthAccessor accessor = OAuthClientUtils.createAccessor(consumer, oauthConsumerProps);
        accessor.requestToken = requestToken.getToken();
        accessor.tokenSecret = requestToken.getSecret();
        return OAuthClientUtils.getToken(accessTokenService, accessor, parameters);
    }

    public static String createAuthorizationHeader(Consumer consumer, Token accessToken, String method, String requestURI) {
        return OAuthClientUtils.createAuthorizationHeader(consumer, accessToken, method, requestURI, null);
    }

    public static String createAuthorizationHeader(Consumer consumer, Token accessToken, String method, String requestURI, Map<String, Object> oauthConsumerProps) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("oauth_consumer_key", consumer.getKey());
        if (accessToken != null) {
            parameters.put("oauth_token", accessToken.getToken());
        }
        if (oauthConsumerProps == null || !oauthConsumerProps.containsKey("oauth_signature_method")) {
            parameters.put("oauth_signature_method", "HMAC-SHA1");
        }
        parameters.put("oauth_nonce", UUID.randomUUID().toString());
        parameters.put("oauth_timestamp", String.valueOf(System.currentTimeMillis() / 1000L));
        OAuthAccessor accessor = OAuthClientUtils.createAccessor(consumer, oauthConsumerProps);
        if (accessToken != null) {
            accessor.accessToken = accessToken.getToken();
            accessor.tokenSecret = accessToken.getSecret();
        }
        return OAuthClientUtils.doGetAuthorizationHeader(accessor, method, requestURI, parameters);
    }

    public static String createAuthorizationHeader(Consumer consumer) {
        StringBuilder sb = new StringBuilder();
        sb.append("OAuth ").append("oauth_consumer_key=").append(consumer.getKey()).append("oauth_consumer_secret=").append(consumer.getSecret());
        return sb.toString();
    }

    private static String doGetAuthorizationHeader(OAuthAccessor accessor, String method, String requestURI, Map<String, String> parameters) {
        try {
            OAuthMessage msg = accessor.newRequestMessage(method, requestURI, parameters.entrySet());
            StringBuilder sb = new StringBuilder();
            sb.append(msg.getAuthorizationHeader(null));
            for (Map.Entry<String, String> entry : parameters.entrySet()) {
                if (entry.getKey().startsWith("oauth_")) continue;
                sb.append(", ");
                sb.append(OAuth.percentEncode((String)entry.getKey())).append("=\"");
                sb.append(OAuth.percentEncode((String)entry.getValue())).append('\"');
            }
            return sb.toString();
        }
        catch (Exception ex) {
            throw new ClientException((Throwable)ex);
        }
    }

    private static Token getToken(WebClient tokenService, OAuthAccessor accessor, Map<String, String> parameters) throws OAuthServiceException {
        String header = OAuthClientUtils.doGetAuthorizationHeader(accessor, "POST", tokenService.getBaseURI().toString(), parameters);
        try {
            tokenService.replaceHeader("Authorization", header);
            Form form = (Form)tokenService.post(null, Form.class);
            return new Token((String)form.getData().getFirst((Object)"oauth_token"), (String)form.getData().getFirst((Object)"oauth_token_secret"));
        }
        catch (WebApplicationException ex) {
            throw new OAuthServiceException(ex);
        }
    }

    public static class Consumer {
        private String key;
        private String secret;

        public Consumer(String key, String secret) {
            this.key = key;
            this.secret = secret;
        }

        public String getKey() {
            return this.key;
        }

        public String getSecret() {
            return this.secret;
        }
    }

    public static class Token {
        private String token;
        private String secret;

        public Token(String token, String secret) {
            this.token = token;
            this.secret = secret;
        }

        public String getToken() {
            return this.token;
        }

        public String getSecret() {
            return this.secret;
        }
    }
}

