/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.impl;

import javax.ws.rs.container.ResourceContext;
import org.apache.cxf.jaxrs.lifecycle.PerRequestResourceProvider;
import org.apache.cxf.jaxrs.model.ClassResourceInfo;
import org.apache.cxf.jaxrs.model.OperationResourceInfo;
import org.apache.cxf.jaxrs.provider.ServerProviderFactory;
import org.apache.cxf.message.Message;

public class ResourceContextImpl
implements ResourceContext {
    private ClassResourceInfo cri;
    private Class<?> subClass;
    private Message m;

    public ResourceContextImpl(Message m, OperationResourceInfo ori) {
        this.m = m;
        this.cri = ori.getClassResourceInfo();
        this.subClass = ori.getMethodToInvoke().getReturnType();
    }

    public <T> T getResource(Class<T> cls) {
        T resource = cls.cast(new PerRequestResourceProvider(cls).getInstance(this.m));
        return this.doInitResource(cls, resource);
    }

    public <T> T initResource(T resource) {
        return this.doInitResource(resource.getClass(), resource);
    }

    private <T> T doInitResource(Class<?> cls, T resource) {
        ClassResourceInfo sub = this.cri.getSubResource(this.subClass, cls, resource, true, this.m);
        sub.initBeanParamInfo(ServerProviderFactory.getInstance(this.m));
        return resource;
    }
}

