/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.ext.multipart;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.ws.rs.core.MediaType;
import org.apache.cxf.jaxrs.ext.multipart.Attachment;
import org.apache.cxf.jaxrs.ext.multipart.ContentDisposition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultipartBody {
    public static final String INBOUND_MESSAGE_ATTACHMENTS = "org.apache.cxf.jaxrs.attachments.inbound";
    public static final String OUTBOUND_MESSAGE_ATTACHMENTS = "org.apache.cxf.jaxrs.attachments.outbound";
    private static final MediaType MULTIPART_RELATED_TYPE = MediaType.valueOf((String)"multipart/related");
    private boolean outbound;
    private List<Attachment> atts;
    private MediaType mt;

    public MultipartBody(List<Attachment> atts, MediaType mt, boolean outbound) {
        this.atts = atts;
        this.outbound = outbound;
        this.mt = mt == null ? MULTIPART_RELATED_TYPE : mt;
    }

    public MultipartBody(List<Attachment> atts, boolean outbound) {
        this(atts, MULTIPART_RELATED_TYPE, outbound);
    }

    public MultipartBody(Attachment att) {
        this.atts = new ArrayList<Attachment>();
        this.atts.add(att);
        this.outbound = true;
        this.mt = MULTIPART_RELATED_TYPE;
    }

    public MultipartBody(List<Attachment> atts) {
        this(atts, MULTIPART_RELATED_TYPE, false);
    }

    public MultipartBody(boolean outbound) {
        this(new ArrayList<Attachment>(), MULTIPART_RELATED_TYPE, outbound);
    }

    public MediaType getType() {
        return this.mt;
    }

    public List<Attachment> getAllAttachments() {
        return this.outbound ? this.atts : Collections.unmodifiableList(this.atts);
    }

    public List<Attachment> getChildAttachments() {
        ArrayList<Attachment> childAtts = new ArrayList<Attachment>();
        for (int i = 1; i < this.atts.size(); ++i) {
            childAtts.add(this.atts.get(i));
        }
        return childAtts;
    }

    public Attachment getRootAttachment() {
        return this.atts.size() > 0 ? this.atts.get(0) : null;
    }

    public Attachment getAttachment(String contentId) {
        for (Attachment a : this.atts) {
            if (contentId.equalsIgnoreCase(a.getContentId())) {
                return a;
            }
            ContentDisposition cd = a.getContentDisposition();
            if (cd == null || !contentId.equals(cd.getParameter("name"))) continue;
            return a;
        }
        return null;
    }

    public <T> T getAttachmentObject(String contentId, Class<T> cls) {
        Attachment att = this.getAttachment(contentId);
        if (att != null) {
            return att.getObject(cls);
        }
        return null;
    }
}

