/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.java2wsdl.generator.wsdl11.annotator;

import java.util.ArrayList;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.tools.common.model.Annotator;
import org.apache.cxf.tools.common.model.JAnnotation;
import org.apache.cxf.tools.common.model.JAnnotationElement;
import org.apache.cxf.tools.common.model.JavaAnnotatable;
import org.apache.cxf.tools.common.model.JavaField;
import org.apache.cxf.tools.java2wsdl.generator.wsdl11.model.WrapperBeanClass;

public class WrapperBeanAnnotator
implements Annotator {
    Class<?> sourceClass;

    public WrapperBeanAnnotator() {
    }

    public WrapperBeanAnnotator(Class<?> cls) {
        this.sourceClass = cls;
    }

    @Override
    public void annotate(JavaAnnotatable clz) {
        WrapperBeanClass beanClass = null;
        if (!(clz instanceof WrapperBeanClass)) {
            throw new RuntimeException("WrapperBeanAnnotator expect JavaClass as input");
        }
        beanClass = (WrapperBeanClass)clz;
        JAnnotation xmlRootElement = new JAnnotation(XmlRootElement.class);
        xmlRootElement.addElement(new JAnnotationElement("name", beanClass.getElementName().getLocalPart()));
        xmlRootElement.addElement(new JAnnotationElement("namespace", beanClass.getElementName().getNamespaceURI()));
        JAnnotation xmlAccessorType = new JAnnotation(XmlAccessorType.class);
        xmlAccessorType.addElement(new JAnnotationElement(null, XmlAccessType.FIELD));
        XmlType tp = null;
        if (this.sourceClass != null) {
            tp = this.sourceClass.getAnnotation(XmlType.class);
        }
        JAnnotation xmlType = new JAnnotation(XmlType.class);
        if (tp == null) {
            xmlType.addElement(new JAnnotationElement("name", beanClass.getElementName().getLocalPart()));
            xmlType.addElement(new JAnnotationElement("namespace", beanClass.getElementName().getNamespaceURI()));
        } else {
            if (!"##default".equals(tp.name())) {
                xmlType.addElement(new JAnnotationElement("name", tp.name()));
            }
            if (!"##default".equals(tp.namespace())) {
                xmlType.addElement(new JAnnotationElement("namespace", tp.namespace()));
            }
            if (!StringUtils.isEmpty(tp.factoryMethod())) {
                xmlType.addElement(new JAnnotationElement("factoryMethod", tp.factoryMethod()));
            }
            if (tp.propOrder().length != 1 || !StringUtils.isEmpty(tp.propOrder()[0])) {
                xmlType.addElement(new JAnnotationElement("propOrder", tp.propOrder()));
            }
        }
        ArrayList<String> props = new ArrayList<String>();
        for (JavaField f : beanClass.getFields()) {
            props.add(f.getParaName());
        }
        if (props.size() > 1) {
            xmlType.addElement(new JAnnotationElement("propOrder", props));
        }
        beanClass.addAnnotation(xmlRootElement);
        beanClass.addAnnotation(xmlAccessorType);
        beanClass.addAnnotation(xmlType);
    }
}

