/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.saml;

import javax.xml.namespace.QName;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.helpers.XMLUtils;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.message.Message;
import org.apache.cxf.rs.security.saml.SAMLUtils;
import org.apache.cxf.rs.security.xml.AbstractXmlSecOutInterceptor;
import org.apache.cxf.rs.security.xml.XmlEncOutInterceptor;
import org.apache.cxf.rs.security.xml.XmlSigOutInterceptor;
import org.apache.ws.security.saml.ext.AssertionWrapper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SamlEnvelopedOutInterceptor
extends AbstractXmlSecOutInterceptor {
    private static final String DEFAULT_ENV_PREFIX = "env";
    private static final QName DEFAULT_ENV_QNAME = new QName("http://org.apache.cxf/rs/env", "Envelope", "env");
    private QName envelopeQName = DEFAULT_ENV_QNAME;
    private boolean signLater;

    public SamlEnvelopedOutInterceptor() {
        super.addAfter(XmlSigOutInterceptor.class.getName());
        super.addBefore(XmlEncOutInterceptor.class.getName());
    }

    public SamlEnvelopedOutInterceptor(boolean signLater) {
        if (signLater) {
            super.addBefore(XmlSigOutInterceptor.class.getName());
        } else {
            super.addAfter(XmlSigOutInterceptor.class.getName());
        }
        this.signLater = signLater;
        super.addBefore(XmlEncOutInterceptor.class.getName());
    }

    @Override
    protected Document processDocument(Message message, Document doc) throws Exception {
        return this.createEnvelopedSamlToken(message, doc);
    }

    private Document createEnvelopedSamlToken(Message message, Document payloadDoc) throws Exception {
        Element docEl = payloadDoc.getDocumentElement();
        AssertionWrapper assertion = SAMLUtils.createAssertion(message);
        QName rootName = DOMUtils.getElementQName(payloadDoc.getDocumentElement());
        if (rootName.equals(this.envelopeQName)) {
            docEl.appendChild(assertion.toDOM(payloadDoc));
            return payloadDoc;
        }
        Document newDoc = DOMUtils.createDocument();
        Element root = newDoc.createElementNS(this.envelopeQName.getNamespaceURI(), this.envelopeQName.getPrefix() + ":" + this.envelopeQName.getLocalPart());
        newDoc.appendChild(root);
        Element assertionEl = assertion.toDOM(newDoc);
        root.appendChild(assertionEl);
        payloadDoc.removeChild(docEl);
        newDoc.adoptNode(docEl);
        root.appendChild(docEl);
        if (this.signLater) {
            CachedOutputStream bos = new CachedOutputStream();
            DOMUtils.writeXml(newDoc, bos);
            return DOMUtils.readXml(bos.getInputStream());
        }
        return newDoc;
    }

    public void setEnvelopeName(String expandedName) {
        this.setEnvelopeQName(XMLUtils.convertStringToQName(expandedName, DEFAULT_ENV_PREFIX));
    }

    public void setEnvelopeQName(QName name) {
        if (name.getPrefix().length() == 0) {
            name = new QName(name.getNamespaceURI(), name.getLocalPart(), DEFAULT_ENV_PREFIX);
        }
        this.envelopeQName = name;
    }
}

