/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.javascript;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.cxf.Bus;
import org.apache.cxf.common.i18n.UncheckedException;
import org.apache.cxf.common.injection.NoJSR250Annotations;
import org.apache.cxf.common.util.UrlUtils;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.endpoint.ServerRegistry;
import org.apache.cxf.javascript.BasicNameManager;
import org.apache.cxf.javascript.NamespacePrefixAccumulator;
import org.apache.cxf.javascript.service.ServiceJavascriptBuilder;
import org.apache.cxf.javascript.types.SchemaJavascriptBuilder;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.service.model.SchemaInfo;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.transport.DestinationWithEndpoint;
import org.apache.cxf.transports.http.QueryHandlerRegistry;
import org.apache.cxf.transports.http.StemMatchingQueryHandler;

@NoJSR250Annotations(unlessNull={"bus"})
public class JavascriptQueryHandler
implements StemMatchingQueryHandler {
    private static final String JS_UTILS_PATH = "/org/apache/cxf/javascript/cxf-utils.js";
    private static final Charset UTF8 = Charset.forName("utf-8");
    private static final String NO_UTILS_QUERY_KEY = "nojsutils";
    private static final String CODE_QUERY_KEY = "js";
    private Bus bus;

    public JavascriptQueryHandler(Bus b) {
        this.setBus(b);
    }

    @Resource
    public final void setBus(Bus b) {
        if (this.bus != b) {
            this.bus = b;
            QueryHandlerRegistry reg = b.getExtension(QueryHandlerRegistry.class);
            if (reg != null) {
                reg.registerHandler(this);
            }
        }
    }

    @Override
    public String getResponseContentType(String fullQueryString, String ctx) {
        URI uri = URI.create(fullQueryString);
        Map<String, String> map = UrlUtils.parseQueryString(uri.getQuery());
        if (map.containsKey(CODE_QUERY_KEY)) {
            return "application/javascript;charset=UTF-8";
        }
        return null;
    }

    @Override
    public boolean isRecognizedQuery(String baseUri, String ctx, EndpointInfo endpointInfo, boolean contextMatchExact) {
        if (baseUri == null) {
            return false;
        }
        URI uri = URI.create(baseUri);
        Map<String, String> map = UrlUtils.parseQueryString(uri.getQuery());
        if (map.containsKey(CODE_QUERY_KEY)) {
            return endpointInfo.getAddress().contains(UrlUtils.getStem(uri.getSchemeSpecificPart()));
        }
        return false;
    }

    public static void writeUtilsToResponseStream(Class<?> referenceClass, OutputStream outputStream) {
        InputStream utils = referenceClass.getResourceAsStream(JS_UTILS_PATH);
        if (utils == null) {
            throw new RuntimeException("Unable to get stream for /org/apache/cxf/javascript/cxf-utils.js");
        }
        byte[] buffer = new byte[1024];
        try {
            int count;
            while ((count = utils.read(buffer, 0, 1024)) > 0) {
                outputStream.write(buffer, 0, count);
            }
            outputStream.flush();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to write javascript utils to HTTP response.", e);
        }
    }

    private Endpoint findEndpoint(EndpointInfo endpointInfo) {
        ServerRegistry serverRegistry = this.bus.getExtension(ServerRegistry.class);
        for (Server server : serverRegistry.getServers()) {
            if (!(server.getDestination() instanceof DestinationWithEndpoint) || !endpointInfo.equals(((DestinationWithEndpoint)((Object)server.getDestination())).getEndpointInfo())) continue;
            return server.getEndpoint();
        }
        return null;
    }

    @Override
    public void writeResponse(String fullQueryString, String ctx, EndpointInfo endpoint, OutputStream os) {
        URI uri = URI.create(fullQueryString);
        String query = uri.getQuery();
        Map<String, String> map = UrlUtils.parseQueryString(query);
        OutputStreamWriter writer = new OutputStreamWriter(os, UTF8);
        if (!map.containsKey(NO_UTILS_QUERY_KEY)) {
            JavascriptQueryHandler.writeUtilsToResponseStream(JavascriptQueryHandler.class, os);
        }
        if (map.containsKey(CODE_QUERY_KEY)) {
            ServiceInfo serviceInfo = endpoint.getService();
            List<SchemaInfo> schemata = serviceInfo.getSchemas();
            Endpoint serverEndpoint = this.findEndpoint(endpoint);
            BasicNameManager nameManager = BasicNameManager.newNameManager(serviceInfo, serverEndpoint);
            NamespacePrefixAccumulator prefixManager = new NamespacePrefixAccumulator(serviceInfo.getXmlSchemaCollection());
            try {
                for (SchemaInfo schema : schemata) {
                    SchemaJavascriptBuilder builder = new SchemaJavascriptBuilder(serviceInfo.getXmlSchemaCollection(), prefixManager, nameManager);
                    String allThatJavascript = builder.generateCodeForSchema(schema.getSchema());
                    writer.append(allThatJavascript);
                }
                ServiceJavascriptBuilder serviceBuilder = new ServiceJavascriptBuilder(serviceInfo, endpoint.getAddress(), prefixManager, nameManager);
                serviceBuilder.walk();
                String serviceJavascript = serviceBuilder.getCode();
                writer.append(serviceJavascript);
                writer.flush();
            }
            catch (IOException e) {
                throw new UncheckedException(e);
            }
        } else {
            throw new RuntimeException("Invalid query " + fullQueryString);
        }
    }

    @Override
    public boolean isRecognizedQuery(String fullQueryString, String ctx, EndpointInfo endpoint) {
        return this.isRecognizedQuery(fullQueryString, ctx, endpoint, false);
    }
}

