/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.saml;

import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import org.apache.cxf.common.util.Base64Exception;
import org.apache.cxf.common.util.Base64Utility;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.rs.security.saml.DeflateEncoderDecoder;
import org.apache.cxf.rs.security.saml.SAMLUtils;
import org.apache.ws.security.WSSConfig;
import org.apache.ws.security.saml.ext.AssertionWrapper;

public abstract class AbstractSamlOutInterceptor
extends AbstractPhaseInterceptor<Message> {
    private boolean useDeflateEncoding = true;

    protected AbstractSamlOutInterceptor() {
        super("write");
    }

    public void setUseDeflateEncoding(boolean deflate) {
        this.useDeflateEncoding = deflate;
    }

    protected AssertionWrapper createAssertion(Message message) throws Fault {
        return SAMLUtils.createAssertion(message);
    }

    protected String encodeToken(String assertion) throws Base64Exception {
        byte[] tokenBytes = null;
        try {
            tokenBytes = assertion.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            // empty catch block
        }
        if (this.useDeflateEncoding) {
            tokenBytes = new DeflateEncoderDecoder().deflateToken(tokenBytes);
        }
        StringWriter writer = new StringWriter();
        Base64Utility.encode(tokenBytes, 0, tokenBytes.length, writer);
        return writer.toString();
    }

    static {
        WSSConfig.init();
    }
}

