/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.bindings.spi.webservices;

import java.util.Collections;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.ws.Binding;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.soap.MTOMFeature;
import javax.xml.ws.soap.SOAPBinding;
import org.apache.chemistry.opencmis.client.bindings.impl.CmisBindingsHelper;
import org.apache.chemistry.opencmis.client.bindings.spi.webservices.AbstractPortProvider;
import org.apache.chemistry.opencmis.commons.exceptions.CmisBaseException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisConnectionException;
import org.apache.chemistry.opencmis.commons.spi.AuthenticationProvider;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.frontend.ClientProxy;
import org.apache.cxf.headers.Header;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.transports.http.configuration.HTTPClientPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class CXFPortProvider
extends AbstractPortProvider {
    private static final Logger LOG = LoggerFactory.getLogger(CXFPortProvider.class);

    protected BindingProvider createPortObject(AbstractPortProvider.CmisServiceHolder serviceHolder) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Creating Web Service port object of " + serviceHolder.getServiceName() + "...");
        }
        try {
            int readTimeout;
            BindingProvider portObject = this.createPortObjectFromServiceHolder(serviceHolder, new WebServiceFeature[]{new MTOMFeature()});
            Binding binding = portObject.getBinding();
            ((SOAPBinding)binding).setMTOMEnabled(true);
            AuthenticationProvider authProvider = CmisBindingsHelper.getAuthenticationProvider(this.getSession());
            Map httpHeaders = null;
            if (authProvider != null) {
                Element soapHeader = authProvider.getSOAPHeaders((Object)portObject);
                if (soapHeader != null) {
                    portObject.getRequestContext().put(Header.HEADER_LIST, Collections.singletonList(new Header(new QName(soapHeader.getNamespaceURI(), soapHeader.getLocalName()), (Object)soapHeader)));
                }
                String url = serviceHolder.getEndpointUrl() != null ? serviceHolder.getEndpointUrl().toString() : serviceHolder.getServiceObject().getWSDLDocumentLocation().toString();
                httpHeaders = authProvider.getHTTPHeaders(url);
            }
            this.setHTTPHeaders(portObject, httpHeaders);
            this.setEndpointUrl(portObject, serviceHolder.getEndpointUrl());
            Client client = ClientProxy.getClient((Object)portObject);
            HTTPConduit http = (HTTPConduit)client.getConduit();
            HTTPClientPolicy httpClientPolicy = new HTTPClientPolicy();
            httpClientPolicy.setAllowChunking(true);
            int connectTimeout = this.getSession().get("org.apache.chemistry.opencmis.binding.connecttimeout", -1);
            if (connectTimeout >= 0) {
                httpClientPolicy.setConnectionTimeout((long)connectTimeout);
            }
            if ((readTimeout = this.getSession().get("org.apache.chemistry.opencmis.binding.readtimeout", -1)) >= 0) {
                httpClientPolicy.setReceiveTimeout((long)readTimeout);
            }
            http.setClient(httpClientPolicy);
            return portObject;
        }
        catch (CmisBaseException ce) {
            throw ce;
        }
        catch (Exception e) {
            throw new CmisConnectionException("Cannot initalize Web Services port object: " + e.getMessage(), (Throwable)e);
        }
    }
}

