/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.boot.actuate.endpoint;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.camel.CamelContext;
import org.apache.camel.Route;
import org.apache.camel.spi.RouteController;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;

@Endpoint(id="camelroutecontroller", enableByDefault=true)
public class CamelRouteControllerEndpoint {
    private CamelContext camelContext;

    public CamelRouteControllerEndpoint(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    @ReadOperation
    public List<String> getControlledRoutes() {
        RouteController controller = this.camelContext.getRouteController();
        if (controller != null) {
            return controller.getControlledRoutes().stream().map(Route::getId).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }
}

