/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.tooling.model;

public final class Strings {
    private Strings() {
    }

    public static boolean isNullOrEmpty(String text) {
        return text == null || text.isEmpty() || "null".equals(text);
    }

    public static String cutLastZeroDigit(String version) {
        Object answer = version;
        String[] parts = version.split("\\.");
        if (parts.length == 3 && parts[2].equals("0")) {
            answer = parts[0] + "." + parts[1];
        }
        return answer;
    }

    public static String wrapCamelCaseWords(String option, int watermark, String lineSep) {
        Object text = option.replaceAll("(?=[A-Z][a-z])", " ");
        text = Strings.wrapWords((String)text, "", lineSep, watermark, false);
        if (((String)(text = Character.toUpperCase(((String)text).charAt(0)) + ((String)text).substring(1))).startsWith(lineSep)) {
            text = ((String)text).substring(lineSep.length());
        }
        if (((String)text).endsWith(lineSep)) {
            text = ((String)text).substring(0, ((String)text).length() - lineSep.length());
        }
        return text;
    }

    public static String wrapWords(String line, String wordSep, String lineSep, int watermark, boolean wrapLongWords) {
        if (line == null) {
            return null;
        }
        if (lineSep == null) {
            lineSep = System.lineSeparator();
        }
        if (wordSep == null) {
            wordSep = "";
        }
        if (watermark < 1) {
            watermark = 1;
        }
        int inputLineLength = line.length();
        int offset = 0;
        StringBuilder sb = new StringBuilder(inputLineLength + 32);
        int currentLength = 0;
        while (offset < inputLineLength) {
            if (line.charAt(offset) == ' ') {
                ++offset;
                continue;
            }
            int next = line.indexOf(32, offset);
            if (next < 0) {
                next = inputLineLength;
                if (wrapLongWords && inputLineLength - offset > watermark) {
                    if (currentLength > 0) {
                        sb.append(wordSep);
                        currentLength += wordSep.length();
                    }
                    sb.append(line, offset, watermark - currentLength);
                    sb.append(lineSep);
                    offset += watermark - currentLength;
                }
            }
            if (currentLength + (currentLength > 0 ? wordSep.length() : 0) + next - offset <= watermark) {
                if (currentLength > 0) {
                    sb.append(wordSep);
                    currentLength += wordSep.length();
                }
                sb.append(line, offset, next);
                currentLength += next - offset;
                offset = next + 1;
                continue;
            }
            sb.append(lineSep);
            sb.append(line, offset, next);
            currentLength = next - offset;
            offset = next + 1;
        }
        return sb.toString();
    }

    public static String getClassShortName(String className) {
        if (className != null) {
            return className.replaceAll("<.*>", "").replaceAll(".*[.]([^.]+)", "$1");
        }
        return className;
    }
}

