/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.FailedToCreateConsumerException;
import org.apache.camel.LoggingLevel;
import org.apache.camel.PollingConsumerPollingStrategy;
import org.apache.camel.Processor;
import org.apache.camel.Suspendable;
import org.apache.camel.spi.PollingConsumerPollStrategy;
import org.apache.camel.spi.ScheduledPollConsumerScheduler;
import org.apache.camel.support.DefaultConsumer;
import org.apache.camel.support.DefaultPollingConsumerPollStrategy;
import org.apache.camel.support.DefaultScheduledPollConsumerScheduler;
import org.apache.camel.support.IntrospectionSupport;
import org.apache.camel.support.PropertyBindingSupport;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.util.ObjectHelper;

public abstract class ScheduledPollConsumer
extends DefaultConsumer
implements Runnable,
Suspendable,
PollingConsumerPollingStrategy {
    private ScheduledPollConsumerScheduler scheduler;
    private ScheduledExecutorService scheduledExecutorService;
    private boolean startScheduler = true;
    private long initialDelay = 1000L;
    private long delay = 500L;
    private TimeUnit timeUnit = TimeUnit.MILLISECONDS;
    private boolean useFixedDelay = true;
    private PollingConsumerPollStrategy pollStrategy = new DefaultPollingConsumerPollStrategy();
    private LoggingLevel runLoggingLevel = LoggingLevel.TRACE;
    private boolean sendEmptyMessageWhenIdle;
    private boolean greedy;
    private int backoffMultiplier;
    private int backoffIdleThreshold;
    private int backoffErrorThreshold;
    private Map<String, Object> schedulerProperties;
    private volatile boolean polling;
    private volatile int backoffCounter;
    private volatile long idleCounter;
    private volatile long errorCounter;

    public ScheduledPollConsumer(Endpoint endpoint, Processor processor) {
        super(endpoint, processor);
    }

    public ScheduledPollConsumer(Endpoint endpoint, Processor processor, ScheduledExecutorService scheduledExecutorService) {
        super(endpoint, processor);
        this.scheduledExecutorService = scheduledExecutorService;
        ObjectHelper.notNull((Object)scheduledExecutorService, (String)"scheduledExecutorService");
    }

    @Override
    public void run() {
        try {
            if (LoggingLevel.ERROR == this.runLoggingLevel) {
                this.log.error("Scheduled task started on:   {}", (Object)this.getEndpoint());
            } else if (LoggingLevel.WARN == this.runLoggingLevel) {
                this.log.warn("Scheduled task started on:   {}", (Object)this.getEndpoint());
            } else if (LoggingLevel.INFO == this.runLoggingLevel) {
                this.log.info("Scheduled task started on:   {}", (Object)this.getEndpoint());
            } else if (LoggingLevel.DEBUG == this.runLoggingLevel) {
                this.log.debug("Scheduled task started on:   {}", (Object)this.getEndpoint());
            } else {
                this.log.trace("Scheduled task started on:   {}", (Object)this.getEndpoint());
            }
            this.doRun();
            if (LoggingLevel.ERROR == this.runLoggingLevel) {
                this.log.error("Scheduled task completed on: {}", (Object)this.getEndpoint());
            } else if (LoggingLevel.WARN == this.runLoggingLevel) {
                this.log.warn("Scheduled task completed on: {}", (Object)this.getEndpoint());
            } else if (LoggingLevel.INFO == this.runLoggingLevel) {
                this.log.info("Scheduled task completed on: {}", (Object)this.getEndpoint());
            } else if (LoggingLevel.DEBUG == this.runLoggingLevel) {
                this.log.debug("Scheduled task completed on: {}", (Object)this.getEndpoint());
            } else {
                this.log.trace("Scheduled task completed on: {}", (Object)this.getEndpoint());
            }
        }
        catch (Error e) {
            this.log.error("Error occurred during running scheduled task on: " + this.getEndpoint() + ", due: " + e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRun() {
        if (this.isSuspended()) {
            this.log.trace("Cannot start to poll: {} as its suspended", (Object)this.getEndpoint());
            return;
        }
        if (this.backoffMultiplier > 0 && this.idleCounter >= (long)(this.backoffIdleThreshold > 0 ? this.backoffIdleThreshold : Integer.MAX_VALUE) || this.errorCounter >= (long)(this.backoffErrorThreshold > 0 ? this.backoffErrorThreshold : Integer.MAX_VALUE)) {
            if (this.backoffCounter++ < this.backoffMultiplier) {
                if (this.idleCounter > 0L) {
                    this.log.debug("doRun() backoff due subsequent {} idles (backoff at {}/{})", new Object[]{this.idleCounter, this.backoffCounter, this.backoffMultiplier});
                } else {
                    this.log.debug("doRun() backoff due subsequent {} errors (backoff at {}/{})", new Object[]{this.errorCounter, this.backoffCounter, this.backoffMultiplier});
                }
                return;
            }
            this.idleCounter = 0L;
            this.errorCounter = 0L;
            this.backoffCounter = 0;
            this.log.trace("doRun() backoff finished, resetting counters.");
        }
        int retryCounter = -1;
        boolean done = false;
        Throwable cause = null;
        int polledMessages = 0;
        while (!done) {
            try {
                cause = null;
                done = true;
                if (this.isPollAllowed()) {
                    if (retryCounter == -1) {
                        this.log.trace("Starting to poll: {}", (Object)this.getEndpoint());
                    } else {
                        this.log.debug("Retrying attempt {} to poll: {}", (Object)retryCounter, (Object)this.getEndpoint());
                    }
                    this.polling = true;
                    try {
                        boolean begin = this.pollStrategy.begin((Consumer)this, this.getEndpoint());
                        if (begin) {
                            ++retryCounter;
                            polledMessages = this.poll();
                            this.log.trace("Polled {} messages", (Object)polledMessages);
                            if (polledMessages == 0 && this.isSendEmptyMessageWhenIdle()) {
                                this.processEmptyMessage();
                            }
                            this.pollStrategy.commit((Consumer)this, this.getEndpoint(), polledMessages);
                            if (polledMessages > 0 && this.isGreedy()) {
                                done = false;
                                retryCounter = -1;
                                this.log.trace("Greedy polling after processing {} messages", (Object)polledMessages);
                            }
                        } else {
                            this.log.debug("Cannot begin polling as pollStrategy returned false: {}", (Object)this.pollStrategy);
                        }
                    }
                    finally {
                        this.polling = false;
                    }
                }
                this.log.trace("Finished polling: {}", (Object)this.getEndpoint());
            }
            catch (Exception e) {
                try {
                    boolean retry = this.pollStrategy.rollback((Consumer)this, this.getEndpoint(), retryCounter, e);
                    if (retry) {
                        done = false;
                    }
                    cause = e;
                    done = true;
                }
                catch (Throwable t) {
                    cause = t;
                    done = true;
                }
            }
            catch (Throwable t) {
                cause = t;
                done = true;
            }
            if (cause == null || !this.isRunAllowed()) continue;
            try {
                this.getExceptionHandler().handleException("Consumer " + this + " failed polling endpoint: " + this.getEndpoint() + ". Will try again at next poll", cause);
            }
            catch (Throwable e) {
                this.log.warn("Error handling exception. This exception will be ignored.", e);
            }
        }
        if (cause != null) {
            this.idleCounter = 0L;
            ++this.errorCounter;
        } else {
            this.idleCounter = polledMessages == 0 ? (this.idleCounter = this.idleCounter + 1L) : 0L;
            this.errorCounter = 0L;
        }
        this.log.trace("doRun() done with idleCounter={}, errorCounter={}", (Object)this.idleCounter, (Object)this.errorCounter);
    }

    protected void processEmptyMessage() throws Exception {
        Exchange exchange = this.getEndpoint().createExchange();
        this.log.debug("Sending empty message as there were no messages from polling: {}", (Object)this.getEndpoint());
        this.getProcessor().process(exchange);
    }

    protected boolean isPollAllowed() {
        return this.isRunAllowed() && !this.isSuspended();
    }

    protected boolean isPolling() {
        return this.polling;
    }

    public ScheduledPollConsumerScheduler getScheduler() {
        return this.scheduler;
    }

    public void setScheduler(ScheduledPollConsumerScheduler scheduler) {
        this.scheduler = scheduler;
    }

    public Map<String, Object> getSchedulerProperties() {
        return this.schedulerProperties;
    }

    public void setSchedulerProperties(Map<String, Object> schedulerProperties) {
        this.schedulerProperties = schedulerProperties;
    }

    public long getInitialDelay() {
        return this.initialDelay;
    }

    public void setInitialDelay(long initialDelay) {
        this.initialDelay = initialDelay;
    }

    public long getDelay() {
        return this.delay;
    }

    public void setDelay(long delay) {
        this.delay = delay;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public void setTimeUnit(TimeUnit timeUnit) {
        this.timeUnit = timeUnit;
    }

    public boolean isUseFixedDelay() {
        return this.useFixedDelay;
    }

    public void setUseFixedDelay(boolean useFixedDelay) {
        this.useFixedDelay = useFixedDelay;
    }

    public LoggingLevel getRunLoggingLevel() {
        return this.runLoggingLevel;
    }

    public void setRunLoggingLevel(LoggingLevel runLoggingLevel) {
        this.runLoggingLevel = runLoggingLevel;
    }

    public PollingConsumerPollStrategy getPollStrategy() {
        return this.pollStrategy;
    }

    public void setPollStrategy(PollingConsumerPollStrategy pollStrategy) {
        this.pollStrategy = pollStrategy;
    }

    public boolean isStartScheduler() {
        return this.startScheduler;
    }

    public void setStartScheduler(boolean startScheduler) {
        this.startScheduler = startScheduler;
    }

    public void setSendEmptyMessageWhenIdle(boolean sendEmptyMessageWhenIdle) {
        this.sendEmptyMessageWhenIdle = sendEmptyMessageWhenIdle;
    }

    public boolean isSendEmptyMessageWhenIdle() {
        return this.sendEmptyMessageWhenIdle;
    }

    public boolean isGreedy() {
        return this.greedy;
    }

    public void setGreedy(boolean greedy) {
        this.greedy = greedy;
    }

    public int getBackoffCounter() {
        return this.backoffCounter;
    }

    public int getBackoffMultiplier() {
        return this.backoffMultiplier;
    }

    public void setBackoffMultiplier(int backoffMultiplier) {
        this.backoffMultiplier = backoffMultiplier;
    }

    public int getBackoffIdleThreshold() {
        return this.backoffIdleThreshold;
    }

    public void setBackoffIdleThreshold(int backoffIdleThreshold) {
        this.backoffIdleThreshold = backoffIdleThreshold;
    }

    public int getBackoffErrorThreshold() {
        return this.backoffErrorThreshold;
    }

    public void setBackoffErrorThreshold(int backoffErrorThreshold) {
        this.backoffErrorThreshold = backoffErrorThreshold;
    }

    public ScheduledExecutorService getScheduledExecutorService() {
        return this.scheduledExecutorService;
    }

    public boolean isSchedulerStarted() {
        return this.scheduler.isSchedulerStarted();
    }

    public void setScheduledExecutorService(ScheduledExecutorService scheduledExecutorService) {
        this.scheduledExecutorService = scheduledExecutorService;
    }

    protected abstract int poll() throws Exception;

    @Override
    protected void doInit() throws Exception {
        super.doInit();
        if (this.backoffMultiplier > 0) {
            if (this.backoffIdleThreshold <= 0 && this.backoffErrorThreshold <= 0) {
                throw new IllegalArgumentException("backoffIdleThreshold and/or backoffErrorThreshold must be configured to a positive value when using backoffMultiplier");
            }
            this.log.debug("Using backoff[multiplier={}, idleThreshold={}, errorThreshold={}] on {}", new Object[]{this.backoffMultiplier, this.backoffIdleThreshold, this.backoffErrorThreshold, this.getEndpoint()});
        }
        if (this.scheduler == null) {
            this.scheduler = new DefaultScheduledPollConsumerScheduler(this.scheduledExecutorService);
        }
        this.scheduler.setCamelContext(this.getEndpoint().getCamelContext());
        this.scheduler.onInit((Consumer)this);
        LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
        IntrospectionSupport.getProperties(this, properties, null);
        PropertyBindingSupport.bindProperties(this.getEndpoint().getCamelContext(), this.scheduler, properties);
        if (this.schedulerProperties != null && !this.schedulerProperties.isEmpty()) {
            LinkedHashMap<String, Object> copy = new LinkedHashMap<String, Object>(this.schedulerProperties);
            PropertyBindingSupport.bindProperties(this.getEndpoint().getCamelContext(), this.scheduler, copy);
            if (copy.size() > 0) {
                throw new FailedToCreateConsumerException(this.getEndpoint(), "There are " + copy.size() + " scheduler parameters that couldn't be set on the endpoint. Check the uri if the parameters are spelt correctly and that they are properties of the endpoint. Unknown parameters=[" + copy + "]");
            }
        }
        ObjectHelper.notNull((Object)this.scheduler, (String)"scheduler", (Object)this);
        ObjectHelper.notNull((Object)this.pollStrategy, (String)"pollStrategy", (Object)this);
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        if (this.scheduler != null) {
            this.scheduler.scheduleTask((Runnable)this);
            ServiceHelper.startService((Object)this.scheduler);
            if (this.isStartScheduler()) {
                this.startScheduler();
            }
        }
    }

    public void startScheduler() {
        this.scheduler.startScheduler();
    }

    @Override
    protected void doStop() throws Exception {
        if (this.scheduler != null) {
            this.scheduler.unscheduleTask();
            ServiceHelper.stopAndShutdownServices((Object[])new Object[]{this.scheduler});
        }
        this.backoffCounter = 0;
        this.idleCounter = 0L;
        this.errorCounter = 0L;
        super.doStop();
    }

    protected void doShutdown() throws Exception {
        ServiceHelper.stopAndShutdownServices((Object[])new Object[]{this.scheduler});
        super.doShutdown();
    }

    protected void doSuspend() throws Exception {
    }

    public void onInit() throws Exception {
        this.startScheduler = true;
    }

    public long beforePoll(long timeout) throws Exception {
        this.log.trace("Before poll {}", (Object)this.getEndpoint());
        if (!ServiceHelper.resumeService((Object)this)) {
            ServiceHelper.startService((Object)this);
        }
        return Math.max(timeout, this.getDelay());
    }

    public void afterPoll() throws Exception {
        this.log.trace("After poll {}", (Object)this.getEndpoint());
        if (!ServiceHelper.suspendService((Object)this)) {
            ServiceHelper.stopService((Object)this);
        }
    }
}

