/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.camel.CamelContext;
import org.apache.camel.DelegateEndpoint;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.PollingConsumer;
import org.apache.camel.Processor;
import org.apache.camel.ResolveEndpointFailedException;
import org.apache.camel.Route;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.IntrospectionSupport;
import org.apache.camel.support.PatternHelper;
import org.apache.camel.support.PropertyBindingSupport;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.util.StringHelper;
import org.apache.camel.util.URISupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EndpointHelper {
    private static final Logger LOG = LoggerFactory.getLogger(EndpointHelper.class);
    private static final AtomicLong ENDPOINT_COUNTER = new AtomicLong(0L);

    private EndpointHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void pollEndpoint(Endpoint endpoint, Processor processor, long timeout) throws Exception {
        PollingConsumer consumer = endpoint.createPollingConsumer();
        try {
            Exchange exchange;
            ServiceHelper.startService((Object)consumer);
            while ((exchange = consumer.receive(timeout)) != null) {
                processor.process(exchange);
            }
        }
        finally {
            try {
                ServiceHelper.stopAndShutdownService((Object)consumer);
            }
            catch (Exception e) {
                LOG.warn("Failed to stop PollingConsumer: " + consumer + ". This example is ignored.", (Throwable)e);
            }
        }
    }

    public static void pollEndpoint(Endpoint endpoint, Processor processor) throws Exception {
        EndpointHelper.pollEndpoint(endpoint, processor, 1000L);
    }

    public static boolean matchEndpoint(CamelContext context, String uri, String pattern) {
        if (context != null) {
            try {
                uri = context.resolvePropertyPlaceholders(uri);
            }
            catch (Exception e) {
                throw new ResolveEndpointFailedException(uri, (Throwable)e);
            }
        }
        try {
            uri = URISupport.normalizeUri((String)uri);
        }
        catch (Exception e) {
            throw new ResolveEndpointFailedException(uri, (Throwable)e);
        }
        if (uri.contains("://")) {
            String scheme = StringHelper.before((String)uri, (String)"://");
            String path = StringHelper.after((String)uri, (String)"://");
            if (PatternHelper.matchPattern(scheme + ":" + path, pattern)) {
                return true;
            }
        } else {
            String scheme = StringHelper.before((String)uri, (String)":");
            String path = StringHelper.after((String)uri, (String)":");
            if (PatternHelper.matchPattern(scheme + "://" + path, pattern)) {
                return true;
            }
        }
        return PatternHelper.matchPattern(uri, pattern);
    }

    @Deprecated
    public static void setProperties(CamelContext context, Object bean, Map<String, Object> parameters) throws Exception {
        PropertyBindingSupport.bindProperties(context, bean, parameters);
    }

    @Deprecated
    public static void setReferenceProperties(CamelContext context, Object bean, Map<String, Object> parameters) throws Exception {
        Iterator<Map.Entry<String, Object>> it = parameters.entrySet().iterator();
        while (it.hasNext()) {
            boolean hit;
            Map.Entry<String, Object> entry = it.next();
            String name = entry.getKey();
            Object v = entry.getValue();
            String value = v != null ? v.toString() : null;
            if (!EndpointHelper.isReferenceParameter(value) || !(hit = IntrospectionSupport.setProperty(context, context.getTypeConverter(), bean, name, null, value, true))) continue;
            it.remove();
        }
    }

    public static boolean isReferenceParameter(String parameter) {
        return parameter != null && parameter.trim().startsWith("#");
    }

    public static <T> T resolveReferenceParameter(CamelContext context, String value, Class<T> type) {
        return EndpointHelper.resolveReferenceParameter(context, value, type, true);
    }

    public static <T> T resolveReferenceParameter(CamelContext context, String value, Class<T> type, boolean mandatory) {
        String valueNoHash = StringHelper.replaceAll((String)value, (String)"#", (String)"");
        if (mandatory) {
            return CamelContextHelper.mandatoryLookupAndConvert(context, valueNoHash, type);
        }
        return CamelContextHelper.lookupAndConvert(context, valueNoHash, type);
    }

    public static <T> List<T> resolveReferenceListParameter(CamelContext context, String value, Class<T> elementType) {
        if (value == null) {
            return new ArrayList();
        }
        List<String> elements = Arrays.asList(value.split(","));
        if (elements.size() == 1) {
            Object bean = EndpointHelper.resolveReferenceParameter(context, elements.get(0).trim(), Object.class);
            if (bean instanceof List) {
                return (List)bean;
            }
            ArrayList<T> singleElementList = new ArrayList<T>();
            singleElementList.add(elementType.cast(bean));
            return singleElementList;
        }
        ArrayList<T> result = new ArrayList<T>(elements.size());
        for (String element : elements) {
            result.add(EndpointHelper.resolveReferenceParameter(context, element.trim(), elementType));
        }
        return result;
    }

    public static <T> T resolveParameter(CamelContext context, String value, Class<T> type) {
        Object result = EndpointHelper.isReferenceParameter(value) ? EndpointHelper.resolveReferenceParameter(context, value, type) : context.getTypeConverter().convertTo(type, (Object)value);
        return result;
    }

    public static String getRouteIdFromEndpoint(Endpoint endpoint) {
        if (endpoint == null || endpoint.getCamelContext() == null) {
            return null;
        }
        List routes = endpoint.getCamelContext().getRoutes();
        for (Route route : routes) {
            if (!route.getEndpoint().equals(endpoint) && !route.getEndpoint().getEndpointKey().equals(endpoint.getEndpointKey())) continue;
            return route.getId();
        }
        return null;
    }

    public static String createEndpointId() {
        return "endpoint" + ENDPOINT_COUNTER.incrementAndGet();
    }

    public static String lookupEndpointRegistryId(Endpoint endpoint) {
        if (endpoint == null || endpoint.getCamelContext() == null) {
            return null;
        }
        Endpoint delegate = null;
        if (endpoint instanceof DelegateEndpoint) {
            delegate = ((DelegateEndpoint)endpoint).getEndpoint();
        }
        Map map = endpoint.getCamelContext().getRegistry().findByTypeWithName(Endpoint.class);
        for (Map.Entry entry : map.entrySet()) {
            if (!((Endpoint)entry.getValue()).equals(endpoint) && !((Endpoint)entry.getValue()).equals(delegate)) continue;
            return (String)entry.getKey();
        }
        return null;
    }

    public static ExchangePattern resolveExchangePatternFromUrl(String url) throws URISyntaxException {
        Map parameters;
        String pattern;
        int idx = url.indexOf("?");
        if (idx > 0) {
            url = url.substring(idx + 1);
        }
        if ((pattern = (String)(parameters = URISupport.parseQuery((String)url, (boolean)true)).get("exchangePattern")) != null) {
            return ExchangePattern.asEnum((String)pattern);
        }
        return null;
    }
}

