/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.metrics.messagehistory;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.MessageHistory;
import org.apache.camel.NamedNode;
import org.apache.camel.NonManagedService;
import org.apache.camel.StaticService;
import org.apache.camel.component.metrics.messagehistory.MetricsMessageHistory;
import org.apache.camel.component.metrics.messagehistory.MetricsMessageHistoryService;
import org.apache.camel.spi.MessageHistoryFactory;
import org.apache.camel.support.ServiceSupport;
import org.apache.camel.util.ObjectHelper;

public class MetricsMessageHistoryFactory
extends ServiceSupport
implements CamelContextAware,
StaticService,
NonManagedService,
MessageHistoryFactory {
    private CamelContext camelContext;
    private MetricsMessageHistoryService messageHistoryService;
    private MetricRegistry metricsRegistry;
    private boolean useJmx;
    private String jmxDomain = "org.apache.camel.metrics";
    private boolean prettyPrint;
    private TimeUnit rateUnit = TimeUnit.SECONDS;
    private TimeUnit durationUnit = TimeUnit.MILLISECONDS;
    private String namePattern = "##name##.##routeId##.##id##.##type##";

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public MetricRegistry getMetricsRegistry() {
        return this.metricsRegistry;
    }

    public void setMetricsRegistry(MetricRegistry metricsRegistry) {
        this.metricsRegistry = metricsRegistry;
    }

    public boolean isUseJmx() {
        return this.useJmx;
    }

    public void setUseJmx(boolean useJmx) {
        this.useJmx = useJmx;
    }

    public String getJmxDomain() {
        return this.jmxDomain;
    }

    public void setJmxDomain(String jmxDomain) {
        this.jmxDomain = jmxDomain;
    }

    public boolean isPrettyPrint() {
        return this.prettyPrint;
    }

    public void setPrettyPrint(boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
    }

    public TimeUnit getRateUnit() {
        return this.rateUnit;
    }

    public void setRateUnit(TimeUnit rateUnit) {
        this.rateUnit = rateUnit;
    }

    public TimeUnit getDurationUnit() {
        return this.durationUnit;
    }

    public void setDurationUnit(TimeUnit durationUnit) {
        this.durationUnit = durationUnit;
    }

    @Deprecated
    public MessageHistory newMessageHistory(String routeId, NamedNode namedNode, Date date) {
        return this.newMessageHistory(routeId, namedNode, date.getTime());
    }

    public MessageHistory newMessageHistory(String routeId, NamedNode namedNode, long timestamp) {
        Timer timer = this.metricsRegistry.timer(this.createName("history", routeId, namedNode.getId()));
        return new MetricsMessageHistory(routeId, namedNode, timer, timestamp);
    }

    private String createName(String type, String routeId, String id) {
        String name = this.camelContext.getManagementName() != null ? this.camelContext.getManagementName() : this.camelContext.getName();
        String answer = this.namePattern;
        answer = answer.replaceFirst("##name##", name);
        answer = answer.replaceFirst("##routeId##", routeId);
        answer = answer.replaceFirst("##id##", id);
        answer = answer.replaceFirst("##type##", type);
        return answer;
    }

    protected void doStart() throws Exception {
        try {
            this.messageHistoryService = (MetricsMessageHistoryService)this.camelContext.hasService(MetricsMessageHistoryService.class);
            if (this.messageHistoryService == null) {
                this.messageHistoryService = new MetricsMessageHistoryService();
                this.messageHistoryService.setMetricsRegistry(this.getMetricsRegistry());
                this.messageHistoryService.setUseJmx(this.isUseJmx());
                this.messageHistoryService.setJmxDomain(this.getJmxDomain());
                this.messageHistoryService.setPrettyPrint(this.isPrettyPrint());
                this.messageHistoryService.setRateUnit(this.getRateUnit());
                this.messageHistoryService.setDurationUnit(this.getDurationUnit());
                this.camelContext.addService((Object)this.messageHistoryService);
            }
        }
        catch (Exception e) {
            throw ObjectHelper.wrapRuntimeCamelException((Throwable)e);
        }
        if (this.metricsRegistry == null) {
            this.metricsRegistry = this.messageHistoryService.getMetricsRegistry();
        }
        ObjectHelper.notNull((Object)this.metricsRegistry, (String)"metricsRegistry", (Object)((Object)this));
    }

    protected void doStop() throws Exception {
    }
}

