/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.maven2.mar;

import java.io.File;
import java.io.IOException;
import org.apache.axis2.maven2.mar.AbstractMarMojo;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.archiver.MavenArchiver;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.archiver.jar.ManifestException;

public class MarMojo
extends AbstractMarMojo {
    private String outputDirectory;
    private String marName;
    private JarArchiver jarArchiver;
    private MavenArchiveConfiguration archive = new MavenArchiveConfiguration();
    private String classifier;
    private boolean primaryArtifact;
    private MavenProjectHelper projectHelper;

    public void execute() throws MojoExecutionException {
        File marFile = new File(this.outputDirectory, this.marName + ".mar");
        try {
            this.performPackaging(marFile);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error assembling mar", e);
        }
    }

    private void performPackaging(File marFile) throws IOException, ArchiverException, ManifestException, DependencyResolutionRequiredException, MojoExecutionException {
        this.buildExplodedMar();
        this.getLog().info((CharSequence)("Generating mar " + marFile.getAbsolutePath()));
        MavenArchiver archiver = new MavenArchiver();
        archiver.setArchiver(this.jarArchiver);
        archiver.setOutputFile(marFile);
        this.jarArchiver.addDirectory(this.marDirectory);
        archiver.createArchive(this.project, this.archive);
        if (this.classifier != null) {
            this.projectHelper.attachArtifact(this.project, "mar", this.classifier, marFile);
        } else {
            Artifact artifact = this.project.getArtifact();
            if (this.primaryArtifact) {
                artifact.setFile(marFile);
            } else if (artifact.getFile() == null || artifact.getFile().isDirectory()) {
                artifact.setFile(marFile);
            } else {
                this.projectHelper.attachArtifact(this.project, "mar", marFile);
            }
        }
    }
}

