/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amber.oauth2.common.validators;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.amber.oauth2.common.exception.OAuthProblemException;
import org.apache.amber.oauth2.common.utils.OAuthUtils;
import org.apache.amber.oauth2.common.validators.OAuthValidator;

public abstract class AbstractValidator<T extends HttpServletRequest>
implements OAuthValidator<T> {
    protected List<String> requiredParams = new ArrayList<String>();
    protected Map<String, String[]> optionalParams = new HashMap<String, String[]>();
    protected List<String> notAllowedParams = new ArrayList<String>();

    @Override
    public void validateMethod(T request) throws OAuthProblemException {
        if (!request.getMethod().equals("POST")) {
            throw OAuthUtils.handleOAuthProblemException("Method not set to POST.");
        }
    }

    @Override
    public void validateContentType(T request) throws OAuthProblemException {
        String contentType = request.getContentType();
        String expectedContentType = "application/x-www-form-urlencoded";
        if (!OAuthUtils.hasContentType(contentType, "application/x-www-form-urlencoded")) {
            throw OAuthUtils.handleBadContentTypeException("application/x-www-form-urlencoded");
        }
    }

    @Override
    public void validateRequiredParameters(T request) throws OAuthProblemException {
        HashSet<String> missingParameters = new HashSet<String>();
        for (String requiredParam : this.requiredParams) {
            String val = request.getParameter(requiredParam);
            if (!OAuthUtils.isEmpty(val)) continue;
            missingParameters.add(requiredParam);
        }
        if (!missingParameters.isEmpty()) {
            throw OAuthUtils.handleMissingParameters(missingParameters);
        }
    }

    @Override
    public void validateOptionalParameters(T request) throws OAuthProblemException {
        HashSet<String> missingParameters = new HashSet<String>();
        for (Map.Entry<String, String[]> requiredParam : this.optionalParams.entrySet()) {
            String[] dependentParams;
            String paramName = requiredParam.getKey();
            String val = request.getParameter(paramName);
            if (OAuthUtils.isEmpty(val) || OAuthUtils.hasEmptyValues(dependentParams = requiredParam.getValue())) continue;
            for (String dependentParam : dependentParams) {
                val = request.getParameter(dependentParam);
                if (!OAuthUtils.isEmpty(val)) continue;
                missingParameters.add(dependentParam);
            }
        }
        if (!missingParameters.isEmpty()) {
            throw OAuthUtils.handleMissingParameters(missingParameters);
        }
    }

    @Override
    public void validateNotAllowedParameters(T request) throws OAuthProblemException {
        ArrayList<String> notAllowedParameters = new ArrayList<String>();
        for (String requiredParam : this.notAllowedParams) {
            String val = request.getParameter(requiredParam);
            if (OAuthUtils.isEmpty(val)) continue;
            notAllowedParameters.add(requiredParam);
        }
        if (!notAllowedParameters.isEmpty()) {
            throw OAuthUtils.handleNotAllowedParametersOAuthException(notAllowedParameters);
        }
    }

    @Override
    public void performAllValidations(T request) throws OAuthProblemException {
        this.validateContentType(request);
        this.validateMethod(request);
        this.validateRequiredParameters(request);
        this.validateOptionalParameters(request);
        this.validateNotAllowedParameters(request);
    }
}

