/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oro.text.awk;

import java.util.BitSet;
import org.apache.oro.text.awk.LeafNode;
import org.apache.oro.text.awk.SyntaxNode;

class CharacterClassNode
extends LeafNode {
    BitSet _characterSet = new BitSet(257);

    CharacterClassNode(int position) {
        super(position);
    }

    void _addToken(int token) {
        this._characterSet.set(token);
    }

    void _addTokenRange(int min, int max) {
        while (min <= max) {
            this._characterSet.set(min++);
        }
    }

    @Override
    boolean _matches(char token) {
        return this._characterSet.get(token);
    }

    @Override
    SyntaxNode _clone(int[] pos) {
        int n = pos[0];
        pos[0] = n + 1;
        CharacterClassNode node = new CharacterClassNode(n);
        node._characterSet = (BitSet)this._characterSet.clone();
        return node;
    }
}

