/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oro.text.awk;

import java.io.IOException;
import java.io.Reader;

public final class AwkStreamInput {
    static final int _DEFAULT_BUFFER_INCREMENT = 2048;
    private Reader __searchStream;
    private int __bufferIncrementUnit;
    boolean _endOfStreamReached;
    int _bufferSize;
    int _bufferOffset;
    int _currentOffset;
    char[] _buffer;

    AwkStreamInput() {
        this._currentOffset = 0;
    }

    public AwkStreamInput(Reader input, int bufferIncrement) {
        this.__searchStream = input;
        this.__bufferIncrementUnit = bufferIncrement;
        this._buffer = new char[bufferIncrement];
        this._currentOffset = 0;
        this._bufferSize = 0;
        this._bufferOffset = 0;
        this._endOfStreamReached = false;
    }

    public AwkStreamInput(Reader input) {
        this(input, 2048);
    }

    int _reallocate(int initialOffset) throws IOException {
        if (this._endOfStreamReached) {
            return this._bufferSize;
        }
        int offset = this._bufferSize - initialOffset;
        char[] tmpBuffer = new char[offset + this.__bufferIncrementUnit];
        int bytesRead = this.__searchStream.read(tmpBuffer, offset, this.__bufferIncrementUnit);
        if (bytesRead <= 0) {
            this._endOfStreamReached = true;
            if (bytesRead == 0) {
                throw new IOException("read from input stream returned 0 bytes.");
            }
            return this._bufferSize;
        }
        this._bufferOffset += initialOffset;
        this._bufferSize = offset + bytesRead;
        System.arraycopy(this._buffer, initialOffset, tmpBuffer, 0, offset);
        this._buffer = tmpBuffer;
        return offset;
    }

    boolean read() throws IOException {
        this._bufferOffset += this._bufferSize;
        this._bufferSize = this.__searchStream.read(this._buffer);
        this._endOfStreamReached = this._bufferSize == -1;
        return !this._endOfStreamReached;
    }

    public boolean endOfStream() {
        return this._endOfStreamReached;
    }
}

