/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oro.text.awk;

import java.io.Serializable;
import java.util.BitSet;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.oro.text.awk.DFAState;
import org.apache.oro.text.awk.LeafNode;
import org.apache.oro.text.awk.SyntaxTree;
import org.apache.oro.text.regex.Pattern;

public final class AwkPattern
implements Pattern,
Serializable {
    static final int _INVALID_STATE = -1;
    static final int _START_STATE = 1;
    int _numStates;
    int _endPosition;
    int _options;
    String _expression;
    Vector _Dtrans;
    Vector[] _nodeList;
    Vector _stateList;
    BitSet _U;
    BitSet _emptySet;
    BitSet[] _followSet;
    BitSet _endStates;
    Hashtable _stateMap;
    boolean _matchesNullString;
    boolean[] _fastMap;
    boolean _hasBeginAnchor = false;
    boolean _hasEndAnchor = false;

    AwkPattern(String expression, SyntaxTree tree) {
        this._expression = expression;
        this._endPosition = tree._positions - 1;
        this._followSet = tree._followSet;
        this._Dtrans = new Vector();
        this._stateList = new Vector();
        this._endStates = new BitSet();
        this._U = new BitSet(tree._positions);
        this._U.or(tree._root._firstPosition());
        int[] tstateArray = new int[256];
        this._Dtrans.addElement(tstateArray);
        this._Dtrans.addElement(tstateArray);
        this._numStates = 1;
        if (this._U.get(this._endPosition)) {
            this._endStates.set(this._numStates);
        }
        DFAState dfaState = new DFAState((BitSet)this._U.clone(), this._numStates);
        this._stateMap = new Hashtable();
        this._stateMap.put(dfaState._state, dfaState);
        this._stateList.addElement(dfaState);
        this._stateList.addElement(dfaState);
        ++this._numStates;
        this._U.xor(this._U);
        this._emptySet = new BitSet(tree._positions);
        this._nodeList = new Vector[256];
        for (int token = 0; token < 256; ++token) {
            this._nodeList[token] = new Vector();
            for (int node = 0; node < tree._positions; ++node) {
                if (!tree._nodes[node]._matches((char)token)) continue;
                this._nodeList[token].addElement(tree._nodes[node]);
            }
        }
        this._fastMap = tree.createFastMap();
        this._matchesNullString = this._endStates.get(1);
    }

    void _createNewState(int current, int token, int[] tstateArray) {
        DFAState T = (DFAState)this._stateList.elementAt(current);
        int node = this._nodeList[token].size();
        this._U.xor(this._U);
        while (node-- > 0) {
            int pos = ((LeafNode)this._nodeList[token].elementAt((int)node))._position;
            if (!T._state.get(pos)) continue;
            this._U.or(this._followSet[pos]);
        }
        if (!this._stateMap.containsKey(this._U)) {
            DFAState dfaState = new DFAState((BitSet)this._U.clone(), this._numStates++);
            this._stateList.addElement(dfaState);
            this._stateMap.put(dfaState._state, dfaState);
            this._Dtrans.addElement(new int[256]);
            if (!this._U.equals(this._emptySet)) {
                tstateArray[token] = this._numStates - 1;
                if (this._U.get(this._endPosition)) {
                    this._endStates.set(this._numStates - 1);
                }
            } else {
                tstateArray[token] = -1;
            }
        } else {
            tstateArray[token] = this._U.equals(this._emptySet) ? -1 : ((DFAState)this._stateMap.get((Object)this._U))._stateNumber;
        }
    }

    int[] _getStateArray(int state) {
        return (int[])this._Dtrans.elementAt(state);
    }

    @Override
    public String getPattern() {
        return this._expression;
    }

    @Override
    public int getOptions() {
        return this._options;
    }
}

