/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.cache;

import java.util.Hashtable;
import java.util.List;
import org.anyline.data.param.Config;
import org.anyline.data.param.ConfigChain;
import org.anyline.data.param.ConfigStore;
import org.anyline.entity.DataRow;
import org.anyline.entity.OrderStore;
import org.anyline.entity.PageNavi;
import org.anyline.log.Log;
import org.anyline.log.LogProxy;
import org.anyline.metadata.Table;
import org.anyline.util.BasicUtil;
import org.anyline.util.ConfigTable;
import org.anyline.util.encrypt.MD5Util;

public class CacheUtil {
    private static final Log log = LogProxy.get(CacheUtil.class);
    private static Hashtable<String, Long> reflushFlag = new Hashtable();

    public static boolean start(String key, int sec) {
        boolean result = false;
        Long fr = reflushFlag.get(key);
        long age = -1L;
        if (null == fr) {
            result = true;
        } else {
            age = (System.currentTimeMillis() - fr) / 1000L;
            if (age > (long)sec) {
                result = true;
            }
        }
        if (result) {
            reflushFlag.put(key, System.currentTimeMillis());
            if (ConfigTable.IS_DEBUG && log.isInfoEnabled()) {
                log.info("[\u9891\u7387\u63a7\u5236\u653e\u884c][key:{}][\u95f4\u9694:{}/{}]", new Object[]{key, age, sec});
            }
        } else if (ConfigTable.IS_DEBUG && log.isInfoEnabled()) {
            log.info("[\u9891\u7387\u63a7\u5236\u62e6\u622a][key:{}][\u95f4\u9694:{}/{}]", new Object[]{key, age, sec});
        }
        return result;
    }

    public static boolean start(String key) {
        int period = ConfigTable.getInt((String)key, (int)120);
        return CacheUtil.start(key, period);
    }

    public static void stop(String key, int sec) {
        Long fr = reflushFlag.get(key);
        if (null == fr) {
            if (ConfigTable.IS_DEBUG && log.isInfoEnabled()) {
                log.info("[\u9891\u7387\u63a7\u5236\u8fd8\u539f\u5b8c\u6210 \u6709\u53ef\u80fdkey\u62fc\u5199\u6709\u8bef][key:{}]", (Object)key);
            }
            return;
        }
        long age = (System.currentTimeMillis() - fr) / 1000L;
        if (age > (long)sec) {
            reflushFlag.remove(key);
        }
        if (ConfigTable.IS_DEBUG && log.isInfoEnabled()) {
            log.info("[\u9891\u7387\u63a7\u5236\u8fd8\u539f\u5b8c\u6210][key:{}][\u95f4\u9694:{}/{}]", new Object[]{key, age, sec});
        }
    }

    public static void stop(String key) {
        int period = ConfigTable.getInt((String)key, (int)120);
        CacheUtil.stop(key, period);
    }

    public static boolean isRun(String key) {
        return null != reflushFlag.get(key);
    }

    public static long getRunTime(String key) {
        long result = -1L;
        Long fr = reflushFlag.get(key);
        if (null != fr) {
            return System.currentTimeMillis() - fr;
        }
        return result;
    }

    public static String crateCachePrimaryKey(String table, DataRow row) {
        Object key = table;
        List pks = row.getPrimaryKeys();
        if (BasicUtil.isNotEmpty((Object)pks) && null != row) {
            for (String pk : pks) {
                String value = row.getString(pk);
                key = (String)key + "|" + pk + "=" + value;
            }
        }
        return key;
    }

    public static String createCacheElementKey(boolean page, boolean order, String dest, ConfigStore store, String ... conditions) {
        conditions = BasicUtil.compress((String[])conditions);
        StringBuilder result = new StringBuilder(dest + "|");
        if (null != store) {
            OrderStore orders;
            List<Config> configs;
            ConfigChain chain = store.getConfigChain();
            if (null != chain && null != (configs = chain.getConfigs())) {
                for (Config config : configs) {
                    List<Object> values = config.getValues();
                    if (null == values) continue;
                    result.append(config).append("|");
                }
            }
            PageNavi navi = store.getPageNavi();
            if (page && null != navi) {
                result.append("page=").append(navi.getCurPage()).append("|first=").append(navi.getFirstRow()).append("|last=").append(navi.getLastRow()).append("|");
            }
            if (order && null != (orders = store.getOrders())) {
                result.append(orders.getRunText("").toUpperCase()).append("|");
            }
        }
        if (null != conditions) {
            for (String condition : conditions) {
                if (!BasicUtil.isNotEmpty((Object)condition)) continue;
                if (condition.trim().toUpperCase().startsWith("ORDER")) {
                    if (!order) continue;
                    result.append(condition.toUpperCase()).append("|");
                    continue;
                }
                result.append(condition).append("|");
            }
        }
        if (ConfigTable.IS_DEBUG && log.isInfoEnabled()) {
            log.info("[create cache key][key:{}]", (Object)result.toString());
        }
        return MD5Util.crypto((String)result.toString());
    }

    public static String createCacheElementKey(boolean page, boolean order, Table dest, ConfigStore store, String ... conditions) {
        String key = null;
        if (null != dest) {
            key = dest.toString();
        }
        return CacheUtil.createCacheElementKey(page, order, key, store, conditions);
    }
}

