/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.dao.init;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.anyline.adapter.PersistenceAdapter;
import org.anyline.annotation.Component;
import org.anyline.dao.AnylineDao;
import org.anyline.data.adapter.DriverAdapter;
import org.anyline.data.param.ConfigStore;
import org.anyline.data.param.init.DefaultConfigStore;
import org.anyline.data.prepare.RunPrepare;
import org.anyline.data.prepare.auto.init.DefaultTablePrepare;
import org.anyline.data.prepare.auto.init.DefaultTextPrepare;
import org.anyline.data.run.Run;
import org.anyline.data.runtime.DataRuntime;
import org.anyline.data.runtime.RuntimeHolder;
import org.anyline.data.util.DataSourceUtil;
import org.anyline.entity.Compare;
import org.anyline.entity.DataRow;
import org.anyline.entity.DataSet;
import org.anyline.entity.EntitySet;
import org.anyline.entity.PageNavi;
import org.anyline.entity.authorize.Privilege;
import org.anyline.entity.authorize.Role;
import org.anyline.entity.authorize.User;
import org.anyline.log.Log;
import org.anyline.log.LogProxy;
import org.anyline.metadata.Catalog;
import org.anyline.metadata.Column;
import org.anyline.metadata.Constraint;
import org.anyline.metadata.Database;
import org.anyline.metadata.ForeignKey;
import org.anyline.metadata.Function;
import org.anyline.metadata.Index;
import org.anyline.metadata.MasterTable;
import org.anyline.metadata.Metadata;
import org.anyline.metadata.PartitionTable;
import org.anyline.metadata.PrimaryKey;
import org.anyline.metadata.Procedure;
import org.anyline.metadata.Schema;
import org.anyline.metadata.Sequence;
import org.anyline.metadata.Table;
import org.anyline.metadata.Tag;
import org.anyline.metadata.Trigger;
import org.anyline.metadata.View;
import org.anyline.metadata.differ.MetadataDiffer;
import org.anyline.metadata.graph.EdgeTable;
import org.anyline.metadata.graph.VertexTable;
import org.anyline.metadata.persistence.ManyToMany;
import org.anyline.metadata.persistence.OneToMany;
import org.anyline.metadata.type.DatabaseType;
import org.anyline.proxy.EntityAdapterProxy;
import org.anyline.util.BasicUtil;
import org.anyline.util.BeanUtil;
import org.anyline.util.ClassUtil;
import org.anyline.util.ConfigTable;

@Component(value="anyline.dao")
public class DefaultDao<E>
implements AnylineDao<E> {
    protected static final Log log = LogProxy.get(DefaultDao.class);
    protected DataRuntime runtime = null;

    @Override
    public DataRuntime runtime() {
        if (null == this.runtime) {
            this.runtime = RuntimeHolder.runtime();
        }
        return this.runtime;
    }

    @Override
    public DriverAdapter adapter() {
        return this.runtime().getAdapter();
    }

    @Override
    public void setRuntime(DataRuntime runtime) {
        this.runtime = runtime;
    }

    public boolean fix() {
        return true;
    }

    @Override
    public List<Run> ddl(DataRuntime runtime, MetadataDiffer differ) {
        if (null == runtime) {
            runtime = this.runtime();
        }
        return runtime.getAdapter().ddl(runtime, null, differ);
    }

    @Override
    public List<Run> ddl(DataRuntime runtime, List<MetadataDiffer> differs) {
        if (null == runtime) {
            runtime = this.runtime();
        }
        return runtime.getAdapter().ddl(runtime, null, differs);
    }

    @Override
    public List<Map<String, Object>> maps(DataRuntime runtime, String random, RunPrepare prepare, ConfigStore configs, String ... conditions) {
        if (null == runtime) {
            runtime = this.runtime();
        }
        if (null != prepare && !prepare.disposable()) {
            prepare = prepare.clone();
        }
        return runtime.getAdapter().maps(runtime, random, prepare, configs, conditions);
    }

    @Override
    public DataSet querys(DataRuntime runtime, String random, RunPrepare prepare, ConfigStore configs, String ... conditions) {
        if (null == runtime) {
            runtime = this.runtime();
        }
        if (null != prepare && !prepare.disposable()) {
            prepare = prepare.clone();
        }
        return runtime.getAdapter().querys(runtime, null, prepare, configs, conditions);
    }

    @Override
    public <T> EntitySet<T> selects(DataRuntime runtime, String random, RunPrepare prepare, Class<T> clazz, ConfigStore configs, String ... conditions) {
        if (null == runtime) {
            runtime = this.runtime();
        }
        if (prepare != null && !prepare.disposable()) {
            prepare = prepare.clone();
        }
        EntitySet<T> set = runtime.getAdapter().selects(runtime, null, prepare, clazz, configs, conditions);
        int dependency = ConfigTable.ENTITY_FIELD_SELECT_DEPENDENCY;
        if (dependency > 0) {
            this.checkMany2ManyDependencyQuery(runtime, random, set, dependency);
            this.checkOne2ManyDependencyQuery(runtime, random, set, dependency);
        }
        return set;
    }

    @Override
    public DataRow sequence(DataRuntime runtime, String random, boolean next, String ... names) {
        if (null == runtime) {
            runtime = this.runtime();
        }
        return runtime.getAdapter().sequence(runtime, random, next, names);
    }

    @Override
    public long count(DataRuntime runtime, String random, RunPrepare prepare, ConfigStore configs, String ... conditions) {
        if (null == runtime) {
            runtime = this.runtime();
        }
        if (null != prepare && !prepare.disposable()) {
            prepare = prepare.clone();
        }
        return runtime.getAdapter().count(runtime, random, prepare, configs, conditions);
    }

    @Override
    public int length(DataRuntime runtime, String random, String cn, ConfigStore configs) {
        if (null == runtime) {
            runtime = this.runtime();
        }
        return runtime.getAdapter().length(runtime, null, cn, configs);
    }

    @Override
    public boolean exists(DataRuntime runtime, String random, RunPrepare prepare, ConfigStore configs, String ... conditions) {
        if (null == runtime) {
            runtime = this.runtime();
        }
        if (null != prepare && !prepare.disposable()) {
            prepare = prepare.clone();
        }
        return runtime.getAdapter().exists(runtime, random, prepare, configs, conditions);
    }

    @Override
    public long update(DataRuntime runtime, String random, int batch, Table dest, Object data, ConfigStore configs, List<String> columns) {
        long result;
        if (null == runtime) {
            runtime = this.runtime();
        }
        if ((result = runtime.getAdapter().update(runtime, random, batch, dest, data, configs, columns)) > 0L) {
            this.checkMany2ManyDependencySave(runtime, random, data, ConfigTable.ENTITY_FIELD_INSERT_DEPENDENCY, 1);
            this.checkOne2ManyDependencySave(runtime, random, data, ConfigTable.ENTITY_FIELD_INSERT_DEPENDENCY, 1);
        }
        return result;
    }

    @Override
    public long update(DataRuntime runtime, String random, int batch, String dest, Object data, ConfigStore configs, List<String> columns) {
        return this.update(runtime, random, batch, DataSourceUtil.parseDest(dest, data, configs), data, configs, columns);
    }

    @Override
    public long update(DataRuntime runtime, String random, RunPrepare prepare, DataRow data, ConfigStore configs, String ... conditions) {
        if (null == runtime) {
            runtime = this.runtime();
        }
        if (null != prepare && !prepare.disposable()) {
            prepare = prepare.clone();
        }
        return runtime.getAdapter().update(runtime, random, prepare, data, configs, conditions);
    }

    private int checkMany2ManyDependencySave(DataRuntime runtime, String random, Object obj, int dependency, int mode) {
        int result = 0;
        if (dependency <= 0) {
            return result;
        }
        if (obj instanceof DataSet || obj instanceof DataRow || obj instanceof Map) {
            return result;
        }
        if (obj instanceof EntitySet) {
            EntitySet set = (EntitySet)obj;
            for (Object entity : set) {
                this.checkMany2ManyDependencySave(runtime, random, entity, dependency, mode);
            }
        } else {
            Class<?> clazz = obj.getClass();
            Column pc = EntityAdapterProxy.primaryKey(clazz);
            String pk = null;
            if (null != pc) {
                pk = pc.getName();
            }
            List fields = ClassUtil.getFieldsByAnnotation(clazz, (String[])new String[]{"ManyToMany"});
            for (Field field : fields) {
                try {
                    long qty;
                    ManyToMany join = PersistenceAdapter.manyToMany((Field)field);
                    Map primaryValueMap = EntityAdapterProxy.primaryValue((Object)obj);
                    Object pv = primaryValueMap.get(pk.toUpperCase());
                    Object fv = BeanUtil.getFieldValue((Object)obj, (Field)field);
                    if (null == fv) continue;
                    DataSet set = new DataSet();
                    List fvs = new ArrayList();
                    if (null == join.dependencyTable) {
                        fvs = BeanUtil.object2list((Object)fv);
                    } else {
                        Column joinpc = EntityAdapterProxy.primaryKey(clazz);
                        String joinpk = null;
                        if (null != joinpc) {
                            joinpk = joinpc.getName();
                        }
                        if (fv.getClass().isArray()) {
                            int len = Array.getLength(fv);
                            for (int i = 0; i < len; ++i) {
                                fvs.add(EntityAdapterProxy.primaryValue((Object)Array.get(fv, i)).get(joinpk.toUpperCase()));
                            }
                        } else if (fv instanceof Collection) {
                            Collection objs = (Collection)fv;
                            for (Object item : objs) {
                                fvs.add(EntityAdapterProxy.primaryValue(item).get(joinpk.toUpperCase()));
                            }
                        }
                    }
                    for (Object item : fvs) {
                        DataRow row = new DataRow();
                        row.put(join.joinColumn, pv);
                        row.put(join.inverseJoinColumn, item);
                        set.add(row);
                    }
                    if (mode == 1 && (qty = runtime.getAdapter().deletes(runtime, random, join.joinTable, join.joinColumn, pv)) > 0L && ConfigTable.ENTITY_FIELD_DELETE_DEPENDENCY > 0 && !(obj instanceof DataRow)) {
                        this.checkMany2ManyDependencyDelete(runtime, random, obj, ConfigTable.ENTITY_FIELD_DELETE_DEPENDENCY);
                        this.checkOne2ManyDependencyDelete(runtime, random, obj, ConfigTable.ENTITY_FIELD_DELETE_DEPENDENCY);
                    }
                    runtime.getAdapter().save(runtime, random, join.joinTable, (Object)set, new String[0]);
                }
                catch (Exception e) {
                    if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                        log.error("check dependency exception:", (Throwable)e);
                        continue;
                    }
                    log.error("[check Many2ManyDependency Save][result:fail][msg:{}]", (Object)e.toString());
                }
            }
        }
        --dependency;
        return result;
    }

    private int checkOne2ManyDependencySave(DataRuntime runtime, String random, Object obj, int dependency, int mode) {
        int result = 0;
        if (dependency <= 0) {
            return result;
        }
        if (obj instanceof DataSet || obj instanceof DataRow || obj instanceof Map) {
            return result;
        }
        if (obj instanceof EntitySet) {
            EntitySet set = (EntitySet)obj;
            for (Object entity : set) {
                this.checkOne2ManyDependencySave(runtime, random, entity, dependency, mode);
            }
        } else {
            Class<?> clazz = obj.getClass();
            Column pc = EntityAdapterProxy.primaryKey(clazz);
            String pk = null;
            if (null != pc) {
                pk = pc.getName();
            }
            List fields = ClassUtil.getFieldsByAnnotation(clazz, (String[])new String[]{"OneToMany"});
            for (Field field : fields) {
                try {
                    long qty;
                    OneToMany join = PersistenceAdapter.oneToMany((Field)field);
                    Object pv = EntityAdapterProxy.primaryValue((Object)obj).get(pk.toUpperCase());
                    Object fv = BeanUtil.getFieldValue((Object)obj, (Field)field);
                    if (null == fv) continue;
                    if (null == join.joinField) {
                        throw new RuntimeException(field + "\u5173\u8054\u5c5e\u6027\u5f02\u5e38");
                    }
                    if (null == join.joinColumn) {
                        throw new RuntimeException(field + "\u5173\u8054\u5217\u5f02\u5e38");
                    }
                    if (null == join.dependencyTable) {
                        throw new RuntimeException(field + "\u5173\u8054\u8868\u5f02\u5e38");
                    }
                    if (mode == 1 && (qty = runtime.getAdapter().deletes(runtime, random, join.dependencyTable, join.joinColumn, pv)) > 0L && ConfigTable.ENTITY_FIELD_DELETE_DEPENDENCY > 0 && !(obj instanceof Map)) {
                        this.checkMany2ManyDependencyDelete(runtime, random, obj, ConfigTable.ENTITY_FIELD_DELETE_DEPENDENCY);
                        this.checkOne2ManyDependencyDelete(runtime, random, obj, ConfigTable.ENTITY_FIELD_DELETE_DEPENDENCY);
                    }
                    ArrayList<Object> items = new ArrayList<Object>();
                    if (fv.getClass().isArray()) {
                        int len = Array.getLength(fv);
                        for (int i = 0; i < len; ++i) {
                            Object item = Array.get(fv, i);
                            BeanUtil.setFieldValue((Object)item, (Field)join.joinField, pv);
                            items.add(item);
                        }
                    } else if (fv instanceof Collection) {
                        Collection cols = (Collection)fv;
                        for (Object item : cols) {
                            BeanUtil.setFieldValue((Object)item, (Field)join.joinField, pv);
                            items.add(item);
                        }
                    }
                    runtime.getAdapter().save(runtime, random, join.dependencyTable, items, new String[0]);
                }
                catch (Exception e) {
                    if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                        log.error("check dependency exception:", (Throwable)e);
                        continue;
                    }
                    log.error("[check One2ManyDependency Save][result:fail][msg:{}]", (Object)e.toString());
                }
            }
        }
        --dependency;
        return result;
    }

    protected <T> void checkMany2ManyDependencyQuery(DataRuntime runtime, String random, EntitySet<T> set, int dependency) {
        if (set.isEmpty() || dependency <= 0) {
            return;
        }
        --dependency;
        Class<?> clazz = set.get(0).getClass();
        Column pc = EntityAdapterProxy.primaryKey(clazz);
        String pk = null;
        if (null != pc) {
            pk = pc.getName();
        }
        List fields = ClassUtil.getFieldsByAnnotation(clazz, (String[])new String[]{"ManyToMany"});
        Compare compare = ConfigTable.ENTITY_FIELD_SELECT_DEPENDENCY_COMPARE;
        for (Field field : fields) {
            try {
                DefaultConfigStore conditions;
                String sql;
                ManyToMany join = PersistenceAdapter.manyToMany((Field)field);
                if (Compare.EQUAL == compare || set.size() == 1) {
                    for (Object entity : set) {
                        Map primaryValueMap = EntityAdapterProxy.primaryValue(entity);
                        if (null == join.dependencyTable) {
                            DataSet items = runtime.getAdapter().querys(runtime, random, new DefaultTablePrepare(join.joinTable), new DefaultConfigStore(new String[0]), "++" + join.joinColumn + ":" + primaryValueMap.get(pk.toUpperCase()));
                            List ids = items.getStrings(join.inverseJoinColumn);
                            BeanUtil.setFieldValue(entity, (Field)field, (Object)ids);
                            continue;
                        }
                        sql = "SELECT * FROM " + join.dependencyTable + " WHERE " + join.dependencyPk + " IN (SELECT " + join.inverseJoinColumn + " FROM " + join.joinTable + " WHERE " + join.joinColumn + "= #{JOIN_VALUE})";
                        DefaultConfigStore configs = new DefaultConfigStore(new String[0]);
                        configs.param("JOIN_VALUE", primaryValueMap.get(pk.toUpperCase()));
                        EntitySet dependencys = runtime.getAdapter().selects(runtime, random, new DefaultTextPrepare(sql), join.itemClass, configs, new String[0]);
                        BeanUtil.setFieldValue(entity, (Field)field, dependencys);
                    }
                    continue;
                }
                if (Compare.IN != compare) continue;
                ArrayList pvs = new ArrayList();
                HashMap idmap = new HashMap();
                for (Object entity : set) {
                    Map primaryValueMap = EntityAdapterProxy.primaryValue(entity);
                    Object pv = primaryValueMap.get(pk.toUpperCase());
                    pvs.add(pv);
                    idmap.put(entity, pv);
                }
                if (null == join.dependencyTable) {
                    conditions = new DefaultConfigStore(new String[0]);
                    conditions.and(join.joinColumn, (Object)pvs);
                    DataSet allItems = runtime.getAdapter().querys(runtime, random, new DefaultTablePrepare(join.joinTable), conditions, new String[0]);
                    for (Object entity : set) {
                        DataSet items = allItems.getRows(new String[]{join.joinColumn, "" + idmap.get(entity)});
                        List ids = items.getStrings(join.inverseJoinColumn);
                        BeanUtil.setFieldValue(entity, (Field)field, (Object)ids);
                    }
                    continue;
                }
                conditions = new DefaultConfigStore(new String[0]);
                conditions.param("JOIN_PVS", pvs);
                sql = "SELECT M.*, F." + join.joinColumn + " FK_" + join.joinColumn + " FROM " + join.dependencyTable + " M RIGHT JOIN " + join.joinTable + " F ON M." + join.dependencyPk + " = " + join.inverseJoinColumn + " WHERE " + join.joinColumn + " IN(#{JOIN_PVS})";
                DataSet alls = runtime.getAdapter().querys(runtime, random, new DefaultTextPrepare(sql), conditions, new String[0]);
                for (Object entity : set) {
                    DataSet items = alls.getRows(new String[]{"FK_" + join.joinColumn, "" + idmap.get(entity)});
                    BeanUtil.setFieldValue(entity, (Field)field, (Object)items.entity(join.itemClass));
                }
            }
            catch (Exception e) {
                if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                    log.error("check dependency exception:", (Throwable)e);
                    continue;
                }
                log.error("[check Many2ManyDependency query][result:fail][msg:{}]", (Object)e.toString());
            }
        }
    }

    private int checkMany2ManyDependencyDelete(DataRuntime runtime, String random, Object entity, int dependency) {
        int result = 0;
        if (dependency <= 0) {
            return result;
        }
        --dependency;
        Class<?> clazz = entity.getClass();
        Column pc = EntityAdapterProxy.primaryKey(clazz);
        String pk = null;
        if (null != pc) {
            pk = pc.getName();
        }
        List fields = ClassUtil.getFieldsByAnnotation(clazz, (String[])new String[]{"ManyToMany"});
        for (Field field : fields) {
            try {
                ManyToMany join = PersistenceAdapter.manyToMany((Field)field);
                runtime.getAdapter().deletes(runtime, random, join.joinTable, join.joinColumn, EntityAdapterProxy.primaryValue((Object)entity).get(pk.toUpperCase()));
            }
            catch (Exception e) {
                if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                    log.error("check dependenty exception:", (Throwable)e);
                    continue;
                }
                log.error("[check Many2ManyDependency delete][result:fail][msg:{}]", (Object)e.toString());
            }
        }
        return result;
    }

    private int checkOne2ManyDependencyDelete(DataRuntime runtime, String random, Object entity, int dependency) {
        int result = 0;
        if (dependency <= 0) {
            return result;
        }
        --dependency;
        Class<?> clazz = entity.getClass();
        Column pc = EntityAdapterProxy.primaryKey(clazz);
        String pk = null;
        if (null != pc) {
            pk = pc.getName();
        }
        List fields = ClassUtil.getFieldsByAnnotation(clazz, (String[])new String[]{"OneToMany"});
        for (Field field : fields) {
            try {
                OneToMany join = PersistenceAdapter.oneToMany((Field)field);
                runtime.getAdapter().deletes(runtime, random, join.dependencyTable, join.joinColumn, EntityAdapterProxy.primaryValue((Object)entity).get(pk.toUpperCase()));
            }
            catch (Exception e) {
                if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                    log.error("check dependency exception:", (Throwable)e);
                    continue;
                }
                log.error("[check One2ManyDependency delete][result:fail][msg:{}]", (Object)e.toString());
            }
        }
        return result;
    }

    protected <T> void checkOne2ManyDependencyQuery(DataRuntime runtime, String random, EntitySet<T> set, int dependency) {
        if (set.isEmpty() || dependency <= 0) {
            return;
        }
        --dependency;
        Class<?> clazz = set.get(0).getClass();
        Column pc = EntityAdapterProxy.primaryKey(clazz);
        String pk = null;
        if (null != pc) {
            pk = pc.getName();
        }
        List fields = ClassUtil.getFieldsByAnnotation(clazz, (String[])new String[]{"OneToMany"});
        Compare compare = ConfigTable.ENTITY_FIELD_SELECT_DEPENDENCY_COMPARE;
        for (Field field : fields) {
            try {
                OneToMany join = PersistenceAdapter.oneToMany((Field)field);
                if (Compare.EQUAL == compare || set.size() == 1) {
                    for (Object entity : set) {
                        Object pv = EntityAdapterProxy.primaryValue(entity).get(pk.toUpperCase());
                        Map primaryValueMap = EntityAdapterProxy.primaryValue(entity);
                        ArrayList params = new ArrayList();
                        params.add(primaryValueMap.get(pk.toUpperCase()));
                        EntitySet dependencys = runtime.getAdapter().selects(runtime, random, null, join.dependencyClass, new DefaultConfigStore(new String[0]).and(join.joinColumn, pv), new String[0]);
                        BeanUtil.setFieldValue(entity, (Field)field, dependencys);
                    }
                    continue;
                }
                if (Compare.IN != compare) continue;
                ArrayList pvs = new ArrayList();
                HashMap idmap = new HashMap();
                for (Object entity : set) {
                    Map primaryValueMap = EntityAdapterProxy.primaryValue(entity);
                    Object pv = primaryValueMap.get(pk.toUpperCase());
                    pvs.add(pv);
                    idmap.put(entity, pv);
                }
                DefaultConfigStore conditions = new DefaultConfigStore(new String[0]);
                conditions.and(join.joinColumn, (Object)pvs);
                EntitySet alls = runtime.getAdapter().selects(runtime, random, null, join.dependencyClass, conditions, new String[0]);
                for (Object entity : set) {
                    EntitySet items = alls.gets(join.joinField, idmap.get(entity));
                    BeanUtil.setFieldValue(entity, (Field)field, (Object)items);
                }
            }
            catch (Exception e) {
                if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                    log.error("check dependency exception:", (Throwable)e);
                    continue;
                }
                log.error("[check One2ManyDependency query][result:fail][msg:{}]", (Object)e.toString());
            }
        }
    }

    @Override
    public long save(DataRuntime runtime, String random, int batch, Table dest, Object data, ConfigStore configs, List<String> columns) {
        if (null == runtime) {
            runtime = this.runtime();
        }
        long result = runtime.getAdapter().save(runtime, random, dest, data, configs, columns);
        int ENTITY_FIELD_INSERT_DEPENDENCY = ConfigTable.ENTITY_FIELD_INSERT_DEPENDENCY;
        this.checkMany2ManyDependencySave(runtime, random, data, ENTITY_FIELD_INSERT_DEPENDENCY, 1);
        this.checkOne2ManyDependencySave(runtime, random, data, ENTITY_FIELD_INSERT_DEPENDENCY, 1);
        return result;
    }

    @Override
    public long save(DataRuntime runtime, String random, int batch, String dest, Object data, ConfigStore configs, List<String> columns) {
        return this.save(runtime, random, batch, DataSourceUtil.parseDest(dest, data, configs), data, configs, columns);
    }

    @Override
    public long insert(DataRuntime runtime, String random, int batch, Table dest, Object data, ConfigStore configs, List<String> columns) {
        if (null == runtime) {
            runtime = this.runtime();
        }
        long result = runtime.getAdapter().insert(runtime, random, batch, dest, data, configs, columns);
        int ENTITY_FIELD_INSERT_DEPENDENCY = ConfigTable.ENTITY_FIELD_INSERT_DEPENDENCY;
        this.checkMany2ManyDependencySave(runtime, random, data, ENTITY_FIELD_INSERT_DEPENDENCY, 0);
        this.checkOne2ManyDependencySave(runtime, random, data, ENTITY_FIELD_INSERT_DEPENDENCY, 0);
        return result;
    }

    @Override
    public long insert(DataRuntime runtime, String random, Table dest, RunPrepare prepare, ConfigStore configs, Object obj, String ... conditions) {
        if (null == runtime) {
            runtime = this.runtime();
        }
        if (null != prepare && !prepare.disposable()) {
            prepare = prepare.clone();
        }
        return runtime.getAdapter().insert(runtime, random, dest, prepare, configs, obj, conditions);
    }

    protected DataSet select(DataRuntime runtime, String random, boolean system, String table, ConfigStore configs, Run run) {
        if (null == runtime) {
            runtime = this.runtime();
        }
        return runtime.getAdapter().select(runtime, random, system, table, configs, run);
    }

    @Override
    public long execute(DataRuntime runtime, String random, RunPrepare prepare, ConfigStore configs, String ... conditions) {
        if (null == runtime) {
            runtime = this.runtime();
        }
        if (null != prepare && !prepare.disposable()) {
            prepare = prepare.clone();
        }
        return runtime.getAdapter().execute(runtime, random, prepare, configs, conditions);
    }

    @Override
    public long execute(DataRuntime runtime, String random, List<RunPrepare> prepares, ConfigStore configs) {
        if (null == runtime) {
            runtime = this.runtime();
        }
        ArrayList<RunPrepare> list = new ArrayList<RunPrepare>();
        for (RunPrepare prepare : prepares) {
            if (!prepare.disposable()) {
                list.add(prepare.clone());
                continue;
            }
            list.add(prepare);
        }
        return runtime.getAdapter().execute(runtime, random, list, configs);
    }

    @Override
    public long execute(DataRuntime runtime, String random, int batch, RunPrepare prepare, Collection<Object> values) {
        if (null == runtime) {
            runtime = this.runtime();
        }
        if (null != prepare && !prepare.disposable()) {
            prepare = prepare.clone();
        }
        return runtime.getAdapter().execute(runtime, random, batch, null, prepare, values);
    }

    @Override
    public long execute(DataRuntime runtime, String random, int batch, int vol, RunPrepare prepare, Collection<Object> values) {
        if (null == runtime) {
            runtime = this.runtime();
        }
        if (null != prepare && !prepare.disposable()) {
            prepare = prepare.clone();
        }
        return runtime.getAdapter().execute(runtime, random, batch, vol, null, prepare, values);
    }

    @Override
    public boolean execute(DataRuntime runtime, String random, Procedure procedure) {
        if (null == runtime) {
            runtime = this.runtime();
        }
        return runtime.getAdapter().execute(runtime, random, procedure);
    }

    @Override
    public DataSet querys(DataRuntime runtime, String random, Procedure procedure, PageNavi navi) {
        if (null == runtime) {
            runtime = this.runtime();
        }
        return runtime.getAdapter().querys(runtime, random, procedure, navi);
    }

    @Override
    public <T> long deletes(DataRuntime runtime, String random, int batch, Table table, String key, Collection<T> values) {
        if (null == runtime) {
            runtime = this.runtime();
        }
        return runtime.getAdapter().deletes(runtime, random, batch, table, key, values);
    }

    @Override
    public long delete(DataRuntime runtime, String random, Table dest, ConfigStore configs, Object obj, String ... columns) {
        long qty;
        if (null == runtime) {
            runtime = this.runtime();
        }
        if ((qty = runtime.getAdapter().delete(runtime, random, dest, configs, obj, columns)) > 0L && ConfigTable.ENTITY_FIELD_DELETE_DEPENDENCY > 0 && !(obj instanceof DataRow) && !(obj instanceof Collection)) {
            this.checkMany2ManyDependencyDelete(runtime, random, obj, ConfigTable.ENTITY_FIELD_DELETE_DEPENDENCY);
            this.checkOne2ManyDependencyDelete(runtime, random, obj, ConfigTable.ENTITY_FIELD_DELETE_DEPENDENCY);
        }
        return qty;
    }

    @Override
    public long delete(DataRuntime runtime, String random, Table table, ConfigStore configs, String ... conditions) {
        if (null == runtime) {
            runtime = this.runtime();
        }
        return runtime.getAdapter().delete(runtime, random, table, configs, conditions);
    }

    @Override
    public long truncate(DataRuntime runtime, String random, Table table) {
        if (null == runtime) {
            runtime = this.runtime();
        }
        return runtime.getAdapter().truncate(runtime, random, table);
    }

    @Override
    public DatabaseType type() {
        DataRuntime runtime = this.runtime();
        return runtime.getAdapter().type();
    }

    @Override
    public String version(DataRuntime runtime, String random) {
        if (null == runtime) {
            runtime = this.runtime();
        }
        return runtime.getAdapter().version(runtime, random);
    }

    @Override
    public String product(DataRuntime runtime, String random) {
        if (null == runtime) {
            runtime = this.runtime();
        }
        return runtime.getAdapter().product(runtime, random);
    }

    @Override
    public LinkedHashMap<String, Column> metadata(RunPrepare prepare, boolean comment) {
        DataRuntime runtime = this.runtime();
        if (null != prepare && !prepare.disposable()) {
            prepare = prepare.clone();
        }
        return runtime.getAdapter().metadata(runtime, prepare, comment);
    }

    @Override
    public Database database(DataRuntime runtime, String random) {
        if (null == runtime) {
            runtime = this.runtime();
        }
        return runtime.getAdapter().database(runtime, random);
    }

    @Override
    public <T extends Database> LinkedHashMap<String, T> databases(DataRuntime runtime, String random, String name) {
        if (null == runtime) {
            runtime = this.runtime();
        }
        return runtime.getAdapter().databases(runtime, random, name);
    }

    @Override
    public <T extends Database> List<T> databases(DataRuntime runtime, String random, boolean greedy, String name) {
        if (null == runtime) {
            runtime = this.runtime();
        }
        return runtime.getAdapter().databases(runtime, random, greedy, name);
    }

    @Override
    public Database database(DataRuntime runtime, String random, String name) {
        if (null == runtime) {
            runtime = this.runtime();
        }
        return runtime.getAdapter().database(runtime, random, name);
    }

    @Override
    public Catalog catalog(DataRuntime runtime, String random) {
        if (null == runtime) {
            runtime = this.runtime();
        }
        return runtime.getAdapter().catalog(runtime, random);
    }

    @Override
    public <T extends Catalog> LinkedHashMap<String, T> catalogs(DataRuntime runtime, String random, String name) {
        if (null == runtime) {
            runtime = this.runtime();
        }
        return runtime.getAdapter().catalogs(runtime, random, name);
    }

    @Override
    public <T extends Catalog> List<T> catalogs(DataRuntime runtime, String random, boolean greedy, String name) {
        if (null == runtime) {
            runtime = this.runtime();
        }
        return runtime.getAdapter().catalogs(runtime, random, greedy, name);
    }

    @Override
    public <T extends Schema> LinkedHashMap<String, T> schemas(DataRuntime runtime, String random, Catalog catalog, String name) {
        if (null == runtime) {
            runtime = this.runtime();
        }
        return runtime.getAdapter().schemas(runtime, random, catalog, name);
    }

    @Override
    public Schema schema(DataRuntime runtime, String random) {
        if (null == runtime) {
            runtime = this.runtime();
        }
        return runtime.getAdapter().schema(runtime, random);
    }

    @Override
    public <T extends Schema> List<T> schemas(DataRuntime runtime, String random, boolean greedy, Catalog catalog, String name) {
        if (null == runtime) {
            runtime = this.runtime();
        }
        return runtime.getAdapter().schemas(runtime, random, greedy, catalog, name);
    }

    @Override
    public <T extends Table> List<T> tables(DataRuntime runtime, String random, boolean greedy, Table query, int types, int struct, ConfigStore configs) {
        if (null == runtime) {
            runtime = this.runtime();
        }
        return runtime.getAdapter().tables(runtime, random, greedy, query, types, struct, configs);
    }

    @Override
    public <T extends Table> LinkedHashMap<String, T> tables(DataRuntime runtime, String random, Table query, int types, int struct, ConfigStore configs) {
        if (null == runtime) {
            runtime = this.runtime();
        }
        return runtime.getAdapter().tables(runtime, random, query, types, struct, configs);
    }

    @Override
    public <T extends VertexTable> List<T> vertexs(DataRuntime runtime, String random, boolean greedy, VertexTable query, int types, int struct, ConfigStore configs) {
        if (null == runtime) {
            runtime = this.runtime();
        }
        return runtime.getAdapter().vertexs(runtime, random, greedy, query, types, struct, configs);
    }

    @Override
    public <T extends VertexTable> LinkedHashMap<String, T> vertexs(DataRuntime runtime, String random, VertexTable quer, int types, int struct, ConfigStore configs) {
        if (null == runtime) {
            runtime = this.runtime();
        }
        return runtime.getAdapter().vertexs(runtime, random, quer, types, struct, configs);
    }

    @Override
    public <T extends EdgeTable> List<T> edges(DataRuntime runtime, String random, boolean greedy, EdgeTable query, int types, int struct, ConfigStore configs) {
        if (null == runtime) {
            runtime = this.runtime();
        }
        return runtime.getAdapter().edges(runtime, random, greedy, query, types, struct, configs);
    }

    @Override
    public <T extends EdgeTable> LinkedHashMap<String, T> edges(DataRuntime runtime, String random, EdgeTable query, int types, int struct, ConfigStore configs) {
        if (null == runtime) {
            runtime = this.runtime();
        }
        return runtime.getAdapter().edges(runtime, random, query, types, struct, configs);
    }

    @Override
    public List<String> ddl(DataRuntime runtime, String random, EdgeTable meta, boolean init) {
        if (null == runtime) {
            runtime = this.runtime();
        }
        return runtime.getAdapter().ddl(runtime, random, meta, init);
    }

    @Override
    public List<String> ddl(DataRuntime runtime, String random, VertexTable meta, boolean init) {
        if (null == runtime) {
            runtime = this.runtime();
        }
        return runtime.getAdapter().ddl(runtime, random, meta, init);
    }

    @Override
    public List<String> ddl(DataRuntime runtime, String random, Table table, boolean init) {
        if (null == runtime) {
            runtime = this.runtime();
        }
        return runtime.getAdapter().ddl(runtime, random, table, init);
    }

    @Override
    public <T extends View> List<T> views(DataRuntime runtime, String random, boolean greedy, View query, int types, int struct, ConfigStore configs) {
        if (null == runtime) {
            runtime = this.runtime();
        }
        return runtime.getAdapter().views(runtime, random, greedy, query, types, struct, configs);
    }

    @Override
    public <T extends View> LinkedHashMap<String, T> views(DataRuntime runtime, String random, View query, int types, int struct, ConfigStore configs) {
        if (null == runtime) {
            runtime = this.runtime();
        }
        return runtime.getAdapter().views(runtime, random, query, types, struct, configs);
    }

    @Override
    public List<String> ddl(DataRuntime runtime, String random, View view, boolean init) {
        return runtime.getAdapter().ddl(runtime, random, view, init);
    }

    @Override
    public <T extends MasterTable> List<T> masters(DataRuntime runtime, String random, boolean greedy, MasterTable query, int types, int struct, ConfigStore configs) {
        if (null == runtime) {
            runtime = this.runtime();
        }
        return runtime.getAdapter().masters(runtime, random, greedy, query, types, struct, configs);
    }

    @Override
    public <T extends MasterTable> LinkedHashMap<String, T> masters(DataRuntime runtime, String random, MasterTable query, int types, int struct, ConfigStore configs) {
        if (null == runtime) {
            runtime = this.runtime();
        }
        return runtime.getAdapter().masters(runtime, random, query, types, struct, configs);
    }

    @Override
    public Table.Partition partition(DataRuntime runtime, String random, Table table) {
        if (null == runtime) {
            runtime = this.runtime();
        }
        return runtime.getAdapter().partition(runtime, random, table);
    }

    @Override
    public <T extends PartitionTable> LinkedHashMap<String, T> partitions(DataRuntime runtime, String random, boolean greedy, PartitionTable query) {
        if (null == runtime) {
            runtime = this.runtime();
        }
        return runtime.getAdapter().partitions(runtime, random, greedy, query);
    }

    @Override
    public List<String> ddl(DataRuntime runtime, String random, PartitionTable table) {
        if (null == runtime) {
            runtime = this.runtime();
        }
        return runtime.getAdapter().ddl(runtime, random, table);
    }

    @Override
    public <T extends Column> LinkedHashMap<String, T> columns(DataRuntime runtime, String random, boolean greedy, Table table, boolean primary, ConfigStore configs) {
        if (null == runtime) {
            runtime = this.runtime();
        }
        return runtime.getAdapter().columns(runtime, random, greedy, table, primary, configs);
    }

    @Override
    public <T extends Column> List<T> columns(DataRuntime runtime, String random, boolean greedy, Column query, ConfigStore configs) {
        if (null == runtime) {
            runtime = this.runtime();
        }
        return runtime.getAdapter().columns(runtime, random, greedy, query, configs);
    }

    @Override
    public <T extends Tag> LinkedHashMap<String, T> tags(DataRuntime runtime, String random, boolean greedy, Table table, Tag query) {
        if (null == runtime) {
            runtime = this.runtime();
        }
        return runtime.getAdapter().tags(runtime, random, greedy, table);
    }

    @Override
    public PrimaryKey primary(DataRuntime runtime, String random, boolean greedy, Table table) {
        if (null == runtime) {
            runtime = this.runtime();
        }
        return runtime.getAdapter().primary(runtime, random, greedy, table);
    }

    @Override
    public <T extends ForeignKey> LinkedHashMap<String, T> foreigns(DataRuntime runtime, String random, boolean greedy, Table table) {
        if (null == runtime) {
            runtime = this.runtime();
        }
        return runtime.getAdapter().foreigns(runtime, random, greedy, table);
    }

    @Override
    public <T extends Index> List<T> indexes(DataRuntime runtime, String random, boolean greedy, Table table, String name) {
        if (null == runtime) {
            runtime = this.runtime();
        }
        return runtime.getAdapter().indexes(runtime, random, greedy, table, name);
    }

    @Override
    public <T extends Index> LinkedHashMap<String, T> indexes(DataRuntime runtime, String random, Table table, String name) {
        if (null == runtime) {
            runtime = this.runtime();
        }
        return runtime.getAdapter().indexes(runtime, random, table, name);
    }

    @Override
    public <T extends Constraint> List<T> constraints(DataRuntime runtime, String random, boolean greedy, Table table, String name) {
        if (null == runtime) {
            runtime = this.runtime();
        }
        return runtime.getAdapter().constraints(runtime, random, greedy, table, name);
    }

    @Override
    public <T extends Constraint> LinkedHashMap<String, T> constraints(DataRuntime runtime, String random, Table table, Column column, String name) {
        if (null == runtime) {
            runtime = this.runtime();
        }
        return runtime.getAdapter().constraints(runtime, random, table, column, name);
    }

    @Override
    public <T extends Trigger> LinkedHashMap<String, T> triggers(DataRuntime runtime, String random, boolean greedy, Table table, List<Trigger.EVENT> events) {
        if (null == runtime) {
            runtime = this.runtime();
        }
        return runtime.getAdapter().triggers(runtime, random, greedy, table, events);
    }

    @Override
    public <T extends Procedure> List<T> procedures(DataRuntime runtime, String random, boolean greedy, Catalog catalog, Schema schema, String name) {
        if (null == runtime) {
            runtime = this.runtime();
        }
        return runtime.getAdapter().procedures(runtime, random, greedy, catalog, schema, name);
    }

    @Override
    public <T extends Procedure> LinkedHashMap<String, T> procedures(DataRuntime runtime, String random, Catalog catalog, Schema schema, String name) {
        if (null == runtime) {
            runtime = this.runtime();
        }
        return runtime.getAdapter().procedures(runtime, random, catalog, schema, name);
    }

    @Override
    public List<String> ddl(DataRuntime runtime, String random, Procedure procedure) {
        if (null == runtime) {
            runtime = this.runtime();
        }
        return runtime.getAdapter().ddl(runtime, random, procedure);
    }

    @Override
    public <T extends Function> List<T> functions(DataRuntime runtime, String random, boolean greedy, Catalog catalog, Schema schema, String name) {
        if (null == runtime) {
            runtime = this.runtime();
        }
        return runtime.getAdapter().functions(runtime, random, greedy, catalog, schema, name);
    }

    @Override
    public <T extends Function> LinkedHashMap<String, T> functions(DataRuntime runtime, String random, Catalog catalog, Schema schema, String name) {
        if (null == runtime) {
            runtime = this.runtime();
        }
        return runtime.getAdapter().functions(runtime, random, catalog, schema, name);
    }

    @Override
    public List<String> ddl(DataRuntime runtime, String random, Function function) {
        if (null == runtime) {
            runtime = this.runtime();
        }
        return runtime.getAdapter().ddl(runtime, random, function);
    }

    @Override
    public <T extends Sequence> List<T> sequences(DataRuntime runtime, String random, boolean greedy, Catalog catalog, Schema schema, String name) {
        if (null == runtime) {
            runtime = this.runtime();
        }
        return runtime.getAdapter().sequences(runtime, random, greedy, catalog, schema, name);
    }

    @Override
    public <T extends Sequence> LinkedHashMap<String, T> sequences(DataRuntime runtime, String random, Catalog catalog, Schema schema, String name) {
        if (null == runtime) {
            runtime = this.runtime();
        }
        return runtime.getAdapter().sequences(runtime, random, catalog, schema, name);
    }

    @Override
    public List<String> ddl(DataRuntime runtime, String random, Sequence sequence) {
        if (null == runtime) {
            runtime = this.runtime();
        }
        return runtime.getAdapter().ddl(runtime, random, sequence);
    }

    @Override
    public <T extends Metadata> T parse(Class<T> type, String ddl, ConfigStore configs) {
        DataRuntime runtime = this.runtime();
        return runtime.getAdapter().parse(runtime, type, ddl, configs);
    }

    @Override
    public boolean create(Catalog meta) throws Exception {
        DataRuntime runtime = this.runtime();
        return runtime.getAdapter().create(runtime, meta);
    }

    @Override
    public boolean alter(Catalog meta) throws Exception {
        DataRuntime runtime = this.runtime();
        return runtime.getAdapter().alter(runtime, meta);
    }

    @Override
    public boolean drop(Catalog meta) throws Exception {
        DataRuntime runtime = this.runtime();
        return runtime.getAdapter().drop(runtime, meta);
    }

    @Override
    public boolean rename(Catalog origin, String name) throws Exception {
        DataRuntime runtime = this.runtime();
        return runtime.getAdapter().rename(runtime, origin, name);
    }

    @Override
    public boolean create(Schema meta) throws Exception {
        DataRuntime runtime = this.runtime();
        return runtime.getAdapter().create(runtime, meta);
    }

    @Override
    public boolean alter(Schema meta) throws Exception {
        DataRuntime runtime = this.runtime();
        return runtime.getAdapter().alter(runtime, meta);
    }

    @Override
    public boolean drop(Schema meta) throws Exception {
        DataRuntime runtime = this.runtime();
        return runtime.getAdapter().drop(runtime, meta);
    }

    @Override
    public boolean rename(Schema origin, String name) throws Exception {
        DataRuntime runtime = this.runtime();
        return runtime.getAdapter().rename(runtime, origin, name);
    }

    @Override
    public boolean create(Database meta) throws Exception {
        DataRuntime runtime = this.runtime();
        return runtime.getAdapter().create(runtime, meta);
    }

    @Override
    public boolean alter(Database meta) throws Exception {
        DataRuntime runtime = this.runtime();
        return runtime.getAdapter().alter(runtime, meta);
    }

    @Override
    public boolean drop(Database meta) throws Exception {
        DataRuntime runtime = this.runtime();
        return runtime.getAdapter().drop(runtime, meta);
    }

    @Override
    public boolean rename(Database origin, String name) throws Exception {
        DataRuntime runtime = this.runtime();
        return runtime.getAdapter().rename(runtime, origin, name);
    }

    @Override
    public boolean create(Table meta) throws Exception {
        DataRuntime runtime = this.runtime();
        return runtime.getAdapter().create(runtime, meta);
    }

    @Override
    public boolean alter(Table meta) throws Exception {
        DataRuntime runtime = this.runtime();
        return runtime.getAdapter().alter(runtime, meta);
    }

    @Override
    public boolean drop(Table meta) throws Exception {
        DataRuntime runtime = this.runtime();
        return runtime.getAdapter().drop(runtime, meta);
    }

    @Override
    public boolean rename(Table origin, String name) throws Exception {
        DataRuntime runtime = this.runtime();
        return runtime.getAdapter().rename(runtime, origin, name);
    }

    @Override
    public boolean create(View meta) throws Exception {
        DataRuntime runtime = this.runtime();
        return runtime.getAdapter().create(runtime, meta);
    }

    @Override
    public boolean alter(View meta) throws Exception {
        DataRuntime runtime = this.runtime();
        return runtime.getAdapter().alter(runtime, meta);
    }

    @Override
    public boolean drop(View meta) throws Exception {
        DataRuntime runtime = this.runtime();
        return runtime.getAdapter().drop(runtime, meta);
    }

    @Override
    public boolean rename(View origin, String name) throws Exception {
        DataRuntime runtime = this.runtime();
        return runtime.getAdapter().rename(runtime, origin, name);
    }

    @Override
    public boolean create(MasterTable meta) throws Exception {
        DataRuntime runtime = this.runtime();
        return runtime.getAdapter().create(runtime, meta);
    }

    @Override
    public boolean alter(MasterTable meta) throws Exception {
        DataRuntime runtime = this.runtime();
        return runtime.getAdapter().alter(runtime, meta);
    }

    @Override
    public boolean drop(MasterTable meta) throws Exception {
        DataRuntime runtime = this.runtime();
        return runtime.getAdapter().drop(runtime, meta);
    }

    @Override
    public boolean rename(MasterTable origin, String name) throws Exception {
        DataRuntime runtime = this.runtime();
        return runtime.getAdapter().rename(runtime, origin, name);
    }

    @Override
    public boolean create(PartitionTable meta) throws Exception {
        DataRuntime runtime = this.runtime();
        return runtime.getAdapter().create(runtime, meta);
    }

    @Override
    public boolean alter(PartitionTable meta) throws Exception {
        DataRuntime runtime = this.runtime();
        return runtime.getAdapter().create(runtime, meta);
    }

    @Override
    public boolean drop(PartitionTable meta) throws Exception {
        DataRuntime runtime = this.runtime();
        return runtime.getAdapter().drop(runtime, meta);
    }

    @Override
    public boolean rename(PartitionTable origin, String name) throws Exception {
        DataRuntime runtime = this.runtime();
        return runtime.getAdapter().rename(runtime, origin, name);
    }

    @Override
    public boolean add(Column meta) throws Exception {
        DataRuntime runtime = this.runtime();
        return runtime.getAdapter().add(runtime, meta);
    }

    @Override
    public boolean drop(Column meta) throws Exception {
        DataRuntime runtime = this.runtime();
        return runtime.getAdapter().drop(runtime, meta);
    }

    @Override
    public boolean alter(Table table, Column column) throws Exception {
        return this.alter(table, column, true);
    }

    @Override
    public boolean alter(Column meta) throws Exception {
        DataRuntime runtime = this.runtime();
        return runtime.getAdapter().alter(runtime, meta);
    }

    public boolean alter(Table table, Column meta, boolean trigger) throws Exception {
        DataRuntime runtime = this.runtime();
        return runtime.getAdapter().alter(runtime, table, meta, trigger);
    }

    @Override
    public boolean rename(Column origin, String name) throws Exception {
        DataRuntime runtime = this.runtime();
        return runtime.getAdapter().rename(runtime, origin, name);
    }

    @Override
    public boolean add(Tag meta) throws Exception {
        DataRuntime runtime = this.runtime();
        return runtime.getAdapter().add(runtime, meta);
    }

    @Override
    public boolean drop(Tag meta) throws Exception {
        DataRuntime runtime = this.runtime();
        return runtime.getAdapter().drop(runtime, meta);
    }

    @Override
    public boolean alter(Table table, Tag column) throws Exception {
        return this.alter(table, column, true);
    }

    @Override
    public boolean alter(Tag meta) throws Exception {
        DataRuntime runtime = this.runtime();
        return runtime.getAdapter().alter(runtime, meta);
    }

    public boolean alter(Table table, Tag meta, boolean trigger) throws Exception {
        DataRuntime runtime = this.runtime();
        return runtime.getAdapter().alter(runtime, table, meta, trigger);
    }

    @Override
    public boolean rename(Tag origin, String name) throws Exception {
        DataRuntime runtime = this.runtime();
        return runtime.getAdapter().rename(runtime, origin, name);
    }

    @Override
    public boolean add(PrimaryKey meta) throws Exception {
        DataRuntime runtime = this.runtime();
        return runtime.getAdapter().add(runtime, meta);
    }

    @Override
    public boolean alter(PrimaryKey meta) throws Exception {
        DataRuntime runtime = this.runtime();
        return runtime.getAdapter().alter(runtime, meta);
    }

    @Override
    public boolean alter(Table table, PrimaryKey meta) throws Exception {
        DataRuntime runtime = this.runtime();
        return runtime.getAdapter().alter(runtime, table, meta);
    }

    @Override
    public boolean drop(PrimaryKey meta) throws Exception {
        DataRuntime runtime = this.runtime();
        return runtime.getAdapter().drop(runtime, meta);
    }

    @Override
    public boolean rename(PrimaryKey origin, String name) throws Exception {
        DataRuntime runtime = this.runtime();
        return runtime.getAdapter().rename(runtime, origin, name);
    }

    @Override
    public boolean add(ForeignKey meta) throws Exception {
        DataRuntime runtime = this.runtime();
        return runtime.getAdapter().add(runtime, meta);
    }

    @Override
    public boolean alter(ForeignKey meta) throws Exception {
        DataRuntime runtime = this.runtime();
        return runtime.getAdapter().alter(runtime, meta);
    }

    @Override
    public boolean alter(Table table, ForeignKey meta) throws Exception {
        DataRuntime runtime = this.runtime();
        return runtime.getAdapter().alter(runtime, table, meta);
    }

    @Override
    public boolean drop(ForeignKey meta) throws Exception {
        DataRuntime runtime = this.runtime();
        return runtime.getAdapter().drop(runtime, meta);
    }

    @Override
    public boolean rename(ForeignKey origin, String name) throws Exception {
        DataRuntime runtime = this.runtime();
        return runtime.getAdapter().rename(runtime, origin, name);
    }

    @Override
    public boolean add(Index meta) throws Exception {
        DataRuntime runtime = this.runtime();
        return runtime.getAdapter().add(runtime, meta);
    }

    @Override
    public boolean alter(Index meta) throws Exception {
        DataRuntime runtime = this.runtime();
        return runtime.getAdapter().alter(runtime, meta);
    }

    @Override
    public boolean alter(Table table, Index meta) throws Exception {
        DataRuntime runtime = this.runtime();
        return runtime.getAdapter().alter(runtime, table, meta);
    }

    @Override
    public boolean drop(Index meta) throws Exception {
        DataRuntime runtime = this.runtime();
        return runtime.getAdapter().drop(runtime, meta);
    }

    @Override
    public boolean rename(Index origin, String name) throws Exception {
        DataRuntime runtime = this.runtime();
        return runtime.getAdapter().rename(runtime, origin, name);
    }

    @Override
    public boolean add(Constraint meta) throws Exception {
        DataRuntime runtime = this.runtime();
        return runtime.getAdapter().add(runtime, meta);
    }

    @Override
    public boolean alter(Constraint meta) throws Exception {
        DataRuntime runtime = this.runtime();
        return runtime.getAdapter().add(runtime, meta);
    }

    @Override
    public boolean alter(Table table, Constraint meta) throws Exception {
        DataRuntime runtime = this.runtime();
        return runtime.getAdapter().alter(runtime, table, meta);
    }

    @Override
    public boolean drop(Constraint meta) throws Exception {
        DataRuntime runtime = this.runtime();
        return runtime.getAdapter().drop(runtime, meta);
    }

    @Override
    public boolean rename(Constraint origin, String name) throws Exception {
        DataRuntime runtime = this.runtime();
        return runtime.getAdapter().rename(runtime, origin, name);
    }

    @Override
    public boolean add(Trigger meta) throws Exception {
        DataRuntime runtime = this.runtime();
        return runtime.getAdapter().add(runtime, meta);
    }

    @Override
    public boolean alter(Trigger meta) throws Exception {
        DataRuntime runtime = this.runtime();
        return runtime.getAdapter().alter(runtime, meta);
    }

    @Override
    public boolean drop(Trigger meta) throws Exception {
        DataRuntime runtime = this.runtime();
        return runtime.getAdapter().drop(runtime, meta);
    }

    @Override
    public boolean rename(Trigger origin, String name) throws Exception {
        DataRuntime runtime = this.runtime();
        return runtime.getAdapter().rename(runtime, origin, name);
    }

    @Override
    public boolean create(Procedure meta) throws Exception {
        DataRuntime runtime = this.runtime();
        return runtime.getAdapter().create(runtime, meta);
    }

    @Override
    public boolean alter(Procedure meta) throws Exception {
        DataRuntime runtime = this.runtime();
        return runtime.getAdapter().alter(runtime, meta);
    }

    @Override
    public boolean drop(Procedure meta) throws Exception {
        DataRuntime runtime = this.runtime();
        return runtime.getAdapter().drop(runtime, meta);
    }

    @Override
    public boolean rename(Procedure origin, String name) throws Exception {
        DataRuntime runtime = this.runtime();
        return runtime.getAdapter().rename(runtime, origin, name);
    }

    @Override
    public boolean create(Function meta) throws Exception {
        DataRuntime runtime = this.runtime();
        return runtime.getAdapter().create(runtime, meta);
    }

    @Override
    public boolean alter(Function meta) throws Exception {
        DataRuntime runtime = this.runtime();
        return runtime.getAdapter().alter(runtime, meta);
    }

    @Override
    public boolean drop(Function meta) throws Exception {
        DataRuntime runtime = this.runtime();
        return runtime.getAdapter().drop(runtime, meta);
    }

    @Override
    public boolean rename(Function origin, String name) throws Exception {
        DataRuntime runtime = this.runtime();
        return runtime.getAdapter().rename(runtime, origin, name);
    }

    @Override
    public boolean create(Sequence meta) throws Exception {
        DataRuntime runtime = this.runtime();
        return runtime.getAdapter().create(runtime, meta);
    }

    @Override
    public boolean alter(Sequence meta) throws Exception {
        DataRuntime runtime = this.runtime();
        return runtime.getAdapter().alter(runtime, meta);
    }

    @Override
    public boolean drop(Sequence meta) throws Exception {
        DataRuntime runtime = this.runtime();
        return runtime.getAdapter().drop(runtime, meta);
    }

    @Override
    public boolean rename(Sequence origin, String name) throws Exception {
        DataRuntime runtime = this.runtime();
        return runtime.getAdapter().rename(runtime, origin, name);
    }

    @Override
    public boolean create(Role role) throws Exception {
        DataRuntime runtime = this.runtime();
        return runtime.getAdapter().create(runtime, role);
    }

    @Override
    public <T extends Role> List<T> roles(DataRuntime runtime, String random, boolean greedy, Role query) throws Exception {
        if (null == runtime) {
            runtime = this.runtime();
        }
        return runtime.getAdapter().roles(runtime, random, greedy, query);
    }

    @Override
    public boolean rename(Role origin, Role update) throws Exception {
        DataRuntime runtime = this.runtime();
        return runtime.getAdapter().rename(runtime, origin, update);
    }

    @Override
    public boolean drop(Role role) throws Exception {
        DataRuntime runtime = this.runtime();
        return runtime.getAdapter().drop(runtime, role);
    }

    @Override
    public boolean create(User user) throws Exception {
        DataRuntime runtime = this.runtime();
        return runtime.getAdapter().create(runtime, user);
    }

    @Override
    public List<User> users(DataRuntime runtime, String random, boolean greedy, User query) throws Exception {
        return runtime.getAdapter().users(runtime, random, greedy, query);
    }

    @Override
    public boolean rename(User origin, User update) throws Exception {
        DataRuntime runtime = this.runtime();
        return runtime.getAdapter().rename(runtime, origin, update);
    }

    @Override
    public boolean drop(User user) throws Exception {
        DataRuntime runtime = this.runtime();
        return runtime.getAdapter().drop(runtime, user);
    }

    @Override
    public boolean grant(User user, Privilege ... privileges) throws Exception {
        DataRuntime runtime = this.runtime();
        return runtime.getAdapter().grant(runtime, user, privileges);
    }

    @Override
    public boolean grant(Role role, Privilege ... privileges) throws Exception {
        DataRuntime runtime = this.runtime();
        return runtime.getAdapter().grant(runtime, role, privileges);
    }

    @Override
    public boolean grant(User user, Role ... roles) throws Exception {
        DataRuntime runtime = this.runtime();
        return runtime.getAdapter().grant(runtime, user, roles);
    }

    @Override
    public List<Privilege> privileges(DataRuntime runtime, String random, boolean greedy, Privilege query) throws Exception {
        return runtime.getAdapter().privileges(runtime, random, greedy, query);
    }

    @Override
    public boolean revoke(User user, Privilege ... privileges) throws Exception {
        DataRuntime runtime = this.runtime();
        return runtime.getAdapter().revoke(runtime, user, privileges);
    }

    @Override
    public boolean revoke(Role role, Privilege ... privileges) throws Exception {
        DataRuntime runtime = this.runtime();
        return runtime.getAdapter().revoke(runtime, role, privileges);
    }

    @Override
    public boolean revoke(User user, Role ... roles) throws Exception {
        DataRuntime runtime = this.runtime();
        return runtime.getAdapter().revoke(runtime, user, roles);
    }

    private String random(DataRuntime runtime) {
        StringBuilder builder = new StringBuilder();
        builder.append("[cmd:").append(System.currentTimeMillis()).append("-").append(BasicUtil.getRandomNumberString((int)8)).append("][thread:").append(Thread.currentThread().getId()).append("][ds:").append(runtime.datasource()).append("]");
        return builder.toString();
    }
}

