/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.anyline.data.adapter.DriverAdapter;
import org.anyline.data.param.ConfigStore;
import org.anyline.data.prepare.Condition;
import org.anyline.data.prepare.RunPrepare;
import org.anyline.data.prepare.SyntaxHelper;
import org.anyline.data.prepare.Variable;
import org.anyline.data.prepare.VariableBlock;
import org.anyline.data.prepare.init.DefaultVariable;
import org.anyline.data.prepare.init.DefaultVariableBlock;
import org.anyline.data.run.Run;
import org.anyline.data.run.TextRun;
import org.anyline.data.runtime.DataRuntime;
import org.anyline.entity.Compare;
import org.anyline.log.Log;
import org.anyline.log.LogProxy;
import org.anyline.metadata.Column;
import org.anyline.util.BasicUtil;
import org.anyline.util.BeanUtil;
import org.anyline.util.SQLUtil;
import org.anyline.util.regular.Regular;
import org.anyline.util.regular.RegularUtil;

public class CommandParser {
    private Log log = LogProxy.get(CommandParser.class);

    public static void parseText(DataRuntime runtime, Run run) {
        RunPrepare prepare = run.getPrepare();
        if (null == prepare) {
            return;
        }
        CommandParser.parseText(runtime, run, prepare.getText());
        List<Condition> list = run.getConditionChain().getConditions();
        for (Condition item : list) {
            CommandParser.parseText(runtime, item, item.text(), run.getConfigs());
        }
    }

    public static void parseText(DataRuntime runtime, Condition condition, String text, ConfigStore configs) {
        if (BasicUtil.isEmpty((Object)text)) {
            return;
        }
        boolean supportSqlVarPlaceholderRegexExt = ConfigStore.IS_ENABLE_PLACEHOLDER_REGEX_EXT(configs) && runtime.getAdapter().supportSqlVarPlaceholderRegexExt(runtime);
        try {
            List boxes = RegularUtil.fetchs((String)text, (String)"\\$\\{.+?:.+?\\}", (Regular.MATCH_MODE)Regular.MATCH_MODE.CONTAIN);
            if (!boxes.isEmpty()) {
                VariableBlock block;
                String box = (String)((List)boxes.get(0)).get(0);
                String prev = RegularUtil.cut((String)text, (String[])new String[]{"${begin}", box});
                List<Variable> vars = CommandParser.parseTextVariable(supportSqlVarPlaceholderRegexExt, prev, Compare.EMPTY_VALUE_SWITCH.NULL);
                condition.addVariable(vars);
                if (!vars.isEmpty()) {
                    condition.setVariableType(1);
                }
                if (null != (block = CommandParser.parseTextVarBox(runtime, configs, text, box))) {
                    condition.addVariableBlock(block);
                    condition.addVariable(block.variables());
                }
                String next = RegularUtil.cut((String)text, (String[])new String[]{box, "${end}"});
                CommandParser.parseText(runtime, condition, next, configs);
            } else {
                List<Variable> vars = CommandParser.parseTextVariable(supportSqlVarPlaceholderRegexExt, text, Compare.EMPTY_VALUE_SWITCH.NULL);
                condition.addVariable(vars);
                if (!vars.isEmpty()) {
                    condition.setVariableType(1);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void parseText(DataRuntime runtime, Run run, String text) {
        if (BasicUtil.isEmpty((Object)text)) {
            return;
        }
        boolean supportSqlVarPlaceholderRegexExt = ConfigStore.IS_ENABLE_PLACEHOLDER_REGEX_EXT(run.getConfigs()) && runtime.getAdapter().supportSqlVarPlaceholderRegexExt(runtime);
        try {
            List boxes = RegularUtil.fetchs((String)text, (String)"\\$\\{.+?:.+?\\}", (Regular.MATCH_MODE)Regular.MATCH_MODE.CONTAIN);
            if (!boxes.isEmpty()) {
                String box = (String)((List)boxes.get(0)).get(0);
                String prev = RegularUtil.cut((String)text, (String[])new String[]{"${begin}", box});
                List<Variable> vars = CommandParser.parseTextVariable(supportSqlVarPlaceholderRegexExt, prev, Compare.EMPTY_VALUE_SWITCH.NULL);
                run.addVariable(vars);
                VariableBlock block = CommandParser.parseTextVarBox(runtime, run.getConfigs(), text, box);
                if (null != block) {
                    run.addVariableBlock(block);
                    run.addVariable(block.variables());
                }
                String next = RegularUtil.cut((String)text, (String[])new String[]{box, "${end}"});
                CommandParser.parseText(runtime, run, next);
            } else {
                List<Variable> vars = CommandParser.parseTextVariable(supportSqlVarPlaceholderRegexExt, text, Compare.EMPTY_VALUE_SWITCH.NULL);
                run.addVariable(vars);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static List<Variable> parseTextVariable(boolean supportSqlVarPlaceholderRegexExt, String text, Compare.EMPTY_VALUE_SWITCH emptyValueSwitch) {
        ArrayList<Variable> vars = new ArrayList<Variable>();
        if (null == text) {
            return vars;
        }
        try {
            int type = 0;
            List keys = RegularUtil.fetchs((String)text, (String)"([^\\s\\$#]+)\\s*\\(?(\\s*[\\$|#]*{\\w+})(\\+|\\s|'|\\)|%)?", (Regular.MATCH_MODE)Regular.MATCH_MODE.CONTAIN);
            type = 2;
            if (keys.isEmpty() && supportSqlVarPlaceholderRegexExt) {
                keys = RegularUtil.fetchs((String)text, (String)"(\\S+)\\s*\\(?(\\s*:+[A-Za-z]\\w+)(\\s|'|\\)|%|\\, )?", (Regular.MATCH_MODE)Regular.MATCH_MODE.CONTAIN);
                type = 1;
            }
            if (BasicUtil.isNotEmpty((boolean)true, (Object)keys)) {
                for (int i = 0; i < keys.size(); ++i) {
                    List keyItem = (List)keys.get(i);
                    Variable var = SyntaxHelper.buildVariable(type, (String)keyItem.get(0), (String)keyItem.get(1), (String)keyItem.get(2), (String)keyItem.get(3));
                    if (null == var) continue;
                    var.setSwt(emptyValueSwitch);
                    vars.add(var);
                }
            } else {
                int qty = SQLUtil.countPlaceholder((String)text);
                if (qty > 0) {
                    for (int i = 0; i < qty; ++i) {
                        DefaultVariable var = new DefaultVariable();
                        var.setType(0);
                        var.setSwt(emptyValueSwitch);
                        vars.add(var);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return vars;
    }

    public static VariableBlock parseTextVarBox(DataRuntime runtime, ConfigStore configs, String text, String box) {
        if (null != box) {
            box = box.trim();
            String body = box.substring(2, box.length() - 1);
            boolean supportSqlVarPlaceholderRegexExt = ConfigStore.IS_ENABLE_PLACEHOLDER_REGEX_EXT(configs) && runtime.getAdapter().supportSqlVarPlaceholderRegexExt(runtime);
            List<Variable> vars = CommandParser.parseTextVariable(supportSqlVarPlaceholderRegexExt, body, Compare.EMPTY_VALUE_SWITCH.IGNORE);
            DefaultVariableBlock block = new DefaultVariableBlock(box, body);
            block.variables(vars);
            return block;
        }
        return null;
    }

    public static String replaceVariable(DataRuntime runtime, TextRun run, List<VariableBlock> blocks, List<Variable> variables, String text) {
        if (null != blocks) {
            for (VariableBlock block : blocks) {
                String box = block.box();
                String body = block.body();
                boolean active = block.active();
                if (!active) {
                    text = text.replace(box, "");
                    variables.removeAll(block.variables());
                    continue;
                }
                text = text.replace(box, body);
            }
        }
        text = CommandParser.replaceVariable(runtime, run, variables, text);
        return text;
    }

    private static String replaceVariable(DataRuntime runtime, Run run, List<Variable> variables, String text) {
        DriverAdapter adapter = runtime.getAdapter();
        boolean supportPlaceholder = adapter.supportPlaceholder();
        if (null != text && supportPlaceholder && null != variables) {
            List<Object> varValues;
            Object value;
            List<Object> values;
            for (Variable var : variables) {
                if (null == var || var.getType() != 3) continue;
                values = var.getValues();
                value = null;
                if (BasicUtil.isNotEmpty((boolean)true, values)) {
                    value = var.getCompare() == Compare.IN ? BeanUtil.concat((Collection)BeanUtil.wrap(values, (String)"'")) : values.get(0).toString();
                }
                if (null != value) {
                    text = text.replace(var.getFullKey(), (CharSequence)value);
                    continue;
                }
                text = text.replace(var.getFullKey(), "NULL");
            }
            for (Variable var : variables) {
                if (null == var || var.getType() != 2) continue;
                values = var.getValues();
                value = null;
                if (BasicUtil.isNotEmpty((boolean)true, values)) {
                    value = var.getCompare() == Compare.IN ? BeanUtil.concat((Collection)BeanUtil.wrap(values, (String)"'")) : values.get(0).toString();
                }
                if (null != value) {
                    text = text.replace(var.getFullKey(), (CharSequence)value);
                    continue;
                }
                text = text.replace(var.getFullKey(), "");
            }
            for (Variable var : variables) {
                if (null == var || var.getType() != 1) continue;
                varValues = var.getValues();
                if (run.getBatch() > 1) {
                    text = text.replace(var.getFullKey(), "?");
                    continue;
                }
                if (BasicUtil.isNotEmpty((boolean)true, varValues)) {
                    if (var.getCompare() == Compare.IN) {
                        Object replaceDst = "";
                        for (Object tmp : varValues) {
                            replaceDst = (String)replaceDst + " ?";
                        }
                        adapter.addRunValue(runtime, run, Compare.IN, new Column(var.getKey()), varValues);
                        replaceDst = ((String)replaceDst).trim().replace(" ", ",");
                        text = text.replace(var.getFullKey(), (CharSequence)replaceDst);
                        continue;
                    }
                    text = text.replace(var.getFullKey(), "?");
                    adapter.addRunValue(runtime, run, Compare.EQUAL, new Column(var.getKey()), varValues.get(0));
                    continue;
                }
                text = text.replace(var.getFullKey(), "NULL");
            }
            for (Variable var : variables) {
                if (null == var || var.getType() != 0) continue;
                varValues = var.getValues();
                value = null;
                if (BasicUtil.isNotEmpty((boolean)true, varValues)) {
                    value = varValues.get(0);
                }
                adapter.addRunValue(runtime, run, Compare.EQUAL, new Column(var.getKey()), value);
            }
        }
        return text;
    }

    public static String replaceVariable(DataRuntime runtime, List<VariableBlock> blocks, List<Variable> variables, String text) {
        if (null != blocks) {
            for (VariableBlock block : blocks) {
                String box = block.box();
                String body = block.body();
                boolean active = block.active();
                if (!active) {
                    text = text.replace(box, "");
                    variables.removeAll(block.variables());
                    continue;
                }
                text = text.replace(box, body);
            }
        }
        text = CommandParser.replaceVariable(runtime, variables, text);
        return text;
    }

    private static String replaceVariable(DataRuntime runtime, List<Variable> variables, String text) {
        DriverAdapter adapter = runtime.getAdapter();
        boolean supportPlaceholder = adapter.supportPlaceholder();
        if (null != text && supportPlaceholder && null != variables) {
            List<Object> varValues;
            Object value;
            List<Object> values;
            for (Variable var : variables) {
                if (null == var || var.getType() != 3) continue;
                values = var.getValues();
                value = null;
                if (BasicUtil.isNotEmpty((boolean)true, values)) {
                    value = var.getCompare() == Compare.IN ? BeanUtil.concat((Collection)BeanUtil.wrap(values, (String)"'")) : values.get(0).toString();
                }
                if (null != value) {
                    text = text.replace(var.getFullKey(), (CharSequence)value);
                    continue;
                }
                text = text.replace(var.getFullKey(), "NULL");
            }
            for (Variable var : variables) {
                if (null == var || var.getType() != 2) continue;
                values = var.getValues();
                value = null;
                if (BasicUtil.isNotEmpty((boolean)true, values)) {
                    value = var.getCompare() == Compare.IN ? BeanUtil.concat((Collection)BeanUtil.wrap(values, (String)"'")) : values.get(0).toString();
                }
                if (null != value) {
                    text = text.replace(var.getFullKey(), (CharSequence)value);
                    continue;
                }
                text = text.replace(var.getFullKey(), "");
            }
            for (Variable var : variables) {
                if (null == var || var.getType() != 1) continue;
                varValues = var.getValues();
                if (BasicUtil.isNotEmpty((boolean)true, varValues)) {
                    if (var.getCompare() == Compare.IN) {
                        Object replaceDst = "";
                        for (Object tmp : varValues) {
                            replaceDst = (String)replaceDst + " ?";
                        }
                        replaceDst = ((String)replaceDst).trim().replace(" ", ",");
                        text = text.replace(var.getFullKey(), (CharSequence)replaceDst);
                        continue;
                    }
                    text = text.replace(var.getFullKey(), "?");
                    continue;
                }
                text = text.replace(var.getFullKey(), "NULL");
            }
            for (Variable var : variables) {
                if (null == var || var.getType() != 0) continue;
                varValues = var.getValues();
                value = null;
                if (!BasicUtil.isNotEmpty((boolean)true, varValues)) continue;
                value = varValues.get(0);
            }
        }
        return text;
    }
}

