/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.datasource;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.anyline.data.adapter.DriverAdapter;
import org.anyline.data.datasource.DataSourceKeyMap;
import org.anyline.data.runtime.DataRuntime;
import org.anyline.data.runtime.RuntimeHolder;
import org.anyline.data.util.DataSourceUtil;
import org.anyline.log.Log;
import org.anyline.log.LogProxy;
import org.anyline.metadata.Database;
import org.anyline.metadata.type.DatabaseType;
import org.anyline.proxy.ServiceProxy;
import org.anyline.service.AnylineService;
import org.anyline.util.BeanUtil;
import org.anyline.util.ClassUtil;
import org.anyline.util.ConfigTable;

public interface DataSourceHolder {
    public static final Log log = LogProxy.get(DataSourceHolder.class);
    public static final Map<String, Map<String, Object>> params = new HashMap<String, Map<String, Object>>();
    public static final Map<Object, DataSourceHolder> instances = new HashMap<Object, DataSourceHolder>();
    public static final Map<String, Object> caches = new HashMap<String, Object>();

    public static void register(Object check, DataSourceHolder holder) {
        if (check instanceof String) {
            check = ((String)check).toUpperCase();
        }
        instances.put(check, holder);
    }

    public static DataSourceHolder instance(DataRuntime runtime) {
        Object processor = runtime.getProcessor();
        Class<?> clazz = processor.getClass();
        DataSourceHolder holder = DataSourceHolder.instance(clazz);
        return holder;
    }

    public static DataSourceHolder instance(DatabaseType type) {
        return instances.get(type);
    }

    public static DataSourceHolder instance(Class clazz) {
        DataSourceHolder holder = instances.get(clazz);
        if (null == holder) {
            for (Object item : instances.keySet()) {
                if (!(item instanceof Class)) continue;
                Class c = (Class)item;
                if (!ClassUtil.isInSub((Class)clazz, (Class[])new Class[]{c})) continue;
                DataSourceHolder h = instances.get(c);
                instances.put(clazz, h);
                holder = h;
                break;
            }
        }
        if (instances.isEmpty()) {
            log.warn("[\u6ca1\u6709\u53ef\u7528\u7684DataSourceHolder][\u6709\u53ef\u80fd\u662f\u4e0a\u4e0b\u6587\u6ca1\u6709\u52a0\u8f7d\u5b8c\u6210 \u6216 pom\u4e2d\u6ca1\u6709\u4f9d\u8d56anyline-environment-* \u6216 \u7eafJava\u73af\u5883\u6ca1\u6709\u542f\u52a8DefaultEnvironmentWorker.start()]");
        }
        return holder;
    }

    public static DataSourceHolder instance(String check) {
        String adapter;
        DataSourceHolder holder = instances.get(check.toUpperCase());
        if (null == holder) {
            try {
                DataRuntime runtime = RuntimeHolder.runtime(check);
                if (null != runtime) {
                    holder = DataSourceHolder.instance(runtime);
                }
            }
            catch (Exception runtime) {
                // empty catch block
            }
        }
        if (null == holder && check.contains("://")) {
            String[] chks = check.split("://");
            holder = instances.get(chks[0]);
        }
        if (null == holder && null != (adapter = DataSourceUtil.parseAdapterKey(check))) {
            holder = instances.get(adapter.toUpperCase());
        }
        return holder;
    }

    public static DataSourceHolder instance(Object chk) {
        DataSourceHolder holder = null;
        if (chk instanceof DataRuntime) {
            holder = DataSourceHolder.instance((DataRuntime)chk);
        } else if (chk instanceof Class) {
            holder = DataSourceHolder.instance((Class)chk);
        } else if (chk instanceof DatabaseType) {
            holder = DataSourceHolder.instance((DatabaseType)chk);
        } else if (chk instanceof String) {
            holder = DataSourceHolder.instance((String)chk);
        }
        return holder;
    }

    public static String reg(String key, String pool, String driver, String url, String user, String password) throws Exception {
        DataSourceHolder instance = DataSourceHolder.instance(pool);
        if (null == instance) {
            instance = DataSourceHolder.instance(driver);
        }
        if (null == instance) {
            instance = DataSourceHolder.instance(url);
        }
        if (null != instance) {
            return instance.create(key, pool, driver, url, user, password);
        }
        return null;
    }

    public static String reg(String key, DatabaseType type, String url, String user, String password) throws Exception {
        DataSourceHolder instance = DataSourceHolder.instance(type);
        if (null == instance) {
            instance = DataSourceHolder.instance(url);
        }
        if (null != instance) {
            return instance.create(key, type, url, user, password);
        }
        return null;
    }

    public static String reg(String key, Map<String, Object> param) throws Exception {
        return DataSourceHolder.reg(key, param, (DatabaseType)null, true);
    }

    public static String reg(String key, Map<String, Object> param, boolean override) throws Exception {
        return DataSourceHolder.reg(key, param, (DatabaseType)null, override);
    }

    public static String reg(String key, Map<String, Object> param, DatabaseType type) throws Exception {
        return DataSourceHolder.reg(key, param, type, true);
    }

    public static String reg(String key, Map<String, Object> param, DatabaseType type, boolean override) throws Exception {
        DataSourceHolder instance = null;
        if (null == instance) {
            instance = DataSourceHolder.instance((String)BeanUtil.value(param, (String)"adapter", DataSourceKeyMap.maps, String.class, null));
        }
        if (null == instance && null != type) {
            instance = DataSourceHolder.instance(type);
        }
        if (null == instance) {
            instance = DataSourceHolder.instance((String)BeanUtil.value(param, (String)"driver", DataSourceKeyMap.maps, String.class, null));
        }
        if (null == instance) {
            instance = DataSourceHolder.instance((String)BeanUtil.value(param, (String)"type", DataSourceKeyMap.maps, String.class, null));
        }
        if (null == instance) {
            instance = DataSourceHolder.instance((String)BeanUtil.value(param, (String)"url", DataSourceKeyMap.maps, String.class, null));
        }
        if (!param.containsKey("adapter") && null != type) {
            param.put("adapter", type.name());
        }
        if (null != instance) {
            return instance.create(key, param, override);
        }
        throw new Exception("DataSourceHolder\u5b9e\u4f8b\u5f02\u5e38");
    }

    public static DataRuntime reg(String key, Object datasource, String database, DatabaseType type, DriverAdapter adapter, boolean override) throws Exception {
        DataSourceHolder instance = null;
        if (null != datasource) {
            instance = DataSourceHolder.instance(datasource.getClass());
        }
        if (null == instance) {
            instance = DataSourceHolder.instance(type);
        }
        if (null != instance) {
            return instance.create(key, datasource, database, type, adapter, override);
        }
        return null;
    }

    public static DataRuntime reg(String key, Object datasource, String database, boolean override) throws Exception {
        return DataSourceHolder.reg(key, datasource, database, null, null, override);
    }

    public static DataRuntime reg(String key, Object datasource, boolean override) throws Exception {
        return DataSourceHolder.reg(key, datasource, (String)null, override);
    }

    public static DataRuntime reg(String key, Object datasource, String database) throws Exception {
        return DataSourceHolder.reg(key, datasource, database, true);
    }

    public static DataRuntime reg(String key, Object datasource) throws Exception {
        return DataSourceHolder.reg(key, datasource, (String)null, true);
    }

    public static DataRuntime reg(String key, Object datasource, DatabaseType type, boolean override) throws Exception {
        return DataSourceHolder.reg(key, datasource, null, type, null, override);
    }

    public static DataRuntime reg(String key, Object datasource, String database, DatabaseType type) throws Exception {
        return DataSourceHolder.reg(key, datasource, database, type, null, true);
    }

    public static DataRuntime reg(String key, Object datasource, DatabaseType type) throws Exception {
        return DataSourceHolder.reg(key, datasource, null, type, null, true);
    }

    public static boolean destroy(String datasource) throws Exception {
        return RuntimeHolder.destroy(datasource);
    }

    public static void check(String key, boolean override) throws Exception {
        if (DataSourceHolder.contains(key)) {
            if (!override) {
                throw new Exception("[\u6570\u636e\u6e90\u91cd\u590d\u6ce8\u518c][thread:" + Thread.currentThread().getId() + "][key:" + key + "]");
            }
            RuntimeHolder.destroy(key);
        }
    }

    public static boolean contains(String datasource) {
        return RuntimeHolder.contains(datasource);
    }

    public static DatabaseType dialect(String datasource) {
        return ServiceProxy.service(datasource).metadata().type();
    }

    public static DatabaseType dialect() {
        return ServiceProxy.service().metadata().type();
    }

    public static List<String> list() {
        return RuntimeHolder.keys();
    }

    public static boolean exists(String datasource) {
        if (null != datasource) {
            return RuntimeHolder.keys().contains(datasource);
        }
        return false;
    }

    public static boolean validity(String datasource) {
        DataSourceHolder instance = DataSourceHolder.instance(datasource);
        if (null != instance) {
            try {
                return instance.validate(datasource);
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    public static boolean validity(DataRuntime runtime) {
        DataSourceHolder instance = DataSourceHolder.instance(runtime);
        if (null != instance) {
            try {
                return instance.validate(runtime);
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    public static boolean hit(DataRuntime runtime) throws Exception {
        DataSourceHolder instance = DataSourceHolder.instance(runtime);
        return instance.validate(runtime);
    }

    public static boolean hit(String datasource) throws Exception {
        DataSourceHolder instance = DataSourceHolder.instance(datasource);
        return instance.validate(datasource);
    }

    default public String create(String key, String pool, String driver, String url, String user, String password) throws Exception {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("type", pool);
        param.put("driver", driver);
        param.put("url", url);
        param.put("user", user);
        param.put("password", password);
        return this.create(key, param);
    }

    default public String create(String key, DatabaseType type, String url, String user, String password) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("url", url);
        params.put("user", user);
        params.put("password", password);
        if (null != type) {
            params.put("adapter", type.name());
        }
        String ds = this.inject(key, params, true);
        return this.runtime(key, ds, false);
    }

    public String create(String var1, String var2);

    default public String create(String key, Map<String, Object> param) throws Exception {
        return this.create(key, param, true);
    }

    default public String create(String key, Map<String, Object> param, boolean override) throws Exception {
        String datasource_id = this.inject(key, param, override);
        return this.runtime(key, datasource_id, override);
    }

    default public DataRuntime create(String key, Object datasource, String database, DatabaseType type, DriverAdapter adapter, boolean override) throws Exception {
        return this.runtime(key, datasource, database, type, adapter, override);
    }

    default public DataRuntime create(String key, Object datasource) throws Exception {
        return this.create(key, datasource, null, null, null, false);
    }

    default public DataRuntime create(String key, Object datasource, boolean override) throws Exception {
        return this.create(key, datasource, null, null, null, override);
    }

    default public DataRuntime create(String key, Object datasource, DatabaseType type, boolean override) throws Exception {
        return this.create(key, datasource, null, type, null, override);
    }

    default public DataRuntime create(String key, Object datasource, DatabaseType type) throws Exception {
        DataRuntime runtime = this.runtime(key, datasource, false);
        if (null != runtime && null != type) {
            runtime.setAdapterKey(type.name());
        }
        return runtime;
    }

    default public boolean validate(String datasource) throws Exception {
        DataRuntime runtime = RuntimeHolder.runtime(datasource);
        return this.validate(runtime);
    }

    default public boolean validate() throws Exception {
        return this.validate(RuntimeHolder.runtime());
    }

    public boolean validate(DataRuntime var1) throws Exception;

    public static List<String> copy(String datasource) {
        return DataSourceHolder.copy(RuntimeHolder.runtime(datasource));
    }

    public static List<String> copy() {
        return DataSourceHolder.copy(RuntimeHolder.runtime());
    }

    public static List<String> copy(DataRuntime runtime) {
        ArrayList<String> list = new ArrayList<String>();
        AnylineService service = ServiceProxy.service(runtime.datasource());
        LinkedHashMap<String, Database> databases = service.metadata().databases();
        Map<String, Object> map = params.get(runtime.datasource());
        if (null == map) {
            log.warn("\u4e0d\u662f\u4eceanyline\u521b\u5efa\u7684\u6570\u636e\u6e90\u83b7\u53d6\u4e0d\u5230\u6570\u636e\u6e90\u53c2\u6570");
            return list;
        }
        for (String database : databases.keySet()) {
            HashMap<String, Object> copy_params = new HashMap<String, Object>();
            BeanUtil.copy(copy_params, map);
            String key = runtime.datasource() + "_" + database.toLowerCase();
            if (RuntimeHolder.contains(key)) {
                list.add(key);
                continue;
            }
            HashSet<String> fieldatasource = DataSourceKeyMap.alias("url");
            for (String field : fieldatasource) {
                String head;
                String db;
                String value = (String)copy_params.get(field);
                if (null == value || (db = (head = value.split("\\?")[0]).substring(head.lastIndexOf("/") + 1)) == null || db.equalsIgnoreCase(database)) continue;
                value = value.replace("/" + db, "/" + database);
                copy_params.put(field, value);
            }
            try {
                String id = DataSourceHolder.reg(key, copy_params);
                if (null == id) continue;
                RuntimeHolder.runtime(key).origin(runtime.getKey());
                list.add(key);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return list;
    }

    default public String regTransactionManager(String key, DataSource datasource) {
        return this.regTransactionManager(key, datasource, false);
    }

    public String regTransactionManager(String var1, DataSource var2, boolean var3);

    default public String regTransactionManager(String key, String datasource) {
        return this.regTransactionManager(key, datasource, false);
    }

    default public String regTransactionManager(String key, String datasource, boolean primary) {
        return this.regTransactionManager(key, (DataSource)ConfigTable.environment().getBean(datasource, DataSource.class), primary);
    }

    public String runtime(String var1, String var2, boolean var3) throws Exception;

    public DataRuntime runtime(String var1, Object var2, String var3, DatabaseType var4, DriverAdapter var5, boolean var6) throws Exception;

    default public DataRuntime runtime(String key, Object datasource, boolean override) throws Exception {
        return this.runtime(key, datasource, null, null, null, override);
    }

    default public String inject(String key, Map params, boolean over) throws Exception {
        return this.inject(key, null, params, over);
    }

    public String inject(String var1, String var2, Map<String, Object> var3, boolean var4) throws Exception;

    default public <T> T value(Map map, String keys, Class<T> clazz, T def) {
        return (T)BeanUtil.value((Map)map, (String)keys, DataSourceKeyMap.maps, clazz, def);
    }

    default public <T> T value(String prefix, String keys, Class<T> clazz, T def) {
        return (T)ConfigTable.environment().value(prefix, keys, DataSourceKeyMap.maps, clazz, def);
    }
}

