/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.transaction.init;

import org.anyline.data.transaction.TransactionDefine;

public class DefaultTransactionDefine
implements TransactionDefine {
    public static final String PREFIX_PROPAGATION = "PROPAGATION_";
    public static final String PREFIX_ISOLATION = "ISOLATION_";
    public static final String PREFIX_TIMEOUT = "timeout_";
    public static final String READ_ONLY_MARKER = "readOnly";
    private int propagationBehavior = 0;
    private int isolationLevel = -1;
    private int timeout = -1;
    private boolean readOnly = false;
    private String name;
    private TransactionDefine.MODE mode = TransactionDefine.MODE.THREAD;

    public DefaultTransactionDefine() {
        this.name = "" + System.currentTimeMillis();
    }

    public DefaultTransactionDefine(TransactionDefine other) {
        this.propagationBehavior = other.getPropagationBehavior();
        this.isolationLevel = other.getIsolationLevel();
        this.timeout = other.getTimeout();
        this.readOnly = other.isReadOnly();
        this.name = other.getName();
    }

    public DefaultTransactionDefine(int propagationBehavior) {
        this.propagationBehavior = propagationBehavior;
    }

    @Override
    public final int getPropagationBehavior() {
        return this.propagationBehavior;
    }

    @Override
    public String getPropagationBehaviorName() {
        return null;
    }

    @Override
    public final int getIsolationLevel() {
        return this.isolationLevel;
    }

    @Override
    public void setTimeout(int timeout) {
        if (timeout < -1) {
            throw new IllegalArgumentException("Timeout must be a positive integer or TIMEOUT_DEFAULT");
        }
        this.timeout = timeout;
    }

    @Override
    public final int getTimeout() {
        return this.timeout;
    }

    @Override
    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    @Override
    public final boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public TransactionDefine.MODE getMode() {
        return this.mode;
    }

    @Override
    public void setMode(TransactionDefine.MODE mode) {
        this.mode = mode;
    }
}

