/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.datasource;

import java.util.ArrayList;
import java.util.List;
import org.anyline.data.datasource.DataSourceHolder;
import org.anyline.util.ConfigTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface DataSourceLoader {
    public static final Logger log = LoggerFactory.getLogger(DataSourceLoader.class);

    public DataSourceHolder holder();

    public List<String> load();

    default public List<String> load(String head, boolean loadDefault) {
        String prefixs;
        String def;
        ArrayList<String> list = new ArrayList<String>();
        if (loadDefault && !ConfigTable.environment.containsBean("anyline.service.default") && null != (def = this.holder().create("default", head))) {
            list.add(def);
        }
        if (null == (prefixs = ConfigTable.environment().string(null, head + ".list"))) {
            prefixs = ConfigTable.environment().string(null, head + "-list");
        }
        if (null != prefixs) {
            for (String prefix : prefixs.split(",")) {
                try {
                    String datasource;
                    if (ConfigTable.environment.containsBean("anyline.service." + prefix) || null == (datasource = this.holder().create(prefix, head + "." + prefix))) continue;
                    list.add(datasource);
                }
                catch (Exception e) {
                    log.error("[\u6ce8\u5165\u6570\u636e\u6e90\u5931\u8d25][key:{}][msg:{}]", (Object)prefix, (Object)e.toString());
                }
            }
        }
        return list;
    }
}

