/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.param;

import java.util.ArrayList;
import java.util.List;
import org.anyline.data.param.ConfigStore;
import org.anyline.data.param.init.DefaultConfigStore;
import org.anyline.data.prepare.RunPrepare;
import org.anyline.data.prepare.auto.init.DefaultTablePrepare;
import org.anyline.entity.Aggregation;
import org.anyline.entity.AggregationConfig;
import org.anyline.entity.DataRow;
import org.anyline.entity.DataSet;
import org.anyline.entity.DefaultGroupStore;
import org.anyline.entity.DefaultOrderStore;
import org.anyline.entity.GroupStore;
import org.anyline.entity.OrderStore;
import org.anyline.metadata.Table;
import org.anyline.service.AnylineService;

public class AggregationBuilder {
    private AnylineService service;
    private Table table;
    private RunPrepare prepare;
    private ConfigStore configs = new DefaultConfigStore(new String[0]);
    private List<AggregationConfig> aggregations = new ArrayList<AggregationConfig>();
    private GroupStore groups = new DefaultGroupStore();
    private ConfigStore having = new DefaultConfigStore(new String[0]);
    private OrderStore orders = new DefaultOrderStore();

    public AggregationBuilder(AnylineService service) {
        this.service = service;
    }

    public AggregationBuilder group(String ... columns) {
        for (String column : columns) {
            this.groups.add(column);
        }
        return this;
    }

    public AggregationBuilder order(String column, String type) {
        this.orders.add(column, type);
        return this;
    }

    public AggregationBuilder order(String column) {
        this.orders.add(column);
        return this;
    }

    public AggregationBuilder having(String having) {
        this.having.and(having);
        return this;
    }

    public GroupStore groups() {
        return this.groups;
    }

    public List<AggregationConfig> aggregations() {
        return this.aggregations;
    }

    public AggregationBuilder aggregation(Aggregation aggregation, String column, String result) {
        AggregationConfig config = new AggregationConfig(aggregation, column, result);
        this.aggregations.add(config);
        return this;
    }

    public AggregationBuilder table(Table table) {
        this.table = table;
        return this;
    }

    public AggregationBuilder table(String table) {
        this.table = new Table(table);
        return this;
    }

    public AggregationBuilder table(RunPrepare prepare) {
        this.prepare = prepare;
        return this;
    }

    public AggregationBuilder configs(ConfigStore configs) {
        this.configs = configs;
        return this;
    }

    public DataSet querys() {
        if (null == this.prepare && null != this.table) {
            this.prepare = new DefaultTablePrepare(this.table);
        }
        if (null != this.prepare) {
            if (!this.orders.isEmpty()) {
                this.prepare.order(this.orders);
            }
            if (!this.groups.isEmpty()) {
                this.prepare.group(this.groups);
            }
            if (!this.having.isEmpty()) {
                this.prepare.having(this.having);
            }
            this.prepare.aggregation(this.aggregations);
            return this.service.querys(this.prepare, this.configs, new String[0]);
        }
        throw new RuntimeException("\u672a\u63d0\u4f9bTable\u6216RunPrepare");
    }

    public DataRow query() {
        if (null == this.prepare && null != this.table) {
            this.prepare = new DefaultTablePrepare(this.table);
        }
        if (null != this.prepare) {
            if (!this.orders.isEmpty()) {
                this.prepare.order(this.orders);
            }
            if (!this.groups.isEmpty()) {
                this.prepare.group(this.groups);
            }
            if (!this.having.isEmpty()) {
                this.prepare.having(this.having);
            }
            this.prepare.aggregation(this.aggregations);
            return this.service.query(this.prepare, this.configs, new String[0]);
        }
        throw new RuntimeException("\u672a\u63d0\u4f9bTable\u6216RunPrepare");
    }
}

