/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.prepare.auto.init;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.anyline.data.adapter.DriverAdapter;
import org.anyline.data.param.Config;
import org.anyline.data.prepare.Condition;
import org.anyline.data.prepare.auto.AutoCondition;
import org.anyline.data.prepare.init.AbstractCondition;
import org.anyline.data.run.RunValue;
import org.anyline.data.runtime.DataRuntime;
import org.anyline.data.util.CommandParser;
import org.anyline.entity.Compare;
import org.anyline.exception.NotSupportException;
import org.anyline.util.BasicUtil;
import org.anyline.util.BeanUtil;
import org.anyline.util.SQLUtil;

public class DefaultAutoCondition
extends AbstractCondition
implements AutoCondition {
    private String table;
    private String column;
    private Object values;
    private Object orValues;
    private Compare compare = Compare.EQUAL;
    private Compare orCompare = Compare.EQUAL;

    public DefaultAutoCondition(Config config) {
        this.setJoin(config.getJoin());
        this.datatype(config.datatype());
        this.setTable(config.getPrefix());
        this.setColumn(config.getVariable());
        this.setValues(config.getValues());
        this.setOrValues(config.getOrValues());
        this.setCompare(config.getCompare());
        this.setVariableType(0);
        this.setSwt(config.getSwt());
        this.prepare(config.prepare());
        this.setRunText(config.getText());
        if (BasicUtil.isNotEmpty((Object)this.text)) {
            this.setVariableType(2);
        }
        if (BasicUtil.isNotEmpty((Object)this.text) || BasicUtil.isNotEmpty((boolean)true, (Object)this.values) || config.getSwt() == Compare.EMPTY_VALUE_SWITCH.NULL || config.getSwt() == Compare.EMPTY_VALUE_SWITCH.SRC) {
            this.setActive(true);
        }
        if (null != this.prepare) {
            this.setActive(true);
        }
    }

    public DefaultAutoCondition(Compare.EMPTY_VALUE_SWITCH swt, Compare compare, String prefix, String var, Object values) {
        this.setSwt(swt);
        this.setTable(prefix);
        this.setColumn(var);
        this.setValues(values);
        this.setCompare(compare);
        this.setVariableType(0);
        if (BasicUtil.isNotEmpty((boolean)true, (Object)values) || swt == Compare.EMPTY_VALUE_SWITCH.NULL || swt == Compare.EMPTY_VALUE_SWITCH.SRC) {
            this.setActive(true);
        }
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    public DefaultAutoCondition(String text) {
        this.text = text;
        this.active = true;
        this.setVariableType(2);
    }

    @Override
    public String getRunText(int lvl, String prefix, DataRuntime runtime, Boolean placeholder, Boolean unicode) {
        this.runValues = new ArrayList();
        String text = "";
        if (this.variableType == 2) {
            text = this.text;
        } else if (this.variableType == 1) {
            text = CommandParser.replaceVariable(runtime, this.getVariableBlocks(), this.getVariables(), text);
        } else {
            String txt = "";
            txt = this.getRunText(prefix, runtime, this.values, this.compare, placeholder, unicode);
            if (BasicUtil.isNotEmpty((Object)txt)) {
                text = txt;
            }
            if (BasicUtil.isNotEmpty((boolean)true, (Object)this.orValues) && BasicUtil.isNotEmpty((Object)(txt = this.getRunText(prefix, runtime, this.orValues, this.orCompare, placeholder, unicode)))) {
                text = BasicUtil.isEmpty((Object)text) ? txt : "(" + text + " OR " + txt + ")";
            }
        }
        return text;
    }

    public String getRunText(String prefix, DataRuntime runtime, Object val, Compare compare, Boolean placeholder, Boolean unicode) {
        StringBuilder builder = new StringBuilder();
        String delimiterFr = "";
        String delimiterTo = "";
        boolean support = true;
        DriverAdapter adapter = null;
        if (null != runtime) {
            adapter = runtime.getAdapter();
        }
        if (null != adapter) {
            delimiterFr = adapter.getDelimiterFr();
            delimiterTo = adapter.getDelimiterTo();
        }
        boolean empty = compare.valueCount() > 0 && BasicUtil.isEmpty((boolean)true, (Object)val);
        int compareCode = compare.getCode();
        if (compareCode == -1) {
            return "";
        }
        if (compare.valueCount() == 1 && null != val) {
            int len;
            if (val instanceof Collection) {
                Collection collection = (Collection)val;
                if (!collection.isEmpty()) {
                    val = collection.iterator().next();
                }
            } else if (val.getClass().isArray() && (len = Array.getLength(val)) > 0) {
                val = Array.get(val, 0);
            }
        }
        if (empty && (this.swt == Compare.EMPTY_VALUE_SWITCH.BREAK || this.swt == Compare.EMPTY_VALUE_SWITCH.IGNORE)) {
            return "";
        }
        if (BasicUtil.isNotEmpty((Object)this.table)) {
            prefix = this.table;
        }
        if (BasicUtil.isEmpty((Object)this.column) && compareCode != 92 && compareCode != 192) {
            return "";
        }
        StringBuilder col_builder = new StringBuilder();
        if (null != this.column && !this.column.contains(".")) {
            if (BasicUtil.isNotEmpty((Object)prefix)) {
                SQLUtil.delimiter((StringBuilder)col_builder, (String)prefix, (String)delimiterFr, (String)delimiterTo).append(".");
            } else if (BasicUtil.isNotEmpty((Object)this.table)) {
                SQLUtil.delimiter((StringBuilder)col_builder, (String)this.table, (String)delimiterFr, (String)delimiterTo).append(".");
            }
        }
        SQLUtil.delimiter((StringBuilder)col_builder, (String)this.column, (String)delimiterFr, (String)delimiterTo);
        if (compareCode >= 60 && compareCode <= 62) {
            try {
                val = adapter.createConditionFindInSet(runtime, builder, col_builder.toString(), compare, val, placeholder, unicode);
            }
            catch (NotSupportException ignored) {
                support = false;
            }
        } else if (compareCode >= 70 && compareCode <= 72) {
            try {
                val = adapter.createConditionJsonContains(runtime, builder, col_builder.toString(), compare, val, placeholder, unicode);
            }
            catch (NotSupportException ignored) {
                support = false;
            }
        } else if (compareCode == 75 || compareCode == 76) {
            try {
                val = adapter.createConditionJsonContainsPath(runtime, builder, col_builder.toString(), compare, val, placeholder, unicode);
            }
            catch (NotSupportException ignored) {
                support = false;
            }
        } else if (compareCode == 77 || compareCode == 78) {
            try {
                val = adapter.createConditionJsonSearch(runtime, builder, col_builder.toString(), compare, val, placeholder, unicode);
            }
            catch (NotSupportException ignored) {
                support = false;
            }
        } else {
            List<RunValue> rvs;
            Object v;
            builder.append((CharSequence)col_builder);
            if (compareCode == 10 || compareCode == 11) {
                String str;
                v = this.getValue(val);
                boolean is_origin = false;
                Object static_value = null;
                if (v instanceof String && BasicUtil.checkEl((String)(str = (String)v))) {
                    is_origin = true;
                }
                if (is_origin) {
                    placeholder = false;
                    adapter.formula(runtime, builder, this.column, Compare.EQUAL, null, v, placeholder, unicode);
                    this.variableType = 2;
                } else if ("NULL".equals(v)) {
                    placeholder = false;
                    adapter.formula(runtime, builder, this.column, Compare.NULL, null, null, placeholder, unicode);
                    this.variableType = 2;
                } else if (empty) {
                    if (this.swt == Compare.EMPTY_VALUE_SWITCH.NULL) {
                        placeholder = false;
                        adapter.formula(runtime, builder, this.column, Compare.NULL, null, null, placeholder, unicode);
                        this.variableType = 2;
                    } else if (this.swt == Compare.EMPTY_VALUE_SWITCH.SRC && null == v) {
                        placeholder = false;
                        adapter.formula(runtime, builder, this.column, Compare.NULL, null, null, placeholder, unicode);
                        this.variableType = 2;
                    } else {
                        adapter.formula(runtime, builder, this.column, compare, null, null, placeholder, unicode);
                    }
                } else {
                    adapter.formula(runtime, builder, this.column, compare, null, v, placeholder, unicode);
                }
            } else if (compareCode == 20) {
                adapter.formula(runtime, builder, this.column, compare, null, val, placeholder, unicode);
            } else if (compareCode == 21) {
                adapter.formula(runtime, builder, this.column, compare, null, val, placeholder, unicode);
            } else if (compareCode == 30) {
                adapter.formula(runtime, builder, this.column, compare, null, val, placeholder, unicode);
            } else if (compareCode == 110) {
                v = this.getValue(val);
                if ("NULL".equals(v.toString())) {
                    placeholder = false;
                    adapter.formula(runtime, builder, this.column, Compare.NOT_NULL, null, null, placeholder, unicode);
                    this.variableType = 2;
                } else if (empty) {
                    if (this.swt == Compare.EMPTY_VALUE_SWITCH.NULL) {
                        placeholder = false;
                        adapter.formula(runtime, builder, this.column, Compare.NOT_NULL, null, null, placeholder, unicode);
                        this.variableType = 2;
                    } else if (this.swt == Compare.EMPTY_VALUE_SWITCH.SRC && null == v) {
                        placeholder = false;
                        adapter.formula(runtime, builder, this.column, Compare.NOT_NULL, null, null, placeholder, unicode);
                        this.variableType = 2;
                    } else {
                        adapter.formula(runtime, builder, this.column, compare, null, null, placeholder, unicode);
                    }
                } else {
                    adapter.formula(runtime, builder, this.column, compare, null, val, placeholder, unicode);
                }
            } else if (compareCode == 31) {
                adapter.formula(runtime, builder, this.column, compare, null, val, placeholder, unicode);
            } else if (compareCode == 80) {
                adapter.formula(runtime, builder, this.column, compare, null, val, placeholder, unicode);
            } else if (compareCode == 40 || compareCode == 140) {
                rvs = adapter.createConditionIn(runtime, builder, compare, val, placeholder, unicode);
                if (null != rvs) {
                    this.runValues.addAll(rvs);
                    this.variableType = 2;
                }
            } else if (compareCode >= 50 && compareCode <= 52 || compareCode >= 150 && compareCode <= 152) {
                RunValue rv = adapter.createConditionLike(runtime, builder, compare, val, placeholder, unicode);
                if (rv.isPlaceholder()) {
                    val = rv.getValue();
                } else {
                    placeholder = false;
                    this.variableType = 2;
                }
            } else if (compareCode == 90) {
                placeholder = false;
                this.variableType = 2;
                adapter.formula(runtime, builder, this.column, compare, null, null, placeholder, unicode);
            } else if (compareCode == 190) {
                adapter.formula(runtime, builder, this.column, compare, null, null, placeholder, unicode);
                placeholder = false;
                this.variableType = 2;
            } else if (compareCode == 91) {
                adapter.formula(runtime, builder, this.column, compare, null, null, placeholder, unicode);
                placeholder = false;
                this.variableType = 2;
            } else if (compareCode == 191) {
                adapter.formula(runtime, builder, this.column, compare, null, null, placeholder, unicode);
            } else if (compareCode == 92) {
                rvs = adapter.createConditionExists(runtime, builder, compare, this.prepare(), placeholder, unicode);
                if (null != rvs) {
                    this.runValues.addAll(rvs);
                }
                this.variableType = 2;
            } else if (compareCode == 192) {
                rvs = adapter.createConditionExists(runtime, builder, compare, this.prepare(), placeholder, unicode);
                if (null != rvs) {
                    this.runValues.addAll(rvs);
                }
            } else {
                adapter.formula(runtime, builder, this.column, compare, null, null, placeholder, unicode);
            }
        }
        if (support && placeholder.booleanValue() && this.variableType != 2) {
            if (null == val) {
                this.runValues.add(new RunValue(this.column, val, this.datatype));
            } else if (compare.valueCount() > 1) {
                List<Object> list = this.getValues(val);
                if (null != list) {
                    for (Object obj : list) {
                        this.runValues.add(new RunValue(this.column, obj, this.datatype));
                    }
                }
            } else {
                Object value = this.getValue(val);
                this.runValues.add(new RunValue(this.column, value, this.datatype));
            }
        }
        return builder.toString();
    }

    public Object getValue(Object src) {
        Object value = null;
        if (null != src) {
            if (src instanceof List) {
                if (!((List)src).isEmpty()) {
                    value = ((List)src).get(0);
                }
            } else {
                value = src;
            }
        }
        return value;
    }

    public List<Object> getValues(Object src) {
        List<Object> values = new ArrayList<Object>();
        if (null != src) {
            if (src instanceof List) {
                values = (List)src;
            } else {
                values.add(src);
            }
        }
        return values;
    }

    @Override
    public Object getValue() {
        return this.getValue(this.values);
    }

    @Override
    public List<Object> getValues() {
        return this.getValues(this.values);
    }

    public Object getOrValue() {
        return this.getValue(this.orValues);
    }

    public List<Object> getOrValues() {
        return this.getValues(this.orValues);
    }

    @Override
    public String getId() {
        return this.column;
    }

    @Override
    public String getColumn() {
        return this.column;
    }

    @Override
    public void setColumn(String column) {
        this.column = column;
    }

    @Override
    public void setValues(Object values) {
        this.values = values;
        this.setValue = true;
    }

    public void setOrValues(Object values) {
        this.orValues = values;
        this.setValue = true;
    }

    @Override
    public Compare getCompare() {
        return this.compare;
    }

    @Override
    public AutoCondition setCompare(Compare compare) {
        this.compare = compare;
        return this;
    }

    public Compare getOrCompare() {
        return this.orCompare;
    }

    @Override
    public AutoCondition setOrCompare(Compare orCompare) {
        this.orCompare = orCompare;
        return this;
    }

    public String getTable() {
        return this.table;
    }

    public void setTable(String table) {
        this.table = table;
    }

    @Override
    public Condition setRunText(String text) {
        this.text = text;
        return this;
    }

    public String toString() {
        if (BasicUtil.isNotEmpty((Object)this.text)) {
            String result = "text:" + this.text;
            if (null != this.values) {
                result = result + " values:" + this.values;
            }
            return result;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        Condition.JOIN join = this.getJoin();
        if (null != join) {
            map.put("join", (Object)join);
        }
        if (null != this.datatype) {
            map.put("datatype", this.datatype);
        }
        map.put("column", this.column);
        map.put("compare", this.compare.getName());
        map.put("values", this.values);
        return BeanUtil.map2json(map);
    }
}

