/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.adapter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.anyline.adapter.DataReader;
import org.anyline.adapter.DataWriter;
import org.anyline.data.adapter.DataReaderFactory;
import org.anyline.data.adapter.DataWriterFactory;
import org.anyline.data.adapter.DriverActuator;
import org.anyline.data.adapter.SystemDataReaderFactory;
import org.anyline.data.adapter.SystemDataWriterFactory;
import org.anyline.data.listener.DDListener;
import org.anyline.data.listener.DMListener;
import org.anyline.data.metadata.TypeMetadataAlias;
import org.anyline.data.param.ConfigStore;
import org.anyline.data.param.init.DefaultConfigStore;
import org.anyline.data.prepare.RunPrepare;
import org.anyline.data.run.Run;
import org.anyline.data.run.RunValue;
import org.anyline.data.run.TableRun;
import org.anyline.data.runtime.DataRuntime;
import org.anyline.data.util.DataSourceUtil;
import org.anyline.entity.Compare;
import org.anyline.entity.DataRow;
import org.anyline.entity.DataSet;
import org.anyline.entity.EntitySet;
import org.anyline.entity.OrderStore;
import org.anyline.entity.PageNavi;
import org.anyline.entity.authorize.Privilege;
import org.anyline.entity.authorize.Role;
import org.anyline.entity.authorize.User;
import org.anyline.entity.generator.PrimaryGenerator;
import org.anyline.exception.NotSupportException;
import org.anyline.log.Log;
import org.anyline.log.LogProxy;
import org.anyline.metadata.ACTION;
import org.anyline.metadata.Catalog;
import org.anyline.metadata.Column;
import org.anyline.metadata.Constraint;
import org.anyline.metadata.Database;
import org.anyline.metadata.ForeignKey;
import org.anyline.metadata.Function;
import org.anyline.metadata.Index;
import org.anyline.metadata.MasterTable;
import org.anyline.metadata.Metadata;
import org.anyline.metadata.Parameter;
import org.anyline.metadata.PartitionTable;
import org.anyline.metadata.PrimaryKey;
import org.anyline.metadata.Procedure;
import org.anyline.metadata.Schema;
import org.anyline.metadata.Sequence;
import org.anyline.metadata.Table;
import org.anyline.metadata.Tag;
import org.anyline.metadata.Trigger;
import org.anyline.metadata.Type;
import org.anyline.metadata.View;
import org.anyline.metadata.differ.ColumnsDiffer;
import org.anyline.metadata.differ.FunctionsDiffer;
import org.anyline.metadata.differ.IndexesDiffer;
import org.anyline.metadata.differ.MetadataDiffer;
import org.anyline.metadata.differ.PrimaryKeyDiffer;
import org.anyline.metadata.differ.ProceduresDiffer;
import org.anyline.metadata.differ.TableDiffer;
import org.anyline.metadata.differ.TablesDiffer;
import org.anyline.metadata.differ.ViewsDiffer;
import org.anyline.metadata.graph.EdgeTable;
import org.anyline.metadata.graph.VertexTable;
import org.anyline.metadata.refer.MetadataFieldRefer;
import org.anyline.metadata.type.DatabaseOrigin;
import org.anyline.metadata.type.DatabaseType;
import org.anyline.metadata.type.TypeMetadata;
import org.anyline.util.BasicUtil;
import org.anyline.util.BeanUtil;
import org.anyline.util.ConfigTable;

public interface DriverAdapter {
    public static final Log log = LogProxy.get(DriverAdapter.class);
    public static final String TAB = "\t";
    public static final String BR = "\n";
    public static final String BR_TAB = "\n\t";

    public DatabaseType type();

    default public String version() {
        return null;
    }

    default public LinkedHashMap<String, TypeMetadata> types() {
        LinkedHashMap<String, TypeMetadata> types = new LinkedHashMap<String, TypeMetadata>();
        for (TypeMetadata type : this.alias().values()) {
            types.put(type.getName().toUpperCase(), type);
        }
        return types;
    }

    default public DatabaseOrigin origin() {
        return this.type().origin();
    }

    public LinkedHashMap<String, TypeMetadata> alias();

    public void setActuator(DriverActuator var1);

    public DriverActuator getActuator();

    public boolean supportCatalog();

    public boolean supportSchema();

    default public boolean supportPlaceholder() {
        return true;
    }

    default public String columnAliasGuidd() {
        return " ";
    }

    default public String tableAliasGuidd() {
        return " ";
    }

    public void setListener(DDListener var1);

    public DDListener getDDListener();

    public void setListener(DMListener var1);

    public DMListener getDMListener();

    public void setGenerator(PrimaryGenerator var1);

    public void setDelimiter(String var1);

    default public boolean equals(Metadata m1, Metadata m2) {
        String c1 = null;
        String c2 = null;
        String s1 = null;
        String s2 = null;
        String n1 = null;
        String n2 = null;
        if (null != m1) {
            if (null == m2) {
                return false;
            }
            c1 = m1.getCatalogName();
            s1 = m1.getSchemaName();
            n1 = m1.getName();
        }
        if (null != m2) {
            if (null == m1) {
                return false;
            }
            c2 = m2.getCatalogName();
            s2 = m2.getSchemaName();
            n2 = m2.getName();
        }
        if (this.supportCatalog() && !BasicUtil.equals((Object)c1, (Object)c2, (boolean)true)) {
            return false;
        }
        if (this.supportSchema() && !BasicUtil.equals((Object)s1, (Object)s2, (boolean)true)) {
            return false;
        }
        return BasicUtil.equals((Object)n1, n2, (boolean)true);
    }

    default public boolean empty(Metadata meta) {
        if (null == meta) {
            return true;
        }
        return BasicUtil.isEmpty((Object)meta.getName());
    }

    default public boolean empty(String meta) {
        return BasicUtil.isEmpty((Object)meta);
    }

    default public boolean equals(Catalog c1, Catalog c2) {
        if (!this.supportCatalog()) {
            return true;
        }
        String n1 = null;
        String n2 = null;
        if (null != c1) {
            if (null == c2) {
                return false;
            }
            n1 = c1.getName();
        }
        if (null != c2) {
            if (null == c1) {
                return false;
            }
            n2 = c2.getName();
        }
        return BasicUtil.equals((Object)n1, n2, (boolean)true);
    }

    default public boolean equals(Schema s1, Schema s2) {
        if (!this.supportCatalog()) {
            return true;
        }
        String n1 = null;
        String n2 = null;
        if (null != s1) {
            if (null == s2) {
                return false;
            }
            n1 = s1.getName();
        }
        if (null != s2) {
            if (null == s1) {
                return false;
            }
            n2 = s2.getName();
        }
        return BasicUtil.equals((Object)n1, n2, (boolean)true);
    }

    public TypeMetadata.Refer reg(TypeMetadataAlias var1);

    public TypeMetadata.Refer reg(String var1, TypeMetadata.Refer var2);

    public TypeMetadata.Refer reg(TypeMetadata var1, TypeMetadata.Refer var2);

    default public boolean exeMatch(DataRuntime runtime, String feature, String adapterKey, boolean compensate) {
        if (BasicUtil.isNotEmpty((Object)adapterKey)) {
            return this.matchByAdapter(adapterKey);
        }
        if (null == feature) {
            feature = runtime.getFeature(true);
        }
        if (BasicUtil.isNotEmpty((Object)runtime.getAdapterKey())) {
            return this.matchByAdapter(runtime);
        }
        List keywords = this.type().keywords();
        return this.match(feature, keywords, compensate);
    }

    default public boolean match(DataRuntime runtime, String feature, String adapterKey, boolean compensate) {
        return this.exeMatch(runtime, feature, adapterKey, compensate);
    }

    default public boolean matchByAdapter(DataRuntime runtime) {
        String config_adapter_key = runtime.getAdapterKey();
        return this.matchByAdapter(config_adapter_key);
    }

    default public boolean matchByAdapter(String key) {
        if (BasicUtil.isNotEmpty((Object)key)) {
            String type = this.type().name();
            boolean result = false;
            if (key.equalsIgnoreCase(type)) {
                result = true;
            }
            if (ConfigTable.IS_LOG_ADAPTER_MATCH) {
                log.info("[adapter match][result:{}][config adapter:{}][match adapter:{}]", new Object[]{result, key, type});
            }
            return result;
        }
        return false;
    }

    default public boolean match(String feature, List<String> keywords, boolean compensate) {
        if (null == feature) {
            return false;
        }
        feature = feature.toLowerCase();
        if (null != keywords) {
            for (String k : keywords) {
                if (BasicUtil.isEmpty((Object)k)) {
                    if (!ConfigTable.IS_LOG_ADAPTER_MATCH) continue;
                    log.info("[adapter match][result:{}][feature:{}][key:{}][match adapter:{}]", new Object[]{false, feature, k, this.getClass()});
                    continue;
                }
                if (!feature.contains(k)) continue;
                if (ConfigTable.IS_LOG_ADAPTER_MATCH) {
                    log.info("[adapter match][result:{}][feature:{}][key:{}][match adapter:{}]", new Object[]{true, feature, k, this.getClass()});
                }
                return true;
            }
        }
        return false;
    }

    public String getDelimiterFr();

    public String getDelimiterTo();

    public DatabaseType compatible();

    public TypeMetadata typeMetadata(DataRuntime var1, Column var2);

    public TypeMetadata typeMetadata(DataRuntime var1, String var2);

    default public void reg(Object[] supports, DataWriter writer) {
        SystemDataWriterFactory.reg(this.type(), supports, writer);
    }

    default public void reg(DataWriter writer) {
        SystemDataWriterFactory.reg(this.type(), null, writer);
    }

    default public void reg(Object[] supports, DataReader reader) {
        SystemDataReaderFactory.reg(this.type(), supports, reader);
    }

    default public void reg(DataReader reader) {
        SystemDataReaderFactory.reg(this.type(), null, reader);
    }

    default public DataReader reader(Object type) {
        DataReader reader = DataReaderFactory.reader(this.type(), type);
        if (null == reader) {
            reader = SystemDataReaderFactory.reader(this.type(), type);
        }
        if (null == reader) {
            reader = DataReaderFactory.reader(DatabaseType.NONE, type);
        }
        if (null == reader) {
            reader = SystemDataReaderFactory.reader(DatabaseType.NONE, type);
        }
        return reader;
    }

    default public DataWriter writer(Object type) {
        DataWriter writer = DataWriterFactory.writer(this.type(), type);
        if (null == writer) {
            writer = SystemDataWriterFactory.writer(this.type(), type);
        }
        if (null == writer) {
            writer = DataWriterFactory.writer(DatabaseType.NONE, type);
        }
        if (null == writer) {
            writer = SystemDataWriterFactory.writer(DatabaseType.NONE, type);
        }
        return writer;
    }

    default public String name(Type type) {
        HashMap<Object, String> types = new HashMap<Object, String>();
        types.put(Table.TYPE.NORMAL, "BASE TABLE");
        types.put(Table.TYPE.VIEW, "VIEW");
        types.put(View.TYPE.NORMAL, "VIEW");
        types.put(Metadata.TYPE.TABLE, "BASE TABLE");
        types.put(Metadata.TYPE.VIEW, "VIEW");
        return (String)types.get(type);
    }

    default public List<String> names(List<Type> types) {
        ArrayList<String> list = new ArrayList<String>();
        for (Type type : types) {
            String name = this.name(type);
            if (null == name) continue;
            list.add(name);
        }
        return list;
    }

    default public void in(DataRuntime runtime, StringBuilder builder, String column, List<String> list) {
        if (!list.isEmpty()) {
            builder.append(" AND ").append(column);
            if (list.size() == 1) {
                builder.append(" = '").append(this.objectName(runtime, list.get(0))).append("'");
            } else {
                boolean first = true;
                builder.append(" IN(");
                for (String item : list) {
                    if (!first) {
                        builder.append(", ");
                    }
                    builder.append("'").append(this.objectName(runtime, item)).append("'");
                    first = false;
                }
                builder.append(")");
            }
        }
    }

    public List<Run> merge(DataRuntime var1, Table var2, List<Run> var3);

    default public List<Run> ddl(DataRuntime runtime, String random, MetadataDiffer differ) {
        return this.ddl(runtime, random, differ, true);
    }

    default public List<Run> ddl(DataRuntime runtime, String random, MetadataDiffer differ, boolean merge) {
        ArrayList<Run> list;
        block70: {
            block77: {
                block76: {
                    block75: {
                        block74: {
                            block73: {
                                block72: {
                                    block71: {
                                        list = new ArrayList<Run>();
                                        if (!(differ instanceof TablesDiffer)) break block71;
                                        TablesDiffer df = (TablesDiffer)differ;
                                        LinkedHashMap adds = df.getAdds();
                                        LinkedHashMap drops = df.getDrops();
                                        LinkedHashMap updates = df.getAlters();
                                        LinkedHashMap diffs = df.getDiffers();
                                        for (Table add : adds.values()) {
                                            try {
                                                list.addAll(this.buildCreateRun(runtime, add));
                                            }
                                            catch (Exception e) {
                                                log.error("build ddl exception:", (Throwable)e);
                                            }
                                        }
                                        for (TableDiffer dif : diffs.values()) {
                                            list.addAll(this.ddl(runtime, random, (MetadataDiffer)dif, merge));
                                        }
                                        for (Table drop : drops.values()) {
                                            try {
                                                list.addAll(this.buildDropRun(runtime, drop));
                                            }
                                            catch (Exception e) {
                                                log.error("build ddl exception:", (Throwable)e);
                                            }
                                        }
                                        break block70;
                                    }
                                    if (!(differ instanceof ViewsDiffer)) break block72;
                                    ViewsDiffer df = (ViewsDiffer)differ;
                                    LinkedHashMap adds = df.getAdds();
                                    LinkedHashMap drops = df.getDrops();
                                    LinkedHashMap updates = df.getAlters();
                                    for (View add : adds.values()) {
                                        try {
                                            list.addAll(this.buildCreateRun(runtime, add));
                                        }
                                        catch (Exception e) {
                                            log.error("build ddl exception:", (Throwable)e);
                                        }
                                    }
                                    for (View update : updates.values()) {
                                        try {
                                            list.addAll(this.buildAlterRun(runtime, update));
                                        }
                                        catch (Exception e) {
                                            log.error("build ddl exception:", (Throwable)e);
                                        }
                                    }
                                    for (View drop : drops.values()) {
                                        try {
                                            list.addAll(this.buildDropRun(runtime, drop));
                                        }
                                        catch (Exception e) {
                                            log.error("build ddl exception:", (Throwable)e);
                                        }
                                    }
                                    break block70;
                                }
                                if (!(differ instanceof TableDiffer)) break block73;
                                try {
                                    TableDiffer dif = (TableDiffer)differ;
                                    ArrayList<Run> slices = new ArrayList<Run>();
                                    Table direct = dif.getDirect();
                                    Table dest = dif.getDest();
                                    Table origin = dif.getOrigin();
                                    Table update = origin.clone();
                                    if (null != update) {
                                        update.setUpdate((Metadata)dest, false, false);
                                    }
                                    ColumnsDiffer columns_dif = dif.getColumnsDiffer();
                                    slices.addAll(this.ddl(runtime, random, (MetadataDiffer)columns_dif, false));
                                    PrimaryKeyDiffer primary_dif = dif.getPrimaryKeyDiffer();
                                    slices.addAll(this.ddl(runtime, random, (MetadataDiffer)primary_dif, false));
                                    IndexesDiffer index_dif = dif.getIndexesDiffer();
                                    slices.addAll(this.ddl(runtime, random, (MetadataDiffer)index_dif, false));
                                    if (merge) {
                                        List<Run> merges = this.merge(runtime, direct, slices);
                                        list.addAll(merges);
                                        break block70;
                                    }
                                    list.addAll(slices);
                                }
                                catch (Exception e) {
                                    log.error("build ddl exception:", (Throwable)e);
                                }
                                break block70;
                            }
                            if (!(differ instanceof PrimaryKeyDiffer)) break block74;
                            PrimaryKeyDiffer df = (PrimaryKeyDiffer)differ;
                            Table table = null;
                            PrimaryKey add = df.getAdd();
                            PrimaryKey drop = df.getDrop();
                            PrimaryKey alter = df.getAlter();
                            boolean slice = this.slice();
                            ArrayList<Run> slices = new ArrayList<Run>();
                            try {
                                if (null != drop) {
                                    if (null == table) {
                                        table = drop.getTable();
                                    }
                                    slices.addAll(this.buildDropRun(runtime, drop, slice));
                                }
                                if (null != add) {
                                    if (null == table) {
                                        table = add.getTable();
                                    }
                                    slices.addAll(this.buildAddRun(runtime, add, slice));
                                }
                                if (null != alter) {
                                    if (null == table) {
                                        table = alter.getTable();
                                    }
                                    slices.addAll(this.buildAlterRun(runtime, alter, (PrimaryKey)alter.getUpdate(), slice));
                                }
                                if (merge) {
                                    list.addAll(this.merge(runtime, table, slices));
                                    break block70;
                                }
                                list.addAll(slices);
                            }
                            catch (Exception e) {
                                log.error("build ddl exception:", (Throwable)e);
                            }
                            break block70;
                        }
                        if (!(differ instanceof ColumnsDiffer)) break block75;
                        boolean slice = this.slice();
                        ColumnsDiffer df = (ColumnsDiffer)differ;
                        LinkedHashMap adds = df.getAdds();
                        LinkedHashMap drops = df.getDrops();
                        LinkedHashMap updates = df.getAlters();
                        Table direct = differ.getDirect();
                        ArrayList<Run> slices = new ArrayList<Run>();
                        for (Column add : adds.values()) {
                            try {
                                if (null == direct) {
                                    direct = add.getTable();
                                }
                                slices.addAll(this.buildAddRun(runtime, add, slice));
                            }
                            catch (Exception e) {
                                log.error("build ddl exception:", (Throwable)e);
                            }
                        }
                        for (Column update : updates.values()) {
                            try {
                                if (null == direct) {
                                    direct = update.getTable();
                                }
                                slices.addAll(this.buildAlterRun(runtime, update, slice));
                            }
                            catch (Exception e) {
                                log.error("build ddl exception:", (Throwable)e);
                            }
                        }
                        for (Column drop : drops.values()) {
                            try {
                                if (null == direct) {
                                    direct = drop.getTable();
                                }
                                slices.addAll(this.buildDropRun(runtime, drop, slice));
                            }
                            catch (Exception e) {
                                log.error("build ddl exception:", (Throwable)e);
                            }
                        }
                        if (merge) {
                            list.addAll(this.merge(runtime, direct, slices));
                        } else {
                            list.addAll(slices);
                        }
                        break block70;
                    }
                    if (!(differ instanceof IndexesDiffer)) break block76;
                    IndexesDiffer df = (IndexesDiffer)differ;
                    LinkedHashMap adds = df.getAdds();
                    LinkedHashMap drops = df.getDrops();
                    LinkedHashMap updates = df.getAlters();
                    for (Index add : adds.values()) {
                        try {
                            list.addAll(this.buildAddRun(runtime, add));
                        }
                        catch (Exception e) {
                            log.error("build ddl exception:", (Throwable)e);
                        }
                    }
                    for (Index update : updates.values()) {
                        try {
                            list.addAll(this.buildAlterRun(runtime, update));
                        }
                        catch (Exception e) {
                            log.error("build ddl exception:", (Throwable)e);
                        }
                    }
                    for (Index drop : drops.values()) {
                        try {
                            list.addAll(this.buildDropRun(runtime, drop));
                        }
                        catch (Exception e) {
                            log.error("build ddl exception:", (Throwable)e);
                        }
                    }
                    break block70;
                }
                if (!(differ instanceof FunctionsDiffer)) break block77;
                FunctionsDiffer df = (FunctionsDiffer)differ;
                List adds = df.getAdds();
                List drops = df.getDrops();
                List updates = df.getAlters();
                for (Function add : adds) {
                    try {
                        list.addAll(this.buildCreateRun(runtime, add));
                    }
                    catch (Exception e) {
                        log.error("build ddl exception:", (Throwable)e);
                    }
                }
                for (Function update : updates) {
                    try {
                        list.addAll(this.buildAlterRun(runtime, update));
                    }
                    catch (Exception e) {
                        log.error("build ddl exception:", (Throwable)e);
                    }
                }
                for (Function drop : drops) {
                    try {
                        list.addAll(this.buildDropRun(runtime, drop));
                    }
                    catch (Exception e) {
                        log.error("build ddl exception:", (Throwable)e);
                    }
                }
                break block70;
            }
            if (!(differ instanceof ProceduresDiffer)) break block70;
            ProceduresDiffer df = (ProceduresDiffer)differ;
            LinkedHashMap adds = df.getAdds();
            LinkedHashMap drops = df.getDrops();
            LinkedHashMap updates = df.getUpdates();
            for (Procedure add : adds.values()) {
                try {
                    list.addAll(this.buildCreateRun(runtime, add));
                }
                catch (Exception e) {
                    log.error("build ddl exception:", (Throwable)e);
                }
            }
            for (Procedure update : updates.values()) {
                try {
                    list.addAll(this.buildAlterRun(runtime, update));
                }
                catch (Exception e) {
                    log.error("build ddl exception:", (Throwable)e);
                }
            }
            for (Procedure drop : drops.values()) {
                try {
                    list.addAll(this.buildDropRun(runtime, drop));
                }
                catch (Exception e) {
                    log.error("build ddl exception:", (Throwable)e);
                }
            }
        }
        return list;
    }

    default public List<Run> ddl(DataRuntime runtime, String random, List<MetadataDiffer> differs) {
        ArrayList<Run> list = new ArrayList<Run>();
        for (MetadataDiffer differ : differs) {
            list.addAll(this.ddl(runtime, random, differ));
        }
        return list;
    }

    public long insert(DataRuntime var1, String var2, int var3, Table var4, Object var5, ConfigStore var6, List<String> var7);

    default public long insert(DataRuntime runtime, String random, int batch, Table dest, Object data, List<String> columns) {
        return this.insert(runtime, random, batch, dest, data, null, columns);
    }

    default public long insert(DataRuntime runtime, String random, int batch, Table dest, Object data, String ... columns) {
        return this.insert(runtime, random, batch, dest, data, (List<String>)BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    default public long insert(DataRuntime runtime, String random, int batch, Object data, String ... columns) {
        return this.insert(runtime, random, batch, DataSourceUtil.parseDest(null, data, null), data, (List<String>)BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    default public long insert(DataRuntime runtime, String random, Table dest, Object data, List<String> columns) {
        return this.insert(runtime, random, 0, dest, data, columns);
    }

    default public long insert(DataRuntime runtime, String random, Table dest, Object data, String ... columns) {
        return this.insert(runtime, random, dest, data, (List<String>)BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    default public long insert(DataRuntime runtime, String random, Object data, String ... columns) {
        return this.insert(runtime, random, DataSourceUtil.parseDest(null, data, null), data, (List<String>)BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    default public long insert(DataRuntime runtime, String random, int batch, String dest, Object data, ConfigStore configs, List<String> columns) {
        return this.insert(runtime, random, batch, DataSourceUtil.parseDest(dest, data, configs), data, configs, columns);
    }

    default public long insert(DataRuntime runtime, String random, int batch, String dest, Object data, List<String> columns) {
        return this.insert(runtime, random, batch, dest, data, null, columns);
    }

    default public long insert(DataRuntime runtime, String random, int batch, String dest, Object data, String ... columns) {
        return this.insert(runtime, random, batch, dest, data, (List<String>)BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    default public long insert(DataRuntime runtime, String random, String dest, Object data, List<String> columns) {
        return this.insert(runtime, random, 0, dest, data, columns);
    }

    default public long insert(DataRuntime runtime, String random, String dest, Object data, String ... columns) {
        return this.insert(runtime, random, dest, data, (List<String>)BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    public long insert(DataRuntime var1, String var2, Table var3, RunPrepare var4, ConfigStore var5, Object var6, String ... var7);

    public Run buildInsertRun(DataRuntime var1, Table var2, RunPrepare var3, ConfigStore var4, Object var5, Boolean var6, Boolean var7, String ... var8);

    public Run buildInsertRun(DataRuntime var1, int var2, Table var3, Object var4, ConfigStore var5, Boolean var6, Boolean var7, List<String> var8);

    default public Run buildInsertRun(DataRuntime runtime, int batch, Table dest, Object obj, Boolean placeholder, Boolean unicode, List<String> columns) {
        return this.buildInsertRun(runtime, batch, dest, obj, null, placeholder, unicode, columns);
    }

    default public Run buildInsertRun(DataRuntime runtime, int batch, Table dest, Object obj, Boolean placeholder, Boolean unicode, String ... columns) {
        return this.buildInsertRun(runtime, batch, dest, obj, placeholder, unicode, (List<String>)BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    default public Run buildInsertRun(DataRuntime runtime, int batch, Table dest, Object obj, ConfigStore confgis, Boolean placeholder, Boolean unicode, String ... columns) {
        return this.buildInsertRun(runtime, batch, dest, obj, confgis, placeholder, unicode, (List<String>)BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    default public Run buildInsertRun(DataRuntime runtime, int batch, Object obj, Boolean placeholder, Boolean unicode, String ... columns) {
        return this.buildInsertRun(runtime, batch, DataSourceUtil.parseDest(null, obj, null), obj, placeholder, unicode, (List<String>)BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    default public Run buildInsertRun(DataRuntime runtime, int batch, Object obj, ConfigStore configs, Boolean placeholder, Boolean unicode, String ... columns) {
        return this.buildInsertRun(runtime, batch, DataSourceUtil.parseDest(null, obj, configs), obj, configs, placeholder, unicode, (List<String>)BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    default public Run buildInsertRun(DataRuntime runtime, int batch, ConfigStore configs, Object obj, Boolean placeholder, Boolean unicode, String ... columns) {
        return this.buildInsertRun(runtime, batch, DataSourceUtil.parseDest(null, obj, configs), obj, configs, placeholder, unicode, (List<String>)BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    default public Run buildInsertRun(DataRuntime runtime, int batch, String dest, Object obj, ConfigStore configs, Boolean placeholder, Boolean unicode, List<String> columns) {
        return this.buildInsertRun(runtime, batch, DataSourceUtil.parseDest(dest, obj, configs), obj, configs, placeholder, unicode, columns);
    }

    default public Run buildInsertRun(DataRuntime runtime, int batch, String dest, Object obj, Boolean placeholder, Boolean unicode, List<String> columns) {
        return this.buildInsertRun(runtime, batch, dest, obj, null, placeholder, unicode, columns);
    }

    default public Run buildInsertRun(DataRuntime runtime, int batch, String dest, Object obj, Boolean placeholder, Boolean unicode, String ... columns) {
        return this.buildInsertRun(runtime, batch, dest, obj, placeholder, unicode, (List<String>)BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    default public Run buildInsertRun(DataRuntime runtime, int batch, String dest, Object obj, ConfigStore confgis, Boolean placeholder, Boolean unicode, String ... columns) {
        return this.buildInsertRun(runtime, batch, dest, obj, confgis, placeholder, unicode, (List<String>)BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    public void fillInsertContent(DataRuntime var1, Run var2, Table var3, Collection var4, ConfigStore var5, Boolean var6, Boolean var7, LinkedHashMap<String, Column> var8);

    default public void fillInsertContent(DataRuntime runtime, Run run, Table dest, Collection list, Boolean placeholder, Boolean unicode, LinkedHashMap<String, Column> columns) {
        this.fillInsertContent(runtime, run, dest, list, null, placeholder, unicode, columns);
    }

    public void fillInsertContent(DataRuntime var1, Run var2, Table var3, DataSet var4, ConfigStore var5, Boolean var6, Boolean var7, LinkedHashMap<String, Column> var8);

    default public void fillInsertContent(DataRuntime runtime, Run run, Table dest, DataSet set, Boolean placeholder, Boolean unicode, LinkedHashMap<String, Column> columns) {
        this.fillInsertContent(runtime, run, dest, set, null, placeholder, unicode, columns);
    }

    default public void fillInsertContent(DataRuntime runtime, Run run, String dest, Collection list, ConfigStore configs, Boolean placeholder, Boolean unicode, LinkedHashMap<String, Column> columns) {
        this.fillInsertContent(runtime, run, DataSourceUtil.parseDest(dest, list, configs), list, configs, placeholder, unicode, columns);
    }

    default public void fillInsertContent(DataRuntime runtime, Run run, String dest, Collection list, Boolean placeholder, Boolean unicode, LinkedHashMap<String, Column> columns) {
        this.fillInsertContent(runtime, run, dest, list, null, placeholder, unicode, columns);
    }

    default public void fillInsertContent(DataRuntime runtime, Run run, String dest, DataSet set, ConfigStore configs, Boolean placeholder, Boolean unicode, LinkedHashMap<String, Column> columns) {
        this.fillInsertContent(runtime, run, DataSourceUtil.parseDest(dest, set, configs), set, configs, placeholder, unicode, columns);
    }

    default public void fillInsertContent(DataRuntime runtime, Run run, String dest, DataSet set, Boolean placeholder, Boolean unicode, LinkedHashMap<String, Column> columns) {
        this.fillInsertContent(runtime, run, dest, set, null, placeholder, unicode, columns);
    }

    default public Run buildInsertRun(DataRuntime runtime, Table dest, RunPrepare prepare, ConfigStore configs, Object obj, String ... conditions) {
        return this.buildInsertRun(runtime, dest, prepare, configs, obj, (Boolean)true, (Boolean)true, conditions);
    }

    default public Run buildInsertRun(DataRuntime runtime, int batch, Table dest, Object obj, ConfigStore configs, List<String> columns) {
        return this.buildInsertRun(runtime, batch, dest, obj, configs, (Boolean)true, (Boolean)true, columns);
    }

    default public Run buildInsertRun(DataRuntime runtime, int batch, Table dest, Object obj, List<String> columns) {
        return this.buildInsertRun(runtime, batch, dest, obj, null, (Boolean)true, (Boolean)true, columns);
    }

    default public Run buildInsertRun(DataRuntime runtime, int batch, Table dest, Object obj, String ... columns) {
        return this.buildInsertRun(runtime, batch, dest, obj, (Boolean)true, (Boolean)true, (List<String>)BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    default public Run buildInsertRun(DataRuntime runtime, int batch, Table dest, Object obj, ConfigStore confgis, String ... columns) {
        return this.buildInsertRun(runtime, batch, dest, obj, confgis, (Boolean)true, (Boolean)true, (List<String>)BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    default public Run buildInsertRun(DataRuntime runtime, int batch, Object obj, String ... columns) {
        return this.buildInsertRun(runtime, batch, DataSourceUtil.parseDest(null, obj, null), obj, (Boolean)true, (Boolean)true, (List<String>)BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    default public Run buildInsertRun(DataRuntime runtime, int batch, Object obj, ConfigStore configs, String ... columns) {
        return this.buildInsertRun(runtime, batch, DataSourceUtil.parseDest(null, obj, configs), obj, configs, (Boolean)true, (Boolean)true, (List<String>)BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    default public Run buildInsertRun(DataRuntime runtime, int batch, ConfigStore configs, Object obj, String ... columns) {
        return this.buildInsertRun(runtime, batch, DataSourceUtil.parseDest(null, obj, configs), obj, configs, (Boolean)true, (Boolean)true, (List<String>)BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    default public Run buildInsertRun(DataRuntime runtime, int batch, String dest, Object obj, ConfigStore configs, List<String> columns) {
        return this.buildInsertRun(runtime, batch, DataSourceUtil.parseDest(dest, obj, configs), obj, configs, (Boolean)true, (Boolean)true, columns);
    }

    default public Run buildInsertRun(DataRuntime runtime, int batch, String dest, Object obj, List<String> columns) {
        return this.buildInsertRun(runtime, batch, dest, obj, null, (Boolean)true, (Boolean)true, columns);
    }

    default public Run buildInsertRun(DataRuntime runtime, int batch, String dest, Object obj, String ... columns) {
        return this.buildInsertRun(runtime, batch, dest, obj, (Boolean)true, (Boolean)true, (List<String>)BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    default public Run buildInsertRun(DataRuntime runtime, int batch, String dest, Object obj, ConfigStore confgis, String ... columns) {
        return this.buildInsertRun(runtime, batch, dest, obj, confgis, (Boolean)true, (Boolean)true, (List<String>)BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    default public void fillInsertContent(DataRuntime runtime, Run run, Table dest, Collection list, ConfigStore configs, LinkedHashMap<String, Column> columns) {
        this.fillInsertContent(runtime, run, dest, list, configs, (Boolean)true, (Boolean)true, columns);
    }

    default public void fillInsertContent(DataRuntime runtime, Run run, Table dest, Collection list, LinkedHashMap<String, Column> columns) {
        this.fillInsertContent(runtime, run, dest, list, null, (Boolean)true, (Boolean)true, columns);
    }

    default public void fillInsertContent(DataRuntime runtime, Run run, Table dest, DataSet set, ConfigStore configs, LinkedHashMap<String, Column> columns) {
        this.fillInsertContent(runtime, run, dest, set, configs, (Boolean)true, (Boolean)true, columns);
    }

    default public void fillInsertContent(DataRuntime runtime, Run run, Table dest, DataSet set, LinkedHashMap<String, Column> columns) {
        this.fillInsertContent(runtime, run, dest, set, null, (Boolean)true, (Boolean)true, columns);
    }

    default public void fillInsertContent(DataRuntime runtime, Run run, String dest, Collection list, ConfigStore configs, LinkedHashMap<String, Column> columns) {
        this.fillInsertContent(runtime, run, DataSourceUtil.parseDest(dest, list, configs), list, configs, (Boolean)true, (Boolean)true, columns);
    }

    default public void fillInsertContent(DataRuntime runtime, Run run, String dest, Collection list, LinkedHashMap<String, Column> columns) {
        this.fillInsertContent(runtime, run, dest, list, null, (Boolean)true, (Boolean)true, columns);
    }

    default public void fillInsertContent(DataRuntime runtime, Run run, String dest, DataSet set, ConfigStore configs, LinkedHashMap<String, Column> columns) {
        this.fillInsertContent(runtime, run, DataSourceUtil.parseDest(dest, set, configs), set, configs, (Boolean)true, (Boolean)true, columns);
    }

    default public void fillInsertContent(DataRuntime runtime, Run run, String dest, DataSet set, LinkedHashMap<String, Column> columns) {
        this.fillInsertContent(runtime, run, dest, set, null, (Boolean)true, (Boolean)true, columns);
    }

    public void fillInsertCreateTemplate(DataRuntime var1, Run var2, PartitionTable var3, ConfigStore var4);

    public LinkedHashMap<String, Column> confirmInsertColumns(DataRuntime var1, Table var2, Object var3, ConfigStore var4, List<String> var5, boolean var6);

    default public LinkedHashMap<String, Column> confirmInsertColumns(DataRuntime runtime, String dest, Object data, ConfigStore configs, List<String> columns, boolean batch) {
        return this.confirmInsertColumns(runtime, DataSourceUtil.parseDest(dest, data, configs), data, configs, columns, batch);
    }

    public String batchInsertSeparator();

    public boolean supportInsertPlaceholder();

    public String generatedKey();

    public long insert(DataRuntime var1, String var2, Object var3, ConfigStore var4, Run var5, String[] var6);

    public boolean supportKeyHolder(DataRuntime var1, ConfigStore var2);

    public List<String> keyHolders(DataRuntime var1, ConfigStore var2);

    public long update(DataRuntime var1, String var2, int var3, Table var4, Object var5, ConfigStore var6, List<String> var7);

    default public long update(DataRuntime runtime, String random, int batch, Object data, ConfigStore configs, List<String> columns) {
        return this.update(runtime, random, batch, DataSourceUtil.parseDest(null, data, configs), data, configs, columns);
    }

    default public long update(DataRuntime runtime, String random, int batch, Table dest, Object data, List<String> columns) {
        return this.update(runtime, random, batch, dest, data, null, columns);
    }

    default public long update(DataRuntime runtime, String random, int batch, Object data, List<String> columns) {
        return this.update(runtime, random, batch, DataSourceUtil.parseDest(null, data, null), data, null, columns);
    }

    default public long update(DataRuntime runtime, String random, int batch, Object data, ConfigStore configs) {
        return this.update(runtime, random, batch, DataSourceUtil.parseDest(null, data, configs), data, configs, new String[0]);
    }

    default public long update(DataRuntime runtime, String random, int batch, Table dest, Object data, ConfigStore configs, String ... columns) {
        return this.update(runtime, random, batch, dest, data, configs, (List<String>)BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    default public long update(DataRuntime runtime, String random, int batch, Object data, ConfigStore configs, String ... columns) {
        return this.update(runtime, random, batch, DataSourceUtil.parseDest(null, data, configs), data, configs, (List<String>)BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    default public long update(DataRuntime runtime, String random, int batch, Table dest, Object data, String ... columns) {
        return this.update(runtime, random, batch, dest, data, BeanUtil.array2string((Object[])columns));
    }

    default public long update(DataRuntime runtime, String random, int batch, Object data, String ... columns) {
        return this.update(runtime, random, batch, DataSourceUtil.parseDest(null, data, null), data, BeanUtil.array2string((Object[])columns));
    }

    default public long update(DataRuntime runtime, String random, Table dest, Object data, ConfigStore configs, List<String> columns) {
        return this.update(runtime, random, 0, dest, data, configs, columns);
    }

    default public long update(DataRuntime runtime, String random, Object data, ConfigStore configs, List<String> columns) {
        return this.update(runtime, random, 0, DataSourceUtil.parseDest(null, data, configs), data, configs, columns);
    }

    default public long update(DataRuntime runtime, String random, Table dest, Object data, List<String> columns) {
        return this.update(runtime, random, 0, dest, data, null, columns);
    }

    default public long update(DataRuntime runtime, String random, Object data, List<String> columns) {
        return this.update(runtime, random, 0, DataSourceUtil.parseDest(null, data, null), data, null, columns);
    }

    default public long update(DataRuntime runtime, String random, Object data, ConfigStore configs) {
        return this.update(runtime, random, 0, DataSourceUtil.parseDest(null, data, configs), data, configs, new String[0]);
    }

    default public long update(DataRuntime runtime, String random, Table dest, Object data, ConfigStore configs, String ... columns) {
        return this.update(runtime, random, 0, dest, data, configs, (List<String>)BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    default public long update(DataRuntime runtime, String random, Object data, ConfigStore configs, String ... columns) {
        return this.update(runtime, random, 0, DataSourceUtil.parseDest(null, data, configs), data, configs, (List<String>)BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    default public long update(DataRuntime runtime, String random, Table dest, Object data, String ... columns) {
        return this.update(runtime, random, 0, dest, data, BeanUtil.array2string((Object[])columns));
    }

    default public long update(DataRuntime runtime, String random, Object data, String ... columns) {
        return this.update(runtime, random, 0, DataSourceUtil.parseDest(null, data, null), data, BeanUtil.array2string((Object[])columns));
    }

    default public long update(DataRuntime runtime, String random, int batch, String dest, Object data, ConfigStore configs, List<String> columns) {
        return this.update(runtime, random, batch, DataSourceUtil.parseDest(dest, data, configs), data, configs, columns);
    }

    default public long update(DataRuntime runtime, String random, int batch, String dest, Object data, List<String> columns) {
        return this.update(runtime, random, batch, dest, data, null, columns);
    }

    default public long update(DataRuntime runtime, String random, int batch, String dest, Object data, ConfigStore configs, String ... columns) {
        return this.update(runtime, random, batch, dest, data, configs, (List<String>)BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    default public long update(DataRuntime runtime, String random, int batch, String dest, Object data, String ... columns) {
        return this.update(runtime, random, batch, dest, data, BeanUtil.array2string((Object[])columns));
    }

    default public long update(DataRuntime runtime, String random, String dest, Object data, ConfigStore configs, List<String> columns) {
        return this.update(runtime, random, 0, dest, data, configs, columns);
    }

    default public long update(DataRuntime runtime, String random, String dest, Object data, List<String> columns) {
        return this.update(runtime, random, 0, dest, data, null, columns);
    }

    default public long update(DataRuntime runtime, String random, String dest, Object data, ConfigStore configs, String ... columns) {
        return this.update(runtime, random, 0, dest, data, configs, (List<String>)BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    default public long update(DataRuntime runtime, String random, String dest, Object data, String ... columns) {
        return this.update(runtime, random, 0, dest, data, BeanUtil.array2string((Object[])columns));
    }

    public long update(DataRuntime var1, String var2, RunPrepare var3, DataRow var4, ConfigStore var5, String ... var6);

    public Run buildUpdateRun(DataRuntime var1, RunPrepare var2, DataRow var3, ConfigStore var4, Boolean var5, Boolean var6, String ... var7);

    public void fillUpdateContent(DataRuntime var1, TableRun var2, StringBuilder var3, DataRow var4, ConfigStore var5, Boolean var6, Boolean var7);

    default public void fillUpdateContent(DataRuntime runtime, TableRun run, DataRow data, ConfigStore configs, Boolean placeholder, Boolean unicode) {
        this.fillUpdateContent(runtime, run, run.getBuilder(), data, configs, placeholder, unicode);
    }

    public Run buildUpdateRun(DataRuntime var1, int var2, Table var3, Object var4, ConfigStore var5, Boolean var6, Boolean var7, List<String> var8);

    public Run buildUpdateRunLimit(DataRuntime var1, Run var2);

    default public Run buildUpdateRun(DataRuntime runtime, Table dest, Object obj, ConfigStore configs, Boolean placeholder, Boolean unicode, List<String> columns) {
        return this.buildUpdateRun(runtime, 0, dest, obj, configs, placeholder, unicode, columns);
    }

    default public Run buildUpdateRun(DataRuntime runtime, Object obj, ConfigStore configs, Boolean placeholder, Boolean unicode, List<String> columns) {
        return this.buildUpdateRun(runtime, DataSourceUtil.parseDest(null, obj, configs), obj, configs, placeholder, unicode, columns);
    }

    default public Run buildUpdateRun(DataRuntime runtime, Table dest, Object obj, Boolean placeholder, Boolean unicode, List<String> columns) {
        return this.buildUpdateRun(runtime, dest, obj, null, placeholder, unicode, columns);
    }

    default public Run buildUpdateRun(DataRuntime runtime, Object obj, Boolean placeholder, Boolean unicode, List<String> columns) {
        return this.buildUpdateRun(runtime, DataSourceUtil.parseDest(null, obj, null), obj, null, placeholder, unicode, columns);
    }

    default public Run buildUpdateRun(DataRuntime runtime, Table dest, Object obj, ConfigStore configs, Boolean placeholder, Boolean unicode, String ... columns) {
        return this.buildUpdateRun(runtime, dest, obj, configs, placeholder, unicode, (List<String>)BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    default public Run buildUpdateRun(DataRuntime runtime, Object obj, ConfigStore configs, Boolean placeholder, Boolean unicode, String ... columns) {
        return this.buildUpdateRun(runtime, DataSourceUtil.parseDest(null, obj, configs), obj, configs, placeholder, unicode, (List<String>)BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    default public Run buildUpdateRun(DataRuntime runtime, Table dest, Object obj, Boolean placeholder, Boolean unicode, String ... columns) {
        return this.buildUpdateRun(runtime, dest, obj, null, placeholder, unicode, (List<String>)BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    default public Run buildUpdateRun(DataRuntime runtime, Object obj, Boolean placeholder, Boolean unicode, String ... columns) {
        return this.buildUpdateRun(runtime, DataSourceUtil.parseDest(null, obj, null), obj, null, placeholder, unicode, (List<String>)BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    public Run buildUpdateRunFromEntity(DataRuntime var1, Table var2, Object var3, ConfigStore var4, Boolean var5, Boolean var6, LinkedHashMap<String, Column> var7);

    public Run buildUpdateRunFromDataRow(DataRuntime var1, Table var2, DataRow var3, ConfigStore var4, Boolean var5, Boolean var6, LinkedHashMap<String, Column> var7);

    public Run buildUpdateRunFromCollection(DataRuntime var1, int var2, Table var3, Collection var4, ConfigStore var5, Boolean var6, Boolean var7, LinkedHashMap<String, Column> var8);

    default public Run buildUpdateRun(DataRuntime runtime, int batch, String dest, Object obj, ConfigStore configs, Boolean placeholder, Boolean unicode, List<String> columns) {
        return this.buildUpdateRun(runtime, batch, DataSourceUtil.parseDest(dest, obj, configs), obj, configs, placeholder, unicode, columns);
    }

    default public Run buildUpdateRun(DataRuntime runtime, String dest, Object obj, ConfigStore configs, Boolean placeholder, Boolean unicode, List<String> columns) {
        return this.buildUpdateRun(runtime, 0, dest, obj, configs, placeholder, unicode, columns);
    }

    default public Run buildUpdateRun(DataRuntime runtime, String dest, Object obj, Boolean placeholder, Boolean unicode, List<String> columns) {
        return this.buildUpdateRun(runtime, dest, obj, null, placeholder, unicode, columns);
    }

    default public Run buildUpdateRun(DataRuntime runtime, String dest, Object obj, ConfigStore configs, Boolean placeholder, Boolean unicode, String ... columns) {
        return this.buildUpdateRun(runtime, dest, obj, configs, placeholder, unicode, (List<String>)BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    default public Run buildUpdateRun(DataRuntime runtime, String dest, Object obj, Boolean placeholder, Boolean unicode, String ... columns) {
        return this.buildUpdateRun(runtime, dest, obj, null, placeholder, unicode, (List<String>)BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    default public Run buildUpdateRunFromEntity(DataRuntime runtime, String dest, Object obj, ConfigStore configs, Boolean placeholder, Boolean unicode, LinkedHashMap<String, Column> columns) {
        return this.buildUpdateRunFromEntity(runtime, DataSourceUtil.parseDest(dest, obj, configs), obj, configs, placeholder, unicode, columns);
    }

    default public Run buildUpdateRunFromDataRow(DataRuntime runtime, String dest, DataRow row, ConfigStore configs, Boolean placeholder, Boolean unicode, LinkedHashMap<String, Column> columns) {
        return this.buildUpdateRunFromDataRow(runtime, DataSourceUtil.parseDest(dest, row, configs), row, configs, placeholder, unicode, columns);
    }

    default public Run buildUpdateRunFromCollection(DataRuntime runtime, int batch, String dest, Collection list, ConfigStore configs, Boolean placeholder, Boolean unicode, LinkedHashMap<String, Column> columns) {
        return this.buildUpdateRunFromCollection(runtime, batch, DataSourceUtil.parseDest(dest, list, configs), list, configs, placeholder, unicode, columns);
    }

    default public Run buildUpdateRun(DataRuntime runtime, RunPrepare prepare, DataRow data, ConfigStore configs, String ... conditions) {
        return this.buildUpdateRun(runtime, prepare, data, configs, (Boolean)true, (Boolean)true, conditions);
    }

    default public void fillUpdateContent(DataRuntime runtime, TableRun run, StringBuilder builder, DataRow data, ConfigStore configs) {
        this.fillUpdateContent(runtime, run, builder, data, configs, true, true);
    }

    default public void fillUpdateContent(DataRuntime runtime, TableRun run, DataRow data, ConfigStore configs) {
        this.fillUpdateContent(runtime, run, run.getBuilder(), data, configs, true, true);
    }

    default public Run buildUpdateRun(DataRuntime runtime, int btch, Table dest, Object obj, ConfigStore configs, List<String> columns) {
        return this.buildUpdateRun(runtime, btch, dest, obj, configs, (Boolean)true, (Boolean)true, columns);
    }

    default public Run buildUpdateRun(DataRuntime runtime, Table dest, Object obj, ConfigStore configs, List<String> columns) {
        return this.buildUpdateRun(runtime, 0, dest, obj, configs, (Boolean)true, (Boolean)true, columns);
    }

    default public Run buildUpdateRun(DataRuntime runtime, Object obj, ConfigStore configs, List<String> columns) {
        return this.buildUpdateRun(runtime, DataSourceUtil.parseDest(null, obj, configs), obj, configs, (Boolean)true, (Boolean)true, columns);
    }

    default public Run buildUpdateRun(DataRuntime runtime, Table dest, Object obj, List<String> columns) {
        return this.buildUpdateRun(runtime, dest, obj, null, (Boolean)true, (Boolean)true, columns);
    }

    default public Run buildUpdateRun(DataRuntime runtime, Object obj, List<String> columns) {
        return this.buildUpdateRun(runtime, DataSourceUtil.parseDest(null, obj, null), obj, null, (Boolean)true, (Boolean)true, columns);
    }

    default public Run buildUpdateRun(DataRuntime runtime, Table dest, Object obj, ConfigStore configs, String ... columns) {
        return this.buildUpdateRun(runtime, dest, obj, configs, (Boolean)true, (Boolean)true, (List<String>)BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    default public Run buildUpdateRun(DataRuntime runtime, Object obj, ConfigStore configs, String ... columns) {
        return this.buildUpdateRun(runtime, DataSourceUtil.parseDest(null, obj, configs), obj, configs, (Boolean)true, (Boolean)true, (List<String>)BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    default public Run buildUpdateRun(DataRuntime runtime, Table dest, Object obj, String ... columns) {
        return this.buildUpdateRun(runtime, dest, obj, null, (Boolean)true, (Boolean)true, (List<String>)BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    default public Run buildUpdateRun(DataRuntime runtime, Object obj, String ... columns) {
        return this.buildUpdateRun(runtime, DataSourceUtil.parseDest(null, obj, null), obj, null, (Boolean)true, (Boolean)true, (List<String>)BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    default public Run buildUpdateRunFromEntity(DataRuntime runtime, Table dest, Object obj, ConfigStore configs, LinkedHashMap<String, Column> columns) {
        return this.buildUpdateRunFromEntity(runtime, dest, obj, configs, (Boolean)true, (Boolean)true, columns);
    }

    default public Run buildUpdateRunFromDataRow(DataRuntime runtime, Table dest, DataRow row, ConfigStore configs, LinkedHashMap<String, Column> columns) {
        return this.buildUpdateRunFromDataRow(runtime, dest, row, configs, (Boolean)true, (Boolean)true, columns);
    }

    default public Run buildUpdateRunFromCollection(DataRuntime runtime, int batch, Table dest, Collection list, ConfigStore configs, LinkedHashMap<String, Column> columns) {
        return this.buildUpdateRunFromCollection(runtime, batch, dest, list, configs, (Boolean)true, (Boolean)true, columns);
    }

    default public Run buildUpdateRun(DataRuntime runtime, int batch, String dest, Object obj, ConfigStore configs, List<String> columns) {
        return this.buildUpdateRun(runtime, batch, DataSourceUtil.parseDest(dest, obj, configs), obj, configs, (Boolean)true, (Boolean)true, columns);
    }

    default public Run buildUpdateRun(DataRuntime runtime, String dest, Object obj, ConfigStore configs, List<String> columns) {
        return this.buildUpdateRun(runtime, 0, dest, obj, configs, (Boolean)true, (Boolean)true, columns);
    }

    default public Run buildUpdateRun(DataRuntime runtime, String dest, Object obj, List<String> columns) {
        return this.buildUpdateRun(runtime, dest, obj, null, (Boolean)true, (Boolean)true, columns);
    }

    default public Run buildUpdateRun(DataRuntime runtime, String dest, Object obj, ConfigStore configs, String ... columns) {
        return this.buildUpdateRun(runtime, dest, obj, configs, (Boolean)true, (Boolean)true, (List<String>)BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    default public Run buildUpdateRun(DataRuntime runtime, String dest, Object obj, String ... columns) {
        return this.buildUpdateRun(runtime, dest, obj, null, (Boolean)true, (Boolean)true, (List<String>)BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    default public Run buildUpdateRunFromEntity(DataRuntime runtime, String dest, Object obj, ConfigStore configs, LinkedHashMap<String, Column> columns) {
        return this.buildUpdateRunFromEntity(runtime, DataSourceUtil.parseDest(dest, obj, configs), obj, configs, (Boolean)true, (Boolean)true, columns);
    }

    default public Run buildUpdateRunFromDataRow(DataRuntime runtime, String dest, DataRow row, ConfigStore configs, LinkedHashMap<String, Column> columns) {
        return this.buildUpdateRunFromDataRow(runtime, DataSourceUtil.parseDest(dest, row, configs), row, configs, (Boolean)true, (Boolean)true, columns);
    }

    default public Run buildUpdateRunFromCollection(DataRuntime runtime, int batch, String dest, Collection list, ConfigStore configs, LinkedHashMap<String, Column> columns) {
        return this.buildUpdateRunFromCollection(runtime, batch, DataSourceUtil.parseDest(dest, list, configs), list, configs, (Boolean)true, (Boolean)true, columns);
    }

    public LinkedHashMap<String, Column> confirmUpdateColumns(DataRuntime var1, Table var2, DataRow var3, ConfigStore var4, List<String> var5);

    public LinkedHashMap<String, Column> confirmUpdateColumns(DataRuntime var1, Table var2, Object var3, ConfigStore var4, List<String> var5);

    default public LinkedHashMap<String, Column> confirmUpdateColumns(DataRuntime runtime, String dest, DataRow row, ConfigStore configs, List<String> columns) {
        return this.confirmUpdateColumns(runtime, DataSourceUtil.parseDest(dest, row, configs), row, configs, columns);
    }

    default public LinkedHashMap<String, Column> confirmUpdateColumns(DataRuntime runtime, String dest, Object obj, ConfigStore configs, List<String> columns) {
        return this.confirmUpdateColumns(runtime, DataSourceUtil.parseDest(dest, obj, configs), obj, configs, columns);
    }

    public long update(DataRuntime var1, String var2, Table var3, Object var4, ConfigStore var5, Run var6);

    default public long update(DataRuntime runtime, String random, String dest, Object data, ConfigStore configs, Run run) {
        return this.update(runtime, random, DataSourceUtil.parseDest(dest, data, configs), data, configs, run);
    }

    public long save(DataRuntime var1, String var2, Table var3, Object var4, ConfigStore var5, List<String> var6);

    default public long save(DataRuntime runtime, String random, Table dest, Object data, List<String> columns) {
        return this.save(runtime, random, dest, data, null, columns);
    }

    default public long save(DataRuntime runtime, String random, Object data, List<String> columns) {
        return this.save(runtime, random, DataSourceUtil.parseDest(null, data, null), data, columns);
    }

    default public long save(DataRuntime runtime, String random, Table dest, Object data, String ... columns) {
        return this.save(runtime, random, dest, data, (List<String>)BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    default public long save(DataRuntime runtime, String random, Object data, String ... columns) {
        return this.save(runtime, random, DataSourceUtil.parseDest(null, data, null), data, (List<String>)BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    default public long save(DataRuntime runtime, String random, String dest, Object data, ConfigStore configs, List<String> columns) {
        return this.save(runtime, random, DataSourceUtil.parseDest(dest, data, configs), data, configs, columns);
    }

    default public long save(DataRuntime runtime, String random, String dest, Object data, List<String> columns) {
        return this.save(runtime, random, dest, data, null, columns);
    }

    default public long save(DataRuntime runtime, String random, String dest, Object data, String ... columns) {
        return this.save(runtime, random, dest, data, (List<String>)BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    public DataSet querys(DataRuntime var1, String var2, RunPrepare var3, ConfigStore var4, String ... var5);

    public DataSet querys(DataRuntime var1, String var2, Procedure var3, PageNavi var4);

    public <T> EntitySet<T> selects(DataRuntime var1, String var2, RunPrepare var3, Class<T> var4, ConfigStore var5, String ... var6);

    public List<Map<String, Object>> maps(DataRuntime var1, String var2, RunPrepare var3, ConfigStore var4, String ... var5);

    public Run buildQueryRun(DataRuntime var1, RunPrepare var2, ConfigStore var3, Boolean var4, Boolean var5, String ... var6);

    default public Run buildQueryRun(DataRuntime runtime, RunPrepare prepare, ConfigStore configs, String ... conditions) {
        return this.buildQueryRun(runtime, prepare, configs, true, true, conditions);
    }

    default public Run initQueryRun(DataRuntime runtime, RunPrepare prepare) {
        Run run = prepare.build(runtime);
        if (null != run && null == run.action()) {
            run.action((ACTION)ACTION.DML.SELECT);
        }
        return run;
    }

    default public RunPrepare buildRunPrepare(DataRuntime runtime, String text) {
        return null;
    }

    public void parsePlaceholder(DataRuntime var1, Run var2);

    default public boolean supportSqlVarPlaceholderRegexExt(DataRuntime runtime) {
        return true;
    }

    default public String compareFormula(DataRuntime runtime, Compare compare) {
        return compare.formula();
    }

    public List<Run> buildQuerySequence(DataRuntime var1, boolean var2, String ... var3);

    public Run fillQueryContent(DataRuntime var1, StringBuilder var2, Run var3, Boolean var4, Boolean var5);

    default public Run fillQueryContent(DataRuntime runtime, StringBuilder builder, Run run) {
        return this.fillQueryContent(runtime, builder, run, true, true);
    }

    public Run fillQueryContent(DataRuntime var1, Run var2, Boolean var3, Boolean var4);

    default public Run fillQueryContent(DataRuntime runtime, Run run) {
        return this.fillQueryContent(runtime, run, true, true);
    }

    public String mergeFinalQuery(DataRuntime var1, Run var2);

    default public String orderNullSet(OrderStore orders) {
        return "";
    }

    public RunValue createConditionLike(DataRuntime var1, StringBuilder var2, Compare var3, Object var4, Boolean var5, Boolean var6);

    default public RunValue createConditionLike(DataRuntime runtime, StringBuilder builder, Compare compare, Object value) {
        return this.createConditionLike(runtime, builder, compare, value, true, true);
    }

    default public List<RunValue> createConditionExists(DataRuntime runtime, StringBuilder builder, Compare compare, RunPrepare prepare, Boolean placeholder, Boolean unicode) {
        return null;
    }

    default public List<RunValue> createConditionExists(DataRuntime runtime, StringBuilder builder, Compare compare, RunPrepare prepare) {
        return this.createConditionExists(runtime, builder, compare, prepare, true, true);
    }

    default public Object createConditionFindInSet(DataRuntime runtime, StringBuilder builder, String column, Compare compare, Object value, Boolean placeholder, Boolean unicode) throws NotSupportException {
        throw new NotSupportException("\u4e0d\u652f\u6301");
    }

    default public Object createConditionFindInSet(DataRuntime runtime, StringBuilder builder, String column, Compare compare, Object value) throws NotSupportException {
        return this.createConditionFindInSet(runtime, builder, column, compare, value, true, true);
    }

    default public Object createConditionJsonContains(DataRuntime runtime, StringBuilder builder, String column, Compare compare, Object value, Boolean placeholder, Boolean unicode) throws NotSupportException {
        throw new NotSupportException("\u4e0d\u652f\u6301");
    }

    default public Object createConditionJsonContains(DataRuntime runtime, StringBuilder builder, String column, Compare compare, Object value) throws NotSupportException {
        return this.createConditionJsonContains(runtime, builder, column, compare, value, true, true);
    }

    default public Object createConditionJsonContainsPath(DataRuntime runtime, StringBuilder builder, String column, Compare compare, Object value, Boolean placeholder, Boolean unicode) throws NotSupportException {
        throw new NotSupportException("\u4e0d\u652f\u6301");
    }

    default public Object createConditionJsonContainsPath(DataRuntime runtime, StringBuilder builder, String column, Compare compare, Object value) throws NotSupportException {
        return this.createConditionJsonContainsPath(runtime, builder, column, compare, value, true, true);
    }

    default public Object createConditionJsonSearch(DataRuntime runtime, StringBuilder builder, String column, Compare compare, Object value, Boolean placeholder, Boolean unicode) throws NotSupportException {
        throw new NotSupportException("\u4e0d\u652f\u6301");
    }

    default public Object createConditionJsonSearch(DataRuntime runtime, StringBuilder builder, String column, Compare compare, Object value) throws NotSupportException {
        return this.createConditionJsonSearch(runtime, builder, column, compare, value, true, true);
    }

    default public List<RunValue> createConditionIn(DataRuntime runtime, StringBuilder builder, Compare compare, Object value, Boolean placeholder, Boolean unicode) {
        return null;
    }

    default public List<RunValue> createConditionIn(DataRuntime runtime, StringBuilder builder, Compare compare, Object value) {
        return this.createConditionIn(runtime, builder, compare, value, true, true);
    }

    public DataSet select(DataRuntime var1, String var2, boolean var3, Table var4, ConfigStore var5, Run var6);

    default public DataSet select(DataRuntime runtime, String random, boolean system, String table, ConfigStore configs, Run run) {
        return this.select(runtime, random, system, new Table(table), configs, run);
    }

    public List<Map<String, Object>> maps(DataRuntime var1, String var2, ConfigStore var3, Run var4);

    public Map<String, Object> map(DataRuntime var1, String var2, ConfigStore var3, Run var4);

    public DataRow sequence(DataRuntime var1, String var2, boolean var3, String ... var4);

    public List<Map<String, Object>> process(DataRuntime var1, List<Map<String, Object>> var2);

    public long count(DataRuntime var1, String var2, RunPrepare var3, ConfigStore var4, String ... var5);

    public long count(DataRuntime var1, String var2, Run var3);

    public String mergeFinalTotal(DataRuntime var1, Run var2);

    public int length(DataRuntime var1, String var2, String var3, ConfigStore var4);

    public Run buildQueryLengthRun(DataRuntime var1, String var2, ConfigStore var3);

    public boolean exists(DataRuntime var1, String var2, RunPrepare var3, ConfigStore var4, String ... var5);

    public String mergeFinalExists(DataRuntime var1, Run var2);

    public long execute(DataRuntime var1, String var2, RunPrepare var3, ConfigStore var4, String ... var5);

    public long execute(DataRuntime var1, String var2, List<RunPrepare> var3, ConfigStore var4);

    public long execute(DataRuntime var1, String var2, int var3, ConfigStore var4, RunPrepare var5, Collection<Object> var6);

    public long execute(DataRuntime var1, String var2, int var3, int var4, ConfigStore var5, RunPrepare var6, Collection<Object> var7);

    public boolean execute(DataRuntime var1, String var2, Procedure var3);

    public Run buildExecuteRun(DataRuntime var1, RunPrepare var2, ConfigStore var3, Boolean var4, Boolean var5, String ... var6);

    default public Run buildExecuteRun(DataRuntime runtime, RunPrepare prepare, ConfigStore configs, String ... conditions) {
        return this.buildExecuteRun(runtime, prepare, configs, true, true, conditions);
    }

    public void fillExecuteContent(DataRuntime var1, Run var2, Boolean var3, Boolean var4);

    default public void fillExecuteContent(DataRuntime runtime, Run run) {
        this.fillExecuteContent(runtime, run, true, true);
    }

    public long execute(DataRuntime var1, String var2, ConfigStore var3, Run var4);

    public long execute(DataRuntime var1, String var2, ConfigStore var3, List<Run> var4);

    public <T> long deletes(DataRuntime var1, String var2, int var3, Table var4, ConfigStore var5, String var6, Collection<T> var7);

    default public <T> long deletes(DataRuntime runtime, String random, int batch, Table table, String column, Collection<T> values) {
        return this.deletes(runtime, random, batch, table, (ConfigStore)null, column, values);
    }

    default public <T> long deletes(DataRuntime runtime, String random, Table table, String column, Collection<T> values) {
        return this.deletes(runtime, random, 0, table, column, values);
    }

    default public <T> long deletes(DataRuntime runtime, String random, Table table, ConfigStore configs, String column, Collection<T> values) {
        return this.deletes(runtime, random, 0, table, configs, column, values);
    }

    default public <T> long deletes(DataRuntime runtime, String random, int batch, Table table, String column, T ... values) {
        return this.deletes(runtime, random, batch, table, column, (Collection<T>)BeanUtil.array2list((Object[][])new Object[][]{values}));
    }

    default public <T> long deletes(DataRuntime runtime, String random, int batch, Table table, ConfigStore configs, String column, T ... values) {
        return this.deletes(runtime, random, batch, table, configs, column, (Collection<T>)BeanUtil.array2list((Object[][])new Object[][]{values}));
    }

    default public <T> long deletes(DataRuntime runtime, String random, Table table, ConfigStore configs, String column, T ... values) {
        return this.deletes(runtime, random, 0, table, configs, column, (Collection<T>)BeanUtil.array2list((Object[][])new Object[][]{values}));
    }

    default public <T> long deletes(DataRuntime runtime, String random, Table table, String column, T ... values) {
        return this.deletes(runtime, random, 0, table, column, (Collection<T>)BeanUtil.array2list((Object[][])new Object[][]{values}));
    }

    default public <T> long deletes(DataRuntime runtime, String random, int batch, String table, ConfigStore configs, String column, Collection<T> values) {
        return this.deletes(runtime, random, batch, new Table(table), configs, column, values);
    }

    default public <T> long deletes(DataRuntime runtime, String random, int batch, String table, String column, Collection<T> values) {
        return this.deletes(runtime, random, batch, table, (ConfigStore)null, column, values);
    }

    default public <T> long deletes(DataRuntime runtime, String random, String table, String column, Collection<T> values) {
        return this.deletes(runtime, random, 0, table, column, values);
    }

    default public <T> long deletes(DataRuntime runtime, String random, String table, ConfigStore configs, String column, Collection<T> values) {
        return this.deletes(runtime, random, 0, table, configs, column, values);
    }

    default public <T> long deletes(DataRuntime runtime, String random, int batch, String table, String column, T ... values) {
        return this.deletes(runtime, random, batch, table, column, (Collection<T>)BeanUtil.array2list((Object[][])new Object[][]{values}));
    }

    default public <T> long deletes(DataRuntime runtime, String random, int batch, String table, ConfigStore configs, String column, T ... values) {
        return this.deletes(runtime, random, batch, table, configs, column, (Collection<T>)BeanUtil.array2list((Object[][])new Object[][]{values}));
    }

    default public <T> long deletes(DataRuntime runtime, String random, String table, ConfigStore configs, String column, T ... values) {
        return this.deletes(runtime, random, 0, table, configs, column, (Collection<T>)BeanUtil.array2list((Object[][])new Object[][]{values}));
    }

    default public <T> long deletes(DataRuntime runtime, String random, String table, String column, T ... values) {
        return this.deletes(runtime, random, 0, table, column, (Collection<T>)BeanUtil.array2list((Object[][])new Object[][]{values}));
    }

    public long delete(DataRuntime var1, String var2, Table var3, ConfigStore var4, Object var5, String ... var6);

    default public long delete(DataRuntime runtime, String random, String table, ConfigStore configs, Object obj, String ... columns) {
        return this.delete(runtime, random, new Table(table), configs, obj, columns);
    }

    public long delete(DataRuntime var1, String var2, Table var3, ConfigStore var4, String ... var5);

    default public long delete(DataRuntime runtime, String random, String table, ConfigStore configs, String ... conditions) {
        return this.delete(runtime, random, new Table(table), configs, conditions);
    }

    public long truncate(DataRuntime var1, String var2, Table var3);

    default public long truncate(DataRuntime runtime, String random, String table) {
        return this.truncate(runtime, random, new Table(table));
    }

    public List<Run> buildDeleteRun(DataRuntime var1, Table var2, ConfigStore var3, Object var4, Boolean var5, Boolean var6, String ... var7);

    default public List<Run> buildDeleteRun(DataRuntime runtime, String table, ConfigStore configs, Object obj, Boolean placeholder, Boolean unicode, String ... columns) {
        return this.buildDeleteRun(runtime, new Table(table), configs, obj, placeholder, unicode, columns);
    }

    default public List<Run> buildDeleteRun(DataRuntime runtime, Table table, ConfigStore configs, Boolean placeholder, Boolean unicode) {
        return this.buildDeleteRun(runtime, table, configs, null, placeholder, unicode, null);
    }

    default public List<Run> buildDeleteRun(DataRuntime runtime, String table, ConfigStore configs, Boolean placeholder, Boolean unicode) {
        return this.buildDeleteRun(runtime, new Table(table), configs, null, placeholder, unicode, null);
    }

    public List<Run> buildDeleteRun(DataRuntime var1, int var2, Table var3, ConfigStore var4, Boolean var5, Boolean var6, String var7, Object var8);

    default public List<Run> buildDeleteRun(DataRuntime runtime, int batch, String table, ConfigStore configs, Boolean placeholder, Boolean unicode, String column, Object values) {
        return this.buildDeleteRun(runtime, batch, new Table(table), configs, placeholder, unicode, column, values);
    }

    public List<Run> buildTruncateRun(DataRuntime var1, Table var2);

    default public List<Run> buildTruncateRun(DataRuntime runtime, String table) {
        return this.buildTruncateRun(runtime, new Table(table));
    }

    public List<Run> buildDeleteRunFromTable(DataRuntime var1, int var2, Table var3, ConfigStore var4, Boolean var5, Boolean var6, String var7, Object var8);

    default public List<Run> buildDeleteRunFromTable(DataRuntime runtime, int batch, String table, ConfigStore configs, Boolean placeholder, Boolean unicode, String column, Object values) {
        return this.buildDeleteRunFromTable(runtime, batch, new Table(table), configs, placeholder, unicode, column, values);
    }

    public List<Run> buildDeleteRunFromEntity(DataRuntime var1, Table var2, ConfigStore var3, Object var4, Boolean var5, Boolean var6, String ... var7);

    default public List<Run> buildDeleteRunFromEntity(DataRuntime runtime, String table, ConfigStore configs, Object obj, Boolean placeholder, Boolean unicode, String ... columns) {
        return this.buildDeleteRunFromEntity(runtime, new Table(table), configs, obj, placeholder, unicode, columns);
    }

    default public List<Run> buildDeleteRunFromConfig(DataRuntime runtime, ConfigStore configs, Boolean placeholder, Boolean unicode) {
        Table table = configs.table();
        if (null != table && BasicUtil.isNotEmpty((Object)table.getName())) {
            return this.buildDeleteRunFromTable(runtime, 1, table, configs, placeholder, unicode, null, null);
        }
        return null;
    }

    public void fillDeleteRunContent(DataRuntime var1, Run var2, Boolean var3, Boolean var4);

    default public List<Run> buildDeleteRun(DataRuntime runtime, Table table, ConfigStore configs, Object obj, String ... columns) {
        return this.buildDeleteRun(runtime, table, configs, obj, (Boolean)true, (Boolean)true, columns);
    }

    default public List<Run> buildDeleteRun(DataRuntime runtime, String table, ConfigStore configs, Object obj, String ... columns) {
        return this.buildDeleteRun(runtime, new Table(table), configs, obj, (Boolean)true, (Boolean)true, columns);
    }

    default public List<Run> buildDeleteRun(DataRuntime runtime, Table table, ConfigStore configs) {
        return this.buildDeleteRun(runtime, table, configs, null, (Boolean)true, (Boolean)true, null);
    }

    default public List<Run> buildDeleteRun(DataRuntime runtime, String table, ConfigStore configs) {
        return this.buildDeleteRun(runtime, new Table(table), configs, null, (Boolean)true, (Boolean)true, null);
    }

    default public List<Run> buildDeleteRun(DataRuntime runtime, int batch, Table table, ConfigStore configs, String column, Object values) {
        return this.buildDeleteRun(runtime, batch, table, configs, (Boolean)true, (Boolean)true, column, values);
    }

    default public List<Run> buildDeleteRun(DataRuntime runtime, int batch, String table, ConfigStore configs, String column, Object values) {
        return this.buildDeleteRun(runtime, batch, new Table(table), configs, (Boolean)true, (Boolean)true, column, values);
    }

    default public List<Run> buildDeleteRunFromTable(DataRuntime runtime, int batch, Table table, ConfigStore configs, String column, Object values) {
        return this.buildDeleteRunFromTable(runtime, batch, table, configs, (Boolean)true, (Boolean)true, column, values);
    }

    default public List<Run> buildDeleteRunFromTable(DataRuntime runtime, int batch, String table, ConfigStore configs, String column, Object values) {
        return this.buildDeleteRunFromTable(runtime, batch, new Table(table), configs, (Boolean)true, (Boolean)true, column, values);
    }

    default public List<Run> buildDeleteRunFromEntity(DataRuntime runtime, Table table, ConfigStore configs, Object obj, String ... columns) {
        return this.buildDeleteRunFromEntity(runtime, table, configs, obj, (Boolean)true, (Boolean)true, columns);
    }

    default public List<Run> buildDeleteRunFromEntity(DataRuntime runtime, String table, ConfigStore configs, Object obj, String ... columns) {
        return this.buildDeleteRunFromEntity(runtime, new Table(table), configs, obj, (Boolean)true, (Boolean)true, columns);
    }

    default public List<Run> buildDeleteRunFromConfig(DataRuntime runtime, ConfigStore configs) {
        return this.buildDeleteRunFromConfig(runtime, configs, true, true);
    }

    default public void fillDeleteRunContent(DataRuntime runtime, Run run) {
        this.fillDeleteRunContent(runtime, run, true, true);
    }

    public long delete(DataRuntime var1, String var2, ConfigStore var3, Run var4);

    public MetadataFieldRefer refer(DataRuntime var1, Class<?> var2);

    public void reg(MetadataFieldRefer var1);

    public <T extends Metadata> void checkSchema(DataRuntime var1, T var2);

    default public <T extends Metadata> void correctSchemaFromJDBC(DataRuntime runtime, T meta, String catalog, String schema, boolean overrideRuntime, boolean overrideMeta) {
        if (this.supportCatalog()) {
            if (overrideMeta || this.empty((Metadata)meta.getCatalog())) {
                meta.setCatalog(catalog);
            }
            if ((overrideRuntime || BasicUtil.isEmpty((Object)runtime.getCatalog())) && ConfigTable.KEEP_ADAPTER == 1) {
                runtime.setCatalog(catalog);
            }
        } else {
            meta.setCatalog((Catalog)null);
            runtime.setCatalog(null);
        }
        if (this.supportSchema()) {
            if (overrideMeta || this.empty((Metadata)meta.getSchema())) {
                meta.setSchema(schema);
            }
            if ((overrideRuntime || BasicUtil.isEmpty((Object)runtime.getSchema())) && ConfigTable.KEEP_ADAPTER == 1) {
                runtime.setSchema(schema);
            }
        } else {
            meta.setSchema((Schema)null);
            runtime.setSchema(null);
        }
    }

    default public <T extends Metadata> void correctSchemaFromJDBC(DataRuntime runtime, T meta, String catalog, String schema) {
        this.correctSchemaFromJDBC(runtime, meta, catalog, schema, false, true);
    }

    default public String[] correctSchemaFromJDBC(String catalog, String schema) {
        return new String[]{catalog, schema};
    }

    public LinkedHashMap<String, Column> metadata(DataRuntime var1, RunPrepare var2, boolean var3);

    public <T extends Metadata> T checkName(DataRuntime var1, String var2, T var3) throws Exception;

    public Database database(DataRuntime var1, String var2);

    public String product(DataRuntime var1, String var2);

    public String version(DataRuntime var1, String var2);

    public <T extends Database> LinkedHashMap<String, T> databases(DataRuntime var1, String var2, Database var3);

    default public <T extends Database> LinkedHashMap<String, T> databases(DataRuntime runtime, String random, String pattern) {
        return this.databases(runtime, random, new Database(pattern));
    }

    public <T extends Database> List<T> databases(DataRuntime var1, String var2, boolean var3, Database var4);

    default public <T extends Database> List<T> databases(DataRuntime runtime, String random, boolean greedy, String pattern) {
        return this.databases(runtime, random, greedy, new Database(pattern));
    }

    default public Database database(DataRuntime runtime, String random, String pattern) {
        List databases = this.databases(runtime, random, false, pattern);
        if (!databases.isEmpty()) {
            return (Database)databases.get(0);
        }
        return null;
    }

    public List<Run> buildQueryProductRun(DataRuntime var1) throws Exception;

    public List<Run> buildQueryVersionRun(DataRuntime var1) throws Exception;

    public List<Run> buildQueryDatabasesRun(DataRuntime var1, boolean var2, Database var3) throws Exception;

    default public List<Run> buildQueryDatabasesRun(DataRuntime runtime, boolean greedy, String pattern) throws Exception {
        return this.buildQueryDatabasesRun(runtime, greedy, new Database(pattern));
    }

    default public List<Run> buildQueryDatabaseRun(DataRuntime runtime, boolean greedy) throws Exception {
        return this.buildQueryDatabasesRun(runtime, false, new Database());
    }

    default public List<Run> buildQueryDatabaseRun(DataRuntime runtime, String pattern) throws Exception {
        return this.buildQueryDatabasesRun(runtime, false, pattern);
    }

    default public List<Run> buildQueryDatabaseRun(DataRuntime runtime) throws Exception {
        return this.buildQueryDatabasesRun(runtime, false, new Database());
    }

    public MetadataFieldRefer initDatabaseFieldRefer();

    public String product(DataRuntime var1, int var2, boolean var3, String var4, DataSet var5);

    public String product(DataRuntime var1, boolean var2, String var3);

    public String version(DataRuntime var1, int var2, boolean var3, String var4, DataSet var5);

    public String version(DataRuntime var1, boolean var2, String var3);

    public <T extends Database> LinkedHashMap<String, T> databases(DataRuntime var1, int var2, boolean var3, LinkedHashMap<String, T> var4, Database var5, DataSet var6) throws Exception;

    public <T extends Database> List<T> databases(DataRuntime var1, int var2, boolean var3, List<T> var4, Database var5, DataSet var6) throws Exception;

    public Database database(DataRuntime var1, int var2, boolean var3, Database var4, DataSet var5) throws Exception;

    public Database database(DataRuntime var1, boolean var2, Database var3) throws Exception;

    public <T extends Database> T init(DataRuntime var1, int var2, T var3, Database var4, DataRow var5);

    public <T extends Database> T detail(DataRuntime var1, int var2, T var3, Database var4, DataRow var5);

    public Catalog catalog(DataRuntime var1, String var2);

    public <T extends Catalog> LinkedHashMap<String, T> catalogs(DataRuntime var1, String var2, Catalog var3);

    default public <T extends Catalog> LinkedHashMap<String, T> catalogs(DataRuntime runtime, String random, String name) {
        return this.catalogs(runtime, random, new Catalog(name));
    }

    public <T extends Catalog> List<T> catalogs(DataRuntime var1, String var2, boolean var3, Catalog var4);

    default public <T extends Catalog> List<T> catalogs(DataRuntime runtime, String random, boolean greedy, String name) {
        return this.catalogs(runtime, random, greedy, new Catalog(name));
    }

    default public Catalog catalog(DataRuntime runtime, String random, String name) {
        List catalogs = this.catalogs(runtime, random, false, name);
        if (!catalogs.isEmpty()) {
            return (Catalog)catalogs.get(0);
        }
        return null;
    }

    public List<Run> buildQueryCatalogRun(DataRuntime var1, String var2) throws Exception;

    public List<Run> buildQueryCatalogsRun(DataRuntime var1, boolean var2, Catalog var3) throws Exception;

    default public List<Run> buildQueryCatalogsRun(DataRuntime runtime, boolean greedy, String name) throws Exception {
        return this.buildQueryCatalogsRun(runtime, greedy, new Catalog(name));
    }

    default public List<Run> buildQueryCatalogsRun(DataRuntime runtime) throws Exception {
        return this.buildQueryCatalogsRun(runtime, false, new Catalog());
    }

    public MetadataFieldRefer initCatalogFieldRefer();

    public <T extends Catalog> LinkedHashMap<String, T> catalogs(DataRuntime var1, int var2, boolean var3, LinkedHashMap<String, T> var4, Catalog var5, DataSet var6) throws Exception;

    public <T extends Catalog> List<T> catalogs(DataRuntime var1, int var2, boolean var3, List<T> var4, Catalog var5, DataSet var6) throws Exception;

    public <T extends Catalog> LinkedHashMap<String, T> catalogs(DataRuntime var1, boolean var2, LinkedHashMap<String, T> var3) throws Exception;

    public <T extends Catalog> List<T> catalogs(DataRuntime var1, boolean var2, List<T> var3) throws Exception;

    public Catalog catalog(DataRuntime var1, int var2, boolean var3, Catalog var4, DataSet var5) throws Exception;

    public Catalog catalog(DataRuntime var1, boolean var2, Catalog var3) throws Exception;

    public <T extends Catalog> T init(DataRuntime var1, int var2, T var3, Catalog var4, DataRow var5);

    public <T extends Catalog> T detail(DataRuntime var1, int var2, T var3, Catalog var4, DataRow var5);

    public Schema schema(DataRuntime var1, String var2);

    public <T extends Schema> LinkedHashMap<String, T> schemas(DataRuntime var1, String var2, Schema var3);

    default public <T extends Schema> LinkedHashMap<String, T> schemas(DataRuntime runtime, String random, Catalog catalog, String name) {
        Schema query = new Schema(name);
        query.setCatalog(catalog);
        return this.schemas(runtime, random, query);
    }

    default public <T extends Schema> LinkedHashMap<String, T> schemas(DataRuntime runtime, String random, String name) {
        return this.schemas(runtime, random, null, name);
    }

    public <T extends Schema> List<T> schemas(DataRuntime var1, String var2, boolean var3, Schema var4);

    default public <T extends Schema> List<T> schemas(DataRuntime runtime, String random, boolean greedy, Catalog catalog, String name) {
        Schema query = new Schema(name);
        query.setCatalog(catalog);
        return this.schemas(runtime, random, greedy, query);
    }

    default public <T extends Schema> List<T> schemas(DataRuntime runtime, String random, boolean greedy, String name) {
        return this.schemas(runtime, random, greedy, null, name);
    }

    default public Schema schema(DataRuntime runtime, String random, Catalog catalog, String name) {
        List schemas = this.schemas(runtime, random, false, catalog, name);
        if (!schemas.isEmpty()) {
            return (Schema)schemas.get(0);
        }
        return null;
    }

    public List<Run> buildQuerySchemaRun(DataRuntime var1, String var2) throws Exception;

    public List<Run> buildQuerySchemasRun(DataRuntime var1, boolean var2, Schema var3) throws Exception;

    default public List<Run> buildQuerySchemasRun(DataRuntime runtime, boolean greedy, Catalog catalog, String name) throws Exception {
        Schema query = new Schema(name);
        query.setCatalog(catalog);
        return this.buildQuerySchemasRun(runtime, greedy, query);
    }

    default public List<Run> buildQuerySchemasRun(DataRuntime runtime, String name) throws Exception {
        return this.buildQuerySchemasRun(runtime, false, null, name);
    }

    default public List<Run> buildQuerySchemasRun(DataRuntime runtime, Catalog catalog) throws Exception {
        return this.buildQuerySchemasRun(runtime, false, catalog, null);
    }

    public MetadataFieldRefer initSchemaFieldRefer();

    public <T extends Schema> LinkedHashMap<String, T> schemas(DataRuntime var1, int var2, boolean var3, LinkedHashMap<String, T> var4, Schema var5, DataSet var6) throws Exception;

    default public <T extends Schema> LinkedHashMap<String, T> schemas(DataRuntime runtime, int index, boolean create, LinkedHashMap<String, T> previous, Catalog catalog, DataSet set) throws Exception {
        Schema query = new Schema();
        query.setCatalog(catalog);
        return this.schemas(runtime, index, create, previous, query, set);
    }

    public <T extends Schema> List<T> schemas(DataRuntime var1, int var2, boolean var3, List<T> var4, Schema var5, DataSet var6) throws Exception;

    default public <T extends Schema> List<T> schemas(DataRuntime runtime, int index, boolean create, List<T> previous, Catalog catalog, DataSet set) throws Exception {
        Schema query = new Schema();
        query.setCatalog(catalog);
        return this.schemas(runtime, index, create, previous, query, set);
    }

    public <T extends Schema> LinkedHashMap<String, T> schemas(DataRuntime var1, boolean var2, LinkedHashMap<String, T> var3, Schema var4) throws Exception;

    public <T extends Schema> List<T> schemas(DataRuntime var1, boolean var2, List<T> var3, Schema var4) throws Exception;

    public Schema schema(DataRuntime var1, int var2, boolean var3, Schema var4, DataSet var5) throws Exception;

    public Schema schema(DataRuntime var1, boolean var2, Schema var3) throws Exception;

    public <T extends Schema> T init(DataRuntime var1, int var2, T var3, Schema var4, DataRow var5);

    public <T extends Schema> T detail(DataRuntime var1, int var2, T var3, Schema var4, DataRow var5);

    public <T extends Table> List<T> tables(DataRuntime var1, String var2, boolean var3, Table var4, int var5, int var6, ConfigStore var7);

    default public <T extends Table> List<T> tables(DataRuntime runtime, String random, boolean greedy, Catalog catalog, Schema schema, String pattern, int types, int struct, ConfigStore configs) {
        Table query = new Table(catalog, schema, pattern);
        return this.tables(runtime, random, greedy, query, types, struct, configs);
    }

    default public <T extends Table> List<T> tables(DataRuntime runtime, String random, boolean greedy, Catalog catalog, Schema schema, String pattern, int types, int struct) {
        return this.tables(runtime, random, greedy, catalog, schema, pattern, types, struct, null);
    }

    default public <T extends Table> List<T> tables(DataRuntime runtime, String random, boolean greedy, Catalog catalog, Schema schema, String pattern, int types, boolean struct, ConfigStore configs) {
        int structs = 0;
        if (struct) {
            structs = Metadata.TYPE.ALL.value();
        }
        return this.tables(runtime, random, greedy, catalog, schema, pattern, types, structs, configs);
    }

    default public <T extends Table> List<T> tables(DataRuntime runtime, String random, boolean greedy, Catalog catalog, Schema schema, String pattern, int types, boolean struct) {
        return this.tables(runtime, random, greedy, catalog, schema, pattern, types, struct, null);
    }

    default public <T extends Table> List<T> tables(DataRuntime runtime, String random, boolean greedy, Catalog catalog, Schema schema, String pattern, int types) {
        return this.tables(runtime, random, greedy, catalog, schema, pattern, types, false);
    }

    public <T extends Table> LinkedHashMap<String, T> tables(DataRuntime var1, String var2, Table var3, int var4, int var5, ConfigStore var6);

    default public <T extends Table> LinkedHashMap<String, T> tables(DataRuntime runtime, String random, Catalog catalog, Schema schema, String pattern, int types, int struct, ConfigStore configs) {
        Table query = new Table(catalog, schema, pattern);
        return this.tables(runtime, random, query, types, struct, configs);
    }

    default public <T extends Table> LinkedHashMap<String, T> tables(DataRuntime runtime, String random, Catalog catalog, Schema schema, String pattern, int types, int struct) {
        return this.tables(runtime, random, catalog, schema, pattern, types, struct, null);
    }

    default public <T extends Table> LinkedHashMap<String, T> tables(DataRuntime runtime, String random, Catalog catalog, Schema schema, String pattern, int types, boolean struct, ConfigStore configs) {
        int structs = 0;
        if (struct) {
            structs = Metadata.TYPE.ALL.value();
        }
        return this.tables(runtime, random, catalog, schema, pattern, types, structs, configs);
    }

    default public <T extends Table> LinkedHashMap<String, T> tables(DataRuntime runtime, String random, Catalog catalog, Schema schema, String pattern, int types, boolean struct) {
        return this.tables(runtime, random, catalog, schema, pattern, types, struct, null);
    }

    default public <T extends Table> LinkedHashMap<String, T> tables(DataRuntime runtime, String random, Catalog catalog, Schema schema, String pattern, int types) {
        return this.tables(runtime, random, catalog, schema, pattern, types, false);
    }

    public List<Run> buildQueryTablesRun(DataRuntime var1, boolean var2, Table var3, int var4, ConfigStore var5) throws Exception;

    default public List<Run> buildQueryTablesRun(DataRuntime runtime, boolean greedy, Catalog catalog, Schema schema, String pattern, int types, ConfigStore configs) throws Exception {
        Table query = new Table(catalog, schema, pattern);
        return this.buildQueryTablesRun(runtime, greedy, query, types, configs);
    }

    public MetadataFieldRefer initTableFieldRefer();

    public MetadataFieldRefer initTableCommentFieldRefer();

    public List<Run> buildQueryTablesCommentRun(DataRuntime var1, Table var2, int var3) throws Exception;

    default public List<Run> buildQueryTablesCommentRun(DataRuntime runtime, Catalog catalog, Schema schema, String pattern, int types) throws Exception {
        Table query = new Table(catalog, schema, pattern);
        return this.buildQueryTablesCommentRun(runtime, query, types);
    }

    public <T extends Table> LinkedHashMap<String, T> tables(DataRuntime var1, int var2, boolean var3, LinkedHashMap<String, T> var4, Table var5, DataSet var6) throws Exception;

    default public <T extends Table> LinkedHashMap<String, T> tables(DataRuntime runtime, int index, boolean create, LinkedHashMap<String, T> previous, Catalog catalog, Schema schema, DataSet set) throws Exception {
        Table query = new Table();
        query.setCatalog(catalog);
        query.setSchema(schema);
        return this.tables(runtime, index, create, previous, query, set);
    }

    public <T extends Table> List<T> tables(DataRuntime var1, int var2, boolean var3, List<T> var4, Table var5, DataSet var6) throws Exception;

    default public <T extends Table> List<T> tables(DataRuntime runtime, int index, boolean create, List<T> previous, Catalog catalog, Schema schema, DataSet set) throws Exception {
        Table query = new Table();
        query.setCatalog(catalog);
        query.setSchema(schema);
        return this.tables(runtime, index, create, previous, query, set);
    }

    public <T extends Table> LinkedHashMap<String, T> tables(DataRuntime var1, boolean var2, LinkedHashMap<String, T> var3, Table var4, int var5) throws Exception;

    default public <T extends Table> LinkedHashMap<String, T> tables(DataRuntime runtime, boolean create, LinkedHashMap<String, T> previous, Catalog catalog, Schema schema, String pattern, int types) throws Exception {
        Table query = new Table(catalog, schema, pattern);
        return this.tables(runtime, create, previous, query, types);
    }

    public <T extends Table> List<T> tables(DataRuntime var1, boolean var2, List<T> var3, Table var4, int var5) throws Exception;

    default public <T extends Table> List<T> tables(DataRuntime runtime, boolean create, List<T> previous, Catalog catalog, Schema schema, String pattern, int types) throws Exception {
        Table query = new Table(catalog, schema, pattern);
        return this.tables(runtime, create, previous, query, types);
    }

    public <T extends Table> LinkedHashMap<String, T> comments(DataRuntime var1, int var2, boolean var3, LinkedHashMap<String, T> var4, Table var5, DataSet var6) throws Exception;

    default public <T extends Table> LinkedHashMap<String, T> comments(DataRuntime runtime, int index, boolean create, LinkedHashMap<String, T> previous, Catalog catalog, Schema schema, DataSet set) throws Exception {
        Table query = new Table();
        query.setCatalog(catalog);
        query.setSchema(schema);
        return this.comments(runtime, index, create, previous, query, set);
    }

    public <T extends Table> List<T> comments(DataRuntime var1, int var2, boolean var3, List<T> var4, Table var5, DataSet var6) throws Exception;

    default public <T extends Table> List<T> comments(DataRuntime runtime, int index, boolean create, List<T> previous, Catalog catalog, Schema schema, DataSet set) throws Exception {
        Table query = new Table();
        query.setCatalog(catalog);
        query.setSchema(schema);
        return this.comments(runtime, index, create, previous, query, set);
    }

    public List<String> ddl(DataRuntime var1, String var2, Table var3, boolean var4);

    public List<Run> buildQueryDdlRun(DataRuntime var1, Table var2) throws Exception;

    public List<String> ddl(DataRuntime var1, int var2, Table var3, List<String> var4, DataSet var5);

    public <T extends Table> T init(DataRuntime var1, int var2, T var3, Table var4, DataRow var5);

    default public <T extends Table> T init(DataRuntime runtime, int index, T meta, Catalog catalog, Schema schema, DataRow row) {
        Table query = new Table();
        query.setCatalog(catalog);
        query.setSchema(schema);
        return this.init(runtime, index, meta, query, row);
    }

    public <T extends Table> T detail(DataRuntime var1, int var2, T var3, Table var4, DataRow var5);

    default public <T extends Table> T detail(DataRuntime runtime, int index, T meta, Catalog catalog, Schema schema, DataRow row) {
        Table query = new Table();
        query.setCatalog(catalog);
        query.setSchema(schema);
        return this.detail(runtime, index, meta, query, row);
    }

    public <T extends VertexTable> List<T> vertexs(DataRuntime var1, String var2, boolean var3, VertexTable var4, int var5, int var6, ConfigStore var7);

    default public <T extends VertexTable> List<T> vertexs(DataRuntime runtime, String random, boolean greedy, Catalog catalog, Schema schema, String pattern, int types, int struct, ConfigStore configs) {
        VertexTable query = new VertexTable(catalog, schema, pattern);
        return this.vertexs(runtime, random, greedy, query, types, struct, configs);
    }

    default public <T extends VertexTable> List<T> vertexs(DataRuntime runtime, String random, boolean greedy, Catalog catalog, Schema schema, String pattern, int types, int struct) {
        return this.vertexs(runtime, random, greedy, catalog, schema, pattern, types, struct, null);
    }

    default public <T extends VertexTable> List<T> vertexs(DataRuntime runtime, String random, boolean greedy, Catalog catalog, Schema schema, String pattern, int types, boolean struct, ConfigStore configs) {
        int structs = 0;
        if (struct) {
            structs = Metadata.TYPE.ALL.value();
        }
        return this.vertexs(runtime, random, greedy, catalog, schema, pattern, types, structs, configs);
    }

    default public <T extends VertexTable> List<T> vertexs(DataRuntime runtime, String random, boolean greedy, Catalog catalog, Schema schema, String pattern, int types, boolean struct) {
        return this.vertexs(runtime, random, greedy, catalog, schema, pattern, types, struct, null);
    }

    default public <T extends VertexTable> List<T> vertexs(DataRuntime runtime, String random, boolean greedy, Catalog catalog, Schema schema, String pattern, int types) {
        return this.vertexs(runtime, random, greedy, catalog, schema, pattern, types, false);
    }

    public <T extends VertexTable> LinkedHashMap<String, T> vertexs(DataRuntime var1, String var2, VertexTable var3, int var4, int var5, ConfigStore var6);

    default public <T extends VertexTable> LinkedHashMap<String, T> vertexs(DataRuntime runtime, String random, Catalog catalog, Schema schema, String pattern, int types, int struct, ConfigStore configs) {
        VertexTable query = new VertexTable(catalog, schema, pattern);
        return this.vertexs(runtime, random, query, types, struct, configs);
    }

    default public <T extends VertexTable> LinkedHashMap<String, T> vertexs(DataRuntime runtime, String random, Catalog catalog, Schema schema, String pattern, int types, int struct) {
        return this.vertexs(runtime, random, catalog, schema, pattern, types, struct, null);
    }

    default public <T extends VertexTable> LinkedHashMap<String, T> vertexs(DataRuntime runtime, String random, Catalog catalog, Schema schema, String pattern, int types, boolean struct, ConfigStore configs) {
        int structs = 0;
        if (struct) {
            structs = Metadata.TYPE.ALL.value();
        }
        return this.vertexs(runtime, random, catalog, schema, pattern, types, structs, configs);
    }

    default public <T extends VertexTable> LinkedHashMap<String, T> vertexs(DataRuntime runtime, String random, Catalog catalog, Schema schema, String pattern, int types, boolean struct) {
        return this.vertexs(runtime, random, catalog, schema, pattern, types, struct, null);
    }

    default public <T extends VertexTable> LinkedHashMap<String, T> vertexs(DataRuntime runtime, String random, Catalog catalog, Schema schema, String pattern, int types) {
        return this.vertexs(runtime, random, catalog, schema, pattern, types, false);
    }

    public List<Run> buildQueryVertexsRun(DataRuntime var1, boolean var2, VertexTable var3, int var4, ConfigStore var5) throws Exception;

    default public List<Run> buildQueryVertexsRun(DataRuntime runtime, boolean greedy, Catalog catalog, Schema schema, String pattern, int types, ConfigStore configs) throws Exception {
        VertexTable query = new VertexTable(catalog, schema, pattern);
        return this.buildQueryVertexsRun(runtime, greedy, query, types, configs);
    }

    public MetadataFieldRefer initVertexFieldRefer();

    public List<Run> buildQueryVertexsCommentRun(DataRuntime var1, VertexTable var2, int var3) throws Exception;

    default public List<Run> buildQueryVertexsCommentRun(DataRuntime runtime, Catalog catalog, Schema schema, String pattern, int types) throws Exception {
        VertexTable query = new VertexTable(catalog, schema, pattern);
        return this.buildQueryVertexsCommentRun(runtime, query, types);
    }

    public <T extends VertexTable> LinkedHashMap<String, T> vertexs(DataRuntime var1, int var2, boolean var3, LinkedHashMap<String, T> var4, VertexTable var5, DataSet var6) throws Exception;

    default public <T extends VertexTable> LinkedHashMap<String, T> vertexs(DataRuntime runtime, int index, boolean create, LinkedHashMap<String, T> previous, Catalog catalog, Schema schema, DataSet set) throws Exception {
        VertexTable query = new VertexTable();
        query.setCatalog(catalog);
        query.setSchema(schema);
        return this.vertexs(runtime, index, create, previous, query, set);
    }

    public <T extends VertexTable> List<T> vertexs(DataRuntime var1, int var2, boolean var3, List<T> var4, VertexTable var5, DataSet var6) throws Exception;

    default public <T extends VertexTable> List<T> vertexs(DataRuntime runtime, int index, boolean create, List<T> previous, Catalog catalog, Schema schema, DataSet set) throws Exception {
        VertexTable query = new VertexTable();
        query.setCatalog(catalog);
        query.setSchema(schema);
        return this.vertexs(runtime, index, create, previous, query, set);
    }

    public <T extends VertexTable> LinkedHashMap<String, T> vertexs(DataRuntime var1, boolean var2, LinkedHashMap<String, T> var3, VertexTable var4, int var5) throws Exception;

    default public <T extends VertexTable> LinkedHashMap<String, T> vertexs(DataRuntime runtime, boolean create, LinkedHashMap<String, T> previous, Catalog catalog, Schema schema, String pattern, int types) throws Exception {
        VertexTable query = new VertexTable(catalog, schema, pattern);
        return this.vertexs(runtime, create, previous, query, types);
    }

    public <T extends VertexTable> List<T> vertexs(DataRuntime var1, boolean var2, List<T> var3, VertexTable var4, int var5) throws Exception;

    default public <T extends VertexTable> List<T> vertexs(DataRuntime runtime, boolean create, List<T> previous, Catalog catalog, Schema schema, String pattern, int types) throws Exception {
        VertexTable query = new VertexTable(catalog, schema, pattern);
        return this.vertexs(runtime, create, previous, query, types);
    }

    public List<String> ddl(DataRuntime var1, String var2, VertexTable var3, boolean var4);

    public List<Run> buildQueryDdlRun(DataRuntime var1, VertexTable var2) throws Exception;

    public List<String> ddl(DataRuntime var1, int var2, VertexTable var3, List<String> var4, DataSet var5);

    public <T extends VertexTable> T init(DataRuntime var1, int var2, T var3, VertexTable var4, DataRow var5);

    default public <T extends VertexTable> T init(DataRuntime runtime, int index, T meta, Catalog catalog, Schema schema, DataRow row) {
        VertexTable query = new VertexTable();
        query.setCatalog(catalog);
        query.setSchema(schema);
        return this.init(runtime, index, meta, query, row);
    }

    public <T extends VertexTable> T detail(DataRuntime var1, int var2, T var3, VertexTable var4, DataRow var5);

    default public <T extends VertexTable> T detail(DataRuntime runtime, int index, T meta, Catalog catalog, Schema schema, DataRow row) {
        VertexTable query = new VertexTable();
        query.setCatalog(catalog);
        query.setSchema(schema);
        return this.detail(runtime, index, meta, query, row);
    }

    public <T extends EdgeTable> List<T> edges(DataRuntime var1, String var2, boolean var3, EdgeTable var4, int var5, int var6, ConfigStore var7);

    default public <T extends EdgeTable> List<T> edges(DataRuntime runtime, String random, boolean greedy, Catalog catalog, Schema schema, String pattern, int types, int struct, ConfigStore configs) {
        EdgeTable query = new EdgeTable(catalog, schema, pattern);
        return this.edges(runtime, random, greedy, query, types, struct, configs);
    }

    default public <T extends EdgeTable> List<T> edges(DataRuntime runtime, String random, boolean greedy, Catalog catalog, Schema schema, String pattern, int types, int struct) {
        return this.edges(runtime, random, greedy, catalog, schema, pattern, types, struct, null);
    }

    default public <T extends EdgeTable> List<T> edges(DataRuntime runtime, String random, boolean greedy, Catalog catalog, Schema schema, String pattern, int types, boolean struct, ConfigStore configs) {
        int structs = 0;
        if (struct) {
            structs = Metadata.TYPE.ALL.value();
        }
        return this.edges(runtime, random, greedy, catalog, schema, pattern, types, structs, configs);
    }

    default public <T extends EdgeTable> List<T> edges(DataRuntime runtime, String random, boolean greedy, Catalog catalog, Schema schema, String pattern, int types, boolean struct) {
        return this.edges(runtime, random, greedy, catalog, schema, pattern, types, struct, null);
    }

    default public <T extends EdgeTable> List<T> edges(DataRuntime runtime, String random, boolean greedy, Catalog catalog, Schema schema, String pattern, int types) {
        return this.edges(runtime, random, greedy, catalog, schema, pattern, types, false);
    }

    public <T extends EdgeTable> LinkedHashMap<String, T> edges(DataRuntime var1, String var2, EdgeTable var3, int var4, int var5, ConfigStore var6);

    default public <T extends EdgeTable> LinkedHashMap<String, T> edges(DataRuntime runtime, String random, Catalog catalog, Schema schema, String pattern, int types, int struct, ConfigStore configs) {
        EdgeTable query = new EdgeTable(catalog, schema, pattern);
        return this.edges(runtime, random, query, types, struct, configs);
    }

    default public <T extends EdgeTable> LinkedHashMap<String, T> edges(DataRuntime runtime, String random, Catalog catalog, Schema schema, String pattern, int types, int struct) {
        return this.edges(runtime, random, catalog, schema, pattern, types, struct, null);
    }

    default public <T extends EdgeTable> LinkedHashMap<String, T> edges(DataRuntime runtime, String random, Catalog catalog, Schema schema, String pattern, int types, boolean struct, ConfigStore configs) {
        int structs = 0;
        if (struct) {
            structs = Metadata.TYPE.ALL.value();
        }
        return this.edges(runtime, random, catalog, schema, pattern, types, structs, configs);
    }

    default public <T extends EdgeTable> LinkedHashMap<String, T> edges(DataRuntime runtime, String random, Catalog catalog, Schema schema, String pattern, int types, boolean struct) {
        return this.edges(runtime, random, catalog, schema, pattern, types, struct, null);
    }

    default public <T extends EdgeTable> LinkedHashMap<String, T> edges(DataRuntime runtime, String random, Catalog catalog, Schema schema, String pattern, int types) {
        return this.edges(runtime, random, catalog, schema, pattern, types, false);
    }

    public List<Run> buildQueryEdgesRun(DataRuntime var1, boolean var2, EdgeTable var3, int var4, ConfigStore var5) throws Exception;

    default public List<Run> buildQueryEdgesRun(DataRuntime runtime, boolean greedy, Catalog catalog, Schema schema, String pattern, int types, ConfigStore configs) throws Exception {
        EdgeTable query = new EdgeTable(catalog, schema, pattern);
        return this.buildQueryEdgesRun(runtime, greedy, query, types, configs);
    }

    public MetadataFieldRefer initEdgeFieldRefer();

    public List<Run> buildQueryEdgesCommentRun(DataRuntime var1, EdgeTable var2, int var3) throws Exception;

    default public List<Run> buildQueryEdgesCommentRun(DataRuntime runtime, Catalog catalog, Schema schema, String pattern, int types) throws Exception {
        EdgeTable query = new EdgeTable(catalog, schema, pattern);
        return this.buildQueryEdgesCommentRun(runtime, query, types);
    }

    public <T extends EdgeTable> LinkedHashMap<String, T> edges(DataRuntime var1, int var2, boolean var3, LinkedHashMap<String, T> var4, EdgeTable var5, DataSet var6) throws Exception;

    default public <T extends EdgeTable> LinkedHashMap<String, T> edges(DataRuntime runtime, int index, boolean create, LinkedHashMap<String, T> previous, Catalog catalog, Schema schema, DataSet set) throws Exception {
        EdgeTable query = new EdgeTable();
        query.setCatalog(catalog);
        query.setSchema(schema);
        return this.edges(runtime, index, create, previous, query, set);
    }

    public <T extends EdgeTable> List<T> edges(DataRuntime var1, int var2, boolean var3, List<T> var4, EdgeTable var5, DataSet var6) throws Exception;

    default public <T extends EdgeTable> List<T> edges(DataRuntime runtime, int index, boolean create, List<T> previous, Catalog catalog, Schema schema, DataSet set) throws Exception {
        EdgeTable query = new EdgeTable();
        query.setCatalog(catalog);
        query.setSchema(schema);
        return this.edges(runtime, index, create, previous, query, set);
    }

    public <T extends EdgeTable> LinkedHashMap<String, T> edges(DataRuntime var1, boolean var2, LinkedHashMap<String, T> var3, EdgeTable var4, int var5) throws Exception;

    default public <T extends EdgeTable> LinkedHashMap<String, T> edges(DataRuntime runtime, boolean create, LinkedHashMap<String, T> previous, Catalog catalog, Schema schema, String pattern, int types) throws Exception {
        EdgeTable query = new EdgeTable(catalog, schema, pattern);
        return this.edges(runtime, create, previous, query, types);
    }

    public <T extends EdgeTable> List<T> edges(DataRuntime var1, boolean var2, List<T> var3, EdgeTable var4, int var5) throws Exception;

    default public <T extends EdgeTable> List<T> edges(DataRuntime runtime, boolean create, List<T> previous, Catalog catalog, Schema schema, String pattern, int types) throws Exception {
        EdgeTable query = new EdgeTable(catalog, schema, pattern);
        return this.edges(runtime, create, previous, query, types);
    }

    public List<String> ddl(DataRuntime var1, String var2, EdgeTable var3, boolean var4);

    public List<Run> buildQueryDdlRun(DataRuntime var1, EdgeTable var2) throws Exception;

    public List<String> ddl(DataRuntime var1, int var2, EdgeTable var3, List<String> var4, DataSet var5);

    public <T extends EdgeTable> T init(DataRuntime var1, int var2, T var3, EdgeTable var4, DataRow var5);

    default public <T extends EdgeTable> T init(DataRuntime runtime, int index, T meta, Catalog catalog, Schema schema, DataRow row) {
        EdgeTable query = new EdgeTable();
        query.setCatalog(catalog);
        query.setSchema(schema);
        return this.init(runtime, index, meta, query, row);
    }

    public <T extends EdgeTable> T detail(DataRuntime var1, int var2, T var3, EdgeTable var4, DataRow var5);

    default public <T extends EdgeTable> T detail(DataRuntime runtime, int index, T meta, Catalog catalog, Schema schema, DataRow row) {
        EdgeTable query = new EdgeTable();
        query.setCatalog(catalog);
        query.setSchema(schema);
        return this.detail(runtime, index, meta, query, row);
    }

    public <T extends View> List<T> views(DataRuntime var1, String var2, boolean var3, View var4, int var5, int var6, ConfigStore var7);

    default public <T extends View> List<T> views(DataRuntime runtime, String random, boolean greedy, Catalog catalog, Schema schema, String pattern, int types, int struct, ConfigStore configs) {
        View query = new View(catalog, schema, pattern);
        return this.views(runtime, random, greedy, catalog, schema, pattern, types, struct, configs);
    }

    default public <T extends View> List<T> views(DataRuntime runtime, String random, boolean greedy, Catalog catalog, Schema schema, String pattern, int types, int struct) {
        return this.views(runtime, random, greedy, catalog, schema, pattern, types, struct, null);
    }

    default public <T extends View> List<T> views(DataRuntime runtime, String random, boolean greedy, Catalog catalog, Schema schema, String pattern, int types, boolean struct, ConfigStore configs) {
        int structs = 0;
        if (struct) {
            structs = Metadata.TYPE.ALL.value();
        }
        return this.views(runtime, random, greedy, catalog, schema, pattern, types, structs, configs);
    }

    default public <T extends View> List<T> views(DataRuntime runtime, String random, boolean greedy, Catalog catalog, Schema schema, String pattern, int types, boolean struct) {
        return this.views(runtime, random, greedy, catalog, schema, pattern, types, struct, null);
    }

    default public <T extends View> List<T> views(DataRuntime runtime, String random, boolean greedy, Catalog catalog, Schema schema, String pattern, int types) {
        return this.views(runtime, random, greedy, catalog, schema, pattern, types, false);
    }

    public <T extends View> LinkedHashMap<String, T> views(DataRuntime var1, String var2, View var3, int var4, int var5, ConfigStore var6);

    default public <T extends View> LinkedHashMap<String, T> views(DataRuntime runtime, String random, Catalog catalog, Schema schema, String pattern, int types, int struct, ConfigStore configs) {
        View query = new View(catalog, schema, pattern);
        return this.views(runtime, random, query, types, struct, configs);
    }

    default public <T extends View> LinkedHashMap<String, T> views(DataRuntime runtime, String random, Catalog catalog, Schema schema, String pattern, int types, int struct) {
        return this.views(runtime, random, catalog, schema, pattern, types, struct, null);
    }

    default public <T extends View> LinkedHashMap<String, T> views(DataRuntime runtime, String random, Catalog catalog, Schema schema, String pattern, int types, boolean struct, ConfigStore configs) {
        int structs = 0;
        if (struct) {
            structs = Metadata.TYPE.ALL.value();
        }
        return this.views(runtime, random, catalog, schema, pattern, types, structs, configs);
    }

    default public <T extends View> LinkedHashMap<String, T> views(DataRuntime runtime, String random, Catalog catalog, Schema schema, String pattern, int types, boolean struct) {
        return this.views(runtime, random, catalog, schema, pattern, types, struct, null);
    }

    default public <T extends View> LinkedHashMap<String, T> views(DataRuntime runtime, String random, Catalog catalog, Schema schema, String pattern, int types) {
        return this.views(runtime, random, catalog, schema, pattern, types, false);
    }

    public List<Run> buildQueryViewsRun(DataRuntime var1, boolean var2, View var3, int var4, ConfigStore var5) throws Exception;

    default public List<Run> buildQueryViewsRun(DataRuntime runtime, boolean greedy, Catalog catalog, Schema schema, String pattern, int types, ConfigStore configs) throws Exception {
        View query = new View(catalog, schema, pattern);
        return this.buildQueryViewsRun(runtime, greedy, query, types, configs);
    }

    public MetadataFieldRefer initViewFieldRefer();

    public List<Run> buildQueryViewsCommentRun(DataRuntime var1, View var2, int var3) throws Exception;

    default public List<Run> buildQueryViewsCommentRun(DataRuntime runtime, Catalog catalog, Schema schema, String pattern, int types) throws Exception {
        View query = new View(catalog, schema, pattern);
        return this.buildQueryViewsCommentRun(runtime, query, types);
    }

    public <T extends View> LinkedHashMap<String, T> views(DataRuntime var1, int var2, boolean var3, LinkedHashMap<String, T> var4, View var5, DataSet var6) throws Exception;

    default public <T extends View> LinkedHashMap<String, T> views(DataRuntime runtime, int index, boolean create, LinkedHashMap<String, T> previous, Catalog catalog, Schema schema, DataSet set) throws Exception {
        View query = new View();
        query.setCatalog(catalog);
        query.setSchema(schema);
        return this.views(runtime, index, create, previous, query, set);
    }

    public <T extends View> List<T> views(DataRuntime var1, int var2, boolean var3, List<T> var4, View var5, DataSet var6) throws Exception;

    default public <T extends View> List<T> views(DataRuntime runtime, int index, boolean create, List<T> previous, Catalog catalog, Schema schema, DataSet set) throws Exception {
        View query = new View();
        query.setCatalog(catalog);
        query.setSchema(schema);
        return this.views(runtime, index, create, previous, query, set);
    }

    public <T extends View> LinkedHashMap<String, T> views(DataRuntime var1, boolean var2, LinkedHashMap<String, T> var3, View var4, int var5) throws Exception;

    default public <T extends View> LinkedHashMap<String, T> views(DataRuntime runtime, boolean create, LinkedHashMap<String, T> previous, Catalog catalog, Schema schema, String pattern, int types) throws Exception {
        View query = new View(catalog, schema, pattern);
        return this.views(runtime, create, previous, query, types);
    }

    public <T extends View> List<T> views(DataRuntime var1, boolean var2, List<T> var3, View var4, int var5) throws Exception;

    default public <T extends View> List<T> views(DataRuntime runtime, boolean create, List<T> previous, Catalog catalog, Schema schema, String pattern, int types) throws Exception {
        View query = new View(catalog, schema, pattern);
        return this.views(runtime, create, previous, query, types);
    }

    public List<String> ddl(DataRuntime var1, String var2, View var3, boolean var4);

    public List<Run> buildQueryDdlRun(DataRuntime var1, View var2) throws Exception;

    public List<String> ddl(DataRuntime var1, int var2, View var3, List<String> var4, DataSet var5);

    public <T extends View> T init(DataRuntime var1, int var2, T var3, View var4, DataRow var5);

    default public <T extends View> T init(DataRuntime runtime, int index, T meta, Catalog catalog, Schema schema, DataRow row) {
        View query = new View();
        query.setCatalog(catalog);
        query.setSchema(schema);
        return this.init(runtime, index, meta, query, row);
    }

    public <T extends View> T detail(DataRuntime var1, int var2, T var3, View var4, DataRow var5);

    default public <T extends View> T detail(DataRuntime runtime, int index, T meta, Catalog catalog, Schema schema, DataRow row) {
        View query = new View();
        query.setCatalog(catalog);
        query.setSchema(schema);
        return this.detail(runtime, index, meta, query, row);
    }

    public <T extends MasterTable> List<T> masters(DataRuntime var1, String var2, boolean var3, MasterTable var4, int var5, int var6, ConfigStore var7);

    default public <T extends MasterTable> List<T> masters(DataRuntime runtime, String random, boolean greedy, Catalog catalog, Schema schema, String pattern, int types, int struct, ConfigStore configs) {
        MasterTable query = new MasterTable(catalog, schema, pattern);
        return this.masters(runtime, random, greedy, query, types, struct, configs);
    }

    default public <T extends MasterTable> List<T> masters(DataRuntime runtime, String random, boolean greedy, Catalog catalog, Schema schema, String pattern, int types, int struct) {
        return this.masters(runtime, random, greedy, catalog, schema, pattern, types, struct, null);
    }

    default public <T extends MasterTable> List<T> masters(DataRuntime runtime, String random, boolean greedy, Catalog catalog, Schema schema, String pattern, int types, boolean struct, ConfigStore configs) {
        int structs = 0;
        if (struct) {
            structs = Metadata.TYPE.ALL.value();
        }
        return this.masters(runtime, random, greedy, catalog, schema, pattern, types, structs, configs);
    }

    default public <T extends MasterTable> List<T> masters(DataRuntime runtime, String random, boolean greedy, Catalog catalog, Schema schema, String pattern, int types, boolean struct) {
        return this.masters(runtime, random, greedy, catalog, schema, pattern, types, struct, null);
    }

    default public <T extends MasterTable> List<T> masters(DataRuntime runtime, String random, boolean greedy, Catalog catalog, Schema schema, String pattern, int types) {
        return this.masters(runtime, random, greedy, catalog, schema, pattern, types, false);
    }

    public <T extends MasterTable> LinkedHashMap<String, T> masters(DataRuntime var1, String var2, MasterTable var3, int var4, int var5, ConfigStore var6);

    default public <T extends MasterTable> LinkedHashMap<String, T> masters(DataRuntime runtime, String random, Catalog catalog, Schema schema, String pattern, int types, int struct, ConfigStore configs) {
        MasterTable query = new MasterTable(catalog, schema, pattern);
        return this.masters(runtime, random, query, types, struct, configs);
    }

    default public <T extends MasterTable> LinkedHashMap<String, T> masters(DataRuntime runtime, String random, Catalog catalog, Schema schema, String pattern, int types, int struct) {
        return this.masters(runtime, random, catalog, schema, pattern, types, struct, null);
    }

    default public <T extends MasterTable> LinkedHashMap<String, T> masters(DataRuntime runtime, String random, Catalog catalog, Schema schema, String pattern, int types, boolean struct, ConfigStore configs) {
        int structs = 0;
        if (struct) {
            structs = Metadata.TYPE.ALL.value();
        }
        return this.masters(runtime, random, catalog, schema, pattern, types, structs, configs);
    }

    default public <T extends MasterTable> LinkedHashMap<String, T> masters(DataRuntime runtime, String random, Catalog catalog, Schema schema, String pattern, int types, boolean struct) {
        return this.masters(runtime, random, catalog, schema, pattern, types, struct, null);
    }

    default public <T extends MasterTable> LinkedHashMap<String, T> masters(DataRuntime runtime, String random, Catalog catalog, Schema schema, String pattern, int types) {
        return this.masters(runtime, random, catalog, schema, pattern, types, false);
    }

    public List<Run> buildQueryMasterTablesRun(DataRuntime var1, boolean var2, MasterTable var3, int var4, ConfigStore var5) throws Exception;

    default public List<Run> buildQueryMasterTablesRun(DataRuntime runtime, boolean greedy, Catalog catalog, Schema schema, String pattern, int types, ConfigStore configs) throws Exception {
        MasterTable query = new MasterTable(catalog, schema, pattern);
        return this.buildQueryMasterTablesRun(runtime, greedy, query, types, configs);
    }

    public MetadataFieldRefer initMasterTableFieldRefer();

    public List<Run> buildQueryMasterTablesCommentRun(DataRuntime var1, MasterTable var2, int var3) throws Exception;

    default public List<Run> buildQueryMasterTablesCommentRun(DataRuntime runtime, Catalog catalog, Schema schema, String pattern, int types) throws Exception {
        MasterTable query = new MasterTable(catalog, schema, pattern);
        return this.buildQueryMasterTablesCommentRun(runtime, query, types);
    }

    public <T extends MasterTable> LinkedHashMap<String, T> masters(DataRuntime var1, int var2, boolean var3, LinkedHashMap<String, T> var4, MasterTable var5, DataSet var6) throws Exception;

    default public <T extends MasterTable> LinkedHashMap<String, T> masters(DataRuntime runtime, int index, boolean create, LinkedHashMap<String, T> previous, Catalog catalog, Schema schema, DataSet set) throws Exception {
        MasterTable query = new MasterTable();
        query.setCatalog(catalog);
        query.setSchema(schema);
        return this.masters(runtime, index, create, previous, query, set);
    }

    public <T extends MasterTable> List<T> masters(DataRuntime var1, int var2, boolean var3, List<T> var4, MasterTable var5, DataSet var6) throws Exception;

    default public <T extends MasterTable> List<T> masters(DataRuntime runtime, int index, boolean create, List<T> previous, Catalog catalog, Schema schema, DataSet set) throws Exception {
        MasterTable query = new MasterTable();
        query.setCatalog(catalog);
        query.setSchema(schema);
        return this.masters(runtime, index, create, previous, query, set);
    }

    public <T extends MasterTable> LinkedHashMap<String, T> masters(DataRuntime var1, boolean var2, LinkedHashMap<String, T> var3, MasterTable var4, int var5) throws Exception;

    default public <T extends MasterTable> LinkedHashMap<String, T> masters(DataRuntime runtime, boolean create, LinkedHashMap<String, T> previous, Catalog catalog, Schema schema, String pattern, int types) throws Exception {
        MasterTable query = new MasterTable(catalog, schema, pattern);
        return this.masters(runtime, create, previous, query, types);
    }

    public <T extends MasterTable> List<T> masters(DataRuntime var1, boolean var2, List<T> var3, MasterTable var4, int var5) throws Exception;

    default public <T extends MasterTable> List<T> masters(DataRuntime runtime, boolean create, List<T> previous, Catalog catalog, Schema schema, String pattern, int types) throws Exception {
        MasterTable query = new MasterTable(catalog, schema, pattern);
        return this.masters(runtime, create, previous, query, types);
    }

    public List<String> ddl(DataRuntime var1, String var2, MasterTable var3, boolean var4);

    public List<Run> buildQueryDdlRun(DataRuntime var1, MasterTable var2) throws Exception;

    public List<String> ddl(DataRuntime var1, int var2, MasterTable var3, List<String> var4, DataSet var5);

    public <T extends MasterTable> T init(DataRuntime var1, int var2, T var3, MasterTable var4, DataRow var5);

    default public <T extends MasterTable> T init(DataRuntime runtime, int index, T meta, Catalog catalog, Schema schema, DataRow row) {
        MasterTable query = new MasterTable();
        query.setCatalog(catalog);
        query.setSchema(schema);
        return this.init(runtime, index, meta, query, row);
    }

    public <T extends MasterTable> T detail(DataRuntime var1, int var2, T var3, MasterTable var4, DataRow var5);

    default public <T extends MasterTable> T detail(DataRuntime runtime, int index, T meta, Catalog catalog, Schema schema, DataRow row) {
        MasterTable query = new MasterTable();
        query.setCatalog(catalog);
        query.setSchema(schema);
        return this.detail(runtime, index, meta, query, row);
    }

    public Table.Partition partition(DataRuntime var1, String var2, Table var3);

    public List<Run> buildQueryTablePartitionRun(DataRuntime var1, Table var2);

    public Table.Partition partition(DataRuntime var1, int var2, boolean var3, Table.Partition var4, Table var5, DataSet var6) throws Exception;

    public Table.Partition init(DataRuntime var1, int var2, boolean var3, Table.Partition var4, Table var5, DataRow var6) throws Exception;

    public Table.Partition detail(DataRuntime var1, int var2, boolean var3, Table.Partition var4, Table var5, DataRow var6) throws Exception;

    public <T extends PartitionTable> LinkedHashMap<String, T> partitions(DataRuntime var1, String var2, boolean var3, PartitionTable var4);

    default public <T extends PartitionTable> LinkedHashMap<String, T> partitions(DataRuntime runtime, String random, boolean greedy, MasterTable master, Map<String, Object> tags, String pattern) {
        PartitionTable query = new PartitionTable();
        query.setMaster((Table)master);
        if (null != tags) {
            for (String key : tags.keySet()) {
                Tag tag = null;
                Object value = tags.get(key);
                tag = value instanceof Tag ? (Tag)value : new Tag(key, value);
                query.addTag(tag);
            }
        }
        query.setName(pattern);
        return this.partitions(runtime, random, greedy, query);
    }

    public List<Run> buildQueryPartitionTablesRun(DataRuntime var1, boolean var2, PartitionTable var3, int var4) throws Exception;

    default public List<Run> buildQueryPartitionTablesRun(DataRuntime runtime, boolean greedy, Catalog catalog, Schema schema, String pattern, int types) throws Exception {
        PartitionTable query = new PartitionTable(catalog, schema, pattern);
        return this.buildQueryPartitionTablesRun(runtime, greedy, query, types);
    }

    default public List<Run> buildQueryPartitionTablesRun(DataRuntime runtime, boolean greedy, PartitionTable query) throws Exception {
        return this.buildQueryPartitionTablesRun(runtime, greedy, query, 1);
    }

    default public List<Run> buildQueryPartitionTablesRun(DataRuntime runtime, boolean greedy, Table master, Map<String, Tag> tags, String pattern) throws Exception {
        PartitionTable query = new PartitionTable();
        query.setMaster(master);
        if (null != tags) {
            for (String key : tags.keySet()) {
                Tag tag = null;
                Tag value = tags.get(key);
                tag = value instanceof Tag ? value : new Tag(key, (Object)value);
                query.addTag(tag);
            }
        }
        query.setName(pattern);
        return this.buildQueryPartitionTablesRun(runtime, greedy, query);
    }

    default public List<Run> buildQueryPartitionTablesRun(DataRuntime runtime, boolean greedy, Table master, Map<String, Tag> tags) throws Exception {
        PartitionTable query = new PartitionTable();
        query.setMaster(master);
        if (null != tags) {
            for (String key : tags.keySet()) {
                Tag tag = null;
                Tag value = tags.get(key);
                tag = value instanceof Tag ? value : new Tag(key, (Object)value);
                query.addTag(tag);
            }
        }
        return this.buildQueryPartitionTablesRun(runtime, greedy, query);
    }

    default public List<Run> buildQueryPartitionTablesRun(DataRuntime runtime, boolean greedy, Table master) throws Exception {
        PartitionTable query = new PartitionTable();
        query.setMaster(master);
        return this.buildQueryPartitionTablesRun(runtime, greedy, query);
    }

    public MetadataFieldRefer initPartitionTableFieldRefer();

    public MetadataFieldRefer initTablePartitionFieldRefer();

    public MetadataFieldRefer initTablePartitionSliceFieldRefer();

    public <T extends PartitionTable> LinkedHashMap<String, T> partitions(DataRuntime var1, int var2, int var3, boolean var4, LinkedHashMap<String, T> var5, PartitionTable var6, DataSet var7) throws Exception;

    default public <T extends PartitionTable> LinkedHashMap<String, T> partitions(DataRuntime runtime, int total, int index, boolean create, MasterTable master, LinkedHashMap<String, T> tables, Catalog catalog, Schema schema, DataSet set) throws Exception {
        PartitionTable query = new PartitionTable();
        query.setMaster((Table)master);
        query.setCatalog(catalog);
        query.setSchema(schema);
        return this.partitions(runtime, total, index, create, tables, query, set);
    }

    public <T extends PartitionTable> LinkedHashMap<String, T> partitions(DataRuntime var1, boolean var2, LinkedHashMap<String, T> var3, PartitionTable var4) throws Exception;

    default public <T extends PartitionTable> LinkedHashMap<String, T> partitions(DataRuntime runtime, boolean create, LinkedHashMap<String, T> tables, Catalog catalog, Schema schema, MasterTable master) throws Exception {
        PartitionTable query = new PartitionTable();
        query.setMaster((Table)master);
        query.setCatalog(catalog);
        query.setSchema(schema);
        return this.partitions(runtime, create, tables, query);
    }

    public List<String> ddl(DataRuntime var1, String var2, PartitionTable var3);

    public List<Run> buildQueryDdlRun(DataRuntime var1, PartitionTable var2) throws Exception;

    public List<String> ddl(DataRuntime var1, int var2, PartitionTable var3, List<String> var4, DataSet var5);

    public <T extends PartitionTable> T init(DataRuntime var1, int var2, T var3, PartitionTable var4, DataRow var5);

    default public <T extends PartitionTable> T init(DataRuntime runtime, int index, T meta, Catalog catalog, Schema schema, DataRow row) {
        PartitionTable query = new PartitionTable();
        query.setCatalog(catalog);
        query.setSchema(schema);
        return this.init(runtime, index, meta, query, row);
    }

    public <T extends PartitionTable> T detail(DataRuntime var1, int var2, T var3, PartitionTable var4, DataRow var5);

    default public <T extends PartitionTable> T detail(DataRuntime runtime, int index, T meta, Catalog catalog, Schema schema, DataRow row) {
        PartitionTable query = new PartitionTable();
        query.setCatalog(catalog);
        query.setSchema(schema);
        return this.detail(runtime, index, meta, query, row);
    }

    public <T extends Column> LinkedHashMap<String, T> columns(DataRuntime var1, String var2, boolean var3, Table var4, Column var5, boolean var6, ConfigStore var7);

    default public <T extends Column> LinkedHashMap<String, T> columns(DataRuntime runtime, String random, boolean greedy, Table table, boolean primary, ConfigStore configs) {
        Column query = new Column();
        query.setTable(table);
        return this.columns(runtime, random, greedy, table, query, primary, configs);
    }

    default public <T extends Column> LinkedHashMap<String, T> columns(DataRuntime runtime, String random, boolean greedy, Table table, boolean primary) {
        Column query = new Column();
        query.setTable(table);
        return this.columns(runtime, random, greedy, table, query, primary, new DefaultConfigStore(new String[0]));
    }

    default public <T extends Column> List<T> columns(DataRuntime runtime, String random, boolean greedy, Column query, ConfigStore configs) {
        return this.columns(runtime, random, greedy, new ArrayList(), query, configs);
    }

    public <T extends Column> List<T> columns(DataRuntime var1, String var2, boolean var3, Collection<? extends Table> var4, Column var5, ConfigStore var6);

    default public <T extends Column> List<T> columns(DataRuntime runtime, String random, boolean greedy, Collection<? extends Table> tables, Column query) {
        return this.columns(runtime, random, greedy, tables, query, (ConfigStore)new DefaultConfigStore(new String[0]));
    }

    public List<Run> buildQueryColumnsRun(DataRuntime var1, boolean var2, Column var3, ConfigStore var4) throws Exception;

    public List<Run> buildQueryColumnsRun(DataRuntime var1, boolean var2, Collection<? extends Table> var3, Column var4, ConfigStore var5) throws Exception;

    public MetadataFieldRefer initColumnFieldRefer();

    public <T extends Column> LinkedHashMap<String, T> columns(DataRuntime var1, int var2, boolean var3, LinkedHashMap<String, T> var4, Table var5, Column var6, DataSet var7) throws Exception;

    public <T extends Column> List<T> columns(DataRuntime var1, int var2, boolean var3, List<T> var4, Column var5, DataSet var6) throws Exception;

    public <T extends Column> LinkedHashMap<String, T> columns(DataRuntime var1, boolean var2, LinkedHashMap<String, T> var3, Column var4) throws Exception;

    public <T extends Column> List<T> columns(DataRuntime var1, int var2, boolean var3, List<T> var4, Collection<? extends Table> var5, Column var6, DataSet var7) throws Exception;

    public <T extends Column> T init(DataRuntime var1, int var2, T var3, Column var4, DataRow var5);

    public <T extends Column> T detail(DataRuntime var1, int var2, T var3, Column var4, DataRow var5);

    default public TypeMetadata.Refer dataTypeMetadataRefer(DataRuntime runtime, TypeMetadata meta) {
        int ignoreScale;
        int ignorePrecision;
        int ignoreLength;
        String columnFieldScaleRefer;
        String columnFieldPrecisionRefer;
        TypeMetadata.Refer refer = new TypeMetadata.Refer();
        String columnFieldLengthRefer = this.columnFieldLengthRefer(runtime, meta);
        if (null != columnFieldLengthRefer) {
            refer.setLengthRefer(columnFieldLengthRefer);
        }
        if (null != (columnFieldPrecisionRefer = this.columnFieldPrecisionRefer(runtime, meta))) {
            refer.setPrecisionRefer(columnFieldPrecisionRefer);
        }
        if (null != (columnFieldScaleRefer = this.columnFieldScaleRefer(runtime, meta))) {
            refer.setScaleRefer(columnFieldScaleRefer);
        }
        if (-1 != (ignoreLength = this.ignoreLength(runtime, meta))) {
            refer.setIgnoreLength(ignoreLength);
        }
        if (-1 != (ignorePrecision = this.ignorePrecision(runtime, meta))) {
            refer.setIgnorePrecision(ignorePrecision);
        }
        if (-1 != (ignoreScale = this.ignoreScale(runtime, meta))) {
            refer.setIgnoreScale(ignoreScale);
        }
        return refer;
    }

    public String columnFieldLengthRefer(DataRuntime var1, TypeMetadata var2);

    public String columnFieldPrecisionRefer(DataRuntime var1, TypeMetadata var2);

    public String columnFieldScaleRefer(DataRuntime var1, TypeMetadata var2);

    public int columnMetadataIgnoreLength(DataRuntime var1, TypeMetadata var2);

    public int columnMetadataIgnorePrecision(DataRuntime var1, TypeMetadata var2);

    public int columnMetadataIgnoreScale(DataRuntime var1, TypeMetadata var2);

    public <T extends Tag> LinkedHashMap<String, T> tags(DataRuntime var1, String var2, boolean var3, Table var4, Tag var5);

    default public <T extends Tag> LinkedHashMap<String, T> tags(DataRuntime runtime, String random, boolean greedy, Table table) {
        Tag query = new Tag();
        query.setTable(table);
        return this.tags(runtime, random, greedy, table, query);
    }

    public List<Run> buildQueryTagsRun(DataRuntime var1, boolean var2, Tag var3) throws Exception;

    public MetadataFieldRefer initTagFieldRefer();

    public <T extends Tag> LinkedHashMap<String, T> tags(DataRuntime var1, int var2, boolean var3, LinkedHashMap<String, T> var4, Tag var5, DataSet var6) throws Exception;

    public <T extends Tag> LinkedHashMap<String, T> tags(DataRuntime var1, boolean var2, LinkedHashMap<String, T> var3, Tag var4) throws Exception;

    public <T extends Tag> T init(DataRuntime var1, int var2, T var3, Table var4, DataRow var5);

    public <T extends Tag> T detail(DataRuntime var1, int var2, T var3, Catalog var4, Schema var5, DataRow var6);

    public PrimaryKey primary(DataRuntime var1, String var2, boolean var3, PrimaryKey var4);

    default public PrimaryKey primary(DataRuntime runtime, String random, boolean greedy, Table table) {
        PrimaryKey query = new PrimaryKey();
        query.setTable(table);
        return this.primary(runtime, random, greedy, query);
    }

    public List<Run> buildQueryPrimaryRun(DataRuntime var1, boolean var2, PrimaryKey var3) throws Exception;

    default public List<Run> buildQueryPrimaryRun(DataRuntime runtime, boolean greedy, Table table) throws Exception {
        PrimaryKey query = new PrimaryKey();
        query.setTable(table);
        return this.buildQueryPrimaryRun(runtime, greedy, query);
    }

    public MetadataFieldRefer initPrimaryKeyFieldRefer();

    public <T extends PrimaryKey> T init(DataRuntime var1, int var2, T var3, PrimaryKey var4, DataSet var5) throws Exception;

    default public <T extends PrimaryKey> T init(DataRuntime runtime, int index, T meta, Table table, DataSet set) throws Exception {
        PrimaryKey query = new PrimaryKey();
        query.setTable(table);
        return this.init(runtime, index, meta, query, set);
    }

    public <T extends PrimaryKey> T detail(DataRuntime var1, int var2, T var3, PrimaryKey var4, DataSet var5) throws Exception;

    default public <T extends PrimaryKey> T detail(DataRuntime runtime, int index, T meta, Table table, DataSet set) throws Exception {
        PrimaryKey query = new PrimaryKey();
        query.setTable(table);
        return this.detail(runtime, index, meta, query, set);
    }

    public PrimaryKey primary(DataRuntime var1, PrimaryKey var2) throws Exception;

    default public PrimaryKey primary(DataRuntime runtime, Table table) throws Exception {
        PrimaryKey query = new PrimaryKey();
        query.setTable(table);
        return this.primary(runtime, query);
    }

    public <T extends ForeignKey> LinkedHashMap<String, T> foreigns(DataRuntime var1, String var2, boolean var3, ForeignKey var4);

    default public <T extends ForeignKey> LinkedHashMap<String, T> foreigns(DataRuntime runtime, String random, boolean greedy, Table table) {
        ForeignKey query = new ForeignKey();
        query.setTable(table);
        return this.foreigns(runtime, random, greedy, query);
    }

    public List<Run> buildQueryForeignsRun(DataRuntime var1, boolean var2, ForeignKey var3) throws Exception;

    default public List<Run> buildQueryForeignsRun(DataRuntime runtime, boolean greedy, Table table) throws Exception {
        ForeignKey query = new ForeignKey();
        query.setTable(table);
        return this.buildQueryForeignsRun(runtime, greedy, query);
    }

    public MetadataFieldRefer initForeignKeyFieldRefer();

    public <T extends ForeignKey> LinkedHashMap<String, T> foreigns(DataRuntime var1, int var2, LinkedHashMap<String, T> var3, ForeignKey var4, DataSet var5) throws Exception;

    default public <T extends ForeignKey> LinkedHashMap<String, T> foreigns(DataRuntime runtime, int index, Table table, LinkedHashMap<String, T> previous, DataSet set) throws Exception {
        ForeignKey query = new ForeignKey();
        query.setTable(table);
        return this.foreigns(runtime, index, previous, query, set);
    }

    public <T extends ForeignKey> T init(DataRuntime var1, int var2, T var3, ForeignKey var4, DataRow var5) throws Exception;

    default public <T extends ForeignKey> T init(DataRuntime runtime, int index, T meta, Table table, DataRow row) throws Exception {
        ForeignKey query = new ForeignKey();
        query.setTable(table);
        return this.init(runtime, index, meta, query, row);
    }

    public <T extends ForeignKey> T detail(DataRuntime var1, int var2, T var3, ForeignKey var4, DataRow var5) throws Exception;

    default public <T extends ForeignKey> T detail(DataRuntime runtime, int index, T meta, Table table, DataRow row) throws Exception {
        ForeignKey query = new ForeignKey();
        query.setTable(table);
        return this.detail(runtime, index, meta, query, row);
    }

    public <T extends Index> List<T> indexes(DataRuntime var1, String var2, boolean var3, Index var4);

    default public <T extends Index> List<T> indexes(DataRuntime runtime, String random, boolean greedy, Table table, String pattern) {
        Index query = new Index();
        query.setTable(table);
        query.setName(pattern);
        return this.indexes(runtime, random, greedy, query);
    }

    public <T extends Index> List<T> indexes(DataRuntime var1, String var2, boolean var3, Collection<? extends Table> var4, Index var5);

    public <T extends Index> LinkedHashMap<String, T> indexes(DataRuntime var1, String var2, Index var3);

    default public <T extends Index> LinkedHashMap<String, T> indexes(DataRuntime runtime, String random, Table table, String pattern) {
        Index query = new Index();
        query.setTable(table);
        query.setName(pattern);
        return this.indexes(runtime, random, query);
    }

    public List<Run> buildQueryIndexesRun(DataRuntime var1, boolean var2, Index var3);

    default public List<Run> buildQueryIndexesRun(DataRuntime runtime, boolean greedy, Table table, String pattern) {
        Index query = new Index();
        query.setTable(table);
        query.setName(pattern);
        return this.buildQueryIndexesRun(runtime, greedy, query);
    }

    public List<Run> buildQueryIndexesRun(DataRuntime var1, boolean var2, Collection<? extends Table> var3);

    public MetadataFieldRefer initIndexFieldRefer();

    public <T extends Index> LinkedHashMap<String, T> indexes(DataRuntime var1, int var2, boolean var3, LinkedHashMap<String, T> var4, Index var5, DataSet var6) throws Exception;

    default public <T extends Index> LinkedHashMap<String, T> indexes(DataRuntime runtime, int index, boolean create, Table table, LinkedHashMap<String, T> previous, DataSet set) throws Exception {
        Index query = new Index();
        query.setTable(table);
        return this.indexes(runtime, index, create, previous, query, set);
    }

    public <T extends Index> List<T> indexes(DataRuntime var1, int var2, boolean var3, List<T> var4, Index var5, DataSet var6) throws Exception;

    default public <T extends Index> List<T> indexes(DataRuntime runtime, int index, boolean create, Table table, List<T> previous, DataSet set) throws Exception {
        Index query = new Index();
        query.setTable(table);
        return this.indexes(runtime, index, create, previous, query, set);
    }

    public <T extends Index> List<T> indexes(DataRuntime var1, int var2, boolean var3, Collection<? extends Table> var4, List<T> var5, Index var6, DataSet var7) throws Exception;

    public <T extends Index> List<T> indexes(DataRuntime var1, boolean var2, List<T> var3, Index var4) throws Exception;

    default public <T extends Index> List<T> indexes(DataRuntime runtime, boolean create, List<T> indexes, Table table, boolean unique, boolean approximate) throws Exception {
        Index query = new Index();
        query.setTable(table);
        query.setUnique(unique);
        return this.indexes(runtime, create, indexes, query);
    }

    public <T extends Index> LinkedHashMap<String, T> indexes(DataRuntime var1, boolean var2, LinkedHashMap<String, T> var3, Index var4) throws Exception;

    default public <T extends Index> LinkedHashMap<String, T> indexes(DataRuntime runtime, boolean create, LinkedHashMap<String, T> indexes, Table table, boolean unique, boolean approximate) throws Exception {
        Index query = new Index();
        query.setTable(table);
        query.setUnique(unique);
        return this.indexes(runtime, create, indexes, query);
    }

    public <T extends Index> T init(DataRuntime var1, int var2, T var3, Index var4, DataRow var5) throws Exception;

    default public <T extends Index> T init(DataRuntime runtime, int index, T meta, Table table, DataRow row) throws Exception {
        Index query = new Index();
        query.setTable(table);
        return this.init(runtime, index, meta, query, row);
    }

    public <T extends Index> T detail(DataRuntime var1, int var2, T var3, Index var4, DataRow var5) throws Exception;

    default public <T extends Index> T detail(DataRuntime runtime, int index, T meta, Table table, DataRow row) throws Exception {
        Index query = new Index();
        query.setTable(table);
        return this.detail(runtime, index, meta, query, row);
    }

    public <T extends Constraint> List<T> constraints(DataRuntime var1, String var2, boolean var3, Constraint var4);

    default public <T extends Constraint> List<T> constraints(DataRuntime runtime, String random, boolean greedy, Table table, String pattern) {
        Constraint query = new Constraint();
        query.setTable(table);
        query.setName(pattern);
        return this.constraints(runtime, random, greedy, query);
    }

    public <T extends Constraint> LinkedHashMap<String, T> constraints(DataRuntime var1, String var2, Constraint var3);

    default public <T extends Constraint> LinkedHashMap<String, T> constraints(DataRuntime runtime, String random, Table table, Column column, String pattern) {
        Constraint query = new Constraint();
        query.setTable(table);
        query.setName(pattern);
        if (null != column) {
            query.addColumn(column);
        }
        return this.constraints(runtime, random, query);
    }

    public List<Run> buildQueryConstraintsRun(DataRuntime var1, boolean var2, Constraint var3);

    default public List<Run> buildQueryConstraintsRun(DataRuntime runtime, boolean greedy, Table table, Column column, String pattern) {
        Constraint query = new Constraint();
        query.setTable(table);
        query.setName(pattern);
        if (null != column) {
            query.addColumn(column);
        }
        return this.buildQueryConstraintsRun(runtime, greedy, query);
    }

    public MetadataFieldRefer initConstraintFieldRefer();

    public <T extends Constraint> List<T> constraints(DataRuntime var1, int var2, boolean var3, List<T> var4, Constraint var5, DataSet var6) throws Exception;

    default public <T extends Constraint> List<T> constraints(DataRuntime runtime, int index, boolean create, Table table, List<T> previous, DataSet set) throws Exception {
        Constraint query = new Constraint();
        query.setTable(table);
        return this.constraints(runtime, index, create, previous, query, set);
    }

    public <T extends Constraint> LinkedHashMap<String, T> constraints(DataRuntime var1, int var2, boolean var3, LinkedHashMap<String, T> var4, Constraint var5, DataSet var6) throws Exception;

    default public <T extends Constraint> LinkedHashMap<String, T> constraints(DataRuntime runtime, int index, boolean create, Table table, LinkedHashMap<String, Column> columns, LinkedHashMap<String, T> previous, DataSet set) throws Exception {
        Constraint query = new Constraint();
        query.setTable(table);
        query.setColumns(columns);
        return this.constraints(runtime, index, create, previous, query, set);
    }

    public <T extends Constraint> T init(DataRuntime var1, int var2, T var3, Constraint var4, DataRow var5);

    default public <T extends Constraint> T init(DataRuntime runtime, int index, T meta, Catalog catalog, Schema schema, DataRow row) {
        Constraint query = new Constraint();
        query.setCatalog(catalog);
        query.setSchema(schema);
        return this.init(runtime, index, meta, query, row);
    }

    public <T extends Constraint> T detail(DataRuntime var1, int var2, T var3, Constraint var4, DataRow var5);

    default public <T extends Constraint> T detail(DataRuntime runtime, int index, T meta, Catalog catalog, Schema schema, DataRow row) {
        Constraint query = new Constraint();
        query.setCatalog(catalog);
        query.setSchema(schema);
        return this.detail(runtime, index, meta, query, row);
    }

    public <T extends Trigger> LinkedHashMap<String, T> triggers(DataRuntime var1, String var2, boolean var3, Trigger var4);

    default public <T extends Trigger> LinkedHashMap<String, T> triggers(DataRuntime runtime, String random, boolean greedy, Table table, List<Trigger.EVENT> events) {
        Trigger query = new Trigger();
        query.setTable(table);
        query.setEvent(events);
        return this.triggers(runtime, random, greedy, query);
    }

    public List<Run> buildQueryTriggersRun(DataRuntime var1, boolean var2, Trigger var3);

    default public List<Run> buildQueryTriggersRun(DataRuntime runtime, boolean greedy, Table table, List<Trigger.EVENT> events) {
        Trigger query = new Trigger();
        query.setTable(table);
        query.setEvent(events);
        return this.buildQueryTriggersRun(runtime, greedy, query);
    }

    public MetadataFieldRefer initTriggerFieldRefer();

    public <T extends Trigger> LinkedHashMap<String, T> triggers(DataRuntime var1, int var2, boolean var3, LinkedHashMap<String, T> var4, Trigger var5, DataSet var6) throws Exception;

    default public <T extends Trigger> LinkedHashMap<String, T> triggers(DataRuntime runtime, int index, boolean create, Table table, LinkedHashMap<String, T> previous, DataSet set) throws Exception {
        Trigger query = new Trigger();
        query.setTable(table);
        return this.triggers(runtime, index, create, previous, query, set);
    }

    public <T extends Trigger> T init(DataRuntime var1, int var2, T var3, Trigger var4, DataRow var5);

    default public <T extends Trigger> T init(DataRuntime runtime, int index, T meta, Catalog catalog, Schema schema, DataRow row) {
        Trigger query = new Trigger();
        query.setCatalog(catalog);
        query.setSchema(schema);
        return this.init(runtime, index, meta, query, row);
    }

    public <T extends Trigger> T detail(DataRuntime var1, int var2, T var3, Trigger var4, DataRow var5);

    default public <T extends Trigger> T detail(DataRuntime runtime, int index, T meta, Catalog catalog, Schema schema, DataRow row) {
        Trigger query = new Trigger();
        query.setCatalog(catalog);
        query.setSchema(schema);
        return this.detail(runtime, index, meta, query, row);
    }

    public <T extends Procedure> List<T> procedures(DataRuntime var1, String var2, boolean var3, Procedure var4);

    default public <T extends Procedure> List<T> procedures(DataRuntime runtime, String random, boolean greedy, Catalog catalog, Schema schema, String pattern) {
        Procedure query = new Procedure();
        query.setCatalog(catalog);
        query.setSchema(schema);
        return this.procedures(runtime, random, greedy, query);
    }

    public <T extends Procedure> LinkedHashMap<String, T> procedures(DataRuntime var1, String var2, Procedure var3);

    default public <T extends Procedure> LinkedHashMap<String, T> procedures(DataRuntime runtime, String random, Catalog catalog, Schema schema, String pattern) {
        Procedure query = new Procedure();
        query.setCatalog(catalog);
        query.setSchema(schema);
        return this.procedures(runtime, random, query);
    }

    public List<Run> buildQueryProceduresRun(DataRuntime var1, boolean var2, Procedure var3);

    default public List<Run> buildQueryProceduresRun(DataRuntime runtime, boolean greedy, Catalog catalog, Schema schema, String pattern) {
        Procedure query = new Procedure();
        query.setCatalog(catalog);
        query.setSchema(schema);
        return this.buildQueryProceduresRun(runtime, greedy, query);
    }

    public MetadataFieldRefer initProcedureFieldRefer();

    public <T extends Procedure> List<T> procedures(DataRuntime var1, int var2, boolean var3, List<T> var4, Procedure var5, DataSet var6) throws Exception;

    public <T extends Procedure> LinkedHashMap<String, T> procedures(DataRuntime var1, int var2, boolean var3, LinkedHashMap<String, T> var4, Procedure var5, DataSet var6) throws Exception;

    public <T extends Procedure> List<T> procedures(DataRuntime var1, boolean var2, List<T> var3, Procedure var4) throws Exception;

    public <T extends Procedure> LinkedHashMap<String, T> procedures(DataRuntime var1, boolean var2, LinkedHashMap<String, T> var3, Procedure var4) throws Exception;

    public List<String> ddl(DataRuntime var1, String var2, Procedure var3);

    public List<Run> buildQueryDdlRun(DataRuntime var1, Procedure var2) throws Exception;

    public List<String> ddl(DataRuntime var1, int var2, Procedure var3, List<String> var4, DataSet var5);

    public <T extends Procedure> T init(DataRuntime var1, int var2, T var3, Procedure var4, DataRow var5);

    default public <T extends Procedure> T init(DataRuntime runtime, int index, T meta, Catalog catalog, Schema schema, DataRow row) {
        meta.setCatalog(catalog);
        meta.setSchema(schema);
        return this.init(runtime, index, meta, catalog, schema, row);
    }

    public <T extends Procedure> T detail(DataRuntime var1, int var2, T var3, Procedure var4, DataRow var5);

    default public <T extends Procedure> T detail(DataRuntime runtime, int index, T meta, Catalog catalog, Schema schema, DataRow row) {
        meta.setCatalog(catalog);
        meta.setSchema(schema);
        return this.detail(runtime, index, meta, catalog, schema, row);
    }

    public <T extends Function> List<T> functions(DataRuntime var1, String var2, boolean var3, Function var4);

    default public <T extends Function> List<T> functions(DataRuntime runtime, String random, boolean greedy, Catalog catalog, Schema schema, String pattern) {
        Function query = new Function(catalog, schema, pattern);
        return this.functions(runtime, random, greedy, query);
    }

    public <T extends Function> LinkedHashMap<String, T> functions(DataRuntime var1, String var2, Function var3);

    default public <T extends Function> LinkedHashMap<String, T> functions(DataRuntime runtime, String random, Catalog catalog, Schema schema, String pattern) {
        Function query = new Function(catalog, schema, pattern);
        return this.functions(runtime, random, query);
    }

    public List<Run> buildQueryFunctionsRun(DataRuntime var1, boolean var2, Function var3);

    default public List<Run> buildQueryFunctionsRun(DataRuntime runtime, boolean greedy, Catalog catalog, Schema schema, String pattern) {
        Function query = new Function(catalog, schema, pattern);
        return this.buildQueryFunctionsRun(runtime, greedy, query);
    }

    public MetadataFieldRefer initFunctionFieldRefer();

    public <T extends Function> List<T> functions(DataRuntime var1, int var2, boolean var3, List<T> var4, Function var5, DataSet var6) throws Exception;

    default public <T extends Function> List<T> functions(DataRuntime runtime, int index, boolean create, List<T> previous, Catalog catalog, Schema schema, DataSet set) throws Exception {
        Function query = new Function(catalog, schema, null);
        return this.functions(runtime, index, create, previous, query, set);
    }

    public <T extends Function> LinkedHashMap<String, T> functions(DataRuntime var1, int var2, boolean var3, LinkedHashMap<String, T> var4, Function var5, DataSet var6) throws Exception;

    default public <T extends Function> LinkedHashMap<String, T> functions(DataRuntime runtime, int index, boolean create, LinkedHashMap<String, T> previous, Catalog catalog, Schema schema, DataSet set) throws Exception {
        Function query = new Function(catalog, schema, null);
        return this.functions(runtime, index, create, previous, query, set);
    }

    public <T extends Function> List<T> functions(DataRuntime var1, boolean var2, List<T> var3, Function var4) throws Exception;

    public <T extends Function> LinkedHashMap<String, T> functions(DataRuntime var1, boolean var2, LinkedHashMap<String, T> var3, Function var4) throws Exception;

    public List<String> ddl(DataRuntime var1, String var2, Function var3);

    public List<Run> buildQueryDdlRun(DataRuntime var1, Function var2) throws Exception;

    public List<String> ddl(DataRuntime var1, int var2, Function var3, List<String> var4, DataSet var5);

    public <T extends Function> T init(DataRuntime var1, int var2, T var3, Function var4, DataRow var5);

    default public <T extends Function> T init(DataRuntime runtime, int index, T meta, Catalog catalog, Schema schema, DataRow row) {
        return this.init(runtime, index, meta, new Function(catalog, schema, null), row);
    }

    public <T extends Function> T detail(DataRuntime var1, int var2, T var3, Function var4, DataRow var5);

    default public <T extends Function> T detail(DataRuntime runtime, int index, T meta, Catalog catalog, Schema schema, DataRow row) {
        return this.detail(runtime, index, meta, new Function(catalog, schema, null), row);
    }

    public <T extends Sequence> List<T> sequences(DataRuntime var1, String var2, boolean var3, Sequence var4);

    default public <T extends Sequence> List<T> sequences(DataRuntime runtime, String random, boolean greedy, Catalog catalog, Schema schema, String pattern) {
        return this.sequences(runtime, random, greedy, new Sequence(catalog, schema, pattern));
    }

    public <T extends Sequence> LinkedHashMap<String, T> sequences(DataRuntime var1, String var2, Sequence var3);

    default public <T extends Sequence> LinkedHashMap<String, T> sequences(DataRuntime runtime, String random, Catalog catalog, Schema schema, String pattern) {
        return this.sequences(runtime, random, new Sequence(catalog, schema, pattern));
    }

    public List<Run> buildQuerySequencesRun(DataRuntime var1, boolean var2, Sequence var3);

    default public List<Run> buildQuerySequencesRun(DataRuntime runtime, boolean greedy, Catalog catalog, Schema schema, String pattern) {
        return this.buildQuerySequencesRun(runtime, greedy, new Sequence(catalog, schema, pattern));
    }

    public MetadataFieldRefer initSequenceFieldRefer();

    public <T extends Sequence> List<T> sequences(DataRuntime var1, int var2, boolean var3, List<T> var4, Sequence var5, DataSet var6) throws Exception;

    public <T extends Sequence> LinkedHashMap<String, T> sequences(DataRuntime var1, int var2, boolean var3, LinkedHashMap<String, T> var4, Sequence var5, DataSet var6) throws Exception;

    public <T extends Sequence> List<T> sequences(DataRuntime var1, boolean var2, List<T> var3, Sequence var4) throws Exception;

    public <T extends Sequence> LinkedHashMap<String, T> sequences(DataRuntime var1, boolean var2, LinkedHashMap<String, T> var3, Sequence var4) throws Exception;

    public List<String> ddl(DataRuntime var1, String var2, Sequence var3);

    public List<Run> buildQueryDdlRun(DataRuntime var1, Sequence var2) throws Exception;

    public List<String> ddl(DataRuntime var1, int var2, Sequence var3, List<String> var4, DataSet var5);

    public <T extends Sequence> T init(DataRuntime var1, int var2, T var3, Sequence var4, DataRow var5);

    default public <T extends Sequence> T init(DataRuntime runtime, int index, T meta, Catalog catalog, Schema schema, DataRow row) {
        return this.init(runtime, index, meta, new Sequence(catalog, schema, null), row);
    }

    public <T extends Sequence> T detail(DataRuntime var1, int var2, T var3, Sequence var4, DataRow var5);

    default public <T extends Sequence> T detail(DataRuntime runtime, int index, T meta, Catalog catalog, Schema schema, DataRow row) {
        return this.detail(runtime, index, meta, new Sequence(catalog, schema, null), row);
    }

    default public boolean slice() {
        return false;
    }

    default public boolean slice(boolean slice) {
        return slice && this.slice();
    }

    public <T extends Metadata> T search(List<T> var1, Catalog var2, Schema var3, String var4);

    public boolean execute(DataRuntime var1, String var2, Metadata var3, ACTION.DDL var4, Run var5);

    public boolean execute(DataRuntime var1, String var2, Metadata var3, ACTION.DDL var4, List<Run> var5);

    public <T extends Metadata> T parse(DataRuntime var1, Class<T> var2, String var3, ConfigStore var4);

    public boolean create(DataRuntime var1, Catalog var2) throws Exception;

    public boolean alter(DataRuntime var1, Catalog var2) throws Exception;

    public boolean drop(DataRuntime var1, Catalog var2) throws Exception;

    public boolean rename(DataRuntime var1, Catalog var2, String var3) throws Exception;

    public List<Run> buildCreateRun(DataRuntime var1, Catalog var2) throws Exception;

    public List<Run> buildAlterRun(DataRuntime var1, Catalog var2) throws Exception;

    public List<Run> buildRenameRun(DataRuntime var1, Catalog var2) throws Exception;

    public List<Run> buildDropRun(DataRuntime var1, Catalog var2) throws Exception;

    public List<Run> buildAppendCommentRun(DataRuntime var1, Catalog var2) throws Exception;

    public List<Run> buildAppendColumnCommentRun(DataRuntime var1, Catalog var2) throws Exception;

    public List<Run> buildChangeCommentRun(DataRuntime var1, Catalog var2) throws Exception;

    default public List<Run> buildAddCommentRun(DataRuntime runtime, Catalog catalog) throws Exception {
        return this.buildChangeCommentRun(runtime, catalog);
    }

    public StringBuilder checkCatalogExists(DataRuntime var1, StringBuilder var2, boolean var3);

    public StringBuilder engine(DataRuntime var1, StringBuilder var2, Catalog var3);

    public StringBuilder charset(DataRuntime var1, StringBuilder var2, Catalog var3);

    public StringBuilder comment(DataRuntime var1, StringBuilder var2, Catalog var3);

    public StringBuilder property(DataRuntime var1, StringBuilder var2, Catalog var3);

    public boolean create(DataRuntime var1, Schema var2) throws Exception;

    public boolean alter(DataRuntime var1, Schema var2) throws Exception;

    public boolean drop(DataRuntime var1, Schema var2) throws Exception;

    public boolean rename(DataRuntime var1, Schema var2, String var3) throws Exception;

    public List<Run> buildCreateRun(DataRuntime var1, Schema var2) throws Exception;

    public List<Run> buildAlterRun(DataRuntime var1, Schema var2) throws Exception;

    public List<Run> buildRenameRun(DataRuntime var1, Schema var2) throws Exception;

    public List<Run> buildDropRun(DataRuntime var1, Schema var2) throws Exception;

    public List<Run> buildAppendCommentRun(DataRuntime var1, Schema var2) throws Exception;

    public List<Run> buildAppendColumnCommentRun(DataRuntime var1, Schema var2) throws Exception;

    public List<Run> buildChangeCommentRun(DataRuntime var1, Schema var2) throws Exception;

    default public List<Run> buildAddCommentRun(DataRuntime runtime, Schema schema) throws Exception {
        return this.buildChangeCommentRun(runtime, schema);
    }

    public StringBuilder checkSchemaExists(DataRuntime var1, StringBuilder var2, boolean var3);

    public StringBuilder engine(DataRuntime var1, StringBuilder var2, Schema var3);

    public StringBuilder charset(DataRuntime var1, StringBuilder var2, Schema var3);

    public StringBuilder comment(DataRuntime var1, StringBuilder var2, Schema var3);

    public StringBuilder property(DataRuntime var1, StringBuilder var2, Schema var3);

    public boolean create(DataRuntime var1, Database var2) throws Exception;

    public boolean alter(DataRuntime var1, Database var2) throws Exception;

    public boolean drop(DataRuntime var1, Database var2) throws Exception;

    public boolean rename(DataRuntime var1, Database var2, String var3) throws Exception;

    public List<Run> buildCreateRun(DataRuntime var1, Database var2) throws Exception;

    public List<Run> buildAlterRun(DataRuntime var1, Database var2) throws Exception;

    public List<Run> buildRenameRun(DataRuntime var1, Database var2) throws Exception;

    public List<Run> buildDropRun(DataRuntime var1, Database var2) throws Exception;

    public List<Run> buildAppendCommentRun(DataRuntime var1, Database var2) throws Exception;

    public List<Run> buildAppendColumnCommentRun(DataRuntime var1, Database var2) throws Exception;

    public List<Run> buildChangeCommentRun(DataRuntime var1, Database var2) throws Exception;

    default public List<Run> buildAddCommentRun(DataRuntime runtime, Database database) throws Exception {
        return this.buildChangeCommentRun(runtime, database);
    }

    public StringBuilder checkDatabaseExists(DataRuntime var1, StringBuilder var2, boolean var3);

    public StringBuilder engine(DataRuntime var1, StringBuilder var2, Database var3);

    public StringBuilder charset(DataRuntime var1, StringBuilder var2, Database var3);

    public StringBuilder comment(DataRuntime var1, StringBuilder var2, Database var3);

    public StringBuilder property(DataRuntime var1, StringBuilder var2, Database var3);

    public boolean create(DataRuntime var1, Table var2) throws Exception;

    public boolean alter(DataRuntime var1, Table var2) throws Exception;

    public boolean drop(DataRuntime var1, Table var2) throws Exception;

    public boolean rename(DataRuntime var1, Table var2, String var3) throws Exception;

    default public String keyword(Metadata meta) {
        return meta.getKeyword();
    }

    public List<Run> buildCreateRun(DataRuntime var1, Table var2) throws Exception;

    public List<Run> buildAlterRun(DataRuntime var1, Table var2) throws Exception;

    public List<Run> buildAlterRun(DataRuntime var1, Table var2, Collection<Column> var3, boolean var4) throws Exception;

    default public List<Run> buildAlterRun(DataRuntime runtime, Table meta, Collection<Column> columns) throws Exception {
        return this.buildAlterRun(runtime, meta, columns, false);
    }

    public List<Run> buildRenameRun(DataRuntime var1, Table var2) throws Exception;

    public List<Run> buildDropRun(DataRuntime var1, Table var2) throws Exception;

    public List<Run> buildAppendCommentRun(DataRuntime var1, Table var2) throws Exception;

    public List<Run> buildAppendColumnCommentRun(DataRuntime var1, Table var2) throws Exception;

    public List<Run> buildChangeCommentRun(DataRuntime var1, Table var2) throws Exception;

    default public List<Run> buildAddCommentRun(DataRuntime runtime, Table table) throws Exception {
        return this.buildChangeCommentRun(runtime, table);
    }

    public StringBuilder checkTableExists(DataRuntime var1, StringBuilder var2, boolean var3);

    public void checkPrimary(DataRuntime var1, Table var2);

    public StringBuilder primary(DataRuntime var1, StringBuilder var2, Table var3);

    public StringBuilder engine(DataRuntime var1, StringBuilder var2, Table var3);

    public StringBuilder body(DataRuntime var1, StringBuilder var2, Table var3);

    public StringBuilder columns(DataRuntime var1, StringBuilder var2, Table var3);

    public StringBuilder indexes(DataRuntime var1, StringBuilder var2, Table var3);

    public StringBuilder charset(DataRuntime var1, StringBuilder var2, Table var3);

    public StringBuilder comment(DataRuntime var1, StringBuilder var2, Table var3);

    public StringBuilder keys(DataRuntime var1, StringBuilder var2, Table var3);

    public StringBuilder distribution(DataRuntime var1, StringBuilder var2, Table var3);

    public StringBuilder materialize(DataRuntime var1, StringBuilder var2, Table var3);

    public StringBuilder property(DataRuntime var1, StringBuilder var2, Table var3);

    public StringBuilder option(DataRuntime var1, StringBuilder var2, Table var3);

    public StringBuilder partitionBy(DataRuntime var1, StringBuilder var2, Table var3) throws Exception;

    public StringBuilder partitionOf(DataRuntime var1, StringBuilder var2, Table var3) throws Exception;

    public StringBuilder partitionFor(DataRuntime var1, StringBuilder var2, Table var3) throws Exception;

    public StringBuilder inherit(DataRuntime var1, StringBuilder var2, Table var3) throws Exception;

    public boolean create(DataRuntime var1, View var2) throws Exception;

    public boolean alter(DataRuntime var1, View var2) throws Exception;

    public boolean drop(DataRuntime var1, View var2) throws Exception;

    public boolean rename(DataRuntime var1, View var2, String var3) throws Exception;

    public List<Run> buildCreateRun(DataRuntime var1, View var2) throws Exception;

    public StringBuilder buildCreateRunHead(DataRuntime var1, StringBuilder var2, View var3) throws Exception;

    public StringBuilder buildCreateRunOption(DataRuntime var1, StringBuilder var2, View var3) throws Exception;

    public List<Run> buildAlterRun(DataRuntime var1, View var2) throws Exception;

    public List<Run> buildRenameRun(DataRuntime var1, View var2) throws Exception;

    public List<Run> buildDropRun(DataRuntime var1, View var2) throws Exception;

    public List<Run> buildAppendCommentRun(DataRuntime var1, View var2) throws Exception;

    public List<Run> buildChangeCommentRun(DataRuntime var1, View var2) throws Exception;

    public StringBuilder checkViewExists(DataRuntime var1, StringBuilder var2, boolean var3);

    public StringBuilder comment(DataRuntime var1, StringBuilder var2, View var3);

    public boolean create(DataRuntime var1, MasterTable var2) throws Exception;

    public boolean alter(DataRuntime var1, MasterTable var2) throws Exception;

    public boolean drop(DataRuntime var1, MasterTable var2) throws Exception;

    public boolean rename(DataRuntime var1, MasterTable var2, String var3) throws Exception;

    public List<Run> buildCreateRun(DataRuntime var1, MasterTable var2) throws Exception;

    public List<Run> buildDropRun(DataRuntime var1, MasterTable var2) throws Exception;

    public List<Run> buildAlterRun(DataRuntime var1, MasterTable var2) throws Exception;

    public List<Run> buildRenameRun(DataRuntime var1, MasterTable var2) throws Exception;

    public List<Run> buildAppendCommentRun(DataRuntime var1, MasterTable var2) throws Exception;

    public List<Run> buildChangeCommentRun(DataRuntime var1, MasterTable var2) throws Exception;

    public boolean create(DataRuntime var1, PartitionTable var2) throws Exception;

    public boolean alter(DataRuntime var1, PartitionTable var2) throws Exception;

    public boolean drop(DataRuntime var1, PartitionTable var2) throws Exception;

    public boolean rename(DataRuntime var1, PartitionTable var2, String var3) throws Exception;

    public List<Run> buildCreateRun(DataRuntime var1, PartitionTable var2) throws Exception;

    public List<Run> buildAppendCommentRun(DataRuntime var1, PartitionTable var2) throws Exception;

    public List<Run> buildAlterRun(DataRuntime var1, PartitionTable var2) throws Exception;

    public List<Run> buildDropRun(DataRuntime var1, PartitionTable var2) throws Exception;

    public List<Run> buildRenameRun(DataRuntime var1, PartitionTable var2) throws Exception;

    public List<Run> buildChangeCommentRun(DataRuntime var1, PartitionTable var2) throws Exception;

    public boolean add(DataRuntime var1, Column var2) throws Exception;

    public boolean alter(DataRuntime var1, Table var2, Column var3, boolean var4) throws Exception;

    default public boolean alter(DataRuntime runtime, Table table, Column meta) throws Exception {
        return this.alter(runtime, table, meta, true);
    }

    public boolean alter(DataRuntime var1, Column var2) throws Exception;

    public boolean drop(DataRuntime var1, Column var2) throws Exception;

    public boolean rename(DataRuntime var1, Column var2, String var3) throws Exception;

    public List<Run> buildAddRun(DataRuntime var1, Column var2, boolean var3) throws Exception;

    public List<Run> buildAlterRun(DataRuntime var1, Column var2, boolean var3) throws Exception;

    public List<Run> buildDropRun(DataRuntime var1, Column var2, boolean var3) throws Exception;

    public List<Run> buildRenameRun(DataRuntime var1, Column var2, boolean var3) throws Exception;

    public List<Run> buildChangeTypeRun(DataRuntime var1, Column var2, boolean var3) throws Exception;

    default public List<Run> buildChangeTypeRun(DataRuntime runtime, Column column) throws Exception {
        return this.buildChangeTypeRun(runtime, column, false);
    }

    public String alterColumnKeyword(DataRuntime var1);

    public StringBuilder addColumnGuide(DataRuntime var1, StringBuilder var2, Column var3);

    default public StringBuilder addColumnClose(DataRuntime runtime, StringBuilder builder, Column column) {
        return builder;
    }

    public StringBuilder dropColumnGuide(DataRuntime var1, StringBuilder var2, Column var3);

    public List<Run> buildChangeDefaultRun(DataRuntime var1, Column var2, boolean var3) throws Exception;

    public List<Run> buildChangeNullableRun(DataRuntime var1, Column var2, boolean var3) throws Exception;

    public List<Run> buildChangeCommentRun(DataRuntime var1, Column var2, boolean var3) throws Exception;

    public List<Run> buildAppendCommentRun(DataRuntime var1, Column var2, boolean var3) throws Exception;

    public List<Run> buildDropAutoIncrement(DataRuntime var1, Column var2, boolean var3) throws Exception;

    public StringBuilder define(DataRuntime var1, StringBuilder var2, Column var3, ACTION.DDL var4);

    public StringBuilder checkColumnExists(DataRuntime var1, StringBuilder var2, boolean var3);

    public StringBuilder type(DataRuntime var1, StringBuilder var2, Column var3);

    public int ignoreLength(DataRuntime var1, TypeMetadata var2);

    public int ignorePrecision(DataRuntime var1, TypeMetadata var2);

    public int ignoreScale(DataRuntime var1, TypeMetadata var2);

    public StringBuilder aggregation(DataRuntime var1, StringBuilder var2, Column var3);

    public StringBuilder type(DataRuntime var1, StringBuilder var2, Column var3, String var4, int var5, int var6, int var7);

    public StringBuilder nullable(DataRuntime var1, StringBuilder var2, Column var3, ACTION.DDL var4);

    public StringBuilder charset(DataRuntime var1, StringBuilder var2, Column var3);

    public StringBuilder defaultValue(DataRuntime var1, StringBuilder var2, Column var3);

    public StringBuilder primary(DataRuntime var1, StringBuilder var2, Column var3);

    public StringBuilder unique(DataRuntime var1, StringBuilder var2, Column var3);

    public StringBuilder increment(DataRuntime var1, StringBuilder var2, Column var3);

    public StringBuilder onupdate(DataRuntime var1, StringBuilder var2, Column var3);

    public StringBuilder position(DataRuntime var1, StringBuilder var2, Column var3);

    public StringBuilder comment(DataRuntime var1, StringBuilder var2, Column var3);

    public boolean add(DataRuntime var1, Tag var2) throws Exception;

    public boolean alter(DataRuntime var1, Table var2, Tag var3, boolean var4) throws Exception;

    default public boolean alter(DataRuntime runtime, Table table, Tag meta) throws Exception {
        return this.alter(runtime, table, meta, true);
    }

    public boolean alter(DataRuntime var1, Tag var2) throws Exception;

    public boolean drop(DataRuntime var1, Tag var2) throws Exception;

    public boolean rename(DataRuntime var1, Tag var2, String var3) throws Exception;

    public List<Run> buildAddRun(DataRuntime var1, Tag var2, boolean var3) throws Exception;

    public List<Run> buildAlterRun(DataRuntime var1, Tag var2, boolean var3) throws Exception;

    public List<Run> buildDropRun(DataRuntime var1, Tag var2, boolean var3) throws Exception;

    public List<Run> buildRenameRun(DataRuntime var1, Tag var2, boolean var3) throws Exception;

    public List<Run> buildChangeDefaultRun(DataRuntime var1, Tag var2, boolean var3) throws Exception;

    public List<Run> buildChangeNullableRun(DataRuntime var1, Tag var2, boolean var3) throws Exception;

    public List<Run> buildChangeCommentRun(DataRuntime var1, Tag var2, boolean var3) throws Exception;

    public List<Run> buildChangeTypeRun(DataRuntime var1, Tag var2, boolean var3) throws Exception;

    public StringBuilder checkTagExists(DataRuntime var1, StringBuilder var2, boolean var3);

    default public SQL_BUILD_IN_VALUE checkDefaultBuildInValue(DataRuntime runtime, Object def) {
        String chk;
        SQL_BUILD_IN_VALUE result = null;
        if (null != def && ("CURRENT_TIMESTAMP".equals(chk = def.toString().toUpperCase().trim()) || "CURRENT TIMESTAMP".equals(chk) || "SYSDATE".equals(chk) || "NOW()".equals(chk) || "NOW".equals(chk) || "SYSTIMESTAMP".equals(chk) || "GETDATE()".equals(chk) || chk.contains("DATETIME("))) {
            result = SQL_BUILD_IN_VALUE.CURRENT_DATETIME;
        }
        return result;
    }

    public boolean add(DataRuntime var1, PrimaryKey var2) throws Exception;

    public boolean alter(DataRuntime var1, PrimaryKey var2) throws Exception;

    public boolean alter(DataRuntime var1, Table var2, PrimaryKey var3, PrimaryKey var4) throws Exception;

    default public boolean alter(DataRuntime runtime, Table table, PrimaryKey meta) throws Exception {
        return this.alter(runtime, table, table.getPrimaryKey(), meta);
    }

    public boolean drop(DataRuntime var1, PrimaryKey var2) throws Exception;

    public boolean rename(DataRuntime var1, PrimaryKey var2, String var3) throws Exception;

    public List<Run> buildAddRun(DataRuntime var1, PrimaryKey var2, boolean var3) throws Exception;

    default public List<Run> buildAppendPrimaryRun(DataRuntime runtime, Table meta) throws Exception {
        return new ArrayList<Run>();
    }

    public List<Run> buildAlterRun(DataRuntime var1, PrimaryKey var2, PrimaryKey var3, boolean var4) throws Exception;

    default public List<Run> buildAlterRun(DataRuntime runtime, PrimaryKey origin, PrimaryKey meta) throws Exception {
        return this.buildAlterRun(runtime, origin, meta, false);
    }

    default public List<Run> buildAlterRun(DataRuntime runtime, PrimaryKey meta) throws Exception {
        return this.buildAlterRun(runtime, null, meta);
    }

    public List<Run> buildDropRun(DataRuntime var1, PrimaryKey var2, boolean var3) throws Exception;

    default public List<Run> buildDropRun(DataRuntime runtime, PrimaryKey primary) throws Exception {
        return this.buildDropRun(runtime, primary, false);
    }

    public List<Run> buildRenameRun(DataRuntime var1, PrimaryKey var2) throws Exception;

    public boolean add(DataRuntime var1, ForeignKey var2) throws Exception;

    public boolean alter(DataRuntime var1, ForeignKey var2) throws Exception;

    public boolean alter(DataRuntime var1, Table var2, ForeignKey var3) throws Exception;

    public boolean drop(DataRuntime var1, ForeignKey var2) throws Exception;

    public boolean rename(DataRuntime var1, ForeignKey var2, String var3) throws Exception;

    public List<Run> buildAddRun(DataRuntime var1, ForeignKey var2) throws Exception;

    public List<Run> buildAlterRun(DataRuntime var1, ForeignKey var2) throws Exception;

    public List<Run> buildDropRun(DataRuntime var1, ForeignKey var2) throws Exception;

    public List<Run> buildRenameRun(DataRuntime var1, ForeignKey var2) throws Exception;

    public boolean add(DataRuntime var1, Index var2) throws Exception;

    public boolean alter(DataRuntime var1, Index var2) throws Exception;

    public boolean alter(DataRuntime var1, Table var2, Index var3) throws Exception;

    public boolean drop(DataRuntime var1, Index var2) throws Exception;

    public boolean rename(DataRuntime var1, Index var2, String var3) throws Exception;

    public List<Run> buildAppendIndexRun(DataRuntime var1, Table var2) throws Exception;

    public List<Run> buildAddRun(DataRuntime var1, Index var2) throws Exception;

    public List<Run> buildAlterRun(DataRuntime var1, Index var2) throws Exception;

    public List<Run> buildDropRun(DataRuntime var1, Index var2) throws Exception;

    public List<Run> buildRenameRun(DataRuntime var1, Index var2) throws Exception;

    public StringBuilder type(DataRuntime var1, StringBuilder var2, Index var3);

    public StringBuilder property(DataRuntime var1, StringBuilder var2, Index var3);

    public StringBuilder comment(DataRuntime var1, StringBuilder var2, Index var3);

    public StringBuilder checkIndexExists(DataRuntime var1, StringBuilder var2, boolean var3);

    public boolean add(DataRuntime var1, Constraint var2) throws Exception;

    public boolean alter(DataRuntime var1, Constraint var2) throws Exception;

    public boolean alter(DataRuntime var1, Table var2, Constraint var3) throws Exception;

    public boolean drop(DataRuntime var1, Constraint var2) throws Exception;

    public boolean rename(DataRuntime var1, Constraint var2, String var3) throws Exception;

    public List<Run> buildAddRun(DataRuntime var1, Constraint var2) throws Exception;

    public List<Run> buildAlterRun(DataRuntime var1, Constraint var2) throws Exception;

    public List<Run> buildDropRun(DataRuntime var1, Constraint var2) throws Exception;

    public List<Run> buildRenameRun(DataRuntime var1, Constraint var2) throws Exception;

    public boolean add(DataRuntime var1, Trigger var2) throws Exception;

    public boolean alter(DataRuntime var1, Trigger var2) throws Exception;

    public boolean drop(DataRuntime var1, Trigger var2) throws Exception;

    public boolean rename(DataRuntime var1, Trigger var2, String var3) throws Exception;

    public List<Run> buildCreateRun(DataRuntime var1, Trigger var2) throws Exception;

    public List<Run> buildAlterRun(DataRuntime var1, Trigger var2) throws Exception;

    public List<Run> buildDropRun(DataRuntime var1, Trigger var2) throws Exception;

    public List<Run> buildRenameRun(DataRuntime var1, Trigger var2) throws Exception;

    public StringBuilder each(DataRuntime var1, StringBuilder var2, Trigger var3);

    public boolean create(DataRuntime var1, Procedure var2) throws Exception;

    public boolean alter(DataRuntime var1, Procedure var2) throws Exception;

    public boolean drop(DataRuntime var1, Procedure var2) throws Exception;

    public boolean rename(DataRuntime var1, Procedure var2, String var3) throws Exception;

    public List<Run> buildCreateRun(DataRuntime var1, Procedure var2) throws Exception;

    public List<Run> buildAlterRun(DataRuntime var1, Procedure var2) throws Exception;

    public List<Run> buildDropRun(DataRuntime var1, Procedure var2) throws Exception;

    public List<Run> buildRenameRun(DataRuntime var1, Procedure var2) throws Exception;

    public StringBuilder parameter(DataRuntime var1, StringBuilder var2, Parameter var3);

    public boolean create(DataRuntime var1, Function var2) throws Exception;

    public boolean alter(DataRuntime var1, Function var2) throws Exception;

    public boolean drop(DataRuntime var1, Function var2) throws Exception;

    public boolean rename(DataRuntime var1, Function var2, String var3) throws Exception;

    public List<Run> buildCreateRun(DataRuntime var1, Function var2) throws Exception;

    public List<Run> buildAlterRun(DataRuntime var1, Function var2) throws Exception;

    public List<Run> buildDropRun(DataRuntime var1, Function var2) throws Exception;

    public List<Run> buildRenameRun(DataRuntime var1, Function var2) throws Exception;

    public boolean create(DataRuntime var1, Sequence var2) throws Exception;

    public boolean alter(DataRuntime var1, Sequence var2) throws Exception;

    public boolean drop(DataRuntime var1, Sequence var2) throws Exception;

    public boolean rename(DataRuntime var1, Sequence var2, String var3) throws Exception;

    public List<Run> buildCreateRun(DataRuntime var1, Sequence var2) throws Exception;

    public List<Run> buildAlterRun(DataRuntime var1, Sequence var2) throws Exception;

    public List<Run> buildDropRun(DataRuntime var1, Sequence var2) throws Exception;

    public List<Run> buildRenameRun(DataRuntime var1, Sequence var2) throws Exception;

    public boolean execute(DataRuntime var1, String var2, Metadata var3, ACTION.Authorize var4, Run var5);

    public boolean execute(DataRuntime var1, String var2, Metadata var3, ACTION.Authorize var4, List<Run> var5);

    public boolean create(DataRuntime var1, Role var2) throws Exception;

    public boolean rename(DataRuntime var1, Role var2, Role var3) throws Exception;

    public boolean drop(DataRuntime var1, Role var2) throws Exception;

    public <T extends Role> List<T> roles(DataRuntime var1, String var2, boolean var3, Role var4) throws Exception;

    default public <T extends Role> List<T> roles(DataRuntime runtime, String random, boolean greedy, Catalog catalog, Schema schema, String pattern) throws Exception {
        Role query = new Role();
        query.setCatalog(catalog);
        query.setSchema(schema);
        query.setName(pattern);
        return this.roles(runtime, random, greedy, query);
    }

    default public <T extends Role> List<T> roles(DataRuntime runtime, String random, boolean greedy) throws Exception {
        return this.roles(runtime, random, greedy, null, null, null);
    }

    default public <T extends Role> List<T> roles(DataRuntime runtime, String random, boolean greedy, String pattern) throws Exception {
        return this.roles(runtime, random, greedy, null, null, pattern);
    }

    public List<Run> buildCreateRun(DataRuntime var1, Role var2) throws Exception;

    public List<Run> buildRenameRun(DataRuntime var1, Role var2, Role var3) throws Exception;

    public List<Run> buildDropRun(DataRuntime var1, Role var2) throws Exception;

    public List<Run> buildQueryRolesRun(DataRuntime var1, boolean var2, Role var3) throws Exception;

    default public List<Run> buildQueryRolesRun(DataRuntime runtime, boolean greedy, Catalog catalog, Schema schema, String pattern) throws Exception {
        return this.buildQueryRolesRun(runtime, greedy, new Role(catalog, schema, pattern));
    }

    public MetadataFieldRefer initRoleFieldRefer();

    public <T extends Role> List<T> roles(DataRuntime var1, int var2, boolean var3, List<T> var4, Role var5, DataSet var6) throws Exception;

    default public <T extends Role> List<T> roles(DataRuntime runtime, int index, boolean create, Catalog catalog, Schema schema, List<T> previous, DataSet set) throws Exception {
        return this.roles(runtime, index, create, previous, new Role(catalog, schema, null), set);
    }

    public <T extends Role> T init(DataRuntime var1, int var2, T var3, Role var4, DataRow var5);

    default public <T extends Role> T init(DataRuntime runtime, int index, T meta, Catalog catalog, Schema schema, DataRow row) {
        return this.init(runtime, index, meta, new Role(catalog, schema, null), row);
    }

    public <T extends Role> T detail(DataRuntime var1, int var2, T var3, Role var4, DataRow var5);

    default public <T extends Role> T detail(DataRuntime runtime, int index, T meta, Catalog catalog, Schema schema, DataRow row) {
        return this.detail(runtime, index, meta, new Role(catalog, schema, null), row);
    }

    public boolean create(DataRuntime var1, User var2) throws Exception;

    default public boolean create(DataRuntime runtime, String name, String password) throws Exception {
        return this.create(runtime, new User(name, password));
    }

    public boolean rename(DataRuntime var1, User var2, User var3) throws Exception;

    default public boolean rename(DataRuntime runtime, String origin, String update) throws Exception {
        return this.rename(runtime, new User(origin), new User(update));
    }

    public boolean drop(DataRuntime var1, User var2) throws Exception;

    default public boolean drop(DataRuntime runtime, String user) throws Exception {
        return this.drop(runtime, new User(user));
    }

    public <T extends User> List<T> users(DataRuntime var1, String var2, boolean var3, User var4) throws Exception;

    default public <T extends User> List<T> users(DataRuntime runtime, String random, boolean greedy, Catalog catalog, Schema schema, String pattern) throws Exception {
        User query = new User();
        query.setCatalog(catalog);
        query.setSchema(schema);
        query.setName(pattern);
        return this.users(runtime, random, greedy, query);
    }

    default public List<User> users(DataRuntime runtime, String random, boolean greedy) throws Exception {
        return this.users(runtime, random, greedy, null, null, null);
    }

    default public <T extends User> List<T> users(DataRuntime runtime, String random, boolean greedy, String pattern) throws Exception {
        return this.users(runtime, random, greedy, null, null, pattern);
    }

    public List<Run> buildCreateRun(DataRuntime var1, User var2) throws Exception;

    public List<Run> buildRenameRun(DataRuntime var1, User var2, User var3) throws Exception;

    public List<Run> buildDropRun(DataRuntime var1, User var2) throws Exception;

    public List<Run> buildQueryUsersRun(DataRuntime var1, boolean var2, User var3) throws Exception;

    default public List<Run> buildQueryUsersRun(DataRuntime runtime, boolean greedy, Catalog catalog, Schema schema, String pattern) throws Exception {
        return this.buildQueryUsersRun(runtime, greedy, new User(catalog, schema, pattern));
    }

    public MetadataFieldRefer initUserFieldRefer();

    public <T extends User> List<T> users(DataRuntime var1, int var2, boolean var3, List<T> var4, User var5, DataSet var6) throws Exception;

    default public <T extends User> List<T> users(DataRuntime runtime, int index, boolean create, Catalog catalog, Schema schema, List<T> previous, DataSet set) throws Exception {
        return this.users(runtime, index, create, previous, new User(catalog, schema, null), set);
    }

    public <T extends User> T init(DataRuntime var1, int var2, T var3, User var4, DataRow var5);

    default public <T extends User> T init(DataRuntime runtime, int index, T meta, Catalog catalog, Schema schema, DataRow row) {
        return this.init(runtime, index, meta, new User(catalog, schema, null), row);
    }

    public <T extends User> T detail(DataRuntime var1, int var2, T var3, User var4, DataRow var5);

    default public <T extends User> T detail(DataRuntime runtime, int index, T meta, Catalog catalog, Schema schema, DataRow row) {
        return this.detail(runtime, index, meta, new User(catalog, schema, null), row);
    }

    public <T extends Privilege> List<T> privileges(DataRuntime var1, String var2, boolean var3, Privilege var4) throws Exception;

    default public <T extends Privilege> List<T> privileges(DataRuntime runtime, String random, boolean greedy, User user) throws Exception {
        Privilege query = new Privilege();
        query.setUser(user);
        return this.privileges(runtime, random, greedy, query);
    }

    default public <T extends Privilege> List<T> privileges(DataRuntime runtime, String random, boolean greedy, String user) throws Exception {
        return this.privileges(runtime, random, greedy, new User(user));
    }

    public List<Run> buildQueryPrivilegesRun(DataRuntime var1, boolean var2, Privilege var3) throws Exception;

    default public List<Run> buildQueryPrivilegesRun(DataRuntime runtime, boolean greedy, User user) throws Exception {
        return this.buildQueryPrivilegesRun(runtime, greedy, new Privilege(user));
    }

    public MetadataFieldRefer initPrivilegeFieldRefer();

    public <T extends Privilege> List<T> privileges(DataRuntime var1, int var2, boolean var3, List<T> var4, Privilege var5, DataSet var6) throws Exception;

    default public <T extends Privilege> List<T> privileges(DataRuntime runtime, int index, boolean create, List<T> previous, User user, DataSet set) throws Exception {
        return this.privileges(runtime, index, create, previous, new Privilege(user), set);
    }

    public <T extends Privilege> T init(DataRuntime var1, int var2, T var3, Privilege var4, DataRow var5);

    default public <T extends Privilege> T init(DataRuntime runtime, int index, T meta, User user, DataRow row) {
        return this.init(runtime, index, meta, new Privilege(user), row);
    }

    public <T extends Privilege> T detail(DataRuntime var1, int var2, T var3, Privilege var4, DataRow var5);

    default public <T extends Privilege> T detail(DataRuntime runtime, int index, T meta, User user, DataRow row) {
        return this.detail(runtime, index, meta, new Privilege(user), row);
    }

    public boolean grant(DataRuntime var1, User var2, Privilege ... var3) throws Exception;

    public boolean grant(DataRuntime var1, Role var2, Privilege ... var3) throws Exception;

    public boolean grant(DataRuntime var1, User var2, Role ... var3) throws Exception;

    default public boolean grant(DataRuntime runtime, String user, Privilege ... privileges) throws Exception {
        return this.grant(runtime, new User(user), privileges);
    }

    public List<Run> buildGrantRun(DataRuntime var1, User var2, Privilege ... var3) throws Exception;

    public List<Run> buildGrantRun(DataRuntime var1, User var2, Role ... var3) throws Exception;

    public List<Run> buildGrantRun(DataRuntime var1, Role var2, Privilege ... var3) throws Exception;

    public boolean revoke(DataRuntime var1, User var2, Privilege ... var3) throws Exception;

    public boolean revoke(DataRuntime var1, User var2, Role ... var3) throws Exception;

    public boolean revoke(DataRuntime var1, Role var2, Privilege ... var3) throws Exception;

    default public boolean revoke(DataRuntime runtime, String user, Privilege ... privileges) throws Exception {
        return this.revoke(runtime, new User(user), privileges);
    }

    public List<Run> buildRevokeRun(DataRuntime var1, User var2, Privilege ... var3) throws Exception;

    public List<Run> buildRevokeRun(DataRuntime var1, User var2, Role ... var3) throws Exception;

    public List<Run> buildRevokeRun(DataRuntime var1, Role var2, Privilege ... var3) throws Exception;

    public StringBuilder name(DataRuntime var1, StringBuilder var2, Metadata var3);

    public StringBuilder name(DataRuntime var1, StringBuilder var2, Column var3);

    public Object convert(DataRuntime var1, StringBuilder var2, Object var3, Column var4, Boolean var5, Boolean var6, ConfigStore var7);

    public boolean convert(DataRuntime var1, Catalog var2, Schema var3, String var4, RunValue var5);

    public boolean convert(DataRuntime var1, Table var2, Run var3);

    public boolean convert(DataRuntime var1, ConfigStore var2, Run var3);

    default public boolean convert(DataRuntime runtime, ConfigStore configs, List<Run> runs) {
        for (Run run : runs) {
            this.convert(runtime, configs, run);
        }
        return true;
    }

    public boolean convert(DataRuntime var1, Map<String, Column> var2, RunValue var3);

    public boolean convert(DataRuntime var1, Column var2, RunValue var3);

    public Object convert(DataRuntime var1, Column var2, Object var3);

    public Object convert(DataRuntime var1, TypeMetadata var2, Object var3);

    public void value(DataRuntime var1, StringBuilder var2, Object var3, String var4);

    public Object read(DataRuntime var1, Column var2, Object var3, Class var4);

    public Object write(DataRuntime var1, Column var2, Object var3, Boolean var4, Boolean var5);

    default public String unicodeGuide(DataRuntime runtime) {
        return "";
    }

    public String concat(DataRuntime var1, String ... var2);

    public boolean isNumberColumn(DataRuntime var1, Column var2);

    public boolean isBooleanColumn(DataRuntime var1, Column var2);

    public boolean isCharColumn(DataRuntime var1, Column var2);

    public String value(DataRuntime var1, Column var2, SQL_BUILD_IN_VALUE var3);

    default public String defaultValue(DataRuntime runtime, Column column, SQL_BUILD_IN_VALUE value) {
        return this.value(runtime, column, value);
    }

    public void addRunValue(DataRuntime var1, Run var2, Compare var3, Column var4, Object var5);

    public String objectName(DataRuntime var1, String var2);

    default public String compressCondition(DataRuntime runtime, String cmd) {
        String head = this.conditionHead();
        cmd = cmd.replaceAll(head + "\\s*1=1\\s*AND", head);
        return cmd;
    }

    default public String conditionHead() {
        return "WHERE";
    }

    default public void formula(DataRuntime runtime, StringBuilder builder, String column, Compare compare, Column metadata, Object value, Boolean placeholder, Boolean unicode) {
        if (!placeholder.booleanValue()) {
            value = this.write(runtime, metadata, value, placeholder, unicode);
        }
        builder.append(compare.formula(column, value, placeholder, unicode));
    }

    public static enum SQL_BUILD_IN_VALUE {
        CURRENT_DATETIME("CURRENT_DATETIME", "\u5f53\u524d\u65e5\u671f\u65f6\u95f4"),
        CURRENT_DATE("CURRENT_DATE", "\u5f53\u524d\u65e5\u671f"),
        CURRENT_TIME("CURRENT_TIME", "\u5f53\u524d\u65f6\u95f4"),
        CURRENT_TIMESTAMP("CURRENT_TIMESTAMP", "\u5f53\u524d\u65f6\u95f4\u6233");

        private final String code;
        private final String name;

        private SQL_BUILD_IN_VALUE(String code, String name) {
            this.code = code;
            this.name = name;
        }

        String getCode() {
            return this.code;
        }

        String getName() {
            return this.name;
        }
    }
}

