/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.run;

import java.util.List;
import org.anyline.data.adapter.DriverAdapter;
import org.anyline.data.param.ConfigStore;
import org.anyline.data.prepare.ConditionChain;
import org.anyline.data.prepare.auto.init.DefaultAutoConditionChain;
import org.anyline.data.run.AbstractRun;
import org.anyline.data.run.Run;
import org.anyline.data.run.RunValue;
import org.anyline.data.runtime.DataRuntime;
import org.anyline.entity.Compare;
import org.anyline.entity.DefaultOrderStore;
import org.anyline.entity.PageNavi;
import org.anyline.metadata.Table;
import org.anyline.util.BasicUtil;
import org.anyline.util.SQLUtil;

public class TableRun
extends AbstractRun
implements Run {
    public TableRun(DataRuntime runtime, String table) {
        this.builder = new StringBuilder();
        this.conditionChain = new DefaultAutoConditionChain();
        this.orders = new DefaultOrderStore();
        this.table = new Table(table);
        this.runtime = runtime;
    }

    public TableRun(DataRuntime runtime, Table table) {
        this.builder = new StringBuilder();
        this.conditionChain = new DefaultAutoConditionChain();
        this.orders = new DefaultOrderStore();
        this.table = table;
        this.runtime = runtime;
    }

    private void parseDataSource() {
        String table = this.getTableName();
        if (null != this.prepare) {
            table = this.prepare.getTableName();
        }
        if (null != table && !(table = table.replace(this.delimiterFr, "").replace(this.delimiterTo, "")).contains(".") && null != this.prepare && BasicUtil.isNotEmpty((Object)this.prepare.getSchema())) {
            this.schema = this.prepare.getSchema();
        }
    }

    @Override
    public void init() {
        super.init();
        this.parseDataSource();
        if (null != this.configs) {
            ConditionChain chain = this.configs.getConfigChain().createAutoConditionChain();
            if (null != chain) {
                if (this.conditionChain.getConditions().isEmpty()) {
                    this.conditionChain = chain;
                } else {
                    this.addCondition(chain);
                }
            }
            this.orders.add(this.configs.getOrders());
            PageNavi navi = this.configs.getPageNavi();
            if (navi != null) {
                this.pageNavi = navi;
            }
        }
    }

    public void appendOrderStore() {
    }

    public void appendGroup(DataRuntime runtime, StringBuilder builder, Boolean placeholder, Boolean unicode) {
        String txt;
        if (null != this.configs) {
            if (null == this.groups) {
                this.groups = this.configs.getGroups();
            }
            if (BasicUtil.isEmpty((Object)this.having)) {
                this.having = this.configs.having();
            }
        }
        if (null != this.groups) {
            builder.append("\n").append(this.groups.getRunText(this.delimiterFr + this.delimiterTo));
        }
        if (null != this.having && BasicUtil.isNotEmpty((Object)(txt = SQLUtil.trim((String)this.having.getRunText(runtime, false, unicode))))) {
            builder.append("\nHAVING ").append(txt);
        }
    }

    public void appendGroup(DataRuntime runtime, Boolean placeholder, Boolean unicode) {
        this.appendGroup(runtime, this.builder, placeholder, unicode);
    }

    @Override
    public boolean checkValid() {
        if (!this.valid) {
            return false;
        }
        if (null != this.conditionChain && !this.conditionChain.isValid()) {
            this.valid = false;
        }
        if (null != this.configs && !this.configs.isValid()) {
            this.valid = false;
        }
        return this.valid;
    }

    public void appendCondition(StringBuilder builder, DriverAdapter adapter, boolean first, Boolean placeholder, Boolean unicode) {
        String condition;
        if (null == this.conditionChain) {
            return;
        }
        String alias = null;
        if (null != this.prepare) {
            alias = this.prepare.getAlias();
        }
        if (!(condition = this.conditionChain.getRunText(alias, this.runtime, placeholder, unicode)).isEmpty()) {
            this.emptyCondition = false;
            if (first) {
                builder.append("\n").append(adapter.conditionHead()).append(" ");
                condition = SQLUtil.trim((String)condition);
            }
            builder.append(condition);
        }
        List<RunValue> values = this.conditionChain.getRunValues();
        this.addValues(values);
    }

    public void appendCondition(DriverAdapter adapter, boolean first, Boolean placeholder, Boolean unicode) {
        this.appendCondition(this.builder, adapter, first, placeholder, unicode);
    }

    public void setConfigs(ConfigStore configs) {
        this.configs = configs;
        if (null != configs) {
            this.pageNavi = configs.getPageNavi();
        }
    }

    @Override
    public Run setConditionValue(Compare.EMPTY_VALUE_SWITCH swt, Compare compare, String condition, String variable, Object value) {
        return this;
    }

    @Override
    public String getTableName() {
        if (null != this.table) {
            return this.table.getName();
        }
        return null;
    }

    @Override
    public String getCatalogName() {
        if (null != this.catalog) {
            return this.catalog.getName();
        }
        return null;
    }

    @Override
    public String getSchemaName() {
        if (null != this.schema) {
            return this.schema.getName();
        }
        return null;
    }
}

