/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.prepare.xml.init;

import java.util.ArrayList;
import java.util.List;
import org.anyline.data.param.ConfigParser;
import org.anyline.data.param.ParseResult;
import org.anyline.data.prepare.Condition;
import org.anyline.data.prepare.RunPrepare;
import org.anyline.data.prepare.Variable;
import org.anyline.data.prepare.init.AbstractRunPrepare;
import org.anyline.data.prepare.xml.XMLPrepare;
import org.anyline.data.prepare.xml.init.DefaultXMLCondition;
import org.anyline.data.prepare.xml.init.DefaultXMLConditionChain;
import org.anyline.data.run.Run;
import org.anyline.data.run.XMLRun;
import org.anyline.data.runtime.DataRuntime;
import org.anyline.data.util.CommandParser;
import org.anyline.entity.Compare;
import org.anyline.entity.DataRow;
import org.anyline.entity.OriginRow;
import org.anyline.metadata.Catalog;
import org.anyline.metadata.Column;
import org.anyline.metadata.Schema;
import org.anyline.metadata.Table;
import org.anyline.util.BasicUtil;
import org.anyline.util.ConfigTable;

public class DefaultXMLPrepare
extends AbstractRunPrepare
implements XMLPrepare {
    private String id;
    private boolean strict = true;
    private List<Variable> variables = new ArrayList<Variable>();

    public DefaultXMLPrepare() {
        this.chain = new DefaultXMLConditionChain();
    }

    @Override
    public RunPrepare init() {
        for (Variable variable : this.variables) {
            if (null == variable) continue;
            variable.init();
        }
        if (null != this.chain) {
            for (Condition condition : this.chain.getConditions()) {
                if (null == condition) continue;
                condition.init();
            }
        }
        return this;
    }

    @Override
    public RunPrepare setText(String text) {
        if (null == text) {
            return this;
        }
        this.text = text = text.replaceAll("--.*", "");
        this.parseText();
        return this;
    }

    @Override
    public RunPrepare addCondition(String condition) {
        if (BasicUtil.isEmpty((Object)condition)) {
            return this;
        }
        if (condition.contains(":")) {
            ParseResult parser = ConfigParser.parse(condition, false);
            String prefix = parser.getPrefix();
            String var = null;
            List<Object> value = ConfigParser.getValues(parser);
            if (prefix.contains(".")) {
                String[] keys = prefix.split(".");
                prefix = keys[0];
                if (keys.length > 1) {
                    var = keys[1];
                }
            }
            this.setConditionValue(prefix, var, value);
        }
        return this;
    }

    private void parseText() {
        if (null == this.text) {
            return;
        }
        List<Variable> vars = CommandParser.parseTextVariable(ConfigTable.IS_ENABLE_PLACEHOLDER_REGEX_EXT, this.text, Compare.EMPTY_VALUE_SWITCH.NULL);
        this.variables.addAll(vars);
    }

    private void addVariable(Variable var) {
        this.variables.add(var);
    }

    @Override
    public RunPrepare setConditionValue(String condition, String variable, Object value) {
        if (BasicUtil.isEmpty((Object)variable)) {
            for (Variable v : this.variables) {
                if (!v.getKey().equalsIgnoreCase(condition)) continue;
                v.setValue(value);
            }
        }
        if (null == condition) {
            return this;
        }
        DefaultXMLCondition con = this.getCondition(condition);
        if (null == con) {
            return this;
        }
        variable = ((String)BasicUtil.nvl((Object[])new String[]{variable, condition})).toString();
        con.setValue(variable, value);
        return this;
    }

    private DefaultXMLCondition getCondition(String id) {
        if (null == this.chain) {
            return null;
        }
        for (Condition con : this.chain.getConditions()) {
            if (!BasicUtil.equalsIgnoreCase((Object)id, (Object)con.getId())) continue;
            return (DefaultXMLCondition)con;
        }
        return null;
    }

    @Override
    public RunPrepare setDest(String dest) {
        this.id = dest;
        return this;
    }

    @Override
    public RunPrepare setDest(Table dest) {
        return null;
    }

    @Override
    public RunPrepare setCatalog(String catalog) {
        return null;
    }

    @Override
    public Catalog getCatalog() {
        return null;
    }

    @Override
    public String getCatalogName() {
        return null;
    }

    @Override
    public RunPrepare setSchema(String schema) {
        return null;
    }

    @Override
    public String getSchemaName() {
        return null;
    }

    @Override
    public String getTableName() {
        return null;
    }

    @Override
    public String getDest() {
        return this.id;
    }

    @Override
    public Schema getSchema() {
        return null;
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public List<Variable> getSQLVariables() {
        return this.variables;
    }

    @Override
    public RunPrepare addColumn(String columns) {
        return this;
    }

    @Override
    public RunPrepare addColumn(Column column) {
        return this;
    }

    @Override
    public RunPrepare excludeColumn(String columns) {
        return this;
    }

    @Override
    public Table getTable() {
        return null;
    }

    @Override
    public Run build(DataRuntime runtime) {
        XMLRun run = new XMLRun();
        run.setPrepare(this);
        run.setRuntime(runtime);
        return run;
    }

    @Override
    public DataRow map(boolean empty, boolean join) {
        OriginRow row = new OriginRow();
        row.put("text", (Object)this.text);
        return row;
    }

    @Override
    public DefaultXMLPrepare clone() {
        DefaultXMLPrepare clone = null;
        try {
            clone = (DefaultXMLPrepare)super.clone();
        }
        catch (Exception e) {
            clone = new DefaultXMLPrepare();
        }
        clone.chain = this.chain.clone();
        if (!this.variables.isEmpty()) {
            ArrayList<Variable> cVariables = new ArrayList<Variable>();
            for (Variable var : this.variables) {
                if (null == var) continue;
                cVariables.add(var.clone());
            }
            clone.variables = cVariables;
        }
        return clone;
    }
}

