/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.param;

import java.util.ArrayList;
import java.util.List;
import org.anyline.data.param.ConfigBuilder;
import org.anyline.data.prepare.Condition;
import org.anyline.entity.Compare;
import org.anyline.entity.DataRow;
import org.anyline.entity.OriginRow;
import org.anyline.util.BasicUtil;

public class ParseResult {
    private static final long serialVersionUID = 1L;
    public static int FETCH_REQUEST_VALUE_TYPE_SINGLE = 1;
    public static int FETCH_REQUEST_VALUE_TYPE_MULTIPLE = 2;
    private Compare.EMPTY_VALUE_SWITCH swt = Compare.EMPTY_VALUE_SWITCH.IGNORE;
    private String prefix;
    private String var;
    private String clazz;
    private String method;
    private List<String> args = new ArrayList<String>();
    private String key;
    private boolean isKeyEncrypt;
    private boolean isValueEncrypt;
    private boolean setEncrypt = false;
    private String datatype;
    private List<ParseResult> defs = new ArrayList<ParseResult>();
    private ParseResult or = null;
    private Compare compare = Compare.EQUAL;
    private Condition.JOIN join = Condition.JOIN.AND;
    private int paramFetchType = FETCH_REQUEST_VALUE_TYPE_SINGLE;

    public DataRow map() {
        return this.map(false);
    }

    public DataRow map(boolean empty) {
        OriginRow row = new OriginRow();
        if (empty || BasicUtil.isNotEmpty((Object)this.prefix)) {
            row.put("prefix", (Object)this.prefix);
        }
        if (empty || BasicUtil.isNotEmpty((Object)this.var)) {
            row.put("var", (Object)this.var);
        }
        if (empty || BasicUtil.isNotEmpty((Object)this.clazz)) {
            row.put("class", (Object)this.clazz);
        }
        if (empty || BasicUtil.isNotEmpty((Object)this.method)) {
            row.put("method", (Object)this.method);
        }
        if (empty || BasicUtil.isNotEmpty((Object)this.key)) {
            row.put("key", (Object)this.key);
        }
        if (empty || BasicUtil.isNotEmpty((boolean)true, this.defs)) {
            row.put("default", this.defs);
        }
        if (empty || BasicUtil.isNotEmpty((Object)this.datatype)) {
            row.put("datatype", (Object)this.datatype);
        }
        row.put("compare", (Object)this.compare.getCode());
        row.put("join", (Object)this.join.getCode());
        row.put("swt", (Object)this.swt);
        return row;
    }

    public static ParseResult build(DataRow row) {
        ParseResult parser = new ParseResult();
        parser.setVar(row.getString("var"));
        DataRow parse = row.getRow("parser");
        if (null != parse) {
            parser.setPrefix(parse.getString("prefix"));
            parser.setVar(parse.getString("var"));
            parser.setClazz(parse.getString("class"));
            parser.setMethod(parse.getString("method"));
            parser.setKey(parse.getString("key"));
            String join = parse.getString("join");
            if (null != join) {
                parser.setJoin(Condition.JOIN.valueOf(join.trim().toUpperCase()));
            }
            parser.setCompare(ConfigBuilder.compare(parse.getInt("compare", Integer.valueOf(Compare.EQUAL.getCode()))));
            String swt = parse.getString("swt");
            if (BasicUtil.isNotEmpty((Object)swt)) {
                try {
                    parser.setSwt(Compare.EMPTY_VALUE_SWITCH.valueOf((String)swt));
                }
                catch (Exception ignored) {
                    // empty catch block
                }
            }
        }
        return parser;
    }

    public String json() {
        return this.json(false);
    }

    public String json(boolean empty) {
        return this.map(empty).json();
    }

    public List<ParseResult> getDefs() {
        return this.defs;
    }

    public void addDef(ParseResult def) {
        this.defs.add(def);
    }

    public ParseResult getOr() {
        return this.or;
    }

    public void setOr(ParseResult or) {
        this.or = or;
    }

    public Compare getCompare() {
        return this.compare;
    }

    public void setCompare(Compare compare) {
        this.compare = compare;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        if (null != key) {
            key = key.trim();
        }
        this.key = key;
    }

    public String getVar() {
        return this.var;
    }

    public void setVar(String var) {
        if (null != var) {
            var = var.trim();
        }
        this.var = var;
    }

    public String getClazz() {
        return this.clazz;
    }

    public void setClazz(String clazz) {
        this.clazz = clazz;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public int getParamFetchType() {
        return this.paramFetchType;
    }

    public void setParamFetchType(int paramFetchType) {
        this.paramFetchType = paramFetchType;
    }

    public boolean isKeyEncrypt() {
        return this.isKeyEncrypt;
    }

    public void setKeyEncrypt(boolean isKeyEncrypt) {
        this.isKeyEncrypt = isKeyEncrypt;
    }

    public boolean isValueEncrypt() {
        return this.isValueEncrypt;
    }

    public void setValueEncrypt(boolean isValueEncrypt) {
        this.isValueEncrypt = isValueEncrypt;
    }

    public boolean isSetEncrypt() {
        return this.setEncrypt;
    }

    public void setSetEncrypt(boolean setEncrypt) {
        this.setEncrypt = setEncrypt;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        if (null != prefix) {
            if (prefix.startsWith("++")) {
                this.setSwt(Compare.EMPTY_VALUE_SWITCH.BREAK);
            } else if (prefix.startsWith("+")) {
                this.setSwt(Compare.EMPTY_VALUE_SWITCH.NULL);
            }
            prefix = prefix.replace("+", "");
        }
        this.prefix = prefix;
    }

    public Condition.JOIN getJoin() {
        return this.join;
    }

    public void setJoin(Condition.JOIN join) {
        this.join = join;
    }

    public ParseResult addArg(String arg) {
        this.args.add(arg);
        return this;
    }

    public List<String> getArgs() {
        return this.args;
    }

    public void setArgs(List<String> args) {
        this.args = args;
    }

    public Compare.EMPTY_VALUE_SWITCH getSwt() {
        return this.swt;
    }

    public void setSwt(Compare.EMPTY_VALUE_SWITCH swt) {
        this.swt = swt;
    }

    public boolean isRequired() {
        return this.swt == Compare.EMPTY_VALUE_SWITCH.NULL || this.swt == Compare.EMPTY_VALUE_SWITCH.SRC;
    }

    public String datatype() {
        return this.datatype;
    }

    public void datatype(String datatype) {
        this.datatype = datatype;
    }
}

