/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.proxy;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.anyline.cache.CacheProvider;
import org.anyline.data.param.ConfigStore;
import org.anyline.data.runtime.DataRuntime;
import org.anyline.metadata.Catalog;
import org.anyline.metadata.Column;
import org.anyline.metadata.MasterTable;
import org.anyline.metadata.Schema;
import org.anyline.metadata.Table;
import org.anyline.metadata.Tag;
import org.anyline.metadata.View;
import org.anyline.metadata.graph.EdgeTable;
import org.anyline.metadata.graph.VertexTable;
import org.anyline.util.encrypt.MD5Util;

public class CacheProxy {
    public static CacheProvider provider;
    private static Map<String, Object> caches;
    private static Map<String, String> names;

    public static void init(CacheProvider provider) {
        CacheProxy.provider = provider;
    }

    public static String key(DataRuntime runtime, String flag, boolean greedy, Catalog catalog, Schema schema, String pattern, int types, ConfigStore configs) {
        StringBuilder key = new StringBuilder();
        key.append(runtime.datasource()).append("_").append(flag).append("_").append(greedy).append("_");
        if (null != catalog) {
            key.append(catalog.getName());
        }
        key.append("_");
        if (null != schema) {
            key.append(schema.getName());
        }
        key.append("_").append(pattern).append("_").append(types);
        if (null != configs) {
            key.append(MD5Util.crypto((String)configs.json()));
        }
        return key.toString().toUpperCase();
    }

    public static String key(DataRuntime runtime, String flag, boolean greedy, Table table) {
        StringBuilder key = new StringBuilder();
        key.append(runtime.datasource()).append("_").append(flag).append("_").append(greedy).append("_");
        String name = table.getName();
        String catalog = table.getCatalogName();
        String schema = table.getSchemaName();
        if (null != catalog) {
            key.append(catalog);
        }
        key.append("_");
        if (null != schema) {
            key.append(schema);
        }
        key.append("_").append(name);
        return key.toString().toUpperCase();
    }

    public static String key(DataRuntime runtime, String flag, boolean greedy, Catalog catalog, Schema schema, String pattern) {
        StringBuilder key = new StringBuilder();
        key.append(runtime.datasource()).append("_").append(flag).append("_").append(greedy).append("_");
        if (null != catalog) {
            key.append(catalog.getName());
        }
        key.append("_");
        if (null != schema) {
            key.append(schema.getName());
        }
        key.append("_").append(pattern);
        return key.toString().toUpperCase();
    }

    public static String name(String key) {
        return names.get(key.toUpperCase());
    }

    public static void name(String key, String origin) {
        names.put(key.toUpperCase(), origin);
    }

    public static <T extends Table> List<T> tables(String cache) {
        List tables = (List)caches.get(cache);
        return tables;
    }

    public static <T extends MasterTable> List<T> masterTables(String cache) {
        List tables = (List)caches.get(cache);
        return tables;
    }

    public static <T extends EdgeTable> List<T> edgeTables(String cache) {
        List tables = (List)caches.get(cache);
        return tables;
    }

    public static <T extends VertexTable> List<T> vertexTables(String cache) {
        List tables = (List)caches.get(cache);
        return tables;
    }

    public static <T extends Table> void tables(String cache, List<T> tables) {
        caches.put(cache, tables);
    }

    public static <T extends View> List<T> views(String cache) {
        List view = (List)caches.get(cache);
        return view;
    }

    public static <T extends View> void views(String cache, List<T> view) {
        caches.put(cache, view);
    }

    public static void cache(String cache, Object value) {
        caches.put(cache, value);
    }

    public static <T extends Column> LinkedHashMap<String, T> columns(String key) {
        return (LinkedHashMap)caches.get(key);
    }

    public static <T extends Tag> LinkedHashMap<String, T> tags(String key) {
        return (LinkedHashMap)caches.get(key);
    }

    public static void clear() {
        caches.clear();
        names.clear();
    }

    static {
        caches = new HashMap<String, Object>();
        names = new HashMap<String, String>();
    }
}

