/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.adapter;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.anyline.data.adapter.DriverAdapter;
import org.anyline.data.runtime.DataRuntime;
import org.anyline.exception.NotFoundAdapterException;
import org.anyline.metadata.type.DatabaseType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DriverAdapterHolder {
    private static final Logger log = LoggerFactory.getLogger(DriverAdapterHolder.class);
    public static LinkedHashMap<DatabaseType, DriverAdapter> user_adapters = new LinkedHashMap();
    private static HashSet<DriverAdapter> adapters = new HashSet();
    private static HashSet<DatabaseType> supports = new HashSet();
    private static List<DriverAdapterHolder> utils = new ArrayList<DriverAdapterHolder>();
    private static DriverAdapter defaultAdapter = null;

    public static void reg(DatabaseType type, DriverAdapter adapter) {
        user_adapters.put(type, adapter);
    }

    public static DriverAdapter getAdapter(DatabaseType type) {
        List<DriverAdapter> list;
        DriverAdapter adapter = user_adapters.get(type);
        if (null == adapter && !(list = DriverAdapterHolder.getAdapters(type)).isEmpty()) {
            adapter = list.get(0);
        }
        return adapter;
    }

    public static List<DriverAdapter> getAdapters(DatabaseType type) {
        ArrayList<DriverAdapter> list = new ArrayList<DriverAdapter>();
        for (DriverAdapter adapter : adapters) {
            if (adapter.type() != type) continue;
            list.add(adapter);
        }
        return list;
    }

    public static List<DriverAdapter> getAdapters() {
        ArrayList<DriverAdapter> list = new ArrayList<DriverAdapter>();
        list.addAll(adapters);
        return list;
    }

    public static void setAdapters(Map<String, DriverAdapter> map) {
        if (null != map) {
            for (DriverAdapter adapter : map.values()) {
                adapters.add(adapter);
            }
        }
    }

    public static boolean support(DatabaseType type) {
        return supports.contains(type);
    }

    public static DriverAdapter getAdapter(String datasource, DataRuntime runtime) {
        DriverAdapter adapter;
        block11: {
            if (null != defaultAdapter) {
                return defaultAdapter;
            }
            if (adapters.size() == 1) {
                defaultAdapter = adapters.iterator().next();
                return defaultAdapter;
            }
            if (adapters.size() == 2) {
                boolean common = false;
                for (DriverAdapter adapter2 : adapters) {
                    if (!adapter2.getClass().getName().toLowerCase().contains("common")) continue;
                    common = true;
                }
                if (common) {
                    for (DriverAdapter adapter2 : adapters) {
                        if (adapter2.getClass().getName().toLowerCase().contains("common")) continue;
                        defaultAdapter = adapter2;
                        return defaultAdapter;
                    }
                }
            }
            adapter = null;
            try {
                for (DriverAdapter item : adapters) {
                    if (!item.match(runtime, false)) continue;
                    adapter = item;
                    break;
                }
                if (null != adapter) break block11;
                for (DriverAdapter item : adapters) {
                    if (!item.match(runtime, true)) continue;
                    adapter = item;
                    break;
                }
            }
            catch (Exception e) {
                log.error("\u68c0\u6d4b\u9002\u914d\u5668 \u5f02\u5e38:", (Throwable)e);
            }
        }
        if (null == adapter) {
            log.error("[\u68c0\u6d4b\u6570\u636e\u5e93\u9002\u914d\u5668][\u68c0\u6d4b\u5931\u8d25][\u53ef\u7528\u9002\u914d\u5668\u6570\u91cf:{}][\u68c0\u6d4b\u5176\u4ed6\u53ef\u7528\u7684\u9002\u914d\u5668]", (Object)adapters.size());
            throw new NotFoundAdapterException("\u68c0\u6d4b\u6570\u636e\u5e93\u9002\u914d\u5668\u5931\u8d25");
        }
        log.info("[\u68c0\u6d4b\u6570\u636e\u5e93\u9002\u914d\u5668][\u6570\u636e\u6e90:{}][\u7279\u5f81:{}][\u9002\u914d\u7ed3\u679c:{}]", new Object[]{datasource, runtime.getFeature(), adapter});
        return adapter;
    }
}

