/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.proxy;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.anyline.dao.init.springjdbc.DefaultDao;
import org.anyline.data.adapter.DriverAdapter;
import org.anyline.data.handler.EntityHandler;
import org.anyline.data.handler.StreamHandler;
import org.anyline.data.param.ConfigStore;
import org.anyline.data.param.init.DefaultConfigStore;
import org.anyline.data.prepare.RunPrepare;
import org.anyline.data.runtime.DataRuntime;
import org.anyline.entity.DataRow;
import org.anyline.entity.DataSet;
import org.anyline.entity.EntitySet;
import org.anyline.entity.PageNavi;
import org.anyline.metadata.Catalog;
import org.anyline.metadata.Column;
import org.anyline.metadata.Constraint;
import org.anyline.metadata.Database;
import org.anyline.metadata.Index;
import org.anyline.metadata.MasterTable;
import org.anyline.metadata.PartitionTable;
import org.anyline.metadata.Procedure;
import org.anyline.metadata.Schema;
import org.anyline.metadata.Table;
import org.anyline.metadata.Tag;
import org.anyline.proxy.DatasourceHolderProxy;
import org.anyline.service.AnylineService;
import org.anyline.service.init.DefaultService;
import org.anyline.util.SpringContextUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="anyline.service.proxy")
public class ServiceProxy {
    private static Logger log = LoggerFactory.getLogger(ServiceProxy.class);
    private static AnylineService service;
    private static AnylineService.DDLService ddl;
    private static AnylineService.MetaDataService metadata;

    @Autowired(required=false)
    @Qualifier(value="anyline.service")
    public void init(AnylineService service) {
        ServiceProxy.service = service;
        ddl = service.ddl();
        metadata = service.metadata();
    }

    public static AnylineService service() {
        return ServiceProxy.service(null);
    }

    public static AnylineService service(String key) {
        if (null == key) {
            key = "default";
        }
        AnylineService service = (AnylineService)SpringContextUtil.getBean((String)("anyline.service." + key));
        return service;
    }

    public static AnylineService temporary(Object datasource, String database, DriverAdapter adapter) throws Exception {
        DataRuntime runtime = DatasourceHolderProxy.temporary(datasource, database, adapter);
        DefaultDao dao = new DefaultDao();
        dao.setRuntime(runtime);
        DefaultService service = new DefaultService();
        service.setDao(dao);
        return service;
    }

    public static AnylineService temporary(Object datasource) throws Exception {
        return ServiceProxy.temporary(datasource, null, null);
    }

    public static AnylineService temporary(Object datasource, String database) throws Exception {
        return ServiceProxy.temporary(datasource, database, null);
    }

    public static ConfigStore condition() {
        return new DefaultConfigStore(new String[0]);
    }

    public static long insert(int batch, String dest, Object data, List<String> columns) {
        return service.insert(batch, dest, data, columns);
    }

    public static long insert(int batch, String dest, Object data, String ... columns) {
        return service.insert(batch, dest, data, columns);
    }

    public static long insert(int batch, Object data, String ... columns) {
        return service.insert(batch, data, columns);
    }

    public static long insert(String dest, Object data, List<String> columns) {
        return service.insert(dest, data, columns);
    }

    public static long insert(String dest, Object data, String ... columns) {
        return service.insert(dest, data, columns);
    }

    public static long insert(Object data, String ... columns) {
        return service.insert(data, columns);
    }

    public static long insert(int batch, String dest, Object data, ConfigStore configs, List<String> columns) {
        return service.insert(batch, dest, data, configs, columns);
    }

    public static long insert(int batch, String dest, Object data, ConfigStore configs, String ... columns) {
        return service.insert(batch, dest, data, configs, columns);
    }

    public static long insert(int batch, Object data, ConfigStore configs, String ... columns) {
        return service.insert(batch, data, configs, columns);
    }

    public static long insert(String dest, Object data, ConfigStore configs, List<String> columns) {
        return service.insert(dest, data, configs, columns);
    }

    public static long insert(String dest, Object data, ConfigStore configs, String ... columns) {
        return service.insert(dest, data, configs, columns);
    }

    public static long insert(Object data, ConfigStore configs, String ... columns) {
        return service.insert(data, configs, columns);
    }

    public static long update(int batch, String dest, Object data, ConfigStore configs, List<String> columns) {
        return service.update(batch, dest, data, configs, columns);
    }

    public static long update(int batch, String dest, Object data, String ... columns) {
        return service.update(batch, dest, data, columns);
    }

    public static long update(int batch, String dest, Object data, ConfigStore configs, String ... columns) {
        return service.update(batch, dest, data, configs, columns);
    }

    public static long update(int batch, Object data, String ... columns) {
        return service.update(batch, data, columns);
    }

    public static long update(int batch, Object data, ConfigStore configs, String ... columns) {
        return service.update(batch, data, configs, columns);
    }

    public static long update(String dest, Object data, String ... columns) {
        return service.update(dest, data, columns);
    }

    public static long update(String dest, Object data, ConfigStore configs, String ... columns) {
        return service.update(dest, data, configs, columns);
    }

    public static long update(Object data, String ... columns) {
        return service.update(data, columns);
    }

    public static long update(Object data, ConfigStore configs, String ... columns) {
        return service.update(data, configs, columns);
    }

    public static long save(int batch, String dest, Object data, List<String> columns) {
        return service.save(batch, dest, data, columns);
    }

    public static long save(int batch, String dest, Object data, String ... columns) {
        return service.save(batch, dest, data, columns);
    }

    public static long save(int batch, Object data, String ... columns) {
        return service.save(batch, data, columns);
    }

    public static long save(String dest, Object data, String ... columns) {
        return service.save(dest, data, columns);
    }

    public static long save(Object data, String ... columns) {
        return service.save(data, columns);
    }

    public static long save(int batch, String dest, Object data, ConfigStore configs, List<String> columns) {
        return service.save(batch, dest, data, configs, columns);
    }

    public static long save(int batch, String dest, Object data, ConfigStore configs, String ... columns) {
        return service.save(batch, dest, data, configs, columns);
    }

    public static long save(int batch, Object data, ConfigStore configs, String ... columns) {
        return service.save(batch, data, configs, columns);
    }

    public static long save(int batch, String dest, ConfigStore configs, Object data, String ... columns) {
        return service.save(batch, dest, data, configs, columns);
    }

    public static long save(String dest, Object data, ConfigStore configs, String ... columns) {
        return service.save(dest, data, configs, columns);
    }

    public static long save(Object data, ConfigStore configs, String ... columns) {
        return service.save(data, configs, columns);
    }

    public static long save(String dest, ConfigStore configs, Object data, String ... columns) {
        return service.save(dest, data, configs, columns);
    }

    public static DataSet querys(String src, ConfigStore configs, Object obj, String ... conditions) {
        return service.querys(src, configs, obj, conditions);
    }

    public static DataSet querys(String src, Object obj, String ... conditions) {
        return service.querys(src, obj, conditions);
    }

    public static void querys(String src, StreamHandler handler, Object obj, String ... conditions) {
        service.querys(src, handler, obj, conditions);
    }

    public static DataSet querys(String src, PageNavi navi, Object obj, String ... conditions) {
        return service.querys(src, navi, obj, conditions);
    }

    public static DataSet querys(String src, long first, long last, Object obj, String ... conditions) {
        return service.querys(src, first, last, obj, conditions);
    }

    public static DataRow query(String src, ConfigStore configs, Object obj, String ... conditions) {
        return service.query(src, configs, obj, conditions);
    }

    public static DataRow query(String src, Object obj, String ... conditions) {
        return service.query(src, obj, conditions);
    }

    public static DataSet querys(String src, ConfigStore configs, String ... conditions) {
        return service.querys(src, configs, conditions);
    }

    public static DataSet querys(String src, String ... conditions) {
        return service.querys(src, conditions);
    }

    public static void querys(String src, StreamHandler handler, String ... conditions) {
        service.querys(src, handler, conditions);
    }

    public static DataSet querys(String src, PageNavi navi, String ... conditions) {
        return service.querys(src, navi, conditions);
    }

    public static DataSet querys(String src, long first, long last, String ... conditions) {
        return service.querys(src, first, last, conditions);
    }

    public static DataRow query(String src, ConfigStore configs, String ... conditions) {
        return service.query(src, configs, conditions);
    }

    public static DataRow query(String src, String ... conditions) {
        return service.query(src, conditions);
    }

    public static <T> EntitySet<T> selects(String src, Class<T> clazz, ConfigStore configs, T entity, String ... conditions) {
        return service.selects(src, clazz, configs, entity, conditions);
    }

    public static <T> EntitySet<T> selects(String src, Class<T> clazz, PageNavi navi, T entity, String ... conditions) {
        return service.selects(src, clazz, navi, entity, conditions);
    }

    public static <T> EntitySet<T> selects(String src, Class<T> clazz, T entity, String ... conditions) {
        return service.selects(src, clazz, entity, conditions);
    }

    public static <T> EntitySet<T> selects(String src, Class<T> clazz, EntityHandler<T> handler, T entity, String ... conditions) {
        return service.selects(src, clazz, handler, entity, conditions);
    }

    public static <T> EntitySet<T> selects(String src, Class<T> clazz, long first, long last, T entity, String ... conditions) {
        return service.selects(src, clazz, first, last, entity, conditions);
    }

    public static <T> T select(String src, Class<T> clazz, ConfigStore configs, T entity, String ... conditions) {
        return service.select(src, clazz, configs, entity, conditions);
    }

    public static <T> T select(String src, Class<T> clazz, T entity, String ... conditions) {
        return (T)service.selects(src, clazz, entity, conditions);
    }

    public static <T> T select(String src, Class<T> clazz, EntityHandler<T> handler, T entity, String ... conditions) {
        return (T)service.selects(src, clazz, handler, entity, conditions);
    }

    public static <T> EntitySet<T> selects(String src, Class<T> clazz, ConfigStore configs, String ... conditions) {
        return service.selects(src, clazz, configs, conditions);
    }

    public static <T> EntitySet<T> selects(String src, Class<T> clazz, PageNavi navi, String ... conditions) {
        return service.selects(src, clazz, navi, conditions);
    }

    public static <T> EntitySet<T> selects(String src, Class<T> clazz, String ... conditions) {
        return service.selects(src, clazz, conditions);
    }

    public static <T> EntitySet<T> selects(String src, Class<T> clazz, EntityHandler<T> handler, String ... conditions) {
        return service.selects(src, clazz, handler, conditions);
    }

    public static <T> EntitySet<T> selects(String src, Class<T> clazz, long first, long last, String ... conditions) {
        return service.selects(src, clazz, first, last, conditions);
    }

    public static <T> T select(String src, Class<T> clazz, ConfigStore configs, String ... conditions) {
        return service.select(src, clazz, configs, conditions);
    }

    public static <T> T select(String src, Class<T> clazz, String ... conditions) {
        return service.select(src, clazz, conditions);
    }

    public static <T> EntitySet<T> selects(Class<T> clazz, ConfigStore configs, T entity, String ... conditions) {
        return service.selects(clazz, configs, entity, conditions);
    }

    public static <T> EntitySet<T> selects(Class<T> clazz, PageNavi navi, T entity, String ... conditions) {
        return service.selects(clazz, navi, entity, conditions);
    }

    public static <T> EntitySet<T> selects(Class<T> clazz, T entity, String ... conditions) {
        return service.selects(clazz, entity, conditions);
    }

    public static <T> EntitySet<T> selects(Class<T> clazz, EntityHandler<T> handler, T entity, String ... conditions) {
        return service.selects(clazz, handler, entity, conditions);
    }

    public static <T> EntitySet<T> selects(Class<T> clazz, long first, long last, T entity, String ... conditions) {
        return service.selects(clazz, first, last, entity, conditions);
    }

    public static <T> T select(Class<T> clazz, ConfigStore configs, T entity, String ... conditions) {
        return service.select(clazz, configs, entity, conditions);
    }

    public static <T> T select(Class<T> clazz, T entity, String ... conditions) {
        return service.select(clazz, entity, conditions);
    }

    public static <T> EntitySet<T> selects(Class<T> clazz, ConfigStore configs, String ... conditions) {
        return service.selects(clazz, configs, conditions);
    }

    public static <T> EntitySet<T> selects(Class<T> clazz, PageNavi navi, String ... conditions) {
        return service.selects(clazz, navi, conditions);
    }

    public static <T> EntitySet<T> selects(Class<T> clazz, String ... conditions) {
        return service.selects(clazz, conditions);
    }

    public static <T> EntitySet<T> selects(Class<T> clazz, EntityHandler<T> handler, String ... conditions) {
        return service.selects(clazz, handler, conditions);
    }

    public static <T> EntitySet<T> selects(Class<T> clazz, long first, long last, String ... conditions) {
        return service.selects(clazz, first, last, conditions);
    }

    public static <T> T select(Class<T> clazz, ConfigStore configs, String ... conditions) {
        return service.select(clazz, configs, conditions);
    }

    public static <T> T select(Class<T> clazz, String ... conditions) {
        return service.select(clazz, conditions);
    }

    public static List<Map<String, Object>> maps(String src, ConfigStore configs, Object obj, String ... conditions) {
        return service.maps(src, configs, conditions);
    }

    public static List<Map<String, Object>> maps(String src, Object obj, String ... conditions) {
        return service.maps(src, obj, conditions);
    }

    public static void maps(String src, StreamHandler handler, Object obj, String ... conditions) {
        service.maps(src, handler, obj, conditions);
    }

    public static List<Map<String, Object>> maps(String src, long first, long last, Object obj, String ... conditions) {
        return service.maps(src, first, last, obj, conditions);
    }

    public static List<Map<String, Object>> maps(String src, ConfigStore configs, String ... conditions) {
        return service.maps(src, configs, conditions);
    }

    public static List<Map<String, Object>> maps(String src, String ... conditions) {
        return service.maps(src, conditions);
    }

    public static void maps(String src, StreamHandler handler, String ... conditions) {
        service.maps(src, handler, conditions);
    }

    public static List<Map<String, Object>> maps(String src, long first, long last, String ... conditions) {
        return service.maps(src, first, last, conditions);
    }

    public static List<String> column2param(String table) {
        return service.column2param(table);
    }

    public static DataSet caches(String cache, String src, ConfigStore configs, Object obj, String ... conditions) {
        return ServiceProxy.caches(cache, src, configs, obj, conditions);
    }

    public static DataSet caches(String cache, String src, Object obj, String ... conditions) {
        return service.caches(cache, src, obj, conditions);
    }

    public static DataSet caches(String cache, String src, long first, long last, Object obj, String ... conditions) {
        return service.caches(cache, src, first, last, obj, conditions);
    }

    public static DataRow cache(String cache, String src, ConfigStore configs, Object obj, String ... conditions) {
        return service.cache(cache, src, configs, obj, conditions);
    }

    public static DataRow cache(String cache, String src, Object obj, String ... conditions) {
        return service.cache(cache, src, obj, conditions);
    }

    public static DataSet caches(String cache, String src, ConfigStore configs, String ... conditions) {
        return service.caches(cache, src, configs, conditions);
    }

    public static DataSet caches(String cache, String src, String ... conditions) {
        return service.caches(cache, src, conditions);
    }

    public static DataSet caches(String cache, String src, long first, long last, String ... conditions) {
        return service.caches(cache, src, first, last, conditions);
    }

    public static DataRow cache(String cache, String src, ConfigStore configs, String ... conditions) {
        return service.cache(cache, src, configs, conditions);
    }

    public static DataRow cache(String cache, String src, String ... conditions) {
        return service.cache(cache, src, conditions);
    }

    public static DataSet querys(RunPrepare prepare, ConfigStore configs, Object obj, String ... conditions) {
        return service.querys(prepare, configs, obj, conditions);
    }

    public static DataSet querys(RunPrepare prepare, Object obj, String ... conditions) {
        return service.querys(prepare, obj, conditions);
    }

    public static void querys(RunPrepare prepare, StreamHandler handler, Object obj, String ... conditions) {
        service.querys(prepare, handler, obj, conditions);
    }

    public static DataSet querys(RunPrepare prepare, long first, long last, Object obj, String ... conditions) {
        return service.querys(prepare, first, last, obj, conditions);
    }

    public static DataRow query(RunPrepare prepare, ConfigStore configs, Object obj, String ... conditions) {
        return service.query(prepare, configs, obj, conditions);
    }

    public static DataRow query(RunPrepare prepare, Object obj, String ... conditions) {
        return service.query(prepare, obj, conditions);
    }

    public static DataSet querys(RunPrepare prepare, ConfigStore configs, String ... conditions) {
        return service.querys(prepare, configs, conditions);
    }

    public static DataSet querys(RunPrepare prepare, String ... conditions) {
        return service.querys(prepare, conditions);
    }

    public static void querys(RunPrepare prepare, StreamHandler handler, String ... conditions) {
        service.querys(prepare, handler, conditions);
    }

    public static DataSet querys(RunPrepare prepare, long first, long last, String ... conditions) {
        return service.querys(prepare, first, last, conditions);
    }

    public static DataRow query(RunPrepare prepare, ConfigStore configs, String ... conditions) {
        return service.query(prepare, configs, conditions);
    }

    public static DataRow query(RunPrepare prepare, String ... conditions) {
        return service.query(prepare, conditions);
    }

    public static void query(RunPrepare prepare, StreamHandler handler, String ... conditions) {
        service.query(prepare, (Object)handler, conditions);
    }

    public static DataSet caches(String cache, RunPrepare prepare, ConfigStore configs, Object obj, String ... conditions) {
        return service.caches(cache, prepare, configs, obj, conditions);
    }

    public static DataSet caches(String cache, RunPrepare prepare, Object obj, String ... conditions) {
        return service.caches(cache, prepare, obj, conditions);
    }

    public static DataSet caches(String cache, RunPrepare prepare, long first, long last, Object obj, String ... conditions) {
        return service.caches(cache, prepare, first, last, obj, conditions);
    }

    public static DataRow cache(String cache, RunPrepare prepare, ConfigStore configs, Object obj, String ... conditions) {
        return service.cache(cache, prepare, configs, obj, conditions);
    }

    public static DataRow cache(String cache, RunPrepare prepare, Object obj, String ... conditions) {
        return service.cache(cache, prepare, obj, conditions);
    }

    public static DataSet caches(String cache, RunPrepare prepare, ConfigStore configs, String ... conditions) {
        return service.caches(cache, prepare, configs, conditions);
    }

    public static DataSet caches(String cache, RunPrepare prepare, String ... conditions) {
        return service.caches(cache, prepare, conditions);
    }

    public static DataSet caches(String cache, RunPrepare prepare, long first, long last, String ... conditions) {
        return service.caches(cache, prepare, first, last, conditions);
    }

    public static DataRow cache(String cache, RunPrepare prepare, ConfigStore configs, String ... conditions) {
        return service.cache(cache, prepare, configs, conditions);
    }

    public static DataRow cache(String cache, RunPrepare prepare, String ... conditions) {
        return service.cache(cache, prepare, conditions);
    }

    public static boolean removeCache(String channel, String src, ConfigStore configs, String ... conditions) {
        return service.removeCache(channel, src, configs, conditions);
    }

    public static boolean removeCache(String channel, String src, String ... conditions) {
        return service.removeCache(channel, src, conditions);
    }

    public static boolean removeCache(String channel, String src, long first, long last, String ... conditions) {
        return service.removeCache(channel, src, first, last, conditions);
    }

    public static boolean clearCache(String channel) {
        return service.clearCache(channel);
    }

    public static boolean exists(String src, ConfigStore configs, Object obj, String ... conditions) {
        return service.exists(src, configs, obj, conditions);
    }

    public static boolean exists(String src, Object obj, String ... conditions) {
        return service.exists(src, obj, conditions);
    }

    public static boolean exists(String src, ConfigStore configs, String ... conditions) {
        return service.exists(src, configs, conditions);
    }

    public static boolean exists(String src, String ... conditions) {
        return service.exists(src, conditions);
    }

    public static boolean exists(String src, DataRow row) {
        return service.exists(src, row);
    }

    public static boolean exists(DataRow row) {
        return service.exists(row);
    }

    public static long count(String src, ConfigStore configs, Object obj, String ... conditions) {
        return service.count(src, configs, obj, conditions);
    }

    public static long count(String src, Object obj, String ... conditions) {
        return service.count(src, obj, conditions);
    }

    public static long count(String src, ConfigStore configs, String ... conditions) {
        return service.count(src, configs, conditions);
    }

    public static long count(String src, String ... conditions) {
        return service.count(src, conditions);
    }

    public static long execute(String src, ConfigStore configs, String ... conditions) {
        return service.execute(src, configs, conditions);
    }

    public static long execute(String src, String ... conditions) {
        return service.execute(src, conditions);
    }

    public static boolean executeProcedure(String procedure, String ... inputs) {
        return service.executeProcedure(procedure, inputs);
    }

    public static boolean execute(Procedure procedure, String ... inputs) {
        return service.execute(procedure, inputs);
    }

    public static DataSet querysProcedure(String procedure, long first, long last, String ... inputs) {
        return service.querysProcedure(procedure, first, last, inputs);
    }

    public static DataSet querysProcedure(String procedure, PageNavi navi, String ... inputs) {
        return service.querysProcedure(procedure, navi, inputs);
    }

    public static DataSet querysProcedure(String procedure, String ... inputs) {
        return service.querysProcedure(procedure, inputs);
    }

    public static DataSet querys(Procedure procedure, long first, long last, String ... inputs) {
        return service.querys(procedure, first, last, inputs);
    }

    public static DataSet querys(Procedure procedure, PageNavi navi, String ... inputs) {
        return service.querys(procedure, navi, inputs);
    }

    public static DataRow queryProcedure(String procedure, String ... inputs) {
        return service.queryProcedure(procedure, inputs);
    }

    public static DataRow query(Procedure procedure, String ... inputs) {
        return service.query(procedure, inputs);
    }

    public static long delete(String table, ConfigStore configs, String ... conditions) {
        return service.delete(table, configs, conditions);
    }

    public static long delete(String dest, DataSet set, String ... columns) {
        return service.delete(dest, set, columns);
    }

    public static long delete(DataSet set, String ... columns) {
        return service.delete(set, columns);
    }

    public static long delete(String dest, DataRow row, String ... columns) {
        return service.delete(dest, row, columns);
    }

    public static long delete(Object obj, String ... columns) {
        return service.delete(obj, columns);
    }

    public static long delete(String table, String ... kvs) {
        return service.delete(table, kvs);
    }

    public static long deletes(String table, String key, Collection<Object> values) {
        return service.deletes(table, key, values);
    }

    public static long deletes(int batch, String table, String key, Collection<Object> values) {
        return service.deletes(batch, table, key, values);
    }

    public static <T> long deletes(String table, String key, T ... values) {
        return service.deletes(table, key, values);
    }

    public static <T> long deletes(int batch, String table, String key, T ... values) {
        return service.deletes(batch, table, key, values);
    }

    public static List<String> tables(Catalog catalog, Schema schema, String name, String types) {
        return service.tables(catalog, schema, name, types);
    }

    public static List<String> tables(Schema schema, String name, String types) {
        return service.tables(schema, name, types);
    }

    public static List<String> tables(String name, String types) {
        return service.tables(name, types);
    }

    public static List<String> tables(String types) {
        return service.tables(types);
    }

    public static List<String> tables() {
        return service.tables();
    }

    public static List<String> mtables(Catalog catalog, Schema schema, String name, String types) {
        return service.mtables(catalog, schema, name, types);
    }

    public static List<String> mtables(Schema schema, String name, String types) {
        return service.mtables(schema, name, types);
    }

    public static List<String> mtables(String name, String types) {
        return service.mtables(name, types);
    }

    public static List<String> mtables(String types) {
        return service.mtables(types);
    }

    public static List<String> mtables() {
        return service.mtables();
    }

    public static List<String> columns(Table table) {
        return service.columns(table);
    }

    public static List<String> columns(String table) {
        return service.columns(table);
    }

    public static List<String> columns(Catalog catalog, Schema schema, String table) {
        return service.columns(catalog, schema, table);
    }

    public static List<String> tags(Table table) {
        return service.tags(table);
    }

    public static List<String> tags(String table) {
        return service.tags(table);
    }

    public static List<String> tags(Catalog catalog, Schema schema, String table) {
        return service.tags(catalog, schema, table);
    }

    public static AnylineService.DDLService ddl() {
        return service.ddl();
    }

    public static AnylineService.MetaDataService metadata() {
        return service.metadata();
    }

    public static interface DDLService {
        public static boolean save(Table table) throws Exception {
            return service.ddl().save(table);
        }

        public static boolean create(Table table) throws Exception {
            return service.ddl().create(table);
        }

        public static boolean alter(Table table) throws Exception {
            return service.ddl().alter(table);
        }

        public static boolean drop(Table table) throws Exception {
            return service.ddl().drop(table);
        }

        public static boolean save(MasterTable table) throws Exception {
            return service.ddl().save(table);
        }

        public static boolean create(MasterTable table) throws Exception {
            return service.ddl().create(table);
        }

        public static boolean alter(MasterTable table) throws Exception {
            return service.ddl().alter(table);
        }

        public static boolean drop(MasterTable table) throws Exception {
            return service.ddl().drop(table);
        }

        public static boolean save(PartitionTable table) throws Exception {
            return service.ddl().save(table);
        }

        public static boolean create(PartitionTable table) throws Exception {
            return service.ddl().create(table);
        }

        public static boolean alter(PartitionTable table) throws Exception {
            return service.ddl().alter(table);
        }

        public static boolean drop(PartitionTable table) throws Exception {
            return service.ddl().drop(table);
        }

        public static boolean save(Column column) throws Exception {
            return service.ddl().save(column);
        }

        public static boolean add(Column column) throws Exception {
            return service.ddl().add(column);
        }

        public static boolean alter(Column column) throws Exception {
            return service.ddl().alter(column);
        }

        public static boolean drop(Column column) throws Exception {
            return service.ddl().drop(column);
        }

        public static boolean save(Tag tag) throws Exception {
            return service.ddl().save(tag);
        }

        public static boolean add(Tag tag) throws Exception {
            return service.ddl().add(tag);
        }

        public static boolean alter(Tag tag) throws Exception {
            return service.ddl().alter(tag);
        }

        public static boolean drop(Tag tag) throws Exception {
            return service.ddl().drop(tag);
        }

        public static boolean add(Index index) throws Exception {
            return service.ddl().add(index);
        }

        public static boolean alter(Index index) throws Exception {
            return service.ddl().alter(index);
        }

        public static boolean drop(Index index) throws Exception {
            return service.ddl().drop(index);
        }

        public static boolean add(Constraint constraint) throws Exception {
            return service.ddl().add(constraint);
        }

        public static boolean alter(Constraint constraint) throws Exception {
            return service.ddl().alter(constraint);
        }

        public static boolean drop(Constraint constraint) throws Exception {
            return service.ddl().drop(constraint);
        }
    }

    public static interface MetaDataService {
        public static LinkedHashMap<String, Database> databases() {
            return service.metadata().databases();
        }

        public static Database database(String name) {
            return service.metadata().database(name);
        }

        public static boolean exists(Table table) {
            return service.metadata().exists(table);
        }

        public static LinkedHashMap<String, Table> tables(Catalog catalog, Schema schema, String name, String types) {
            return service.metadata().tables(catalog, schema, name, types);
        }

        public static LinkedHashMap<String, Table> tables(Schema schema, String name, String types) {
            return service.metadata().tables(schema, name, types);
        }

        public static LinkedHashMap<String, Table> tables(String name, String types) {
            return service.metadata().tables(name, types);
        }

        public static LinkedHashMap<String, Table> tables(String types) {
            return service.metadata().tables(types);
        }

        public static LinkedHashMap<String, Table> tables() {
            return service.metadata().tables();
        }

        public static Table table(Catalog catalog, Schema schema, String name) {
            return service.metadata().table(catalog, schema, name);
        }

        public static Table table(Schema schema, String name) {
            return service.metadata().table(schema, name);
        }

        public static Table table(String name) {
            return service.metadata().table(name);
        }

        public static boolean exists(MasterTable table) {
            return service.metadata().exists(table);
        }

        public static LinkedHashMap<String, MasterTable> mtables(Catalog catalog, Schema schema, String name, String types) {
            return service.metadata().mtables(catalog, schema, name, types);
        }

        public static LinkedHashMap<String, MasterTable> mtables(Schema schema, String name, String types) {
            return service.metadata().mtables(schema, name, types);
        }

        public static LinkedHashMap<String, MasterTable> mtables(String name, String types) {
            return service.metadata().mtables(name, types);
        }

        public static LinkedHashMap<String, MasterTable> mtables(String types) {
            return service.metadata().mtables(types);
        }

        public static LinkedHashMap<String, MasterTable> mtables() {
            return service.metadata().mtables();
        }

        public static MasterTable mtable(Catalog catalog, Schema schema, String name) {
            return service.metadata().mtable(catalog, schema, name);
        }

        public static MasterTable mtable(Schema schema, String name) {
            return service.metadata().mtable(schema, name);
        }

        public static MasterTable mtable(String name) {
            return service.metadata().mtable(name);
        }

        public static boolean exists(PartitionTable table) {
            return service.metadata().exists(table);
        }

        public static LinkedHashMap<String, PartitionTable> ptables(Catalog catalog, Schema schema, String master, String name) {
            return service.metadata().ptables(catalog, schema, master, name);
        }

        public static LinkedHashMap<String, PartitionTable> ptables(Schema schema, String master, String name) {
            return service.metadata().ptables(schema, master, name);
        }

        public static LinkedHashMap<String, PartitionTable> ptables(String master, String name) {
            return service.metadata().ptables(master, name);
        }

        public static LinkedHashMap<String, PartitionTable> ptables(String master) {
            return service.metadata().ptables(master);
        }

        public static LinkedHashMap<String, PartitionTable> ptables(MasterTable master) {
            return service.metadata().ptables(master);
        }

        public static LinkedHashMap<String, PartitionTable> ptables(MasterTable master, Map<String, Object> tags) {
            return service.metadata().ptables(master, tags);
        }

        public static PartitionTable ptable(Catalog catalog, Schema schema, String master, String name) {
            return service.metadata().ptable(catalog, schema, master, name);
        }

        public static PartitionTable ptable(Schema schema, String master, String name) {
            return service.metadata().ptable(schema, master, name);
        }

        public static PartitionTable ptable(String master, String name) {
            return service.metadata().ptable(master, name);
        }

        public static boolean exists(Column column) {
            return service.metadata().exists(column);
        }

        public static boolean exists(Table table, String name) {
            return service.metadata().exists(table, name);
        }

        public static boolean exists(String table, String name) {
            return service.metadata().exists(table, name);
        }

        public static boolean exists(Catalog catalog, Schema schema, String table, String name) {
            return service.metadata().exists(catalog, schema, table, name);
        }

        public static LinkedHashMap<String, Column> columns(Table table) {
            return service.metadata().columns(table);
        }

        public static LinkedHashMap<String, Column> columns(String table) {
            return service.metadata().columns(table);
        }

        public static LinkedHashMap<String, Column> columns(Catalog catalog, Schema schema, String table) {
            return service.metadata().columns(catalog, schema, table);
        }

        public static Column column(Table table, String name) {
            return service.metadata().column(table, name);
        }

        public static Column column(String table, String name) {
            return service.metadata().column(table, name);
        }

        public static Column column(Catalog catalog, Schema schema, String table, String name) {
            return service.metadata().column(catalog, schema, table, name);
        }

        public static LinkedHashMap<String, Tag> tags(Table table) {
            return service.metadata().tags(table);
        }

        public static LinkedHashMap<String, Tag> tags(String table) {
            return service.metadata().tags(table);
        }

        public static LinkedHashMap<String, Tag> tags(Catalog catalog, Schema schema, String table) {
            return service.metadata().tags(catalog, schema, table);
        }

        public static LinkedHashMap<String, Index> indexs(Table table) {
            return service.metadata().indexs(table);
        }

        public static LinkedHashMap<String, Index> indexs(String table) {
            return service.metadata().indexs(table);
        }

        public static LinkedHashMap<String, Index> indexs(Catalog catalog, Schema schema, String table) {
            return service.metadata().indexs(catalog, schema, table);
        }

        public static LinkedHashMap<String, Constraint> constraints(Table table) {
            return service.metadata().constraints(table);
        }

        public static LinkedHashMap<String, Constraint> constraints(String table) {
            return service.metadata().constraints(table);
        }

        public static LinkedHashMap<String, Constraint> constraints(Catalog catalog, Schema schema, String table) {
            return service.metadata().constraints(catalog, schema, table);
        }
    }
}

