/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.util;

import java.util.Collection;
import org.anyline.entity.DataRow;
import org.anyline.entity.DataSet;
import org.anyline.metadata.BaseMetadata;
import org.anyline.proxy.EntityAdapterProxy;
import org.anyline.util.BasicUtil;

public class DataSourceUtil {
    public static String parseDataSource(String src) {
        if (null != src && src.startsWith("<")) {
            int fr = src.indexOf("<");
            int to = src.indexOf(">");
            if (fr != -1) {
                src = src.substring(to + 1);
            }
        }
        return src;
    }

    public static String[] parseRuntime(BaseMetadata meta) {
        if (null != meta) {
            return DataSourceUtil.parseRuntime(meta.getName());
        }
        return new String[2];
    }

    public static String[] parseRuntime(String src) {
        String[] result = new String[2];
        result[1] = src;
        String runtime = null;
        if (null != src && src.startsWith("<")) {
            int fr = src.indexOf("<");
            int to = src.indexOf(">");
            if (fr != -1) {
                runtime = src.substring(fr + 1, to);
                src = src.substring(to + 1);
                result[0] = runtime;
                result[1] = src;
            }
        }
        return result;
    }

    public static String parseDataSource(String dest, Object obj) {
        if (BasicUtil.isNotEmpty((Object)dest) || null == obj) {
            return DataSourceUtil.parseDataSource(dest);
        }
        String result = "";
        if (obj instanceof DataRow) {
            DataRow row = (DataRow)obj;
            String link = row.getDataLink();
            if (BasicUtil.isNotEmpty((Object)link)) {
                // empty if block
            }
            result = row.getDataSource();
        } else if (obj instanceof DataSet) {
            DataSet set = (DataSet)obj;
            if (set.size() > 0) {
                result = DataSourceUtil.parseDataSource(dest, set.getRow(0));
            }
        } else {
            Object first;
            result = obj instanceof Collection ? ((first = ((Collection)obj).iterator().next()) instanceof DataRow ? DataSourceUtil.parseDataSource(dest, first) : EntityAdapterProxy.table(first.getClass(), (boolean)true)) : EntityAdapterProxy.table(obj.getClass(), (boolean)true);
        }
        result = DataSourceUtil.parseDataSource(result);
        return result;
    }
}

