/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.runtime;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.anyline.data.adapter.DriverAdapter;
import org.anyline.data.runtime.DataRuntime;
import org.anyline.proxy.DatasourceHolderProxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;

public abstract class RuntimeHolder {
    protected static Logger log = LoggerFactory.getLogger(RuntimeHolder.class);
    protected static Map<String, DataRuntime> runtimes = new Hashtable<String, DataRuntime>();
    protected static DefaultListableBeanFactory factory;

    public static void init(DefaultListableBeanFactory factory) {
        RuntimeHolder.factory = factory;
    }

    public static DataRuntime temporary(Object datasource, String database, DriverAdapter adapter) throws Exception {
        return DatasourceHolderProxy.temporary(datasource, database, adapter);
    }

    public abstract DataRuntime callTemporary(Object var1, String var2, DriverAdapter var3) throws Exception;

    public static void destroy(String datasource) {
        DatasourceHolderProxy.destroy(RuntimeHolder.runtime(datasource));
    }

    public abstract void callDestroy(String var1);

    public static void reg(String key, DataRuntime runtime) {
        runtimes.put(key, runtime);
    }

    public static DataRuntime runtime() {
        return RuntimeHolder.runtime(null);
    }

    public static Map<String, DataRuntime> all() {
        return runtimes;
    }

    public static Map<String, DataRuntime> runtimes(String origin) {
        Hashtable<String, DataRuntime> map = new Hashtable<String, DataRuntime>();
        for (String key : runtimes.keySet()) {
            DataRuntime runtime = runtimes.get(key);
            if (!origin.equals(runtime.origin())) continue;
            map.put(key, runtime);
        }
        return map;
    }

    public static DataRuntime runtime(String datasource) {
        DataRuntime runtime = null;
        if (null == datasource) {
            datasource = "default";
        }
        if (null == (runtime = runtimes.get(datasource))) {
            throw new RuntimeException("\u672a\u6ce8\u518c\u6570\u636e\u6e90:" + datasource);
        }
        return runtime;
    }

    public static boolean contains(String key) {
        if (null == key) {
            return false;
        }
        return runtimes.containsKey(key);
    }

    public static List<String> keys() {
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(runtimes.keySet());
        return list;
    }

    public static void destroyBean(String bean) {
        if (factory.containsSingleton(bean)) {
            factory.destroySingleton(bean);
        }
        if (factory.containsBeanDefinition(bean)) {
            factory.removeBeanDefinition(bean);
        }
    }

    public static boolean validate(String ds) {
        return RuntimeHolder.validate(RuntimeHolder.runtime(ds));
    }

    public static boolean validate() {
        return RuntimeHolder.validate(RuntimeHolder.runtime());
    }

    public static boolean validate(DataRuntime runtime) {
        return DatasourceHolderProxy.validate(runtime);
    }

    public static boolean hit(String ds) throws Exception {
        return RuntimeHolder.hit(RuntimeHolder.runtime(ds));
    }

    public static boolean hit() throws Exception {
        return RuntimeHolder.hit(RuntimeHolder.runtime());
    }

    public static boolean hit(DataRuntime runtime) throws Exception {
        return DatasourceHolderProxy.hit(runtime);
    }
}

