/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.run;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import org.anyline.data.adapter.DriverAdapter;
import org.anyline.data.param.ConfigParser;
import org.anyline.data.param.ConfigStore;
import org.anyline.data.param.ParseResult;
import org.anyline.data.prepare.Condition;
import org.anyline.data.prepare.ConditionChain;
import org.anyline.data.prepare.GroupStore;
import org.anyline.data.prepare.RunPrepare;
import org.anyline.data.prepare.Variable;
import org.anyline.data.prepare.auto.init.DefaultAutoCondition;
import org.anyline.data.prepare.auto.init.DefaultAutoConditionChain;
import org.anyline.data.prepare.init.DefaultGroupStore;
import org.anyline.data.run.Run;
import org.anyline.data.run.RunValue;
import org.anyline.data.runtime.DataRuntime;
import org.anyline.entity.Compare;
import org.anyline.entity.DefaultOrderStore;
import org.anyline.entity.Order;
import org.anyline.entity.OrderStore;
import org.anyline.entity.PageNavi;
import org.anyline.metadata.ACTION;
import org.anyline.metadata.Column;
import org.anyline.metadata.type.ColumnType;
import org.anyline.util.BasicUtil;
import org.anyline.util.BeanUtil;
import org.anyline.util.ConfigTable;
import org.anyline.util.LogUtil;
import org.anyline.util.SQLUtil;
import org.anyline.util.regular.RegularUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BasicRun
implements Run {
    protected static final Logger log = LoggerFactory.getLogger(BasicRun.class);
    protected StringBuilder builder = new StringBuilder();
    protected int batch;
    protected int vol;
    protected RunPrepare prepare;
    protected String catalog;
    protected String schema;
    protected String table;
    protected List<String> keys;
    protected List<RunValue> values;
    protected List<RunValue> batchValues;
    protected PageNavi pageNavi;
    protected ConditionChain conditionChain;
    protected ConfigStore configStore;
    protected OrderStore orderStore;
    protected GroupStore groupStore;
    protected String having;
    protected List<Variable> variables;
    protected Object filter;
    protected Object update;
    protected Object value;
    protected Compare.EMPTY_VALUE_SWITCH swt = Compare.EMPTY_VALUE_SWITCH.IGNORE;
    protected boolean valid = true;
    protected LinkedHashMap<String, Column> insertColumns = null;
    protected LinkedHashMap<String, Column> updateColumns;
    protected List<String> queryColumns;
    protected List<String> excludeColumn;
    protected int from = 1;
    protected boolean supportBr = true;
    protected DataRuntime runtime;
    protected String delimiterFr;
    protected String delimiterTo;
    protected String action;

    @Override
    public DriverAdapter adapter() {
        if (null != this.runtime) {
            return this.runtime.getAdapter();
        }
        return null;
    }

    @Override
    public void setRuntime(DataRuntime runtime) {
        this.runtime = runtime;
    }

    @Override
    public int getFrom() {
        return this.from;
    }

    @Override
    public void setFrom(int from) {
        this.from = from;
    }

    @Override
    public void init() {
        if (null != this.runtime) {
            this.delimiterFr = this.runtime.getAdapter().getDelimiterFr();
            this.delimiterTo = this.runtime.getAdapter().getDelimiterTo();
        }
        if (null != this.configStore) {
            this.setPageNavi(this.configStore.getPageNavi());
        }
    }

    @Override
    public String getTable() {
        return this.table;
    }

    @Override
    public String getCatalog() {
        return this.catalog;
    }

    public void setCatalog(String catalog) {
        this.catalog = catalog;
    }

    @Override
    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public void setTable(String table) {
        this.table = table;
    }

    @Override
    public String getDataSource() {
        Object ds = this.table;
        if (BasicUtil.isNotEmpty((Object)ds) && BasicUtil.isNotEmpty((Object)this.schema)) {
            ds = this.schema + "." + (String)ds;
        }
        if (BasicUtil.isEmpty((Object)ds)) {
            ds = this.schema;
        }
        return ds;
    }

    @Override
    public Run group(String group) {
        if (BasicUtil.isEmpty((Object)group)) {
            return this;
        }
        if (null == this.groupStore) {
            this.groupStore = new DefaultGroupStore();
        }
        group = group.trim().toUpperCase();
        if (!this.groupStore.getGroups().contains(group)) {
            this.groupStore.group(group);
        }
        return this;
    }

    @Override
    public Run order(String order) {
        if (null == this.orderStore) {
            this.orderStore = new DefaultOrderStore();
        }
        this.orderStore.order(order);
        return this;
    }

    @Override
    public RunPrepare getPrepare() {
        return this.prepare;
    }

    @Override
    public Run setPrepare(RunPrepare prepare) {
        this.prepare = prepare;
        this.table = prepare.getTable();
        return this;
    }

    @Override
    public List<RunValue> getRunValues() {
        if (null != this.batchValues) {
            return this.batchValues;
        }
        return this.values;
    }

    @Override
    public List<Object> getValues() {
        ArrayList<Object> list;
        block3: {
            block2: {
                list = new ArrayList<Object>();
                if (null == this.batchValues) break block2;
                for (RunValue value : this.batchValues) {
                    list.add(value.getValue());
                }
                break block3;
            }
            if (null == this.values) break block3;
            for (RunValue value : this.values) {
                list.add(value.getValue());
            }
        }
        return list;
    }

    @Override
    public void setValues(String key, List<Object> values) {
        if (null != values) {
            if (null == this.values) {
                this.values = new ArrayList<RunValue>();
            }
            for (Object value : values) {
                this.values.add(new RunValue(key, value));
            }
        }
    }

    @Override
    public RunValue addValues(Compare compare, Column column, Object obj, boolean split) {
        RunValue rv = null;
        if (null != obj) {
            if (split && (null == column || !column.isArray()) && this.getFrom() != 2) {
                String type;
                boolean json = false;
                if (null != column && null != (type = column.getTypeName()) && (type.toUpperCase().contains("JSON") || type.toUpperCase().contains("BSON"))) {
                    json = true;
                }
                if (obj.getClass().isArray()) {
                    if (obj instanceof Object[] && !json) {
                        list = (Object[])obj;
                        for (Object item : list) {
                            rv = new RunValue(column, item);
                            this.addValues(rv);
                            if (Compare.EQUAL != compare) {
                                continue;
                            }
                            break;
                        }
                    } else if (obj instanceof double[] && !json) {
                        for (Object item : list = (Object)((double[])obj)) {
                            rv = new RunValue(column, (Object)((double)item));
                            this.addValues(rv);
                            if (Compare.EQUAL != compare) {
                                continue;
                            }
                            break;
                        }
                    } else if (obj instanceof long[] && !json) {
                        for (Object item : list = (Object)((long[])obj)) {
                            rv = new RunValue(column, (Object)((long)item));
                            this.addValues(rv);
                            if (Compare.EQUAL != compare) {
                                continue;
                            }
                            break;
                        }
                    } else if (obj instanceof int[] && !json) {
                        for (Object item : list = (Object)((int[])obj)) {
                            rv = new RunValue(column, (Object)((int)item));
                            this.addValues(rv);
                            if (Compare.EQUAL != compare) {
                                continue;
                            }
                            break;
                        }
                    } else if (obj instanceof float[] && !json) {
                        for (Object item : list = (Object)((float[])obj)) {
                            rv = new RunValue(column, (Object)Float.valueOf((float)item));
                            this.addValues(rv);
                            if (Compare.EQUAL != compare) {
                                continue;
                            }
                            break;
                        }
                    } else if (obj instanceof short[] && !json) {
                        for (Object item : list = (Object)((short[])obj)) {
                            rv = new RunValue(column, (Object)((short)item));
                            this.addValues(rv);
                            if (Compare.EQUAL != compare) {
                                continue;
                            }
                            break;
                        }
                    } else if (obj instanceof Object[] && !json) {
                        for (Object item : list = (Object[])obj) {
                            rv = new RunValue(column, item);
                            this.addValues(rv);
                            if (Compare.EQUAL != compare) {
                                continue;
                            }
                            break;
                        }
                    }
                } else if (obj instanceof Collection && !json) {
                    list = (Collection)obj;
                    for (Object e : list) {
                        rv = new RunValue(column, e);
                        this.addValues(rv);
                        if (Compare.EQUAL != compare) continue;
                        break;
                    }
                } else {
                    rv = new RunValue(column, obj);
                    this.addValues(rv);
                }
            } else {
                rv = new RunValue(column, obj);
                this.addValues(rv);
            }
        } else {
            rv = new RunValue(column, obj);
            this.addValues(rv);
        }
        return rv;
    }

    public Run addValues(RunValue run) {
        if (null == this.values) {
            this.values = new ArrayList<RunValue>();
        }
        this.values.add(run);
        return this;
    }

    public Run addValues(List<RunValue> values) {
        for (RunValue value : values) {
            this.addValues(value);
        }
        return this;
    }

    public Run setRunValues(List<RunValue> values) {
        this.values = values;
        return this;
    }

    @Override
    public PageNavi getPageNavi() {
        return this.pageNavi;
    }

    @Override
    public void setPageNavi(PageNavi pageNavi) {
        this.pageNavi = pageNavi;
    }

    @Override
    public ConfigStore getConfigStore() {
        return this.configStore;
    }

    @Override
    public void setConfigStore(ConfigStore configStore) {
        this.configStore = configStore;
    }

    @Override
    public OrderStore getOrderStore() {
        return this.orderStore;
    }

    @Override
    public void setOrderStore(OrderStore orderStore) {
        this.orderStore = orderStore;
    }

    @Override
    public GroupStore getGroupStore() {
        return this.groupStore;
    }

    @Override
    public void setGroupStore(GroupStore groupStore) {
        this.groupStore = groupStore;
    }

    public String getDelimiterFr() {
        return this.delimiterFr;
    }

    public void setDelimiterFr(String delimiterFr) {
        this.delimiterFr = delimiterFr;
    }

    public String getDelimiterTo() {
        return this.delimiterTo;
    }

    public void setDelimiterTo(String delimiterTo) {
        this.delimiterTo = delimiterTo;
    }

    public DriverAdapter getAdapter() {
        return this.runtime.getAdapter();
    }

    @Override
    public Run setConditionValue(Compare.EMPTY_VALUE_SWITCH swt, Compare compare, String prefix, String variable, Object value) {
        return this;
    }

    @Override
    public void setOrders(String[] orders) {
        if (null != orders) {
            for (String order : orders) {
                this.order(order);
            }
        }
    }

    @Override
    public String getFinalQuery(boolean placeholder) {
        String text = this.runtime.getAdapter().mergeFinalQuery(this.runtime, this);
        if (ConfigTable.IS_SQL_DELIMITER_PLACEHOLDER_OPEN) {
            text = SQLUtil.placeholder((String)text, (String)this.delimiterFr, (String)this.delimiterTo);
        }
        if (!placeholder) {
            text = this.replace(text);
        }
        return text;
    }

    @Override
    public String getTotalQuery(boolean placeholder) {
        String text = this.runtime.getAdapter().mergeFinalTotal(this.runtime, this);
        if (ConfigTable.IS_SQL_DELIMITER_PLACEHOLDER_OPEN) {
            text = SQLUtil.placeholder((String)text, (String)this.delimiterFr, (String)this.delimiterTo);
        }
        if (!placeholder) {
            text = this.replace(text);
        }
        return text;
    }

    @Override
    public String getFinalExists(boolean placeholder) {
        String text = this.runtime.getAdapter().mergeFinalExists(this.runtime, this);
        if (ConfigTable.IS_SQL_DELIMITER_PLACEHOLDER_OPEN) {
            text = SQLUtil.placeholder((String)text, (String)this.delimiterFr, (String)this.delimiterTo);
        }
        if (!placeholder) {
            text = this.replace(text);
        }
        return text;
    }

    @Override
    public String getBaseQuery(boolean placeholder) {
        String text = this.builder.toString();
        if (!placeholder) {
            text = this.replace(text);
        }
        return text;
    }

    @Override
    public Run addOrders(OrderStore orderStore) {
        if (null == orderStore) {
            return this;
        }
        List orders = orderStore.getOrders();
        if (null == orders) {
            return this;
        }
        for (Order order : orders) {
            this.orderStore.order(order);
        }
        return this;
    }

    @Override
    public Run addOrder(Order order) {
        this.orderStore.order(order);
        return this;
    }

    @Override
    public Run addValue(RunValue value) {
        if (null == this.values) {
            this.values = new ArrayList<RunValue>();
        }
        this.values.add(value);
        return this;
    }

    @Override
    public Run setConditionChain(ConditionChain chain) {
        this.conditionChain = chain;
        return this;
    }

    @Override
    public ConditionChain getConditionChain() {
        return this.conditionChain;
    }

    @Override
    public Run addCondition(Compare.EMPTY_VALUE_SWITCH swt, Compare compare, String prefix, String var, Object value) {
        DefaultAutoCondition condition = new DefaultAutoCondition(swt, compare, prefix, var, value);
        if (null == this.conditionChain) {
            this.conditionChain = new DefaultAutoConditionChain();
        }
        if (condition.isActive()) {
            this.conditionChain.addCondition(condition);
        } else if (swt == Compare.EMPTY_VALUE_SWITCH.BREAK) {
            this.conditionChain.setValid(false);
        }
        return this;
    }

    @Override
    public Run addCondition(Condition condition) {
        if (null != this.conditionChain) {
            this.conditionChain.addCondition(condition);
        }
        return this;
    }

    @Override
    public Condition getCondition(String name) {
        for (Condition con : this.conditionChain.getConditions()) {
            if (null == con || null == con.getId() || !con.getId().equalsIgnoreCase(name)) continue;
            return con;
        }
        return null;
    }

    @Override
    public List<Condition> getConditions(String name) {
        ArrayList<Condition> list = new ArrayList<Condition>();
        for (Condition con : this.conditionChain.getConditions()) {
            if (null == con || null == con.getId() || !con.getId().equalsIgnoreCase(name)) continue;
            list.add(con);
        }
        return list;
    }

    @Override
    public String getFinalDelete(boolean placeholder) {
        if (ConfigTable.IS_SQL_DELIMITER_PLACEHOLDER_OPEN) {
            return SQLUtil.placeholder((String)this.builder.toString(), (String)this.delimiterFr, (String)this.delimiterTo);
        }
        String text = this.builder.toString();
        if (!placeholder) {
            text = this.replace(text);
        }
        return text;
    }

    @Override
    public String getFinalInsert(boolean placeholder) {
        if (ConfigTable.IS_SQL_DELIMITER_PLACEHOLDER_OPEN) {
            return SQLUtil.placeholder((String)this.builder.toString(), (String)this.delimiterFr, (String)this.delimiterTo);
        }
        String text = this.builder.toString();
        if (!placeholder) {
            text = this.replace(text);
        }
        return text;
    }

    @Override
    public String getFinalUpdate(boolean placeholder) {
        if (ConfigTable.IS_SQL_DELIMITER_PLACEHOLDER_OPEN) {
            return SQLUtil.placeholder((String)this.builder.toString(), (String)this.delimiterFr, (String)this.delimiterTo);
        }
        String text = this.builder.toString();
        if (!placeholder) {
            text = this.replace(text);
        }
        return text;
    }

    public Run addVariable(Variable var) {
        if (null == this.variables) {
            this.variables = new ArrayList<Variable>();
        }
        this.variables.add(var);
        return this;
    }

    @Override
    public String getFinalExecute(boolean placeholder) {
        String text = this.builder.toString();
        if (ConfigTable.IS_SQL_DELIMITER_PLACEHOLDER_OPEN) {
            text = SQLUtil.placeholder((String)text, (String)this.delimiterFr, (String)this.delimiterTo);
        }
        if (!placeholder) {
            text = this.replace(text);
        }
        if (!this.supportBr()) {
            text = text.replace("\r\n", " ").replace("\n", " ");
        }
        return text;
    }

    @Override
    public boolean supportBr() {
        return this.supportBr;
    }

    @Override
    public void supportBr(boolean support) {
        this.supportBr = support;
    }

    @Override
    public Compare.EMPTY_VALUE_SWITCH getStrict() {
        return this.swt;
    }

    @Override
    public void setSwitch(Compare.EMPTY_VALUE_SWITCH swt) {
        this.swt = swt;
    }

    @Override
    public boolean isValid() {
        if (!this.valid) {
            return false;
        }
        this.valid = this.checkValid();
        return this.valid;
    }

    @Override
    public void setValid(boolean valid) {
        this.valid = valid;
    }

    @Override
    public void setBuilder(StringBuilder builder) {
        this.builder = builder;
    }

    @Override
    public StringBuilder getBuilder() {
        return this.builder;
    }

    @Override
    public LinkedHashMap<String, Column> getInsertColumns(boolean metadata) {
        return this.insertColumns;
    }

    @Override
    public List<String> getInsertColumns() {
        ArrayList<String> keys = new ArrayList<String>();
        if (null != this.insertColumns) {
            for (Column column : this.insertColumns.values()) {
                keys.add(column.getName());
            }
        }
        return keys;
    }

    @Override
    public Run setInsertColumns(List<String> columns) {
        if (null != columns) {
            if (null == this.insertColumns) {
                this.insertColumns = new LinkedHashMap();
            }
            for (String column : columns) {
                this.insertColumns.put(column.toUpperCase(), new Column(column));
            }
        }
        return this;
    }

    @Override
    public Run setInsertColumns(LinkedHashMap<String, Column> columns) {
        this.insertColumns = columns;
        return this;
    }

    @Override
    public LinkedHashMap<String, Column> getUpdateColumns(boolean metadata) {
        return this.updateColumns;
    }

    @Override
    public List<String> getUpdateColumns() {
        ArrayList<String> keys = new ArrayList<String>();
        if (null != this.updateColumns) {
            for (Column column : this.updateColumns.values()) {
                keys.add(column.getName());
            }
        }
        return keys;
    }

    @Override
    public Run setUpdateColumns(List<String> columns) {
        if (null != columns) {
            if (null == this.updateColumns) {
                this.updateColumns = new LinkedHashMap();
            }
            for (String column : columns) {
                this.updateColumns.put(column.toUpperCase(), new Column(column));
            }
        }
        return this;
    }

    @Override
    public Run setUpdateColumns(LinkedHashMap<String, Column> columns) {
        this.updateColumns = columns;
        return this;
    }

    @Override
    public Run addCondition(String ... conditions) {
        if (null != conditions) {
            for (String condition : conditions) {
                if (null == condition) continue;
                String up = (condition = condition.trim()).toUpperCase().replaceAll("\\s+", " ").trim();
                if (up.startsWith("ORDER BY")) {
                    String[] orders;
                    String orderStr = condition.substring(up.indexOf("ORDER BY") + "ORDER BY".length()).trim();
                    for (String item : orders = orderStr.split(",")) {
                        this.order(item);
                        if (null != this.configStore) {
                            this.configStore.order(item);
                        }
                        if (null == this.orderStore) continue;
                        this.orderStore.order(item);
                    }
                    continue;
                }
                if (up.startsWith("GROUP BY")) {
                    String[] groups;
                    String groupStr = condition.substring(up.indexOf("GROUP BY") + "GROUP BY".length()).trim();
                    for (String item : groups = groupStr.split(",")) {
                        if (null == this.groupStore) {
                            this.groupStore = new DefaultGroupStore();
                        }
                        this.groupStore.group(item);
                    }
                    continue;
                }
                if (up.startsWith("HAVING")) {
                    String haveStr;
                    this.having = haveStr = condition.substring(up.indexOf("HAVING") + "HAVING".length()).trim();
                    continue;
                }
                if (condition.startsWith("${") && condition.endsWith("}")) {
                    DefaultAutoCondition con = new DefaultAutoCondition(condition.substring(2, condition.length() - 1));
                    this.addCondition(con);
                    continue;
                }
                if (condition.contains(":")) {
                    boolean isTime = false;
                    int idx = condition.indexOf(":");
                    if (condition.indexOf("'") < idx && condition.indexOf("'", idx + 1) > 0) {
                        isTime = true;
                    }
                    if (!isTime) {
                        ParseResult parser = ConfigParser.parse(condition, false);
                        List<Object> value = ConfigParser.getValues(parser);
                        this.addCondition(parser.getSwitch(), parser.getCompare(), parser.getPrefix(), parser.getVar(), value);
                        continue;
                    }
                }
                DefaultAutoCondition con = new DefaultAutoCondition(condition);
                this.addCondition(con);
            }
        }
        return this;
    }

    protected static boolean endWithWhere(String txt) {
        if ((txt = txt.replaceAll("\\s", " ").replaceAll("'[\\S\\s]*?'", "{}").replaceAll("\\([^\\(\\)]+?\\)", "{}").replaceAll("\\([^\\(\\)]+?\\)", "{}").replaceAll("\\([^\\(\\)]+?\\)", "{}").toUpperCase()).contains("UNION")) {
            boolean result = false;
            int fr = 0;
            while ((fr = txt.indexOf("WHERE")) > 0) {
                if ((txt = txt.substring(fr + 5)).indexOf("UNION") > 0) continue;
                try {
                    int bSize = 0;
                    if (txt.contains(")")) {
                        bSize = RegularUtil.fetch((String)txt, (String)"\\)").size();
                    }
                    int eSize = 0;
                    if (txt.contains("(")) {
                        eSize = RegularUtil.fetch((String)txt, (String)"\\(").size();
                    }
                    if (bSize != eSize) continue;
                    result = true;
                    break;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return result;
        }
        return txt.contains("WHERE");
    }

    public List<Variable> getVariables() {
        return this.variables;
    }

    public void setVariables(List<Variable> variables) {
        this.variables = variables;
    }

    @Override
    public boolean isSetValue(String condition, String variable) {
        Variable var;
        Condition con = this.getCondition(condition);
        if (null == con && null != (var = con.getVariable(variable))) {
            return var.isSetValue();
        }
        return false;
    }

    @Override
    public boolean isSetValue(String variable) {
        Variable var = this.getVariable(variable);
        if (null != var) {
            return var.isSetValue();
        }
        return false;
    }

    @Override
    public Variable getVariable(String var) {
        if (null == this.variables || null == var) {
            return null;
        }
        for (Variable variable : this.variables) {
            if (null == variable || !var.equalsIgnoreCase(variable.getKey())) continue;
            return variable;
        }
        return null;
    }

    @Override
    public void setFilter(Object filter) {
        this.filter = filter;
    }

    @Override
    public Object getFilter() {
        return this.filter;
    }

    @Override
    public Object getUpdate() {
        return this.update;
    }

    @Override
    public void setUpdate(Object update) {
        this.update = update;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public void setValue(Object value) {
        this.value = value;
    }

    @Override
    public Run setQueryColumns(String ... columns) {
        if (null != columns) {
            this.queryColumns = BeanUtil.array2list((Object[][])new String[][]{columns});
        }
        return this;
    }

    @Override
    public Run setQueryColumns(List<String> columns) {
        this.queryColumns = columns;
        return this;
    }

    @Override
    public List<String> getQueryColumns() {
        return this.queryColumns;
    }

    @Override
    public List<String> getExcludeColumns() {
        return this.excludeColumn;
    }

    @Override
    public Run setExcludeColumns(List<String> excludeColumn) {
        this.excludeColumn = excludeColumn;
        return this;
    }

    @Override
    public Run setExcludeColumns(String ... columns) {
        if (null != columns) {
            this.queryColumns = BeanUtil.array2list((Object[][])new String[][]{columns});
        }
        return this;
    }

    @Override
    public int getBatch() {
        return this.batch;
    }

    @Override
    public void setBatch(int batch) {
        this.batch = batch;
    }

    @Override
    public int getVol() {
        return this.vol;
    }

    @Override
    public String action() {
        return this.action;
    }

    @Override
    public void action(String action) {
        this.action = action;
    }

    @Override
    public void setVol(int vol) {
        this.vol = vol;
    }

    @Override
    public String getQueryColumn() {
        List<String> cols;
        Object result = "*";
        if (null != this.prepare && null != (cols = this.prepare.getFetchKeys()) && cols.size() > 0) {
            result = null;
            for (String col : cols) {
                if (null == result) {
                    result = SQLUtil.delimiter((String)col, (String)this.runtime.getAdapter().getDelimiterFr(), (String)this.runtime.getAdapter().getDelimiterTo());
                    continue;
                }
                result = (String)result + "," + SQLUtil.delimiter((String)col, (String)this.runtime.getAdapter().getDelimiterFr(), (String)this.runtime.getAdapter().getDelimiterTo());
            }
        }
        return result;
    }

    protected String replace(String sql) {
        Object result = sql;
        if (null != this.values) {
            for (RunValue rv : this.values) {
                DriverAdapter adapter;
                Object value = rv.getValue();
                Column column = rv.getColumn();
                ColumnType columnType = null;
                if (null != column) {
                    columnType = column.getColumnType();
                }
                int index = ((String)result).indexOf("?");
                Object replacement = null;
                if (null == value) {
                    value = "null";
                }
                replacement = null != (adapter = this.adapter()) ? "" + adapter.write(this.runtime, column, value, false) : (BasicUtil.isNumber((Object)value) || "NULL".equalsIgnoreCase(value.toString()) ? value.toString() : "'" + value + "'");
                result = ((String)result).substring(0, index) + (String)replacement + ((String)result).substring(index + 1);
            }
        }
        return result;
    }

    @Override
    public String log(ACTION.DML action, boolean placeholder) {
        List<Object> values;
        StringBuilder builder = new StringBuilder();
        List<String> keys = null;
        builder.append("[sql:\n");
        if (action == ACTION.DML.SELECT) {
            builder.append(this.getFinalQuery(placeholder));
        } else if (action == ACTION.DML.COUNT) {
            builder.append(this.getTotalQuery(placeholder));
        } else if (action == ACTION.DML.UPDATE) {
            keys = this.getUpdateColumns();
            builder.append(this.getFinalUpdate(placeholder));
        } else if (action == ACTION.DML.INSERT) {
            keys = this.getInsertColumns();
            builder.append(this.getFinalInsert(placeholder));
        } else if (action == ACTION.DML.EXECUTE) {
            builder.append(this.getFinalExecute(placeholder));
        } else if (action == ACTION.DML.DELETE) {
            builder.append(this.getFinalDelete(placeholder));
        } else if (action == ACTION.DML.EXISTS) {
            builder.append(this.getFinalExists(placeholder));
        }
        builder.append("\n]");
        if (placeholder && null != (values = this.getValues()) && values.size() > 0) {
            builder.append("\n[param:");
            builder.append(LogUtil.param(keys, this.getValues()));
            builder.append("];");
        }
        return builder.toString();
    }
}

