/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.adapter.init;

import java.lang.reflect.Field;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.anyline.adapter.DataReader;
import org.anyline.adapter.DataWriter;
import org.anyline.adapter.EntityAdapter;
import org.anyline.adapter.KeyAdapter;
import org.anyline.adapter.init.ConvertAdapter;
import org.anyline.data.adapter.DriverAdapter;
import org.anyline.data.cache.PageLazyStore;
import org.anyline.data.listener.DDListener;
import org.anyline.data.listener.DMListener;
import org.anyline.data.metadata.StandardColumnType;
import org.anyline.data.param.ConfigParser;
import org.anyline.data.param.ConfigStore;
import org.anyline.data.param.init.DefaultConfigStore;
import org.anyline.data.prepare.RunPrepare;
import org.anyline.data.prepare.auto.TablePrepare;
import org.anyline.data.prepare.auto.TextPrepare;
import org.anyline.data.prepare.auto.init.DefaultTablePrepare;
import org.anyline.data.prepare.auto.init.DefaultTextPrepare;
import org.anyline.data.prepare.xml.XMLPrepare;
import org.anyline.data.run.BasicRun;
import org.anyline.data.run.Run;
import org.anyline.data.run.RunValue;
import org.anyline.data.run.SimpleRun;
import org.anyline.data.run.TableRun;
import org.anyline.data.run.TextRun;
import org.anyline.data.run.XMLRun;
import org.anyline.data.runtime.DataRuntime;
import org.anyline.data.util.DataSourceUtil;
import org.anyline.entity.Compare;
import org.anyline.entity.DataRow;
import org.anyline.entity.DataSet;
import org.anyline.entity.EntitySet;
import org.anyline.entity.PageNavi;
import org.anyline.entity.generator.GeneratorConfig;
import org.anyline.entity.generator.PrimaryGenerator;
import org.anyline.exception.AnylineException;
import org.anyline.exception.SQLUpdateException;
import org.anyline.metadata.ACTION;
import org.anyline.metadata.BaseMetadata;
import org.anyline.metadata.CMD;
import org.anyline.metadata.Catalog;
import org.anyline.metadata.Column;
import org.anyline.metadata.Constraint;
import org.anyline.metadata.Database;
import org.anyline.metadata.ForeignKey;
import org.anyline.metadata.Function;
import org.anyline.metadata.Index;
import org.anyline.metadata.MasterTable;
import org.anyline.metadata.Parameter;
import org.anyline.metadata.PartitionTable;
import org.anyline.metadata.PrimaryKey;
import org.anyline.metadata.Procedure;
import org.anyline.metadata.Schema;
import org.anyline.metadata.Table;
import org.anyline.metadata.Tag;
import org.anyline.metadata.Trigger;
import org.anyline.metadata.View;
import org.anyline.metadata.type.ColumnType;
import org.anyline.metadata.type.DatabaseType;
import org.anyline.proxy.CacheProxy;
import org.anyline.proxy.EntityAdapterProxy;
import org.anyline.proxy.InterceptorProxy;
import org.anyline.util.BasicUtil;
import org.anyline.util.BeanUtil;
import org.anyline.util.ClassUtil;
import org.anyline.util.ConfigTable;
import org.anyline.util.LogUtil;
import org.anyline.util.SQLUtil;
import org.anyline.util.regular.RegularUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class DefaultDriverAdapter
implements DriverAdapter {
    protected static final Logger log = LoggerFactory.getLogger(DefaultDriverAdapter.class);
    @Autowired(required=false)
    protected DMListener dmListener;
    @Autowired(required=false)
    protected DDListener ddListener;
    public String delimiterFr = "";
    public String delimiterTo = "";
    protected Map<String, ColumnType> types = new Hashtable<String, ColumnType>();
    @Autowired(required=false)
    protected PrimaryGenerator primaryGenerator;
    protected Map<String, String> versions = new Hashtable<String, String>();

    public DMListener getListener() {
        return this.dmListener;
    }

    @Autowired(required=false)
    public void setListener(DMListener listener) {
        this.dmListener = listener;
    }

    @Override
    public String version() {
        return null;
    }

    @Override
    public DatabaseType compatible() {
        return null;
    }

    public DefaultDriverAdapter() {
        block0: for (StandardColumnType type : StandardColumnType.values()) {
            DatabaseType[] dbs;
            for (DatabaseType db : dbs = type.dbs()) {
                if (db != this.type()) continue;
                this.types.put(type.getName(), type);
                continue block0;
            }
        }
    }

    @Override
    public String getDelimiterFr() {
        return this.delimiterFr;
    }

    @Override
    public String getDelimiterTo() {
        return this.delimiterTo;
    }

    public void setDelimiter(String delimiter) {
        if (BasicUtil.isNotEmpty((Object)delimiter)) {
            if ((delimiter = delimiter.replaceAll("\\s", "")).length() == 1) {
                this.delimiterFr = delimiter;
                this.delimiterTo = delimiter;
            } else {
                this.delimiterFr = delimiter.substring(0, 1);
                this.delimiterTo = delimiter.substring(1, 2);
            }
        }
    }

    @Override
    public long insert(DataRuntime runtime, String random, int batch, String dest, Object data, ConfigStore configs, List<String> columns) {
        DataSet set;
        Map tags;
        dest = DataSourceUtil.parseDataSource(dest, data);
        if (null == random) {
            random = this.random(runtime);
        }
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        boolean cmd_success = false;
        swt = InterceptorProxy.prepareInsert(runtime, random, batch, dest, data, columns);
        if (swt == ACTION.SWITCH.BREAK) {
            return -1L;
        }
        if (null != this.dmListener) {
            swt = this.dmListener.prepareInsert(runtime, random, batch, dest, data, columns);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return -1L;
        }
        if (null != data && data instanceof DataSet && null != (tags = (set = (DataSet)data).getTags()) && tags.size() > 0) {
            LinkedHashMap ptables = this.ptables(runtime, random, false, new MasterTable(dest), tags, null);
            if (ptables.size() != 1) {
                String msg = "\u5206\u533a\u8868\u5b9a\u4f4d\u5f02\u5e38,\u4e3b\u8868:" + dest + ",\u6807\u7b7e:" + BeanUtil.map2json((Map)tags) + ",\u5206\u533a\u8868:" + BeanUtil.object2json(ptables.keySet());
                if (this.IS_THROW_SQL_UPDATE_EXCEPTION(configs)) {
                    throw new SQLUpdateException(msg);
                }
                log.error(msg);
                return -1L;
            }
            dest = ((PartitionTable)ptables.values().iterator().next()).getName();
        }
        Run run = this.buildInsertRun(runtime, batch, dest, data, configs, columns);
        Table table = new Table(dest);
        if (this.IS_AUTO_CHECK_METADATA(configs)) {
            table.setColumns(this.columns(runtime, random, false, table, false));
        }
        if (null == run) {
            return 0L;
        }
        long cnt = 0L;
        long fr = System.currentTimeMillis();
        long millis = -1L;
        swt = InterceptorProxy.beforeInsert(runtime, random, run, dest, data, columns);
        if (swt == ACTION.SWITCH.BREAK) {
            return -1L;
        }
        if (null != this.dmListener) {
            swt = this.dmListener.beforeInsert(runtime, random, run, dest, data, columns);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return -1L;
        }
        cnt = this.insert(runtime, random, data, configs, run, null);
        if (null != this.dmListener) {
            this.dmListener.afterInsert(runtime, random, run, cnt, dest, data, columns, cmd_success, cnt, millis);
        }
        InterceptorProxy.afterInsert(runtime, random, run, dest, data, columns, cmd_success, cnt, System.currentTimeMillis() - fr);
        return cnt;
    }

    @Override
    public Run buildInsertRun(DataRuntime runtime, int batch, String dest, Object obj, ConfigStore configs, List<String> columns) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 Run buildInsertRun(DataRuntime runtime, int batch, String dest, Object obj, ConfigStore configs, List<String> columns)"), (int)37));
        }
        return null;
    }

    @Override
    public void fillInsertContent(DataRuntime runtime, Run run, String dest, DataSet set, ConfigStore configs, LinkedHashMap<String, Column> columns) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 void fillInsertContent(DataRuntime runtime, Run run, String dest, DataSet set, ConfigStore configs, LinkedHashMap<String, Column> columns)"), (int)37));
        }
    }

    @Override
    public void fillInsertContent(DataRuntime runtime, Run run, String dest, Collection list, ConfigStore configs, LinkedHashMap<String, Column> columns) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 void fillInsertContent(DataRuntime runtime, Run run, String dest, Collection list, ConfigStore configs, LinkedHashMap<String, Column> columns)"), (int)37));
        }
    }

    @Override
    public LinkedHashMap<String, Column> confirmInsertColumns(DataRuntime runtime, String dest, Object obj, ConfigStore configs, List<String> columns, boolean batch) {
        LinkedHashMap<String, Column> cols = new LinkedHashMap<String, Column>();
        if (null == obj) {
            return new LinkedHashMap<String, Column>();
        }
        if (obj instanceof Map && !(obj instanceof DataRow)) {
            obj = new DataRow((Map)obj);
        }
        LinkedHashMap<String, Column> mastKeys = new LinkedHashMap<String, Column>();
        ArrayList<String> ignores = new ArrayList<String>();
        ArrayList<String> factKeys = new ArrayList<String>();
        boolean each = true;
        if (null != columns && columns.size() > 0) {
            each = false;
            cols = new LinkedHashMap();
            for (String column : columns) {
                if (BasicUtil.isEmpty((Object)column)) continue;
                if (column.startsWith("+")) {
                    column = column.substring(1);
                    mastKeys.put(column.toUpperCase(), new Column(column));
                    each = true;
                } else if (column.startsWith("-")) {
                    column = column.substring(1);
                    ignores.add(column);
                    each = true;
                } else if (column.startsWith("?")) {
                    column = column.substring(1);
                    factKeys.add(column);
                    each = true;
                }
                cols.put(column.toUpperCase(), new Column(column));
            }
        }
        if (each) {
            boolean isInsertNullColumn = false;
            boolean isInsertEmptyColumn = false;
            DataRow row = null;
            if (obj instanceof DataRow) {
                row = (DataRow)obj;
                mastKeys.putAll(row.getUpdateColumns(true));
                ignores.addAll(row.getIgnoreUpdateColumns());
                cols = row.getColumns();
                isInsertNullColumn = row.isInsertNullColumn();
                isInsertEmptyColumn = row.isInsertEmptyColumn();
            } else {
                isInsertNullColumn = this.IS_INSERT_NULL_FIELD(configs);
                isInsertEmptyColumn = this.IS_INSERT_EMPTY_FIELD(configs);
                if (EntityAdapterProxy.hasAdapter(obj.getClass())) {
                    cols.putAll(EntityAdapterProxy.columns(obj.getClass(), (EntityAdapter.MODE)EntityAdapter.MODE.INSERT));
                } else {
                    cols = new LinkedHashMap<String, Column>();
                    List fields = ClassUtil.getFields(obj.getClass(), (boolean)false, (boolean)false);
                    Iterator iterator = fields.iterator();
                    while (iterator.hasNext()) {
                        Field field = (Field)iterator.next();
                        Class<?> clazz = field.getType();
                        if (clazz != String.class && clazz != Date.class && !ClassUtil.isPrimitiveClass(clazz)) continue;
                        cols.put(field.getName().toUpperCase(), new Column(field.getName()));
                    }
                }
            }
            if (batch) {
                isInsertNullColumn = true;
                isInsertEmptyColumn = true;
            }
            if (log.isDebugEnabled()) {
                log.debug("[confirm insert columns][columns:{}]", cols);
            }
            BeanUtil.removeAll(ignores, columns);
            for (String ignore : ignores) {
                cols.remove(ignore.toUpperCase());
            }
            if (log.isDebugEnabled()) {
                log.debug("[confirm insert columns][ignores:{}]", ignores);
            }
            List keys = BeanUtil.getMapKeys(cols);
            for (String key : keys) {
                if (mastKeys.containsKey(key = key.toUpperCase())) continue;
                Object value = null;
                value = !(obj instanceof Map) && EntityAdapterProxy.hasAdapter(obj.getClass()) ? BeanUtil.getFieldValue((Object)obj, (Field)EntityAdapterProxy.field(obj.getClass(), (String)key)) : BeanUtil.getFieldValue((Object)obj, (String)key);
                if (null == value) {
                    if (factKeys.contains(key)) {
                        cols.remove(key);
                        continue;
                    }
                    if (isInsertNullColumn) continue;
                    cols.remove(key);
                    continue;
                }
                if (!BasicUtil.isEmpty((boolean)true, (Object)value)) continue;
                if (factKeys.contains(key)) {
                    cols.remove(key);
                    continue;
                }
                if (isInsertEmptyColumn) continue;
                cols.remove(key);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("[confirm insert columns][result:{}]", cols);
        }
        cols = this.checkMetadata(runtime, dest, configs, cols);
        return cols;
    }

    @Override
    public String batchInsertSeparator() {
        return ",";
    }

    @Override
    public boolean supportInsertPlaceholder() {
        return true;
    }

    protected void setPrimaryValue(Object obj, Object value) {
        if (null == obj) {
            return;
        }
        if (obj instanceof DataRow) {
            DataRow row = (DataRow)obj;
            row.put(row.getPrimaryKey(), value);
        } else {
            Column key = EntityAdapterProxy.primaryKey(obj.getClass());
            Field field = EntityAdapterProxy.field(obj.getClass(), (Column)key);
            BeanUtil.setFieldValue((Object)obj, (Field)field, (Object)value);
        }
    }

    protected Run createInsertRun(DataRuntime runtime, String dest, Object obj, ConfigStore configs, List<String> columns) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 Run createInsertRun(DataRuntime runtime, String dest, Object obj, List<String> columns)"), (int)37));
        }
        return null;
    }

    protected Run createInsertRunFromCollection(DataRuntime runtime, int batch, String dest, Collection list, ConfigStore configs, List<String> columns) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 Run createInsertRunFromCollection(DataRuntime runtime, int batch, String dest, Collection list, List<String> columns)"), (int)37));
        }
        return null;
    }

    @Override
    public String generatedKey() {
        return null;
    }

    @Override
    public long insert(DataRuntime runtime, String random, Object data, ConfigStore configs, Run run, String[] pks) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 long insert(DataRuntime runtime, String random, Object data, ConfigStore configs, Run run, String[] pks)"), (int)37));
        }
        return -1L;
    }

    @Override
    public long insert(DataRuntime runtime, String random, Object data, ConfigStore configs, Run run, String[] pks, boolean simple) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 long insert(DataRuntime runtime, String random, Object data, ConfigStore configs, Run run, String[] pks, boolean simple)"), (int)37));
        }
        return -1L;
    }

    @Override
    public long update(DataRuntime runtime, String random, int batch, String dest, Object data, ConfigStore configs, List<String> columns) {
        dest = DataSourceUtil.parseDataSource(dest, data);
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        boolean cmd_success = false;
        if (null == random) {
            random = this.random(runtime);
        }
        if ((swt = InterceptorProxy.prepareUpdate(runtime, random, batch, dest, data, configs, columns)) == ACTION.SWITCH.BREAK) {
            return -1L;
        }
        if (null != this.dmListener) {
            swt = this.dmListener.prepareUpdate(runtime, random, batch, dest, data, configs, columns);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return -1L;
        }
        if (null == data) {
            if (this.IS_THROW_SQL_UPDATE_EXCEPTION(configs)) {
                throw new SQLUpdateException("\u66f4\u65b0\u7a7a\u6570\u636e");
            }
            log.error("\u66f4\u65b0\u7a7a\u6570\u636e");
        }
        long result = 0L;
        if (data instanceof Collection && batch <= 1) {
            Collection list = (Collection)data;
            for (Object item : list) {
                result += this.update(runtime, random, 0, dest, item, configs, columns);
            }
            return result;
        }
        Run run = this.buildUpdateRun(runtime, batch, dest, data, configs, columns);
        Table table = new Table(dest);
        if (this.IS_AUTO_CHECK_METADATA(configs)) {
            table.setColumns(this.columns(runtime, null, false, table, false));
        }
        if (!run.isValid()) {
            if (log.isWarnEnabled() && this.IS_LOG_SQL(configs)) {
                log.warn("[valid:false][\u4e0d\u5177\u5907\u6267\u884c\u6761\u4ef6][dest:" + dest + "]");
            }
            return -1L;
        }
        long fr = System.currentTimeMillis();
        long millis = -1L;
        swt = InterceptorProxy.beforeUpdate(runtime, random, run, dest, data, configs, columns);
        if (swt == ACTION.SWITCH.BREAK) {
            return -1L;
        }
        if (null != this.dmListener) {
            swt = this.dmListener.beforeUpdate(runtime, random, run, dest, data, columns);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return -1L;
        }
        result = this.update(runtime, random, dest, data, configs, run);
        cmd_success = true;
        millis = System.currentTimeMillis() - fr;
        if (null != this.dmListener) {
            this.dmListener.afterUpdate(runtime, random, run, result, dest, data, columns, cmd_success, result, millis);
        }
        InterceptorProxy.afterUpdate(runtime, random, run, dest, data, configs, columns, cmd_success, result, System.currentTimeMillis() - fr);
        return result;
    }

    @Override
    public Run buildUpdateRun(DataRuntime runtime, int batch, String dest, Object obj, ConfigStore configs, List<String> columns) {
        Run run = null;
        if (null == obj) {
            return null;
        }
        if (null == dest) {
            dest = DataSourceUtil.parseDataSource(null, obj);
        }
        LinkedHashMap<String, Column> cols = new LinkedHashMap<String, Column>();
        if (null != columns) {
            for (String column : columns) {
                cols.put(column.toUpperCase(), new Column(column));
            }
        }
        if (!(obj instanceof DataRow) && obj instanceof Map) {
            obj = new DataRow((Map)obj);
        }
        run = obj instanceof Collection ? this.buildUpdateRunFromCollection(runtime, batch, dest, (Collection)obj, configs, cols) : (obj instanceof DataRow ? this.buildUpdateRunFromDataRow(runtime, dest, (DataRow)obj, configs, cols) : this.buildUpdateRunFromEntity(runtime, dest, obj, configs, cols));
        this.convert(runtime, configs, run);
        return run;
    }

    @Override
    public Run buildUpdateRunFromEntity(DataRuntime runtime, String dest, Object obj, ConfigStore configs, LinkedHashMap<String, Column> columns) {
        TableRun run = new TableRun(runtime, dest);
        run.setFrom(2);
        StringBuilder builder = run.getBuilder();
        ArrayList<String> list = new ArrayList<String>();
        for (Column column : columns.values()) {
            list.add(column.getName());
        }
        LinkedHashMap<String, Column> cols = this.confirmUpdateColumns(runtime, dest, obj, configs, list);
        ArrayList<Object> primaryKeys = new ArrayList<Object>();
        if (EntityAdapterProxy.hasAdapter(obj.getClass())) {
            primaryKeys.addAll(EntityAdapterProxy.primaryKeys(obj.getClass()).keySet());
        } else {
            primaryKeys = new ArrayList();
            primaryKeys.add(DataRow.DEFAULT_PRIMARY_KEY);
        }
        for (String string : primaryKeys) {
            if (columns.containsKey(string.toUpperCase())) continue;
            cols.remove(string.toUpperCase());
        }
        if (!columns.containsKey(DataRow.DEFAULT_PRIMARY_KEY.toUpperCase())) {
            cols.remove(DataRow.DEFAULT_PRIMARY_KEY.toUpperCase());
        }
        boolean isReplaceEmptyNull = this.IS_REPLACE_EMPTY_NULL(configs);
        cols = this.checkMetadata(runtime, dest, configs, cols);
        ArrayList<String> arrayList = new ArrayList<String>();
        if (!cols.isEmpty()) {
            builder.append("UPDATE ").append(this.parseTable(dest));
            builder.append(" SET").append("\n\t");
            boolean first = true;
            for (Column column : cols.values()) {
                String key = column.getName();
                Object value = null;
                if (EntityAdapterProxy.hasAdapter(obj.getClass())) {
                    Field field = EntityAdapterProxy.field(obj.getClass(), (String)key);
                    value = BeanUtil.getFieldValue((Object)obj, (Field)field);
                } else {
                    value = BeanUtil.getFieldValue((Object)obj, (String)key);
                }
                if (null != value && value.toString().startsWith("${") && value.toString().endsWith("}")) {
                    String str = value.toString();
                    value = str.substring(2, str.length() - 1);
                    if (!first) {
                        builder.append(",");
                    }
                    this.delimiter(builder, key).append(" = ").append(value).append("\n\t");
                    first = false;
                    continue;
                }
                if ("NULL".equals(value)) {
                    value = null;
                } else if ("".equals(value) && isReplaceEmptyNull) {
                    value = null;
                }
                boolean chk = true;
                if ("".equals(value) && !this.IS_UPDATE_EMPTY_FIELD(configs)) {
                    chk = false;
                }
                if (!chk) continue;
                if (!first) {
                    builder.append(",");
                }
                first = false;
                this.delimiter(builder, key).append(" = ?").append("\n\t");
                arrayList.add(key);
                Compare compare = Compare.EQUAL;
                if (this.isMultipleValue(runtime, run, key)) {
                    compare = Compare.IN;
                }
                this.addRunValue(runtime, run, compare, column, value);
            }
            builder.append("\n");
            builder.append("\nWHERE 1=1").append("\n\t");
            if (null == configs) {
                configs = new DefaultConfigStore(new String[0]);
            }
            for (String string : primaryKeys) {
                if (EntityAdapterProxy.hasAdapter(obj.getClass())) {
                    Field field = EntityAdapterProxy.field(obj.getClass(), (String)string);
                    configs.and(string, BeanUtil.getFieldValue((Object)obj, (Field)field));
                    continue;
                }
                configs.and(string, BeanUtil.getFieldValue((Object)obj, (String)string));
            }
            run.setConfigStore(configs);
            run.init();
            run.appendCondition();
        }
        run.setUpdateColumns(arrayList);
        return run;
    }

    @Override
    public Run buildUpdateRunFromDataRow(DataRuntime runtime, String dest, DataRow row, ConfigStore configs, LinkedHashMap<String, Column> columns) {
        TableRun run = new TableRun(runtime, dest);
        run.setFrom(1);
        StringBuilder builder = run.getBuilder();
        LinkedHashMap<String, Column> cols = this.confirmUpdateColumns(runtime, dest, row, configs, (List<String>)BeanUtil.getMapKeys(columns));
        List primaryKeys = row.getPrimaryKeys();
        if (primaryKeys.size() == 0) {
            throw new SQLUpdateException("[\u66f4\u65b0\u66f4\u65b0\u5f02\u5e38][\u66f4\u65b0\u6761\u4ef6\u4e3a\u7a7a,update\u65b9\u6cd5\u4e0d\u652f\u6301\u66f4\u65b0\u6574\u8868\u64cd\u4f5c]");
        }
        if (null == configs) {
            configs = new DefaultConfigStore(new String[0]);
        }
        for (String pk : primaryKeys) {
            Object pv = row.get(pk);
            pv = this.convert(runtime, cols.get(pk.toUpperCase()), pv);
            configs.and(pk, pv);
        }
        for (String pk : primaryKeys) {
            if (columns.containsKey(pk.toUpperCase())) continue;
            cols.remove(pk.toUpperCase());
        }
        if (!columns.containsKey(DataRow.DEFAULT_PRIMARY_KEY.toUpperCase())) {
            cols.remove(DataRow.DEFAULT_PRIMARY_KEY.toUpperCase());
        }
        boolean replaceEmptyNull = row.isReplaceEmptyNull();
        ArrayList<String> updateColumns = new ArrayList<String>();
        if (!cols.isEmpty()) {
            builder.append("UPDATE ").append(this.parseTable(dest));
            builder.append(" SET").append("\n\t");
            boolean first = true;
            for (Column col : cols.values()) {
                String key = col.getName();
                Object value = row.get(key);
                if (!first) {
                    builder.append(",");
                }
                first = false;
                if (null != value && value.toString().startsWith("${") && value.toString().endsWith("}")) {
                    String str = value.toString();
                    value = str.substring(2, str.length() - 1);
                    this.delimiter(builder, key).append(" = ").append(value).append("\n\t");
                    continue;
                }
                this.delimiter(builder, key).append(" = ?").append("\n\t");
                if ("NULL".equals(value)) {
                    value = null;
                } else if ("".equals(value) && replaceEmptyNull) {
                    value = null;
                }
                updateColumns.add(key);
                Compare compare = Compare.EQUAL;
                this.addRunValue(runtime, run, compare, col, value);
            }
            builder.append("\n");
            builder.append("\nWHERE 1=1").append("\n\t");
            run.setConfigStore(configs);
            run.init();
            run.appendCondition();
        }
        run.setUpdateColumns(updateColumns);
        return run;
    }

    @Override
    public Run buildUpdateRunFromCollection(DataRuntime runtime, int batch, String dest, Collection list, ConfigStore configs, LinkedHashMap<String, Column> columns) {
        TableRun run = new TableRun(runtime, dest);
        run.setFrom(1);
        Object first = list.iterator().next();
        if (null == first) {
            return run;
        }
        if (first instanceof Map && !(first instanceof DataRow)) {
            first = new DataRow((Map)first);
        }
        LinkedHashMap<String, Column> cols = new LinkedHashMap();
        List<Object> primaryKeys = new ArrayList();
        boolean replaceEmptyNull = false;
        if (first instanceof DataRow) {
            DataRow row = (DataRow)first;
            primaryKeys = row.getPrimaryKeys();
            cols = this.confirmUpdateColumns(runtime, dest, row, configs, (List<String>)BeanUtil.getMapKeys(columns));
            replaceEmptyNull = row.isReplaceEmptyNull();
        } else {
            ArrayList<String> ll = new ArrayList<String>();
            for (Column column : columns.values()) {
                ll.add(column.getName());
            }
            cols = this.confirmUpdateColumns(runtime, dest, first, configs, ll);
            if (EntityAdapterProxy.hasAdapter(first.getClass())) {
                primaryKeys.addAll(EntityAdapterProxy.primaryKeys(first.getClass()).keySet());
            } else {
                primaryKeys = new ArrayList();
                primaryKeys.add(DataRow.DEFAULT_PRIMARY_KEY);
            }
            replaceEmptyNull = this.IS_REPLACE_EMPTY_NULL(configs);
        }
        cols = this.checkMetadata(runtime, dest, configs, cols);
        StringBuilder builder = run.getBuilder();
        if (primaryKeys.size() == 0) {
            throw new SQLUpdateException("[\u66f4\u65b0\u66f4\u65b0\u5f02\u5e38][\u66f4\u65b0\u6761\u4ef6\u4e3a\u7a7a,update\u65b9\u6cd5\u4e0d\u652f\u6301\u66f4\u65b0\u6574\u8868\u64cd\u4f5c]");
        }
        for (String string : primaryKeys) {
            if (columns.containsKey(string.toUpperCase())) continue;
            cols.remove(string.toUpperCase());
        }
        if (!columns.containsKey(DataRow.DEFAULT_PRIMARY_KEY.toUpperCase())) {
            cols.remove(DataRow.DEFAULT_PRIMARY_KEY.toUpperCase());
        }
        ArrayList<String> updateColumns = new ArrayList<String>();
        if (!cols.isEmpty()) {
            builder.append("UPDATE ").append(this.parseTable(dest));
            builder.append(" SET ");
            boolean bl = true;
            for (Column column : cols.values()) {
                boolean bl2;
                String key = column.getName();
                if (!bl2) {
                    builder.append(", ");
                }
                bl2 = false;
                builder.append(key);
                builder.append(" = ?");
            }
            if (null == configs) {
                configs = new DefaultConfigStore(new String[0]);
            }
            boolean bl3 = true;
            for (String string : primaryKeys) {
                boolean bl4;
                if (bl4) {
                    builder.append(" WHERE ");
                } else {
                    builder.append(" AND ");
                }
                this.delimiter(builder, string).append(" = ?");
                bl4 = false;
            }
        }
        run.setUpdateColumns(updateColumns);
        ArrayList<RunValue> arrayList = new ArrayList<RunValue>();
        for (Object e : list) {
            for (Column column : cols.values()) {
                String key = column.getName();
                Object value = BeanUtil.getFieldValue(e, (String)key);
                if (null != value && value.toString().startsWith("${") && value.toString().endsWith("}")) {
                    String str = value.toString();
                    value = str.substring(2, str.length() - 1);
                } else if ("NULL".equals(value)) {
                    value = null;
                } else if ("".equals(value) && replaceEmptyNull) {
                    value = null;
                }
                arrayList.add(new RunValue(key, value));
            }
            for (String string : primaryKeys) {
                arrayList.add(new RunValue(string, BeanUtil.getFieldValue(e, (String)string)));
            }
        }
        run.setBatch(batch);
        run.setVol(cols.size() + primaryKeys.size());
        run.setRunValues(arrayList);
        return run;
    }

    @Override
    public LinkedHashMap<String, Column> confirmUpdateColumns(DataRuntime runtime, String dest, DataRow row, ConfigStore configs, List<String> columns) {
        LinkedHashMap<String, Column> cols = null;
        if (null == row) {
            return new LinkedHashMap<String, Column>();
        }
        boolean each = true;
        ArrayList conditions = new ArrayList();
        LinkedHashMap masters = row.getUpdateColumns(true);
        List ignores = BeanUtil.copy((Collection)row.getIgnoreUpdateColumns());
        ArrayList<String> factKeys = new ArrayList<String>();
        BeanUtil.removeAll((List)ignores, columns);
        if (null != columns && columns.size() > 0) {
            each = false;
            cols = new LinkedHashMap<String, Column>();
            for (String column : columns) {
                if (BasicUtil.isEmpty((Object)column)) continue;
                if (column.startsWith("+")) {
                    column = column.substring(1);
                    masters.put(column.toUpperCase(), new Column(column));
                    each = true;
                } else if (column.startsWith("-")) {
                    column = column.substring(1);
                    ignores.add(column);
                    each = true;
                } else if (column.startsWith("?")) {
                    column = column.substring(1);
                    factKeys.add(column);
                    each = true;
                }
                cols.put(column.toUpperCase(), new Column(column));
            }
        } else if (null != masters && masters.size() > 0) {
            each = false;
            cols = masters;
        }
        if (each) {
            cols = row.getUpdateColumns(true);
            cols.putAll(masters);
            boolean isUpdateNullColumn = row.isUpdateNullColumn();
            boolean isUpdateEmptyColumn = row.isUpdateEmptyColumn();
            List keys = BeanUtil.getMapKeys(cols);
            int size = keys.size();
            for (int i = size - 1; i >= 0; --i) {
                String key = (String)keys.get(i);
                if (masters.containsKey(key)) continue;
                Object value = row.get(key);
                if (null == value) {
                    if (factKeys.contains(key)) {
                        keys.remove(key);
                        continue;
                    }
                    if (isUpdateNullColumn) continue;
                    keys.remove(i);
                    continue;
                }
                if (!"".equals(value.toString().trim())) continue;
                if (factKeys.contains(key)) {
                    keys.remove(key);
                    continue;
                }
                if (isUpdateEmptyColumn) continue;
                keys.remove(i);
            }
        }
        if (null != ignores) {
            for (String ignore : ignores) {
                cols.remove(ignore.toUpperCase());
            }
        }
        cols = this.checkMetadata(runtime, dest, configs, cols);
        return cols;
    }

    @Override
    public LinkedHashMap<String, Column> confirmUpdateColumns(DataRuntime runtime, String dest, Object obj, ConfigStore configs, List<String> columns) {
        LinkedHashMap<String, Column> cols = null;
        if (null == obj) {
            return new LinkedHashMap<String, Column>();
        }
        boolean each = true;
        ArrayList conditions = new ArrayList();
        LinkedHashMap<String, Column> masters = new LinkedHashMap<String, Column>();
        ArrayList<String> ignores = new ArrayList<String>();
        ArrayList<String> factKeys = new ArrayList<String>();
        BeanUtil.removeAll(ignores, columns);
        if (null != columns && columns.size() > 0) {
            each = false;
            cols = new LinkedHashMap<String, Column>();
            for (String column : columns) {
                if (BasicUtil.isEmpty((Object)column)) continue;
                if (column.startsWith("+")) {
                    column = column.substring(1);
                    masters.put(column.toUpperCase(), new Column(column));
                    each = true;
                } else if (column.startsWith("-")) {
                    column = column.substring(1);
                    ignores.add(column);
                    each = true;
                } else if (column.startsWith("?")) {
                    column = column.substring(1);
                    factKeys.add(column);
                    each = true;
                }
                cols.put(column.toUpperCase(), new Column(column));
            }
        } else if (null != masters && masters.size() > 0) {
            each = false;
            cols = masters;
        }
        if (each) {
            cols = new LinkedHashMap();
            cols.putAll(EntityAdapterProxy.columns(obj.getClass(), (EntityAdapter.MODE)EntityAdapter.MODE.UPDATE));
            cols.putAll(masters);
            boolean isUpdateNullColumn = this.IS_UPDATE_NULL_FIELD(configs);
            boolean isUpdateEmptyColumn = this.IS_UPDATE_EMPTY_FIELD(configs);
            List keys = BeanUtil.getMapKeys(cols);
            int size = keys.size();
            for (int i = size - 1; i >= 0; --i) {
                String key = (String)keys.get(i);
                if (masters.containsKey(key)) continue;
                Object value = BeanUtil.getFieldValue((Object)obj, (String)key);
                if (null == value) {
                    if (factKeys.contains(key)) {
                        keys.remove(key);
                        continue;
                    }
                    if (isUpdateNullColumn) continue;
                    keys.remove(i);
                    continue;
                }
                if (!"".equals(value.toString().trim())) continue;
                if (factKeys.contains(key)) {
                    keys.remove(key);
                    continue;
                }
                if (isUpdateEmptyColumn) continue;
                keys.remove(i);
            }
        }
        if (null != ignores) {
            for (String ignore : ignores) {
                cols.remove(ignore.toUpperCase());
            }
        }
        cols = this.checkMetadata(runtime, dest, configs, cols);
        return cols;
    }

    @Override
    public long update(DataRuntime runtime, String random, String dest, Object data, ConfigStore configs, Run run) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 long update(DataRuntime runtime, String random, String dest, Object data, ConfigStore configs, Run run)"), (int)37));
        }
        return -1L;
    }

    @Override
    public long save(DataRuntime runtime, String random, String dest, Object data, ConfigStore configs, List<String> columns) {
        if (null == random) {
            random = this.random(runtime);
        }
        if (null == data) {
            if (this.IS_THROW_SQL_UPDATE_EXCEPTION(configs)) {
                throw new SQLUpdateException("save\u7a7a\u6570\u636e");
            }
            log.error("save\u7a7a\u6570\u636e");
            return -1L;
        }
        if (data instanceof Collection) {
            Collection items = (Collection)data;
            long cnt = 0L;
            for (Object item : items) {
                cnt += this.save(runtime, random, dest, item, configs, columns);
            }
            return cnt;
        }
        return this.saveObject(runtime, random, dest, data, configs, columns);
    }

    protected long saveCollection(DataRuntime runtime, String random, String dest, Collection<?> data, ConfigStore configs, List<String> columns) {
        long cnt = 0L;
        return cnt;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected long saveObject(DataRuntime runtime, String random, String dest, Object data, ConfigStore configs, List<String> columns) {
        if (null == data) {
            return 0L;
        }
        boolean isNew = BeanUtil.checkIsNew((Object)data);
        if (isNew) {
            return this.insert(runtime, random, 0, dest, data, configs, columns);
        }
        Boolean override = this.checkOverride(data);
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        if (null == override) return this.update(runtime, random, dest, data, configs, columns);
        DefaultTablePrepare prepare = new DefaultTablePrepare(dest);
        Map<String, Object> pvs = this.checkPv(data);
        DefaultConfigStore stores = new DefaultConfigStore(new String[0]);
        for (String k : pvs.keySet()) {
            stores.and(k, pvs.get(k));
        }
        boolean exists = this.exists(runtime, random, prepare, stores, new String[0]);
        if (!exists) return this.insert(runtime, random, 0, dest, data, configs, columns);
        if (override.booleanValue()) {
            return this.update(runtime, random, dest, data, configs, columns);
        }
        log.warn("[\u8df3\u8fc7\u66f4\u65b0][\u6570\u636e\u5df2\u5b58\u5728:{}({})]", (Object)dest, (Object)BeanUtil.map2json(pvs));
        return 0L;
    }

    protected Boolean checkOverride(Object obj) {
        Boolean result = null;
        if (null != obj && obj instanceof DataRow) {
            result = ((DataRow)obj).getOverride();
        }
        return result;
    }

    protected Map<String, Object> checkPv(Object obj) {
        HashMap<String, Object> pvs = new HashMap<String, Object>();
        if (null != obj && obj instanceof DataRow) {
            DataRow row = (DataRow)obj;
            List ks = row.getPrimaryKeys();
            for (String k : ks) {
                pvs.put(k, row.get(k));
            }
        }
        return pvs;
    }

    protected boolean isMultipleValue(DataRuntime runtime, TableRun run, String key) {
        LinkedHashMap columns;
        String table = run.getTable();
        if (null != table && null != (columns = this.columns(runtime, null, false, new Table(table), false))) {
            Column column = (Column)columns.get(key.toUpperCase());
            return this.isMultipleValue(column);
        }
        return false;
    }

    protected boolean isMultipleValue(Column column) {
        String type;
        return null != column && ((type = column.getTypeName().toUpperCase()).contains("POINT") || type.contains("GEOMETRY") || type.contains("POLYGON"));
    }

    public LinkedHashMap<String, Column> checkMetadata(DataRuntime runtime, String table, ConfigStore configs, LinkedHashMap<String, Column> columns) {
        if (!this.IS_AUTO_CHECK_METADATA(configs)) {
            return columns;
        }
        LinkedHashMap<String, Column> result = new LinkedHashMap<String, Column>();
        LinkedHashMap metadatas = this.columns(runtime, null, false, new Table(table), false);
        if (metadatas.size() > 0) {
            for (String key : columns.keySet()) {
                if (metadatas.containsKey(key)) {
                    result.put(key, (Column)metadatas.get(key));
                    continue;
                }
                if (!this.IS_LOG_SQL_WARN(configs)) continue;
                log.warn("[{}][column:{}.{}][insert/update\u5ffd\u7565\u5f53\u524d\u5217\u540d]", new Object[]{LogUtil.format((String)"\u5217\u540d\u68c0\u6d4b\u4e0d\u5b58\u5728", (int)33), table, key});
            }
        } else if (this.IS_LOG_SQL_WARN(configs)) {
            log.warn("[{}][table:{}][\u5ffd\u7565\u5217\u540d\u68c0\u6d4b]", (Object)LogUtil.format((String)"\u8868\u7ed3\u6784\u68c0\u6d4b\u5931\u8d25(\u68c0\u67e5\u8868\u540d\u662f\u5426\u5b58\u5728)", (int)33), (Object)table);
        }
        if (this.IS_LOG_SQL_WARN(configs)) {
            log.info("[check column metadata][src:{}][result:{}]", (Object)columns.size(), (Object)result.size());
        }
        return result;
    }

    @Override
    public DataSet querys(DataRuntime runtime, String random, RunPrepare prepare, ConfigStore configs, String ... conditions) {
        DataSet set = null;
        Long fr = System.currentTimeMillis();
        boolean cmd_success = false;
        Run run = null;
        PageNavi navi = null;
        if (null == random) {
            random = this.random(runtime);
        }
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        if (null != this.dmListener) {
            swt = this.dmListener.prepareQuery(runtime, random, prepare, configs, conditions);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return new DataSet();
        }
        swt = InterceptorProxy.prepareQuery(runtime, random, prepare, configs, conditions);
        if (swt == ACTION.SWITCH.BREAK) {
            return new DataSet();
        }
        run = this.buildQueryRun(runtime, prepare, configs, conditions);
        if (log.isWarnEnabled() && this.IS_LOG_SQL(configs) && !run.isValid()) {
            Object tmp = "[valid:false][\u4e0d\u5177\u5907\u6267\u884c\u6761\u4ef6]";
            String src = "";
            src = prepare instanceof TablePrepare ? prepare.getTable() : prepare.getText();
            tmp = (String)tmp + "[RunPrepare:" + ConfigParser.createSQLSign(false, false, src, configs, conditions) + "][thread:" + Thread.currentThread().getId() + "][ds:" + runtime.datasource() + "]";
            log.warn((String)tmp);
        }
        navi = run.getPageNavi();
        long total = 0L;
        if (run.isValid() && null != navi) {
            if (null != this.dmListener) {
                this.dmListener.beforeTotal(runtime, random, run);
            }
            fr = System.currentTimeMillis();
            if (navi.getCalType() == 1 && navi.getLastRow() == 0L) {
                total = 1L;
            } else if (navi.getTotalRow() == 0L) {
                total = this.count(runtime, random, run);
                navi.setTotalRow(total);
            } else {
                total = navi.getTotalRow();
            }
            if (null != this.dmListener) {
                this.dmListener.afterTotal(runtime, random, run, true, total, System.currentTimeMillis() - fr);
            }
            if (log.isInfoEnabled() && this.IS_LOG_SQL(configs)) {
                log.info("[\u67e5\u8be2\u8bb0\u5f55\u603b\u6570][\u884c\u6570:{}]", (Object)total);
            }
        }
        fr = System.currentTimeMillis();
        if (run.isValid()) {
            if (null == navi || total > 0L) {
                if (null != this.dmListener) {
                    this.dmListener.beforeQuery(runtime, random, run, total);
                }
                if ((swt = InterceptorProxy.beforeQuery(runtime, random, run, navi)) == ACTION.SWITCH.BREAK) {
                    return new DataSet();
                }
                set = this.select(runtime, random, false, prepare.getTable(), configs, run);
                cmd_success = true;
            } else {
                if (null != configs) {
                    configs.add(run);
                }
                set = new DataSet();
            }
        } else {
            set = new DataSet();
        }
        set.setDataSource(prepare.getDataSource());
        set.setNavi(navi);
        if (null != navi && navi.isLazy()) {
            PageLazyStore.setTotal(navi.getLazyKey(), navi.getTotalRow());
        }
        if (null != this.dmListener) {
            this.dmListener.afterQuery(runtime, random, run, cmd_success, set, System.currentTimeMillis() - fr);
        }
        InterceptorProxy.afterQuery(runtime, random, run, cmd_success, set, navi, System.currentTimeMillis() - fr);
        return set;
    }

    @Override
    public DataSet querys(DataRuntime runtime, String random, Procedure procedure, PageNavi navi) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 DataSet querys(DataRuntime runtime, String random, Procedure procedure, PageNavi navi)"), (int)37));
        }
        return new DataSet();
    }

    @Override
    public <T> EntitySet<T> selects(DataRuntime runtime, String random, RunPrepare prepare, Class<T> clazz, ConfigStore configs, String ... conditions) {
        if (null == prepare) {
            prepare = new DefaultTablePrepare();
        }
        EntitySet<T> list = null;
        Long fr = System.currentTimeMillis();
        Run run = null;
        boolean cmd_success = false;
        PageNavi navi = null;
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        if (null != this.dmListener) {
            swt = this.dmListener.prepareQuery(runtime, random, prepare, configs, conditions);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return new EntitySet();
        }
        swt = InterceptorProxy.prepareQuery(runtime, random, prepare, configs, conditions);
        if (swt == ACTION.SWITCH.BREAK) {
            return new EntitySet();
        }
        if (BasicUtil.isEmpty((Object)prepare.getDataSource()) && !(prepare instanceof TextPrepare) && !(prepare instanceof XMLPrepare)) {
            prepare.setDataSource(EntityAdapterProxy.table(clazz, (boolean)true));
        }
        run = this.buildQueryRun(runtime, prepare, configs, conditions);
        if (log.isWarnEnabled() && this.IS_LOG_SQL(configs) && !run.isValid()) {
            Object tmp = "[valid:false][\u4e0d\u5177\u5907\u6267\u884c\u6761\u4ef6]";
            tmp = (String)tmp + "[RunPrepare:" + ConfigParser.createSQLSign(false, false, clazz.getName(), configs, conditions) + "][thread:" + Thread.currentThread().getId() + "][ds:" + runtime.datasource() + "]";
            log.warn((String)tmp);
        }
        navi = run.getPageNavi();
        long total = 0L;
        if (run.isValid()) {
            if (null != navi) {
                if (null != this.dmListener) {
                    this.dmListener.beforeTotal(runtime, random, run);
                }
                fr = System.currentTimeMillis();
                if (navi.getCalType() == 1 && navi.getLastRow() == 0L) {
                    total = 1L;
                } else if (navi.getTotalRow() == 0L) {
                    total = this.count(runtime, random, run);
                    navi.setTotalRow(total);
                } else {
                    total = navi.getTotalRow();
                }
                if (null != this.dmListener) {
                    this.dmListener.afterTotal(runtime, random, run, true, total, System.currentTimeMillis() - fr);
                }
            }
            if (log.isInfoEnabled() && this.IS_LOG_SQL(configs)) {
                log.info("[\u67e5\u8be2\u8bb0\u5f55\u603b\u6570][\u884c\u6570:{}]", (Object)total);
            }
        }
        fr = System.currentTimeMillis();
        if (run.isValid()) {
            if (null == navi || total > 0L) {
                swt = InterceptorProxy.beforeQuery(runtime, random, run, navi);
                if (swt == ACTION.SWITCH.BREAK) {
                    return new EntitySet();
                }
                if (null != this.dmListener) {
                    this.dmListener.beforeQuery(runtime, random, run, total);
                }
                fr = System.currentTimeMillis();
                list = this.select(runtime, random, clazz, run.getTable(), configs, run);
                cmd_success = false;
            } else {
                list = new EntitySet();
            }
        } else {
            list = new EntitySet<T>();
        }
        list.setNavi(navi);
        if (null != navi && navi.isLazy()) {
            PageLazyStore.setTotal(navi.getLazyKey(), navi.getTotalRow());
        }
        if (null != this.dmListener) {
            this.dmListener.afterQuery(runtime, random, run, cmd_success, list, System.currentTimeMillis() - fr);
        }
        InterceptorProxy.afterQuery(runtime, random, run, cmd_success, list, navi, System.currentTimeMillis() - fr);
        return list;
    }

    protected <T> EntitySet<T> select(DataRuntime runtime, String random, Class<T> clazz, String table, ConfigStore configs, Run run) {
        EntitySet set = new EntitySet();
        if (null == random) {
            random = this.random(runtime);
        }
        if (null != configs) {
            configs.entityClass(clazz);
        }
        DataSet rows = this.select(runtime, random, false, table, configs, run);
        for (DataRow row : rows) {
            Object entity = null;
            entity = EntityAdapterProxy.hasAdapter(clazz) ? EntityAdapterProxy.entity(clazz, (Map)row, null) : row.entity(clazz, new String[0]);
            set.add(entity);
        }
        return set;
    }

    @Override
    public List<Map<String, Object>> maps(DataRuntime runtime, String random, RunPrepare prepare, ConfigStore configs, String ... conditions) {
        ArrayList<Map<String, Object>> maps = null;
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        boolean cmd_success = false;
        Run run = null;
        if (null == random) {
            random = this.random(runtime);
        }
        if ((swt = InterceptorProxy.prepareQuery(runtime, random, prepare, configs, conditions)) == ACTION.SWITCH.BREAK) {
            return new ArrayList<Map<String, Object>>();
        }
        if (null != this.dmListener) {
            swt = this.dmListener.prepareQuery(runtime, random, prepare, configs, conditions);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return new ArrayList<Map<String, Object>>();
        }
        run = this.buildQueryRun(runtime, prepare, configs, conditions);
        Long fr = System.currentTimeMillis();
        if (log.isWarnEnabled() && this.IS_LOG_SQL(configs) && !run.isValid()) {
            Object tmp = "[valid:false][\u4e0d\u5177\u5907\u6267\u884c\u6761\u4ef6]";
            String src = "";
            src = prepare instanceof TablePrepare ? prepare.getTable() : prepare.getText();
            tmp = (String)tmp + "[RunPrepare:" + ConfigParser.createSQLSign(false, false, src, configs, conditions) + "][thread:" + Thread.currentThread().getId() + "][ds:" + runtime.datasource() + "]";
            log.warn((String)tmp);
        }
        if (run.isValid()) {
            swt = InterceptorProxy.beforeQuery(runtime, random, run, null);
            if (swt == ACTION.SWITCH.BREAK) {
                return new ArrayList<Map<String, Object>>();
            }
            if (null != this.dmListener) {
                this.dmListener.beforeQuery(runtime, random, run, -1L);
            }
            maps = this.maps(runtime, random, configs, run);
            cmd_success = true;
        } else {
            maps = new ArrayList();
        }
        if (null != this.dmListener) {
            this.dmListener.afterQuery(runtime, random, run, cmd_success, maps, System.currentTimeMillis() - fr);
        }
        InterceptorProxy.afterQuery(runtime, random, run, cmd_success, maps, null, System.currentTimeMillis() - fr);
        return maps;
    }

    @Override
    public Run buildQueryRun(DataRuntime runtime, RunPrepare prepare, ConfigStore configs, String ... conditions) {
        BasicRun run = null;
        if (prepare instanceof TablePrepare) {
            run = new TableRun(runtime, prepare.getTable());
        } else if (prepare instanceof XMLPrepare) {
            run = new XMLRun();
        } else if (prepare instanceof TextPrepare) {
            run = new TextRun();
        }
        if (null != run) {
            run.setRuntime(runtime);
            run.setPrepare(prepare);
            run.setConfigStore(configs);
            if (null != configs) {
                List<Object> statics = configs.getStaticValues();
                for (Object item : statics) {
                    run.addValue(new RunValue("none", item));
                }
            }
            run.addCondition(conditions);
            if (run.checkValid()) {
                run.init();
                this.fillQueryContent(runtime, run);
            }
        }
        this.convert(runtime, configs, (Run)run);
        return run;
    }

    @Override
    public List<Run> buildQuerySequence(DataRuntime runtime, boolean next, String ... names) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildQuerySequence(DataRuntime runtime, boolean next, String ... names)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public void fillQueryContent(DataRuntime runtime, Run run) {
        if (null != run) {
            if (run instanceof TableRun) {
                TableRun r = (TableRun)run;
                this.fillQueryContent(runtime, r);
            } else if (run instanceof XMLRun) {
                XMLRun r = (XMLRun)run;
                this.fillQueryContent(runtime, r);
            } else if (run instanceof TextRun) {
                TextRun r = (TextRun)run;
                this.fillQueryContent(runtime, r);
            }
        }
    }

    protected void fillQueryContent(DataRuntime runtime, XMLRun run) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 fillQueryContent(DataRuntime runtime, XMLRun run)"), (int)37));
        }
    }

    protected void fillQueryContent(DataRuntime runtime, TextRun run) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 fillQueryContent(DataRuntime runtime, TextRun run)"), (int)37));
        }
    }

    protected void fillQueryContent(DataRuntime runtime, TableRun run) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 fillQueryContent(DataRuntime runtime, TableRun run)"), (int)37));
        }
    }

    @Override
    public String mergeFinalQuery(DataRuntime runtime, Run run) {
        return null;
    }

    @Override
    public RunValue createConditionLike(DataRuntime runtime, StringBuilder builder, Compare compare, Object value) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 RunValue createConditionLike(DataRuntime runtime, StringBuilder builder, Compare compare, Object value)"), (int)37));
        }
        return null;
    }

    @Override
    public Object createConditionFindInSet(DataRuntime runtime, StringBuilder builder, String column, Compare compare, Object value) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 Object createConditionFindInSet(DataRuntime runtime, StringBuilder builder, String column, Compare compare, Object value)"), (int)37));
        }
        return null;
    }

    @Override
    public StringBuilder createConditionIn(DataRuntime runtime, StringBuilder builder, Compare compare, Object value) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 StringBuilder createConditionIn(DataRuntime runtime, StringBuilder builder, Compare compare, Object value)"), (int)37));
        }
        return null;
    }

    @Override
    public DataSet select(DataRuntime runtime, String random, boolean system, String table, ConfigStore configs, Run run) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 DataSet select(DataRuntime runtime, String random, boolean system, String table, ConfigStore configs, Run run)"), (int)37));
        }
        return new DataSet();
    }

    @Override
    public List<Map<String, Object>> maps(DataRuntime runtime, String random, ConfigStore configs, Run run) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Map<String,Object>> maps(DataRuntime runtime, String random, ConfigStore configs, Run run)"), (int)37));
        }
        return new ArrayList<Map<String, Object>>();
    }

    @Override
    public Map<String, Object> map(DataRuntime runtime, String random, ConfigStore configs, Run run) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 Map<String,Object> map(DataRuntime runtime, String random, ConfigStore configs, Run run)"), (int)37));
        }
        return null;
    }

    @Override
    public DataRow sequence(DataRuntime runtime, String random, boolean next, String ... names) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 DataRow sequence(DataRuntime runtime, String random, boolean next, String ... names)"), (int)37));
        }
        return null;
    }

    @Override
    public List<Map<String, Object>> process(DataRuntime runtime, List<Map<String, Object>> list) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Map<String,Object>> process(DataRuntime runtime, List<Map<String,Object>> list)"), (int)37));
        }
        return new ArrayList<Map<String, Object>>();
    }

    @Override
    public long count(DataRuntime runtime, String random, RunPrepare prepare, ConfigStore configs, String ... conditions) {
        long count = -1L;
        Long fr = System.currentTimeMillis();
        Run run = null;
        if (null == random) {
            random = this.random(runtime);
        }
        boolean cmd_success = false;
        ACTION.SWITCH swt = InterceptorProxy.prepareCount(runtime, random, prepare, configs, conditions);
        if (swt == ACTION.SWITCH.BREAK) {
            return -1L;
        }
        if (null != this.dmListener) {
            swt = this.dmListener.prepareQuery(runtime, random, prepare, configs, conditions);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return -1L;
        }
        run = this.buildQueryRun(runtime, prepare, configs, conditions);
        if (!run.isValid()) {
            if (log.isWarnEnabled() && this.IS_LOG_SQL(configs)) {
                log.warn("[valid:false][\u4e0d\u5177\u5907\u6267\u884c\u6761\u4ef6][RunPrepare:" + ConfigParser.createSQLSign(false, false, prepare.getTable(), configs, conditions) + "][thread:" + Thread.currentThread().getId() + "][ds:" + runtime.datasource() + "]");
            }
            return -1L;
        }
        if (null != this.dmListener) {
            this.dmListener.beforeCount(runtime, random, run);
        }
        if ((swt = InterceptorProxy.beforeCount(runtime, random, run)) == ACTION.SWITCH.BREAK) {
            return -1L;
        }
        fr = System.currentTimeMillis();
        count = this.count(runtime, random, run);
        cmd_success = true;
        if (null != this.dmListener) {
            this.dmListener.afterCount(runtime, random, run, cmd_success, count, System.currentTimeMillis() - fr);
        }
        InterceptorProxy.afterCount(runtime, random, run, cmd_success, count, System.currentTimeMillis() - fr);
        return count;
    }

    @Override
    public String mergeFinalTotal(DataRuntime runtime, Run run) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 String mergeFinalTotal(DataRuntime runtime, Run run)"), (int)37));
        }
        return null;
    }

    @Override
    public long count(DataRuntime runtime, String random, Run run) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 long count(DataRuntime runtime, String random, Run run)"), (int)37));
        }
        return -1L;
    }

    @Override
    public boolean exists(DataRuntime runtime, String random, RunPrepare prepare, ConfigStore configs, String ... conditions) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0  exists(DataRuntime runtime, String random, RunPrepare prepare, ConfigStore configs, String ... conditions)"), (int)37));
        }
        return false;
    }

    @Override
    public String mergeFinalExists(DataRuntime runtime, Run run) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 String mergeFinalExists(DataRuntime runtime, Run run)"), (int)37));
        }
        return null;
    }

    @Override
    public long execute(DataRuntime runtime, String random, RunPrepare prepare, ConfigStore configs, String ... conditions) {
        long result = -1L;
        boolean cmd_success = false;
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        if (null == random) {
            random = this.random(runtime);
        }
        if ((swt = InterceptorProxy.prepareExecute(runtime, random, prepare, configs, conditions)) == ACTION.SWITCH.BREAK) {
            return -1L;
        }
        Run run = this.buildExecuteRun(runtime, prepare, configs, conditions);
        if (!run.isValid()) {
            if (log.isWarnEnabled() && this.IS_LOG_SQL(configs)) {
                log.warn("[valid:false][\u4e0d\u5177\u5907\u6267\u884c\u6761\u4ef6][RunPrepare:" + ConfigParser.createSQLSign(false, false, prepare.getTable(), configs, conditions) + "][thread:" + Thread.currentThread().getId() + "][ds:" + runtime.datasource() + "]");
            }
            return -1L;
        }
        long fr = System.currentTimeMillis();
        long millis = -1L;
        swt = InterceptorProxy.beforeExecute(runtime, random, run);
        if (swt == ACTION.SWITCH.BREAK) {
            return -1L;
        }
        if (null != this.dmListener) {
            swt = this.dmListener.beforeExecute(runtime, random, run);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return -1L;
        }
        result = this.execute(runtime, random, configs, run);
        cmd_success = true;
        if (null != this.dmListener) {
            this.dmListener.afterExecute(runtime, random, run, cmd_success, result, millis);
        }
        InterceptorProxy.afterExecute(runtime, random, run, cmd_success, result, System.currentTimeMillis() - fr);
        return result;
    }

    @Override
    public long execute(DataRuntime runtime, String random, int batch, ConfigStore configs, String cmd, List<Object> values) {
        SimpleRun run = new SimpleRun(runtime);
        if (null == random) {
            random = this.random(runtime);
        }
        StringBuilder builder = run.getBuilder();
        builder.append(cmd);
        run.setValues(null, values);
        Object first = values.get(0);
        if (first instanceof Collection) {
            ArrayList<Object> list = new ArrayList<Object>();
            for (Object object : values) {
                Collection col = (Collection)object;
                list.addAll(col);
            }
            run.setValues(null, list);
        }
        run.setBatch(batch);
        String[] strs = cmd.split("");
        int vol = 0;
        for (String str : strs) {
            if (!str.equals("?")) continue;
            ++vol;
        }
        run.setVol(vol);
        long l = this.execute(runtime, random, configs, run);
        return l;
    }

    @Override
    public boolean execute(DataRuntime runtime, String random, Procedure procedure) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 boolean execute(DataRuntime runtime, String random, Procedure procedure)"), (int)37));
        }
        return false;
    }

    @Override
    public Run buildExecuteRun(DataRuntime runtime, RunPrepare prepare, ConfigStore configs, String ... conditions) {
        BasicRun run = null;
        if (prepare instanceof XMLPrepare) {
            run = new XMLRun();
        } else if (prepare instanceof TextPrepare) {
            run = new TextRun();
        }
        if (null != run) {
            run.setRuntime(runtime);
            run.setPrepare(prepare);
            run.setConfigStore(configs);
            run.addCondition(conditions);
            run.init();
            this.fillQueryContent(runtime, run);
        }
        return run;
    }

    protected void fillExecuteContent(DataRuntime runtime, XMLRun run) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 fillExecuteContent(DataRuntime runtime, XMLRun run)"), (int)37));
        }
    }

    protected void fillExecuteContent(DataRuntime runtime, TextRun run) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 fillExecuteContent(DataRuntime runtime, TextRun run)"), (int)37));
        }
    }

    protected void fillExecuteContent(DataRuntime runtime, TableRun run) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 fillExecuteContent(DataRuntime runtime, TableRun run)"), (int)37));
        }
    }

    @Override
    public void fillExecuteContent(DataRuntime runtime, Run run) {
        if (null != run) {
            if (run instanceof TableRun) {
                TableRun r = (TableRun)run;
                this.fillExecuteContent(runtime, r);
            } else if (run instanceof XMLRun) {
                XMLRun r = (XMLRun)run;
                this.fillExecuteContent(runtime, r);
            } else if (run instanceof TextRun) {
                TextRun r = (TextRun)run;
                this.fillExecuteContent(runtime, r);
            }
        }
    }

    @Override
    public long execute(DataRuntime runtime, String random, ConfigStore configs, Run run) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 long execute(DataRuntime runtime, String random, ConfigStore configs, Run run)"), (int)37));
        }
        return -1L;
    }

    @Override
    public <T> long deletes(DataRuntime runtime, String random, int batch, String table, ConfigStore configs, String key, Collection<T> values) {
        ACTION.SWITCH swt;
        table = DataSourceUtil.parseDataSource(table, null);
        if (null == random) {
            random = this.random(runtime);
        }
        if ((swt = InterceptorProxy.prepareDelete(runtime, random, batch, table, key, values)) == ACTION.SWITCH.BREAK) {
            return -1L;
        }
        if (null != this.dmListener) {
            swt = this.dmListener.prepareDelete(runtime, random, batch, table, key, values);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return -1L;
        }
        Run run = this.buildDeleteRun(runtime, batch, table, key, values);
        if (!run.isValid()) {
            if (log.isWarnEnabled() && this.IS_LOG_SQL(configs)) {
                log.warn("[valid:false][\u4e0d\u5177\u5907\u6267\u884c\u6761\u4ef6][table:" + table + "][thread:" + Thread.currentThread().getId() + "][ds:" + runtime.datasource() + "]");
            }
            return -1L;
        }
        long result = this.delete(runtime, random, configs, run);
        return result;
    }

    @Override
    public long delete(DataRuntime runtime, String random, String dest, ConfigStore configs, Object obj, String ... columns) {
        dest = DataSourceUtil.parseDataSource(dest, obj);
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        long size = 0L;
        if (null != obj) {
            if (obj instanceof Collection) {
                Collection list = (Collection)obj;
                for (Object item : list) {
                    long qty = this.delete(runtime, random, dest, configs, item, columns);
                    if (qty <= 0L) continue;
                    size += qty;
                }
                if (log.isInfoEnabled()) {
                    log.info("[delete Collection][\u5f71\u54cd\u884c\u6570:{}]", (Object)LogUtil.format((long)size, (int)34));
                }
            } else {
                swt = InterceptorProxy.prepareDelete(runtime, random, 0, dest, obj, columns);
                if (swt == ACTION.SWITCH.BREAK) {
                    return -1L;
                }
                if (null != this.dmListener) {
                    swt = this.dmListener.prepareDelete(runtime, random, 0, dest, obj, columns);
                }
                if (swt == ACTION.SWITCH.BREAK) {
                    return -1L;
                }
                Run run = this.buildDeleteRun(runtime, dest, obj, columns);
                if (!run.isValid()) {
                    if (log.isWarnEnabled() && this.IS_LOG_SQL(configs)) {
                        log.warn("[valid:false][\u4e0d\u5177\u5907\u6267\u884c\u6761\u4ef6][dest:" + dest + "][thread:" + Thread.currentThread().getId() + "][ds:" + runtime.datasource() + "]");
                    }
                    return -1L;
                }
                size = this.delete(runtime, random, configs, run);
            }
        }
        return size;
    }

    @Override
    public long delete(DataRuntime runtime, String random, String table, ConfigStore configs, String ... conditions) {
        table = DataSourceUtil.parseDataSource(table, null);
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        swt = InterceptorProxy.prepareDelete(runtime, random, 0, table, configs, conditions);
        if (swt == ACTION.SWITCH.BREAK) {
            return -1L;
        }
        if (null != this.dmListener) {
            swt = this.dmListener.prepareDelete(runtime, random, 0, table, configs, conditions);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return -1L;
        }
        Run run = this.buildDeleteRun(runtime, table, configs, conditions);
        if (!run.isValid()) {
            if (log.isWarnEnabled() && this.IS_LOG_SQL(configs)) {
                log.warn("[valid:false][\u4e0d\u5177\u5907\u6267\u884c\u6761\u4ef6][table:" + table + "][thread:" + Thread.currentThread().getId() + "][ds:" + runtime.datasource() + "]");
            }
            return -1L;
        }
        long result = this.delete(runtime, random, configs, run);
        return result;
    }

    @Override
    public long truncate(DataRuntime runtime, String random, String table) {
        List<Run> runs = this.buildTruncateRun(runtime, table = DataSourceUtil.parseDataSource(table));
        if (null != runs && runs.size() > 0) {
            DefaultTextPrepare prepare = new DefaultTextPrepare(runs.get(0).getFinalUpdate());
            return (int)this.execute(runtime, random, prepare, null, new String[0]);
        }
        return -1L;
    }

    @Override
    public Run buildDeleteRun(DataRuntime runtime, String dest, Object obj, String ... columns) {
        if (null == obj) {
            return null;
        }
        Run run = null;
        if (null == dest) {
            dest = DataSourceUtil.parseDataSource(dest, obj);
        }
        if (null == dest) {
            Table table;
            Object entity = obj;
            if (obj instanceof Collection) {
                entity = ((Collection)obj).iterator().next();
            }
            if (null != (table = EntityAdapterProxy.table(entity.getClass()))) {
                dest = table.getName();
            }
        }
        if (obj instanceof ConfigStore) {
            run = new TableRun(runtime, dest);
            DefaultTablePrepare prepare = new DefaultTablePrepare();
            prepare.setDataSource(dest);
            run.setPrepare(prepare);
            run.setConfigStore((ConfigStore)obj);
            run.addCondition(columns);
            run.init();
            this.fillDeleteRunContent(runtime, run);
        } else {
            run = this.buildDeleteRunFromEntity(runtime, dest, obj, columns);
        }
        this.convert(runtime, new DefaultConfigStore(new String[0]), run);
        return run;
    }

    @Override
    public Run buildDeleteRun(DataRuntime runtime, int batch, String table, String key, Object values) {
        Run run = this.buildDeleteRunFromTable(runtime, batch, table, key, values);
        this.convert(runtime, new DefaultConfigStore(new String[0]), run);
        return run;
    }

    @Override
    public List<Run> buildTruncateRun(DataRuntime runtime, String table) {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun(runtime);
        runs.add(run);
        StringBuilder builder = run.getBuilder();
        builder.append("TRUNCATE TABLE ");
        this.delimiter(builder, table);
        return runs;
    }

    @Override
    public Run buildDeleteRunFromTable(DataRuntime runtime, int batch, String table, String column, Object values) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 Run buildDeleteRunFromTable(DataRuntime runtime, int batch, String table, String column, Object values)"), (int)37));
        }
        return null;
    }

    @Override
    public Run buildDeleteRunFromEntity(DataRuntime runtime, String table, Object obj, String ... columns) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 Run buildDeleteRunFromEntity(DataRuntime runtime, String table, Object obj, String... columns)"), (int)37));
        }
        return null;
    }

    @Override
    public void fillDeleteRunContent(DataRuntime runtime, Run run) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 void fillDeleteRunContent(DataRuntime runtime, Run run)"), (int)37));
        }
    }

    @Override
    public long delete(DataRuntime runtime, String random, ConfigStore configs, Run run) {
        long result = -1L;
        boolean cmd_success = false;
        if (null == random) {
            random = this.random(runtime);
        }
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        long fr = System.currentTimeMillis();
        swt = InterceptorProxy.beforeDelete(runtime, random, run);
        if (swt == ACTION.SWITCH.BREAK) {
            return -1L;
        }
        if (null != this.dmListener) {
            swt = this.dmListener.beforeDelete(runtime, random, run);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return -1L;
        }
        long millis = -1L;
        result = this.execute(runtime, random, configs, run);
        cmd_success = true;
        millis = System.currentTimeMillis() - fr;
        if (null != this.dmListener) {
            this.dmListener.afterDelete(runtime, random, run, cmd_success, result, millis);
        }
        InterceptorProxy.afterDelete(runtime, random, run, cmd_success, result, millis);
        return result;
    }

    @Override
    public List<Database> databases(DataRuntime runtime, String random, boolean greedy, String name) {
        if (null == random) {
            random = this.random(runtime);
        }
        List<Database> databases = new ArrayList<Database>();
        try {
            long fr;
            block10: {
                fr = System.currentTimeMillis();
                try {
                    List<Run> runs = this.buildQueryDatabaseRun(runtime, greedy, name);
                    if (null != runs) {
                        int idx = 0;
                        for (Run run : runs) {
                            DataSet set = this.select(runtime, random, true, null, new DefaultConfigStore(new String[0]).keyCase(KeyAdapter.KEY_CASE.PUT_UPPER), run).toUpperKey();
                            databases = this.databases(runtime, idx++, true, databases, set);
                        }
                    }
                }
                catch (Exception e) {
                    if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                        e.printStackTrace();
                    }
                    if (!ConfigTable.IS_LOG_SQL || !log.isWarnEnabled()) break block10;
                    log.warn("{}[databases][{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u6839\u636e\u7cfb\u7edf\u8868\u67e5\u8be2\u5931\u8d25", (int)33), e.toString()});
                }
            }
            if (ConfigTable.IS_LOG_SQL_TIME && log.isInfoEnabled()) {
                log.info("{}[databases][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, databases.size(), System.currentTimeMillis() - fr});
            }
        }
        catch (Exception e) {
            if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                e.printStackTrace();
            }
            log.error("[databases][result:fail][msg:{}]", (Object)e.toString());
        }
        return databases;
    }

    @Override
    public LinkedHashMap<String, Database> databases(DataRuntime runtime, String random, String name) {
        if (null == random) {
            random = this.random(runtime);
        }
        LinkedHashMap<String, Database> databases = new LinkedHashMap<String, Database>();
        try {
            long fr;
            block10: {
                fr = System.currentTimeMillis();
                try {
                    List<Run> runs = this.buildQueryDatabaseRun(runtime, false, name);
                    if (null != runs) {
                        int idx = 0;
                        for (Run run : runs) {
                            DataSet set = this.select(runtime, random, true, null, new DefaultConfigStore(new String[0]).keyCase(KeyAdapter.KEY_CASE.PUT_UPPER), run).toUpperKey();
                            databases = this.databases(runtime, idx++, true, databases, set);
                        }
                    }
                }
                catch (Exception e) {
                    if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                        e.printStackTrace();
                    }
                    if (!ConfigTable.IS_LOG_SQL || !log.isWarnEnabled()) break block10;
                    log.warn("{}[databases][{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u6839\u636e\u7cfb\u7edf\u8868\u67e5\u8be2\u5931\u8d25", (int)33), e.toString()});
                }
            }
            if (ConfigTable.IS_LOG_SQL_TIME && log.isInfoEnabled()) {
                log.info("{}[databases][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, databases.size(), System.currentTimeMillis() - fr});
            }
        }
        catch (Exception e) {
            if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                e.printStackTrace();
            }
            log.error("[databases][result:fail][msg:{}]", (Object)e.toString());
        }
        return databases;
    }

    @Override
    public List<Run> buildQueryDatabaseRun(DataRuntime runtime, boolean greedy, String name) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildQueryDatabaseRun(DataRuntime runtime, boolean greedy, String name)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public LinkedHashMap<String, Database> databases(DataRuntime runtime, int index, boolean create, LinkedHashMap<String, Database> databases, DataSet set) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 LinkedHashMap<String, Database> databases(DataRuntime runtime, int index, boolean create, LinkedHashMap<String, Database> databases, DataSet set)"), (int)37));
        }
        return new LinkedHashMap<String, Database>();
    }

    @Override
    public List<Database> databases(DataRuntime runtime, int index, boolean create, List<Database> databases, DataSet set) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Database> databases(DataRuntime runtime, int index, boolean create, List<Database> databases, DataSet set)"), (int)37));
        }
        return new ArrayList<Database>();
    }

    @Override
    public Database database(DataRuntime runtime, int index, boolean create, DataSet set) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 Database database(DataRuntime runtime, int index, boolean create, DataSet set)"), (int)37));
        }
        return null;
    }

    @Override
    public LinkedHashMap<String, Catalog> catalogs(DataRuntime runtime, String random, String name) {
        if (null == random) {
            random = this.random(runtime);
        }
        LinkedHashMap<String, Catalog> catalogs = new LinkedHashMap<String, Catalog>();
        try {
            long fr;
            block10: {
                fr = System.currentTimeMillis();
                try {
                    List<Run> runs = this.buildQueryCatalogRun(runtime, false, name);
                    if (null != runs) {
                        int idx = 0;
                        for (Run run : runs) {
                            DataSet set = this.select(runtime, random, true, null, new DefaultConfigStore(new String[0]).keyCase(KeyAdapter.KEY_CASE.PUT_UPPER), run).toUpperKey();
                            catalogs = this.catalogs(runtime, idx++, true, catalogs, set);
                        }
                    }
                }
                catch (Exception e) {
                    if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                        e.printStackTrace();
                    }
                    if (!ConfigTable.IS_LOG_SQL || !log.isWarnEnabled()) break block10;
                    log.warn("{}[catalogs][{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u6839\u636e\u7cfb\u7edf\u8868\u67e5\u8be2\u5931\u8d25", (int)33), e.toString()});
                }
            }
            if (ConfigTable.IS_LOG_SQL_TIME && log.isInfoEnabled()) {
                log.info("{}[catalogs][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, catalogs.size(), System.currentTimeMillis() - fr});
            }
        }
        catch (Exception e) {
            if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                e.printStackTrace();
            }
            log.error("[catalogs][result:fail][msg:{}]", (Object)e.toString());
        }
        return catalogs;
    }

    @Override
    public List<Catalog> catalogs(DataRuntime runtime, String random, boolean greedy, String name) {
        if (null == random) {
            random = this.random(runtime);
        }
        List<Catalog> catalogs = new ArrayList<Catalog>();
        try {
            long fr;
            block10: {
                fr = System.currentTimeMillis();
                try {
                    List<Run> runs = this.buildQueryCatalogRun(runtime, greedy, name);
                    if (null != runs) {
                        int idx = 0;
                        for (Run run : runs) {
                            DataSet set = this.select(runtime, random, true, null, new DefaultConfigStore(new String[0]).keyCase(KeyAdapter.KEY_CASE.PUT_UPPER), run).toUpperKey();
                            catalogs = this.catalogs(runtime, idx++, true, catalogs, set);
                        }
                    }
                }
                catch (Exception e) {
                    if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                        e.printStackTrace();
                    }
                    if (!ConfigTable.IS_LOG_SQL || !log.isWarnEnabled()) break block10;
                    log.warn("{}[catalogs][{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u6839\u636e\u7cfb\u7edf\u8868\u67e5\u8be2\u5931\u8d25", (int)33), e.toString()});
                }
            }
            if (ConfigTable.IS_LOG_SQL_TIME && log.isInfoEnabled()) {
                log.info("{}[catalogs][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, catalogs.size(), System.currentTimeMillis() - fr});
            }
        }
        catch (Exception e) {
            if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                e.printStackTrace();
            }
            log.error("[catalogs][result:fail][msg:{}]", (Object)e.toString());
        }
        return catalogs;
    }

    @Override
    public List<Run> buildQueryCatalogRun(DataRuntime runtime, boolean greedy, String name) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildQueryCatalogRun(DataRuntime runtime, boolean greedy, String name)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public LinkedHashMap<String, Catalog> catalogs(DataRuntime runtime, int index, boolean create, LinkedHashMap<String, Catalog> catalogs, DataSet set) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 LinkedHashMap<String, Catalog> catalogs(DataRuntime runtime, int index, boolean create, LinkedHashMap<String, Catalog> catalogs, DataSet set)"), (int)37));
        }
        return new LinkedHashMap<String, Catalog>();
    }

    @Override
    public List<Catalog> catalogs(DataRuntime runtime, int index, boolean create, List<Catalog> catalogs, DataSet set) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Catalog> catalogs(DataRuntime runtime, int index, boolean create, List<Catalog> catalogs, DataSet set)"), (int)37));
        }
        return new ArrayList<Catalog>();
    }

    @Override
    public LinkedHashMap<String, Catalog> catalogs(DataRuntime runtime, boolean create, LinkedHashMap<String, Catalog> catalogs) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 LinkedHashMap<String, Catalog> catalogs(DataRuntime runtime, boolean create, LinkedHashMap<String, Catalog> catalogs)"), (int)37));
        }
        return new LinkedHashMap<String, Catalog>();
    }

    @Override
    public List<Catalog> catalogs(DataRuntime runtime, boolean create, List<Catalog> catalogs) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Catalog> catalogs(DataRuntime runtime, boolean create, List<Catalog> catalogs)"), (int)37));
        }
        return new ArrayList<Catalog>();
    }

    @Override
    public Catalog catalog(DataRuntime runtime, int index, boolean create, DataSet set) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 Catalog catalog(DataRuntime runtime, int index, boolean create, DataSet set)"), (int)37));
        }
        return null;
    }

    @Override
    public LinkedHashMap<String, Schema> schemas(DataRuntime runtime, String random, Catalog catalog, String name) {
        if (null == random) {
            random = this.random(runtime);
        }
        LinkedHashMap<String, Schema> schemas = new LinkedHashMap<String, Schema>();
        try {
            long fr;
            block10: {
                fr = System.currentTimeMillis();
                try {
                    List<Run> runs = this.buildQuerySchemaRun(runtime, false, catalog, name);
                    if (null != runs) {
                        int idx = 0;
                        for (Run run : runs) {
                            DataSet set = this.select(runtime, random, true, null, new DefaultConfigStore(new String[0]).keyCase(KeyAdapter.KEY_CASE.PUT_UPPER), run).toUpperKey();
                            schemas = this.schemas(runtime, idx++, true, schemas, set);
                        }
                    }
                }
                catch (Exception e) {
                    if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                        e.printStackTrace();
                    }
                    if (!ConfigTable.IS_LOG_SQL || !log.isWarnEnabled()) break block10;
                    log.warn("{}[schemas][{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u6839\u636e\u7cfb\u7edf\u8868\u67e5\u8be2\u5931\u8d25", (int)33), e.toString()});
                }
            }
            if (ConfigTable.IS_LOG_SQL_TIME && log.isInfoEnabled()) {
                log.info("{}[schemas][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, schemas.size(), System.currentTimeMillis() - fr});
            }
        }
        catch (Exception e) {
            if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                e.printStackTrace();
            }
            log.error("[schemas][result:fail][msg:{}]", (Object)e.toString());
        }
        return schemas;
    }

    @Override
    public List<Schema> schemas(DataRuntime runtime, String random, boolean greedy, Catalog catalog, String name) {
        if (null == random) {
            random = this.random(runtime);
        }
        List<Schema> schemas = new ArrayList<Schema>();
        try {
            long fr;
            block10: {
                fr = System.currentTimeMillis();
                try {
                    List<Run> runs = this.buildQuerySchemaRun(runtime, greedy, catalog, name);
                    if (null != runs) {
                        int idx = 0;
                        for (Run run : runs) {
                            DataSet set = this.select(runtime, random, true, null, new DefaultConfigStore(new String[0]).keyCase(KeyAdapter.KEY_CASE.PUT_UPPER), run).toUpperKey();
                            schemas = this.schemas(runtime, idx++, true, schemas, set);
                        }
                    }
                }
                catch (Exception e) {
                    if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                        e.printStackTrace();
                    }
                    if (!ConfigTable.IS_LOG_SQL || !log.isWarnEnabled()) break block10;
                    log.warn("{}[schemas][{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u6839\u636e\u7cfb\u7edf\u8868\u67e5\u8be2\u5931\u8d25", (int)33), e.toString()});
                }
            }
            if (ConfigTable.IS_LOG_SQL_TIME && log.isInfoEnabled()) {
                log.info("{}[schemas][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, schemas.size(), System.currentTimeMillis() - fr});
            }
        }
        catch (Exception e) {
            if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                e.printStackTrace();
            }
            log.error("[schemas][result:fail][msg:{}]", (Object)e.toString());
        }
        return schemas;
    }

    @Override
    public List<Run> buildQuerySchemaRun(DataRuntime runtime, boolean greedy, Catalog catalog, String name) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildQuerySchemaRun(DataRuntime runtime, boolean greedy, Catalog catalog, String name)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public LinkedHashMap<String, Schema> schemas(DataRuntime runtime, int index, boolean create, LinkedHashMap<String, Schema> schemas, DataSet set) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 LinkedHashMap<String, Schema> schemas(DataRuntime runtime, int index, boolean create, LinkedHashMap<String, Schema> schemas, DataSet set)"), (int)37));
        }
        return new LinkedHashMap<String, Schema>();
    }

    @Override
    public List<Schema> schemas(DataRuntime runtime, int index, boolean create, List<Schema> schemas, DataSet set) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Schema> schemas(DataRuntime runtime, int index, boolean create, List<Schema> schemas, DataSet set)"), (int)37));
        }
        return new ArrayList<Schema>();
    }

    @Override
    public LinkedHashMap<String, Schema> schemas(DataRuntime runtime, boolean create, LinkedHashMap<String, Schema> schemas) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 LinkedHashMap<String, Schema> schemas(DataRuntime runtime, boolean create, LinkedHashMap<String, Schema> schemas)"), (int)37));
        }
        return new LinkedHashMap<String, Schema>();
    }

    @Override
    public List<Schema> schemas(DataRuntime runtime, boolean create, List<Schema> schemas) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Schema> schemas(DataRuntime runtime, boolean create, List<Schema> schemas)"), (int)37));
        }
        return new ArrayList<Schema>();
    }

    @Override
    public Schema schema(DataRuntime runtime, int index, boolean create, DataSet set) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 Schema schema(DataRuntime runtime, int index, boolean create, DataSet set)"), (int)37));
        }
        return null;
    }

    @Override
    public <T extends Table> List<T> tables(DataRuntime runtime, String random, boolean greedy, Catalog catalog, Schema schema, String pattern, String types, boolean strut) {
        List list = new ArrayList();
        if (null == random) {
            random = this.random(runtime);
        }
        try {
            String origin;
            long fr;
            block37: {
                String[] tps;
                block36: {
                    fr = System.currentTimeMillis();
                    Table search = new Table();
                    if (null == catalog || null == schema) {
                        Table tmp = new Table();
                        if (!greedy) {
                            this.checkSchema(runtime, tmp);
                        }
                        if (null == catalog) {
                            catalog = tmp.getCatalog();
                        }
                        if (null == schema) {
                            schema = tmp.getSchema();
                        }
                    }
                    if (null == (origin = CacheProxy.name(greedy, catalog, schema, pattern)) && ConfigTable.IS_METADATA_IGNORE_CASE) {
                        this.tableMap(runtime, random, greedy, catalog, schema);
                        origin = CacheProxy.name(greedy, catalog, schema, pattern);
                    }
                    if (null == origin) {
                        origin = pattern;
                    }
                    search.setName(origin);
                    search.setCatalog(catalog);
                    search.setSchema(schema);
                    tps = null;
                    if (null != types) {
                        tps = types.toUpperCase().trim().split(",");
                    }
                    try {
                        List<Run> runs = this.buildQueryTableRun(runtime, greedy, catalog, schema, origin, types);
                        if (null != runs) {
                            int idx = 0;
                            for (Run run : runs) {
                                DataSet set = this.select(runtime, random, true, (String)null, new DefaultConfigStore(new String[0]).keyCase(KeyAdapter.KEY_CASE.PUT_UPPER), run).toUpperKey();
                                list = this.tables(runtime, idx++, true, catalog, schema, list, set);
                            }
                        }
                    }
                    catch (Exception e) {
                        if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                            e.printStackTrace();
                        }
                        if (!ConfigTable.IS_LOG_SQL || !log.isWarnEnabled()) break block36;
                        log.warn("{}[tables][{}][catalog:{}][schema:{}][pattern:{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u6839\u636e\u7cfb\u7edf\u8868\u67e5\u8be2\u5931\u8d25", (int)33), catalog, schema, origin, e.toString()});
                    }
                }
                if (list.size() == 0) {
                    try {
                        list = this.tables(runtime, true, list, catalog, schema, origin, tps);
                        if (!greedy) {
                            int size = list.size();
                            for (int i = size - 1; i >= 0; --i) {
                                Table item = (Table)list.get(i);
                                if ((catalog + "_" + schema).equalsIgnoreCase(item.getCatalog() + "_" + item.getSchema())) continue;
                                list.remove(i);
                            }
                        }
                    }
                    catch (Exception e) {
                        if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                            e.printStackTrace();
                        }
                        log.warn("{}[tables][catalog:{}][schema:{}][pattern:{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u6839\u636e\u9a71\u52a8\u5185\u7f6e\u63a5\u53e3\u8865\u5145\u5931\u8d25", (int)33), catalog, schema, origin, e.toString()});
                    }
                }
                boolean comment = false;
                for (Table table : list) {
                    if (!BasicUtil.isNotEmpty((Object)table.getComment())) continue;
                    comment = true;
                    break;
                }
                if (!comment) {
                    try {
                        List<Run> runs = this.buildQueryTableCommentRun(runtime, catalog, schema, null, types);
                        if (null != runs) {
                            int idx = 0;
                            for (Run run : runs) {
                                DataSet set = this.select(runtime, random, true, (String)null, new DefaultConfigStore(new String[0]).keyCase(KeyAdapter.KEY_CASE.PUT_UPPER), run).toUpperKey();
                                list = this.comments(runtime, idx++, true, catalog, schema, list, set);
                            }
                        }
                    }
                    catch (Exception e) {
                        if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                            e.printStackTrace();
                        }
                        if (!ConfigTable.IS_LOG_SQL || !log.isWarnEnabled()) break block37;
                        log.info("{}[tables][{}][catalog:{}][schema:{}][pattern:{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u6839\u636e\u7cfb\u7edf\u8868\u67e5\u8be2\u5931\u8d25", (int)33), catalog, schema, origin, e.toString()});
                    }
                }
            }
            if (ConfigTable.IS_LOG_SQL_TIME && log.isInfoEnabled()) {
                log.info("{}[tables][catalog:{}][schema:{}][pattern:{}][type:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, catalog, schema, origin, types, list.size(), System.currentTimeMillis() - fr});
            }
            if (BasicUtil.isNotEmpty((Object)origin)) {
                origin = origin.replace("%", ".*");
                ArrayList<Table> tmp = new ArrayList<Table>();
                for (Table table : list) {
                    String name = table.getName(greedy);
                    if (!RegularUtil.match((String)name, (String)origin)) continue;
                    tmp.add(table);
                }
                list = tmp;
            }
            if (strut) {
                List<T> columns = this.columns(runtime, random, greedy, catalog, schema, pattern);
                for (Table table : list) {
                    String tName = table.getName();
                    Catalog tCatalog = table.getCatalog();
                    Schema tSchema = table.getSchema();
                    Long tObjectId = table.getObjectId();
                    LinkedHashMap<String, Column> cols = new LinkedHashMap<String, Column>();
                    table.setColumns(cols);
                    for (Column column : columns) {
                        if (!tName.equalsIgnoreCase(column.getTableName(false))) continue;
                        Catalog cCatalog = column.getCatalog();
                        Schema cSchema = column.getSchema();
                        Long cObjectId = column.getObjectId();
                        if (null != tObjectId && null != cObjectId && tObjectId == cObjectId) {
                            cols.put(column.getName().toUpperCase(), column);
                            continue;
                        }
                        if (null != cCatalog && !cCatalog.equals(tCatalog) || null != cSchema && !cSchema.equal(tSchema)) continue;
                        cols.put(column.getName().toUpperCase(), column);
                    }
                    columns.removeAll(cols.values());
                }
            }
        }
        catch (Exception e) {
            if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                e.printStackTrace();
            }
            log.error("[tables][result:fail][msg:{}]", (Object)e.toString());
        }
        return list;
    }

    protected void tableMap(DataRuntime runtime, String random, boolean greedy, Catalog catalog, Schema schema) {
        Map<String, String> names = CacheProxy.names(catalog, schema);
        if (null == names || names.isEmpty()) {
            if (null == random) {
                random = this.random(runtime);
            }
            DriverAdapter adapter = runtime.getAdapter();
            List<Table> tables = null;
            boolean sys = false;
            if (greedy) {
                catalog = null;
                schema = null;
            }
            try {
                List<Run> runs = this.buildQueryTableRun(runtime, greedy, catalog, schema, null, null);
                if (null != runs && runs.size() > 0) {
                    int idx = 0;
                    for (Run run : runs) {
                        DataSet set = this.select(runtime, random, true, (String)null, new DefaultConfigStore(new String[0]).keyCase(KeyAdapter.KEY_CASE.PUT_UPPER), run).toUpperKey();
                        tables = this.tables(runtime, idx++, true, catalog, schema, tables, set);
                        CacheProxy.name(tables);
                        sys = true;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (!sys) {
                try {
                    tables = this.tables(runtime, true, tables, catalog, schema, null, null);
                    CacheProxy.name(tables);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public <T extends Table> LinkedHashMap<String, T> tables(DataRuntime runtime, String random, Catalog catalog, Schema schema, String pattern, String types, boolean strut) {
        LinkedHashMap<String, Table> tables = new LinkedHashMap<String, Table>();
        List list = this.tables(runtime, random, false, catalog, schema, pattern, types);
        for (Table table : list) {
            tables.put(table.getName().toUpperCase(), table);
        }
        return tables;
    }

    @Override
    public List<Run> buildQueryTableRun(DataRuntime runtime, boolean greedy, Catalog catalog, Schema schema, String pattern, String types) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildQueryTableRun(DataRuntime runtime, Catalog catalog, Schema schema, String pattern, String types)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildQueryTableCommentRun(DataRuntime runtime, Catalog catalog, Schema schema, String pattern, String types) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildQueryTableCommentRun(DataRuntime runtime, Catalog catalog, Schema schema, String pattern, String types)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public <T extends Table> LinkedHashMap<String, T> tables(DataRuntime runtime, int index, boolean create, Catalog catalog, Schema schema, LinkedHashMap<String, T> tables, DataSet set) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 <T extends Table> LinkedHashMap<String, T> tables(DataRuntime runtime, int index, boolean create, Catalog catalog, Schema schema, LinkedHashMap<String, T> tables, DataSet set)"), (int)37));
        }
        if (null == tables) {
            tables = new LinkedHashMap();
        }
        return tables;
    }

    @Override
    public <T extends Table> List<T> tables(DataRuntime runtime, int index, boolean create, Catalog catalog, Schema schema, List<T> tables, DataSet set) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 <T extends Table> List<T> tables(DataRuntime runtime, int index, boolean create, Catalog catalog, Schema schema, List<T> tables, DataSet set)"), (int)37));
        }
        if (null == tables) {
            tables = new ArrayList<T>();
        }
        return tables;
    }

    @Override
    public <T extends Table> LinkedHashMap<String, T> tables(DataRuntime runtime, boolean create, LinkedHashMap<String, T> tables, Catalog catalog, Schema schema, String pattern, String ... types) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 <T extends Table> LinkedHashMap<String, T> tables(DataRuntime runtime, boolean create, LinkedHashMap<String, T> tables, Catalog catalog, Schema schema, String pattern, String ... types)"), (int)37));
        }
        if (null == tables) {
            tables = new LinkedHashMap();
        }
        return tables;
    }

    @Override
    public <T extends Table> List<T> tables(DataRuntime runtime, boolean create, List<T> tables, Catalog catalog, Schema schema, String pattern, String ... types) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 <T extends Table> List<T> tables(DataRuntime runtime, boolean create, List<T> tables, Catalog catalog, Schema schema, String pattern, String ... types)"), (int)37));
        }
        if (null == tables) {
            tables = new ArrayList<T>();
        }
        return tables;
    }

    @Override
    public <T extends Table> LinkedHashMap<String, T> comments(DataRuntime runtime, int index, boolean create, Catalog catalog, Schema schema, LinkedHashMap<String, T> tables, DataSet set) throws Exception {
        if (null == tables) {
            tables = new LinkedHashMap();
        }
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 <T extends Table> LinkedHashMap<String, T> comments(DataRuntime runtime, int index, boolean create, Catalog catalog, Schema schema, LinkedHashMap<String, T> tables, DataSet set)"), (int)37));
        }
        return tables;
    }

    public <T extends Table> List<T> comments(DataRuntime runtime, int index, boolean create, Catalog catalog, Schema schema, List<T> tables, DataSet set) throws Exception {
        if (null == tables) {
            tables = new ArrayList<T>();
        }
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0  <T extends Table> List<T> comments(DataRuntime runtime, int index, boolean create, Catalog catalog, Schema schema, List<T> tables, DataSet set)"), (int)37));
        }
        return tables;
    }

    @Override
    public List<String> ddl(DataRuntime runtime, String random, Table table, boolean init) {
        List<String> list;
        block11: {
            list = new ArrayList<String>();
            if (null == random) {
                random = this.random(runtime);
            }
            try {
                long fr = System.currentTimeMillis();
                List<Run> runs = this.buildQueryDDLRun(runtime, table);
                if (null != runs && runs.size() > 0) {
                    int idx = 0;
                    for (Run run : runs) {
                        DataSet set = this.select(runtime, random, true, null, new DefaultConfigStore(new String[0]).keyCase(KeyAdapter.KEY_CASE.PUT_UPPER), run).toUpperKey();
                        list = this.ddl(runtime, idx++, table, list, set);
                    }
                    table.setDdls(list);
                } else {
                    LinkedHashMap columns = this.columns(runtime, random, false, table, true);
                    table.setColumns(columns);
                    table.setTags(this.tags(runtime, random, false, table));
                    PrimaryKey pk = this.primary(runtime, random, false, table);
                    if (null != pk) {
                        for (String col : pk.getColumns().keySet()) {
                            Column column = (Column)columns.get(col.toUpperCase());
                            if (null == column) continue;
                            column.primary(Boolean.valueOf(true));
                        }
                    }
                    table.setPrimaryKey(pk);
                    table.setIndexs(this.indexs(runtime, random, table, null));
                    runs = this.buildCreateRun(runtime, table);
                    for (Run run : runs) {
                        list.add(run.getFinalUpdate());
                        table.setDdls(list);
                    }
                }
                if (ConfigTable.IS_LOG_SQL_TIME && log.isInfoEnabled()) {
                    log.info("{}[table ddl][table:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, table.getName(), list.size(), System.currentTimeMillis() - fr});
                }
            }
            catch (Exception e) {
                if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                    e.printStackTrace();
                }
                if (!ConfigTable.IS_LOG_SQL || !log.isWarnEnabled()) break block11;
                log.info("{}[table ddl][{}][table:{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u67e5\u8be2\u8868\u7684\u521b\u5efaDDL\u5931\u8d25", (int)33), table.getName(), e.toString()});
            }
        }
        return list;
    }

    @Override
    public List<Run> buildQueryDDLRun(DataRuntime runtime, Table table) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildQueryDDLRun(DataRuntime runtime, Table table)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<String> ddl(DataRuntime runtime, int index, Table table, List<String> ddls, DataSet set) {
        if (null == ddls) {
            ddls = new ArrayList<String>();
        }
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<String> ddl(DataRuntime runtime, int index, Table table, List<String> ddls, DataSet set)"), (int)37));
        }
        return ddls;
    }

    @Override
    public <T extends View> LinkedHashMap<String, T> views(DataRuntime runtime, String random, boolean greedy, Catalog catalog, Schema schema, String pattern, String types) {
        LinkedHashMap<Object, Object> views = new LinkedHashMap();
        if (null == random) {
            random = this.random(runtime);
        }
        try {
            LinkedHashMap<String, Object> tmps;
            String[] tps;
            long fr;
            block25: {
                fr = System.currentTimeMillis();
                View search = new View();
                if (null == catalog || null == schema) {
                    View tmp = new View();
                    if (!greedy) {
                        this.checkSchema(runtime, tmp);
                    }
                    if (null == catalog) {
                        catalog = tmp.getCatalog();
                    }
                    if (null == schema) {
                        schema = tmp.getSchema();
                    }
                }
                search.setName(pattern);
                search.setCatalog(catalog);
                search.setSchema(schema);
                tps = null;
                tps = null != types ? types.toUpperCase().trim().split(",") : new String[]{"VIEW"};
                DataRow view_map = CacheProxy.getViewMaps(runtime.datasource());
                if (null != pattern) {
                    if (view_map.isEmpty()) {
                        LinkedHashMap<String, T> all = this.views(runtime, random, greedy, catalog, schema, null, types);
                        if (!greedy) {
                            for (View view : all.values()) {
                                if (!(catalog + "_" + schema).equals(view.getCatalog() + "_" + view.getSchema())) continue;
                                view_map.put(view.getName(greedy).toUpperCase(), (Object)view.getName(greedy));
                            }
                        }
                    }
                    pattern = view_map.containsKey(search.getName(greedy).toUpperCase()) ? view_map.getString(search.getName(greedy).toUpperCase()) : search.getName(greedy);
                }
                try {
                    List<Run> runs = this.buildQueryViewRun(runtime, greedy, catalog, schema, pattern, types);
                    if (null != runs) {
                        int idx = 0;
                        for (Run run : runs) {
                            DataSet set = this.select(runtime, random, true, (String)null, new DefaultConfigStore(new String[0]).keyCase(KeyAdapter.KEY_CASE.PUT_UPPER), run).toUpperKey();
                            views = this.views(runtime, idx++, true, catalog, schema, views, set);
                        }
                    }
                }
                catch (Exception e) {
                    if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                        e.printStackTrace();
                    }
                    if (!ConfigTable.IS_LOG_SQL || !log.isWarnEnabled()) break block25;
                    log.warn("{}[views][{}][catalog:{}][schema:{}][pattern:{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u6839\u636e\u7cfb\u7edf\u8868\u67e5\u8be2\u5931\u8d25", (int)33), catalog, schema, pattern, e.toString()});
                }
            }
            if (null == views || views.isEmpty()) {
                try {
                    tmps = this.views(runtime, true, null, catalog, schema, pattern, tps);
                    for (String key : tmps.keySet()) {
                        View item;
                        if (views.containsKey(key.toUpperCase()) || null == (item = (View)tmps.get(key)) || !greedy && !(catalog + "_" + schema).equalsIgnoreCase(item.getCatalog() + "_" + item.getSchema())) continue;
                        views.put(key.toUpperCase(), item);
                    }
                }
                catch (Exception e) {
                    if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                        e.printStackTrace();
                    }
                    log.warn("{}[views][][catalog:{}][schema:{}][pattern:{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u6839\u636e\u9a71\u52a8\u5185\u7f6e\u63a5\u53e3\u8865\u5145\u5931\u8d25", (int)33), catalog, schema, pattern, e.toString()});
                }
            }
            if (ConfigTable.IS_LOG_SQL_TIME && log.isInfoEnabled()) {
                log.info("{}[views][catalog:{}][schema:{}][pattern:{}][type:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, catalog, schema, pattern, types, views.size(), System.currentTimeMillis() - fr});
            }
            if (BasicUtil.isNotEmpty((Object)pattern)) {
                pattern = pattern.replace("%", ".*");
                tmps = new LinkedHashMap();
                List keys = BeanUtil.getMapKeys(views);
                for (String key : keys) {
                    View item = (View)views.get(key);
                    String name = item.getName(greedy);
                    if (!RegularUtil.match((String)name, (String)pattern)) continue;
                    tmps.put(name.toUpperCase(), item);
                }
                views = tmps;
            }
        }
        catch (Exception e) {
            if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                e.printStackTrace();
            }
            log.error("[views][result:fail][msg:{}]", (Object)e.toString());
        }
        return views;
    }

    @Override
    public List<Run> buildQueryViewRun(DataRuntime runtime, boolean greedy, Catalog catalog, Schema schema, String pattern, String types) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildQueryViewRun(DataRuntime runtime, Catalog catalog, Schema schema, String pattern, String types)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public <T extends View> LinkedHashMap<String, T> views(DataRuntime runtime, int index, boolean create, Catalog catalog, Schema schema, LinkedHashMap<String, T> views, DataSet set) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 <T extends View> LinkedHashMap<String, T> views(DataRuntime runtime, int index, boolean create, Catalog catalog, Schema schema, LinkedHashMap<String, T> views, DataSet set)"), (int)37));
        }
        if (null == views) {
            views = new LinkedHashMap();
        }
        return views;
    }

    @Override
    public <T extends View> LinkedHashMap<String, T> views(DataRuntime runtime, boolean create, LinkedHashMap<String, T> views, Catalog catalog, Schema schema, String pattern, String ... types) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 <T extends View> LinkedHashMap<String, T> views(DataRuntime runtime, boolean create, LinkedHashMap<String, T> views, Catalog catalog, Schema schema, String pattern, String ... types)"), (int)37));
        }
        if (null == views) {
            views = new LinkedHashMap();
        }
        return views;
    }

    @Override
    public List<String> ddl(DataRuntime runtime, String random, View view) {
        List<String> list;
        block7: {
            list = new ArrayList<String>();
            if (null == random) {
                random = this.random(runtime);
            }
            try {
                long fr = System.currentTimeMillis();
                List<Run> runs = this.buildQueryDDLRun(runtime, view);
                if (null != runs) {
                    int idx = 0;
                    for (Run run : runs) {
                        DataSet set = this.select(runtime, random, true, null, new DefaultConfigStore(new String[0]).keyCase(KeyAdapter.KEY_CASE.PUT_UPPER), run).toUpperKey();
                        list = this.ddl(runtime, idx++, view, list, set);
                    }
                    view.setDdls(list);
                }
                if (ConfigTable.IS_LOG_SQL_TIME && log.isInfoEnabled()) {
                    log.info("{}[view ddl][view:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, view.getName(), list.size(), System.currentTimeMillis() - fr});
                }
            }
            catch (Exception e) {
                if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                    e.printStackTrace();
                }
                if (!ConfigTable.IS_LOG_SQL || !log.isWarnEnabled()) break block7;
                log.info("{}[view ddl][{}][view:{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u67e5\u8be2\u89c6\u56fe\u521b\u5efaDDL\u5931\u8d25", (int)33), view.getName(), e.toString()});
            }
        }
        return list;
    }

    @Override
    public List<Run> buildQueryDDLRun(DataRuntime runtime, View view) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildQueryDDLRun(DataRuntime runtime, View view)"), (int)37));
        }
        return runs;
    }

    @Override
    public List<String> ddl(DataRuntime runtime, int index, View view, List<String> ddls, DataSet set) {
        if (null == ddls) {
            ddls = new ArrayList<String>();
        }
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<String> ddl(DataRuntime runtime, int index, View view, List<String> ddls, DataSet set)"), (int)37));
        }
        return ddls;
    }

    @Override
    public <T extends MasterTable> LinkedHashMap<String, T> mtables(DataRuntime runtime, String random, boolean greedy, Catalog catalog, Schema schema, String pattern, String types) {
        LinkedHashMap<String, Object> tables = new LinkedHashMap<String, MasterTable>();
        if (null == random) {
            random = this.random(runtime);
        }
        try {
            String[] tps;
            long fr;
            block24: {
                fr = System.currentTimeMillis();
                if (null == catalog || null == schema) {
                    Table tmp = new Table();
                    if (!greedy) {
                        this.checkSchema(runtime, tmp);
                    }
                    if (null == catalog) {
                        catalog = tmp.getCatalog();
                    }
                    if (null == schema) {
                        schema = tmp.getSchema();
                    }
                }
                tps = null;
                if (null != types) {
                    tps = types.toUpperCase().trim().split(",");
                }
                DataRow table_map = CacheProxy.getTableMaps(runtime.datasource());
                if (null != pattern) {
                    if (table_map.isEmpty()) {
                        LinkedHashMap<String, T> all = this.mtables(runtime, random, greedy, catalog, schema, null, types);
                        for (Table table : all.values()) {
                            table_map.put(table.getName().toUpperCase(), (Object)table.getName());
                        }
                    }
                    if (table_map.containsKey(pattern.toUpperCase())) {
                        pattern = table_map.getString(pattern.toUpperCase());
                    }
                }
                try {
                    List<Run> runs = this.buildQueryMasterTableRun(runtime, catalog, schema, pattern, types);
                    if (null != runs) {
                        int idx = 0;
                        for (Run run : runs) {
                            DataSet set = this.select(runtime, random, true, (String)null, new DefaultConfigStore(new String[0]).keyCase(KeyAdapter.KEY_CASE.PUT_UPPER), run).toUpperKey();
                            tables = this.mtables(runtime, idx++, true, catalog, schema, tables, set);
                        }
                    }
                }
                catch (Exception e) {
                    if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                        e.printStackTrace();
                    }
                    if (!ConfigTable.IS_LOG_SQL || !log.isWarnEnabled()) break block24;
                    log.warn("{}[stables][{}][catalog:{}][schema:{}][pattern:{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u6839\u636e\u7cfb\u7edf\u8868\u67e5\u8be2\u5931\u8d25", (int)33), catalog, schema, pattern, e.toString()});
                }
            }
            if (null == tables || tables.isEmpty()) {
                try {
                    LinkedHashMap<String, T> tmps = this.mtables(runtime, true, null, catalog, schema, pattern, tps);
                    for (String key : tmps.keySet()) {
                        MasterTable item;
                        if (tables.containsKey(key.toUpperCase()) || null == (item = (MasterTable)tmps.get(key)) || !greedy && !(catalog + "_" + schema).equalsIgnoreCase(item.getCatalog() + "_" + item.getSchema())) continue;
                        tables.put(key.toUpperCase(), item);
                    }
                }
                catch (Exception e) {
                    if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                        e.printStackTrace();
                    }
                    log.warn("{}[stables][{}][catalog:{}][schema:{}][pattern:{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u6839\u636e\u9a71\u52a8\u5185\u7f6e\u63a5\u53e3\u8865\u5145\u5931\u8d25", (int)33), catalog, schema, pattern, e.toString()});
                }
            }
            if (ConfigTable.IS_LOG_SQL_TIME && log.isInfoEnabled()) {
                log.info("{}[stables][catalog:{}][schema:{}][pattern:{}][type:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, catalog, schema, pattern, types, tables.size(), System.currentTimeMillis() - fr});
            }
        }
        catch (Exception e) {
            if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                e.printStackTrace();
            }
            log.error("[mtables][result:fail][msg:{}]", (Object)e.toString());
        }
        return tables;
    }

    @Override
    public List<Run> buildQueryMasterTableRun(DataRuntime runtime, Catalog catalog, Schema schema, String pattern, String types) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildQueryMasterTableRun(DataRuntime runtime, Catalog catalog, Schema schema, String pattern, String types)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public <T extends MasterTable> LinkedHashMap<String, T> mtables(DataRuntime runtime, int index, boolean create, Catalog catalog, Schema schema, LinkedHashMap<String, T> tables, DataSet set) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 <T extends MasterTable> LinkedHashMap<String, T> mtables(DataRuntime runtime, int index, boolean create, Catalog catalog, Schema schema, LinkedHashMap<String, T> tables, DataSet set)"), (int)37));
        }
        if (null == tables) {
            tables = new LinkedHashMap();
        }
        return tables;
    }

    @Override
    public <T extends MasterTable> LinkedHashMap<String, T> mtables(DataRuntime runtime, boolean create, LinkedHashMap<String, T> tables, Catalog catalog, Schema schema, String pattern, String ... types) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 <T extends MasterTable> LinkedHashMap<String, T> mtables(DataRuntime runtime, boolean create, LinkedHashMap<String, T> tables, Catalog catalog, Schema schema, String pattern, String ... types)"), (int)37));
        }
        if (null == tables) {
            tables = new LinkedHashMap();
        }
        return tables;
    }

    @Override
    public List<String> ddl(DataRuntime runtime, String random, MasterTable table) {
        List<String> list;
        block7: {
            list = new ArrayList<String>();
            if (null == random) {
                random = this.random(runtime);
            }
            try {
                long fr = System.currentTimeMillis();
                List<Run> runs = this.buildQueryDDLRun(runtime, table);
                if (null != runs) {
                    int idx = 0;
                    for (Run run : runs) {
                        DataSet set = this.select(runtime, random, true, null, new DefaultConfigStore(new String[0]).keyCase(KeyAdapter.KEY_CASE.PUT_UPPER), run).toUpperKey();
                        list = this.ddl(runtime, idx++, table, list, set);
                    }
                    table.setDdls(list);
                }
                if (ConfigTable.IS_LOG_SQL_TIME && log.isInfoEnabled()) {
                    log.info("{}[master table ddl][table:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, table.getName(), list.size(), System.currentTimeMillis() - fr});
                }
            }
            catch (Exception e) {
                if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                    e.printStackTrace();
                }
                if (!ConfigTable.IS_LOG_SQL || !log.isWarnEnabled()) break block7;
                log.info("{}[master table ddl][{}][table:{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u67e5\u8be2\u4e3b\u8868\u521b\u5efaDDL\u5931\u8d25", (int)33), table.getName(), e.toString()});
            }
        }
        return list;
    }

    @Override
    public List<Run> buildQueryDDLRun(DataRuntime runtime, MasterTable table) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildQueryDDLRun(DataRuntime runtime, MasterTable table)"), (int)37));
        }
        return runs;
    }

    @Override
    public List<String> ddl(DataRuntime runtime, int index, MasterTable table, List<String> ddls, DataSet set) {
        if (null == ddls) {
            ddls = new ArrayList<String>();
        }
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<String> ddl(DataRuntime runtime, int index, MasterTable table, List<String> ddls, DataSet set)"), (int)37));
        }
        return ddls;
    }

    @Override
    public <T extends PartitionTable> LinkedHashMap<String, T> ptables(DataRuntime runtime, String random, boolean greedy, MasterTable master, Map<String, Object> tags, String pattern) {
        LinkedHashMap tables = new LinkedHashMap();
        if (null == random) {
            random = this.random(runtime);
        }
        try {
            long fr;
            block10: {
                fr = System.currentTimeMillis();
                try {
                    List<Run> runs = this.buildQueryPartitionTableRun(runtime, master, tags, pattern);
                    if (null != runs) {
                        int idx = 0;
                        int total = runs.size();
                        for (Run run : runs) {
                            DataSet set = this.select(runtime, random, false, (String)null, new DefaultConfigStore(new String[0]).keyCase(KeyAdapter.KEY_CASE.PUT_UPPER), run).toUpperKey();
                            tables = this.ptables(runtime, total, idx++, true, master, master.getCatalog(), master.getSchema(), tables, set);
                        }
                    }
                }
                catch (Exception e) {
                    if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                        e.printStackTrace();
                    }
                    if (!ConfigTable.IS_LOG_SQL || !log.isWarnEnabled()) break block10;
                    log.warn("{}[tables][{}][stable:{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u6839\u636e\u7cfb\u7edf\u8868\u67e5\u8be2\u5931\u8d25", (int)33), master.getName(), e.toString()});
                }
            }
            if (ConfigTable.IS_LOG_SQL_TIME && log.isInfoEnabled()) {
                log.info("{}[tables][stable:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, master.getName(), tables.size(), System.currentTimeMillis() - fr});
            }
        }
        catch (Exception e) {
            if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                e.printStackTrace();
            }
            log.error("[ptables][result:fail][msg:{}]", (Object)e.toString());
        }
        return tables;
    }

    @Override
    public List<Run> buildQueryPartitionTableRun(DataRuntime runtime, Catalog catalog, Schema schema, String pattern, String types) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildQueryPartitionTableRun(DataRuntime runtime, Catalog catalog, Schema schema, String pattern, String types)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildQueryPartitionTableRun(DataRuntime runtime, MasterTable master, Map<String, Object> tags, String name) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildQueryPartitionTableRun(DataRuntime runtime, MasterTable master, Map<String,Object> tags, String name)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildQueryPartitionTableRun(DataRuntime runtime, MasterTable master, Map<String, Object> tags) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildQueryPartitionTableRun(DataRuntime runtime, MasterTable master, Map<String,Object> tags)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public <T extends PartitionTable> LinkedHashMap<String, T> ptables(DataRuntime runtime, int total, int index, boolean create, MasterTable master, Catalog catalog, Schema schema, LinkedHashMap<String, T> tables, DataSet set) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 LinkedHashMap<String, PartitionTable> ptables(DataRuntime runtime, int total, int index, boolean create, MasterTable table, Catalog catalog, Schema schema, LinkedHashMap<String, PartitionTable> tables, DataSet set)"), (int)37));
        }
        if (null == tables) {
            tables = new LinkedHashMap();
        }
        return tables;
    }

    @Override
    public <T extends PartitionTable> LinkedHashMap<String, T> ptables(DataRuntime runtime, boolean create, LinkedHashMap<String, T> tables, Catalog catalog, Schema schema, MasterTable master) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 LinkedHashMap<String, PartitionTable> ptables(DataRuntime runtime, boolean create, LinkedHashMap<String, T> tables, Catalog catalog, Schema schema, MasterTable master)"), (int)37));
        }
        if (null == tables) {
            tables = new LinkedHashMap();
        }
        return tables;
    }

    @Override
    public List<String> ddl(DataRuntime runtime, String random, PartitionTable table) {
        List<String> list;
        block7: {
            list = new ArrayList<String>();
            if (null == random) {
                random = this.random(runtime);
            }
            try {
                long fr = System.currentTimeMillis();
                List<Run> runs = this.buildQueryDDLRun(runtime, table);
                if (null != runs) {
                    int idx = 0;
                    for (Run run : runs) {
                        DataSet set = this.select(runtime, random, true, null, new DefaultConfigStore(new String[0]).keyCase(KeyAdapter.KEY_CASE.PUT_UPPER), run).toUpperKey();
                        list = this.ddl(runtime, idx++, table, list, set);
                    }
                    table.setDdls(list);
                }
                if (ConfigTable.IS_LOG_SQL_TIME && log.isInfoEnabled()) {
                    log.info("{}[partition table ddl][table:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, table.getName(), list.size(), System.currentTimeMillis() - fr});
                }
            }
            catch (Exception e) {
                if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                    e.printStackTrace();
                }
                if (!ConfigTable.IS_LOG_SQL || !log.isWarnEnabled()) break block7;
                log.info("{}[partition table ddl][{}][table:{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u67e5\u8be2\u5b50\u8868\u521b\u5efaDDL\u5931\u8d25", (int)33), table.getName(), e.toString()});
            }
        }
        return list;
    }

    @Override
    public List<Run> buildQueryDDLRun(DataRuntime runtime, PartitionTable table) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildQueryDDLRun(DataRuntime runtime, PartitionTable table)"), (int)37));
        }
        return runs;
    }

    @Override
    public List<String> ddl(DataRuntime runtime, int index, PartitionTable table, List<String> ddls, DataSet set) {
        if (null == ddls) {
            ddls = new ArrayList<String>();
        }
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<String> ddl(DataRuntime runtime, int index, PartitionTable table, List<String> ddls, DataSet set)"), (int)37));
        }
        return ddls;
    }

    @Override
    public <T extends Column> LinkedHashMap<String, T> columns(DataRuntime runtime, String random, boolean greedy, Table table, boolean primary) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 <T extends Column> LinkedHashMap<String, T> columns(DataRuntime runtime, String random, boolean greedy, Table table, boolean primary)"), (int)37));
        }
        return new LinkedHashMap();
    }

    @Override
    public <T extends Column> List<T> columns(DataRuntime runtime, String random, boolean greedy, Catalog catalog, Schema schema, String table) {
        List columns = new ArrayList();
        long fr = System.currentTimeMillis();
        if (null == random) {
            random = this.random(runtime);
        }
        Table tab = new Table(table);
        tab.setCatalog(catalog);
        tab.setSchema(schema);
        if (BasicUtil.isEmpty((Object)catalog) && BasicUtil.isEmpty((Object)schema) && !greedy) {
            this.checkSchema(runtime, tab);
        }
        try {
            List<Run> runs = this.buildQueryColumnRun(runtime, tab, false);
            if (null != runs) {
                int idx = 0;
                for (Run run : runs) {
                    DataSet set = this.select(runtime, random, true, (String)null, new DefaultConfigStore(new String[0]).keyCase(KeyAdapter.KEY_CASE.PUT_UPPER), run);
                    columns = this.columns(runtime, idx, true, tab, columns, set);
                    ++idx;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return columns;
    }

    @Override
    public <T extends Column> LinkedHashMap<String, T> columns(DataRuntime runtime, boolean create, LinkedHashMap<String, T> columns, Table table, String pattern) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 <T extends Column> LinkedHashMap<String, T> columns(DataRuntime runtime, boolean create, LinkedHashMap<String, T> columns, Table table, String pattern)"), (int)37));
        }
        return new LinkedHashMap();
    }

    @Override
    public List<Run> buildQueryColumnRun(DataRuntime runtime, Table table, boolean metadata) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildQueryColumnRun(DataRuntime runtime, Table table, boolean metadata)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public <T extends Column> LinkedHashMap<String, T> columns(DataRuntime runtime, int index, boolean create, Table table, LinkedHashMap<String, T> columns, DataSet set) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 <T extends Column> LinkedHashMap<String, T> columns(DataRuntime runtime, int index, boolean create, Table table, LinkedHashMap<String, T> columns, DataSet set)"), (int)37));
        }
        return new LinkedHashMap();
    }

    @Override
    public <T extends Column> List<T> columns(DataRuntime runtime, int index, boolean create, Table table, List<T> columns, DataSet set) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 <T extends Column> List<T> columns(DataRuntime runtime, int index, boolean create, Table table, List<T> columns, DataSet set)"), (int)37));
        }
        return new ArrayList();
    }

    @Override
    public <T extends Tag> LinkedHashMap<String, T> tags(DataRuntime runtime, String random, boolean greedy, Table table) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 <T extends Tag> LinkedHashMap<String, T> tags(DataRuntime runtime, String random, boolean greedy, Table table)"), (int)37));
        }
        return new LinkedHashMap();
    }

    @Override
    public List<Run> buildQueryTagRun(DataRuntime runtime, Table table, boolean metadata) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildQueryTagRun(DataRuntime runtime, Table table, boolean metadata)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public <T extends Tag> LinkedHashMap<String, T> tags(DataRuntime runtime, int index, boolean create, Table table, LinkedHashMap<String, T> tags, DataSet set) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 <T extends Tag> LinkedHashMap<String, T> tags(DataRuntime runtime, int index, boolean create, Table table, LinkedHashMap<String, T> tags, DataSet set)"), (int)37));
        }
        if (null == tags) {
            tags = new LinkedHashMap();
        }
        return tags;
    }

    @Override
    public <T extends Tag> LinkedHashMap<String, T> tags(DataRuntime runtime, boolean create, LinkedHashMap<String, T> tags, Table table, String pattern) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 <T extends Tag> LinkedHashMap<String, T> tags(DataRuntime runtime, boolean create, LinkedHashMap<String, T> tags, Table table, String pattern)"), (int)37));
        }
        if (null == tags) {
            tags = new LinkedHashMap();
        }
        return tags;
    }

    @Override
    public PrimaryKey primary(DataRuntime runtime, String random, boolean greedy, Table table) {
        PrimaryKey primary;
        block8: {
            primary = null;
            if (!greedy) {
                this.checkSchema(runtime, table);
            }
            String tab = table.getName();
            Catalog catalog = table.getCatalog();
            Schema schema = table.getSchema();
            if (null == random) {
                random = this.random(runtime);
            }
            try {
                List<Run> runs = this.buildQueryPrimaryRun(runtime, table);
                if (null != runs) {
                    int idx = 0;
                    for (Run run : runs) {
                        DataSet set = this.select(runtime, random, false, (String)null, new DefaultConfigStore(new String[0]).keyCase(KeyAdapter.KEY_CASE.PUT_UPPER), run).toUpperKey();
                        primary = this.primary(runtime, idx, table, set);
                        if (null != primary) {
                            primary.setTable(table);
                        }
                        ++idx;
                    }
                }
            }
            catch (Exception e) {
                if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                    e.printStackTrace();
                }
                if (!ConfigTable.IS_LOG_SQL || !log.isWarnEnabled()) break block8;
                log.warn("{}[primary][{}][catalog:{}][schema:{}][table:{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u6839\u636e\u7cfb\u7edf\u8868\u67e5\u8be2\u5931\u8d25", (int)33), catalog, schema, table, e.toString()});
            }
        }
        table.setPrimaryKey(primary);
        return primary;
    }

    @Override
    public List<Run> buildQueryPrimaryRun(DataRuntime runtime, Table table) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildQueryPrimaryRun(DataRuntime runtime, Table table)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public PrimaryKey primary(DataRuntime runtime, int index, Table table, DataSet set) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 PrimaryKey primary(DataRuntime runtime, int index, Table table, DataSet set)"), (int)37));
        }
        return null;
    }

    @Override
    public PrimaryKey primary(DataRuntime runtime, Table table) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 PrimaryKey primary(DataRuntime runtime, Table table)"), (int)37));
        }
        return null;
    }

    @Override
    public <T extends ForeignKey> LinkedHashMap<String, T> foreigns(DataRuntime runtime, String random, boolean greedy, Table table) {
        LinkedHashMap foreigns;
        block6: {
            foreigns = new LinkedHashMap();
            if (null == random) {
                random = this.random(runtime);
            }
            if (!greedy) {
                this.checkSchema(runtime, table);
            }
            try {
                List<Run> runs = this.buildQueryForeignRun(runtime, table);
                if (null != runs) {
                    int idx = 0;
                    for (Run run : runs) {
                        DataSet set = this.select(runtime, random, true, (String)null, new DefaultConfigStore(new String[0]).keyCase(KeyAdapter.KEY_CASE.PUT_UPPER), run).toUpperKey();
                        foreigns = this.foreigns(runtime, idx, table, foreigns, set);
                        ++idx;
                    }
                }
            }
            catch (Exception e) {
                if (!ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) break block6;
                e.printStackTrace();
            }
        }
        return foreigns;
    }

    @Override
    public List<Run> buildQueryForeignRun(DataRuntime runtime, Table table) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildQueryForeignRun(DataRuntime runtime, Table table)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public <T extends ForeignKey> LinkedHashMap<String, T> foreigns(DataRuntime runtime, int index, Table table, LinkedHashMap<String, T> foreigns, DataSet set) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 <T extends ForeignKey> LinkedHashMap<String, T> foreigns(DataRuntime runtime, int index, Table table, LinkedHashMap<String, T> foreigns, DataSet set)"), (int)37));
        }
        return new LinkedHashMap();
    }

    @Override
    public <T extends Index> List<T> indexs(DataRuntime runtime, String random, boolean greedy, Table table, String pattern) {
        List<Run> runs;
        List<T> indexs;
        block10: {
            indexs = null;
            if (null == table) {
                table = new Table();
            }
            if (null == random) {
                random = this.random(runtime);
            }
            if (!greedy) {
                this.checkSchema(runtime, table);
            }
            if (null != table.getName()) {
                try {
                    LinkedHashMap maps = this.indexs(runtime, true, new LinkedHashMap(), table, false, false);
                    table.setIndexs(maps);
                }
                catch (Exception e) {
                    if (!ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) break block10;
                    e.printStackTrace();
                }
            }
        }
        if (null != (runs = this.buildQueryIndexRun(runtime, table, pattern))) {
            int idx = 0;
            for (Run run : runs) {
                block11: {
                    DataSet set = this.select(runtime, random, true, (String)null, new DefaultConfigStore(new String[0]).keyCase(KeyAdapter.KEY_CASE.PUT_UPPER), run).toUpperKey();
                    try {
                        indexs = this.indexs(runtime, idx, true, table, indexs, set);
                    }
                    catch (Exception e) {
                        if (!ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) break block11;
                        e.printStackTrace();
                    }
                }
                ++idx;
            }
        }
        return indexs;
    }

    @Override
    public <T extends Index> LinkedHashMap<String, T> indexs(DataRuntime runtime, String random, Table table, String pattern) {
        List<Run> runs;
        LinkedHashMap<String, Object> indexs = null;
        if (null == table) {
            table = new Table();
        }
        if (null == random) {
            random = this.random(runtime);
        }
        this.checkSchema(runtime, table);
        if (null != table.getName()) {
            block16: {
                try {
                    indexs = this.indexs(runtime, true, indexs, table, false, false);
                    table.setIndexs(indexs);
                }
                catch (Exception e) {
                    if (!ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) break block16;
                    e.printStackTrace();
                }
            }
            if (BasicUtil.isNotEmpty((Object)pattern)) {
                Index index = (Index)indexs.get(pattern.toUpperCase());
                indexs = new LinkedHashMap();
                indexs.put(pattern.toUpperCase(), index);
            }
        }
        if (null != (runs = this.buildQueryIndexRun(runtime, table, pattern))) {
            int idx = 0;
            for (Run run : runs) {
                block17: {
                    DataSet set = this.select(runtime, random, true, (String)null, new DefaultConfigStore(new String[0]).keyCase(KeyAdapter.KEY_CASE.PUT_UPPER), run).toUpperKey();
                    try {
                        indexs = this.indexs(runtime, idx, true, table, indexs, set);
                    }
                    catch (Exception e) {
                        if (!ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) break block17;
                        e.printStackTrace();
                    }
                }
                ++idx;
            }
        }
        PrimaryKey pk = null;
        for (Index index : indexs.values()) {
            if (!index.isPrimary()) continue;
            pk = index;
            break;
        }
        if (null == pk) {
            pk = table.getPrimaryKey();
            if (null == pk) {
                pk = this.primary(runtime, random, false, table);
            }
            if (null != pk) {
                Index index = (Index)indexs.get(pk.getName().toUpperCase());
                if (null != index) {
                    index.setPrimary(true);
                } else {
                    indexs.put(pk.getName().toUpperCase(), pk);
                }
            }
        }
        return indexs;
    }

    @Override
    public List<Run> buildQueryIndexRun(DataRuntime runtime, Table table, String name) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildQueryIndexRun(DataRuntime runtime, Table table, String name)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public <T extends Index> LinkedHashMap<String, T> indexs(DataRuntime runtime, int index, boolean create, Table table, LinkedHashMap<String, T> indexs, DataSet set) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 <T extends Index> LinkedHashMap<String, T> indexs(DataRuntime runtime, int index, boolean create, Table table, LinkedHashMap<String, T> indexs, DataSet set)"), (int)37));
        }
        if (null == indexs) {
            indexs = new LinkedHashMap();
        }
        return indexs;
    }

    @Override
    public <T extends Index> List<T> indexs(DataRuntime runtime, int index, boolean create, Table table, List<T> indexs, DataSet set) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 <T extends Index> List<T> indexs(DataRuntime runtime, int index, boolean create, Table table, List<T> indexs, DataSet set)"), (int)37));
        }
        if (null == indexs) {
            indexs = new ArrayList<T>();
        }
        return indexs;
    }

    @Override
    public <T extends Index> List<T> indexs(DataRuntime runtime, boolean create, List<T> indexs, Table table, boolean unique, boolean approximate) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 <T extends Index> LinkedHashMap<String, T> indexs(DataRuntime runtime, boolean create, List<T> indexs, Table table, boolean unique, boolean approximate)"), (int)37));
        }
        if (null == indexs) {
            indexs = new ArrayList<T>();
        }
        return indexs;
    }

    @Override
    public <T extends Index> LinkedHashMap<String, T> indexs(DataRuntime runtime, boolean create, LinkedHashMap<String, T> indexs, Table table, boolean unique, boolean approximate) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 <T extends Index> LinkedHashMap<String, T> indexs(DataRuntime runtime, boolean create, LinkedHashMap<String, T> indexs, Table table, boolean unique, boolean approximate)"), (int)37));
        }
        if (null == indexs) {
            indexs = new LinkedHashMap();
        }
        return indexs;
    }

    @Override
    public <T extends Constraint> List<T> constraints(DataRuntime runtime, String random, boolean greedy, Table table, String pattern) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 <T extends Constraint> List<T> constraints(DataRuntime runtime, String random, boolean greedy, Table table, String pattern)"), (int)37));
        }
        return new ArrayList();
    }

    @Override
    public <T extends Constraint> LinkedHashMap<String, T> constraints(DataRuntime runtime, String random, Table table, Column column, String pattern) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 <T extends Constraint> LinkedHashMap<String, T> constraints(DataRuntime runtime, String random, Table table, Column column, String pattern)"), (int)37));
        }
        return new LinkedHashMap();
    }

    @Override
    public List<Run> buildQueryConstraintRun(DataRuntime runtime, Table table, Column column, String pattern) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildQueryConstraintRun(DataRuntime runtime, Table table, Column column, String pattern)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public <T extends Constraint> List<T> constraints(DataRuntime runtime, int index, boolean create, Table table, List<T> constraints, DataSet set) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 <T extends Constraint> List<T> constraints(DataRuntime runtime, int index, boolean create, Table table, List<T> constraints, DataSet set)"), (int)37));
        }
        if (null == constraints) {
            constraints = new ArrayList<T>();
        }
        return constraints;
    }

    @Override
    public <T extends Constraint> LinkedHashMap<String, T> constraints(DataRuntime runtime, int index, boolean create, Table table, Column column, LinkedHashMap<String, T> constraints, DataSet set) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 LinkedHashMap<String, Constraint>  constraints(DataRuntime runtime, int index, boolean create, Table table, LinkedHashMap<String, T> constraints, DataSet set)"), (int)37));
        }
        if (null == constraints) {
            constraints = new LinkedHashMap();
        }
        return constraints;
    }

    @Override
    public <T extends Trigger> LinkedHashMap<String, T> triggers(DataRuntime runtime, String random, boolean greedy, Table table, List<Trigger.EVENT> events) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 <T extends Trigger> LinkedHashMap<String, T> triggers(DataRuntime runtime, String random, boolean greedy, Table table, List<Trigger.EVENT> events)"), (int)37));
        }
        return new LinkedHashMap();
    }

    @Override
    public List<Run> buildQueryTriggerRun(DataRuntime runtime, Table table, List<Trigger.EVENT> events) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 buildQueryTriggerRun(DataRuntime runtime, Table table, List<Trigger.EVENT> events)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public <T extends Trigger> LinkedHashMap<String, T> triggers(DataRuntime runtime, int index, boolean create, Table table, LinkedHashMap<String, T> triggers, DataSet set) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 <T extends Trigger> LinkedHashMap<String, T> triggers(DataRuntime runtime, int index, boolean create, Table table, LinkedHashMap<String, T> triggers, DataSet set)"), (int)37));
        }
        if (null == triggers) {
            triggers = new LinkedHashMap();
        }
        return triggers;
    }

    @Override
    public <T extends Procedure> List<T> procedures(DataRuntime runtime, String random, boolean greedy, Catalog catalog, Schema schema, String pattern) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 <T extends Procedure> ArrayList<T> procedures(DataRuntime runtime, String random,  boolean greedy, Catalog catalog, Schema schema, String pattern)"), (int)37));
        }
        return new ArrayList();
    }

    @Override
    public <T extends Procedure> LinkedHashMap<String, T> procedures(DataRuntime runtime, String random, Catalog catalog, Schema schema, String pattern) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 <T extends Procedure> LinkedHashMap<String, T> procedures(DataRuntime runtime, String random, Catalog catalog, Schema schema, String pattern)"), (int)37));
        }
        return new LinkedHashMap();
    }

    @Override
    public List<Run> buildQueryProcedureRun(DataRuntime runtime, Catalog catalog, Schema schema, String pattern) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildQueryProcedureRun(DataRuntime runtime, Catalog catalog, Schema schema, String pattern)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public <T extends Procedure> List<T> procedures(DataRuntime runtime, int index, boolean create, List<T> procedures, DataSet set) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 <T extends Procedure> List<T> procedures(DataRuntime runtime, int index, boolean create, List<T> procedures, DataSet set)"), (int)37));
        }
        return new ArrayList();
    }

    @Override
    public <T extends Procedure> LinkedHashMap<String, T> procedures(DataRuntime runtime, int index, boolean create, LinkedHashMap<String, T> procedures, DataSet set) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 <T extends Procedure> LinkedHashMap<String, T> procedures(DataRuntime runtime, int index, boolean create, LinkedHashMap<String, T> procedures, DataSet set)"), (int)37));
        }
        return new LinkedHashMap();
    }

    @Override
    public <T extends Procedure> List<T> procedures(DataRuntime runtime, boolean create, List<T> procedures) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 <T extends Procedure> List<T> procedures(DataRuntime runtime, int index, boolean create, List<T> procedures, DataSet set)"), (int)37));
        }
        return new ArrayList();
    }

    @Override
    public <T extends Procedure> LinkedHashMap<String, T> procedures(DataRuntime runtime, boolean create, LinkedHashMap<String, T> procedures) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 <T extends Procedure> LinkedHashMap<String, T> procedures(DataRuntime runtime, int index, boolean create, LinkedHashMap<String, T> procedures, DataSet set)"), (int)37));
        }
        return new LinkedHashMap();
    }

    @Override
    public List<String> ddl(DataRuntime runtime, String random, Procedure procedure) {
        List<String> list;
        block8: {
            list = new ArrayList<String>();
            if (null == random) {
                random = this.random(runtime);
            }
            try {
                long fr = System.currentTimeMillis();
                List<Run> runs = this.buildQueryDDLRun(runtime, procedure);
                if (null != runs && runs.size() > 0) {
                    int idx = 0;
                    for (Run run : runs) {
                        DataSet set = this.select(runtime, random, true, null, new DefaultConfigStore(new String[0]).keyCase(KeyAdapter.KEY_CASE.PUT_UPPER), run).toUpperKey();
                        list = this.ddl(runtime, idx++, procedure, list, set);
                    }
                    if (list.size() > 0) {
                        procedure.setDdls(list);
                    }
                }
                if (ConfigTable.IS_LOG_SQL && log.isInfoEnabled()) {
                    log.info("{}[procedure ddl][procedure:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, procedure.getName(), list.size(), System.currentTimeMillis() - fr});
                }
            }
            catch (Exception e) {
                if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                    e.printStackTrace();
                }
                if (!ConfigTable.IS_LOG_SQL || !log.isWarnEnabled()) break block8;
                log.info("{}[procedure ddl][{}][procedure:{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u67e5\u8be2\u5b58\u50a8\u8fc7\u7a0b\u7684\u521b\u5efaDDL\u5931\u8d25", (int)33), procedure.getName(), e.toString()});
            }
        }
        return list;
    }

    @Override
    public List<Run> buildQueryDDLRun(DataRuntime runtime, Procedure procedure) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildQueryDDLRun(DataRuntime runtime, Procedure procedure)"), (int)37));
        }
        return runs;
    }

    @Override
    public List<String> ddl(DataRuntime runtime, int index, Procedure procedure, List<String> ddls, DataSet set) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> List<String> ddl(DataRuntime runtime, int index, Procedure procedure, List<String> ddls, DataSet set)"), (int)37));
        }
        return new ArrayList<String>();
    }

    @Override
    public <T extends Function> List<T> functions(DataRuntime runtime, String random, boolean greedy, Catalog catalog, Schema schema, String pattern) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> <T extends Function> List<T> functions(DataRuntime runtime, String random, boolean greedy, Catalog catalog, Schema schema, String pattern)"), (int)37));
        }
        return new ArrayList();
    }

    @Override
    public <T extends Function> LinkedHashMap<String, T> functions(DataRuntime runtime, String random, Catalog catalog, Schema schema, String pattern) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> <T extends Function> LinkedHashMap<String, T> functions(DataRuntime runtime, String random, Catalog catalog, Schema schema, String pattern)"), (int)37));
        }
        return new LinkedHashMap();
    }

    @Override
    public List<Run> buildQueryFunctionRun(DataRuntime runtime, Catalog catalog, Schema schema, String pattern) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildQueryFunctionRun(DataRuntime runtime, Catalog catalog, Schema schema, String pattern)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public <T extends Function> List<T> functions(DataRuntime runtime, int index, boolean create, List<T> functions, DataSet set) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 <T extends Function> List<T> functions(DataRuntime runtime, int index, boolean create, List<T> functions, DataSet set)"), (int)37));
        }
        return new ArrayList();
    }

    @Override
    public <T extends Function> LinkedHashMap<String, T> functions(DataRuntime runtime, int index, boolean create, LinkedHashMap<String, T> functions, DataSet set) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 <T extends Function> LinkedHashMap<String, T> functions(DataRuntime runtime, int index, boolean create, LinkedHashMap<String, T> functions, DataSet set)"), (int)37));
        }
        return new LinkedHashMap();
    }

    @Override
    public <T extends Function> List<T> functions(DataRuntime runtime, boolean create, List<T> functions) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 <T extends Function> List<T> functions(DataRuntime runtime, int index, boolean create, List<T> functions, DataSet set)"), (int)37));
        }
        return new ArrayList();
    }

    @Override
    public <T extends Function> LinkedHashMap<String, T> functions(DataRuntime runtime, boolean create, LinkedHashMap<String, T> functions) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 <T extends Function> LinkedHashMap<String, T> functions(DataRuntime runtime, boolean create, LinkedHashMap<String, T> functions)"), (int)37));
        }
        return new LinkedHashMap();
    }

    @Override
    public List<String> ddl(DataRuntime runtime, String random, Function meta) {
        List<String> list;
        block8: {
            list = new ArrayList<String>();
            if (null == random) {
                random = this.random(runtime);
            }
            try {
                long fr = System.currentTimeMillis();
                List<Run> runs = this.buildQueryDDLRun(runtime, meta);
                if (null != runs && runs.size() > 0) {
                    int idx = 0;
                    for (Run run : runs) {
                        DataSet set = this.select(runtime, random, true, null, new DefaultConfigStore(new String[0]).keyCase(KeyAdapter.KEY_CASE.PUT_UPPER), run).toUpperKey();
                        list = this.ddl(runtime, idx++, meta, list, set);
                    }
                    if (list.size() > 0) {
                        meta.setDdls(list);
                    }
                }
                if (ConfigTable.IS_LOG_SQL && log.isInfoEnabled()) {
                    log.info("{}[function ddl][function:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, meta.getName(), list.size(), System.currentTimeMillis() - fr});
                }
            }
            catch (Exception e) {
                if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                    e.printStackTrace();
                }
                if (!ConfigTable.IS_LOG_SQL || !log.isWarnEnabled()) break block8;
                log.info("{}[function ddl][{}][function:{}][msg:{}]", new Object[]{random, LogUtil.format((String)"\u67e5\u8be2\u51fd\u6570\u7684\u521b\u5efaDDL\u5931\u8d25", (int)33), meta.getName(), e.toString()});
            }
        }
        return list;
    }

    @Override
    public List<Run> buildQueryDDLRun(DataRuntime runtime, Function meta) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildQueryDDLRun(DataRuntime runtime, Function meta)"), (int)37));
        }
        return runs;
    }

    @Override
    public List<String> ddl(DataRuntime runtime, int index, Function function, List<String> ddls, DataSet set) {
        if (null == ddls) {
            ddls = new ArrayList<String>();
        }
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<String> ddl(DataRuntime runtime, int index, Function function, List<String> ddls, DataSet set)"), (int)37));
        }
        return ddls;
    }

    public <T extends Table> T table(List<T> tables, Catalog catalog, Schema schema, String name) {
        if (null != tables) {
            for (Table table : tables) {
                if (null != catalog && !catalog.equal(table.getCatalog()) || null != schema && !schema.equal(table.getSchema()) || !table.getName().equalsIgnoreCase(name)) continue;
                return (T)table;
            }
        }
        return null;
    }

    public <T extends Schema> T schema(List<T> schemas, Catalog catalog, String name) {
        if (null != schemas) {
            for (Schema schema : schemas) {
                if (null != catalog && !catalog.equal(schema.getCatalog()) || !schema.getName().equalsIgnoreCase(name)) continue;
                return (T)schema;
            }
        }
        return null;
    }

    public <T extends Catalog> T catalog(List<T> catalogs, String name) {
        if (null != catalogs) {
            for (Catalog catalog : catalogs) {
                if (!catalog.getName().equalsIgnoreCase(name)) continue;
                return (T)catalog;
            }
        }
        return null;
    }

    public <T extends Database> T database(List<T> databases, String name) {
        if (null != databases) {
            for (Database database : databases) {
                if (!database.getName().equalsIgnoreCase(name)) continue;
                return (T)database;
            }
        }
        return null;
    }

    @Override
    public boolean execute(DataRuntime runtime, String random, BaseMetadata meta, ACTION.DDL action, Run run) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 boolean execute(DataRuntime runtime, String random, BaseMetadata meta, ACTION.DDL action, Run run)"), (int)37));
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean create(DataRuntime runtime, Table meta) throws Exception {
        boolean result = false;
        ACTION.DDL action = ACTION.DDL.TABLE_CREATE;
        String random = this.random(runtime);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (null != this.ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = this.ddListener.prepareCreate(runtime, random, meta);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        this.checkSchema(runtime, meta);
        List<Run> runs = this.buildCreateRun(runtime, meta);
        swt = InterceptorProxy.before(runtime, random, action, meta, runs);
        if (null != this.ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = this.ddListener.beforeCreate(runtime, random, meta, runs);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        long fr = System.currentTimeMillis();
        try {
            result = this.execute(runtime, random, (BaseMetadata)meta, action, runs);
        }
        catch (Throwable throwable) {
            long millis = System.currentTimeMillis() - fr;
            if (runs.size() > 1 && ConfigTable.IS_LOG_SQL_TIME && log.isInfoEnabled()) {
                log.info("{}[action:{}][name:{}][cmds:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getName(), runs.size(), result, millis});
            }
            swt = ACTION.SWITCH.CONTINUE;
            if (null != this.ddListener) {
                swt = this.ddListener.afterCreate(runtime, random, meta, runs, result, millis);
            }
            if (swt == ACTION.SWITCH.CONTINUE) {
                InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
            }
            throw throwable;
        }
        long millis = System.currentTimeMillis() - fr;
        if (runs.size() > 1 && ConfigTable.IS_LOG_SQL_TIME && log.isInfoEnabled()) {
            log.info("{}[action:{}][name:{}][cmds:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getName(), runs.size(), result, millis});
        }
        swt = ACTION.SWITCH.CONTINUE;
        if (null != this.ddListener) {
            swt = this.ddListener.afterCreate(runtime, random, meta, runs, result, millis);
        }
        if (swt == ACTION.SWITCH.CONTINUE) {
            InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
        }
        return result;
    }

    @Override
    public boolean alter(DataRuntime runtime, Table meta) throws Exception {
        List<Run> alters;
        boolean change_pk;
        boolean result = true;
        List<Run> runs = new ArrayList<Run>();
        Table update = (Table)meta.getUpdate();
        LinkedHashMap columns = meta.getColumns();
        LinkedHashMap ucolumns = update.getColumns();
        String name = meta.getName();
        String uname = update.getName();
        String random = this.random(runtime);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, ACTION.DDL.TABLE_ALTER, meta);
        if (null != this.ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = this.ddListener.parepareAlter(runtime, random, meta);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        this.checkSchema(runtime, meta);
        this.checkSchema(runtime, update);
        long fr = System.currentTimeMillis();
        if (!name.equalsIgnoreCase(uname)) {
            result = this.rename(runtime, meta, uname);
            meta.setName(uname);
        }
        if (!result) {
            return result;
        }
        String comment = update.getComment();
        if (!comment.equals(meta.getComment()) && (swt = InterceptorProxy.prepare(runtime, random, ACTION.DDL.TABLE_COMMENT, meta)) != ACTION.SWITCH.BREAK) {
            if (BasicUtil.isNotEmpty((Object)meta.getComment())) {
                runs.addAll(this.buildChangeCommentRun(runtime, update));
            } else {
                runs.addAll(this.buildAppendCommentRun(runtime, update));
            }
            swt = InterceptorProxy.before(runtime, random, ACTION.DDL.TABLE_COMMENT, meta, runs);
            if (swt != ACTION.SWITCH.BREAK) {
                long cmt_fr = System.currentTimeMillis();
                result = this.execute(runtime, random, (BaseMetadata)meta, ACTION.DDL.TABLE_COMMENT, runs) && result;
                InterceptorProxy.after(runtime, random, ACTION.DDL.TABLE_COMMENT, meta, runs, result, System.currentTimeMillis() - cmt_fr);
            }
        }
        LinkedHashMap<String, Object> cols = new LinkedHashMap<String, Object>();
        for (Object ucolumn : ucolumns.values()) {
            Column column = (Column)columns.get(ucolumn.getName().toUpperCase());
            if (null != ucolumn.getUpdate()) {
                ucolumn = (Column)ucolumn.getUpdate();
            }
            if (null != column) {
                if (column.equals((Column)ucolumn)) continue;
                column.setTable(update);
                column.setUpdate((BaseMetadata)ucolumn, false, false);
                column.setAction(ACTION.DDL.COLUMN_ALTER);
                cols.put(column.getName().toUpperCase(), column);
                continue;
            }
            ucolumn.setTable(update);
            ucolumn.setAction(ACTION.DDL.COLUMN_ADD);
            cols.put(ucolumn.getName().toUpperCase(), ucolumn);
        }
        ArrayList<String> deletes = new ArrayList<String>();
        for (Column column : ucolumns.values()) {
            if (!column.isDrop()) continue;
            deletes.add(column.getName().toUpperCase());
            column.setAction(ACTION.DDL.COLUMN_DROP);
            cols.put(column.getName().toUpperCase(), column);
        }
        if (meta.isAutoDropColumn()) {
            for (Column column : columns.values()) {
                Column ucolumn;
                if (column instanceof Tag || column.isDrop() || deletes.contains(column.getName().toUpperCase()) || ACTION.DDL.COLUMN_DROP == column.getAction() || null != (ucolumn = (Column)ucolumns.get(column.getName().toUpperCase()))) continue;
                column.setTable(update);
                column.setAction(ACTION.DDL.COLUMN_DROP);
                cols.put(column.getName().toUpperCase(), column);
            }
        }
        PrimaryKey src_primary = this.primary(runtime, random, false, meta);
        PrimaryKey cur_primary = update.getPrimaryKey();
        String src_define = "";
        String cur_define = "";
        if (null != src_primary) {
            src_define = BeanUtil.concat(src_primary.getColumns().values(), (String)"name", (String)",", (boolean)false, (boolean)true);
        }
        if (null != cur_primary) {
            cur_define = BeanUtil.concat(cur_primary.getColumns().values(), (String)"name", (String)",", (boolean)false, (boolean)true);
        }
        boolean bl = change_pk = !cur_define.equalsIgnoreCase(src_define);
        if (null != src_primary && change_pk) {
            LinkedHashMap pks = src_primary.getColumns();
            LinkedHashMap npks = cur_primary.getColumns();
            for (String k : pks.keySet()) {
                Column auto = (Column)columns.get(k.toUpperCase());
                if (null == auto || auto.isAutoIncrement() != 1 || npks.containsKey(auto.getName().toUpperCase())) continue;
                auto.primary(Boolean.valueOf(false));
                runs = this.buildDropAutoIncrement(runtime, auto);
                result = this.execute(runtime, random, (BaseMetadata)meta, ACTION.DDL.TABLE_ALTER, runs) && result;
            }
            if (null != src_primary) {
                this.drop(runtime, src_primary);
            }
        }
        if (null != (alters = this.buildAlterRun(runtime, meta, cols.values())) && alters.size() > 0) {
            boolean bl2 = result = this.execute(runtime, random, (BaseMetadata)meta, ACTION.DDL.COLUMN_ALTER, alters) && result;
        }
        if (change_pk && null != cur_primary) {
            this.add(runtime, cur_primary);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean drop(DataRuntime runtime, Table meta) throws Exception {
        boolean result = false;
        ACTION.DDL action = ACTION.DDL.TABLE_DROP;
        String random = this.random(runtime);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (null != this.ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = this.ddListener.prepareDrop(runtime, random, meta);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        this.checkSchema(runtime, meta);
        List<Run> runs = this.buildDropRun(runtime, meta);
        swt = InterceptorProxy.before(runtime, random, action, meta, runs);
        if (null != this.ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = this.ddListener.beforeDrop(runtime, random, meta, runs);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        long fr = System.currentTimeMillis();
        try {
            result = this.execute(runtime, random, (BaseMetadata)meta, action, runs);
        }
        catch (Throwable throwable) {
            long millis = System.currentTimeMillis() - fr;
            if (runs.size() > 1 && ConfigTable.IS_LOG_SQL_TIME && log.isInfoEnabled()) {
                log.info("{}[action:{}][name:{}][cmds:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getName(), runs.size(), result, millis});
            }
            swt = ACTION.SWITCH.CONTINUE;
            if (null != this.ddListener) {
                swt = this.ddListener.afterDrop(runtime, random, meta, runs, result, millis);
            }
            if (swt == ACTION.SWITCH.CONTINUE) {
                InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
            }
            throw throwable;
        }
        long millis = System.currentTimeMillis() - fr;
        if (runs.size() > 1 && ConfigTable.IS_LOG_SQL_TIME && log.isInfoEnabled()) {
            log.info("{}[action:{}][name:{}][cmds:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getName(), runs.size(), result, millis});
        }
        swt = ACTION.SWITCH.CONTINUE;
        if (null != this.ddListener) {
            swt = this.ddListener.afterDrop(runtime, random, meta, runs, result, millis);
        }
        if (swt == ACTION.SWITCH.CONTINUE) {
            InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean rename(DataRuntime runtime, Table origin, String name) throws Exception {
        boolean result = false;
        ACTION.DDL action = ACTION.DDL.TABLE_RENAME;
        String random = this.random(runtime);
        origin.setNewName(name);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, origin);
        if (null != this.ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = this.ddListener.prepareRename(runtime, random, origin);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        this.checkSchema(runtime, origin);
        List<Run> runs = this.buildRenameRun(runtime, origin);
        swt = InterceptorProxy.before(runtime, random, action, origin, runs);
        if (null != this.ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = this.ddListener.beforeRename(runtime, random, origin, runs);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        long fr = System.currentTimeMillis();
        try {
            result = this.execute(runtime, random, (BaseMetadata)origin, action, runs);
        }
        catch (Throwable throwable) {
            long millis = System.currentTimeMillis() - fr;
            if (runs.size() > 1 && ConfigTable.IS_LOG_SQL_TIME && log.isInfoEnabled()) {
                log.info("{}[action:{}][name:{}][rename:{}][cmds:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, origin.getName(), name, runs.size(), result, millis});
            }
            swt = ACTION.SWITCH.CONTINUE;
            if (null != this.ddListener) {
                swt = this.ddListener.afterRename(runtime, random, origin, runs, result, millis);
            }
            if (swt == ACTION.SWITCH.CONTINUE) {
                InterceptorProxy.after(runtime, random, action, origin, runs, result, millis);
            }
            throw throwable;
        }
        long millis = System.currentTimeMillis() - fr;
        if (runs.size() > 1 && ConfigTable.IS_LOG_SQL_TIME && log.isInfoEnabled()) {
            log.info("{}[action:{}][name:{}][rename:{}][cmds:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, origin.getName(), name, runs.size(), result, millis});
        }
        swt = ACTION.SWITCH.CONTINUE;
        if (null != this.ddListener) {
            swt = this.ddListener.afterRename(runtime, random, origin, runs, result, millis);
        }
        if (swt == ACTION.SWITCH.CONTINUE) {
            InterceptorProxy.after(runtime, random, action, origin, runs, result, millis);
        }
        return result;
    }

    @Override
    public String keyword(Table meta) {
        return meta.getKeyword();
    }

    @Override
    public List<Run> buildCreateRun(DataRuntime runtime, Table meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildAlterRun(DataRuntime runtime, Table meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildAlterRun(DataRuntime runtime, Table meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildAlterRun(DataRuntime runtime, Table meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildAlterRun(DataRuntime runtime, Table table, Collection<Column> columns) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        for (Column column : columns) {
            ACTION.DDL action = column.getAction();
            CMD cmd = null;
            if (null != action) {
                cmd = action.getCmd();
            }
            if (CMD.CREATE == cmd) {
                runs.addAll(this.buildAddRun(runtime, column, false));
                continue;
            }
            if (CMD.ALTER == cmd) {
                runs.addAll(this.buildAlterRun(runtime, column, false));
                continue;
            }
            if (CMD.DROP != cmd) continue;
            runs.addAll(this.buildDropRun(runtime, column, false));
        }
        return runs;
    }

    @Override
    public List<Run> buildRenameRun(DataRuntime runtime, Table meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildRenameRun(DataRuntime runtime, Table meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildDropRun(DataRuntime runtime, Table meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildDropRun(DataRuntime runtime, Table meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildAppendCommentRun(DataRuntime runtime, Table meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildAppendCommentRun(DataRuntime runtime, Table meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildChangeCommentRun(DataRuntime runtime, Table meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildChangeCommentRun(DataRuntime runtime, Table meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public StringBuilder checkTableExists(DataRuntime runtime, StringBuilder builder, boolean exists) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 StringBuilder checkTableExists(DataRuntime runtime, StringBuilder builder, boolean exists)"), (int)37));
        }
        return builder;
    }

    @Override
    public StringBuilder primary(DataRuntime runtime, StringBuilder builder, Table meta) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 StringBuilder primary(DataRuntime runtime, StringBuilder builder, Table meta)"), (int)37));
        }
        return builder;
    }

    @Override
    public StringBuilder charset(DataRuntime runtime, StringBuilder builder, Table meta) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 StringBuilder charset(DataRuntime runtime, StringBuilder builder, Table meta)"), (int)37));
        }
        return builder;
    }

    @Override
    public StringBuilder comment(DataRuntime runtime, StringBuilder builder, Table meta) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 StringBuilder comment(DataRuntime runtime, StringBuilder builder, Table meta)"), (int)37));
        }
        return builder;
    }

    @Override
    public StringBuilder partitionBy(DataRuntime runtime, StringBuilder builder, Table meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 StringBuilder partitionBy(DataRuntime runtime, StringBuilder builder, Table meta)"), (int)37));
        }
        return builder;
    }

    @Override
    public StringBuilder partitionOf(DataRuntime runtime, StringBuilder builder, Table meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 StringBuilder partitionOf(DataRuntime runtime, StringBuilder builder, Table meta)"), (int)37));
        }
        return builder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean create(DataRuntime runtime, View meta) throws Exception {
        boolean result = false;
        ACTION.DDL action = ACTION.DDL.VIEW_CREATE;
        String random = this.random(runtime);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (null != this.ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = this.ddListener.prepareCreate(runtime, random, meta);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        this.checkSchema(runtime, meta);
        List<Run> runs = this.buildCreateRun(runtime, meta);
        swt = InterceptorProxy.before(runtime, random, action, meta, runs);
        if (null != this.ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = this.ddListener.beforeCreate(runtime, random, meta, runs);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        long fr = System.currentTimeMillis();
        try {
            result = this.execute(runtime, random, (BaseMetadata)meta, action, runs);
        }
        catch (Throwable throwable) {
            long millis = System.currentTimeMillis() - fr;
            if (runs.size() > 1 && ConfigTable.IS_LOG_SQL_TIME && log.isInfoEnabled()) {
                log.info("{}[action:{}][name:{}][cmds:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getName(), runs.size(), result, millis});
            }
            swt = ACTION.SWITCH.CONTINUE;
            if (null != this.ddListener) {
                swt = this.ddListener.afterCreate(runtime, random, meta, runs, result, millis);
            }
            if (swt == ACTION.SWITCH.CONTINUE) {
                InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
            }
            throw throwable;
        }
        long millis = System.currentTimeMillis() - fr;
        if (runs.size() > 1 && ConfigTable.IS_LOG_SQL_TIME && log.isInfoEnabled()) {
            log.info("{}[action:{}][name:{}][cmds:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getName(), runs.size(), result, millis});
        }
        swt = ACTION.SWITCH.CONTINUE;
        if (null != this.ddListener) {
            swt = this.ddListener.afterCreate(runtime, random, meta, runs, result, millis);
        }
        if (swt == ACTION.SWITCH.CONTINUE) {
            InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean alter(DataRuntime runtime, View meta) throws Exception {
        boolean result = false;
        ACTION.DDL action = ACTION.DDL.VIEW_ALTER;
        String random = this.random(runtime);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (null != this.ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = this.ddListener.prepareAlter(runtime, random, meta);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        this.checkSchema(runtime, meta);
        List<Run> runs = this.buildAlterRun(runtime, meta);
        swt = InterceptorProxy.before(runtime, random, action, meta, runs);
        if (null != this.ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = this.ddListener.beforeAlter(runtime, random, meta, runs);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        long fr = System.currentTimeMillis();
        try {
            result = this.execute(runtime, random, (BaseMetadata)meta, action, runs);
        }
        catch (Throwable throwable) {
            long millis = System.currentTimeMillis() - fr;
            if (runs.size() > 1 && ConfigTable.IS_LOG_SQL_TIME && log.isInfoEnabled()) {
                log.info("{}[action:{}][name:{}][cmds:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getName(), runs.size(), result, millis});
            }
            swt = ACTION.SWITCH.CONTINUE;
            if (null != this.ddListener) {
                swt = this.ddListener.afterAlter(runtime, random, meta, runs, result, millis);
            }
            if (swt == ACTION.SWITCH.CONTINUE) {
                InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
            }
            throw throwable;
        }
        long millis = System.currentTimeMillis() - fr;
        if (runs.size() > 1 && ConfigTable.IS_LOG_SQL_TIME && log.isInfoEnabled()) {
            log.info("{}[action:{}][name:{}][cmds:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getName(), runs.size(), result, millis});
        }
        swt = ACTION.SWITCH.CONTINUE;
        if (null != this.ddListener) {
            swt = this.ddListener.afterAlter(runtime, random, meta, runs, result, millis);
        }
        if (swt == ACTION.SWITCH.CONTINUE) {
            InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean drop(DataRuntime runtime, View meta) throws Exception {
        boolean result = false;
        ACTION.DDL action = ACTION.DDL.VIEW_DROP;
        String random = this.random(runtime);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (null != this.ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = this.ddListener.prepareDrop(runtime, random, meta);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        this.checkSchema(runtime, meta);
        List<Run> runs = this.buildDropRun(runtime, meta);
        swt = InterceptorProxy.before(runtime, random, action, meta, runs);
        if (null != this.ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = this.ddListener.beforeDrop(runtime, random, meta, runs);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        long fr = System.currentTimeMillis();
        try {
            result = this.execute(runtime, random, (BaseMetadata)meta, action, runs);
        }
        catch (Throwable throwable) {
            long millis = System.currentTimeMillis() - fr;
            if (runs.size() > 1 && ConfigTable.IS_LOG_SQL_TIME && log.isInfoEnabled()) {
                log.info("{}[action:{}][name:{}][cmds:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getName(), runs.size(), result, millis});
            }
            swt = ACTION.SWITCH.CONTINUE;
            if (null != this.ddListener) {
                swt = this.ddListener.afterDrop(runtime, random, meta, runs, result, millis);
            }
            if (swt == ACTION.SWITCH.CONTINUE) {
                InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
            }
            throw throwable;
        }
        long millis = System.currentTimeMillis() - fr;
        if (runs.size() > 1 && ConfigTable.IS_LOG_SQL_TIME && log.isInfoEnabled()) {
            log.info("{}[action:{}][name:{}][cmds:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getName(), runs.size(), result, millis});
        }
        swt = ACTION.SWITCH.CONTINUE;
        if (null != this.ddListener) {
            swt = this.ddListener.afterDrop(runtime, random, meta, runs, result, millis);
        }
        if (swt == ACTION.SWITCH.CONTINUE) {
            InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean rename(DataRuntime runtime, View origin, String name) throws Exception {
        boolean result = false;
        ACTION.DDL action = ACTION.DDL.VIEW_RENAME;
        String random = this.random(runtime);
        origin.setNewName(name);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, origin);
        if (null != this.ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = this.ddListener.prepareRename(runtime, random, origin);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        this.checkSchema(runtime, origin);
        List<Run> runs = this.buildRenameRun(runtime, origin);
        swt = InterceptorProxy.before(runtime, random, action, origin, runs);
        if (null != this.ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = this.ddListener.beforeRename(runtime, random, origin, runs);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        long fr = System.currentTimeMillis();
        try {
            result = this.execute(runtime, random, (BaseMetadata)origin, action, runs);
        }
        catch (Throwable throwable) {
            long millis = System.currentTimeMillis() - fr;
            if (runs.size() > 1 && ConfigTable.IS_LOG_SQL && log.isInfoEnabled()) {
                log.info("{}[action:{}][name:{}][rename:{}][cmds:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, origin.getName(), name, runs.size(), result, millis});
            }
            swt = ACTION.SWITCH.CONTINUE;
            if (null != this.ddListener) {
                swt = this.ddListener.afterRename(runtime, random, origin, runs, result, millis);
            }
            if (swt == ACTION.SWITCH.CONTINUE) {
                InterceptorProxy.after(runtime, random, action, origin, runs, result, millis);
            }
            throw throwable;
        }
        long millis = System.currentTimeMillis() - fr;
        if (runs.size() > 1 && ConfigTable.IS_LOG_SQL && log.isInfoEnabled()) {
            log.info("{}[action:{}][name:{}][rename:{}][cmds:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, origin.getName(), name, runs.size(), result, millis});
        }
        swt = ACTION.SWITCH.CONTINUE;
        if (null != this.ddListener) {
            swt = this.ddListener.afterRename(runtime, random, origin, runs, result, millis);
        }
        if (swt == ACTION.SWITCH.CONTINUE) {
            InterceptorProxy.after(runtime, random, action, origin, runs, result, millis);
        }
        return result;
    }

    @Override
    public List<Run> buildCreateRun(DataRuntime runtime, View meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildCreateRun(DataRuntime runtime, View meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildAlterRun(DataRuntime runtime, View meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildAlterRun(DataRuntime runtime, View meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildRenameRun(DataRuntime runtime, View meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildRenameRun(DataRuntime runtime, View meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildDropRun(DataRuntime runtime, View meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildDropRun(DataRuntime runtime, View meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildAppendCommentRun(DataRuntime runtime, View meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildAppendCommentRun(DataRuntime runtime, View meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildChangeCommentRun(DataRuntime runtime, View meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildChangeCommentRun(DataRuntime runtime, View meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public StringBuilder checkViewExists(DataRuntime runtime, StringBuilder builder, boolean exists) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 StringBuilder checkViewExists(DataRuntime runtime, StringBuilder builder, boolean exists)"), (int)37));
        }
        return builder;
    }

    @Override
    public StringBuilder comment(DataRuntime runtime, StringBuilder builder, View meta) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 StringBuilder comment(DataRuntime runtime, StringBuilder builder, View meta)"), (int)37));
        }
        return builder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean create(DataRuntime runtime, MasterTable meta) throws Exception {
        boolean result = false;
        ACTION.DDL action = ACTION.DDL.MASTER_TABLE_CREATE;
        String random = this.random(runtime);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (null != this.ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = this.ddListener.prepareCreate(runtime, random, meta);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        this.checkSchema(runtime, meta);
        List<Run> runs = this.buildCreateRun(runtime, meta);
        swt = InterceptorProxy.before(runtime, random, action, meta, runs);
        if (null != this.ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = this.ddListener.beforeCreate(runtime, random, meta, runs);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        long fr = System.currentTimeMillis();
        try {
            result = this.execute(runtime, random, (BaseMetadata)meta, action, runs);
        }
        catch (Throwable throwable) {
            long millis = System.currentTimeMillis() - fr;
            if (runs.size() > 1 && ConfigTable.IS_LOG_SQL && log.isInfoEnabled()) {
                log.info("{}[action:{}][name:{}][cmds:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getName(), runs.size(), result, millis});
            }
            swt = ACTION.SWITCH.CONTINUE;
            if (null != this.ddListener) {
                swt = this.ddListener.afterCreate(runtime, random, meta, runs, result, millis);
            }
            if (swt == ACTION.SWITCH.CONTINUE) {
                InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
            }
            throw throwable;
        }
        long millis = System.currentTimeMillis() - fr;
        if (runs.size() > 1 && ConfigTable.IS_LOG_SQL && log.isInfoEnabled()) {
            log.info("{}[action:{}][name:{}][cmds:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getName(), runs.size(), result, millis});
        }
        swt = ACTION.SWITCH.CONTINUE;
        if (null != this.ddListener) {
            swt = this.ddListener.afterCreate(runtime, random, meta, runs, result, millis);
        }
        if (swt == ACTION.SWITCH.CONTINUE) {
            InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
        }
        return result;
    }

    @Override
    public boolean alter(DataRuntime runtime, MasterTable meta) throws Exception {
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        String random = this.random(runtime);
        if (null != this.ddListener) {
            // empty if block
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        boolean result = true;
        this.checkSchema(runtime, meta);
        Table update = (Table)meta.getUpdate();
        LinkedHashMap columns = meta.getColumns();
        LinkedHashMap ucolumns = update.getColumns();
        LinkedHashMap tags = meta.getTags();
        LinkedHashMap utags = update.getTags();
        String name = meta.getName();
        String uname = update.getName();
        long fr = System.currentTimeMillis();
        if (!name.equalsIgnoreCase(uname)) {
            result = this.rename(runtime, meta, uname);
        }
        for (Column ucolumn : ucolumns.values()) {
            Column column = (Column)columns.get(ucolumn.getName().toUpperCase());
            if (null != column) {
                column.setTable(update);
                column.setUpdate((BaseMetadata)ucolumn, false, false);
                this.alter(runtime, column);
                result = true;
                continue;
            }
            ucolumn.setTable(update);
            this.add(runtime, ucolumn);
            result = true;
        }
        if (meta.isAutoDropColumn()) {
            for (Column column : columns.values()) {
                Column ucolumn;
                if (column instanceof Tag || null != (ucolumn = (Column)ucolumns.get(column.getName().toUpperCase()))) continue;
                column.setTable(update);
                this.drop(runtime, column);
                result = true;
            }
        }
        for (Tag utag : utags.values()) {
            Tag tag = (Tag)tags.get(utag.getName().toUpperCase());
            if (null != tag) {
                tag.setTable(update);
                tag.setUpdate(utag, false, false);
                this.alter(runtime, tag);
                result = true;
                continue;
            }
            utag.setTable(update);
            this.add(runtime, utag);
            result = true;
        }
        if (meta.isAutoDropColumn()) {
            for (Tag tag : tags.values()) {
                Tag utag = (Tag)utags.get(tag.getName().toUpperCase());
                if (null != utag) continue;
                tag.setTable(update);
                this.drop(runtime, tag);
                result = true;
            }
        }
        if (ConfigTable.IS_LOG_SQL && log.isInfoEnabled()) {
            log.info("{}[alter master table][table:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, meta.getName(), result, System.currentTimeMillis() - fr});
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean drop(DataRuntime runtime, MasterTable meta) throws Exception {
        boolean result = false;
        ACTION.DDL action = ACTION.DDL.MASTER_TABLE_DROP;
        String random = this.random(runtime);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (null != this.ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = this.ddListener.prepareDrop(runtime, random, meta);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        this.checkSchema(runtime, meta);
        List<Run> runs = this.buildDropRun(runtime, meta);
        swt = InterceptorProxy.before(runtime, random, action, meta, runs);
        if (null != this.ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = this.ddListener.beforeDrop(runtime, random, meta, runs);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        long fr = System.currentTimeMillis();
        try {
            result = this.execute(runtime, random, (BaseMetadata)meta, action, runs);
        }
        catch (Throwable throwable) {
            long millis = System.currentTimeMillis() - fr;
            if (runs.size() > 1 && ConfigTable.IS_LOG_SQL && log.isInfoEnabled()) {
                log.info("{}[action:{}][name:{}][cmds:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getName(), runs.size(), result, millis});
            }
            swt = ACTION.SWITCH.CONTINUE;
            if (null != this.ddListener) {
                swt = this.ddListener.afterDrop(runtime, random, meta, runs, result, millis);
            }
            if (swt == ACTION.SWITCH.CONTINUE) {
                InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
            }
            throw throwable;
        }
        long millis = System.currentTimeMillis() - fr;
        if (runs.size() > 1 && ConfigTable.IS_LOG_SQL && log.isInfoEnabled()) {
            log.info("{}[action:{}][name:{}][cmds:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getName(), runs.size(), result, millis});
        }
        swt = ACTION.SWITCH.CONTINUE;
        if (null != this.ddListener) {
            swt = this.ddListener.afterDrop(runtime, random, meta, runs, result, millis);
        }
        if (swt == ACTION.SWITCH.CONTINUE) {
            InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean rename(DataRuntime runtime, MasterTable origin, String name) throws Exception {
        boolean result = false;
        ACTION.DDL action = ACTION.DDL.MASTER_TABLE_RENAME;
        String random = this.random(runtime);
        origin.setNewName(name);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, origin);
        if (null != this.ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = this.ddListener.prepareRename(runtime, random, origin);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        this.checkSchema(runtime, origin);
        List<Run> runs = this.buildRenameRun(runtime, origin);
        swt = InterceptorProxy.before(runtime, random, action, origin, runs);
        if (null != this.ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = this.ddListener.beforeRename(runtime, random, origin, runs);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        long fr = System.currentTimeMillis();
        try {
            result = this.execute(runtime, random, (BaseMetadata)origin, action, runs);
        }
        catch (Throwable throwable) {
            long millis = System.currentTimeMillis() - fr;
            if (runs.size() > 1 && ConfigTable.IS_LOG_SQL && log.isInfoEnabled()) {
                log.info("{}[action:{}][name:{}][rename:{}][cmds:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, origin.getName(), name, runs.size(), result, millis});
            }
            swt = ACTION.SWITCH.CONTINUE;
            if (null != this.ddListener) {
                swt = this.ddListener.afterRename(runtime, random, origin, runs, result, millis);
            }
            if (swt == ACTION.SWITCH.CONTINUE) {
                swt = InterceptorProxy.after(runtime, random, action, origin, runs, result, millis);
            }
            throw throwable;
        }
        long millis = System.currentTimeMillis() - fr;
        if (runs.size() > 1 && ConfigTable.IS_LOG_SQL && log.isInfoEnabled()) {
            log.info("{}[action:{}][name:{}][rename:{}][cmds:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, origin.getName(), name, runs.size(), result, millis});
        }
        swt = ACTION.SWITCH.CONTINUE;
        if (null != this.ddListener) {
            swt = this.ddListener.afterRename(runtime, random, origin, runs, result, millis);
        }
        if (swt == ACTION.SWITCH.CONTINUE) {
            swt = InterceptorProxy.after(runtime, random, action, origin, runs, result, millis);
        }
        return result;
    }

    @Override
    public List<Run> buildCreateRun(DataRuntime runtime, MasterTable meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildCreateRun(DataRuntime runtime, MasterTable meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildDropRun(DataRuntime runtime, MasterTable meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildDropRun(DataRuntime runtime, MasterTable meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildAlterRun(DataRuntime runtime, MasterTable meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildAlterRun(DataRuntime runtime, MasterTable meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildRenameRun(DataRuntime runtime, MasterTable meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildRenameRun(DataRuntime runtime, MasterTable meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildAppendCommentRun(DataRuntime runtime, MasterTable meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildAppendCommentRun(DataRuntime runtime, MasterTable meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildChangeCommentRun(DataRuntime runtime, MasterTable meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildChangeCommentRun(DataRuntime runtime, MasterTable meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean create(DataRuntime runtime, PartitionTable meta) throws Exception {
        boolean result = false;
        ACTION.DDL action = ACTION.DDL.PARTITION_TABLE_CREATE;
        String random = this.random(runtime);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (null != this.ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = this.ddListener.prepareCreate(runtime, random, meta);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        this.checkSchema(runtime, meta);
        List<Run> runs = this.buildCreateRun(runtime, meta);
        swt = InterceptorProxy.before(runtime, random, action, meta, runs);
        if (null != this.ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = this.ddListener.beforeCreate(runtime, random, meta, runs);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        long fr = System.currentTimeMillis();
        try {
            result = this.execute(runtime, random, (BaseMetadata)meta, action, runs);
        }
        catch (Throwable throwable) {
            long millis = System.currentTimeMillis() - fr;
            if (runs.size() > 1 && ConfigTable.IS_LOG_SQL && log.isInfoEnabled()) {
                log.info("{}[action:{}][master:{}][name:{}][cmds:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getMasterName(), meta.getName(), runs.size(), result, millis});
            }
            swt = ACTION.SWITCH.CONTINUE;
            if (null != this.ddListener) {
                swt = this.ddListener.afterCreate(runtime, random, meta, runs, result, millis);
            }
            if (swt == ACTION.SWITCH.CONTINUE) {
                InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
            }
            throw throwable;
        }
        long millis = System.currentTimeMillis() - fr;
        if (runs.size() > 1 && ConfigTable.IS_LOG_SQL && log.isInfoEnabled()) {
            log.info("{}[action:{}][master:{}][name:{}][cmds:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getMasterName(), meta.getName(), runs.size(), result, millis});
        }
        swt = ACTION.SWITCH.CONTINUE;
        if (null != this.ddListener) {
            swt = this.ddListener.afterCreate(runtime, random, meta, runs, result, millis);
        }
        if (swt == ACTION.SWITCH.CONTINUE) {
            InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
        }
        return result;
    }

    @Override
    public boolean alter(DataRuntime runtime, PartitionTable meta) throws Exception {
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        String random = this.random(runtime);
        if (null != this.ddListener) {
            // empty if block
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        boolean result = true;
        this.checkSchema(runtime, meta);
        Table update = (Table)meta.getUpdate();
        LinkedHashMap columns = meta.getColumns();
        LinkedHashMap ucolumns = update.getColumns();
        String name = meta.getName();
        String uname = update.getName();
        long fr = System.currentTimeMillis();
        if (!name.equalsIgnoreCase(uname)) {
            result = this.rename(runtime, meta, uname);
        }
        for (Column ucolumn : ucolumns.values()) {
            Column column = (Column)columns.get(ucolumn.getName().toUpperCase());
            if (null != column) {
                column.setTable(update);
                column.setUpdate((BaseMetadata)ucolumn, false, false);
                this.alter(runtime, column);
                result = true;
                continue;
            }
            ucolumn.setTable(update);
            this.add(runtime, ucolumn);
            result = true;
        }
        if (meta.isAutoDropColumn()) {
            for (Column column : columns.values()) {
                Column ucolumn;
                if (column instanceof Tag || null != (ucolumn = (Column)ucolumns.get(column.getName().toUpperCase()))) continue;
                column.setTable(update);
                this.drop(runtime, column);
                result = true;
            }
        }
        if (null != this.ddListener) {
            // empty if block
        }
        if (ConfigTable.IS_LOG_SQL && log.isInfoEnabled()) {
            log.info("{}[alter partition table][table:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, meta.getName(), result, System.currentTimeMillis() - fr});
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean drop(DataRuntime runtime, PartitionTable meta) throws Exception {
        boolean result = false;
        ACTION.DDL action = ACTION.DDL.PARTITION_TABLE_DROP;
        String random = this.random(runtime);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (null != this.ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = this.ddListener.prepareDrop(runtime, random, meta);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        this.checkSchema(runtime, meta);
        List<Run> runs = this.buildDropRun(runtime, meta);
        swt = InterceptorProxy.before(runtime, random, action, meta, runs);
        if (null != this.ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = this.ddListener.beforeDrop(runtime, random, meta, runs);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        long fr = System.currentTimeMillis();
        try {
            result = this.execute(runtime, random, (BaseMetadata)meta, action, runs);
        }
        catch (Throwable throwable) {
            long millis = System.currentTimeMillis() - fr;
            if (runs.size() > 1 && ConfigTable.IS_LOG_SQL && log.isInfoEnabled()) {
                log.info("{}[action:{}][master:{}][name:{}][cmds:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getMasterName(), meta.getName(), runs.size(), result, millis});
            }
            swt = ACTION.SWITCH.CONTINUE;
            if (null != this.ddListener) {
                swt = this.ddListener.afterDrop(runtime, random, meta, runs, result, millis);
            }
            if (swt == ACTION.SWITCH.CONTINUE) {
                InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
            }
            throw throwable;
        }
        long millis = System.currentTimeMillis() - fr;
        if (runs.size() > 1 && ConfigTable.IS_LOG_SQL && log.isInfoEnabled()) {
            log.info("{}[action:{}][master:{}][name:{}][cmds:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getMasterName(), meta.getName(), runs.size(), result, millis});
        }
        swt = ACTION.SWITCH.CONTINUE;
        if (null != this.ddListener) {
            swt = this.ddListener.afterDrop(runtime, random, meta, runs, result, millis);
        }
        if (swt == ACTION.SWITCH.CONTINUE) {
            InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean rename(DataRuntime runtime, PartitionTable origin, String name) throws Exception {
        boolean result = false;
        ACTION.DDL action = ACTION.DDL.PARTITION_TABLE_RENAME;
        origin.setNewName(name);
        String random = this.random(runtime);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, origin);
        if (null != this.ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = this.ddListener.prepareRename(runtime, random, origin);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        this.checkSchema(runtime, origin);
        List<Run> runs = this.buildRenameRun(runtime, origin);
        swt = InterceptorProxy.before(runtime, random, action, origin, runs);
        if (null != this.ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = this.ddListener.beforeRename(runtime, random, origin, runs);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        long fr = System.currentTimeMillis();
        try {
            result = this.execute(runtime, random, (BaseMetadata)origin, action, runs);
        }
        catch (Throwable throwable) {
            long millis = System.currentTimeMillis() - fr;
            if (runs.size() > 1 && ConfigTable.IS_LOG_SQL && log.isInfoEnabled()) {
                log.info("{}[action:{}][master:{}][name:{}][rename:{}][cmds:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, origin.getMasterName(), origin.getName(), name, runs.size(), result, millis});
            }
            swt = ACTION.SWITCH.CONTINUE;
            if (null != this.ddListener) {
                swt = this.ddListener.afterRename(runtime, random, origin, runs, result, millis);
            }
            if (swt == ACTION.SWITCH.CONTINUE) {
                InterceptorProxy.after(runtime, random, action, origin, runs, result, millis);
            }
            throw throwable;
        }
        long millis = System.currentTimeMillis() - fr;
        if (runs.size() > 1 && ConfigTable.IS_LOG_SQL && log.isInfoEnabled()) {
            log.info("{}[action:{}][master:{}][name:{}][rename:{}][cmds:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, origin.getMasterName(), origin.getName(), name, runs.size(), result, millis});
        }
        swt = ACTION.SWITCH.CONTINUE;
        if (null != this.ddListener) {
            swt = this.ddListener.afterRename(runtime, random, origin, runs, result, millis);
        }
        if (swt == ACTION.SWITCH.CONTINUE) {
            InterceptorProxy.after(runtime, random, action, origin, runs, result, millis);
        }
        return result;
    }

    @Override
    public List<Run> buildCreateRun(DataRuntime runtime, PartitionTable meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildCreateRun(DataRuntime runtime, PartitionTable meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildAppendCommentRun(DataRuntime runtime, PartitionTable meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildAppendCommentRun(DataRuntime runtime, PartitionTable meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildAlterRun(DataRuntime runtime, PartitionTable meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildAlterRun(DataRuntime runtime, PartitionTable meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildDropRun(DataRuntime runtime, PartitionTable meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildDropRun(DataRuntime runtime, PartitionTable meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildRenameRun(DataRuntime runtime, PartitionTable meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildRenameRun(DataRuntime runtime, PartitionTable meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildChangeCommentRun(DataRuntime runtime, PartitionTable meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildChangeCommentRun(DataRuntime runtime, PartitionTable meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(DataRuntime runtime, Column meta) throws Exception {
        boolean result = false;
        ACTION.DDL action = ACTION.DDL.COLUMN_ADD;
        String random = this.random(runtime);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (null != this.ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = this.ddListener.prepareAdd(runtime, random, meta);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        this.checkSchema(runtime, meta);
        List<Run> runs = this.buildAddRun(runtime, meta);
        swt = InterceptorProxy.before(runtime, random, action, meta, runs);
        if (null != this.ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = this.ddListener.beforeAdd(runtime, random, meta, runs);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        long fr = System.currentTimeMillis();
        try {
            result = this.execute(runtime, random, (BaseMetadata)meta, action, runs);
        }
        catch (Throwable throwable) {
            long millis = System.currentTimeMillis() - fr;
            if (runs.size() > 1 && ConfigTable.IS_LOG_SQL && log.isInfoEnabled()) {
                log.info("{}[action:{}][table:{}][name:{}][cmds:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getTableName(true), meta.getName(), runs.size(), result, millis});
            }
            swt = ACTION.SWITCH.CONTINUE;
            if (null != this.ddListener) {
                swt = this.ddListener.afterAdd(runtime, random, meta, runs, result, millis);
            }
            if (swt == ACTION.SWITCH.CONTINUE) {
                InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
            }
            throw throwable;
        }
        long millis = System.currentTimeMillis() - fr;
        if (runs.size() > 1 && ConfigTable.IS_LOG_SQL && log.isInfoEnabled()) {
            log.info("{}[action:{}][table:{}][name:{}][cmds:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getTableName(true), meta.getName(), runs.size(), result, millis});
        }
        swt = ACTION.SWITCH.CONTINUE;
        if (null != this.ddListener) {
            swt = this.ddListener.afterAdd(runtime, random, meta, runs, result, millis);
        }
        if (swt == ACTION.SWITCH.CONTINUE) {
            InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean alter(DataRuntime runtime, Table table, Column meta, boolean trigger) throws Exception {
        boolean result = false;
        ACTION.DDL action = ACTION.DDL.COLUMN_ALTER;
        String random = this.random(runtime);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (null != this.ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = this.ddListener.prepareAlter(runtime, random, meta);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        this.checkSchema(runtime, meta);
        List<Run> runs = this.buildAlterRun(runtime, meta, false);
        swt = InterceptorProxy.before(runtime, random, action, meta, runs);
        if (null != this.ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = this.ddListener.beforeAlter(runtime, random, meta, runs);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        long fr = System.currentTimeMillis();
        try {
            result = this.execute(runtime, random, (BaseMetadata)meta, action, runs);
        }
        catch (Exception e) {
            block21: {
                try {
                    if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                        e.printStackTrace();
                    }
                    log.warn("{}[{}][exception:{}]", new Object[]{random, LogUtil.format((String)"\u4fee\u6539Column\u6267\u884c\u5f02\u5e38", (int)33), e.toString()});
                    if (trigger && null != this.ddListener && !BasicUtil.equalsIgnoreCase((Object)meta.getTypeName(), (Object)((Column)meta.getUpdate()).getTypeName())) {
                        if (ConfigTable.AFTER_ALTER_COLUMN_EXCEPTION_ACTION != 0) {
                            swt = this.ddListener.afterAlterColumnException(runtime, random, table, meta, e);
                        }
                        log.warn("{}[\u4fee\u6539Column\u6267\u884c\u5f02\u5e38][\u5c1d\u8bd5\u4fee\u6b63\u6570\u636e][\u4fee\u6b63\u7ed3\u679c:{}]", (Object)random, (Object)swt);
                        if (swt == ACTION.SWITCH.CONTINUE) {
                            result = this.alter(runtime, table, meta, false);
                        }
                        break block21;
                    }
                    log.error("{}[\u4fee\u6539Column\u6267\u884c\u5f02\u5e38][\u4e2d\u65ad\u6267\u884c]", (Object)random);
                    result = false;
                    throw e;
                }
                catch (Throwable throwable) {
                    long millis = System.currentTimeMillis() - fr;
                    if (runs.size() > 1 && ConfigTable.IS_LOG_SQL && log.isInfoEnabled()) {
                        log.info("{}[action:{}][table:{}][name:{}][cmds:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getTableName(true), meta.getName(), runs.size(), result, millis});
                    }
                    swt = ACTION.SWITCH.CONTINUE;
                    if (null != this.ddListener) {
                        swt = this.ddListener.afterAlter(runtime, random, meta, runs, result, millis);
                    }
                    if (swt == ACTION.SWITCH.CONTINUE) {
                        InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
                    }
                    throw throwable;
                }
            }
            long millis = System.currentTimeMillis() - fr;
            if (runs.size() > 1 && ConfigTable.IS_LOG_SQL && log.isInfoEnabled()) {
                log.info("{}[action:{}][table:{}][name:{}][cmds:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getTableName(true), meta.getName(), runs.size(), result, millis});
            }
            swt = ACTION.SWITCH.CONTINUE;
            if (null != this.ddListener) {
                swt = this.ddListener.afterAlter(runtime, random, meta, runs, result, millis);
            }
            if (swt == ACTION.SWITCH.CONTINUE) {
                InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
            }
        }
        long millis = System.currentTimeMillis() - fr;
        if (runs.size() > 1 && ConfigTable.IS_LOG_SQL && log.isInfoEnabled()) {
            log.info("{}[action:{}][table:{}][name:{}][cmds:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getTableName(true), meta.getName(), runs.size(), result, millis});
        }
        swt = ACTION.SWITCH.CONTINUE;
        if (null != this.ddListener) {
            swt = this.ddListener.afterAlter(runtime, random, meta, runs, result, millis);
        }
        if (swt == ACTION.SWITCH.CONTINUE) {
            InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
        }
        return result;
    }

    @Override
    public boolean alter(DataRuntime runtime, Column meta) throws Exception {
        Table table = meta.getTable(true);
        if (null == table) {
            LinkedHashMap tables = this.tables(runtime, null, meta.getCatalog(), meta.getSchema(), meta.getTableName(true), "TABLE");
            if (tables.isEmpty()) {
                if (ConfigTable.IS_THROW_SQL_UPDATE_EXCEPTION) {
                    throw new AnylineException("\u8868\u4e0d\u5b58\u5728:" + meta.getTableName(true));
                }
                log.error("\u8868\u4e0d\u5b58\u5728:" + meta.getTableName(true));
            } else {
                table = (Table)tables.values().iterator().next();
            }
        }
        return this.alter(runtime, table, meta, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean drop(DataRuntime runtime, Column meta) throws Exception {
        boolean result = false;
        ACTION.DDL action = ACTION.DDL.COLUMN_DROP;
        String random = this.random(runtime);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (null != this.ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = this.ddListener.prepareDrop(runtime, random, meta);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        this.checkSchema(runtime, meta);
        List<Run> runs = this.buildDropRun(runtime, meta);
        swt = InterceptorProxy.before(runtime, random, action, meta, runs);
        if (null != this.ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = this.ddListener.beforeDrop(runtime, random, meta, runs);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        long fr = System.currentTimeMillis();
        try {
            result = this.execute(runtime, random, (BaseMetadata)meta, action, runs);
        }
        catch (Throwable throwable) {
            long millis = System.currentTimeMillis() - fr;
            if (runs.size() > 1 && ConfigTable.IS_LOG_SQL && log.isInfoEnabled()) {
                log.info("{}[action:{}][table:{}][name:{}][cmds:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getTableName(true), meta.getName(), runs.size(), result, millis});
            }
            swt = ACTION.SWITCH.CONTINUE;
            if (null != this.ddListener) {
                swt = this.ddListener.afterDrop(runtime, random, meta, runs, result, millis);
            }
            if (swt == ACTION.SWITCH.CONTINUE) {
                InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
            }
            throw throwable;
        }
        long millis = System.currentTimeMillis() - fr;
        if (runs.size() > 1 && ConfigTable.IS_LOG_SQL && log.isInfoEnabled()) {
            log.info("{}[action:{}][table:{}][name:{}][cmds:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getTableName(true), meta.getName(), runs.size(), result, millis});
        }
        swt = ACTION.SWITCH.CONTINUE;
        if (null != this.ddListener) {
            swt = this.ddListener.afterDrop(runtime, random, meta, runs, result, millis);
        }
        if (swt == ACTION.SWITCH.CONTINUE) {
            InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean rename(DataRuntime runtime, Column origin, String name) throws Exception {
        boolean result = false;
        ACTION.DDL action = ACTION.DDL.COLUMN_RENAME;
        String random = this.random(runtime);
        origin.setNewName(name);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, origin);
        if (null != this.ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = this.ddListener.prepareRename(runtime, random, origin);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        this.checkSchema(runtime, origin);
        List<Run> runs = this.buildRenameRun(runtime, origin);
        swt = InterceptorProxy.before(runtime, random, action, origin, runs);
        if (null != this.ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = this.ddListener.beforeRename(runtime, random, origin, runs);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        long fr = System.currentTimeMillis();
        try {
            result = this.execute(runtime, random, (BaseMetadata)origin, action, runs);
        }
        catch (Throwable throwable) {
            long millis = System.currentTimeMillis() - fr;
            if (runs.size() > 1 && ConfigTable.IS_LOG_SQL && log.isInfoEnabled()) {
                log.info("{}[action:{}][table:{}][name:{}][rename:{}][cmds:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, origin.getTableName(true), origin.getName(), name, runs.size(), result, millis});
            }
            swt = ACTION.SWITCH.CONTINUE;
            if (null != this.ddListener) {
                swt = this.ddListener.afterRename(runtime, random, origin, runs, result, millis);
            }
            if (swt == ACTION.SWITCH.CONTINUE) {
                InterceptorProxy.after(runtime, random, action, origin, runs, result, millis);
            }
            throw throwable;
        }
        long millis = System.currentTimeMillis() - fr;
        if (runs.size() > 1 && ConfigTable.IS_LOG_SQL && log.isInfoEnabled()) {
            log.info("{}[action:{}][table:{}][name:{}][rename:{}][cmds:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, origin.getTableName(true), origin.getName(), name, runs.size(), result, millis});
        }
        swt = ACTION.SWITCH.CONTINUE;
        if (null != this.ddListener) {
            swt = this.ddListener.afterRename(runtime, random, origin, runs, result, millis);
        }
        if (swt == ACTION.SWITCH.CONTINUE) {
            InterceptorProxy.after(runtime, random, action, origin, runs, result, millis);
        }
        return result;
    }

    @Override
    public List<Run> buildAddRun(DataRuntime runtime, Column meta, boolean slice) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildAddRun(DataRuntime runtime, Column meta, boolean slice)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildAddRun(DataRuntime runtime, Column meta) throws Exception {
        return this.buildAddRun(runtime, meta, false);
    }

    @Override
    public List<Run> buildAlterRun(DataRuntime runtime, Column meta, boolean slice) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildAlterRun(DataRuntime runtime, Column meta, boolean slice)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildAlterRun(DataRuntime runtime, Column meta) throws Exception {
        return this.buildAlterRun(runtime, meta, false);
    }

    @Override
    public List<Run> buildDropRun(DataRuntime runtime, Column meta, boolean slice) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildDropRun(DataRuntime runtime, Column meta, boolean slice)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildDropRun(DataRuntime runtime, Column meta) throws Exception {
        return this.buildDropRun(runtime, meta, false);
    }

    @Override
    public List<Run> buildRenameRun(DataRuntime runtime, Column meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildRenameRun(DataRuntime runtime, Column meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildChangeTypeRun(DataRuntime runtime, Column meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildChangeTypeRun(DataRuntime runtime, Column meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public String alterColumnKeyword(DataRuntime runtime) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 String alterColumnKeyword(DataRuntime runtime)"), (int)37));
        }
        return null;
    }

    @Override
    public StringBuilder addColumnGuide(DataRuntime runtime, StringBuilder builder, Column meta) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 StringBuilder addColumnGuide(DataRuntime runtime, StringBuilder builder, Column meta)"), (int)37));
        }
        return builder;
    }

    @Override
    public StringBuilder dropColumnGuide(DataRuntime runtime, StringBuilder builder, Column meta) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 StringBuilder dropColumnGuide(DataRuntime runtime, StringBuilder builder, Column meta)"), (int)37));
        }
        return builder;
    }

    @Override
    public List<Run> buildChangeDefaultRun(DataRuntime runtime, Column meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildChangeDefaultRun(DataRuntime runtime, Column meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildChangeNullableRun(DataRuntime runtime, Column meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildChangeNullableRun(DataRuntime runtime, Column meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildChangeCommentRun(DataRuntime runtime, Column meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildChangeCommentRun(DataRuntime runtime, Column meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildAppendCommentRun(DataRuntime runtime, Column meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildAppendCommentRun(DataRuntime runtime, Column meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildDropAutoIncrement(DataRuntime runtime, Column meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildDropAutoIncrement(DataRuntime runtime, Column meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public StringBuilder define(DataRuntime runtime, StringBuilder builder, Column meta) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 StringBuilder define(DataRuntime runtime, StringBuilder builder, Column meta)"), (int)37));
        }
        return builder;
    }

    @Override
    public StringBuilder checkColumnExists(DataRuntime runtime, StringBuilder builder, boolean exists) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 checkColumnExists(DataRuntime runtime, StringBuilder builder, boolean exists)"), (int)37));
        }
        return builder;
    }

    @Override
    public StringBuilder type(DataRuntime runtime, StringBuilder builder, Column meta) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 StringBuilder type(DataRuntime runtime, StringBuilder builder, Column meta)"), (int)37));
        }
        return builder;
    }

    @Override
    public StringBuilder type(DataRuntime runtime, StringBuilder builder, Column meta, String type, boolean isIgnorePrecision, boolean isIgnoreScale) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 StringBuilder type(DataRuntime runtime, StringBuilder builder, Column meta, String type, boolean isIgnorePrecision, boolean isIgnoreScale)"), (int)37));
        }
        return builder;
    }

    @Override
    public boolean isIgnorePrecision(DataRuntime runtime, Column meta) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 boolean isIgnorePrecision(DataRuntime runtime, Column meta)"), (int)37));
        }
        return false;
    }

    @Override
    public boolean isIgnoreScale(DataRuntime runtime, Column meta) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 boolean isIgnoreScale(DataRuntime runtime, Column meta)"), (int)37));
        }
        return false;
    }

    @Override
    public Boolean checkIgnorePrecision(DataRuntime runtime, String type) {
        if ((type = type.toUpperCase()).contains("INT")) {
            return false;
        }
        if (type.contains("DATE")) {
            return true;
        }
        if (type.contains("TIME")) {
            return true;
        }
        if (type.contains("YEAR")) {
            return true;
        }
        if (type.contains("TEXT")) {
            return true;
        }
        if (type.contains("BLOB")) {
            return true;
        }
        if (type.contains("JSON")) {
            return true;
        }
        if (type.contains("POINT")) {
            return true;
        }
        if (type.contains("LINE")) {
            return true;
        }
        if (type.contains("POLYGON")) {
            return true;
        }
        if (type.contains("GEOMETRY")) {
            return true;
        }
        return null;
    }

    @Override
    public Boolean checkIgnoreScale(DataRuntime runtime, String type) {
        if ((type = type.toUpperCase()).contains("INT")) {
            return true;
        }
        if (type.contains("DATE")) {
            return true;
        }
        if (type.contains("TIME")) {
            return true;
        }
        if (type.contains("YEAR")) {
            return true;
        }
        if (type.contains("TEXT")) {
            return true;
        }
        if (type.contains("BLOB")) {
            return true;
        }
        if (type.contains("JSON")) {
            return true;
        }
        if (type.contains("POINT")) {
            return true;
        }
        if (type.contains("LINE")) {
            return true;
        }
        if (type.contains("POLYGON")) {
            return true;
        }
        if (type.contains("GEOMETRY")) {
            return true;
        }
        return null;
    }

    @Override
    public StringBuilder nullable(DataRuntime runtime, StringBuilder builder, Column meta) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 StringBuilder nullable(DataRuntime runtime, StringBuilder builder, Column meta)"), (int)37));
        }
        return builder;
    }

    @Override
    public StringBuilder charset(DataRuntime runtime, StringBuilder builder, Column meta) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 StringBuilder charset(DataRuntime runtime, StringBuilder builder, Column meta)"), (int)37));
        }
        return builder;
    }

    @Override
    public StringBuilder defaultValue(DataRuntime runtime, StringBuilder builder, Column meta) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 StringBuilder defaultValue(DataRuntime runtime, StringBuilder builder, Column meta)"), (int)37));
        }
        return builder;
    }

    @Override
    public StringBuilder primary(DataRuntime runtime, StringBuilder builder, Column meta) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 StringBuilder primary(DataRuntime runtime, StringBuilder builder, Column meta)"), (int)37));
        }
        return builder;
    }

    @Override
    public StringBuilder increment(DataRuntime runtime, StringBuilder builder, Column meta) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 StringBuilder increment(DataRuntime runtime, StringBuilder builder, Column meta)"), (int)37));
        }
        return builder;
    }

    @Override
    public StringBuilder onupdate(DataRuntime runtime, StringBuilder builder, Column meta) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 StringBuilder onupdate(DataRuntime runtime, StringBuilder builder, Column meta)"), (int)37));
        }
        return builder;
    }

    @Override
    public StringBuilder position(DataRuntime runtime, StringBuilder builder, Column meta) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 StringBuilder position(DataRuntime runtime, StringBuilder builder, Column meta)"), (int)37));
        }
        return builder;
    }

    @Override
    public StringBuilder comment(DataRuntime runtime, StringBuilder builder, Column meta) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 StringBuilder comment(DataRuntime runtime, StringBuilder builder, Column meta)"), (int)37));
        }
        return builder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(DataRuntime runtime, Tag meta) throws Exception {
        boolean result = false;
        ACTION.DDL action = ACTION.DDL.TAG_ADD;
        String random = this.random(runtime);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (null != this.ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = this.ddListener.prepareAdd(runtime, random, (Column)meta);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        this.checkSchema(runtime, meta);
        List<Run> runs = this.buildAddRun(runtime, meta);
        swt = InterceptorProxy.before(runtime, random, action, meta, runs);
        if (null != this.ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = this.ddListener.beforeAdd(runtime, random, (Column)meta, runs);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        long fr = System.currentTimeMillis();
        try {
            result = this.execute(runtime, random, (BaseMetadata)meta, action, runs);
        }
        catch (Throwable throwable) {
            long millis = System.currentTimeMillis() - fr;
            if (runs.size() > 1 && ConfigTable.IS_LOG_SQL && log.isInfoEnabled()) {
                log.info("{}[action:{}][table:{}][name:{}][cmds:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getTableName(true), meta.getName(), runs.size(), result, millis});
            }
            swt = ACTION.SWITCH.CONTINUE;
            if (null != this.ddListener) {
                swt = this.ddListener.afterAdd(runtime, random, (Column)meta, runs, result, millis);
            }
            if (swt == ACTION.SWITCH.CONTINUE) {
                InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
            }
            throw throwable;
        }
        long millis = System.currentTimeMillis() - fr;
        if (runs.size() > 1 && ConfigTable.IS_LOG_SQL && log.isInfoEnabled()) {
            log.info("{}[action:{}][table:{}][name:{}][cmds:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getTableName(true), meta.getName(), runs.size(), result, millis});
        }
        swt = ACTION.SWITCH.CONTINUE;
        if (null != this.ddListener) {
            swt = this.ddListener.afterAdd(runtime, random, (Column)meta, runs, result, millis);
        }
        if (swt == ACTION.SWITCH.CONTINUE) {
            InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean alter(DataRuntime runtime, Table table, Tag meta, boolean trigger) throws Exception {
        boolean result = false;
        ACTION.DDL action = ACTION.DDL.TAG_ALTER;
        String random = this.random(runtime);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (null != this.ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = this.ddListener.prepareAlter(runtime, random, (Column)meta);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        this.checkSchema(runtime, meta);
        List<Run> runs = this.buildAlterRun(runtime, (Column)meta, false);
        long fr = System.currentTimeMillis();
        try {
            result = this.execute(runtime, random, (BaseMetadata)meta, action, runs);
        }
        catch (Exception e) {
            block19: {
                try {
                    if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                        e.printStackTrace();
                    }
                    log.warn("{}[{}][exception:{}]", new Object[]{random, LogUtil.format((String)"\u4fee\u6539TAG\u6267\u884c\u5f02\u5e38", (int)33), e.toString()});
                    if (trigger && null != this.ddListener && !BasicUtil.equalsIgnoreCase((Object)meta.getTypeName(), (Object)meta.getUpdate().getTypeName())) {
                        if (ConfigTable.AFTER_ALTER_COLUMN_EXCEPTION_ACTION != 0) {
                            swt = this.ddListener.afterAlterColumnException(runtime, random, table, (Column)meta, e);
                        }
                        log.warn("{}[\u4fee\u6539TAG\u6267\u884c\u5f02\u5e38][\u5c1d\u8bd5\u4fee\u6b63\u6570\u636e][\u4fee\u6b63\u7ed3\u679c:{}]", (Object)random, (Object)swt);
                        if (swt == ACTION.SWITCH.CONTINUE) {
                            result = this.alter(runtime, table, meta, false);
                        }
                        break block19;
                    }
                    log.error("{}[\u4fee\u6539Column\u6267\u884c\u5f02\u5e38][\u4e2d\u65ad\u6267\u884c]", (Object)random);
                    result = false;
                    throw e;
                }
                catch (Throwable throwable) {
                    long millis = System.currentTimeMillis() - fr;
                    if (runs.size() > 1 && ConfigTable.IS_LOG_SQL && log.isInfoEnabled()) {
                        log.info("{}[action:{}][table:{}][name:{}][cmds:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getTableName(true), meta.getName(), runs.size(), result, millis});
                    }
                    swt = ACTION.SWITCH.CONTINUE;
                    if (null != this.ddListener) {
                        swt = this.ddListener.afterAlter(runtime, random, (Column)meta, runs, result, millis);
                    }
                    if (swt == ACTION.SWITCH.CONTINUE) {
                        InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
                    }
                    throw throwable;
                }
            }
            long millis = System.currentTimeMillis() - fr;
            if (runs.size() > 1 && ConfigTable.IS_LOG_SQL && log.isInfoEnabled()) {
                log.info("{}[action:{}][table:{}][name:{}][cmds:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getTableName(true), meta.getName(), runs.size(), result, millis});
            }
            swt = ACTION.SWITCH.CONTINUE;
            if (null != this.ddListener) {
                swt = this.ddListener.afterAlter(runtime, random, (Column)meta, runs, result, millis);
            }
            if (swt == ACTION.SWITCH.CONTINUE) {
                InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
            }
        }
        long millis = System.currentTimeMillis() - fr;
        if (runs.size() > 1 && ConfigTable.IS_LOG_SQL && log.isInfoEnabled()) {
            log.info("{}[action:{}][table:{}][name:{}][cmds:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getTableName(true), meta.getName(), runs.size(), result, millis});
        }
        swt = ACTION.SWITCH.CONTINUE;
        if (null != this.ddListener) {
            swt = this.ddListener.afterAlter(runtime, random, (Column)meta, runs, result, millis);
        }
        if (swt == ACTION.SWITCH.CONTINUE) {
            InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
        }
        return result;
    }

    @Override
    public boolean alter(DataRuntime runtime, Tag meta) throws Exception {
        Table table = meta.getTable(true);
        if (null == table) {
            List tables = this.tables(runtime, null, false, meta.getCatalog(), meta.getSchema(), meta.getTableName(true), "TABLE");
            if (tables.isEmpty()) {
                if (ConfigTable.IS_THROW_SQL_UPDATE_EXCEPTION) {
                    throw new AnylineException("\u8868\u4e0d\u5b58\u5728:" + meta.getTableName(true));
                }
                log.error("\u8868\u4e0d\u5b58\u5728:" + meta.getTableName(true));
            } else {
                table = (Table)tables.get(0);
            }
        }
        return this.alter(runtime, table, meta, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean drop(DataRuntime runtime, Tag meta) throws Exception {
        boolean result = false;
        ACTION.DDL action = ACTION.DDL.TAG_DROP;
        String random = this.random(runtime);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (null != this.ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = this.ddListener.prepareDrop(runtime, random, (Column)meta);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        this.checkSchema(runtime, meta);
        List<Run> runs = this.buildDropRun(runtime, meta);
        swt = InterceptorProxy.before(runtime, random, action, meta, runs);
        if (null != this.ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = this.ddListener.beforeDrop(runtime, random, (Column)meta, runs);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        long fr = System.currentTimeMillis();
        try {
            result = this.execute(runtime, random, (BaseMetadata)meta, action, runs);
        }
        catch (Throwable throwable) {
            long millis = System.currentTimeMillis() - fr;
            if (runs.size() > 1 && ConfigTable.IS_LOG_SQL && log.isInfoEnabled()) {
                log.info("{}[action:{}][table:{}][name:{}][cmds:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getTableName(true), meta.getName(), runs.size(), result, millis});
            }
            swt = ACTION.SWITCH.CONTINUE;
            if (null != this.ddListener) {
                swt = this.ddListener.afterDrop(runtime, random, (Column)meta, runs, result, millis);
            }
            if (swt == ACTION.SWITCH.CONTINUE) {
                InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
            }
            throw throwable;
        }
        long millis = System.currentTimeMillis() - fr;
        if (runs.size() > 1 && ConfigTable.IS_LOG_SQL && log.isInfoEnabled()) {
            log.info("{}[action:{}][table:{}][name:{}][cmds:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getTableName(true), meta.getName(), runs.size(), result, millis});
        }
        swt = ACTION.SWITCH.CONTINUE;
        if (null != this.ddListener) {
            swt = this.ddListener.afterDrop(runtime, random, (Column)meta, runs, result, millis);
        }
        if (swt == ACTION.SWITCH.CONTINUE) {
            InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean rename(DataRuntime runtime, Tag origin, String name) throws Exception {
        boolean result = false;
        ACTION.DDL action = ACTION.DDL.TAG_RENAME;
        String random = this.random(runtime);
        origin.setNewName(name);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, origin);
        if (null != this.ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = this.ddListener.prepareRename(runtime, random, (Column)origin);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        this.checkSchema(runtime, origin);
        List<Run> runs = this.buildRenameRun(runtime, origin);
        swt = InterceptorProxy.before(runtime, random, action, origin, runs);
        if (null != this.ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = this.ddListener.beforeRename(runtime, random, (Column)origin, runs);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        long fr = System.currentTimeMillis();
        try {
            result = this.execute(runtime, random, (BaseMetadata)origin, action, runs);
        }
        catch (Throwable throwable) {
            long millis = System.currentTimeMillis() - fr;
            if (runs.size() > 1 && ConfigTable.IS_LOG_SQL && log.isInfoEnabled()) {
                log.info("{}[action:{}][table:{}][name:{}][rename:{}][cmds:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, origin.getTableName(true), origin.getName(), name, runs.size(), result, millis});
            }
            swt = ACTION.SWITCH.CONTINUE;
            if (null != this.ddListener) {
                swt = this.ddListener.afterRename(runtime, random, (Column)origin, runs, result, millis);
            }
            if (swt == ACTION.SWITCH.CONTINUE) {
                InterceptorProxy.after(runtime, random, action, origin, runs, result, millis);
            }
            throw throwable;
        }
        long millis = System.currentTimeMillis() - fr;
        if (runs.size() > 1 && ConfigTable.IS_LOG_SQL && log.isInfoEnabled()) {
            log.info("{}[action:{}][table:{}][name:{}][rename:{}][cmds:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, origin.getTableName(true), origin.getName(), name, runs.size(), result, millis});
        }
        swt = ACTION.SWITCH.CONTINUE;
        if (null != this.ddListener) {
            swt = this.ddListener.afterRename(runtime, random, (Column)origin, runs, result, millis);
        }
        if (swt == ACTION.SWITCH.CONTINUE) {
            InterceptorProxy.after(runtime, random, action, origin, runs, result, millis);
        }
        return result;
    }

    @Override
    public List<Run> buildAddRun(DataRuntime runtime, Tag meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildAddRun(DataRuntime runtime, Tag meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildAlterRun(DataRuntime runtime, Tag meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildAlterRun(DataRuntime runtime, Tag meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildDropRun(DataRuntime runtime, Tag meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildDropRun(DataRuntime runtime, Tag meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildRenameRun(DataRuntime runtime, Tag meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildRenameRun(DataRuntime runtime, Tag meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildChangeDefaultRun(DataRuntime runtime, Tag meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildChangeDefaultRun(DataRuntime runtime, Tag meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildChangeNullableRun(DataRuntime runtime, Tag meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildChangeNullableRun(DataRuntime runtime, Tag meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildChangeCommentRun(DataRuntime runtime, Tag meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildChangeCommentRun(DataRuntime runtime, Tag meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildChangeTypeRun(DataRuntime runtime, Tag meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildChangeTypeRun(DataRuntime runtime, Tag meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public StringBuilder checkTagExists(DataRuntime runtime, StringBuilder builder, boolean exists) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 StringBuilder checkTagExists(DataRuntime runtime, StringBuilder builder, boolean exists)"), (int)37));
        }
        return builder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(DataRuntime runtime, PrimaryKey meta) throws Exception {
        boolean result = false;
        ACTION.DDL action = ACTION.DDL.PRIMARY_ADD;
        String random = this.random(runtime);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (null != this.ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = this.ddListener.prepareAdd(runtime, random, meta);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        this.checkSchema(runtime, meta);
        List<Run> runs = this.buildAddRun(runtime, meta);
        swt = InterceptorProxy.before(runtime, random, action, meta, runs);
        if (null != this.ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = this.ddListener.beforeAdd(runtime, random, meta, runs);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        long fr = System.currentTimeMillis();
        try {
            result = this.execute(runtime, random, (BaseMetadata)meta, action, runs);
        }
        catch (Throwable throwable) {
            long millis = System.currentTimeMillis() - fr;
            if (runs.size() > 1 && ConfigTable.IS_LOG_SQL && log.isInfoEnabled()) {
                log.info("{}[action:{}][table:{}][name:{}][cmds:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getTableName(true), meta.getName(), runs.size(), result, millis});
            }
            swt = ACTION.SWITCH.CONTINUE;
            if (null != this.ddListener) {
                swt = this.ddListener.afterAdd(runtime, random, meta, runs, result, millis);
            }
            if (swt == ACTION.SWITCH.CONTINUE) {
                InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
            }
            throw throwable;
        }
        long millis = System.currentTimeMillis() - fr;
        if (runs.size() > 1 && ConfigTable.IS_LOG_SQL && log.isInfoEnabled()) {
            log.info("{}[action:{}][table:{}][name:{}][cmds:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getTableName(true), meta.getName(), runs.size(), result, millis});
        }
        swt = ACTION.SWITCH.CONTINUE;
        if (null != this.ddListener) {
            swt = this.ddListener.afterAdd(runtime, random, meta, runs, result, millis);
        }
        if (swt == ACTION.SWITCH.CONTINUE) {
            InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
        }
        return result;
    }

    @Override
    public boolean alter(DataRuntime runtime, PrimaryKey meta) throws Exception {
        Table table = meta.getTable(true);
        if (null == table) {
            List tables = this.tables(runtime, null, false, meta.getCatalog(), meta.getSchema(), meta.getTableName(true), "TABLE");
            if (tables.isEmpty()) {
                if (ConfigTable.IS_THROW_SQL_UPDATE_EXCEPTION) {
                    throw new AnylineException("\u8868\u4e0d\u5b58\u5728:" + meta.getTableName(true));
                }
                log.error("\u8868\u4e0d\u5b58\u5728:" + meta.getTableName(true));
            } else {
                table = (Table)tables.get(0);
            }
        }
        return this.alter(runtime, table, meta);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean alter(DataRuntime runtime, Table table, PrimaryKey meta) throws Exception {
        boolean result = false;
        ACTION.DDL action = ACTION.DDL.PRIMARY_ALTER;
        String random = this.random(runtime);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (null != this.ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = this.ddListener.prepareAlter(runtime, random, meta);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        this.checkSchema(runtime, meta);
        List<Run> runs = this.buildAlterRun(runtime, meta);
        swt = InterceptorProxy.before(runtime, random, action, meta, runs);
        if (null != this.ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = this.ddListener.beforeAlter(runtime, random, meta, runs);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        long fr = System.currentTimeMillis();
        try {
            result = this.execute(runtime, random, (BaseMetadata)table, action, runs);
        }
        catch (Throwable throwable) {
            long millis = System.currentTimeMillis() - fr;
            if (runs.size() > 1 && ConfigTable.IS_LOG_SQL && log.isInfoEnabled()) {
                log.info("{}[action:{}][table:{}][name:{}][cmds:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getTableName(true), meta.getName(), runs.size(), result, millis});
            }
            swt = ACTION.SWITCH.CONTINUE;
            if (null != this.ddListener) {
                swt = this.ddListener.afterAlter(runtime, random, meta, runs, result, millis);
            }
            if (swt == ACTION.SWITCH.CONTINUE) {
                InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
            }
            throw throwable;
        }
        long millis = System.currentTimeMillis() - fr;
        if (runs.size() > 1 && ConfigTable.IS_LOG_SQL && log.isInfoEnabled()) {
            log.info("{}[action:{}][table:{}][name:{}][cmds:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getTableName(true), meta.getName(), runs.size(), result, millis});
        }
        swt = ACTION.SWITCH.CONTINUE;
        if (null != this.ddListener) {
            swt = this.ddListener.afterAlter(runtime, random, meta, runs, result, millis);
        }
        if (swt == ACTION.SWITCH.CONTINUE) {
            InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean drop(DataRuntime runtime, PrimaryKey meta) throws Exception {
        boolean result = false;
        ACTION.DDL action = ACTION.DDL.PRIMARY_DROP;
        String random = this.random(runtime);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (null != this.ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = this.ddListener.prepareDrop(runtime, random, meta);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        this.checkSchema(runtime, meta);
        List<Run> runs = this.buildDropRun(runtime, meta);
        swt = InterceptorProxy.before(runtime, random, action, meta, runs);
        if (null != this.ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = this.ddListener.beforeDrop(runtime, random, meta, runs);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        long fr = System.currentTimeMillis();
        try {
            result = this.execute(runtime, random, (BaseMetadata)meta, action, runs);
        }
        catch (Throwable throwable) {
            long millis = System.currentTimeMillis() - fr;
            if (runs.size() > 1 && ConfigTable.IS_LOG_SQL && log.isInfoEnabled()) {
                log.info("{}[action:{}][table:{}][name:{}][cmds:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getTableName(true), meta.getName(), runs.size(), result, millis});
            }
            swt = ACTION.SWITCH.CONTINUE;
            if (null != this.ddListener) {
                swt = this.ddListener.afterDrop(runtime, random, meta, runs, result, millis);
            }
            if (swt == ACTION.SWITCH.CONTINUE) {
                InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
            }
            throw throwable;
        }
        long millis = System.currentTimeMillis() - fr;
        if (runs.size() > 1 && ConfigTable.IS_LOG_SQL && log.isInfoEnabled()) {
            log.info("{}[action:{}][table:{}][name:{}][cmds:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getTableName(true), meta.getName(), runs.size(), result, millis});
        }
        swt = ACTION.SWITCH.CONTINUE;
        if (null != this.ddListener) {
            swt = this.ddListener.afterDrop(runtime, random, meta, runs, result, millis);
        }
        if (swt == ACTION.SWITCH.CONTINUE) {
            InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean rename(DataRuntime runtime, PrimaryKey origin, String name) throws Exception {
        boolean result = false;
        ACTION.DDL action = ACTION.DDL.PRIMARY_RENAME;
        String random = this.random(runtime);
        origin.setNewName(name);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, origin);
        if (null != this.ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = this.ddListener.prepareRename(runtime, random, origin);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        this.checkSchema(runtime, origin);
        List<Run> runs = this.buildRenameRun(runtime, origin);
        swt = InterceptorProxy.before(runtime, random, action, origin, runs);
        if (null != this.ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = this.ddListener.beforeRename(runtime, random, origin, runs);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        long fr = System.currentTimeMillis();
        try {
            result = this.execute(runtime, random, (BaseMetadata)origin, action, runs);
        }
        catch (Throwable throwable) {
            long millis = System.currentTimeMillis() - fr;
            if (runs.size() > 1 && ConfigTable.IS_LOG_SQL && log.isInfoEnabled()) {
                log.info("{}[action:{}][table:{}][name:{}][rename:{}][cmds:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, origin.getTableName(true), origin.getName(), name, runs.size(), result, millis});
            }
            swt = ACTION.SWITCH.CONTINUE;
            if (null != this.ddListener) {
                swt = this.ddListener.afterRename(runtime, random, origin, runs, result, millis);
            }
            if (swt == ACTION.SWITCH.CONTINUE) {
                InterceptorProxy.after(runtime, random, action, origin, runs, result, millis);
            }
            throw throwable;
        }
        long millis = System.currentTimeMillis() - fr;
        if (runs.size() > 1 && ConfigTable.IS_LOG_SQL && log.isInfoEnabled()) {
            log.info("{}[action:{}][table:{}][name:{}][rename:{}][cmds:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, origin.getTableName(true), origin.getName(), name, runs.size(), result, millis});
        }
        swt = ACTION.SWITCH.CONTINUE;
        if (null != this.ddListener) {
            swt = this.ddListener.afterRename(runtime, random, origin, runs, result, millis);
        }
        if (swt == ACTION.SWITCH.CONTINUE) {
            InterceptorProxy.after(runtime, random, action, origin, runs, result, millis);
        }
        return result;
    }

    @Override
    public List<Run> buildAddRun(DataRuntime runtime, PrimaryKey meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildAddRun(DataRuntime runtime, PrimaryKey meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildAlterRun(DataRuntime runtime, PrimaryKey meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildAlterRun(DataRuntime runtime, PrimaryKey meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildDropRun(DataRuntime runtime, PrimaryKey meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildDropRun(DataRuntime runtime, PrimaryKey meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildRenameRun(DataRuntime runtime, PrimaryKey meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildAddRun(DataRuntime runtime, PrimaryKey meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(DataRuntime runtime, ForeignKey meta) throws Exception {
        boolean result = false;
        ACTION.DDL action = ACTION.DDL.FOREIGN_ADD;
        String random = this.random(runtime);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (null != this.ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = this.ddListener.prepareAdd(runtime, random, meta);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        this.checkSchema(runtime, meta);
        List<Run> runs = this.buildAddRun(runtime, meta);
        swt = InterceptorProxy.before(runtime, random, action, meta, runs);
        if (null != this.ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = this.ddListener.beforeAdd(runtime, random, meta, runs);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        long fr = System.currentTimeMillis();
        try {
            result = this.execute(runtime, random, (BaseMetadata)meta, action, runs);
        }
        catch (Throwable throwable) {
            long millis = System.currentTimeMillis() - fr;
            if (runs.size() > 1 && ConfigTable.IS_LOG_SQL && log.isInfoEnabled()) {
                log.info("{}[action:{}][table:{}][name:{}][cmds:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getTableName(true), meta.getName(), runs.size(), result, millis});
            }
            swt = ACTION.SWITCH.CONTINUE;
            if (null != this.ddListener) {
                swt = this.ddListener.afterAdd(runtime, random, meta, runs, result, millis);
            }
            if (swt == ACTION.SWITCH.CONTINUE) {
                InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
            }
            throw throwable;
        }
        long millis = System.currentTimeMillis() - fr;
        if (runs.size() > 1 && ConfigTable.IS_LOG_SQL && log.isInfoEnabled()) {
            log.info("{}[action:{}][table:{}][name:{}][cmds:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getTableName(true), meta.getName(), runs.size(), result, millis});
        }
        swt = ACTION.SWITCH.CONTINUE;
        if (null != this.ddListener) {
            swt = this.ddListener.afterAdd(runtime, random, meta, runs, result, millis);
        }
        if (swt == ACTION.SWITCH.CONTINUE) {
            InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
        }
        return result;
    }

    @Override
    public boolean alter(DataRuntime runtime, ForeignKey meta) throws Exception {
        Table table = meta.getTable(true);
        if (null == table) {
            List tables = this.tables(runtime, null, false, meta.getCatalog(), meta.getSchema(), meta.getTableName(true), "TABLE");
            if (tables.size() == 0) {
                if (ConfigTable.IS_THROW_SQL_UPDATE_EXCEPTION) {
                    throw new AnylineException("\u8868\u4e0d\u5b58\u5728:" + meta.getTableName(true));
                }
                log.error("\u8868\u4e0d\u5b58\u5728:" + meta.getTableName(true));
            } else {
                table = (Table)tables.get(0);
            }
        }
        return this.alter(runtime, table, meta);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean alter(DataRuntime runtime, Table table, ForeignKey meta) throws Exception {
        boolean result = false;
        ACTION.DDL action = ACTION.DDL.TRIGGER_ALTER;
        String random = this.random(runtime);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (null != this.ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = this.ddListener.prepareAlter(runtime, random, meta);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        this.checkSchema(runtime, meta);
        List<Run> runs = this.buildAlterRun(runtime, meta);
        swt = InterceptorProxy.before(runtime, random, action, meta, runs);
        if (null != this.ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = this.ddListener.beforeAlter(runtime, random, meta, runs);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        long fr = System.currentTimeMillis();
        try {
            result = this.execute(runtime, random, (BaseMetadata)meta, action, runs);
        }
        catch (Throwable throwable) {
            long millis = System.currentTimeMillis() - fr;
            if (runs.size() > 1 && ConfigTable.IS_LOG_SQL && log.isInfoEnabled()) {
                log.info("{}[action:{}][table:{}][name:{}][cmds:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getTableName(true), meta.getName(), runs.size(), result, millis});
            }
            swt = ACTION.SWITCH.CONTINUE;
            if (null != this.ddListener) {
                swt = this.ddListener.afterAlter(runtime, random, meta, runs, result, millis);
            }
            if (swt == ACTION.SWITCH.CONTINUE) {
                InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
            }
            throw throwable;
        }
        long millis = System.currentTimeMillis() - fr;
        if (runs.size() > 1 && ConfigTable.IS_LOG_SQL && log.isInfoEnabled()) {
            log.info("{}[action:{}][table:{}][name:{}][cmds:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getTableName(true), meta.getName(), runs.size(), result, millis});
        }
        swt = ACTION.SWITCH.CONTINUE;
        if (null != this.ddListener) {
            swt = this.ddListener.afterAlter(runtime, random, meta, runs, result, millis);
        }
        if (swt == ACTION.SWITCH.CONTINUE) {
            InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean drop(DataRuntime runtime, ForeignKey meta) throws Exception {
        boolean result = false;
        ACTION.DDL action = ACTION.DDL.FOREIGN_DROP;
        String random = this.random(runtime);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (null != this.ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = this.ddListener.prepareDrop(runtime, random, meta);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        this.checkSchema(runtime, meta);
        List<Run> runs = this.buildDropRun(runtime, meta);
        swt = InterceptorProxy.before(runtime, random, action, meta, runs);
        if (null != this.ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = this.ddListener.beforeDrop(runtime, random, meta, runs);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        long fr = System.currentTimeMillis();
        try {
            result = this.execute(runtime, random, (BaseMetadata)meta, action, runs);
        }
        catch (Throwable throwable) {
            long millis = System.currentTimeMillis() - fr;
            if (runs.size() > 1 && ConfigTable.IS_LOG_SQL && log.isInfoEnabled()) {
                log.info("{}[action:{}][table:{}][name:{}][cmds:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getTableName(true), meta.getName(), runs.size(), result, millis});
            }
            swt = ACTION.SWITCH.CONTINUE;
            if (null != this.ddListener) {
                swt = this.ddListener.afterDrop(runtime, random, meta, runs, result, millis);
            }
            if (swt == ACTION.SWITCH.CONTINUE) {
                InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
            }
            throw throwable;
        }
        long millis = System.currentTimeMillis() - fr;
        if (runs.size() > 1 && ConfigTable.IS_LOG_SQL && log.isInfoEnabled()) {
            log.info("{}[action:{}][table:{}][name:{}][cmds:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getTableName(true), meta.getName(), runs.size(), result, millis});
        }
        swt = ACTION.SWITCH.CONTINUE;
        if (null != this.ddListener) {
            swt = this.ddListener.afterDrop(runtime, random, meta, runs, result, millis);
        }
        if (swt == ACTION.SWITCH.CONTINUE) {
            InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean rename(DataRuntime runtime, ForeignKey origin, String name) throws Exception {
        boolean result = false;
        ACTION.DDL action = ACTION.DDL.FOREIGN_RENAME;
        String random = this.random(runtime);
        origin.setNewName(name);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, origin);
        if (null != this.ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = this.ddListener.prepareRename(runtime, random, origin);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        this.checkSchema(runtime, origin);
        List<Run> runs = this.buildRenameRun(runtime, origin);
        swt = InterceptorProxy.before(runtime, random, action, origin, runs);
        if (null != this.ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = this.ddListener.beforeRename(runtime, random, origin, runs);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        long fr = System.currentTimeMillis();
        try {
            result = this.execute(runtime, random, (BaseMetadata)origin, action, runs);
        }
        catch (Throwable throwable) {
            long millis = System.currentTimeMillis() - fr;
            if (runs.size() > 1 && ConfigTable.IS_LOG_SQL && log.isInfoEnabled()) {
                log.info("{}[action:{}][table:{}][name:{}][rename:{}][cmds:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, origin.getTableName(true), origin.getName(), name, runs.size(), result, millis});
            }
            swt = ACTION.SWITCH.CONTINUE;
            if (null != this.ddListener) {
                swt = this.ddListener.afterRename(runtime, random, origin, runs, result, millis);
            }
            if (swt == ACTION.SWITCH.CONTINUE) {
                InterceptorProxy.after(runtime, random, action, origin, runs, result, millis);
            }
            throw throwable;
        }
        long millis = System.currentTimeMillis() - fr;
        if (runs.size() > 1 && ConfigTable.IS_LOG_SQL && log.isInfoEnabled()) {
            log.info("{}[action:{}][table:{}][name:{}][rename:{}][cmds:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, origin.getTableName(true), origin.getName(), name, runs.size(), result, millis});
        }
        swt = ACTION.SWITCH.CONTINUE;
        if (null != this.ddListener) {
            swt = this.ddListener.afterRename(runtime, random, origin, runs, result, millis);
        }
        if (swt == ACTION.SWITCH.CONTINUE) {
            InterceptorProxy.after(runtime, random, action, origin, runs, result, millis);
        }
        return result;
    }

    @Override
    public List<Run> buildAddRun(DataRuntime runtime, ForeignKey meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildAddRun(DataRuntime runtime, ForeignKey meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildAlterRun(DataRuntime runtime, ForeignKey meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildAlterRun(DataRuntime runtime, ForeignKey meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildDropRun(DataRuntime runtime, ForeignKey meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildDropRun(DataRuntime runtime, ForeignKey meta) "), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildRenameRun(DataRuntime runtime, ForeignKey meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildRenameRun(DataRuntime runtime, ForeignKey meta) "), (int)37));
        }
        return new ArrayList<Run>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(DataRuntime runtime, Index meta) throws Exception {
        boolean result = false;
        ACTION.DDL action = ACTION.DDL.INDEX_ADD;
        String random = this.random(runtime);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (null != this.ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = this.ddListener.prepareAdd(runtime, random, meta);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        this.checkSchema(runtime, meta);
        List<Run> runs = this.buildAddRun(runtime, meta);
        swt = InterceptorProxy.before(runtime, random, action, meta, runs);
        if (null != this.ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = this.ddListener.beforeAdd(runtime, random, meta, runs);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        long fr = System.currentTimeMillis();
        try {
            result = this.execute(runtime, random, (BaseMetadata)meta, action, runs);
        }
        catch (Throwable throwable) {
            long millis = System.currentTimeMillis() - fr;
            if (runs.size() > 1 && ConfigTable.IS_LOG_SQL && log.isInfoEnabled()) {
                log.info("{}[action:{}][table:{}][name:{}][cmds:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getTableName(true), meta.getName(), runs.size(), result, millis});
            }
            swt = ACTION.SWITCH.CONTINUE;
            if (null != this.ddListener) {
                swt = this.ddListener.afterAdd(runtime, random, meta, runs, result, millis);
            }
            if (swt == ACTION.SWITCH.CONTINUE) {
                InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
            }
            throw throwable;
        }
        long millis = System.currentTimeMillis() - fr;
        if (runs.size() > 1 && ConfigTable.IS_LOG_SQL && log.isInfoEnabled()) {
            log.info("{}[action:{}][table:{}][name:{}][cmds:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getTableName(true), meta.getName(), runs.size(), result, millis});
        }
        swt = ACTION.SWITCH.CONTINUE;
        if (null != this.ddListener) {
            swt = this.ddListener.afterAdd(runtime, random, meta, runs, result, millis);
        }
        if (swt == ACTION.SWITCH.CONTINUE) {
            InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
        }
        return result;
    }

    @Override
    public boolean alter(DataRuntime runtime, Index meta) throws Exception {
        Table table = meta.getTable(true);
        if (null == table) {
            List tables = this.tables(runtime, null, false, meta.getCatalog(), meta.getSchema(), meta.getTableName(true), "TABLE");
            if (tables.isEmpty()) {
                if (ConfigTable.IS_THROW_SQL_UPDATE_EXCEPTION) {
                    throw new AnylineException("\u8868\u4e0d\u5b58\u5728:" + meta.getTableName(true));
                }
                log.error("\u8868\u4e0d\u5b58\u5728:" + meta.getTableName(true));
            } else {
                table = (Table)tables.get(0);
            }
        }
        return this.alter(runtime, table, meta);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean alter(DataRuntime runtime, Table table, Index meta) throws Exception {
        boolean result = false;
        ACTION.DDL action = ACTION.DDL.INDEX_ALTER;
        String random = this.random(runtime);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (null != this.ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = this.ddListener.prepareAlter(runtime, random, meta);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        this.checkSchema(runtime, meta);
        List<Run> runs = this.buildAlterRun(runtime, meta);
        swt = InterceptorProxy.before(runtime, random, action, meta, runs);
        if (null != this.ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = this.ddListener.beforeAlter(runtime, random, meta, runs);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        long fr = System.currentTimeMillis();
        try {
            result = this.execute(runtime, random, (BaseMetadata)meta, action, runs);
        }
        catch (Throwable throwable) {
            long millis = System.currentTimeMillis() - fr;
            if (runs.size() > 1 && ConfigTable.IS_LOG_SQL && log.isInfoEnabled()) {
                log.info("{}[action:{}][table:{}][name:{}][cmds:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getTableName(true), meta.getName(), runs.size(), result, millis});
            }
            swt = ACTION.SWITCH.CONTINUE;
            if (null != this.ddListener) {
                swt = this.ddListener.afterAlter(runtime, random, meta, runs, result, millis);
            }
            if (swt == ACTION.SWITCH.CONTINUE) {
                InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
            }
            throw throwable;
        }
        long millis = System.currentTimeMillis() - fr;
        if (runs.size() > 1 && ConfigTable.IS_LOG_SQL && log.isInfoEnabled()) {
            log.info("{}[action:{}][table:{}][name:{}][cmds:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getTableName(true), meta.getName(), runs.size(), result, millis});
        }
        swt = ACTION.SWITCH.CONTINUE;
        if (null != this.ddListener) {
            swt = this.ddListener.afterAlter(runtime, random, meta, runs, result, millis);
        }
        if (swt == ACTION.SWITCH.CONTINUE) {
            InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean drop(DataRuntime runtime, Index meta) throws Exception {
        boolean result = false;
        ACTION.DDL action = ACTION.DDL.INDEX_DROP;
        String random = this.random(runtime);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (null != this.ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = this.ddListener.prepareDrop(runtime, random, meta);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        this.checkSchema(runtime, meta);
        List<Run> runs = this.buildDropRun(runtime, meta);
        swt = InterceptorProxy.before(runtime, random, action, meta, runs);
        if (null != this.ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = this.ddListener.beforeDrop(runtime, random, meta, runs);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        long fr = System.currentTimeMillis();
        try {
            result = this.execute(runtime, random, (BaseMetadata)meta, action, runs);
        }
        catch (Throwable throwable) {
            long millis = System.currentTimeMillis() - fr;
            if (runs.size() > 1 && ConfigTable.IS_LOG_SQL && log.isInfoEnabled()) {
                log.info("{}[action:{}][table:{}][name:{}][cmds:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getTableName(true), meta.getName(), runs.size(), result, millis});
            }
            swt = ACTION.SWITCH.CONTINUE;
            if (null != this.ddListener) {
                swt = this.ddListener.afterDrop(runtime, random, meta, runs, result, millis);
            }
            if (swt == ACTION.SWITCH.CONTINUE) {
                InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
            }
            throw throwable;
        }
        long millis = System.currentTimeMillis() - fr;
        if (runs.size() > 1 && ConfigTable.IS_LOG_SQL && log.isInfoEnabled()) {
            log.info("{}[action:{}][table:{}][name:{}][cmds:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getTableName(true), meta.getName(), runs.size(), result, millis});
        }
        swt = ACTION.SWITCH.CONTINUE;
        if (null != this.ddListener) {
            swt = this.ddListener.afterDrop(runtime, random, meta, runs, result, millis);
        }
        if (swt == ACTION.SWITCH.CONTINUE) {
            InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean rename(DataRuntime runtime, Index origin, String name) throws Exception {
        boolean result = false;
        ACTION.DDL action = ACTION.DDL.INDEX_RENAME;
        String random = this.random(runtime);
        origin.setNewName(name);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, origin);
        if (null != this.ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = this.ddListener.prepareRename(runtime, random, origin);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        this.checkSchema(runtime, origin);
        List<Run> runs = this.buildRenameRun(runtime, origin);
        swt = InterceptorProxy.before(runtime, random, action, origin, runs);
        if (null != this.ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = this.ddListener.beforeRename(runtime, random, origin, runs);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        long fr = System.currentTimeMillis();
        try {
            result = this.execute(runtime, random, (BaseMetadata)origin, action, runs);
        }
        catch (Throwable throwable) {
            long millis = System.currentTimeMillis() - fr;
            if (runs.size() > 1 && ConfigTable.IS_LOG_SQL && log.isInfoEnabled()) {
                log.info("{}[action:{}][table:{}][name:{}][rename:{}][cmds:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, origin.getTableName(true), origin.getName(), name, runs.size(), result, millis});
            }
            swt = ACTION.SWITCH.CONTINUE;
            if (null != this.ddListener) {
                swt = this.ddListener.afterRename(runtime, random, origin, runs, result, millis);
            }
            if (swt == ACTION.SWITCH.CONTINUE) {
                InterceptorProxy.after(runtime, random, action, origin, runs, result, millis);
            }
            throw throwable;
        }
        long millis = System.currentTimeMillis() - fr;
        if (runs.size() > 1 && ConfigTable.IS_LOG_SQL && log.isInfoEnabled()) {
            log.info("{}[action:{}][table:{}][name:{}][rename:{}][cmds:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, origin.getTableName(true), origin.getName(), name, runs.size(), result, millis});
        }
        swt = ACTION.SWITCH.CONTINUE;
        if (null != this.ddListener) {
            swt = this.ddListener.afterRename(runtime, random, origin, runs, result, millis);
        }
        if (swt == ACTION.SWITCH.CONTINUE) {
            InterceptorProxy.after(runtime, random, action, origin, runs, result, millis);
        }
        return result;
    }

    @Override
    public List<Run> buildAddRun(DataRuntime runtime, Index meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildAddRun(DataRuntime runtime, Index meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildAlterRun(DataRuntime runtime, Index meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildAlterRun(DataRuntime runtime, Index meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildDropRun(DataRuntime runtime, Index meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildDropRun(DataRuntime runtime, Index meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildRenameRun(DataRuntime runtime, Index meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildRenameRun(DataRuntime runtime, Index meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public StringBuilder type(DataRuntime runtime, StringBuilder builder, Index meta) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 StringBuilder type(DataRuntime runtime, StringBuilder builder, Index meta)"), (int)37));
        }
        return builder;
    }

    @Override
    public StringBuilder comment(DataRuntime runtime, StringBuilder builder, Index meta) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 StringBuilder comment(DataRuntime runtime, StringBuilder builder, Index meta)"), (int)37));
        }
        return builder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(DataRuntime runtime, Constraint meta) throws Exception {
        boolean result = false;
        ACTION.DDL action = ACTION.DDL.CONSTRAINT_ADD;
        String random = this.random(runtime);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (null != this.ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = this.ddListener.prepareAdd(runtime, random, meta);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        this.checkSchema(runtime, meta);
        List<Run> runs = this.buildAddRun(runtime, meta);
        swt = InterceptorProxy.before(runtime, random, action, meta, runs);
        if (null != this.ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = this.ddListener.beforeAdd(runtime, random, meta, runs);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        long fr = System.currentTimeMillis();
        try {
            result = this.execute(runtime, random, (BaseMetadata)meta, action, runs);
        }
        catch (Throwable throwable) {
            long millis = System.currentTimeMillis() - fr;
            if (runs.size() > 1 && ConfigTable.IS_LOG_SQL && log.isInfoEnabled()) {
                log.info("{}[action:{}][table:{}][name:{}][cmds:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getTableName(true), meta.getName(), runs.size(), result, millis});
            }
            swt = ACTION.SWITCH.CONTINUE;
            if (null != this.ddListener) {
                swt = this.ddListener.afterAdd(runtime, random, meta, runs, result, millis);
            }
            if (swt == ACTION.SWITCH.CONTINUE) {
                InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
            }
            throw throwable;
        }
        long millis = System.currentTimeMillis() - fr;
        if (runs.size() > 1 && ConfigTable.IS_LOG_SQL && log.isInfoEnabled()) {
            log.info("{}[action:{}][table:{}][name:{}][cmds:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getTableName(true), meta.getName(), runs.size(), result, millis});
        }
        swt = ACTION.SWITCH.CONTINUE;
        if (null != this.ddListener) {
            swt = this.ddListener.afterAdd(runtime, random, meta, runs, result, millis);
        }
        if (swt == ACTION.SWITCH.CONTINUE) {
            InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
        }
        return result;
    }

    @Override
    public boolean alter(DataRuntime runtime, Constraint meta) throws Exception {
        Table table = meta.getTable(true);
        if (null == table) {
            List tables = this.tables(runtime, null, false, meta.getCatalog(), meta.getSchema(), meta.getTableName(true), "TABLE");
            if (tables.isEmpty()) {
                if (ConfigTable.IS_THROW_SQL_UPDATE_EXCEPTION) {
                    throw new AnylineException("\u8868\u4e0d\u5b58\u5728:" + meta.getTableName(true));
                }
                log.error("\u8868\u4e0d\u5b58\u5728:" + meta.getTableName(true));
            } else {
                table = (Table)tables.get(0);
            }
        }
        return this.alter(runtime, table, meta);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean alter(DataRuntime runtime, Table table, Constraint meta) throws Exception {
        boolean result = false;
        ACTION.DDL action = ACTION.DDL.CONSTRAINT_ALTER;
        String random = this.random(runtime);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (null != this.ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = this.ddListener.prepareAlter(runtime, random, meta);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        this.checkSchema(runtime, meta);
        List<Run> runs = this.buildAlterRun(runtime, meta);
        swt = InterceptorProxy.before(runtime, random, action, meta, runs);
        if (null != this.ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = this.ddListener.beforeAlter(runtime, random, meta, runs);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        long fr = System.currentTimeMillis();
        try {
            result = this.execute(runtime, random, (BaseMetadata)meta, action, runs);
        }
        catch (Throwable throwable) {
            long millis = System.currentTimeMillis() - fr;
            if (runs.size() > 1 && ConfigTable.IS_LOG_SQL && log.isInfoEnabled()) {
                log.info("{}[action:{}][table:{}][name:{}][cmds:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getTableName(true), meta.getName(), runs.size(), result, millis});
            }
            swt = ACTION.SWITCH.CONTINUE;
            if (null != this.ddListener) {
                swt = this.ddListener.afterAlter(runtime, random, meta, runs, result, millis);
            }
            if (swt == ACTION.SWITCH.CONTINUE) {
                InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
            }
            throw throwable;
        }
        long millis = System.currentTimeMillis() - fr;
        if (runs.size() > 1 && ConfigTable.IS_LOG_SQL && log.isInfoEnabled()) {
            log.info("{}[action:{}][table:{}][name:{}][cmds:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getTableName(true), meta.getName(), runs.size(), result, millis});
        }
        swt = ACTION.SWITCH.CONTINUE;
        if (null != this.ddListener) {
            swt = this.ddListener.afterAlter(runtime, random, meta, runs, result, millis);
        }
        if (swt == ACTION.SWITCH.CONTINUE) {
            InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean drop(DataRuntime runtime, Constraint meta) throws Exception {
        boolean result = false;
        ACTION.DDL action = ACTION.DDL.CONSTRAINT_DROP;
        String random = this.random(runtime);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (null != this.ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = this.ddListener.prepareDrop(runtime, random, meta);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        this.checkSchema(runtime, meta);
        List<Run> runs = this.buildDropRun(runtime, meta);
        swt = InterceptorProxy.before(runtime, random, action, meta, runs);
        if (null != this.ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = this.ddListener.beforeDrop(runtime, random, meta, runs);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        long fr = System.currentTimeMillis();
        try {
            result = this.execute(runtime, random, (BaseMetadata)meta, action, runs);
        }
        catch (Throwable throwable) {
            long millis = System.currentTimeMillis() - fr;
            if (runs.size() > 1 && ConfigTable.IS_LOG_SQL && log.isInfoEnabled()) {
                log.info("{}[action:{}][table:{}][name:{}][cmds:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getTableName(true), meta.getName(), runs.size(), result, millis});
            }
            swt = ACTION.SWITCH.CONTINUE;
            if (null != this.ddListener) {
                swt = this.ddListener.afterDrop(runtime, random, meta, runs, result, millis);
            }
            if (swt == ACTION.SWITCH.CONTINUE) {
                InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
            }
            throw throwable;
        }
        long millis = System.currentTimeMillis() - fr;
        if (runs.size() > 1 && ConfigTable.IS_LOG_SQL && log.isInfoEnabled()) {
            log.info("{}[action:{}][table:{}][name:{}][cmds:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getTableName(true), meta.getName(), runs.size(), result, millis});
        }
        swt = ACTION.SWITCH.CONTINUE;
        if (null != this.ddListener) {
            swt = this.ddListener.afterDrop(runtime, random, meta, runs, result, millis);
        }
        if (swt == ACTION.SWITCH.CONTINUE) {
            InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean rename(DataRuntime runtime, Constraint origin, String name) throws Exception {
        boolean result = false;
        ACTION.DDL action = ACTION.DDL.CONSTRAINT_RENAME;
        String random = this.random(runtime);
        origin.setNewName(name);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, origin);
        if (null != this.ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = this.ddListener.prepareRename(runtime, random, origin);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        this.checkSchema(runtime, origin);
        List<Run> runs = this.buildRenameRun(runtime, origin);
        swt = InterceptorProxy.before(runtime, random, action, origin, runs);
        if (null != this.ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = this.ddListener.beforeRename(runtime, random, origin, runs);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        long fr = System.currentTimeMillis();
        try {
            result = this.execute(runtime, random, (BaseMetadata)origin, action, runs);
        }
        catch (Throwable throwable) {
            long millis = System.currentTimeMillis() - fr;
            if (runs.size() > 1 && ConfigTable.IS_LOG_SQL && log.isInfoEnabled()) {
                log.info("{}[action:{}][table:{}][name:{}][rename:{}][cmds:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, origin.getTableName(true), origin.getName(), name, runs.size(), result, millis});
            }
            swt = ACTION.SWITCH.CONTINUE;
            if (null != this.ddListener) {
                swt = this.ddListener.afterRename(runtime, random, origin, runs, result, millis);
            }
            if (swt == ACTION.SWITCH.CONTINUE) {
                InterceptorProxy.after(runtime, random, action, origin, runs, result, millis);
            }
            throw throwable;
        }
        long millis = System.currentTimeMillis() - fr;
        if (runs.size() > 1 && ConfigTable.IS_LOG_SQL && log.isInfoEnabled()) {
            log.info("{}[action:{}][table:{}][name:{}][rename:{}][cmds:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, origin.getTableName(true), origin.getName(), name, runs.size(), result, millis});
        }
        swt = ACTION.SWITCH.CONTINUE;
        if (null != this.ddListener) {
            swt = this.ddListener.afterRename(runtime, random, origin, runs, result, millis);
        }
        if (swt == ACTION.SWITCH.CONTINUE) {
            InterceptorProxy.after(runtime, random, action, origin, runs, result, millis);
        }
        return result;
    }

    @Override
    public List<Run> buildAddRun(DataRuntime runtime, Constraint meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildAddRun(DataRuntime runtime, Constraint meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildAlterRun(DataRuntime runtime, Constraint meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildAlterRun(DataRuntime runtime, Constraint meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildDropRun(DataRuntime runtime, Constraint meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildDropRun(DataRuntime runtime, Constraint meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildRenameRun(DataRuntime runtime, Constraint meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildRenameRun(DataRuntime runtime, Constraint meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(DataRuntime runtime, Trigger meta) throws Exception {
        boolean result = false;
        ACTION.DDL action = ACTION.DDL.TRIGGER_ADD;
        String random = this.random(runtime);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (null != this.ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = this.ddListener.prepareCreate(runtime, random, meta);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        this.checkSchema(runtime, meta);
        List<Run> runs = this.buildCreateRun(runtime, meta);
        swt = InterceptorProxy.before(runtime, random, action, meta, runs);
        if (null != this.ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = this.ddListener.beforeCreate(runtime, random, meta, runs);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        long fr = System.currentTimeMillis();
        try {
            result = this.execute(runtime, random, (BaseMetadata)meta, action, runs);
        }
        catch (Throwable throwable) {
            long millis = System.currentTimeMillis() - fr;
            if (runs.size() > 1 && ConfigTable.IS_LOG_SQL && log.isInfoEnabled()) {
                log.info("{}[action:{}][table:{}][name:{}][cmds:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getTableName(true), meta.getName(), runs.size(), result, millis});
            }
            swt = ACTION.SWITCH.CONTINUE;
            if (null != this.ddListener) {
                swt = this.ddListener.afterCreate(runtime, random, meta, runs, result, millis);
            }
            if (swt == ACTION.SWITCH.CONTINUE) {
                InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
            }
            throw throwable;
        }
        long millis = System.currentTimeMillis() - fr;
        if (runs.size() > 1 && ConfigTable.IS_LOG_SQL && log.isInfoEnabled()) {
            log.info("{}[action:{}][table:{}][name:{}][cmds:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getTableName(true), meta.getName(), runs.size(), result, millis});
        }
        swt = ACTION.SWITCH.CONTINUE;
        if (null != this.ddListener) {
            swt = this.ddListener.afterCreate(runtime, random, meta, runs, result, millis);
        }
        if (swt == ACTION.SWITCH.CONTINUE) {
            InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean alter(DataRuntime runtime, Trigger meta) throws Exception {
        boolean result = false;
        ACTION.DDL action = ACTION.DDL.TRIGGER_ALTER;
        String random = this.random(runtime);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (null != this.ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = this.ddListener.prepareAlter(runtime, random, meta);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        this.checkSchema(runtime, meta);
        List<Run> runs = this.buildAlterRun(runtime, meta);
        swt = InterceptorProxy.before(runtime, random, action, meta, runs);
        if (null != this.ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = this.ddListener.beforeAlter(runtime, random, meta, runs);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        long fr = System.currentTimeMillis();
        try {
            result = this.execute(runtime, random, (BaseMetadata)meta, action, runs);
        }
        catch (Throwable throwable) {
            long millis = System.currentTimeMillis() - fr;
            if (runs.size() > 1 && ConfigTable.IS_LOG_SQL && log.isInfoEnabled()) {
                log.info("{}[action:{}][table:{}][name:{}][cmds:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getTableName(true), meta.getName(), runs.size(), result, millis});
            }
            swt = ACTION.SWITCH.CONTINUE;
            if (null != this.ddListener) {
                swt = this.ddListener.afterAlter(runtime, random, meta, runs, result, millis);
            }
            if (swt == ACTION.SWITCH.CONTINUE) {
                InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
            }
            throw throwable;
        }
        long millis = System.currentTimeMillis() - fr;
        if (runs.size() > 1 && ConfigTable.IS_LOG_SQL && log.isInfoEnabled()) {
            log.info("{}[action:{}][table:{}][name:{}][cmds:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getTableName(true), meta.getName(), runs.size(), result, millis});
        }
        swt = ACTION.SWITCH.CONTINUE;
        if (null != this.ddListener) {
            swt = this.ddListener.afterAlter(runtime, random, meta, runs, result, millis);
        }
        if (swt == ACTION.SWITCH.CONTINUE) {
            InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean drop(DataRuntime runtime, Trigger meta) throws Exception {
        boolean result = false;
        ACTION.DDL action = ACTION.DDL.TRIGGER_DROP;
        String random = this.random(runtime);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (null != this.ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = this.ddListener.prepareDrop(runtime, random, meta);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        this.checkSchema(runtime, meta);
        List<Run> runs = this.buildDropRun(runtime, meta);
        swt = InterceptorProxy.before(runtime, random, action, meta, runs);
        if (null != this.ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = this.ddListener.beforeDrop(runtime, random, meta, runs);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        long fr = System.currentTimeMillis();
        try {
            result = this.execute(runtime, random, (BaseMetadata)meta, action, runs);
        }
        catch (Throwable throwable) {
            long millis = System.currentTimeMillis() - fr;
            if (runs.size() > 1 && ConfigTable.IS_LOG_SQL && log.isInfoEnabled()) {
                log.info("{}[action:{}][table:{}][name:{}][cmds:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getTableName(true), meta.getName(), runs.size(), result, millis});
            }
            swt = ACTION.SWITCH.CONTINUE;
            if (null != this.ddListener) {
                swt = this.ddListener.afterDrop(runtime, random, meta, runs, result, millis);
            }
            if (swt == ACTION.SWITCH.CONTINUE) {
                InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
            }
            throw throwable;
        }
        long millis = System.currentTimeMillis() - fr;
        if (runs.size() > 1 && ConfigTable.IS_LOG_SQL && log.isInfoEnabled()) {
            log.info("{}[action:{}][table:{}][name:{}][cmds:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getTableName(true), meta.getName(), runs.size(), result, millis});
        }
        swt = ACTION.SWITCH.CONTINUE;
        if (null != this.ddListener) {
            swt = this.ddListener.afterDrop(runtime, random, meta, runs, result, millis);
        }
        if (swt == ACTION.SWITCH.CONTINUE) {
            InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean rename(DataRuntime runtime, Trigger origin, String name) throws Exception {
        boolean result = false;
        ACTION.DDL action = ACTION.DDL.TRIGGER_RENAME;
        String random = this.random(runtime);
        origin.setNewName(name);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, origin);
        if (null != this.ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = this.ddListener.prepareRename(runtime, random, origin);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        this.checkSchema(runtime, origin);
        List<Run> runs = this.buildRenameRun(runtime, origin);
        swt = InterceptorProxy.before(runtime, random, action, origin, runs);
        if (null != this.ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = this.ddListener.beforeRename(runtime, random, origin, runs);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        long fr = System.currentTimeMillis();
        try {
            result = this.execute(runtime, random, (BaseMetadata)origin, action, runs);
        }
        catch (Throwable throwable) {
            long millis = System.currentTimeMillis() - fr;
            if (runs.size() > 1 && ConfigTable.IS_LOG_SQL && log.isInfoEnabled()) {
                log.info("{}[action:{}][table:{}][name:{}][rename:{}][cmds:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, origin.getTableName(true), origin.getName(), name, runs.size(), result, millis});
            }
            swt = ACTION.SWITCH.CONTINUE;
            if (null != this.ddListener) {
                swt = this.ddListener.afterRename(runtime, random, origin, runs, result, millis);
            }
            if (swt == ACTION.SWITCH.CONTINUE) {
                InterceptorProxy.after(runtime, random, action, origin, runs, result, millis);
            }
            throw throwable;
        }
        long millis = System.currentTimeMillis() - fr;
        if (runs.size() > 1 && ConfigTable.IS_LOG_SQL && log.isInfoEnabled()) {
            log.info("{}[action:{}][table:{}][name:{}][rename:{}][cmds:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, origin.getTableName(true), origin.getName(), name, runs.size(), result, millis});
        }
        swt = ACTION.SWITCH.CONTINUE;
        if (null != this.ddListener) {
            swt = this.ddListener.afterRename(runtime, random, origin, runs, result, millis);
        }
        if (swt == ACTION.SWITCH.CONTINUE) {
            InterceptorProxy.after(runtime, random, action, origin, runs, result, millis);
        }
        return result;
    }

    @Override
    public List<Run> buildCreateRun(DataRuntime runtime, Trigger meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildCreateRun(DataRuntime runtime, Trigger meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildAlterRun(DataRuntime runtime, Trigger meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildAlterRun(DataRuntime runtime, Trigger meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildDropRun(DataRuntime runtime, Trigger meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildDropRun(DataRuntime runtime, Trigger meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildRenameRun(DataRuntime runtime, Trigger meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildRenameRun(DataRuntime runtime, Trigger meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public StringBuilder each(DataRuntime runtime, StringBuilder builder, Trigger meta) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 StringBuilder each(DataRuntime runtime, StringBuilder builder, Trigger meta)"), (int)37));
        }
        return builder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean create(DataRuntime runtime, Procedure meta) throws Exception {
        boolean result = false;
        ACTION.DDL action = ACTION.DDL.PRIMARY_ADD;
        String random = this.random(runtime);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (null != this.ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = this.ddListener.prepareCreate(runtime, random, meta);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        this.checkSchema(runtime, meta);
        List<Run> runs = this.buildCreateRun(runtime, meta);
        swt = InterceptorProxy.before(runtime, random, action, meta, runs);
        if (null != this.ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = this.ddListener.beforeCreate(runtime, random, meta, runs);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        long fr = System.currentTimeMillis();
        try {
            result = this.execute(runtime, random, (BaseMetadata)meta, action, runs);
        }
        catch (Throwable throwable) {
            long millis = System.currentTimeMillis() - fr;
            if (runs.size() > 1 && ConfigTable.IS_LOG_SQL && log.isInfoEnabled()) {
                log.info("{}[action:{}][name:{}][cmds:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getName(), runs.size(), result, millis});
            }
            swt = ACTION.SWITCH.CONTINUE;
            if (null != this.ddListener) {
                swt = this.ddListener.afterCreate(runtime, random, meta, runs, result, millis);
            }
            if (swt == ACTION.SWITCH.CONTINUE) {
                InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
            }
            throw throwable;
        }
        long millis = System.currentTimeMillis() - fr;
        if (runs.size() > 1 && ConfigTable.IS_LOG_SQL && log.isInfoEnabled()) {
            log.info("{}[action:{}][name:{}][cmds:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getName(), runs.size(), result, millis});
        }
        swt = ACTION.SWITCH.CONTINUE;
        if (null != this.ddListener) {
            swt = this.ddListener.afterCreate(runtime, random, meta, runs, result, millis);
        }
        if (swt == ACTION.SWITCH.CONTINUE) {
            InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean alter(DataRuntime runtime, Procedure meta) throws Exception {
        boolean result = false;
        ACTION.DDL action = ACTION.DDL.PROCEDURE_ALTER;
        String random = this.random(runtime);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (null != this.ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = this.ddListener.prepareAlter(runtime, random, meta);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        this.checkSchema(runtime, meta);
        List<Run> runs = this.buildAlterRun(runtime, meta);
        swt = InterceptorProxy.before(runtime, random, action, meta, runs);
        if (null != this.ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = this.ddListener.beforeAlter(runtime, random, meta, runs);
        }
        long fr = System.currentTimeMillis();
        try {
            result = this.execute(runtime, random, (BaseMetadata)meta, action, runs);
        }
        catch (Throwable throwable) {
            long millis = System.currentTimeMillis() - fr;
            if (runs.size() > 1 && ConfigTable.IS_LOG_SQL && log.isInfoEnabled()) {
                log.info("{}[action:{}][name:{}][cmds:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getName(), runs.size(), result, millis});
            }
            swt = ACTION.SWITCH.CONTINUE;
            if (null != this.ddListener) {
                swt = this.ddListener.afterAlter(runtime, random, meta, runs, result, millis);
            }
            if (swt == ACTION.SWITCH.CONTINUE) {
                InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
            }
            throw throwable;
        }
        long millis = System.currentTimeMillis() - fr;
        if (runs.size() > 1 && ConfigTable.IS_LOG_SQL && log.isInfoEnabled()) {
            log.info("{}[action:{}][name:{}][cmds:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getName(), runs.size(), result, millis});
        }
        swt = ACTION.SWITCH.CONTINUE;
        if (null != this.ddListener) {
            swt = this.ddListener.afterAlter(runtime, random, meta, runs, result, millis);
        }
        if (swt == ACTION.SWITCH.CONTINUE) {
            InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean drop(DataRuntime runtime, Procedure meta) throws Exception {
        boolean result = true;
        ACTION.DDL action = ACTION.DDL.PROCEDURE_DROP;
        String random = this.random(runtime);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (null != this.ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = this.ddListener.prepareDrop(runtime, random, meta);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        this.checkSchema(runtime, meta);
        List<Run> runs = this.buildDropRun(runtime, meta);
        swt = InterceptorProxy.before(runtime, random, action, meta, runs);
        if (null != this.ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = this.ddListener.beforeDrop(runtime, random, meta, runs);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        long fr = System.currentTimeMillis();
        try {
            result = this.execute(runtime, random, (BaseMetadata)meta, action, runs);
        }
        catch (Throwable throwable) {
            long millis = System.currentTimeMillis() - fr;
            if (runs.size() > 1 && ConfigTable.IS_LOG_SQL && log.isInfoEnabled()) {
                log.info("{}[action:{}][name:{}][cmds:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, meta.getName(), runs.size(), result, millis});
            }
            swt = ACTION.SWITCH.CONTINUE;
            if (null != this.ddListener) {
                swt = this.ddListener.afterDrop(runtime, random, meta, runs, result, millis);
            }
            if (swt == ACTION.SWITCH.CONTINUE) {
                InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
            }
            throw throwable;
        }
        long millis = System.currentTimeMillis() - fr;
        if (runs.size() > 1 && ConfigTable.IS_LOG_SQL && log.isInfoEnabled()) {
            log.info("{}[action:{}][name:{}][cmds:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, meta.getName(), runs.size(), result, millis});
        }
        swt = ACTION.SWITCH.CONTINUE;
        if (null != this.ddListener) {
            swt = this.ddListener.afterDrop(runtime, random, meta, runs, result, millis);
        }
        if (swt == ACTION.SWITCH.CONTINUE) {
            InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean rename(DataRuntime runtime, Procedure origin, String name) throws Exception {
        boolean result = false;
        ACTION.DDL action = ACTION.DDL.PROCEDURE_RENAME;
        origin.setNewName(name);
        String random = this.random(runtime);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, origin);
        if (null != this.ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = this.ddListener.prepareRename(runtime, random, origin);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        this.checkSchema(runtime, origin);
        List<Run> runs = this.buildRenameRun(runtime, origin);
        swt = InterceptorProxy.before(runtime, random, action, origin, runs);
        if (null == this.ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = this.ddListener.beforeRename(runtime, random, origin, runs);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        long fr = System.currentTimeMillis();
        try {
            result = this.execute(runtime, random, (BaseMetadata)origin, action, runs);
        }
        catch (Throwable throwable) {
            long millis = System.currentTimeMillis() - fr;
            if (runs.size() > 1 && ConfigTable.IS_LOG_SQL && log.isInfoEnabled()) {
                log.info("{}[action:{}][name:{}][cmds:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, origin.getName(), runs.size(), result, millis});
            }
            swt = ACTION.SWITCH.CONTINUE;
            if (null != this.ddListener) {
                swt = this.ddListener.afterRename(runtime, random, origin, runs, result, millis);
            }
            if (swt == ACTION.SWITCH.CONTINUE) {
                InterceptorProxy.after(runtime, random, action, origin, runs, result, millis);
            }
            throw throwable;
        }
        long millis = System.currentTimeMillis() - fr;
        if (runs.size() > 1 && ConfigTable.IS_LOG_SQL && log.isInfoEnabled()) {
            log.info("{}[action:{}][name:{}][cmds:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, origin.getName(), runs.size(), result, millis});
        }
        swt = ACTION.SWITCH.CONTINUE;
        if (null != this.ddListener) {
            swt = this.ddListener.afterRename(runtime, random, origin, runs, result, millis);
        }
        if (swt == ACTION.SWITCH.CONTINUE) {
            InterceptorProxy.after(runtime, random, action, origin, runs, result, millis);
        }
        return result;
    }

    @Override
    public List<Run> buildCreateRun(DataRuntime runtime, Procedure meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildCreateRun(DataRuntime runtime, Procedure meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildAlterRun(DataRuntime runtime, Procedure meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildAlterRun(DataRuntime runtime, Procedure meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildDropRun(DataRuntime runtime, Procedure meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildDropRun(DataRuntime runtime, Procedure meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildRenameRun(DataRuntime runtime, Procedure meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildRenameRun(DataRuntime runtime, Procedure meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public StringBuilder parameter(DataRuntime runtime, StringBuilder builder, Parameter parameter) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 StringBuilder parameter(DataRuntime runtime, StringBuilder builder, Parameter parameter)"), (int)37));
        }
        return builder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean create(DataRuntime runtime, Function meta) throws Exception {
        boolean result = true;
        ACTION.DDL action = ACTION.DDL.FUNCTION_CREATE;
        String random = this.random(runtime);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (null != this.ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = this.ddListener.prepareCreate(runtime, random, meta);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        this.checkSchema(runtime, meta);
        List<Run> runs = this.buildCreateRun(runtime, meta);
        long fr = System.currentTimeMillis();
        try {
            result = this.execute(runtime, random, (BaseMetadata)meta, action, runs);
        }
        catch (Throwable throwable) {
            long millis = System.currentTimeMillis() - fr;
            swt = ACTION.SWITCH.CONTINUE;
            if (runs.size() > 1 && ConfigTable.IS_LOG_SQL && log.isInfoEnabled()) {
                log.info("{}[action:{}][name:{}][cmds:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getName(), runs.size(), result, millis});
            }
            if (null != this.ddListener) {
                swt = this.ddListener.afterCreate(runtime, random, meta, runs, result, millis);
            }
            if (swt == ACTION.SWITCH.CONTINUE) {
                InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
            }
            throw throwable;
        }
        long millis = System.currentTimeMillis() - fr;
        swt = ACTION.SWITCH.CONTINUE;
        if (runs.size() > 1 && ConfigTable.IS_LOG_SQL && log.isInfoEnabled()) {
            log.info("{}[action:{}][name:{}][cmds:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getName(), runs.size(), result, millis});
        }
        if (null != this.ddListener) {
            swt = this.ddListener.afterCreate(runtime, random, meta, runs, result, millis);
        }
        if (swt == ACTION.SWITCH.CONTINUE) {
            InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean alter(DataRuntime runtime, Function meta) throws Exception {
        boolean result = false;
        String random = this.random(runtime);
        ACTION.DDL action = ACTION.DDL.FUNCTION_ALTER;
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (null != this.ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = this.ddListener.prepareDrop(runtime, random, meta);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        this.checkSchema(runtime, meta);
        List<Run> runs = this.buildAlterRun(runtime, meta);
        swt = InterceptorProxy.before(runtime, random, action, meta, runs);
        if (null != this.ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = this.ddListener.beforeDrop(runtime, random, meta, runs);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        long fr = System.currentTimeMillis();
        try {
            result = this.execute(runtime, random, (BaseMetadata)meta, action, runs);
        }
        catch (Throwable throwable) {
            long millis = System.currentTimeMillis() - fr;
            if (runs.size() > 1 && ConfigTable.IS_LOG_SQL && log.isInfoEnabled()) {
                log.info("{}[action:{}][name:{}][cmds:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getName(), runs.size(), result, millis});
            }
            swt = ACTION.SWITCH.CONTINUE;
            if (null != this.ddListener) {
                swt = this.ddListener.afterAlter(runtime, random, meta, runs, result, millis);
            }
            if (swt == ACTION.SWITCH.CONTINUE) {
                InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
            }
            throw throwable;
        }
        long millis = System.currentTimeMillis() - fr;
        if (runs.size() > 1 && ConfigTable.IS_LOG_SQL && log.isInfoEnabled()) {
            log.info("{}[action:{}][name:{}][cmds:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getName(), runs.size(), result, millis});
        }
        swt = ACTION.SWITCH.CONTINUE;
        if (null != this.ddListener) {
            swt = this.ddListener.afterAlter(runtime, random, meta, runs, result, millis);
        }
        if (swt == ACTION.SWITCH.CONTINUE) {
            InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean drop(DataRuntime runtime, Function meta) throws Exception {
        ACTION.DDL action;
        boolean result = false;
        String random = this.random(runtime);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action = ACTION.DDL.FUNCTION_DROP, meta);
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        if (null != this.ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = this.ddListener.prepareDrop(runtime, random, meta);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        this.checkSchema(runtime, meta);
        List<Run> runs = this.buildDropRun(runtime, meta);
        swt = InterceptorProxy.before(runtime, random, action, meta, runs);
        if (null != this.ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = this.ddListener.beforeDrop(runtime, random, meta, runs);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        long fr = System.currentTimeMillis();
        try {
            result = this.execute(runtime, random, (BaseMetadata)meta, action, runs);
        }
        catch (Throwable throwable) {
            long millis = System.currentTimeMillis() - fr;
            if (runs.size() > 1 && ConfigTable.IS_LOG_SQL && log.isInfoEnabled()) {
                log.info("{}[action:{}][name:{}][cmds:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getName(), runs.size(), result, millis});
            }
            swt = ACTION.SWITCH.CONTINUE;
            if (null != this.ddListener) {
                swt = this.ddListener.afterDrop(runtime, random, meta, runs, result, millis);
            }
            if (swt == ACTION.SWITCH.CONTINUE) {
                InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
            }
            throw throwable;
        }
        long millis = System.currentTimeMillis() - fr;
        if (runs.size() > 1 && ConfigTable.IS_LOG_SQL && log.isInfoEnabled()) {
            log.info("{}[action:{}][name:{}][cmds:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getName(), runs.size(), result, millis});
        }
        swt = ACTION.SWITCH.CONTINUE;
        if (null != this.ddListener) {
            swt = this.ddListener.afterDrop(runtime, random, meta, runs, result, millis);
        }
        if (swt == ACTION.SWITCH.CONTINUE) {
            InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean rename(DataRuntime runtime, Function origin, String name) throws Exception {
        boolean result = false;
        ACTION.DDL action = ACTION.DDL.FUNCTION_RENAME;
        String random = this.random(runtime);
        origin.setNewName(name);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, origin);
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        if (null != this.ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = this.ddListener.prepareRename(runtime, random, origin);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        this.checkSchema(runtime, origin);
        List<Run> runs = this.buildRenameRun(runtime, origin);
        swt = InterceptorProxy.before(runtime, random, action, origin, runs);
        if (null != this.ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = this.ddListener.beforeRename(runtime, random, origin, runs);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        long fr = System.currentTimeMillis();
        try {
            result = this.execute(runtime, random, (BaseMetadata)origin, action, runs);
        }
        catch (Throwable throwable) {
            long millis = System.currentTimeMillis() - fr;
            if (runs.size() > 1 && ConfigTable.IS_LOG_SQL && log.isInfoEnabled()) {
                log.info("{}[action:{}][name:{}][rename:{}][cmds:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, origin.getName(), name, runs.size(), result, millis});
            }
            swt = ACTION.SWITCH.CONTINUE;
            if (null != this.ddListener) {
                swt = this.ddListener.afterRename(runtime, random, origin, runs, result, millis);
            }
            if (swt == ACTION.SWITCH.CONTINUE) {
                InterceptorProxy.after(runtime, random, action, origin, runs, result, millis);
            }
            throw throwable;
        }
        long millis = System.currentTimeMillis() - fr;
        if (runs.size() > 1 && ConfigTable.IS_LOG_SQL && log.isInfoEnabled()) {
            log.info("{}[action:{}][name:{}][rename:{}][cmds:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, origin.getName(), name, runs.size(), result, millis});
        }
        swt = ACTION.SWITCH.CONTINUE;
        if (null != this.ddListener) {
            swt = this.ddListener.afterRename(runtime, random, origin, runs, result, millis);
        }
        if (swt == ACTION.SWITCH.CONTINUE) {
            InterceptorProxy.after(runtime, random, action, origin, runs, result, millis);
        }
        return result;
    }

    @Override
    public List<Run> buildCreateRun(DataRuntime runtime, Function meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildCreateRun(DataRuntime runtime, Function meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildAlterRun(DataRuntime runtime, Function meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildAlterRun(DataRuntime runtime, Function meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildDropRun(DataRuntime runtime, Function meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildDropRun(DataRuntime runtime, Function meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildRenameRun(DataRuntime runtime, Function meta) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getSimpleName() + ")\u672a\u5b9e\u73b0 List<Run> buildRenameRun(DataRuntime runtime, Function meta)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    protected PrimaryGenerator checkPrimaryGenerator(DatabaseType type, String table) {
        PrimaryGenerator generator = GeneratorConfig.get((String)table);
        if (null != generator && generator != PrimaryGenerator.GENERATOR.DISABLE && generator != PrimaryGenerator.GENERATOR.AUTO) {
            return generator;
        }
        if (null == this.primaryGenerator) {
            if (null == this.primaryGenerator) {
                this.primaryGenerator = GeneratorConfig.get();
            }
            if (null == this.primaryGenerator) {
                if (ConfigTable.PRIMARY_GENERATOR_SNOWFLAKE_ACTIVE) {
                    this.primaryGenerator = PrimaryGenerator.GENERATOR.SNOWFLAKE;
                } else if (ConfigTable.PRIMARY_GENERATOR_UUID_ACTIVE) {
                    this.primaryGenerator = PrimaryGenerator.GENERATOR.RANDOM;
                } else if (ConfigTable.PRIMARY_GENERATOR_UUID_ACTIVE) {
                    this.primaryGenerator = PrimaryGenerator.GENERATOR.UUID;
                } else if (ConfigTable.PRIMARY_GENERATOR_TIME_ACTIVE) {
                    this.primaryGenerator = PrimaryGenerator.GENERATOR.TIME;
                } else if (ConfigTable.PRIMARY_GENERATOR_TIMESTAMP_ACTIVE) {
                    this.primaryGenerator = PrimaryGenerator.GENERATOR.TIMESTAMP;
                }
            }
        }
        if (null != this.primaryGenerator) {
            return this.primaryGenerator;
        }
        return null;
    }

    @Override
    public ColumnType type(String type) {
        ColumnType ct;
        if (null == type) {
            return null;
        }
        boolean array = false;
        if (type.startsWith("_")) {
            type = type.substring(1);
            array = true;
        }
        if (type.endsWith("[]")) {
            type = type.replace("[]", "");
            array = true;
        }
        if (null != (ct = this.types.get(type.toUpperCase()))) {
            ct.setArray(array);
        }
        return ct;
    }

    @Override
    public StringBuilder name(DataRuntime runtime, StringBuilder builder, BaseMetadata meta) {
        Catalog catalog = meta.getCatalog();
        Schema schema = meta.getSchema();
        String name = meta.getName();
        if (BasicUtil.isNotEmpty((Object)catalog)) {
            this.delimiter(builder, (BaseMetadata)catalog).append(".");
        }
        if (BasicUtil.isNotEmpty((Object)schema)) {
            this.delimiter(builder, (BaseMetadata)schema).append(".");
        }
        this.delimiter(builder, name);
        return builder;
    }

    @Override
    public boolean isBooleanColumn(DataRuntime runtime, Column column) {
        String type;
        String clazz = column.getClassName();
        return null != clazz ? (clazz = clazz.toLowerCase()).contains("boolean") : null != (type = column.getTypeName()) && ((type = type.toLowerCase()).equals("bit") || type.equals("bool"));
    }

    @Override
    public boolean isNumberColumn(DataRuntime runtime, Column column) {
        String type;
        String clazz = column.getClassName();
        return null != clazz ? (clazz = clazz.toLowerCase()).startsWith("int") || clazz.contains("integer") || clazz.contains("long") || clazz.contains("decimal") || clazz.contains("float") || clazz.contains("double") || clazz.contains("timestamp") || clazz.contains("short") : null != (type = column.getTypeName()) && ((type = type.toLowerCase()).startsWith("int") || type.contains("float") || type.contains("double") || type.contains("short") || type.contains("long") || type.contains("decimal") || type.contains("numeric") || type.contains("timestamp"));
    }

    @Override
    public boolean isCharColumn(DataRuntime runtime, Column column) {
        return !this.isNumberColumn(runtime, column) && !this.isBooleanColumn(runtime, column);
    }

    @Override
    public String value(DataRuntime runtime, Column column, DriverAdapter.SQL_BUILD_IN_VALUE value) {
        return null;
    }

    protected String string(Map<String, Integer> keys, String key, ResultSet set, String def) throws Exception {
        Object value = this.value(keys, key, set);
        if (null != value) {
            return value.toString();
        }
        return def;
    }

    protected String string(Map<String, Integer> keys, String key, ResultSet set) throws Exception {
        return this.string(keys, key, set, null);
    }

    protected Integer integer(Map<String, Integer> keys, String key, ResultSet set, Integer def) throws Exception {
        Object value = this.value(keys, key, set);
        if (null != value) {
            return BasicUtil.parseInt((Object)value, (Integer)def);
        }
        return null;
    }

    protected Long longs(Map<String, Integer> keys, String key, ResultSet set, Long def) throws Exception {
        Object value = this.value(keys, key, set);
        if (null != value) {
            return BasicUtil.parseLong((Object)value, (Long)def);
        }
        return null;
    }

    protected Boolean bool(Map<String, Integer> keys, String key, ResultSet set, Boolean def) throws Exception {
        Object value = this.value(keys, key, set);
        if (null != value) {
            return BasicUtil.parseBoolean((Object)value, (Boolean)def);
        }
        return null;
    }

    protected Boolean bool(Map<String, Integer> keys, String key, ResultSet set, int def) throws Exception {
        Boolean defaultValue = null;
        if (def == 0) {
            defaultValue = false;
        } else if (def == 1) {
            defaultValue = true;
        }
        return this.bool(keys, key, set, defaultValue);
    }

    protected Object value(Map<String, Integer> keys, String key, ResultSet set, Object def) throws Exception {
        String[] ks = key.split(",");
        Object result = null;
        for (String k : ks) {
            Integer index = keys.get(k);
            if (null == index || index < 0) continue;
            try {
                result = set.getObject(index);
                if (null == result) continue;
                return result;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return def;
    }

    protected Object value(Map<String, Integer> keys, String key, ResultSet set) throws Exception {
        return this.value(keys, key, set, null);
    }

    @Override
    public String getPrimaryKey(DataRuntime runtime, Object obj) {
        if (null == obj) {
            return null;
        }
        if (obj instanceof DataRow) {
            return ((DataRow)obj).getPrimaryKey();
        }
        return EntityAdapterProxy.primaryKey(obj.getClass(), (boolean)true);
    }

    @Override
    public Object getPrimaryValue(DataRuntime runtime, Object obj) {
        if (null == obj) {
            return null;
        }
        if (obj instanceof DataRow) {
            return ((DataRow)obj).getPrimaryValue();
        }
        return EntityAdapterProxy.primaryValue((Object)obj);
    }

    public String parseTable(String table) {
        if (null == table) {
            return table;
        }
        table = ((String)table).replace(this.getDelimiterFr(), "").replace(this.getDelimiterTo(), "");
        if (((String)(table = DataSourceUtil.parseDataSource((String)table, null))).contains(".")) {
            String[] tmps = ((String)table).split("\\.");
            table = SQLUtil.delimiter((String)tmps[0], (String)this.getDelimiterFr(), (String)this.getDelimiterTo()) + "." + SQLUtil.delimiter((String)tmps[1], (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
        } else {
            table = SQLUtil.delimiter((String)table, (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
        }
        return table;
    }

    @Override
    public Object write(DataRuntime runtime, Column metadata, Object value, boolean placeholder) {
        if (null == value || "NULL".equals(value)) {
            return null;
        }
        Object result = null;
        ColumnType columnType = null;
        DataWriter writer = null;
        boolean isArray = false;
        if (null != metadata) {
            String typeName;
            isArray = metadata.isArray();
            columnType = metadata.getColumnType();
            if (null != columnType) {
                writer = this.writer(columnType);
            }
            if (null == writer && null != (typeName = metadata.getTypeName())) {
                writer = this.writer(typeName);
                if (null != columnType) {
                    writer = this.writer(this.type(typeName.toUpperCase()));
                }
            }
        }
        if (null == columnType) {
            columnType = this.type(value.getClass().getSimpleName());
        }
        if (null != columnType) {
            Class writeClass = columnType.compatible();
            value = ConvertAdapter.convert((Object)value, (Class)writeClass, (boolean)isArray);
        }
        if (null != columnType) {
            writer = this.writer(columnType);
        }
        if (null == writer && null != value) {
            writer = this.writer(value.getClass());
        }
        if (null != writer) {
            result = writer.write(value, placeholder);
        }
        if (null != result) {
            return result;
        }
        if (null != columnType) {
            result = columnType.write(value, null, false);
        }
        if (null != result) {
            return result;
        }
        if (!placeholder) {
            result = BasicUtil.isNumber((Object)value) || "NULL".equals(value) ? value : "'" + value + "'";
        }
        return result;
    }

    @Override
    public Object read(DataRuntime runtime, Column metadata, Object value, Class clazz) {
        Object result = value;
        if (null == value) {
            return null;
        }
        DataReader reader = null;
        ColumnType ctype = null;
        if (null != metadata) {
            String typeName;
            ctype = metadata.getColumnType();
            if (null != ctype) {
                reader = this.reader(ctype);
            }
            if (null == reader && null != (typeName = metadata.getTypeName()) && null == (reader = this.reader(typeName))) {
                reader = this.reader(this.type(typeName));
            }
        }
        if (null == reader) {
            reader = this.reader(value.getClass());
        }
        if (null != reader) {
            result = reader.read(value);
        }
        if ((null == reader || null == result) && null != ctype) {
            result = ctype.read(value, null, clazz);
        }
        return result;
    }

    @Override
    public void value(DataRuntime runtime, StringBuilder builder, Object obj, String key) {
        Object value = null;
        if (obj instanceof DataRow) {
            value = ((DataRow)obj).get(key);
        } else if (EntityAdapterProxy.hasAdapter(obj.getClass())) {
            Field field = EntityAdapterProxy.field(obj.getClass(), (String)key);
            value = BeanUtil.getFieldValue((Object)obj, (Field)field);
        } else {
            value = BeanUtil.getFieldValue((Object)obj, (String)key);
        }
        if (null != value) {
            if (value instanceof DriverAdapter.SQL_BUILD_IN_VALUE) {
                builder.append(this.value(runtime, null, (DriverAdapter.SQL_BUILD_IN_VALUE)((Object)value)));
            } else {
                ColumnType type = this.type(value.getClass().getName());
                if (null != type) {
                    value = type.write(value, null, false);
                }
                builder.append(value);
            }
        } else {
            builder.append("null");
        }
    }

    @Override
    public boolean convert(DataRuntime runtime, Catalog catalog, Schema schema, String table, RunValue value) {
        boolean result = false;
        if (ConfigTable.IS_AUTO_CHECK_METADATA) {
            LinkedHashMap<String, Column> columns = this.columns(runtime, null, false, new Table(catalog, schema, table), false);
            result = this.convert(runtime, columns, value);
        } else {
            result = this.convert(runtime, (Column)null, value);
        }
        return result;
    }

    @Override
    public void addRunValue(DataRuntime runtime, Run run, Compare compare, Column column, Object value) {
        boolean split = ConfigTable.IS_AUTO_SPLIT_ARRAY;
        if (ConfigTable.IS_AUTO_CHECK_METADATA) {
            LinkedHashMap columns;
            String type = null;
            if (null != column && null == (type = column.getTypeName()) && BasicUtil.isNotEmpty((Object)run.getTable()) && null != (column = (Column)(columns = this.columns(runtime, null, false, new Table(run.getTable()), false)).get(column.getName().toUpperCase()))) {
                type = column.getTypeName();
            }
        }
        RunValue rv = run.addValues(compare, column, value, split);
        if (null != column) {
            // empty if block
        }
    }

    @Override
    public boolean convert(DataRuntime runtime, ConfigStore configs, Run run) {
        boolean result = false;
        if (null != run) {
            result = this.convert(runtime, new Table(run.getTable()), run);
        }
        return result;
    }

    @Override
    public boolean convert(DataRuntime runtime, Table table, Run run) {
        List<RunValue> values;
        boolean result = false;
        LinkedHashMap<String, Column> columns = table.getColumns();
        if (ConfigTable.IS_AUTO_CHECK_METADATA && (null == columns || columns.isEmpty())) {
            columns = this.columns(runtime, null, false, table, false);
        }
        if (null != (values = run.getRunValues())) {
            for (RunValue value : values) {
                if (ConfigTable.IS_AUTO_CHECK_METADATA) {
                    result = this.convert(runtime, columns, value);
                    continue;
                }
                result = this.convert(runtime, (Column)null, value);
            }
        }
        return result;
    }

    @Override
    public boolean convert(DataRuntime runtime, Map<String, Column> columns, RunValue value) {
        String key;
        boolean result = false;
        if (null != columns && null != value && null != (key = value.getKey())) {
            Column meta = columns.get(key.toUpperCase());
            result = this.convert(runtime, meta, value);
        }
        return result;
    }

    @Override
    public boolean convert(DataRuntime runtime, Column metadata, RunValue run) {
        if (null == run) {
            return true;
        }
        Object value = run.getValue();
        if (null == value) {
            return true;
        }
        try {
            if (null != metadata) {
                value = this.convert(runtime, metadata, value);
            } else {
                DataWriter writer = this.writer(value.getClass());
                if (null != writer) {
                    value = writer.write(value, true);
                }
            }
            run.setValue(value);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    @Override
    public Object convert(DataRuntime runtime, Column metadata, Object value) {
        if (null == value) {
            return value;
        }
        try {
            if (null != metadata) {
                ColumnType columnType = metadata.getColumnType();
                if (null == columnType && null != (columnType = this.type(metadata.getTypeName()))) {
                    columnType.setArray(metadata.isArray());
                    metadata.setColumnType(columnType);
                }
                value = this.convert(runtime, columnType, value);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return value;
    }

    @Override
    public Object convert(DataRuntime runtime, ColumnType columnType, Object value) {
        if (null == columnType) {
            return value;
        }
        String typeName = columnType.getName();
        boolean parseJson = false;
        if (null != typeName && !(value instanceof String)) {
            if (typeName.contains("JSON")) {
                value = BeanUtil.object2json((Object)value);
                parseJson = true;
            } else if (typeName.contains("XML")) {
                value = BeanUtil.object2xml((Object)value);
                parseJson = true;
            }
        }
        if (!parseJson && null != columnType) {
            DataWriter writer = this.writer(columnType);
            if (null != writer) {
                value = writer.write(value, true);
            } else {
                Class transfer = columnType.transfer();
                Class compatible = columnType.compatible();
                if (null != transfer) {
                    value = ConvertAdapter.convert((Object)value, (Class)transfer, (boolean)columnType.isArray());
                }
                if (null != compatible) {
                    value = ConvertAdapter.convert((Object)value, (Class)compatible, (boolean)columnType.isArray());
                }
            }
        }
        return value;
    }

    public PrimaryGenerator getPrimaryGenerator() {
        return this.primaryGenerator;
    }

    public void setPrimaryGenerator(PrimaryGenerator primaryGenerator) {
        this.primaryGenerator = primaryGenerator;
    }

    @Override
    public String objectName(DataRuntime runtime, String name) {
        KeyAdapter.KEY_CASE keyCase = this.type().nameCase();
        if (null != keyCase) {
            return keyCase.convert(name);
        }
        return name;
    }

    protected String random(DataRuntime runtime) {
        StringBuilder builder = new StringBuilder();
        builder.append("[SQL:").append(System.currentTimeMillis()).append("-").append(BasicUtil.getRandomNumberString((int)8)).append("][thread:").append(Thread.currentThread().getId()).append("][ds:").append(runtime.datasource()).append("]");
        return builder.toString();
    }

    protected String concat(String prefix, String split, List<String> columns) {
        StringBuilder builder = new StringBuilder();
        if (BasicUtil.isEmpty((Object)prefix)) {
            prefix = "";
        } else if (!((String)prefix).endsWith(".")) {
            prefix = (String)prefix + ".";
        }
        boolean first = true;
        for (String column : columns) {
            if (!first) {
                builder.append(split);
            }
            first = false;
            builder.append((String)prefix).append(column);
        }
        return builder.toString();
    }

    protected String concatEqual(String master, String data, String split, List<String> columns) {
        StringBuilder builder = new StringBuilder();
        if (BasicUtil.isEmpty((Object)master)) {
            master = "";
        } else if (!((String)master).endsWith(".")) {
            master = (String)master + ".";
        }
        if (BasicUtil.isEmpty((Object)data)) {
            data = "";
        } else if (!((String)data).endsWith(".")) {
            data = (String)data + ".";
        }
        boolean first = true;
        for (String column : columns) {
            if (!first) {
                builder.append(split);
            }
            first = false;
            builder.append((String)master).append(column).append(" = ").append((String)data).append(column);
        }
        return builder.toString();
    }

    public StringBuilder delimiter(StringBuilder builder, String src) {
        return SQLUtil.delimiter((StringBuilder)builder, (String)src, (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
    }

    public StringBuilder delimiter(StringBuilder builder, BaseMetadata src) {
        String name;
        if (null != src && BasicUtil.isNotEmpty((Object)(name = src.getName()))) {
            SQLUtil.delimiter((StringBuilder)builder, (String)name, (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
        }
        return builder;
    }

    public <T extends BaseMetadata> T search(List<T> list, String catalog, String schema, String name) {
        return (T)BaseMetadata.search(list, (String)catalog, (String)schema, (String)name);
    }

    public <T extends BaseMetadata> T search(List<T> list, String catalog, String name) {
        return (T)BaseMetadata.search(list, (String)catalog, (String)name);
    }

    public <T extends BaseMetadata> T search(List<T> list, String name) {
        return (T)BaseMetadata.search(list, (String)name);
    }

    protected boolean IS_LOG_SQL(ConfigStore configs) {
        if (null != configs) {
            return configs.IS_LOG_SQL();
        }
        return ConfigTable.IS_LOG_SQL;
    }

    protected boolean IS_AUTO_CHECK_METADATA(ConfigStore configs) {
        if (null != configs) {
            return configs.IS_AUTO_CHECK_METADATA();
        }
        return ConfigTable.IS_AUTO_CHECK_METADATA;
    }

    protected boolean IS_LOG_SLOW_SQL(ConfigStore configs) {
        if (null != configs) {
            return configs.IS_LOG_SLOW_SQL();
        }
        return ConfigTable.IS_LOG_SLOW_SQL;
    }

    protected boolean IS_LOG_SQL_PARAM(ConfigStore configs) {
        if (null != configs) {
            return configs.IS_LOG_SQL_PARAM();
        }
        return ConfigTable.IS_LOG_SQL_PARAM;
    }

    protected boolean IS_LOG_BATCH_SQL_PARAM(ConfigStore configs) {
        if (null != configs) {
            return configs.IS_LOG_BATCH_SQL_PARAM();
        }
        return ConfigTable.IS_LOG_BATCH_SQL_PARAM;
    }

    protected boolean IS_LOG_SQL_WHEN_ERROR(ConfigStore configs) {
        if (null != configs) {
            return configs.IS_LOG_SQL_WHEN_ERROR();
        }
        return ConfigTable.IS_LOG_SQL_WHEN_ERROR;
    }

    protected boolean IS_PRINT_EXCEPTION_STACK_TRACE(ConfigStore configs) {
        if (null != configs) {
            return configs.IS_PRINT_EXCEPTION_STACK_TRACE();
        }
        return ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE;
    }

    protected boolean IS_LOG_SQL_PARAM_WHEN_ERROR(ConfigStore configs) {
        if (null != configs) {
            return configs.IS_LOG_SQL_PARAM_WHEN_ERROR();
        }
        return ConfigTable.IS_LOG_SQL_PARAM_WHEN_ERROR;
    }

    protected boolean IS_SQL_LOG_PLACEHOLDER(ConfigStore configs) {
        if (null != configs) {
            return configs.IS_SQL_LOG_PLACEHOLDER();
        }
        return ConfigTable.IS_SQL_LOG_PLACEHOLDER;
    }

    protected boolean IS_LOG_SQL_TIME(ConfigStore configs) {
        if (null != configs) {
            return configs.IS_LOG_SQL_TIME();
        }
        return ConfigTable.IS_LOG_SQL_TIME;
    }

    protected long SLOW_SQL_MILLIS(ConfigStore configs) {
        if (null != configs) {
            return configs.SLOW_SQL_MILLIS();
        }
        return ConfigTable.SLOW_SQL_MILLIS;
    }

    protected boolean IS_THROW_SQL_QUERY_EXCEPTION(ConfigStore configs) {
        if (null != configs) {
            return configs.IS_THROW_SQL_QUERY_EXCEPTION();
        }
        return ConfigTable.IS_THROW_SQL_QUERY_EXCEPTION;
    }

    protected boolean IS_THROW_SQL_UPDATE_EXCEPTION(ConfigStore configs) {
        if (null != configs) {
            return configs.IS_THROW_SQL_UPDATE_EXCEPTION();
        }
        return ConfigTable.IS_THROW_SQL_UPDATE_EXCEPTION;
    }

    protected boolean IS_UPDATE_NULL_COLUMN(ConfigStore configs) {
        if (null != configs) {
            return configs.IS_UPDATE_NULL_COLUMN();
        }
        return ConfigTable.IS_UPDATE_NULL_COLUMN;
    }

    protected boolean IS_UPDATE_EMPTY_COLUMN(ConfigStore configs) {
        if (null != configs) {
            return configs.IS_UPDATE_EMPTY_COLUMN();
        }
        return ConfigTable.IS_UPDATE_EMPTY_COLUMN;
    }

    protected boolean IS_UPDATE_NULL_FIELD(ConfigStore configs) {
        if (null != configs) {
            return configs.IS_UPDATE_NULL_FIELD();
        }
        return ConfigTable.IS_UPDATE_NULL_FIELD;
    }

    protected boolean IS_UPDATE_EMPTY_FIELD(ConfigStore configs) {
        if (null != configs) {
            return configs.IS_UPDATE_EMPTY_FIELD();
        }
        return ConfigTable.IS_UPDATE_EMPTY_FIELD;
    }

    protected boolean IS_INSERT_NULL_FIELD(ConfigStore configs) {
        if (null != configs) {
            return configs.IS_INSERT_NULL_FIELD();
        }
        return ConfigTable.IS_INSERT_NULL_FIELD;
    }

    protected boolean IS_INSERT_EMPTY_FIELD(ConfigStore configs) {
        if (null != configs) {
            return configs.IS_INSERT_EMPTY_FIELD();
        }
        return ConfigTable.IS_INSERT_EMPTY_FIELD;
    }

    protected boolean IS_INSERT_NULL_COLUMN(ConfigStore configs) {
        if (null != configs) {
            return configs.IS_INSERT_NULL_COLUMN();
        }
        return ConfigTable.IS_INSERT_NULL_COLUMN;
    }

    protected boolean IS_INSERT_EMPTY_COLUMN(ConfigStore configs) {
        if (null != configs) {
            return configs.IS_INSERT_EMPTY_COLUMN();
        }
        return ConfigTable.IS_INSERT_EMPTY_COLUMN;
    }

    protected boolean IS_LOG_SQL_WARN(ConfigStore configs) {
        if (null != configs) {
            return configs.IS_LOG_SQL_WARN();
        }
        return ConfigTable.IS_LOG_SQL_WARN;
    }

    protected boolean IS_REPLACE_EMPTY_NULL(ConfigStore configs) {
        if (null != configs) {
            return configs.IS_REPLACE_EMPTY_NULL();
        }
        return ConfigTable.IS_REPLACE_EMPTY_NULL;
    }

    protected boolean IS_KEYHOLDER_IDENTITY(ConfigStore configs) {
        if (null != configs) {
            return configs.IS_KEYHOLDER_IDENTITY();
        }
        return ConfigTable.IS_KEYHOLDER_IDENTITY;
    }
}

