/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.adapter;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.anyline.adapter.DataReader;
import org.anyline.adapter.DataWriter;
import org.anyline.data.adapter.DataReaderFactory;
import org.anyline.data.adapter.DataWriterFactory;
import org.anyline.data.adapter.SystemDataReaderFactory;
import org.anyline.data.adapter.SystemDataWriterFactory;
import org.anyline.data.param.ConfigStore;
import org.anyline.data.prepare.RunPrepare;
import org.anyline.data.run.Run;
import org.anyline.data.run.RunValue;
import org.anyline.data.runtime.DataRuntime;
import org.anyline.entity.Compare;
import org.anyline.entity.DataRow;
import org.anyline.entity.DataSet;
import org.anyline.entity.EntitySet;
import org.anyline.entity.PageNavi;
import org.anyline.metadata.ACTION;
import org.anyline.metadata.BaseMetadata;
import org.anyline.metadata.Catalog;
import org.anyline.metadata.Column;
import org.anyline.metadata.Constraint;
import org.anyline.metadata.Database;
import org.anyline.metadata.ForeignKey;
import org.anyline.metadata.Function;
import org.anyline.metadata.Index;
import org.anyline.metadata.MasterTable;
import org.anyline.metadata.Parameter;
import org.anyline.metadata.PartitionTable;
import org.anyline.metadata.PrimaryKey;
import org.anyline.metadata.Procedure;
import org.anyline.metadata.Schema;
import org.anyline.metadata.Table;
import org.anyline.metadata.Tag;
import org.anyline.metadata.Trigger;
import org.anyline.metadata.View;
import org.anyline.metadata.type.ColumnType;
import org.anyline.metadata.type.DatabaseType;
import org.anyline.util.BeanUtil;

public interface DriverAdapter {
    public static final String TAB = "\t";
    public static final String BR = "\n";
    public static final String BR_TAB = "\n\t";

    public DatabaseType type();

    public String version();

    public String getDelimiterFr();

    public String getDelimiterTo();

    public DatabaseType compatible();

    public ColumnType type(String var1);

    default public void reg(Object[] supports, DataWriter writer) {
        SystemDataWriterFactory.reg(this.type(), supports, writer);
    }

    default public void reg(DataWriter writer) {
        SystemDataWriterFactory.reg(this.type(), null, writer);
    }

    default public void reg(Object[] supports, DataReader reader) {
        SystemDataReaderFactory.reg(this.type(), supports, reader);
    }

    default public void reg(DataReader reader) {
        SystemDataReaderFactory.reg(this.type(), null, reader);
    }

    default public DataReader reader(Object type) {
        DataReader reader = DataReaderFactory.reader(this.type(), type);
        if (null == reader) {
            reader = SystemDataReaderFactory.reader(this.type(), type);
        }
        if (null == reader) {
            reader = DataReaderFactory.reader(DatabaseType.NONE, type);
        }
        if (null == reader) {
            reader = SystemDataReaderFactory.reader(DatabaseType.NONE, type);
        }
        return reader;
    }

    default public DataWriter writer(Object type) {
        DataWriter writer = DataWriterFactory.writer(this.type(), type);
        if (null == writer) {
            writer = SystemDataWriterFactory.writer(this.type(), type);
        }
        if (null == writer) {
            writer = DataWriterFactory.writer(DatabaseType.NONE, type);
        }
        if (null == writer) {
            writer = SystemDataWriterFactory.writer(DatabaseType.NONE, type);
        }
        return writer;
    }

    public long insert(DataRuntime var1, String var2, int var3, String var4, Object var5, ConfigStore var6, List<String> var7);

    default public long insert(DataRuntime runtime, String random, int batch, String dest, Object data, List<String> columns) {
        return this.insert(runtime, random, batch, dest, data, null, columns);
    }

    default public long insert(DataRuntime runtime, String random, int batch, String dest, Object data, String ... columns) {
        return this.insert(runtime, random, batch, dest, data, BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    default public long insert(DataRuntime runtime, String random, int batch, Object data, String ... columns) {
        return this.insert(runtime, random, batch, null, data, BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    default public long insert(DataRuntime runtime, String random, String dest, Object data, List<String> columns) {
        return this.insert(runtime, random, 0, dest, data, columns);
    }

    default public long insert(DataRuntime runtime, String random, String dest, Object data, String ... columns) {
        return this.insert(runtime, random, dest, data, BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    default public long insert(DataRuntime runtime, String random, Object data, String ... columns) {
        return this.insert(runtime, random, null, data, BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    public Run buildInsertRun(DataRuntime var1, int var2, String var3, Object var4, ConfigStore var5, List<String> var6);

    default public Run buildInsertRun(DataRuntime runtime, int batch, String dest, Object obj, List<String> columns) {
        return this.buildInsertRun(runtime, batch, dest, obj, null, columns);
    }

    default public Run buildInsertRun(DataRuntime runtime, int batch, String dest, Object obj, String ... columns) {
        return this.buildInsertRun(runtime, batch, dest, obj, BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    default public Run buildInsertRun(DataRuntime runtime, int batch, String dest, Object obj, ConfigStore confgis, String ... columns) {
        return this.buildInsertRun(runtime, batch, dest, obj, confgis, BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    default public Run buildInsertRun(DataRuntime runtime, int batch, Object obj, String ... columns) {
        return this.buildInsertRun(runtime, batch, null, obj, BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    default public Run buildInsertRun(DataRuntime runtime, int batch, Object obj, ConfigStore configs, String ... columns) {
        return this.buildInsertRun(runtime, batch, null, obj, configs, BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    default public Run buildInsertRun(DataRuntime runtime, int batch, ConfigStore configs, Object obj, String ... columns) {
        return this.buildInsertRun(runtime, batch, null, obj, configs, BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    public void fillInsertContent(DataRuntime var1, Run var2, String var3, Collection var4, ConfigStore var5, LinkedHashMap<String, Column> var6);

    default public void fillInsertContent(DataRuntime runtime, Run run, String dest, Collection list, LinkedHashMap<String, Column> columns) {
        this.fillInsertContent(runtime, run, dest, list, null, columns);
    }

    public void fillInsertContent(DataRuntime var1, Run var2, String var3, DataSet var4, ConfigStore var5, LinkedHashMap<String, Column> var6);

    default public void fillInsertContent(DataRuntime runtime, Run run, String dest, DataSet set, LinkedHashMap<String, Column> columns) {
        this.fillInsertContent(runtime, run, dest, set, null, columns);
    }

    public LinkedHashMap<String, Column> confirmInsertColumns(DataRuntime var1, String var2, Object var3, ConfigStore var4, List<String> var5, boolean var6);

    public String batchInsertSeparator();

    public boolean supportInsertPlaceholder();

    public String generatedKey();

    public long insert(DataRuntime var1, String var2, Object var3, ConfigStore var4, Run var5, String[] var6);

    public long insert(DataRuntime var1, String var2, Object var3, ConfigStore var4, Run var5, String[] var6, boolean var7);

    public long update(DataRuntime var1, String var2, int var3, String var4, Object var5, ConfigStore var6, List<String> var7);

    default public long update(DataRuntime runtime, String random, int batch, Object data, ConfigStore configs, List<String> columns) {
        return this.update(runtime, random, batch, null, data, configs, columns);
    }

    default public long update(DataRuntime runtime, String random, int batch, String dest, Object data, List<String> columns) {
        return this.update(runtime, random, batch, dest, data, null, columns);
    }

    default public long update(DataRuntime runtime, String random, int batch, Object data, List<String> columns) {
        return this.update(runtime, random, batch, null, data, null, columns);
    }

    default public long update(DataRuntime runtime, String random, int batch, Object data, ConfigStore configs) {
        return this.update(runtime, random, batch, null, data, configs, new String[0]);
    }

    default public long update(DataRuntime runtime, String random, int batch, String dest, Object data, ConfigStore configs, String ... columns) {
        return this.update(runtime, random, batch, dest, data, configs, BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    default public long update(DataRuntime runtime, String random, int batch, Object data, ConfigStore configs, String ... columns) {
        return this.update(runtime, random, batch, null, data, configs, BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    default public long update(DataRuntime runtime, String random, int batch, String dest, Object data, String ... columns) {
        return this.update(runtime, random, batch, dest, data, BeanUtil.array2string((Object[])columns));
    }

    default public long update(DataRuntime runtime, String random, int batch, Object data, String ... columns) {
        return this.update(runtime, random, batch, null, data, BeanUtil.array2string((Object[])columns));
    }

    default public long update(DataRuntime runtime, String random, String dest, Object data, ConfigStore configs, List<String> columns) {
        return this.update(runtime, random, 0, dest, data, configs, columns);
    }

    default public long update(DataRuntime runtime, String random, Object data, ConfigStore configs, List<String> columns) {
        return this.update(runtime, random, 0, null, data, configs, columns);
    }

    default public long update(DataRuntime runtime, String random, String dest, Object data, List<String> columns) {
        return this.update(runtime, random, 0, dest, data, null, columns);
    }

    default public long update(DataRuntime runtime, String random, Object data, List<String> columns) {
        return this.update(runtime, random, 0, null, data, null, columns);
    }

    default public long update(DataRuntime runtime, String random, Object data, ConfigStore configs) {
        return this.update(runtime, random, 0, null, data, configs, new String[0]);
    }

    default public long update(DataRuntime runtime, String random, String dest, Object data, ConfigStore configs, String ... columns) {
        return this.update(runtime, random, 0, dest, data, configs, BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    default public long update(DataRuntime runtime, String random, Object data, ConfigStore configs, String ... columns) {
        return this.update(runtime, random, 0, null, data, configs, BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    default public long update(DataRuntime runtime, String random, String dest, Object data, String ... columns) {
        return this.update(runtime, random, 0, dest, data, BeanUtil.array2string((Object[])columns));
    }

    default public long update(DataRuntime runtime, String random, Object data, String ... columns) {
        return this.update(runtime, random, 0, null, data, BeanUtil.array2string((Object[])columns));
    }

    public Run buildUpdateRun(DataRuntime var1, int var2, String var3, Object var4, ConfigStore var5, List<String> var6);

    default public Run buildUpdateRun(DataRuntime runtime, String dest, Object obj, ConfigStore configs, List<String> columns) {
        return this.buildUpdateRun(runtime, 0, dest, obj, configs, columns);
    }

    default public Run buildUpdateRun(DataRuntime runtime, Object obj, ConfigStore configs, List<String> columns) {
        return this.buildUpdateRun(runtime, null, obj, configs, columns);
    }

    default public Run buildUpdateRun(DataRuntime runtime, String dest, Object obj, List<String> columns) {
        return this.buildUpdateRun(runtime, dest, obj, null, columns);
    }

    default public Run buildUpdateRun(DataRuntime runtime, Object obj, List<String> columns) {
        return this.buildUpdateRun(runtime, null, obj, null, columns);
    }

    default public Run buildUpdateRun(DataRuntime runtime, String dest, Object obj, ConfigStore configs, String ... columns) {
        return this.buildUpdateRun(runtime, dest, obj, configs, BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    default public Run buildUpdateRun(DataRuntime runtime, Object obj, ConfigStore configs, String ... columns) {
        return this.buildUpdateRun(runtime, null, obj, configs, BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    default public Run buildUpdateRun(DataRuntime runtime, String dest, Object obj, String ... columns) {
        return this.buildUpdateRun(runtime, dest, obj, null, BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    default public Run buildUpdateRun(DataRuntime runtime, Object obj, String ... columns) {
        return this.buildUpdateRun(runtime, null, obj, null, BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    public Run buildUpdateRunFromEntity(DataRuntime var1, String var2, Object var3, ConfigStore var4, LinkedHashMap<String, Column> var5);

    public Run buildUpdateRunFromDataRow(DataRuntime var1, String var2, DataRow var3, ConfigStore var4, LinkedHashMap<String, Column> var5);

    public Run buildUpdateRunFromCollection(DataRuntime var1, int var2, String var3, Collection var4, ConfigStore var5, LinkedHashMap<String, Column> var6);

    public LinkedHashMap<String, Column> confirmUpdateColumns(DataRuntime var1, String var2, DataRow var3, ConfigStore var4, List<String> var5);

    public LinkedHashMap<String, Column> confirmUpdateColumns(DataRuntime var1, String var2, Object var3, ConfigStore var4, List<String> var5);

    public long update(DataRuntime var1, String var2, String var3, Object var4, ConfigStore var5, Run var6);

    public long save(DataRuntime var1, String var2, String var3, Object var4, ConfigStore var5, List<String> var6);

    default public long save(DataRuntime runtime, String random, String dest, Object data, List<String> columns) {
        return this.save(runtime, random, dest, data, null, columns);
    }

    default public long save(DataRuntime runtime, String random, Object data, List<String> columns) {
        return this.save(runtime, random, null, data, columns);
    }

    default public long save(DataRuntime runtime, String random, String dest, Object data, String ... columns) {
        return this.save(runtime, random, dest, data, BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    default public long save(DataRuntime runtime, String random, Object data, String ... columns) {
        return this.save(runtime, random, null, data, BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    public DataSet querys(DataRuntime var1, String var2, RunPrepare var3, ConfigStore var4, String ... var5);

    public DataSet querys(DataRuntime var1, String var2, Procedure var3, PageNavi var4);

    public <T> EntitySet<T> selects(DataRuntime var1, String var2, RunPrepare var3, Class<T> var4, ConfigStore var5, String ... var6);

    public List<Map<String, Object>> maps(DataRuntime var1, String var2, RunPrepare var3, ConfigStore var4, String ... var5);

    public Run buildQueryRun(DataRuntime var1, RunPrepare var2, ConfigStore var3, String ... var4);

    public List<Run> buildQuerySequence(DataRuntime var1, boolean var2, String ... var3);

    public void fillQueryContent(DataRuntime var1, Run var2);

    public String mergeFinalQuery(DataRuntime var1, Run var2);

    public RunValue createConditionLike(DataRuntime var1, StringBuilder var2, Compare var3, Object var4);

    public Object createConditionFindInSet(DataRuntime var1, StringBuilder var2, String var3, Compare var4, Object var5);

    public StringBuilder createConditionIn(DataRuntime var1, StringBuilder var2, Compare var3, Object var4);

    public DataSet select(DataRuntime var1, String var2, boolean var3, String var4, ConfigStore var5, Run var6);

    public List<Map<String, Object>> maps(DataRuntime var1, String var2, ConfigStore var3, Run var4);

    public Map<String, Object> map(DataRuntime var1, String var2, ConfigStore var3, Run var4);

    public DataRow sequence(DataRuntime var1, String var2, boolean var3, String ... var4);

    public List<Map<String, Object>> process(DataRuntime var1, List<Map<String, Object>> var2);

    public long count(DataRuntime var1, String var2, RunPrepare var3, ConfigStore var4, String ... var5);

    public long count(DataRuntime var1, String var2, Run var3);

    public String mergeFinalTotal(DataRuntime var1, Run var2);

    public boolean exists(DataRuntime var1, String var2, RunPrepare var3, ConfigStore var4, String ... var5);

    public String mergeFinalExists(DataRuntime var1, Run var2);

    public long execute(DataRuntime var1, String var2, RunPrepare var3, ConfigStore var4, String ... var5);

    public long execute(DataRuntime var1, String var2, int var3, ConfigStore var4, String var5, List<Object> var6);

    public boolean execute(DataRuntime var1, String var2, Procedure var3);

    public Run buildExecuteRun(DataRuntime var1, RunPrepare var2, ConfigStore var3, String ... var4);

    public void fillExecuteContent(DataRuntime var1, Run var2);

    public long execute(DataRuntime var1, String var2, ConfigStore var3, Run var4);

    public <T> long deletes(DataRuntime var1, String var2, int var3, String var4, ConfigStore var5, String var6, Collection<T> var7);

    default public <T> long deletes(DataRuntime runtime, String random, int batch, String table, String column, Collection<T> values) {
        return this.deletes(runtime, random, batch, table, (ConfigStore)null, column, values);
    }

    default public <T> long deletes(DataRuntime runtime, String random, String table, String column, Collection<T> values) {
        return this.deletes(runtime, random, 0, table, column, values);
    }

    default public <T> long deletes(DataRuntime runtime, String random, String table, ConfigStore configs, String column, Collection<T> values) {
        return this.deletes(runtime, random, 0, table, configs, column, values);
    }

    default public <T> long deletes(DataRuntime runtime, String random, int batch, String table, String column, T ... values) {
        return this.deletes(runtime, random, batch, table, column, (Collection<T>)BeanUtil.array2list((Object[][])new Object[][]{values}));
    }

    default public <T> long deletes(DataRuntime runtime, String random, int batch, String table, ConfigStore configs, String column, T ... values) {
        return this.deletes(runtime, random, batch, table, configs, column, BeanUtil.array2list((Object[][])new Object[][]{values}));
    }

    default public <T> long deletes(DataRuntime runtime, String random, String table, ConfigStore configs, String column, T ... values) {
        return this.deletes(runtime, random, 0, table, configs, column, BeanUtil.array2list((Object[][])new Object[][]{values}));
    }

    default public <T> long deletes(DataRuntime runtime, String random, String table, String column, T ... values) {
        return this.deletes(runtime, random, 0, table, column, (Collection<T>)BeanUtil.array2list((Object[][])new Object[][]{values}));
    }

    public long delete(DataRuntime var1, String var2, String var3, ConfigStore var4, Object var5, String ... var6);

    public long delete(DataRuntime var1, String var2, String var3, ConfigStore var4, String ... var5);

    public long truncate(DataRuntime var1, String var2, String var3);

    public Run buildDeleteRun(DataRuntime var1, String var2, Object var3, String ... var4);

    public Run buildDeleteRun(DataRuntime var1, int var2, String var3, String var4, Object var5);

    public List<Run> buildTruncateRun(DataRuntime var1, String var2);

    public Run buildDeleteRunFromTable(DataRuntime var1, int var2, String var3, String var4, Object var5);

    public Run buildDeleteRunFromEntity(DataRuntime var1, String var2, Object var3, String ... var4);

    public void fillDeleteRunContent(DataRuntime var1, Run var2);

    public long delete(DataRuntime var1, String var2, ConfigStore var3, Run var4);

    public <T extends BaseMetadata> void checkSchema(DataRuntime var1, DataSource var2, T var3);

    public <T extends BaseMetadata> void checkSchema(DataRuntime var1, Connection var2, T var3);

    public <T extends BaseMetadata> void checkSchema(DataRuntime var1, T var2);

    public LinkedHashMap<String, Column> metadata(DataRuntime var1, RunPrepare var2, boolean var3);

    public LinkedHashMap<String, Database> databases(DataRuntime var1, String var2, String var3);

    public List<Database> databases(DataRuntime var1, String var2, boolean var3, String var4);

    default public Database database(DataRuntime runtime, String random, String name) {
        List<Database> databases = this.databases(runtime, random, false, name);
        if (!databases.isEmpty()) {
            return databases.get(0);
        }
        return null;
    }

    public List<Run> buildQueryDatabaseRun(DataRuntime var1, boolean var2, String var3) throws Exception;

    default public List<Run> buildQueryDatabaseRun(DataRuntime runtime, boolean greedy) throws Exception {
        return this.buildQueryDatabaseRun(runtime, false, null);
    }

    default public List<Run> buildQueryDatabaseRun(DataRuntime runtime, String name) throws Exception {
        return this.buildQueryDatabaseRun(runtime, false, name);
    }

    default public List<Run> buildQueryDatabaseRun(DataRuntime runtime) throws Exception {
        return this.buildQueryDatabaseRun(runtime, false, null);
    }

    public LinkedHashMap<String, Database> databases(DataRuntime var1, int var2, boolean var3, LinkedHashMap<String, Database> var4, DataSet var5) throws Exception;

    public List<Database> databases(DataRuntime var1, int var2, boolean var3, List<Database> var4, DataSet var5) throws Exception;

    public Database database(DataRuntime var1, int var2, boolean var3, DataSet var4) throws Exception;

    public LinkedHashMap<String, Catalog> catalogs(DataRuntime var1, String var2, String var3);

    public List<Catalog> catalogs(DataRuntime var1, String var2, boolean var3, String var4);

    default public Catalog catalog(DataRuntime runtime, String random, String name) {
        List<Catalog> catalogs = this.catalogs(runtime, random, false, name);
        if (!catalogs.isEmpty()) {
            return catalogs.get(0);
        }
        return null;
    }

    public List<Run> buildQueryCatalogRun(DataRuntime var1, boolean var2, String var3) throws Exception;

    default public List<Run> buildQueryCatalogRun(DataRuntime runtime) throws Exception {
        return this.buildQueryCatalogRun(runtime, false, null);
    }

    public LinkedHashMap<String, Catalog> catalogs(DataRuntime var1, int var2, boolean var3, LinkedHashMap<String, Catalog> var4, DataSet var5) throws Exception;

    public List<Catalog> catalogs(DataRuntime var1, int var2, boolean var3, List<Catalog> var4, DataSet var5) throws Exception;

    public LinkedHashMap<String, Catalog> catalogs(DataRuntime var1, boolean var2, LinkedHashMap<String, Catalog> var3) throws Exception;

    public List<Catalog> catalogs(DataRuntime var1, boolean var2, List<Catalog> var3) throws Exception;

    public Catalog catalog(DataRuntime var1, int var2, boolean var3, DataSet var4) throws Exception;

    public LinkedHashMap<String, Schema> schemas(DataRuntime var1, String var2, Catalog var3, String var4);

    default public LinkedHashMap<String, Schema> schemas(DataRuntime runtime, String random, String name) {
        return this.schemas(runtime, random, null, name);
    }

    public List<Schema> schemas(DataRuntime var1, String var2, boolean var3, Catalog var4, String var5);

    default public List<Schema> schemas(DataRuntime runtime, String random, boolean greedy, String name) {
        return this.schemas(runtime, random, greedy, null, name);
    }

    default public Schema schema(DataRuntime runtime, String random, Catalog catalog, String name) {
        List<Schema> schemas = this.schemas(runtime, random, false, catalog, name);
        if (!schemas.isEmpty()) {
            return schemas.get(0);
        }
        return null;
    }

    public List<Run> buildQuerySchemaRun(DataRuntime var1, boolean var2, Catalog var3, String var4) throws Exception;

    default public List<Run> buildQuerySchemaRun(DataRuntime runtime, String name) throws Exception {
        return this.buildQuerySchemaRun(runtime, false, null, name);
    }

    default public List<Run> buildQuerySchemaRun(DataRuntime runtime, Catalog catalog) throws Exception {
        return this.buildQuerySchemaRun(runtime, false, catalog, null);
    }

    public LinkedHashMap<String, Schema> schemas(DataRuntime var1, int var2, boolean var3, LinkedHashMap<String, Schema> var4, DataSet var5) throws Exception;

    public List<Schema> schemas(DataRuntime var1, int var2, boolean var3, List<Schema> var4, DataSet var5) throws Exception;

    public LinkedHashMap<String, Schema> schemas(DataRuntime var1, boolean var2, LinkedHashMap<String, Schema> var3) throws Exception;

    public List<Schema> schemas(DataRuntime var1, boolean var2, List<Schema> var3) throws Exception;

    public Schema schema(DataRuntime var1, int var2, boolean var3, DataSet var4) throws Exception;

    public <T extends Table> List<T> tables(DataRuntime var1, String var2, boolean var3, Catalog var4, Schema var5, String var6, String var7, boolean var8);

    default public <T extends Table> List<T> tables(DataRuntime runtime, String random, boolean greedy, Catalog catalog, Schema schema, String pattern, String types) {
        return this.tables(runtime, random, greedy, catalog, schema, pattern, types, false);
    }

    public <T extends Table> LinkedHashMap<String, T> tables(DataRuntime var1, String var2, Catalog var3, Schema var4, String var5, String var6, boolean var7);

    default public <T extends Table> LinkedHashMap<String, T> tables(DataRuntime runtime, String random, Catalog catalog, Schema schema, String pattern, String types) {
        return this.tables(runtime, random, catalog, schema, pattern, types, false);
    }

    public List<Run> buildQueryTableRun(DataRuntime var1, boolean var2, Catalog var3, Schema var4, String var5, String var6) throws Exception;

    public List<Run> buildQueryTableCommentRun(DataRuntime var1, Catalog var2, Schema var3, String var4, String var5) throws Exception;

    public <T extends Table> LinkedHashMap<String, T> tables(DataRuntime var1, int var2, boolean var3, Catalog var4, Schema var5, LinkedHashMap<String, T> var6, DataSet var7) throws Exception;

    public <T extends Table> List<T> tables(DataRuntime var1, int var2, boolean var3, Catalog var4, Schema var5, List<T> var6, DataSet var7) throws Exception;

    public <T extends Table> LinkedHashMap<String, T> tables(DataRuntime var1, boolean var2, LinkedHashMap<String, T> var3, Catalog var4, Schema var5, String var6, String ... var7) throws Exception;

    public <T extends Table> List<T> tables(DataRuntime var1, boolean var2, List<T> var3, Catalog var4, Schema var5, String var6, String ... var7) throws Exception;

    public <T extends Table> LinkedHashMap<String, T> comments(DataRuntime var1, int var2, boolean var3, Catalog var4, Schema var5, LinkedHashMap<String, T> var6, DataSet var7) throws Exception;

    public List<String> ddl(DataRuntime var1, String var2, Table var3, boolean var4);

    public List<Run> buildQueryDDLRun(DataRuntime var1, Table var2) throws Exception;

    public List<String> ddl(DataRuntime var1, int var2, Table var3, List<String> var4, DataSet var5);

    public <T extends View> LinkedHashMap<String, T> views(DataRuntime var1, String var2, boolean var3, Catalog var4, Schema var5, String var6, String var7);

    public List<Run> buildQueryViewRun(DataRuntime var1, boolean var2, Catalog var3, Schema var4, String var5, String var6) throws Exception;

    public <T extends View> LinkedHashMap<String, T> views(DataRuntime var1, int var2, boolean var3, Catalog var4, Schema var5, LinkedHashMap<String, T> var6, DataSet var7) throws Exception;

    public <T extends View> LinkedHashMap<String, T> views(DataRuntime var1, boolean var2, LinkedHashMap<String, T> var3, Catalog var4, Schema var5, String var6, String ... var7) throws Exception;

    public List<String> ddl(DataRuntime var1, String var2, View var3);

    public List<Run> buildQueryDDLRun(DataRuntime var1, View var2) throws Exception;

    public List<String> ddl(DataRuntime var1, int var2, View var3, List<String> var4, DataSet var5);

    public <T extends MasterTable> LinkedHashMap<String, T> mtables(DataRuntime var1, String var2, boolean var3, Catalog var4, Schema var5, String var6, String var7);

    public List<Run> buildQueryMasterTableRun(DataRuntime var1, Catalog var2, Schema var3, String var4, String var5) throws Exception;

    public <T extends MasterTable> LinkedHashMap<String, T> mtables(DataRuntime var1, int var2, boolean var3, Catalog var4, Schema var5, LinkedHashMap<String, T> var6, DataSet var7) throws Exception;

    public <T extends MasterTable> LinkedHashMap<String, T> mtables(DataRuntime var1, boolean var2, LinkedHashMap<String, T> var3, Catalog var4, Schema var5, String var6, String ... var7) throws Exception;

    public List<String> ddl(DataRuntime var1, String var2, MasterTable var3);

    public List<Run> buildQueryDDLRun(DataRuntime var1, MasterTable var2) throws Exception;

    public List<String> ddl(DataRuntime var1, int var2, MasterTable var3, List<String> var4, DataSet var5);

    public <T extends PartitionTable> LinkedHashMap<String, T> ptables(DataRuntime var1, String var2, boolean var3, MasterTable var4, Map<String, Object> var5, String var6);

    public List<Run> buildQueryPartitionTableRun(DataRuntime var1, Catalog var2, Schema var3, String var4, String var5) throws Exception;

    public List<Run> buildQueryPartitionTableRun(DataRuntime var1, MasterTable var2, Map<String, Object> var3, String var4) throws Exception;

    public List<Run> buildQueryPartitionTableRun(DataRuntime var1, MasterTable var2, Map<String, Object> var3) throws Exception;

    public <T extends PartitionTable> LinkedHashMap<String, T> ptables(DataRuntime var1, int var2, int var3, boolean var4, MasterTable var5, Catalog var6, Schema var7, LinkedHashMap<String, T> var8, DataSet var9) throws Exception;

    public <T extends PartitionTable> LinkedHashMap<String, T> ptables(DataRuntime var1, boolean var2, LinkedHashMap<String, T> var3, Catalog var4, Schema var5, MasterTable var6) throws Exception;

    public List<String> ddl(DataRuntime var1, String var2, PartitionTable var3);

    public List<Run> buildQueryDDLRun(DataRuntime var1, PartitionTable var2) throws Exception;

    public List<String> ddl(DataRuntime var1, int var2, PartitionTable var3, List<String> var4, DataSet var5);

    public <T extends Column> LinkedHashMap<String, T> columns(DataRuntime var1, String var2, boolean var3, Table var4, boolean var5);

    public <T extends Column> List<T> columns(DataRuntime var1, String var2, boolean var3, Catalog var4, Schema var5, String var6);

    default public <T extends Column> List<T> columns(DataRuntime runtime, String random, boolean greedy, Catalog catalog, Schema schema) {
        return this.columns(runtime, random, greedy, catalog, schema, null);
    }

    public <T extends Column> LinkedHashMap<String, T> columns(DataRuntime var1, boolean var2, LinkedHashMap<String, T> var3, Table var4, String var5) throws Exception;

    public List<Run> buildQueryColumnRun(DataRuntime var1, Table var2, boolean var3) throws Exception;

    public <T extends Column> LinkedHashMap<String, T> columns(DataRuntime var1, int var2, boolean var3, Table var4, LinkedHashMap<String, T> var5, DataSet var6) throws Exception;

    public <T extends Column> List<T> columns(DataRuntime var1, int var2, boolean var3, Table var4, List<T> var5, DataSet var6) throws Exception;

    public <T extends Tag> LinkedHashMap<String, T> tags(DataRuntime var1, String var2, boolean var3, Table var4);

    public List<Run> buildQueryTagRun(DataRuntime var1, Table var2, boolean var3) throws Exception;

    public <T extends Tag> LinkedHashMap<String, T> tags(DataRuntime var1, int var2, boolean var3, Table var4, LinkedHashMap<String, T> var5, DataSet var6) throws Exception;

    public <T extends Tag> LinkedHashMap<String, T> tags(DataRuntime var1, boolean var2, LinkedHashMap<String, T> var3, Table var4, String var5) throws Exception;

    public PrimaryKey primary(DataRuntime var1, String var2, boolean var3, Table var4);

    public List<Run> buildQueryPrimaryRun(DataRuntime var1, Table var2) throws Exception;

    public PrimaryKey primary(DataRuntime var1, int var2, Table var3, DataSet var4) throws Exception;

    public PrimaryKey primary(DataRuntime var1, Table var2) throws Exception;

    public <T extends ForeignKey> LinkedHashMap<String, T> foreigns(DataRuntime var1, String var2, boolean var3, Table var4);

    public List<Run> buildQueryForeignRun(DataRuntime var1, Table var2) throws Exception;

    public <T extends ForeignKey> LinkedHashMap<String, T> foreigns(DataRuntime var1, int var2, Table var3, LinkedHashMap<String, T> var4, DataSet var5) throws Exception;

    public <T extends Index> List<T> indexs(DataRuntime var1, String var2, boolean var3, Table var4, String var5);

    public <T extends Index> LinkedHashMap<String, T> indexs(DataRuntime var1, String var2, Table var3, String var4);

    public List<Run> buildQueryIndexRun(DataRuntime var1, Table var2, String var3);

    public <T extends Index> LinkedHashMap<String, T> indexs(DataRuntime var1, int var2, boolean var3, Table var4, LinkedHashMap<String, T> var5, DataSet var6) throws Exception;

    public <T extends Index> List<T> indexs(DataRuntime var1, int var2, boolean var3, Table var4, List<T> var5, DataSet var6) throws Exception;

    public <T extends Index> List<T> indexs(DataRuntime var1, boolean var2, List<T> var3, Table var4, boolean var5, boolean var6) throws Exception;

    public <T extends Index> LinkedHashMap<String, T> indexs(DataRuntime var1, boolean var2, LinkedHashMap<String, T> var3, Table var4, boolean var5, boolean var6) throws Exception;

    public <T extends Constraint> List<T> constraints(DataRuntime var1, String var2, boolean var3, Table var4, String var5);

    public <T extends Constraint> LinkedHashMap<String, T> constraints(DataRuntime var1, String var2, Table var3, Column var4, String var5);

    public List<Run> buildQueryConstraintRun(DataRuntime var1, Table var2, Column var3, String var4);

    public <T extends Constraint> List<T> constraints(DataRuntime var1, int var2, boolean var3, Table var4, List<T> var5, DataSet var6) throws Exception;

    public <T extends Constraint> LinkedHashMap<String, T> constraints(DataRuntime var1, int var2, boolean var3, Table var4, Column var5, LinkedHashMap<String, T> var6, DataSet var7) throws Exception;

    public <T extends Trigger> LinkedHashMap<String, T> triggers(DataRuntime var1, String var2, boolean var3, Table var4, List<Trigger.EVENT> var5);

    public List<Run> buildQueryTriggerRun(DataRuntime var1, Table var2, List<Trigger.EVENT> var3);

    public <T extends Trigger> LinkedHashMap<String, T> triggers(DataRuntime var1, int var2, boolean var3, Table var4, LinkedHashMap<String, T> var5, DataSet var6) throws Exception;

    public <T extends Procedure> List<T> procedures(DataRuntime var1, String var2, boolean var3, Catalog var4, Schema var5, String var6);

    public <T extends Procedure> LinkedHashMap<String, T> procedures(DataRuntime var1, String var2, Catalog var3, Schema var4, String var5);

    public List<Run> buildQueryProcedureRun(DataRuntime var1, Catalog var2, Schema var3, String var4);

    public <T extends Procedure> List<T> procedures(DataRuntime var1, int var2, boolean var3, List<T> var4, DataSet var5) throws Exception;

    public <T extends Procedure> LinkedHashMap<String, T> procedures(DataRuntime var1, int var2, boolean var3, LinkedHashMap<String, T> var4, DataSet var5) throws Exception;

    public <T extends Procedure> List<T> procedures(DataRuntime var1, boolean var2, List<T> var3) throws Exception;

    public <T extends Procedure> LinkedHashMap<String, T> procedures(DataRuntime var1, boolean var2, LinkedHashMap<String, T> var3) throws Exception;

    public List<String> ddl(DataRuntime var1, String var2, Procedure var3);

    public List<Run> buildQueryDDLRun(DataRuntime var1, Procedure var2) throws Exception;

    public List<String> ddl(DataRuntime var1, int var2, Procedure var3, List<String> var4, DataSet var5);

    public <T extends Function> List<T> functions(DataRuntime var1, String var2, boolean var3, Catalog var4, Schema var5, String var6);

    public <T extends Function> LinkedHashMap<String, T> functions(DataRuntime var1, String var2, Catalog var3, Schema var4, String var5);

    public List<Run> buildQueryFunctionRun(DataRuntime var1, Catalog var2, Schema var3, String var4);

    public <T extends Function> List<T> functions(DataRuntime var1, int var2, boolean var3, List<T> var4, DataSet var5) throws Exception;

    public <T extends Function> LinkedHashMap<String, T> functions(DataRuntime var1, int var2, boolean var3, LinkedHashMap<String, T> var4, DataSet var5) throws Exception;

    public <T extends Function> List<T> functions(DataRuntime var1, boolean var2, List<T> var3) throws Exception;

    public <T extends Function> LinkedHashMap<String, T> functions(DataRuntime var1, boolean var2, LinkedHashMap<String, T> var3) throws Exception;

    public List<String> ddl(DataRuntime var1, String var2, Function var3);

    public List<Run> buildQueryDDLRun(DataRuntime var1, Function var2) throws Exception;

    public List<String> ddl(DataRuntime var1, int var2, Function var3, List<String> var4, DataSet var5);

    public boolean execute(DataRuntime var1, String var2, BaseMetadata var3, ACTION.DDL var4, Run var5);

    default public boolean execute(DataRuntime runtime, String random, BaseMetadata meta, ACTION.DDL action, List<Run> runs) {
        boolean result = true;
        int idx = 0;
        for (Run run : runs) {
            result = this.execute(runtime, random + "[index:" + idx++ + "]", meta, action, run) && result;
        }
        return result;
    }

    public boolean create(DataRuntime var1, Table var2) throws Exception;

    public boolean alter(DataRuntime var1, Table var2) throws Exception;

    public boolean drop(DataRuntime var1, Table var2) throws Exception;

    public boolean rename(DataRuntime var1, Table var2, String var3) throws Exception;

    default public String keyword(Table table) {
        return table.getKeyword();
    }

    public List<Run> buildCreateRun(DataRuntime var1, Table var2) throws Exception;

    public List<Run> buildAlterRun(DataRuntime var1, Table var2) throws Exception;

    public List<Run> buildAlterRun(DataRuntime var1, Table var2, Collection<Column> var3) throws Exception;

    public List<Run> buildRenameRun(DataRuntime var1, Table var2) throws Exception;

    public List<Run> buildDropRun(DataRuntime var1, Table var2) throws Exception;

    public List<Run> buildAppendCommentRun(DataRuntime var1, Table var2) throws Exception;

    public List<Run> buildChangeCommentRun(DataRuntime var1, Table var2) throws Exception;

    public StringBuilder checkTableExists(DataRuntime var1, StringBuilder var2, boolean var3);

    public StringBuilder primary(DataRuntime var1, StringBuilder var2, Table var3);

    public StringBuilder charset(DataRuntime var1, StringBuilder var2, Table var3);

    public StringBuilder comment(DataRuntime var1, StringBuilder var2, Table var3);

    public StringBuilder partitionBy(DataRuntime var1, StringBuilder var2, Table var3) throws Exception;

    public StringBuilder partitionOf(DataRuntime var1, StringBuilder var2, Table var3) throws Exception;

    public boolean create(DataRuntime var1, View var2) throws Exception;

    public boolean alter(DataRuntime var1, View var2) throws Exception;

    public boolean drop(DataRuntime var1, View var2) throws Exception;

    public boolean rename(DataRuntime var1, View var2, String var3) throws Exception;

    public List<Run> buildCreateRun(DataRuntime var1, View var2) throws Exception;

    public List<Run> buildAlterRun(DataRuntime var1, View var2) throws Exception;

    public List<Run> buildRenameRun(DataRuntime var1, View var2) throws Exception;

    public List<Run> buildDropRun(DataRuntime var1, View var2) throws Exception;

    public List<Run> buildAppendCommentRun(DataRuntime var1, View var2) throws Exception;

    public List<Run> buildChangeCommentRun(DataRuntime var1, View var2) throws Exception;

    public StringBuilder checkViewExists(DataRuntime var1, StringBuilder var2, boolean var3);

    public StringBuilder comment(DataRuntime var1, StringBuilder var2, View var3);

    public boolean create(DataRuntime var1, MasterTable var2) throws Exception;

    public boolean alter(DataRuntime var1, MasterTable var2) throws Exception;

    public boolean drop(DataRuntime var1, MasterTable var2) throws Exception;

    public boolean rename(DataRuntime var1, MasterTable var2, String var3) throws Exception;

    public List<Run> buildCreateRun(DataRuntime var1, MasterTable var2) throws Exception;

    public List<Run> buildDropRun(DataRuntime var1, MasterTable var2) throws Exception;

    public List<Run> buildAlterRun(DataRuntime var1, MasterTable var2) throws Exception;

    public List<Run> buildRenameRun(DataRuntime var1, MasterTable var2) throws Exception;

    public List<Run> buildAppendCommentRun(DataRuntime var1, MasterTable var2) throws Exception;

    public List<Run> buildChangeCommentRun(DataRuntime var1, MasterTable var2) throws Exception;

    public boolean create(DataRuntime var1, PartitionTable var2) throws Exception;

    public boolean alter(DataRuntime var1, PartitionTable var2) throws Exception;

    public boolean drop(DataRuntime var1, PartitionTable var2) throws Exception;

    public boolean rename(DataRuntime var1, PartitionTable var2, String var3) throws Exception;

    public List<Run> buildCreateRun(DataRuntime var1, PartitionTable var2) throws Exception;

    public List<Run> buildAppendCommentRun(DataRuntime var1, PartitionTable var2) throws Exception;

    public List<Run> buildAlterRun(DataRuntime var1, PartitionTable var2) throws Exception;

    public List<Run> buildDropRun(DataRuntime var1, PartitionTable var2) throws Exception;

    public List<Run> buildRenameRun(DataRuntime var1, PartitionTable var2) throws Exception;

    public List<Run> buildChangeCommentRun(DataRuntime var1, PartitionTable var2) throws Exception;

    public boolean add(DataRuntime var1, Column var2) throws Exception;

    public boolean alter(DataRuntime var1, Table var2, Column var3, boolean var4) throws Exception;

    default public boolean alter(DataRuntime runtime, Table table, Column meta) throws Exception {
        return this.alter(runtime, table, meta, true);
    }

    public boolean alter(DataRuntime var1, Column var2) throws Exception;

    public boolean drop(DataRuntime var1, Column var2) throws Exception;

    public boolean rename(DataRuntime var1, Column var2, String var3) throws Exception;

    public List<Run> buildAddRun(DataRuntime var1, Column var2, boolean var3) throws Exception;

    default public List<Run> buildAddRun(DataRuntime runtime, Column column) throws Exception {
        return this.buildAddRun(runtime, column, false);
    }

    public List<Run> buildAlterRun(DataRuntime var1, Column var2, boolean var3) throws Exception;

    default public List<Run> buildAlterRun(DataRuntime runtime, Column column) throws Exception {
        return this.buildAlterRun(runtime, column, false);
    }

    public List<Run> buildDropRun(DataRuntime var1, Column var2, boolean var3) throws Exception;

    default public List<Run> buildDropRun(DataRuntime runtime, Column column) throws Exception {
        return this.buildDropRun(runtime, column, false);
    }

    public List<Run> buildRenameRun(DataRuntime var1, Column var2) throws Exception;

    public List<Run> buildChangeTypeRun(DataRuntime var1, Column var2) throws Exception;

    public String alterColumnKeyword(DataRuntime var1);

    public StringBuilder addColumnGuide(DataRuntime var1, StringBuilder var2, Column var3);

    public StringBuilder dropColumnGuide(DataRuntime var1, StringBuilder var2, Column var3);

    public List<Run> buildChangeDefaultRun(DataRuntime var1, Column var2) throws Exception;

    public List<Run> buildChangeNullableRun(DataRuntime var1, Column var2) throws Exception;

    public List<Run> buildChangeCommentRun(DataRuntime var1, Column var2) throws Exception;

    public List<Run> buildAppendCommentRun(DataRuntime var1, Column var2) throws Exception;

    public List<Run> buildDropAutoIncrement(DataRuntime var1, Column var2) throws Exception;

    public StringBuilder define(DataRuntime var1, StringBuilder var2, Column var3);

    public StringBuilder checkColumnExists(DataRuntime var1, StringBuilder var2, boolean var3);

    public StringBuilder type(DataRuntime var1, StringBuilder var2, Column var3);

    public StringBuilder type(DataRuntime var1, StringBuilder var2, Column var3, String var4, boolean var5, boolean var6);

    public boolean isIgnorePrecision(DataRuntime var1, Column var2);

    public boolean isIgnoreScale(DataRuntime var1, Column var2);

    public Boolean checkIgnorePrecision(DataRuntime var1, String var2);

    public Boolean checkIgnoreScale(DataRuntime var1, String var2);

    public StringBuilder nullable(DataRuntime var1, StringBuilder var2, Column var3);

    public StringBuilder charset(DataRuntime var1, StringBuilder var2, Column var3);

    public StringBuilder defaultValue(DataRuntime var1, StringBuilder var2, Column var3);

    public StringBuilder primary(DataRuntime var1, StringBuilder var2, Column var3);

    public StringBuilder increment(DataRuntime var1, StringBuilder var2, Column var3);

    public StringBuilder onupdate(DataRuntime var1, StringBuilder var2, Column var3);

    public StringBuilder position(DataRuntime var1, StringBuilder var2, Column var3);

    public StringBuilder comment(DataRuntime var1, StringBuilder var2, Column var3);

    public boolean add(DataRuntime var1, Tag var2) throws Exception;

    public boolean alter(DataRuntime var1, Table var2, Tag var3, boolean var4) throws Exception;

    default public boolean alter(DataRuntime runtime, Table table, Tag meta) throws Exception {
        return this.alter(runtime, table, meta, true);
    }

    public boolean alter(DataRuntime var1, Tag var2) throws Exception;

    public boolean drop(DataRuntime var1, Tag var2) throws Exception;

    public boolean rename(DataRuntime var1, Tag var2, String var3) throws Exception;

    public List<Run> buildAddRun(DataRuntime var1, Tag var2) throws Exception;

    public List<Run> buildAlterRun(DataRuntime var1, Tag var2) throws Exception;

    public List<Run> buildDropRun(DataRuntime var1, Tag var2) throws Exception;

    public List<Run> buildRenameRun(DataRuntime var1, Tag var2) throws Exception;

    public List<Run> buildChangeDefaultRun(DataRuntime var1, Tag var2) throws Exception;

    public List<Run> buildChangeNullableRun(DataRuntime var1, Tag var2) throws Exception;

    public List<Run> buildChangeCommentRun(DataRuntime var1, Tag var2) throws Exception;

    public List<Run> buildChangeTypeRun(DataRuntime var1, Tag var2) throws Exception;

    public StringBuilder checkTagExists(DataRuntime var1, StringBuilder var2, boolean var3);

    default public SQL_BUILD_IN_VALUE checkDefaultBuildInValue(DataRuntime runtime, Object def) {
        String chk;
        SQL_BUILD_IN_VALUE result = null;
        if (null != def && ("CURRENT_TIMESTAMP".equals(chk = def.toString().toUpperCase().trim()) || "CURRENT TIMESTAMP".equals(chk) || "SYSDATE".equals(chk) || "NOW()".equals(chk) || "NOW".equals(chk) || "GETDATE()".equals(chk) || chk.contains("DATETIME("))) {
            result = SQL_BUILD_IN_VALUE.CURRENT_DATETIME;
        }
        return result;
    }

    public boolean add(DataRuntime var1, PrimaryKey var2) throws Exception;

    public boolean alter(DataRuntime var1, PrimaryKey var2) throws Exception;

    public boolean alter(DataRuntime var1, Table var2, PrimaryKey var3) throws Exception;

    public boolean drop(DataRuntime var1, PrimaryKey var2) throws Exception;

    public boolean rename(DataRuntime var1, PrimaryKey var2, String var3) throws Exception;

    public List<Run> buildAddRun(DataRuntime var1, PrimaryKey var2) throws Exception;

    default public List<Run> buildAddRunAfterTable(DataRuntime runtime, PrimaryKey primary) throws Exception {
        return new ArrayList<Run>();
    }

    public List<Run> buildAlterRun(DataRuntime var1, PrimaryKey var2) throws Exception;

    public List<Run> buildDropRun(DataRuntime var1, PrimaryKey var2) throws Exception;

    public List<Run> buildRenameRun(DataRuntime var1, PrimaryKey var2) throws Exception;

    public boolean add(DataRuntime var1, ForeignKey var2) throws Exception;

    public boolean alter(DataRuntime var1, ForeignKey var2) throws Exception;

    public boolean alter(DataRuntime var1, Table var2, ForeignKey var3) throws Exception;

    public boolean drop(DataRuntime var1, ForeignKey var2) throws Exception;

    public boolean rename(DataRuntime var1, ForeignKey var2, String var3) throws Exception;

    public List<Run> buildAddRun(DataRuntime var1, ForeignKey var2) throws Exception;

    public List<Run> buildAlterRun(DataRuntime var1, ForeignKey var2) throws Exception;

    public List<Run> buildDropRun(DataRuntime var1, ForeignKey var2) throws Exception;

    public List<Run> buildRenameRun(DataRuntime var1, ForeignKey var2) throws Exception;

    public boolean add(DataRuntime var1, Index var2) throws Exception;

    public boolean alter(DataRuntime var1, Index var2) throws Exception;

    public boolean alter(DataRuntime var1, Table var2, Index var3) throws Exception;

    public boolean drop(DataRuntime var1, Index var2) throws Exception;

    public boolean rename(DataRuntime var1, Index var2, String var3) throws Exception;

    public List<Run> buildAddRun(DataRuntime var1, Index var2) throws Exception;

    public List<Run> buildAlterRun(DataRuntime var1, Index var2) throws Exception;

    public List<Run> buildDropRun(DataRuntime var1, Index var2) throws Exception;

    public List<Run> buildRenameRun(DataRuntime var1, Index var2) throws Exception;

    public StringBuilder type(DataRuntime var1, StringBuilder var2, Index var3);

    public StringBuilder comment(DataRuntime var1, StringBuilder var2, Index var3);

    public boolean add(DataRuntime var1, Constraint var2) throws Exception;

    public boolean alter(DataRuntime var1, Constraint var2) throws Exception;

    public boolean alter(DataRuntime var1, Table var2, Constraint var3) throws Exception;

    public boolean drop(DataRuntime var1, Constraint var2) throws Exception;

    public boolean rename(DataRuntime var1, Constraint var2, String var3) throws Exception;

    public List<Run> buildAddRun(DataRuntime var1, Constraint var2) throws Exception;

    public List<Run> buildAlterRun(DataRuntime var1, Constraint var2) throws Exception;

    public List<Run> buildDropRun(DataRuntime var1, Constraint var2) throws Exception;

    public List<Run> buildRenameRun(DataRuntime var1, Constraint var2) throws Exception;

    public boolean add(DataRuntime var1, Trigger var2) throws Exception;

    public boolean alter(DataRuntime var1, Trigger var2) throws Exception;

    public boolean drop(DataRuntime var1, Trigger var2) throws Exception;

    public boolean rename(DataRuntime var1, Trigger var2, String var3) throws Exception;

    public List<Run> buildCreateRun(DataRuntime var1, Trigger var2) throws Exception;

    public List<Run> buildAlterRun(DataRuntime var1, Trigger var2) throws Exception;

    public List<Run> buildDropRun(DataRuntime var1, Trigger var2) throws Exception;

    public List<Run> buildRenameRun(DataRuntime var1, Trigger var2) throws Exception;

    public StringBuilder each(DataRuntime var1, StringBuilder var2, Trigger var3);

    public boolean create(DataRuntime var1, Procedure var2) throws Exception;

    public boolean alter(DataRuntime var1, Procedure var2) throws Exception;

    public boolean drop(DataRuntime var1, Procedure var2) throws Exception;

    public boolean rename(DataRuntime var1, Procedure var2, String var3) throws Exception;

    public List<Run> buildCreateRun(DataRuntime var1, Procedure var2) throws Exception;

    public List<Run> buildAlterRun(DataRuntime var1, Procedure var2) throws Exception;

    public List<Run> buildDropRun(DataRuntime var1, Procedure var2) throws Exception;

    public List<Run> buildRenameRun(DataRuntime var1, Procedure var2) throws Exception;

    public StringBuilder parameter(DataRuntime var1, StringBuilder var2, Parameter var3);

    public boolean create(DataRuntime var1, Function var2) throws Exception;

    public boolean alter(DataRuntime var1, Function var2) throws Exception;

    public boolean drop(DataRuntime var1, Function var2) throws Exception;

    public boolean rename(DataRuntime var1, Function var2, String var3) throws Exception;

    public List<Run> buildCreateRun(DataRuntime var1, Function var2) throws Exception;

    public List<Run> buildAlterRun(DataRuntime var1, Function var2) throws Exception;

    public List<Run> buildDropRun(DataRuntime var1, Function var2) throws Exception;

    public List<Run> buildRenameRun(DataRuntime var1, Function var2) throws Exception;

    public StringBuilder name(DataRuntime var1, StringBuilder var2, BaseMetadata var3);

    public String getPrimaryKey(DataRuntime var1, Object var2);

    public Object getPrimaryValue(DataRuntime var1, Object var2);

    public boolean convert(DataRuntime var1, Catalog var2, Schema var3, String var4, RunValue var5);

    public boolean convert(DataRuntime var1, Table var2, Run var3);

    public boolean convert(DataRuntime var1, ConfigStore var2, Run var3);

    public boolean convert(DataRuntime var1, Map<String, Column> var2, RunValue var3);

    public boolean convert(DataRuntime var1, Column var2, RunValue var3);

    public Object convert(DataRuntime var1, Column var2, Object var3);

    public Object convert(DataRuntime var1, ColumnType var2, Object var3);

    public void value(DataRuntime var1, StringBuilder var2, Object var3, String var4);

    public Object read(DataRuntime var1, Column var2, Object var3, Class var4);

    public Object write(DataRuntime var1, Column var2, Object var3, boolean var4);

    public String concat(DataRuntime var1, String ... var2);

    public boolean isNumberColumn(DataRuntime var1, Column var2);

    public boolean isBooleanColumn(DataRuntime var1, Column var2);

    public boolean isCharColumn(DataRuntime var1, Column var2);

    public String value(DataRuntime var1, Column var2, SQL_BUILD_IN_VALUE var3);

    default public String defaultValue(DataRuntime runtime, Column column, SQL_BUILD_IN_VALUE value) {
        return this.value(runtime, column, value);
    }

    public void addRunValue(DataRuntime var1, Run var2, Compare var3, Column var4, Object var5);

    public String objectName(DataRuntime var1, String var2);

    public static enum SQL_BUILD_IN_VALUE {
        CURRENT_DATETIME("CURRENT_DATETIME", "\u5f53\u524d\u65e5\u671f\u65f6\u95f4"),
        CURRENT_DATE("CURRENT_DATE", "\u5f53\u524d\u65e5\u671f"),
        CURRENT_TIME("CURRENT_TIME", "\u5f53\u524d\u65f6\u95f4"),
        CURRENT_TIMESTAMP("CURRENT_TIMESTAMP", "\u5f53\u524d\u65f6\u95f4\u6233");

        private final String code;
        private final String name;

        private SQL_BUILD_IN_VALUE(String code, String name) {
            this.code = code;
            this.name = name;
        }

        String getCode() {
            return this.code;
        }

        String getName() {
            return this.name;
        }
    }
}

