/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.util;

import java.util.Collection;
import org.anyline.data.param.ConfigStore;
import org.anyline.entity.DataRow;
import org.anyline.entity.DataSet;
import org.anyline.metadata.BaseMetadata;
import org.anyline.metadata.Table;
import org.anyline.proxy.EntityAdapterProxy;
import org.anyline.util.BasicUtil;

public class DataSourceUtil {
    public static String[] parseRuntime(BaseMetadata meta) {
        if (null != meta) {
            return DataSourceUtil.parseRuntime(meta.getName());
        }
        return new String[2];
    }

    public static String[] parseRuntime(String src) {
        String[] result = new String[2];
        result[1] = src;
        String runtime = null;
        if (null != src && src.startsWith("<")) {
            int fr = src.indexOf("<");
            int to = src.indexOf(">");
            if (fr != -1) {
                runtime = src.substring(fr + 1, to);
                src = src.substring(to + 1);
                result[0] = runtime;
                result[1] = src;
            }
        }
        return result;
    }

    public static Table parseDest(String src, ConfigStore configs) {
        int fr;
        if (null == src) {
            return null;
        }
        Table result = new Table();
        if (src.startsWith("<")) {
            fr = src.indexOf("<");
            int to = src.indexOf(">");
            if (fr != -1) {
                String datasource = src.substring(fr + 1, to);
                src = src.substring(to + 1);
                result.setDatasource(datasource);
            }
        }
        if (src.endsWith(">") && (fr = src.lastIndexOf("<")) != -1) {
            String[] keys = src.substring(fr + 1, src.length() - 1).split(",");
            src = src.substring(0, fr);
            result.setPrimaryKey(keys);
        }
        if (src.contains(" ")) {
            result.setText(src);
        } else if (src.contains(":")) {
            result.setId(src);
        }
        result.setName(src);
        return result;
    }

    public static Table parseDest(String dest, Object obj, ConfigStore configs) {
        Table table = null;
        if (BasicUtil.isNotEmpty((Object)dest) || null == obj) {
            return DataSourceUtil.parseDest(dest, configs);
        }
        if (obj instanceof DataRow) {
            DataRow row = (DataRow)obj;
            table = DataSourceUtil.parseDest(row.getDest(), configs);
        } else if (obj instanceof DataSet) {
            DataSet set = (DataSet)obj;
            if (set.size() > 0) {
                table = DataSourceUtil.parseDest(set.getRow(0).getDest(), configs);
            }
        } else if (obj instanceof Collection) {
            Collection col = (Collection)obj;
            if (!col.isEmpty()) {
                Object first = col.iterator().next();
                if (first instanceof DataRow) {
                    table = DataSourceUtil.parseDest(((DataRow)first).getDest(), configs);
                } else {
                    String tableName = EntityAdapterProxy.table(first.getClass(), (boolean)true);
                    table = DataSourceUtil.parseDest(tableName, configs);
                }
            }
        } else {
            table = EntityAdapterProxy.table(obj.getClass());
        }
        return table;
    }
}

