/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.run;

import java.util.List;
import org.anyline.data.adapter.DriverAdapter;
import org.anyline.data.param.ConfigStore;
import org.anyline.data.prepare.ConditionChain;
import org.anyline.data.prepare.auto.init.DefaultAutoConditionChain;
import org.anyline.data.run.BasicRun;
import org.anyline.data.run.Run;
import org.anyline.data.run.RunValue;
import org.anyline.data.runtime.DataRuntime;
import org.anyline.entity.Compare;
import org.anyline.entity.DefaultOrderStore;
import org.anyline.entity.Order;
import org.anyline.entity.OrderStore;
import org.anyline.entity.PageNavi;
import org.anyline.metadata.Table;
import org.anyline.util.BasicUtil;

public class TableRun
extends BasicRun
implements Run {
    public TableRun(DataRuntime runtime, String table) {
        this.builder = new StringBuilder();
        this.conditionChain = new DefaultAutoConditionChain();
        this.orderStore = new DefaultOrderStore();
        this.table = new Table(table);
        this.runtime = runtime;
    }

    public TableRun(DataRuntime runtime, Table table) {
        this.builder = new StringBuilder();
        this.conditionChain = new DefaultAutoConditionChain();
        this.orderStore = new DefaultOrderStore();
        this.table = table;
        this.runtime = runtime;
    }

    private void parseDataSource() {
        String table = this.getTableName();
        if (null != this.prepare) {
            table = this.prepare.getTableName();
        }
        if (!(table = table.replace(this.delimiterFr, "").replace(this.delimiterTo, "")).contains(".") && null != this.prepare && BasicUtil.isNotEmpty((Object)this.prepare.getSchema())) {
            this.schema = this.prepare.getSchema();
        }
    }

    @Override
    public void init() {
        super.init();
        this.parseDataSource();
        if (null != this.configs) {
            PageNavi navi;
            List orders;
            OrderStore orderStore;
            ConditionChain chain = this.configs.getConfigChain().createAutoConditionChain();
            if (null != chain) {
                this.addCondition(chain);
            }
            if (null != (orderStore = this.configs.getOrders()) && null != (orders = orderStore.getOrders())) {
                for (Order order : orders) {
                    this.orderStore.order(order);
                }
            }
            if ((navi = this.configs.getPageNavi()) != null) {
                this.pageNavi = navi;
            }
        }
    }

    public void appendOrderStore() {
    }

    public void appendGroup() {
        if (null != this.groupStore) {
            this.builder.append(this.groupStore.getRunText(this.delimiterFr + this.delimiterTo));
        }
        if (BasicUtil.isNotEmpty((Object)this.having)) {
            if (this.having.trim().toUpperCase().startsWith("HAVING")) {
                this.builder.append(this.having);
            } else {
                this.builder.append(" HAVING ").append(this.having);
            }
        }
    }

    @Override
    public boolean checkValid() {
        if (!this.valid) {
            return false;
        }
        if (null != this.conditionChain && !this.conditionChain.isValid()) {
            this.valid = false;
        }
        if (null != this.configs && !this.configs.isValid()) {
            this.valid = false;
        }
        return this.valid;
    }

    public void appendCondition(DriverAdapter adapter, boolean first, boolean placeholder) {
        String condition;
        if (null == this.conditionChain) {
            return;
        }
        String alias = null;
        if (null != this.prepare) {
            alias = this.prepare.getAlias();
        }
        if (!(condition = this.conditionChain.getRunText(alias, this.runtime, placeholder)).isEmpty()) {
            this.emptyCondition = false;
            if (first) {
                this.builder.append("\n").append(adapter.conditionHead()).append(" ");
                condition = condition.trim();
                String up = condition.toUpperCase();
                if (up.startsWith("AND ") || up.startsWith("AND(")) {
                    condition = condition.substring(3);
                } else if (up.startsWith("OR ") || up.startsWith("OR(")) {
                    condition = condition.substring(2);
                }
            }
            this.builder.append(condition);
        }
        List<RunValue> values = this.conditionChain.getRunValues();
        this.addValues(values);
    }

    public void setConfigs(ConfigStore configs) {
        this.configs = configs;
        if (null != configs) {
            this.pageNavi = configs.getPageNavi();
        }
    }

    @Override
    public Run setConditionValue(Compare.EMPTY_VALUE_SWITCH swt, Compare compare, String condition, String variable, Object value) {
        return this;
    }

    @Override
    public String getTableName() {
        if (null != this.table) {
            return this.table.getName();
        }
        return null;
    }

    @Override
    public String getCatalogName() {
        if (null != this.catalog) {
            return this.catalog.getName();
        }
        return null;
    }

    @Override
    public String getSchemaName() {
        if (null != this.schema) {
            return this.schema.getName();
        }
        return null;
    }
}

